// Compiled by ClojureScript 0.0-2816 {:target :nodejs}
goog.provide('clodexeddb.core');
goog.require('cljs.core');
cljs.core.load_file("ydn-db.js");
/**
* Defines a new database with a given schema. An optional ydn-db schema
* may be given, otherwise a default one will be provided. See here for more
* information: http://dev.yathit.com/ydn-db/doc/setup/schema.html
*/
clodexeddb.core.setup = (function() {
var setup = null;
var setup__1 = (function (name){
var schema = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"stores","stores",1203804823),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),"database",new cljs.core.Keyword(null,"keyPath","keyPath",-1845944323),"name",new cljs.core.Keyword(null,"indexes","indexes",1496475545),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keyPath","keyPath",-1845944323),"value",new cljs.core.Keyword(null,"type","type",1174270348),"TEXT"], null)], null)], null)], null)], null);
var s = cljs.core.clj__GT_js.call(null,schema);
return (new ydn.db.Storage(name,s));
});
var setup__2 = (function (name,schema){
var s = cljs.core.clj__GT_js.call(null,schema);
return (new ydn.db.Storage(name,s));
});
setup = function(name,schema){
switch(arguments.length){
case 1:
return setup__1.call(this,name);
case 2:
return setup__2.call(this,name,schema);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
setup.cljs$core$IFn$_invoke$arity$1 = setup__1;
setup.cljs$core$IFn$_invoke$arity$2 = setup__2;
return setup;
})()
;
/**
* Removes a database
*/
clodexeddb.core.rm_db = (function rm_db(db_name){
return ydn.db.deleteDatabase(db_name);
});
/**
* A funciton for adding an object to an ObjectStore.
* db -- the database defined with setup
* store -- the name of an ObjectStore
* value -- the value to add (as a clojure map, follows your schema)
*/
clodexeddb.core.add = (function add(db,store,value){
var obj = cljs.core.clj__GT_js.call(null,value);
return db.add(store,obj);
});
/**
* Removes an item from an ObjectStore
* db -- the database defined with setup
* store -- the name of an ObjectStore
* value -- the value to remove (as a string, primary key of your schema)
*/
clodexeddb.core.clear = (function clear(db,store,name){
return db.clear(store,ydn.db.KeyRange.only(name));
});
clodexeddb.core.key_range = (function (){var method_table__5999__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__6000__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__6001__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__6002__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__6003__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"clodexeddb.core","key-range"),((function (method_table__5999__auto__,prefer_table__6000__auto__,method_cache__6001__auto__,cached_hierarchy__6002__auto__,hierarchy__6003__auto__){
return (function() { 
var G__20843__delegate = function (call,args){
return call;
};
var G__20843 = function (call,var_args){
var args = null;
if (arguments.length > 1) {
var G__20844__i = 0, G__20844__a = new Array(arguments.length -  1);
while (G__20844__i < G__20844__a.length) {G__20844__a[G__20844__i] = arguments[G__20844__i + 1]; ++G__20844__i;}
  args = new cljs.core.IndexedSeq(G__20844__a,0);
} 
return G__20843__delegate.call(this,call,args);};
G__20843.cljs$lang$maxFixedArity = 1;
G__20843.cljs$lang$applyTo = (function (arglist__20845){
var call = cljs.core.first(arglist__20845);
var args = cljs.core.rest(arglist__20845);
return G__20843__delegate(call,args);
});
G__20843.cljs$core$IFn$_invoke$arity$variadic = G__20843__delegate;
return G__20843;
})()
;})(method_table__5999__auto__,prefer_table__6000__auto__,method_cache__6001__auto__,cached_hierarchy__6002__auto__,hierarchy__6003__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__6003__auto__,method_table__5999__auto__,prefer_table__6000__auto__,method_cache__6001__auto__,cached_hierarchy__6002__auto__));
})();
cljs.core._add_method.call(null,clodexeddb.core.key_range,new cljs.core.Keyword(null,"upper-bound","upper-bound",1562892816),(function (call,val,ceil){
return ydn.db.KeyRange.upperBound(val,(function (){var or__5102__auto__ = ceil;
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
return false;
}
})());
}));
cljs.core._add_method.call(null,clodexeddb.core.key_range,new cljs.core.Keyword(null,"lower-bound","lower-bound",153632489),(function (call,val,floor){
return ydn.db.KeyRange.lowerBound(val,(function (){var or__5102__auto__ = floor;
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
return false;
}
})());
}));
cljs.core._add_method.call(null,clodexeddb.core.key_range,new cljs.core.Keyword(null,"bound","bound",587617170),(function (call,val,floor,ceil){
return ydn.db.KeyRange.bound(val,(function (){var or__5102__auto__ = floor;
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
return false;
}
})(),(function (){var or__5102__auto__ = ceil;
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
return false;
}
})());
}));
cljs.core._add_method.call(null,clodexeddb.core.key_range,new cljs.core.Keyword(null,"only","only",1907811652),(function (call,val){
return ydn.db.KeyRange.only(val);
}));
cljs.core._add_method.call(null,clodexeddb.core.key_range,new cljs.core.Keyword(null,"starts","starts",-1501572425),(function (call,val){
return ydn.db.KeyRange.starts(val);
}));
/**
* Gets a value using an optional key range query. This works on indexes of an
* ObjectStore.
* db -- the database defined with setup
* store -- the name of an ObjectStore
* field -- an index of an ObjectStore
* k-range -- a key-range of the field to search in
* callback -- returns a JS callback with the results
* limit -- limit for results, defaults to 100
* offset -- offset for results, defaults to 0
*/
clodexeddb.core.value_query = (function() {
var value_query = null;
var value_query__3 = (function (db,store,callback){
return db.values(store).done(cljs.core.comp.call(null,callback,(function (p1__20846_SHARP_){
return cljs.core.js__GT_clj.call(null,p1__20846_SHARP_);
})));
});
var value_query__5 = (function (db,store,field,k_range,callback){
return db.values(store,field,k_range).done(cljs.core.comp.call(null,callback,(function (p1__20847_SHARP_){
return cljs.core.js__GT_clj.call(null,p1__20847_SHARP_);
})));
});
var value_query__6 = (function (db,store,field,k_range,callback,limit){
return db.values(store,field,k_range,limit).done(cljs.core.comp.call(null,callback,(function (p1__20848_SHARP_){
return cljs.core.js__GT_clj.call(null,p1__20848_SHARP_);
})));
});
var value_query__7 = (function (db,store,field,k_range,callback,limit,offset){
return db.values(store,field,k_range,limit,offset).done(cljs.core.comp.call(null,callback,(function (p1__20849_SHARP_){
return cljs.core.js__GT_clj.call(null,p1__20849_SHARP_);
})));
});
value_query = function(db,store,field,k_range,callback,limit,offset){
switch(arguments.length){
case 3:
return value_query__3.call(this,db,store,field);
case 5:
return value_query__5.call(this,db,store,field,k_range,callback);
case 6:
return value_query__6.call(this,db,store,field,k_range,callback,limit);
case 7:
return value_query__7.call(this,db,store,field,k_range,callback,limit,offset);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
value_query.cljs$core$IFn$_invoke$arity$3 = value_query__3;
value_query.cljs$core$IFn$_invoke$arity$5 = value_query__5;
value_query.cljs$core$IFn$_invoke$arity$6 = value_query__6;
value_query.cljs$core$IFn$_invoke$arity$7 = value_query__7;
return value_query;
})()
;
/**
* Retrieves an item from an ObjectStore.
* db -- the database defined with setup
* store -- the name of an ObjectStore
* val -- the primary key of an item in an ObjectStore
* callback -- returns a JS callback with results
*/
clodexeddb.core.get_query = (function get_query(db,store,val,callback){
return db.get(store,val).done(cljs.core.comp.call(null,callback,(function (p1__20850_SHARP_){
return cljs.core.js__GT_clj.call(null,p1__20850_SHARP_);
})));
});

//# sourceMappingURL=core.js.map