// Compiled by ClojureScript 0.0-2816 {:target :nodejs}
goog.provide('cljs.core.logic.pldb');
goog.require('cljs.core');
goog.require('cljs.core.logic');
cljs.core.logic.pldb.empty_db = cljs.core.PersistentArrayMap.EMPTY;
cljs.core.logic.pldb.facts_for = (function facts_for(dbs,kname){
return cljs.core.mapcat.call(null,(function (p1__20489_SHARP_){
return cljs.core.get_in.call(null,p1__20489_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [kname,new cljs.core.Keyword("cljs.core.logic.pldb","unindexed","cljs.core.logic.pldb/unindexed",849102433)], null));
}),dbs);
});
cljs.core.logic.pldb.facts_using_index = (function facts_using_index(dbs,kname,index,val){
return cljs.core.mapcat.call(null,(function (p1__20490_SHARP_){
return cljs.core.get_in.call(null,p1__20490_SHARP_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [kname,index,val], null));
}),dbs);
});
cljs.core.logic.pldb.rel_key = (function rel_key(rel){
if((rel instanceof cljs.core.Keyword)){
return rel;
} else {
return new cljs.core.Keyword(null,"rel-name","rel-name",-989189385).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,rel));
}
});
cljs.core.logic.pldb.rel_indexes = (function rel_indexes(rel){
return new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,rel));
});
cljs.core.logic.pldb.contains_lvar_QMARK_ = (function contains_lvar_QMARK_(x){
return cljs.core.some.call(null,cljs.core.logic.lvar_QMARK_,cljs.core.tree_seq.call(null,cljs.core.coll_QMARK_,cljs.core.seq,x));
});
cljs.core.logic.pldb.ground_QMARK_ = (function ground_QMARK_(s,term){
return cljs.core.not.call(null,cljs.core.logic.pldb.contains_lvar_QMARK_.call(null,cljs.core.logic._walk_STAR_.call(null,s,term)));
});
cljs.core.logic.pldb.index_for_query = (function index_for_query(s,q,indexes){
var indexable = cljs.core.map.call(null,(function (p1__20491_SHARP_){
return cljs.core.logic.pldb.ground_QMARK_.call(null,s,p1__20491_SHARP_);
}),q);
var triples = cljs.core.map.call(null,cljs.core.vector,cljs.core.range.call(null),indexable,indexes);
return cljs.core.first.call(null,(function (){var iter__5858__auto__ = ((function (indexable,triples){
return (function iter__20500(s__20501){
return (new cljs.core.LazySeq(null,((function (indexable,triples){
return (function (){
var s__20501__$1 = s__20501;
while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__20501__$1);
if(temp__4126__auto__){
var s__20501__$2 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20501__$2)){
var c__5856__auto__ = cljs.core.chunk_first.call(null,s__20501__$2);
var size__5857__auto__ = cljs.core.count.call(null,c__5856__auto__);
var b__20503 = cljs.core.chunk_buffer.call(null,size__5857__auto__);
if((function (){var i__20502 = (0);
while(true){
if((i__20502 < size__5857__auto__)){
var vec__20506 = cljs.core._nth.call(null,c__5856__auto__,i__20502);
var i = cljs.core.nth.call(null,vec__20506,(0),null);
var indexable__$1 = cljs.core.nth.call(null,vec__20506,(1),null);
var indexed = cljs.core.nth.call(null,vec__20506,(2),null);
if(cljs.core.truth_((function (){var and__5090__auto__ = indexable__$1;
if(cljs.core.truth_(and__5090__auto__)){
return indexed;
} else {
return and__5090__auto__;
}
})())){
cljs.core.chunk_append.call(null,b__20503,i);

var G__20508 = (i__20502 + (1));
i__20502 = G__20508;
continue;
} else {
var G__20509 = (i__20502 + (1));
i__20502 = G__20509;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20503),iter__20500.call(null,cljs.core.chunk_rest.call(null,s__20501__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20503),null);
}
} else {
var vec__20507 = cljs.core.first.call(null,s__20501__$2);
var i = cljs.core.nth.call(null,vec__20507,(0),null);
var indexable__$1 = cljs.core.nth.call(null,vec__20507,(1),null);
var indexed = cljs.core.nth.call(null,vec__20507,(2),null);
if(cljs.core.truth_((function (){var and__5090__auto__ = indexable__$1;
if(cljs.core.truth_(and__5090__auto__)){
return indexed;
} else {
return and__5090__auto__;
}
})())){
return cljs.core.cons.call(null,i,iter__20500.call(null,cljs.core.rest.call(null,s__20501__$2)));
} else {
var G__20510 = cljs.core.rest.call(null,s__20501__$2);
s__20501__$1 = G__20510;
continue;
}
}
} else {
return null;
}
break;
}
});})(indexable,triples))
,null,null));
});})(indexable,triples))
;
return iter__5858__auto__.call(null,triples);
})());
});
/**
* @param {...*} var_args
*/
cljs.core.logic.pldb.db_fact = (function() { 
var db_fact__delegate = function (db,rel,args){
var key = cljs.core.logic.pldb.rel_key.call(null,rel);
var add_to_set = ((function (key){
return (function (current,new$){
return cljs.core.conj.call(null,(function (){var or__5102__auto__ = current;
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})(),new$);
});})(key))
;
var db_with_fact = cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key,new cljs.core.Keyword("cljs.core.logic.pldb","unindexed","cljs.core.logic.pldb/unindexed",849102433)], null),((function (key,add_to_set){
return (function (p1__20511_SHARP_){
return add_to_set.call(null,p1__20511_SHARP_,args);
});})(key,add_to_set))
);
var indexes_to_update = cljs.core.map.call(null,cljs.core.vector,cljs.core.logic.pldb.rel_indexes.call(null,rel),cljs.core.range.call(null),args);
var update_index_fn = ((function (key,add_to_set,db_with_fact,indexes_to_update){
return (function (db__$1,p__20515){
var vec__20516 = p__20515;
var is_indexed = cljs.core.nth.call(null,vec__20516,(0),null);
var index_num = cljs.core.nth.call(null,vec__20516,(1),null);
var val = cljs.core.nth.call(null,vec__20516,(2),null);
if(cljs.core.truth_(is_indexed)){
return cljs.core.update_in.call(null,db__$1,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [key,index_num,val], null),((function (vec__20516,is_indexed,index_num,val,key,add_to_set,db_with_fact,indexes_to_update){
return (function (p1__20512_SHARP_){
return add_to_set.call(null,p1__20512_SHARP_,args);
});})(vec__20516,is_indexed,index_num,val,key,add_to_set,db_with_fact,indexes_to_update))
);
} else {
return db__$1;
}
});})(key,add_to_set,db_with_fact,indexes_to_update))
;
return cljs.core.reduce.call(null,update_index_fn,db_with_fact,indexes_to_update);
};
var db_fact = function (db,rel,var_args){
var args = null;
if (arguments.length > 2) {
var G__20517__i = 0, G__20517__a = new Array(arguments.length -  2);
while (G__20517__i < G__20517__a.length) {G__20517__a[G__20517__i] = arguments[G__20517__i + 2]; ++G__20517__i;}
  args = new cljs.core.IndexedSeq(G__20517__a,0);
} 
return db_fact__delegate.call(this,db,rel,args);};
db_fact.cljs$lang$maxFixedArity = 2;
db_fact.cljs$lang$applyTo = (function (arglist__20518){
var db = cljs.core.first(arglist__20518);
arglist__20518 = cljs.core.next(arglist__20518);
var rel = cljs.core.first(arglist__20518);
var args = cljs.core.rest(arglist__20518);
return db_fact__delegate(db,rel,args);
});
db_fact.cljs$core$IFn$_invoke$arity$variadic = db_fact__delegate;
return db_fact;
})()
;
/**
* @param {...*} var_args
*/
cljs.core.logic.pldb.db_retraction = (function() { 
var db_retraction__delegate = function (db,rel,args){
var key = cljs.core.logic.pldb.rel_key.call(null,rel);
var retract_args = ((function (key){
return (function (p1__20519_SHARP_){
return cljs.core.disj.call(null,p1__20519_SHARP_,args);
});})(key))
;
var db_without_fact = cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key,new cljs.core.Keyword("cljs.core.logic.pldb","unindexed","cljs.core.logic.pldb/unindexed",849102433)], null),retract_args);
var indexes_to_update = cljs.core.map.call(null,cljs.core.vector,cljs.core.logic.pldb.rel_indexes.call(null,rel),cljs.core.range.call(null),args);
var remove_from_index_fn = ((function (key,retract_args,db_without_fact,indexes_to_update){
return (function (db__$1,p__20522){
var vec__20523 = p__20522;
var is_indexed = cljs.core.nth.call(null,vec__20523,(0),null);
var index_num = cljs.core.nth.call(null,vec__20523,(1),null);
var val = cljs.core.nth.call(null,vec__20523,(2),null);
if(cljs.core.truth_(is_indexed)){
return cljs.core.update_in.call(null,db__$1,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [key,index_num,val], null),retract_args);
} else {
return db__$1;
}
});})(key,retract_args,db_without_fact,indexes_to_update))
;
return cljs.core.reduce.call(null,remove_from_index_fn,db_without_fact,indexes_to_update);
};
var db_retraction = function (db,rel,var_args){
var args = null;
if (arguments.length > 2) {
var G__20524__i = 0, G__20524__a = new Array(arguments.length -  2);
while (G__20524__i < G__20524__a.length) {G__20524__a[G__20524__i] = arguments[G__20524__i + 2]; ++G__20524__i;}
  args = new cljs.core.IndexedSeq(G__20524__a,0);
} 
return db_retraction__delegate.call(this,db,rel,args);};
db_retraction.cljs$lang$maxFixedArity = 2;
db_retraction.cljs$lang$applyTo = (function (arglist__20525){
var db = cljs.core.first(arglist__20525);
arglist__20525 = cljs.core.next(arglist__20525);
var rel = cljs.core.first(arglist__20525);
var args = cljs.core.rest(arglist__20525);
return db_retraction__delegate(db,rel,args);
});
db_retraction.cljs$core$IFn$_invoke$arity$variadic = db_retraction__delegate;
return db_retraction;
})()
;
/**
* @param {...*} var_args
*/
cljs.core.logic.pldb.db_facts = (function() { 
var db_facts__delegate = function (base_db,facts){
return cljs.core.reduce.call(null,(function (p1__20526_SHARP_,p2__20527_SHARP_){
return cljs.core.apply.call(null,cljs.core.logic.pldb.db_fact,p1__20526_SHARP_,p2__20527_SHARP_);
}),base_db,facts);
};
var db_facts = function (base_db,var_args){
var facts = null;
if (arguments.length > 1) {
var G__20528__i = 0, G__20528__a = new Array(arguments.length -  1);
while (G__20528__i < G__20528__a.length) {G__20528__a[G__20528__i] = arguments[G__20528__i + 1]; ++G__20528__i;}
  facts = new cljs.core.IndexedSeq(G__20528__a,0);
} 
return db_facts__delegate.call(this,base_db,facts);};
db_facts.cljs$lang$maxFixedArity = 1;
db_facts.cljs$lang$applyTo = (function (arglist__20529){
var base_db = cljs.core.first(arglist__20529);
var facts = cljs.core.rest(arglist__20529);
return db_facts__delegate(base_db,facts);
});
db_facts.cljs$core$IFn$_invoke$arity$variadic = db_facts__delegate;
return db_facts;
})()
;
/**
* @param {...*} var_args
*/
cljs.core.logic.pldb.db = (function() { 
var db__delegate = function (facts){
return cljs.core.apply.call(null,cljs.core.logic.pldb.db_facts,cljs.core.logic.pldb.empty_db,facts);
};
var db = function (var_args){
var facts = null;
if (arguments.length > 0) {
var G__20530__i = 0, G__20530__a = new Array(arguments.length -  0);
while (G__20530__i < G__20530__a.length) {G__20530__a[G__20530__i] = arguments[G__20530__i + 0]; ++G__20530__i;}
  facts = new cljs.core.IndexedSeq(G__20530__a,0);
} 
return db__delegate.call(this,facts);};
db.cljs$lang$maxFixedArity = 0;
db.cljs$lang$applyTo = (function (arglist__20531){
var facts = cljs.core.seq(arglist__20531);
return db__delegate(facts);
});
db.cljs$core$IFn$_invoke$arity$variadic = db__delegate;
return db;
})()
;
/**
* @param {...*} var_args
*/
cljs.core.logic.pldb.db_retractions = (function() { 
var db_retractions__delegate = function (base_db,retractions){
return cljs.core.reduce.call(null,(function (p1__20532_SHARP_,p2__20533_SHARP_){
return cljs.core.apply.call(null,cljs.core.logic.pldb.db_retraction,p1__20532_SHARP_,p2__20533_SHARP_);
}),base_db,retractions);
};
var db_retractions = function (base_db,var_args){
var retractions = null;
if (arguments.length > 1) {
var G__20534__i = 0, G__20534__a = new Array(arguments.length -  1);
while (G__20534__i < G__20534__a.length) {G__20534__a[G__20534__i] = arguments[G__20534__i + 1]; ++G__20534__i;}
  retractions = new cljs.core.IndexedSeq(G__20534__a,0);
} 
return db_retractions__delegate.call(this,base_db,retractions);};
db_retractions.cljs$lang$maxFixedArity = 1;
db_retractions.cljs$lang$applyTo = (function (arglist__20535){
var base_db = cljs.core.first(arglist__20535);
var retractions = cljs.core.rest(arglist__20535);
return db_retractions__delegate(base_db,retractions);
});
db_retractions.cljs$core$IFn$_invoke$arity$variadic = db_retractions__delegate;
return db_retractions;
})()
;

//# sourceMappingURL=pldb.js.map