// Compiled by ClojureScript 0.0-2816 {:target :nodejs}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function fn_handler(f){
if(typeof cljs.core.async.t17277 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t17277 = (function (f,fn_handler,meta17278){
this.f = f;
this.fn_handler = fn_handler;
this.meta17278 = meta17278;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t17277.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t17277.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t17277.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t17277.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17279){
var self__ = this;
var _17279__$1 = this;
return self__.meta17278;
});

cljs.core.async.t17277.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17279,meta17278__$1){
var self__ = this;
var _17279__$1 = this;
return (new cljs.core.async.t17277(self__.f,self__.fn_handler,meta17278__$1));
});

cljs.core.async.t17277.cljs$lang$type = true;

cljs.core.async.t17277.cljs$lang$ctorStr = "cljs.core.async/t17277";

cljs.core.async.t17277.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write.call(null,writer__5690__auto__,"cljs.core.async/t17277");
});

cljs.core.async.__GT_t17277 = (function __GT_t17277(f__$1,fn_handler__$1,meta17278){
return (new cljs.core.async.t17277(f__$1,fn_handler__$1,meta17278));
});

}

return (new cljs.core.async.t17277(f,fn_handler,cljs.core.PersistentArrayMap.EMPTY));
});
/**
* Returns a fixed buffer of size n. When full, puts will block/park.
*/
cljs.core.async.buffer = (function buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
* Returns a buffer of size n. When full, puts will complete but
* val will be dropped (no transfer).
*/
cljs.core.async.dropping_buffer = (function dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
* Returns a buffer of size n. When full, puts will complete, and be
* buffered, but oldest elements in buffer will be dropped (not
* transferred).
*/
cljs.core.async.sliding_buffer = (function sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
* Returns true if a channel created with buff will never block. That is to say,
* puts into this buffer will never cause the buffer to be full.
*/
cljs.core.async.unblocking_buffer_QMARK_ = (function unblocking_buffer_QMARK_(buff){
var G__17281 = buff;
if(G__17281){
var bit__5783__auto__ = null;
if(cljs.core.truth_((function (){var or__5102__auto__ = bit__5783__auto__;
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
return G__17281.cljs$core$async$impl$protocols$UnblockingBuffer$;
}
})())){
return true;
} else {
if((!G__17281.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__17281);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__17281);
}
});
/**
* Creates a channel with an optional buffer, an optional transducer (like (map f),
* (filter p) etc or a composition thereof), and an optional exception handler.
* If buf-or-n is a number, will create and use a fixed buffer of that size. If a
* transducer is supplied a buffer must be specified. ex-handler must be a
* fn of one argument - if an exception occurs during transformation it will be called
* with the thrown value as an argument, and any non-nil return value will be placed
* in the channel.
*/
cljs.core.async.chan = (function() {
var chan = null;
var chan__0 = (function (){
return chan.call(null,null);
});
var chan__1 = (function (buf_or_n){
return chan.call(null,buf_or_n,null,null);
});
var chan__2 = (function (buf_or_n,xform){
return chan.call(null,buf_or_n,xform,null);
});
var chan__3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});
chan = function(buf_or_n,xform,ex_handler){
switch(arguments.length){
case 0:
return chan__0.call(this);
case 1:
return chan__1.call(this,buf_or_n);
case 2:
return chan__2.call(this,buf_or_n,xform);
case 3:
return chan__3.call(this,buf_or_n,xform,ex_handler);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chan.cljs$core$IFn$_invoke$arity$0 = chan__0;
chan.cljs$core$IFn$_invoke$arity$1 = chan__1;
chan.cljs$core$IFn$_invoke$arity$2 = chan__2;
chan.cljs$core$IFn$_invoke$arity$3 = chan__3;
return chan;
})()
;
/**
* Returns a channel that will close after msecs
*/
cljs.core.async.timeout = (function timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
* takes a val from port. Must be called inside a (go ...) block. Will
* return nil if closed. Will park if nothing is available.
* Returns true unless port is already closed
*/
cljs.core.async._LT__BANG_ = (function _LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
* Asynchronously takes a val from port, passing to fn1. Will pass nil
* if closed. If on-caller? (default true) is true, and value is
* immediately available, will call fn1 on calling thread.
* Returns nil.
*/
cljs.core.async.take_BANG_ = (function() {
var take_BANG_ = null;
var take_BANG___2 = (function (port,fn1){
return take_BANG_.call(null,port,fn1,true);
});
var take_BANG___3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_17282 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_17282);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_17282,ret){
return (function (){
return fn1.call(null,val_17282);
});})(val_17282,ret))
);
}
} else {
}

return null;
});
take_BANG_ = function(port,fn1,on_caller_QMARK_){
switch(arguments.length){
case 2:
return take_BANG___2.call(this,port,fn1);
case 3:
return take_BANG___3.call(this,port,fn1,on_caller_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take_BANG_.cljs$core$IFn$_invoke$arity$2 = take_BANG___2;
take_BANG_.cljs$core$IFn$_invoke$arity$3 = take_BANG___3;
return take_BANG_;
})()
;
cljs.core.async.nop = (function nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
* puts a val into port. nil values are not allowed. Must be called
* inside a (go ...) block. Will park if no buffer space is available.
* Returns true unless port is already closed.
*/
cljs.core.async._GT__BANG_ = (function _GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
* Asynchronously puts a val into port, calling fn0 (if supplied) when
* complete. nil values are not allowed. Will throw if closed. If
* on-caller? (default true) is true, and the put is immediately
* accepted, will call fn0 on calling thread.  Returns nil.
*/
cljs.core.async.put_BANG_ = (function() {
var put_BANG_ = null;
var put_BANG___2 = (function (port,val){
var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4124__auto__)){
var ret = temp__4124__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});
var put_BANG___3 = (function (port,val,fn1){
return put_BANG_.call(null,port,val,fn1,true);
});
var put_BANG___4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4124__auto__)){
var retb = temp__4124__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4124__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4124__auto__))
);
}

return ret;
} else {
return true;
}
});
put_BANG_ = function(port,val,fn1,on_caller_QMARK_){
switch(arguments.length){
case 2:
return put_BANG___2.call(this,port,val);
case 3:
return put_BANG___3.call(this,port,val,fn1);
case 4:
return put_BANG___4.call(this,port,val,fn1,on_caller_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
put_BANG_.cljs$core$IFn$_invoke$arity$2 = put_BANG___2;
put_BANG_.cljs$core$IFn$_invoke$arity$3 = put_BANG___3;
put_BANG_.cljs$core$IFn$_invoke$arity$4 = put_BANG___4;
return put_BANG_;
})()
;
cljs.core.async.close_BANG_ = (function close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function random_array(n){
var a = (new Array(n));
var n__5989__auto___17283 = n;
var x_17284 = (0);
while(true){
if((x_17284 < n__5989__auto___17283)){
(a[x_17284] = (0));

var G__17285 = (x_17284 + (1));
x_17284 = G__17285;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__17286 = (i + (1));
i = G__17286;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t17290 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t17290 = (function (flag,alt_flag,meta17291){
this.flag = flag;
this.alt_flag = alt_flag;
this.meta17291 = meta17291;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t17290.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t17290.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t17290.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t17290.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_17292){
var self__ = this;
var _17292__$1 = this;
return self__.meta17291;
});})(flag))
;

cljs.core.async.t17290.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_17292,meta17291__$1){
var self__ = this;
var _17292__$1 = this;
return (new cljs.core.async.t17290(self__.flag,self__.alt_flag,meta17291__$1));
});})(flag))
;

cljs.core.async.t17290.cljs$lang$type = true;

cljs.core.async.t17290.cljs$lang$ctorStr = "cljs.core.async/t17290";

cljs.core.async.t17290.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write.call(null,writer__5690__auto__,"cljs.core.async/t17290");
});})(flag))
;

cljs.core.async.__GT_t17290 = ((function (flag){
return (function __GT_t17290(flag__$1,alt_flag__$1,meta17291){
return (new cljs.core.async.t17290(flag__$1,alt_flag__$1,meta17291));
});})(flag))
;

}

return (new cljs.core.async.t17290(flag,alt_flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function alt_handler(flag,cb){
if(typeof cljs.core.async.t17296 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t17296 = (function (cb,flag,alt_handler,meta17297){
this.cb = cb;
this.flag = flag;
this.alt_handler = alt_handler;
this.meta17297 = meta17297;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t17296.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t17296.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t17296.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t17296.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17298){
var self__ = this;
var _17298__$1 = this;
return self__.meta17297;
});

cljs.core.async.t17296.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17298,meta17297__$1){
var self__ = this;
var _17298__$1 = this;
return (new cljs.core.async.t17296(self__.cb,self__.flag,self__.alt_handler,meta17297__$1));
});

cljs.core.async.t17296.cljs$lang$type = true;

cljs.core.async.t17296.cljs$lang$ctorStr = "cljs.core.async/t17296";

cljs.core.async.t17296.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write.call(null,writer__5690__auto__,"cljs.core.async/t17296");
});

cljs.core.async.__GT_t17296 = (function __GT_t17296(cb__$1,flag__$1,alt_handler__$1,meta17297){
return (new cljs.core.async.t17296(cb__$1,flag__$1,alt_handler__$1,meta17297));
});

}

return (new cljs.core.async.t17296(cb,flag,alt_handler,cljs.core.PersistentArrayMap.EMPTY));
});
/**
* returns derefable [val port] if immediate, nil if enqueued
*/
cljs.core.async.do_alts = (function do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17299_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17299_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17300_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17300_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__5102__auto__ = wport;
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17301 = (i + (1));
i = G__17301;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5102__auto__ = ret;
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4126__auto__ = (function (){var and__5090__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__5090__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__5090__auto__;
}
})();
if(cljs.core.truth_(temp__4126__auto__)){
var got = temp__4126__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
* Completes at most one of several channel operations. Must be called
* inside a (go ...) block. ports is a vector of channel endpoints,
* which can be either a channel to take from or a vector of
* [channel-to-put-to val-to-put], in any combination. Takes will be
* made as if by <!, and puts will be made as if by >!. Unless
* the :priority option is true, if more than one port operation is
* ready a non-deterministic choice will be made. If no operation is
* ready and a :default value is supplied, [default-val :default] will
* be returned, otherwise alts! will park until the first operation to
* become ready completes. Returns [val port] of the completed
* operation, where val is the value taken for takes, and a
* boolean (true unless already closed, as per put!) for puts.
* 
* opts are passed as :key val ... Supported options:
* 
* :default val - the value to use if none of the operations are immediately ready
* :priority true - (default nil) when true, the operations will be tried in order.
* 
* Note: there is no guarantee that the port exps or val exprs will be
* used, nor in what order should they be, so they should not be
* depended upon for side effects.
* @param {...*} var_args
*/
cljs.core.async.alts_BANG_ = (function() { 
var alts_BANG___delegate = function (ports,p__17302){
var map__17304 = p__17302;
var map__17304__$1 = ((cljs.core.seq_QMARK_.call(null,map__17304))?cljs.core.apply.call(null,cljs.core.hash_map,map__17304):map__17304);
var opts = map__17304__$1;
throw (new Error("alts! used not in (go ...) block"));
};
var alts_BANG_ = function (ports,var_args){
var p__17302 = null;
if (arguments.length > 1) {
var G__17305__i = 0, G__17305__a = new Array(arguments.length -  1);
while (G__17305__i < G__17305__a.length) {G__17305__a[G__17305__i] = arguments[G__17305__i + 1]; ++G__17305__i;}
  p__17302 = new cljs.core.IndexedSeq(G__17305__a,0);
} 
return alts_BANG___delegate.call(this,ports,p__17302);};
alts_BANG_.cljs$lang$maxFixedArity = 1;
alts_BANG_.cljs$lang$applyTo = (function (arglist__17306){
var ports = cljs.core.first(arglist__17306);
var p__17302 = cljs.core.rest(arglist__17306);
return alts_BANG___delegate(ports,p__17302);
});
alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = alts_BANG___delegate;
return alts_BANG_;
})()
;
/**
* Takes elements from the from channel and supplies them to the to
* channel. By default, the to channel will be closed when the from
* channel closes, but can be determined by the close?  parameter. Will
* stop consuming the from channel if the to channel closes
*/
cljs.core.async.pipe = (function() {
var pipe = null;
var pipe__2 = (function (from,to){
return pipe.call(null,from,to,true);
});
var pipe__3 = (function (from,to,close_QMARK_){
var c__14050__auto___17401 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14050__auto___17401){
return (function (){
var f__14051__auto__ = (function (){var switch__13994__auto__ = ((function (c__14050__auto___17401){
return (function (state_17377){
var state_val_17378 = (state_17377[(1)]);
if((state_val_17378 === (7))){
var inst_17373 = (state_17377[(2)]);
var state_17377__$1 = state_17377;
var statearr_17379_17402 = state_17377__$1;
(statearr_17379_17402[(2)] = inst_17373);

(statearr_17379_17402[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17378 === (1))){
var state_17377__$1 = state_17377;
var statearr_17380_17403 = state_17377__$1;
(statearr_17380_17403[(2)] = null);

(statearr_17380_17403[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17378 === (4))){
var inst_17356 = (state_17377[(7)]);
var inst_17356__$1 = (state_17377[(2)]);
var inst_17357 = (inst_17356__$1 == null);
var state_17377__$1 = (function (){var statearr_17381 = state_17377;
(statearr_17381[(7)] = inst_17356__$1);

return statearr_17381;
})();
if(cljs.core.truth_(inst_17357)){
var statearr_17382_17404 = state_17377__$1;
(statearr_17382_17404[(1)] = (5));

} else {
var statearr_17383_17405 = state_17377__$1;
(statearr_17383_17405[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17378 === (13))){
var state_17377__$1 = state_17377;
var statearr_17384_17406 = state_17377__$1;
(statearr_17384_17406[(2)] = null);

(statearr_17384_17406[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17378 === (6))){
var inst_17356 = (state_17377[(7)]);
var state_17377__$1 = state_17377;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17377__$1,(11),to,inst_17356);
} else {
if((state_val_17378 === (3))){
var inst_17375 = (state_17377[(2)]);
var state_17377__$1 = state_17377;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17377__$1,inst_17375);
} else {
if((state_val_17378 === (12))){
var state_17377__$1 = state_17377;
var statearr_17385_17407 = state_17377__$1;
(statearr_17385_17407[(2)] = null);

(statearr_17385_17407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17378 === (2))){
var state_17377__$1 = state_17377;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17377__$1,(4),from);
} else {
if((state_val_17378 === (11))){
var inst_17366 = (state_17377[(2)]);
var state_17377__$1 = state_17377;
if(cljs.core.truth_(inst_17366)){
var statearr_17386_17408 = state_17377__$1;
(statearr_17386_17408[(1)] = (12));

} else {
var statearr_17387_17409 = state_17377__$1;
(statearr_17387_17409[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17378 === (9))){
var state_17377__$1 = state_17377;
var statearr_17388_17410 = state_17377__$1;
(statearr_17388_17410[(2)] = null);

(statearr_17388_17410[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17378 === (5))){
var state_17377__$1 = state_17377;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17389_17411 = state_17377__$1;
(statearr_17389_17411[(1)] = (8));

} else {
var statearr_17390_17412 = state_17377__$1;
(statearr_17390_17412[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17378 === (14))){
var inst_17371 = (state_17377[(2)]);
var state_17377__$1 = state_17377;
var statearr_17391_17413 = state_17377__$1;
(statearr_17391_17413[(2)] = inst_17371);

(statearr_17391_17413[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17378 === (10))){
var inst_17363 = (state_17377[(2)]);
var state_17377__$1 = state_17377;
var statearr_17392_17414 = state_17377__$1;
(statearr_17392_17414[(2)] = inst_17363);

(statearr_17392_17414[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17378 === (8))){
var inst_17360 = cljs.core.async.close_BANG_.call(null,to);
var state_17377__$1 = state_17377;
var statearr_17393_17415 = state_17377__$1;
(statearr_17393_17415[(2)] = inst_17360);

(statearr_17393_17415[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14050__auto___17401))
;
return ((function (switch__13994__auto__,c__14050__auto___17401){
return (function() {
var state_machine__13995__auto__ = null;
var state_machine__13995__auto____0 = (function (){
var statearr_17397 = [null,null,null,null,null,null,null,null];
(statearr_17397[(0)] = state_machine__13995__auto__);

(statearr_17397[(1)] = (1));

return statearr_17397;
});
var state_machine__13995__auto____1 = (function (state_17377){
while(true){
var ret_value__13996__auto__ = (function (){try{while(true){
var result__13997__auto__ = switch__13994__auto__.call(null,state_17377);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13997__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13997__auto__;
}
break;
}
}catch (e17398){if((e17398 instanceof Object)){
var ex__13998__auto__ = e17398;
var statearr_17399_17416 = state_17377;
(statearr_17399_17416[(5)] = ex__13998__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17377);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17398;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13996__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17417 = state_17377;
state_17377 = G__17417;
continue;
} else {
return ret_value__13996__auto__;
}
break;
}
});
state_machine__13995__auto__ = function(state_17377){
switch(arguments.length){
case 0:
return state_machine__13995__auto____0.call(this);
case 1:
return state_machine__13995__auto____1.call(this,state_17377);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__13995__auto____0;
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__13995__auto____1;
return state_machine__13995__auto__;
})()
;})(switch__13994__auto__,c__14050__auto___17401))
})();
var state__14052__auto__ = (function (){var statearr_17400 = f__14051__auto__.call(null);
(statearr_17400[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14050__auto___17401);

return statearr_17400;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14052__auto__);
});})(c__14050__auto___17401))
);


return to;
});
pipe = function(from,to,close_QMARK_){
switch(arguments.length){
case 2:
return pipe__2.call(this,from,to);
case 3:
return pipe__3.call(this,from,to,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pipe.cljs$core$IFn$_invoke$arity$2 = pipe__2;
pipe.cljs$core$IFn$_invoke$arity$3 = pipe__3;
return pipe;
})()
;
cljs.core.async.pipeline_STAR_ = (function pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__17601){
var vec__17602 = p__17601;
var v = cljs.core.nth.call(null,vec__17602,(0),null);
var p = cljs.core.nth.call(null,vec__17602,(1),null);
var job = vec__17602;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__14050__auto___17784 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14050__auto___17784,res,vec__17602,v,p,job,jobs,results){
return (function (){
var f__14051__auto__ = (function (){var switch__13994__auto__ = ((function (c__14050__auto___17784,res,vec__17602,v,p,job,jobs,results){
return (function (state_17607){
var state_val_17608 = (state_17607[(1)]);
if((state_val_17608 === (2))){
var inst_17604 = (state_17607[(2)]);
var inst_17605 = cljs.core.async.close_BANG_.call(null,res);
var state_17607__$1 = (function (){var statearr_17609 = state_17607;
(statearr_17609[(7)] = inst_17604);

return statearr_17609;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17607__$1,inst_17605);
} else {
if((state_val_17608 === (1))){
var state_17607__$1 = state_17607;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17607__$1,(2),res,v);
} else {
return null;
}
}
});})(c__14050__auto___17784,res,vec__17602,v,p,job,jobs,results))
;
return ((function (switch__13994__auto__,c__14050__auto___17784,res,vec__17602,v,p,job,jobs,results){
return (function() {
var state_machine__13995__auto__ = null;
var state_machine__13995__auto____0 = (function (){
var statearr_17613 = [null,null,null,null,null,null,null,null];
(statearr_17613[(0)] = state_machine__13995__auto__);

(statearr_17613[(1)] = (1));

return statearr_17613;
});
var state_machine__13995__auto____1 = (function (state_17607){
while(true){
var ret_value__13996__auto__ = (function (){try{while(true){
var result__13997__auto__ = switch__13994__auto__.call(null,state_17607);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13997__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13997__auto__;
}
break;
}
}catch (e17614){if((e17614 instanceof Object)){
var ex__13998__auto__ = e17614;
var statearr_17615_17785 = state_17607;
(statearr_17615_17785[(5)] = ex__13998__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17607);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17614;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13996__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17786 = state_17607;
state_17607 = G__17786;
continue;
} else {
return ret_value__13996__auto__;
}
break;
}
});
state_machine__13995__auto__ = function(state_17607){
switch(arguments.length){
case 0:
return state_machine__13995__auto____0.call(this);
case 1:
return state_machine__13995__auto____1.call(this,state_17607);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__13995__auto____0;
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__13995__auto____1;
return state_machine__13995__auto__;
})()
;})(switch__13994__auto__,c__14050__auto___17784,res,vec__17602,v,p,job,jobs,results))
})();
var state__14052__auto__ = (function (){var statearr_17616 = f__14051__auto__.call(null);
(statearr_17616[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14050__auto___17784);

return statearr_17616;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14052__auto__);
});})(c__14050__auto___17784,res,vec__17602,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17617){
var vec__17618 = p__17617;
var v = cljs.core.nth.call(null,vec__17618,(0),null);
var p = cljs.core.nth.call(null,vec__17618,(1),null);
var job = vec__17618;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5989__auto___17787 = n;
var __17788 = (0);
while(true){
if((__17788 < n__5989__auto___17787)){
var G__17619_17789 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__17619_17789) {
case "async":
var c__14050__auto___17791 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17788,c__14050__auto___17791,G__17619_17789,n__5989__auto___17787,jobs,results,process,async){
return (function (){
var f__14051__auto__ = (function (){var switch__13994__auto__ = ((function (__17788,c__14050__auto___17791,G__17619_17789,n__5989__auto___17787,jobs,results,process,async){
return (function (state_17632){
var state_val_17633 = (state_17632[(1)]);
if((state_val_17633 === (7))){
var inst_17628 = (state_17632[(2)]);
var state_17632__$1 = state_17632;
var statearr_17634_17792 = state_17632__$1;
(statearr_17634_17792[(2)] = inst_17628);

(statearr_17634_17792[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17633 === (6))){
var state_17632__$1 = state_17632;
var statearr_17635_17793 = state_17632__$1;
(statearr_17635_17793[(2)] = null);

(statearr_17635_17793[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17633 === (5))){
var state_17632__$1 = state_17632;
var statearr_17636_17794 = state_17632__$1;
(statearr_17636_17794[(2)] = null);

(statearr_17636_17794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17633 === (4))){
var inst_17622 = (state_17632[(2)]);
var inst_17623 = async.call(null,inst_17622);
var state_17632__$1 = state_17632;
if(cljs.core.truth_(inst_17623)){
var statearr_17637_17795 = state_17632__$1;
(statearr_17637_17795[(1)] = (5));

} else {
var statearr_17638_17796 = state_17632__$1;
(statearr_17638_17796[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17633 === (3))){
var inst_17630 = (state_17632[(2)]);
var state_17632__$1 = state_17632;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17632__$1,inst_17630);
} else {
if((state_val_17633 === (2))){
var state_17632__$1 = state_17632;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17632__$1,(4),jobs);
} else {
if((state_val_17633 === (1))){
var state_17632__$1 = state_17632;
var statearr_17639_17797 = state_17632__$1;
(statearr_17639_17797[(2)] = null);

(statearr_17639_17797[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17788,c__14050__auto___17791,G__17619_17789,n__5989__auto___17787,jobs,results,process,async))
;
return ((function (__17788,switch__13994__auto__,c__14050__auto___17791,G__17619_17789,n__5989__auto___17787,jobs,results,process,async){
return (function() {
var state_machine__13995__auto__ = null;
var state_machine__13995__auto____0 = (function (){
var statearr_17643 = [null,null,null,null,null,null,null];
(statearr_17643[(0)] = state_machine__13995__auto__);

(statearr_17643[(1)] = (1));

return statearr_17643;
});
var state_machine__13995__auto____1 = (function (state_17632){
while(true){
var ret_value__13996__auto__ = (function (){try{while(true){
var result__13997__auto__ = switch__13994__auto__.call(null,state_17632);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13997__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13997__auto__;
}
break;
}
}catch (e17644){if((e17644 instanceof Object)){
var ex__13998__auto__ = e17644;
var statearr_17645_17798 = state_17632;
(statearr_17645_17798[(5)] = ex__13998__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17632);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17644;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13996__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17799 = state_17632;
state_17632 = G__17799;
continue;
} else {
return ret_value__13996__auto__;
}
break;
}
});
state_machine__13995__auto__ = function(state_17632){
switch(arguments.length){
case 0:
return state_machine__13995__auto____0.call(this);
case 1:
return state_machine__13995__auto____1.call(this,state_17632);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__13995__auto____0;
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__13995__auto____1;
return state_machine__13995__auto__;
})()
;})(__17788,switch__13994__auto__,c__14050__auto___17791,G__17619_17789,n__5989__auto___17787,jobs,results,process,async))
})();
var state__14052__auto__ = (function (){var statearr_17646 = f__14051__auto__.call(null);
(statearr_17646[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14050__auto___17791);

return statearr_17646;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14052__auto__);
});})(__17788,c__14050__auto___17791,G__17619_17789,n__5989__auto___17787,jobs,results,process,async))
);


break;
case "compute":
var c__14050__auto___17800 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17788,c__14050__auto___17800,G__17619_17789,n__5989__auto___17787,jobs,results,process,async){
return (function (){
var f__14051__auto__ = (function (){var switch__13994__auto__ = ((function (__17788,c__14050__auto___17800,G__17619_17789,n__5989__auto___17787,jobs,results,process,async){
return (function (state_17659){
var state_val_17660 = (state_17659[(1)]);
if((state_val_17660 === (7))){
var inst_17655 = (state_17659[(2)]);
var state_17659__$1 = state_17659;
var statearr_17661_17801 = state_17659__$1;
(statearr_17661_17801[(2)] = inst_17655);

(statearr_17661_17801[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17660 === (6))){
var state_17659__$1 = state_17659;
var statearr_17662_17802 = state_17659__$1;
(statearr_17662_17802[(2)] = null);

(statearr_17662_17802[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17660 === (5))){
var state_17659__$1 = state_17659;
var statearr_17663_17803 = state_17659__$1;
(statearr_17663_17803[(2)] = null);

(statearr_17663_17803[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17660 === (4))){
var inst_17649 = (state_17659[(2)]);
var inst_17650 = process.call(null,inst_17649);
var state_17659__$1 = state_17659;
if(cljs.core.truth_(inst_17650)){
var statearr_17664_17804 = state_17659__$1;
(statearr_17664_17804[(1)] = (5));

} else {
var statearr_17665_17805 = state_17659__$1;
(statearr_17665_17805[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17660 === (3))){
var inst_17657 = (state_17659[(2)]);
var state_17659__$1 = state_17659;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17659__$1,inst_17657);
} else {
if((state_val_17660 === (2))){
var state_17659__$1 = state_17659;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17659__$1,(4),jobs);
} else {
if((state_val_17660 === (1))){
var state_17659__$1 = state_17659;
var statearr_17666_17806 = state_17659__$1;
(statearr_17666_17806[(2)] = null);

(statearr_17666_17806[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17788,c__14050__auto___17800,G__17619_17789,n__5989__auto___17787,jobs,results,process,async))
;
return ((function (__17788,switch__13994__auto__,c__14050__auto___17800,G__17619_17789,n__5989__auto___17787,jobs,results,process,async){
return (function() {
var state_machine__13995__auto__ = null;
var state_machine__13995__auto____0 = (function (){
var statearr_17670 = [null,null,null,null,null,null,null];
(statearr_17670[(0)] = state_machine__13995__auto__);

(statearr_17670[(1)] = (1));

return statearr_17670;
});
var state_machine__13995__auto____1 = (function (state_17659){
while(true){
var ret_value__13996__auto__ = (function (){try{while(true){
var result__13997__auto__ = switch__13994__auto__.call(null,state_17659);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13997__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13997__auto__;
}
break;
}
}catch (e17671){if((e17671 instanceof Object)){
var ex__13998__auto__ = e17671;
var statearr_17672_17807 = state_17659;
(statearr_17672_17807[(5)] = ex__13998__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17659);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17671;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13996__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17808 = state_17659;
state_17659 = G__17808;
continue;
} else {
return ret_value__13996__auto__;
}
break;
}
});
state_machine__13995__auto__ = function(state_17659){
switch(arguments.length){
case 0:
return state_machine__13995__auto____0.call(this);
case 1:
return state_machine__13995__auto____1.call(this,state_17659);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__13995__auto____0;
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__13995__auto____1;
return state_machine__13995__auto__;
})()
;})(__17788,switch__13994__auto__,c__14050__auto___17800,G__17619_17789,n__5989__auto___17787,jobs,results,process,async))
})();
var state__14052__auto__ = (function (){var statearr_17673 = f__14051__auto__.call(null);
(statearr_17673[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14050__auto___17800);

return statearr_17673;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14052__auto__);
});})(__17788,c__14050__auto___17800,G__17619_17789,n__5989__auto___17787,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__17809 = (__17788 + (1));
__17788 = G__17809;
continue;
} else {
}
break;
}

var c__14050__auto___17810 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14050__auto___17810,jobs,results,process,async){
return (function (){
var f__14051__auto__ = (function (){var switch__13994__auto__ = ((function (c__14050__auto___17810,jobs,results,process,async){
return (function (state_17695){
var state_val_17696 = (state_17695[(1)]);
if((state_val_17696 === (9))){
var inst_17688 = (state_17695[(2)]);
var state_17695__$1 = (function (){var statearr_17697 = state_17695;
(statearr_17697[(7)] = inst_17688);

return statearr_17697;
})();
var statearr_17698_17811 = state_17695__$1;
(statearr_17698_17811[(2)] = null);

(statearr_17698_17811[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17696 === (8))){
var inst_17681 = (state_17695[(8)]);
var inst_17686 = (state_17695[(2)]);
var state_17695__$1 = (function (){var statearr_17699 = state_17695;
(statearr_17699[(9)] = inst_17686);

return statearr_17699;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17695__$1,(9),results,inst_17681);
} else {
if((state_val_17696 === (7))){
var inst_17691 = (state_17695[(2)]);
var state_17695__$1 = state_17695;
var statearr_17700_17812 = state_17695__$1;
(statearr_17700_17812[(2)] = inst_17691);

(statearr_17700_17812[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17696 === (6))){
var inst_17681 = (state_17695[(8)]);
var inst_17676 = (state_17695[(10)]);
var inst_17681__$1 = cljs.core.async.chan.call(null,(1));
var inst_17682 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17683 = [inst_17676,inst_17681__$1];
var inst_17684 = (new cljs.core.PersistentVector(null,2,(5),inst_17682,inst_17683,null));
var state_17695__$1 = (function (){var statearr_17701 = state_17695;
(statearr_17701[(8)] = inst_17681__$1);

return statearr_17701;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17695__$1,(8),jobs,inst_17684);
} else {
if((state_val_17696 === (5))){
var inst_17679 = cljs.core.async.close_BANG_.call(null,jobs);
var state_17695__$1 = state_17695;
var statearr_17702_17813 = state_17695__$1;
(statearr_17702_17813[(2)] = inst_17679);

(statearr_17702_17813[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17696 === (4))){
var inst_17676 = (state_17695[(10)]);
var inst_17676__$1 = (state_17695[(2)]);
var inst_17677 = (inst_17676__$1 == null);
var state_17695__$1 = (function (){var statearr_17703 = state_17695;
(statearr_17703[(10)] = inst_17676__$1);

return statearr_17703;
})();
if(cljs.core.truth_(inst_17677)){
var statearr_17704_17814 = state_17695__$1;
(statearr_17704_17814[(1)] = (5));

} else {
var statearr_17705_17815 = state_17695__$1;
(statearr_17705_17815[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17696 === (3))){
var inst_17693 = (state_17695[(2)]);
var state_17695__$1 = state_17695;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17695__$1,inst_17693);
} else {
if((state_val_17696 === (2))){
var state_17695__$1 = state_17695;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17695__$1,(4),from);
} else {
if((state_val_17696 === (1))){
var state_17695__$1 = state_17695;
var statearr_17706_17816 = state_17695__$1;
(statearr_17706_17816[(2)] = null);

(statearr_17706_17816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__14050__auto___17810,jobs,results,process,async))
;
return ((function (switch__13994__auto__,c__14050__auto___17810,jobs,results,process,async){
return (function() {
var state_machine__13995__auto__ = null;
var state_machine__13995__auto____0 = (function (){
var statearr_17710 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17710[(0)] = state_machine__13995__auto__);

(statearr_17710[(1)] = (1));

return statearr_17710;
});
var state_machine__13995__auto____1 = (function (state_17695){
while(true){
var ret_value__13996__auto__ = (function (){try{while(true){
var result__13997__auto__ = switch__13994__auto__.call(null,state_17695);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13997__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13997__auto__;
}
break;
}
}catch (e17711){if((e17711 instanceof Object)){
var ex__13998__auto__ = e17711;
var statearr_17712_17817 = state_17695;
(statearr_17712_17817[(5)] = ex__13998__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17695);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17711;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13996__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17818 = state_17695;
state_17695 = G__17818;
continue;
} else {
return ret_value__13996__auto__;
}
break;
}
});
state_machine__13995__auto__ = function(state_17695){
switch(arguments.length){
case 0:
return state_machine__13995__auto____0.call(this);
case 1:
return state_machine__13995__auto____1.call(this,state_17695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__13995__auto____0;
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__13995__auto____1;
return state_machine__13995__auto__;
})()
;})(switch__13994__auto__,c__14050__auto___17810,jobs,results,process,async))
})();
var state__14052__auto__ = (function (){var statearr_17713 = f__14051__auto__.call(null);
(statearr_17713[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14050__auto___17810);

return statearr_17713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14052__auto__);
});})(c__14050__auto___17810,jobs,results,process,async))
);


var c__14050__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14050__auto__,jobs,results,process,async){
return (function (){
var f__14051__auto__ = (function (){var switch__13994__auto__ = ((function (c__14050__auto__,jobs,results,process,async){
return (function (state_17751){
var state_val_17752 = (state_17751[(1)]);
if((state_val_17752 === (7))){
var inst_17747 = (state_17751[(2)]);
var state_17751__$1 = state_17751;
var statearr_17753_17819 = state_17751__$1;
(statearr_17753_17819[(2)] = inst_17747);

(statearr_17753_17819[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17752 === (20))){
var state_17751__$1 = state_17751;
var statearr_17754_17820 = state_17751__$1;
(statearr_17754_17820[(2)] = null);

(statearr_17754_17820[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17752 === (1))){
var state_17751__$1 = state_17751;
var statearr_17755_17821 = state_17751__$1;
(statearr_17755_17821[(2)] = null);

(statearr_17755_17821[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17752 === (4))){
var inst_17716 = (state_17751[(7)]);
var inst_17716__$1 = (state_17751[(2)]);
var inst_17717 = (inst_17716__$1 == null);
var state_17751__$1 = (function (){var statearr_17756 = state_17751;
(statearr_17756[(7)] = inst_17716__$1);

return statearr_17756;
})();
if(cljs.core.truth_(inst_17717)){
var statearr_17757_17822 = state_17751__$1;
(statearr_17757_17822[(1)] = (5));

} else {
var statearr_17758_17823 = state_17751__$1;
(statearr_17758_17823[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17752 === (15))){
var inst_17729 = (state_17751[(8)]);
var state_17751__$1 = state_17751;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17751__$1,(18),to,inst_17729);
} else {
if((state_val_17752 === (21))){
var inst_17742 = (state_17751[(2)]);
var state_17751__$1 = state_17751;
var statearr_17759_17824 = state_17751__$1;
(statearr_17759_17824[(2)] = inst_17742);

(statearr_17759_17824[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17752 === (13))){
var inst_17744 = (state_17751[(2)]);
var state_17751__$1 = (function (){var statearr_17760 = state_17751;
(statearr_17760[(9)] = inst_17744);

return statearr_17760;
})();
var statearr_17761_17825 = state_17751__$1;
(statearr_17761_17825[(2)] = null);

(statearr_17761_17825[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17752 === (6))){
var inst_17716 = (state_17751[(7)]);
var state_17751__$1 = state_17751;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17751__$1,(11),inst_17716);
} else {
if((state_val_17752 === (17))){
var inst_17737 = (state_17751[(2)]);
var state_17751__$1 = state_17751;
if(cljs.core.truth_(inst_17737)){
var statearr_17762_17826 = state_17751__$1;
(statearr_17762_17826[(1)] = (19));

} else {
var statearr_17763_17827 = state_17751__$1;
(statearr_17763_17827[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17752 === (3))){
var inst_17749 = (state_17751[(2)]);
var state_17751__$1 = state_17751;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17751__$1,inst_17749);
} else {
if((state_val_17752 === (12))){
var inst_17726 = (state_17751[(10)]);
var state_17751__$1 = state_17751;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17751__$1,(14),inst_17726);
} else {
if((state_val_17752 === (2))){
var state_17751__$1 = state_17751;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17751__$1,(4),results);
} else {
if((state_val_17752 === (19))){
var state_17751__$1 = state_17751;
var statearr_17764_17828 = state_17751__$1;
(statearr_17764_17828[(2)] = null);

(statearr_17764_17828[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17752 === (11))){
var inst_17726 = (state_17751[(2)]);
var state_17751__$1 = (function (){var statearr_17765 = state_17751;
(statearr_17765[(10)] = inst_17726);

return statearr_17765;
})();
var statearr_17766_17829 = state_17751__$1;
(statearr_17766_17829[(2)] = null);

(statearr_17766_17829[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17752 === (9))){
var state_17751__$1 = state_17751;
var statearr_17767_17830 = state_17751__$1;
(statearr_17767_17830[(2)] = null);

(statearr_17767_17830[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17752 === (5))){
var state_17751__$1 = state_17751;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17768_17831 = state_17751__$1;
(statearr_17768_17831[(1)] = (8));

} else {
var statearr_17769_17832 = state_17751__$1;
(statearr_17769_17832[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17752 === (14))){
var inst_17729 = (state_17751[(8)]);
var inst_17731 = (state_17751[(11)]);
var inst_17729__$1 = (state_17751[(2)]);
var inst_17730 = (inst_17729__$1 == null);
var inst_17731__$1 = cljs.core.not.call(null,inst_17730);
var state_17751__$1 = (function (){var statearr_17770 = state_17751;
(statearr_17770[(8)] = inst_17729__$1);

(statearr_17770[(11)] = inst_17731__$1);

return statearr_17770;
})();
if(inst_17731__$1){
var statearr_17771_17833 = state_17751__$1;
(statearr_17771_17833[(1)] = (15));

} else {
var statearr_17772_17834 = state_17751__$1;
(statearr_17772_17834[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17752 === (16))){
var inst_17731 = (state_17751[(11)]);
var state_17751__$1 = state_17751;
var statearr_17773_17835 = state_17751__$1;
(statearr_17773_17835[(2)] = inst_17731);

(statearr_17773_17835[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17752 === (10))){
var inst_17723 = (state_17751[(2)]);
var state_17751__$1 = state_17751;
var statearr_17774_17836 = state_17751__$1;
(statearr_17774_17836[(2)] = inst_17723);

(statearr_17774_17836[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17752 === (18))){
var inst_17734 = (state_17751[(2)]);
var state_17751__$1 = state_17751;
var statearr_17775_17837 = state_17751__$1;
(statearr_17775_17837[(2)] = inst_17734);

(statearr_17775_17837[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17752 === (8))){
var inst_17720 = cljs.core.async.close_BANG_.call(null,to);
var state_17751__$1 = state_17751;
var statearr_17776_17838 = state_17751__$1;
(statearr_17776_17838[(2)] = inst_17720);

(statearr_17776_17838[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14050__auto__,jobs,results,process,async))
;
return ((function (switch__13994__auto__,c__14050__auto__,jobs,results,process,async){
return (function() {
var state_machine__13995__auto__ = null;
var state_machine__13995__auto____0 = (function (){
var statearr_17780 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17780[(0)] = state_machine__13995__auto__);

(statearr_17780[(1)] = (1));

return statearr_17780;
});
var state_machine__13995__auto____1 = (function (state_17751){
while(true){
var ret_value__13996__auto__ = (function (){try{while(true){
var result__13997__auto__ = switch__13994__auto__.call(null,state_17751);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13997__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13997__auto__;
}
break;
}
}catch (e17781){if((e17781 instanceof Object)){
var ex__13998__auto__ = e17781;
var statearr_17782_17839 = state_17751;
(statearr_17782_17839[(5)] = ex__13998__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17751);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17781;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13996__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17840 = state_17751;
state_17751 = G__17840;
continue;
} else {
return ret_value__13996__auto__;
}
break;
}
});
state_machine__13995__auto__ = function(state_17751){
switch(arguments.length){
case 0:
return state_machine__13995__auto____0.call(this);
case 1:
return state_machine__13995__auto____1.call(this,state_17751);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__13995__auto____0;
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__13995__auto____1;
return state_machine__13995__auto__;
})()
;})(switch__13994__auto__,c__14050__auto__,jobs,results,process,async))
})();
var state__14052__auto__ = (function (){var statearr_17783 = f__14051__auto__.call(null);
(statearr_17783[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14050__auto__);

return statearr_17783;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14052__auto__);
});})(c__14050__auto__,jobs,results,process,async))
);

return c__14050__auto__;
});
/**
* Takes elements from the from channel and supplies them to the to
* channel, subject to the async function af, with parallelism n. af
* must be a function of two arguments, the first an input value and
* the second a channel on which to place the result(s). af must close!
* the channel before returning.  The presumption is that af will
* return immediately, having launched some asynchronous operation
* whose completion/callback will manipulate the result channel. Outputs
* will be returned in order relative to  the inputs. By default, the to
* channel will be closed when the from channel closes, but can be
* determined by the close?  parameter. Will stop consuming the from
* channel if the to channel closes.
*/
cljs.core.async.pipeline_async = (function() {
var pipeline_async = null;
var pipeline_async__4 = (function (n,to,af,from){
return pipeline_async.call(null,n,to,af,from,true);
});
var pipeline_async__5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});
pipeline_async = function(n,to,af,from,close_QMARK_){
switch(arguments.length){
case 4:
return pipeline_async__4.call(this,n,to,af,from);
case 5:
return pipeline_async__5.call(this,n,to,af,from,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pipeline_async.cljs$core$IFn$_invoke$arity$4 = pipeline_async__4;
pipeline_async.cljs$core$IFn$_invoke$arity$5 = pipeline_async__5;
return pipeline_async;
})()
;
/**
* Takes elements from the from channel and supplies them to the to
* channel, subject to the transducer xf, with parallelism n. Because
* it is parallel, the transducer will be applied independently to each
* element, not across elements, and may produce zero or more outputs
* per input.  Outputs will be returned in order relative to the
* inputs. By default, the to channel will be closed when the from
* channel closes, but can be determined by the close?  parameter. Will
* stop consuming the from channel if the to channel closes.
* 
* Note this is supplied for API compatibility with the Clojure version.
* Values of N > 1 will not result in actual concurrency in a
* single-threaded runtime.
*/
cljs.core.async.pipeline = (function() {
var pipeline = null;
var pipeline__4 = (function (n,to,xf,from){
return pipeline.call(null,n,to,xf,from,true);
});
var pipeline__5 = (function (n,to,xf,from,close_QMARK_){
return pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});
var pipeline__6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});
pipeline = function(n,to,xf,from,close_QMARK_,ex_handler){
switch(arguments.length){
case 4:
return pipeline__4.call(this,n,to,xf,from);
case 5:
return pipeline__5.call(this,n,to,xf,from,close_QMARK_);
case 6:
return pipeline__6.call(this,n,to,xf,from,close_QMARK_,ex_handler);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pipeline.cljs$core$IFn$_invoke$arity$4 = pipeline__4;
pipeline.cljs$core$IFn$_invoke$arity$5 = pipeline__5;
pipeline.cljs$core$IFn$_invoke$arity$6 = pipeline__6;
return pipeline;
})()
;
/**
* Takes a predicate and a source channel and returns a vector of two
* channels, the first of which will contain the values for which the
* predicate returned true, the second those for which it returned
* false.
* 
* The out channels will be unbuffered by default, or two buf-or-ns can
* be supplied. The channels will close after the source channel has
* closed.
*/
cljs.core.async.split = (function() {
var split = null;
var split__2 = (function (p,ch){
return split.call(null,p,ch,null,null);
});
var split__4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__14050__auto___17941 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14050__auto___17941,tc,fc){
return (function (){
var f__14051__auto__ = (function (){var switch__13994__auto__ = ((function (c__14050__auto___17941,tc,fc){
return (function (state_17916){
var state_val_17917 = (state_17916[(1)]);
if((state_val_17917 === (7))){
var inst_17912 = (state_17916[(2)]);
var state_17916__$1 = state_17916;
var statearr_17918_17942 = state_17916__$1;
(statearr_17918_17942[(2)] = inst_17912);

(statearr_17918_17942[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17917 === (1))){
var state_17916__$1 = state_17916;
var statearr_17919_17943 = state_17916__$1;
(statearr_17919_17943[(2)] = null);

(statearr_17919_17943[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17917 === (4))){
var inst_17893 = (state_17916[(7)]);
var inst_17893__$1 = (state_17916[(2)]);
var inst_17894 = (inst_17893__$1 == null);
var state_17916__$1 = (function (){var statearr_17920 = state_17916;
(statearr_17920[(7)] = inst_17893__$1);

return statearr_17920;
})();
if(cljs.core.truth_(inst_17894)){
var statearr_17921_17944 = state_17916__$1;
(statearr_17921_17944[(1)] = (5));

} else {
var statearr_17922_17945 = state_17916__$1;
(statearr_17922_17945[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17917 === (13))){
var state_17916__$1 = state_17916;
var statearr_17923_17946 = state_17916__$1;
(statearr_17923_17946[(2)] = null);

(statearr_17923_17946[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17917 === (6))){
var inst_17893 = (state_17916[(7)]);
var inst_17899 = p.call(null,inst_17893);
var state_17916__$1 = state_17916;
if(cljs.core.truth_(inst_17899)){
var statearr_17924_17947 = state_17916__$1;
(statearr_17924_17947[(1)] = (9));

} else {
var statearr_17925_17948 = state_17916__$1;
(statearr_17925_17948[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17917 === (3))){
var inst_17914 = (state_17916[(2)]);
var state_17916__$1 = state_17916;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17916__$1,inst_17914);
} else {
if((state_val_17917 === (12))){
var state_17916__$1 = state_17916;
var statearr_17926_17949 = state_17916__$1;
(statearr_17926_17949[(2)] = null);

(statearr_17926_17949[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17917 === (2))){
var state_17916__$1 = state_17916;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17916__$1,(4),ch);
} else {
if((state_val_17917 === (11))){
var inst_17893 = (state_17916[(7)]);
var inst_17903 = (state_17916[(2)]);
var state_17916__$1 = state_17916;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17916__$1,(8),inst_17903,inst_17893);
} else {
if((state_val_17917 === (9))){
var state_17916__$1 = state_17916;
var statearr_17927_17950 = state_17916__$1;
(statearr_17927_17950[(2)] = tc);

(statearr_17927_17950[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17917 === (5))){
var inst_17896 = cljs.core.async.close_BANG_.call(null,tc);
var inst_17897 = cljs.core.async.close_BANG_.call(null,fc);
var state_17916__$1 = (function (){var statearr_17928 = state_17916;
(statearr_17928[(8)] = inst_17896);

return statearr_17928;
})();
var statearr_17929_17951 = state_17916__$1;
(statearr_17929_17951[(2)] = inst_17897);

(statearr_17929_17951[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17917 === (14))){
var inst_17910 = (state_17916[(2)]);
var state_17916__$1 = state_17916;
var statearr_17930_17952 = state_17916__$1;
(statearr_17930_17952[(2)] = inst_17910);

(statearr_17930_17952[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17917 === (10))){
var state_17916__$1 = state_17916;
var statearr_17931_17953 = state_17916__$1;
(statearr_17931_17953[(2)] = fc);

(statearr_17931_17953[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17917 === (8))){
var inst_17905 = (state_17916[(2)]);
var state_17916__$1 = state_17916;
if(cljs.core.truth_(inst_17905)){
var statearr_17932_17954 = state_17916__$1;
(statearr_17932_17954[(1)] = (12));

} else {
var statearr_17933_17955 = state_17916__$1;
(statearr_17933_17955[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14050__auto___17941,tc,fc))
;
return ((function (switch__13994__auto__,c__14050__auto___17941,tc,fc){
return (function() {
var state_machine__13995__auto__ = null;
var state_machine__13995__auto____0 = (function (){
var statearr_17937 = [null,null,null,null,null,null,null,null,null];
(statearr_17937[(0)] = state_machine__13995__auto__);

(statearr_17937[(1)] = (1));

return statearr_17937;
});
var state_machine__13995__auto____1 = (function (state_17916){
while(true){
var ret_value__13996__auto__ = (function (){try{while(true){
var result__13997__auto__ = switch__13994__auto__.call(null,state_17916);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13997__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13997__auto__;
}
break;
}
}catch (e17938){if((e17938 instanceof Object)){
var ex__13998__auto__ = e17938;
var statearr_17939_17956 = state_17916;
(statearr_17939_17956[(5)] = ex__13998__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17916);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17938;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13996__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17957 = state_17916;
state_17916 = G__17957;
continue;
} else {
return ret_value__13996__auto__;
}
break;
}
});
state_machine__13995__auto__ = function(state_17916){
switch(arguments.length){
case 0:
return state_machine__13995__auto____0.call(this);
case 1:
return state_machine__13995__auto____1.call(this,state_17916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__13995__auto____0;
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__13995__auto____1;
return state_machine__13995__auto__;
})()
;})(switch__13994__auto__,c__14050__auto___17941,tc,fc))
})();
var state__14052__auto__ = (function (){var statearr_17940 = f__14051__auto__.call(null);
(statearr_17940[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14050__auto___17941);

return statearr_17940;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14052__auto__);
});})(c__14050__auto___17941,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});
split = function(p,ch,t_buf_or_n,f_buf_or_n){
switch(arguments.length){
case 2:
return split__2.call(this,p,ch);
case 4:
return split__4.call(this,p,ch,t_buf_or_n,f_buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
split.cljs$core$IFn$_invoke$arity$2 = split__2;
split.cljs$core$IFn$_invoke$arity$4 = split__4;
return split;
})()
;
/**
* f should be a function of 2 arguments. Returns a channel containing
* the single result of applying f to init and the first item from the
* channel, then applying f to that result and the 2nd item, etc. If
* the channel closes without yielding items, returns init and f is not
* called. ch must close before reduce produces a result.
*/
cljs.core.async.reduce = (function reduce(f,init,ch){
var c__14050__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14050__auto__){
return (function (){
var f__14051__auto__ = (function (){var switch__13994__auto__ = ((function (c__14050__auto__){
return (function (state_18004){
var state_val_18005 = (state_18004[(1)]);
if((state_val_18005 === (7))){
var inst_18000 = (state_18004[(2)]);
var state_18004__$1 = state_18004;
var statearr_18006_18022 = state_18004__$1;
(statearr_18006_18022[(2)] = inst_18000);

(statearr_18006_18022[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18005 === (6))){
var inst_17990 = (state_18004[(7)]);
var inst_17993 = (state_18004[(8)]);
var inst_17997 = f.call(null,inst_17990,inst_17993);
var inst_17990__$1 = inst_17997;
var state_18004__$1 = (function (){var statearr_18007 = state_18004;
(statearr_18007[(7)] = inst_17990__$1);

return statearr_18007;
})();
var statearr_18008_18023 = state_18004__$1;
(statearr_18008_18023[(2)] = null);

(statearr_18008_18023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18005 === (5))){
var inst_17990 = (state_18004[(7)]);
var state_18004__$1 = state_18004;
var statearr_18009_18024 = state_18004__$1;
(statearr_18009_18024[(2)] = inst_17990);

(statearr_18009_18024[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18005 === (4))){
var inst_17993 = (state_18004[(8)]);
var inst_17993__$1 = (state_18004[(2)]);
var inst_17994 = (inst_17993__$1 == null);
var state_18004__$1 = (function (){var statearr_18010 = state_18004;
(statearr_18010[(8)] = inst_17993__$1);

return statearr_18010;
})();
if(cljs.core.truth_(inst_17994)){
var statearr_18011_18025 = state_18004__$1;
(statearr_18011_18025[(1)] = (5));

} else {
var statearr_18012_18026 = state_18004__$1;
(statearr_18012_18026[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18005 === (3))){
var inst_18002 = (state_18004[(2)]);
var state_18004__$1 = state_18004;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18004__$1,inst_18002);
} else {
if((state_val_18005 === (2))){
var state_18004__$1 = state_18004;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18004__$1,(4),ch);
} else {
if((state_val_18005 === (1))){
var inst_17990 = init;
var state_18004__$1 = (function (){var statearr_18013 = state_18004;
(statearr_18013[(7)] = inst_17990);

return statearr_18013;
})();
var statearr_18014_18027 = state_18004__$1;
(statearr_18014_18027[(2)] = null);

(statearr_18014_18027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__14050__auto__))
;
return ((function (switch__13994__auto__,c__14050__auto__){
return (function() {
var state_machine__13995__auto__ = null;
var state_machine__13995__auto____0 = (function (){
var statearr_18018 = [null,null,null,null,null,null,null,null,null];
(statearr_18018[(0)] = state_machine__13995__auto__);

(statearr_18018[(1)] = (1));

return statearr_18018;
});
var state_machine__13995__auto____1 = (function (state_18004){
while(true){
var ret_value__13996__auto__ = (function (){try{while(true){
var result__13997__auto__ = switch__13994__auto__.call(null,state_18004);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13997__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13997__auto__;
}
break;
}
}catch (e18019){if((e18019 instanceof Object)){
var ex__13998__auto__ = e18019;
var statearr_18020_18028 = state_18004;
(statearr_18020_18028[(5)] = ex__13998__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18004);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18019;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13996__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18029 = state_18004;
state_18004 = G__18029;
continue;
} else {
return ret_value__13996__auto__;
}
break;
}
});
state_machine__13995__auto__ = function(state_18004){
switch(arguments.length){
case 0:
return state_machine__13995__auto____0.call(this);
case 1:
return state_machine__13995__auto____1.call(this,state_18004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__13995__auto____0;
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__13995__auto____1;
return state_machine__13995__auto__;
})()
;})(switch__13994__auto__,c__14050__auto__))
})();
var state__14052__auto__ = (function (){var statearr_18021 = f__14051__auto__.call(null);
(statearr_18021[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14050__auto__);

return statearr_18021;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14052__auto__);
});})(c__14050__auto__))
);

return c__14050__auto__;
});
/**
* Puts the contents of coll into the supplied channel.
* 
* By default the channel will be closed after the items are copied,
* but can be determined by the close? parameter.
* 
* Returns a channel which will close after the items are copied.
*/
cljs.core.async.onto_chan = (function() {
var onto_chan = null;
var onto_chan__2 = (function (ch,coll){
return onto_chan.call(null,ch,coll,true);
});
var onto_chan__3 = (function (ch,coll,close_QMARK_){
var c__14050__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14050__auto__){
return (function (){
var f__14051__auto__ = (function (){var switch__13994__auto__ = ((function (c__14050__auto__){
return (function (state_18103){
var state_val_18104 = (state_18103[(1)]);
if((state_val_18104 === (7))){
var inst_18085 = (state_18103[(2)]);
var state_18103__$1 = state_18103;
var statearr_18105_18128 = state_18103__$1;
(statearr_18105_18128[(2)] = inst_18085);

(statearr_18105_18128[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18104 === (1))){
var inst_18079 = cljs.core.seq.call(null,coll);
var inst_18080 = inst_18079;
var state_18103__$1 = (function (){var statearr_18106 = state_18103;
(statearr_18106[(7)] = inst_18080);

return statearr_18106;
})();
var statearr_18107_18129 = state_18103__$1;
(statearr_18107_18129[(2)] = null);

(statearr_18107_18129[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18104 === (4))){
var inst_18080 = (state_18103[(7)]);
var inst_18083 = cljs.core.first.call(null,inst_18080);
var state_18103__$1 = state_18103;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18103__$1,(7),ch,inst_18083);
} else {
if((state_val_18104 === (13))){
var inst_18097 = (state_18103[(2)]);
var state_18103__$1 = state_18103;
var statearr_18108_18130 = state_18103__$1;
(statearr_18108_18130[(2)] = inst_18097);

(statearr_18108_18130[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18104 === (6))){
var inst_18088 = (state_18103[(2)]);
var state_18103__$1 = state_18103;
if(cljs.core.truth_(inst_18088)){
var statearr_18109_18131 = state_18103__$1;
(statearr_18109_18131[(1)] = (8));

} else {
var statearr_18110_18132 = state_18103__$1;
(statearr_18110_18132[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18104 === (3))){
var inst_18101 = (state_18103[(2)]);
var state_18103__$1 = state_18103;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18103__$1,inst_18101);
} else {
if((state_val_18104 === (12))){
var state_18103__$1 = state_18103;
var statearr_18111_18133 = state_18103__$1;
(statearr_18111_18133[(2)] = null);

(statearr_18111_18133[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18104 === (2))){
var inst_18080 = (state_18103[(7)]);
var state_18103__$1 = state_18103;
if(cljs.core.truth_(inst_18080)){
var statearr_18112_18134 = state_18103__$1;
(statearr_18112_18134[(1)] = (4));

} else {
var statearr_18113_18135 = state_18103__$1;
(statearr_18113_18135[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18104 === (11))){
var inst_18094 = cljs.core.async.close_BANG_.call(null,ch);
var state_18103__$1 = state_18103;
var statearr_18114_18136 = state_18103__$1;
(statearr_18114_18136[(2)] = inst_18094);

(statearr_18114_18136[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18104 === (9))){
var state_18103__$1 = state_18103;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18115_18137 = state_18103__$1;
(statearr_18115_18137[(1)] = (11));

} else {
var statearr_18116_18138 = state_18103__$1;
(statearr_18116_18138[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18104 === (5))){
var inst_18080 = (state_18103[(7)]);
var state_18103__$1 = state_18103;
var statearr_18117_18139 = state_18103__$1;
(statearr_18117_18139[(2)] = inst_18080);

(statearr_18117_18139[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18104 === (10))){
var inst_18099 = (state_18103[(2)]);
var state_18103__$1 = state_18103;
var statearr_18118_18140 = state_18103__$1;
(statearr_18118_18140[(2)] = inst_18099);

(statearr_18118_18140[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18104 === (8))){
var inst_18080 = (state_18103[(7)]);
var inst_18090 = cljs.core.next.call(null,inst_18080);
var inst_18080__$1 = inst_18090;
var state_18103__$1 = (function (){var statearr_18119 = state_18103;
(statearr_18119[(7)] = inst_18080__$1);

return statearr_18119;
})();
var statearr_18120_18141 = state_18103__$1;
(statearr_18120_18141[(2)] = null);

(statearr_18120_18141[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14050__auto__))
;
return ((function (switch__13994__auto__,c__14050__auto__){
return (function() {
var state_machine__13995__auto__ = null;
var state_machine__13995__auto____0 = (function (){
var statearr_18124 = [null,null,null,null,null,null,null,null];
(statearr_18124[(0)] = state_machine__13995__auto__);

(statearr_18124[(1)] = (1));

return statearr_18124;
});
var state_machine__13995__auto____1 = (function (state_18103){
while(true){
var ret_value__13996__auto__ = (function (){try{while(true){
var result__13997__auto__ = switch__13994__auto__.call(null,state_18103);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13997__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13997__auto__;
}
break;
}
}catch (e18125){if((e18125 instanceof Object)){
var ex__13998__auto__ = e18125;
var statearr_18126_18142 = state_18103;
(statearr_18126_18142[(5)] = ex__13998__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18103);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18125;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13996__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18143 = state_18103;
state_18103 = G__18143;
continue;
} else {
return ret_value__13996__auto__;
}
break;
}
});
state_machine__13995__auto__ = function(state_18103){
switch(arguments.length){
case 0:
return state_machine__13995__auto____0.call(this);
case 1:
return state_machine__13995__auto____1.call(this,state_18103);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__13995__auto____0;
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__13995__auto____1;
return state_machine__13995__auto__;
})()
;})(switch__13994__auto__,c__14050__auto__))
})();
var state__14052__auto__ = (function (){var statearr_18127 = f__14051__auto__.call(null);
(statearr_18127[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14050__auto__);

return statearr_18127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14052__auto__);
});})(c__14050__auto__))
);

return c__14050__auto__;
});
onto_chan = function(ch,coll,close_QMARK_){
switch(arguments.length){
case 2:
return onto_chan__2.call(this,ch,coll);
case 3:
return onto_chan__3.call(this,ch,coll,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
onto_chan.cljs$core$IFn$_invoke$arity$2 = onto_chan__2;
onto_chan.cljs$core$IFn$_invoke$arity$3 = onto_chan__3;
return onto_chan;
})()
;
/**
* Creates and returns a channel which contains the contents of coll,
* closing when exhausted.
*/
cljs.core.async.to_chan = (function to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

cljs.core.async.Mux = (function (){var obj18145 = {};
return obj18145;
})();

cljs.core.async.muxch_STAR_ = (function muxch_STAR_(_){
if((function (){var and__5090__auto__ = _;
if(and__5090__auto__){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1;
} else {
return and__5090__auto__;
}
})()){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5746__auto__ = (((_ == null))?null:_);
return (function (){var or__5102__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5746__auto__)]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
})().call(null,_);
}
});


cljs.core.async.Mult = (function (){var obj18147 = {};
return obj18147;
})();

cljs.core.async.tap_STAR_ = (function tap_STAR_(m,ch,close_QMARK_){
if((function (){var and__5090__auto__ = m;
if(and__5090__auto__){
return m.cljs$core$async$Mult$tap_STAR_$arity$3;
} else {
return and__5090__auto__;
}
})()){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5746__auto__ = (((m == null))?null:m);
return (function (){var or__5102__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5746__auto__)]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
})().call(null,m,ch,close_QMARK_);
}
});

cljs.core.async.untap_STAR_ = (function untap_STAR_(m,ch){
if((function (){var and__5090__auto__ = m;
if(and__5090__auto__){
return m.cljs$core$async$Mult$untap_STAR_$arity$2;
} else {
return and__5090__auto__;
}
})()){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5746__auto__ = (((m == null))?null:m);
return (function (){var or__5102__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5746__auto__)]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.untap_all_STAR_ = (function untap_all_STAR_(m){
if((function (){var and__5090__auto__ = m;
if(and__5090__auto__){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1;
} else {
return and__5090__auto__;
}
})()){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5746__auto__ = (((m == null))?null:m);
return (function (){var or__5102__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5746__auto__)]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
})().call(null,m);
}
});

/**
* Creates and returns a mult(iple) of the supplied channel. Channels
* containing copies of the channel can be created with 'tap', and
* detached with 'untap'.
* 
* Each item is distributed to all taps in parallel and synchronously,
* i.e. each tap must accept before the next item is distributed. Use
* buffering/windowing to prevent slow taps from holding up the mult.
* 
* Items received when there are no taps get dropped.
* 
* If a tap puts to a closed channel, it will be removed from the mult.
*/
cljs.core.async.mult = (function mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t18369 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t18369 = (function (cs,ch,mult,meta18370){
this.cs = cs;
this.ch = ch;
this.mult = mult;
this.meta18370 = meta18370;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t18369.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t18369.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t18369.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t18369.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t18369.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t18369.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t18369.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_18371){
var self__ = this;
var _18371__$1 = this;
return self__.meta18370;
});})(cs))
;

cljs.core.async.t18369.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_18371,meta18370__$1){
var self__ = this;
var _18371__$1 = this;
return (new cljs.core.async.t18369(self__.cs,self__.ch,self__.mult,meta18370__$1));
});})(cs))
;

cljs.core.async.t18369.cljs$lang$type = true;

cljs.core.async.t18369.cljs$lang$ctorStr = "cljs.core.async/t18369";

cljs.core.async.t18369.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write.call(null,writer__5690__auto__,"cljs.core.async/t18369");
});})(cs))
;

cljs.core.async.__GT_t18369 = ((function (cs){
return (function __GT_t18369(cs__$1,ch__$1,mult__$1,meta18370){
return (new cljs.core.async.t18369(cs__$1,ch__$1,mult__$1,meta18370));
});})(cs))
;

}

return (new cljs.core.async.t18369(cs,ch,mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__14050__auto___18590 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14050__auto___18590,cs,m,dchan,dctr,done){
return (function (){
var f__14051__auto__ = (function (){var switch__13994__auto__ = ((function (c__14050__auto___18590,cs,m,dchan,dctr,done){
return (function (state_18502){
var state_val_18503 = (state_18502[(1)]);
if((state_val_18503 === (7))){
var inst_18498 = (state_18502[(2)]);
var state_18502__$1 = state_18502;
var statearr_18504_18591 = state_18502__$1;
(statearr_18504_18591[(2)] = inst_18498);

(statearr_18504_18591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (20))){
var inst_18403 = (state_18502[(7)]);
var inst_18413 = cljs.core.first.call(null,inst_18403);
var inst_18414 = cljs.core.nth.call(null,inst_18413,(0),null);
var inst_18415 = cljs.core.nth.call(null,inst_18413,(1),null);
var state_18502__$1 = (function (){var statearr_18505 = state_18502;
(statearr_18505[(8)] = inst_18414);

return statearr_18505;
})();
if(cljs.core.truth_(inst_18415)){
var statearr_18506_18592 = state_18502__$1;
(statearr_18506_18592[(1)] = (22));

} else {
var statearr_18507_18593 = state_18502__$1;
(statearr_18507_18593[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (27))){
var inst_18445 = (state_18502[(9)]);
var inst_18443 = (state_18502[(10)]);
var inst_18450 = (state_18502[(11)]);
var inst_18374 = (state_18502[(12)]);
var inst_18450__$1 = cljs.core._nth.call(null,inst_18443,inst_18445);
var inst_18451 = cljs.core.async.put_BANG_.call(null,inst_18450__$1,inst_18374,done);
var state_18502__$1 = (function (){var statearr_18508 = state_18502;
(statearr_18508[(11)] = inst_18450__$1);

return statearr_18508;
})();
if(cljs.core.truth_(inst_18451)){
var statearr_18509_18594 = state_18502__$1;
(statearr_18509_18594[(1)] = (30));

} else {
var statearr_18510_18595 = state_18502__$1;
(statearr_18510_18595[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (1))){
var state_18502__$1 = state_18502;
var statearr_18511_18596 = state_18502__$1;
(statearr_18511_18596[(2)] = null);

(statearr_18511_18596[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (24))){
var inst_18403 = (state_18502[(7)]);
var inst_18420 = (state_18502[(2)]);
var inst_18421 = cljs.core.next.call(null,inst_18403);
var inst_18383 = inst_18421;
var inst_18384 = null;
var inst_18385 = (0);
var inst_18386 = (0);
var state_18502__$1 = (function (){var statearr_18512 = state_18502;
(statearr_18512[(13)] = inst_18386);

(statearr_18512[(14)] = inst_18420);

(statearr_18512[(15)] = inst_18383);

(statearr_18512[(16)] = inst_18385);

(statearr_18512[(17)] = inst_18384);

return statearr_18512;
})();
var statearr_18513_18597 = state_18502__$1;
(statearr_18513_18597[(2)] = null);

(statearr_18513_18597[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (39))){
var state_18502__$1 = state_18502;
var statearr_18517_18598 = state_18502__$1;
(statearr_18517_18598[(2)] = null);

(statearr_18517_18598[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (4))){
var inst_18374 = (state_18502[(12)]);
var inst_18374__$1 = (state_18502[(2)]);
var inst_18375 = (inst_18374__$1 == null);
var state_18502__$1 = (function (){var statearr_18518 = state_18502;
(statearr_18518[(12)] = inst_18374__$1);

return statearr_18518;
})();
if(cljs.core.truth_(inst_18375)){
var statearr_18519_18599 = state_18502__$1;
(statearr_18519_18599[(1)] = (5));

} else {
var statearr_18520_18600 = state_18502__$1;
(statearr_18520_18600[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (15))){
var inst_18386 = (state_18502[(13)]);
var inst_18383 = (state_18502[(15)]);
var inst_18385 = (state_18502[(16)]);
var inst_18384 = (state_18502[(17)]);
var inst_18399 = (state_18502[(2)]);
var inst_18400 = (inst_18386 + (1));
var tmp18514 = inst_18383;
var tmp18515 = inst_18385;
var tmp18516 = inst_18384;
var inst_18383__$1 = tmp18514;
var inst_18384__$1 = tmp18516;
var inst_18385__$1 = tmp18515;
var inst_18386__$1 = inst_18400;
var state_18502__$1 = (function (){var statearr_18521 = state_18502;
(statearr_18521[(13)] = inst_18386__$1);

(statearr_18521[(15)] = inst_18383__$1);

(statearr_18521[(16)] = inst_18385__$1);

(statearr_18521[(18)] = inst_18399);

(statearr_18521[(17)] = inst_18384__$1);

return statearr_18521;
})();
var statearr_18522_18601 = state_18502__$1;
(statearr_18522_18601[(2)] = null);

(statearr_18522_18601[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (21))){
var inst_18424 = (state_18502[(2)]);
var state_18502__$1 = state_18502;
var statearr_18526_18602 = state_18502__$1;
(statearr_18526_18602[(2)] = inst_18424);

(statearr_18526_18602[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (31))){
var inst_18450 = (state_18502[(11)]);
var inst_18454 = done.call(null,null);
var inst_18455 = cljs.core.async.untap_STAR_.call(null,m,inst_18450);
var state_18502__$1 = (function (){var statearr_18527 = state_18502;
(statearr_18527[(19)] = inst_18454);

return statearr_18527;
})();
var statearr_18528_18603 = state_18502__$1;
(statearr_18528_18603[(2)] = inst_18455);

(statearr_18528_18603[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (32))){
var inst_18445 = (state_18502[(9)]);
var inst_18443 = (state_18502[(10)]);
var inst_18444 = (state_18502[(20)]);
var inst_18442 = (state_18502[(21)]);
var inst_18457 = (state_18502[(2)]);
var inst_18458 = (inst_18445 + (1));
var tmp18523 = inst_18443;
var tmp18524 = inst_18444;
var tmp18525 = inst_18442;
var inst_18442__$1 = tmp18525;
var inst_18443__$1 = tmp18523;
var inst_18444__$1 = tmp18524;
var inst_18445__$1 = inst_18458;
var state_18502__$1 = (function (){var statearr_18529 = state_18502;
(statearr_18529[(9)] = inst_18445__$1);

(statearr_18529[(10)] = inst_18443__$1);

(statearr_18529[(20)] = inst_18444__$1);

(statearr_18529[(21)] = inst_18442__$1);

(statearr_18529[(22)] = inst_18457);

return statearr_18529;
})();
var statearr_18530_18604 = state_18502__$1;
(statearr_18530_18604[(2)] = null);

(statearr_18530_18604[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (40))){
var inst_18470 = (state_18502[(23)]);
var inst_18474 = done.call(null,null);
var inst_18475 = cljs.core.async.untap_STAR_.call(null,m,inst_18470);
var state_18502__$1 = (function (){var statearr_18531 = state_18502;
(statearr_18531[(24)] = inst_18474);

return statearr_18531;
})();
var statearr_18532_18605 = state_18502__$1;
(statearr_18532_18605[(2)] = inst_18475);

(statearr_18532_18605[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (33))){
var inst_18461 = (state_18502[(25)]);
var inst_18463 = cljs.core.chunked_seq_QMARK_.call(null,inst_18461);
var state_18502__$1 = state_18502;
if(inst_18463){
var statearr_18533_18606 = state_18502__$1;
(statearr_18533_18606[(1)] = (36));

} else {
var statearr_18534_18607 = state_18502__$1;
(statearr_18534_18607[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (13))){
var inst_18393 = (state_18502[(26)]);
var inst_18396 = cljs.core.async.close_BANG_.call(null,inst_18393);
var state_18502__$1 = state_18502;
var statearr_18535_18608 = state_18502__$1;
(statearr_18535_18608[(2)] = inst_18396);

(statearr_18535_18608[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (22))){
var inst_18414 = (state_18502[(8)]);
var inst_18417 = cljs.core.async.close_BANG_.call(null,inst_18414);
var state_18502__$1 = state_18502;
var statearr_18536_18609 = state_18502__$1;
(statearr_18536_18609[(2)] = inst_18417);

(statearr_18536_18609[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (36))){
var inst_18461 = (state_18502[(25)]);
var inst_18465 = cljs.core.chunk_first.call(null,inst_18461);
var inst_18466 = cljs.core.chunk_rest.call(null,inst_18461);
var inst_18467 = cljs.core.count.call(null,inst_18465);
var inst_18442 = inst_18466;
var inst_18443 = inst_18465;
var inst_18444 = inst_18467;
var inst_18445 = (0);
var state_18502__$1 = (function (){var statearr_18537 = state_18502;
(statearr_18537[(9)] = inst_18445);

(statearr_18537[(10)] = inst_18443);

(statearr_18537[(20)] = inst_18444);

(statearr_18537[(21)] = inst_18442);

return statearr_18537;
})();
var statearr_18538_18610 = state_18502__$1;
(statearr_18538_18610[(2)] = null);

(statearr_18538_18610[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (41))){
var inst_18461 = (state_18502[(25)]);
var inst_18477 = (state_18502[(2)]);
var inst_18478 = cljs.core.next.call(null,inst_18461);
var inst_18442 = inst_18478;
var inst_18443 = null;
var inst_18444 = (0);
var inst_18445 = (0);
var state_18502__$1 = (function (){var statearr_18539 = state_18502;
(statearr_18539[(27)] = inst_18477);

(statearr_18539[(9)] = inst_18445);

(statearr_18539[(10)] = inst_18443);

(statearr_18539[(20)] = inst_18444);

(statearr_18539[(21)] = inst_18442);

return statearr_18539;
})();
var statearr_18540_18611 = state_18502__$1;
(statearr_18540_18611[(2)] = null);

(statearr_18540_18611[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (43))){
var state_18502__$1 = state_18502;
var statearr_18541_18612 = state_18502__$1;
(statearr_18541_18612[(2)] = null);

(statearr_18541_18612[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (29))){
var inst_18486 = (state_18502[(2)]);
var state_18502__$1 = state_18502;
var statearr_18542_18613 = state_18502__$1;
(statearr_18542_18613[(2)] = inst_18486);

(statearr_18542_18613[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (44))){
var inst_18495 = (state_18502[(2)]);
var state_18502__$1 = (function (){var statearr_18543 = state_18502;
(statearr_18543[(28)] = inst_18495);

return statearr_18543;
})();
var statearr_18544_18614 = state_18502__$1;
(statearr_18544_18614[(2)] = null);

(statearr_18544_18614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (6))){
var inst_18434 = (state_18502[(29)]);
var inst_18433 = cljs.core.deref.call(null,cs);
var inst_18434__$1 = cljs.core.keys.call(null,inst_18433);
var inst_18435 = cljs.core.count.call(null,inst_18434__$1);
var inst_18436 = cljs.core.reset_BANG_.call(null,dctr,inst_18435);
var inst_18441 = cljs.core.seq.call(null,inst_18434__$1);
var inst_18442 = inst_18441;
var inst_18443 = null;
var inst_18444 = (0);
var inst_18445 = (0);
var state_18502__$1 = (function (){var statearr_18545 = state_18502;
(statearr_18545[(29)] = inst_18434__$1);

(statearr_18545[(30)] = inst_18436);

(statearr_18545[(9)] = inst_18445);

(statearr_18545[(10)] = inst_18443);

(statearr_18545[(20)] = inst_18444);

(statearr_18545[(21)] = inst_18442);

return statearr_18545;
})();
var statearr_18546_18615 = state_18502__$1;
(statearr_18546_18615[(2)] = null);

(statearr_18546_18615[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (28))){
var inst_18461 = (state_18502[(25)]);
var inst_18442 = (state_18502[(21)]);
var inst_18461__$1 = cljs.core.seq.call(null,inst_18442);
var state_18502__$1 = (function (){var statearr_18547 = state_18502;
(statearr_18547[(25)] = inst_18461__$1);

return statearr_18547;
})();
if(inst_18461__$1){
var statearr_18548_18616 = state_18502__$1;
(statearr_18548_18616[(1)] = (33));

} else {
var statearr_18549_18617 = state_18502__$1;
(statearr_18549_18617[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (25))){
var inst_18445 = (state_18502[(9)]);
var inst_18444 = (state_18502[(20)]);
var inst_18447 = (inst_18445 < inst_18444);
var inst_18448 = inst_18447;
var state_18502__$1 = state_18502;
if(cljs.core.truth_(inst_18448)){
var statearr_18550_18618 = state_18502__$1;
(statearr_18550_18618[(1)] = (27));

} else {
var statearr_18551_18619 = state_18502__$1;
(statearr_18551_18619[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (34))){
var state_18502__$1 = state_18502;
var statearr_18552_18620 = state_18502__$1;
(statearr_18552_18620[(2)] = null);

(statearr_18552_18620[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (17))){
var state_18502__$1 = state_18502;
var statearr_18553_18621 = state_18502__$1;
(statearr_18553_18621[(2)] = null);

(statearr_18553_18621[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (3))){
var inst_18500 = (state_18502[(2)]);
var state_18502__$1 = state_18502;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18502__$1,inst_18500);
} else {
if((state_val_18503 === (12))){
var inst_18429 = (state_18502[(2)]);
var state_18502__$1 = state_18502;
var statearr_18554_18622 = state_18502__$1;
(statearr_18554_18622[(2)] = inst_18429);

(statearr_18554_18622[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (2))){
var state_18502__$1 = state_18502;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18502__$1,(4),ch);
} else {
if((state_val_18503 === (23))){
var state_18502__$1 = state_18502;
var statearr_18555_18623 = state_18502__$1;
(statearr_18555_18623[(2)] = null);

(statearr_18555_18623[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (35))){
var inst_18484 = (state_18502[(2)]);
var state_18502__$1 = state_18502;
var statearr_18556_18624 = state_18502__$1;
(statearr_18556_18624[(2)] = inst_18484);

(statearr_18556_18624[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (19))){
var inst_18403 = (state_18502[(7)]);
var inst_18407 = cljs.core.chunk_first.call(null,inst_18403);
var inst_18408 = cljs.core.chunk_rest.call(null,inst_18403);
var inst_18409 = cljs.core.count.call(null,inst_18407);
var inst_18383 = inst_18408;
var inst_18384 = inst_18407;
var inst_18385 = inst_18409;
var inst_18386 = (0);
var state_18502__$1 = (function (){var statearr_18557 = state_18502;
(statearr_18557[(13)] = inst_18386);

(statearr_18557[(15)] = inst_18383);

(statearr_18557[(16)] = inst_18385);

(statearr_18557[(17)] = inst_18384);

return statearr_18557;
})();
var statearr_18558_18625 = state_18502__$1;
(statearr_18558_18625[(2)] = null);

(statearr_18558_18625[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (11))){
var inst_18403 = (state_18502[(7)]);
var inst_18383 = (state_18502[(15)]);
var inst_18403__$1 = cljs.core.seq.call(null,inst_18383);
var state_18502__$1 = (function (){var statearr_18559 = state_18502;
(statearr_18559[(7)] = inst_18403__$1);

return statearr_18559;
})();
if(inst_18403__$1){
var statearr_18560_18626 = state_18502__$1;
(statearr_18560_18626[(1)] = (16));

} else {
var statearr_18561_18627 = state_18502__$1;
(statearr_18561_18627[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (9))){
var inst_18431 = (state_18502[(2)]);
var state_18502__$1 = state_18502;
var statearr_18562_18628 = state_18502__$1;
(statearr_18562_18628[(2)] = inst_18431);

(statearr_18562_18628[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (5))){
var inst_18381 = cljs.core.deref.call(null,cs);
var inst_18382 = cljs.core.seq.call(null,inst_18381);
var inst_18383 = inst_18382;
var inst_18384 = null;
var inst_18385 = (0);
var inst_18386 = (0);
var state_18502__$1 = (function (){var statearr_18563 = state_18502;
(statearr_18563[(13)] = inst_18386);

(statearr_18563[(15)] = inst_18383);

(statearr_18563[(16)] = inst_18385);

(statearr_18563[(17)] = inst_18384);

return statearr_18563;
})();
var statearr_18564_18629 = state_18502__$1;
(statearr_18564_18629[(2)] = null);

(statearr_18564_18629[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (14))){
var state_18502__$1 = state_18502;
var statearr_18565_18630 = state_18502__$1;
(statearr_18565_18630[(2)] = null);

(statearr_18565_18630[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (45))){
var inst_18492 = (state_18502[(2)]);
var state_18502__$1 = state_18502;
var statearr_18566_18631 = state_18502__$1;
(statearr_18566_18631[(2)] = inst_18492);

(statearr_18566_18631[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (26))){
var inst_18434 = (state_18502[(29)]);
var inst_18488 = (state_18502[(2)]);
var inst_18489 = cljs.core.seq.call(null,inst_18434);
var state_18502__$1 = (function (){var statearr_18567 = state_18502;
(statearr_18567[(31)] = inst_18488);

return statearr_18567;
})();
if(inst_18489){
var statearr_18568_18632 = state_18502__$1;
(statearr_18568_18632[(1)] = (42));

} else {
var statearr_18569_18633 = state_18502__$1;
(statearr_18569_18633[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (16))){
var inst_18403 = (state_18502[(7)]);
var inst_18405 = cljs.core.chunked_seq_QMARK_.call(null,inst_18403);
var state_18502__$1 = state_18502;
if(inst_18405){
var statearr_18570_18634 = state_18502__$1;
(statearr_18570_18634[(1)] = (19));

} else {
var statearr_18571_18635 = state_18502__$1;
(statearr_18571_18635[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (38))){
var inst_18481 = (state_18502[(2)]);
var state_18502__$1 = state_18502;
var statearr_18572_18636 = state_18502__$1;
(statearr_18572_18636[(2)] = inst_18481);

(statearr_18572_18636[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (30))){
var state_18502__$1 = state_18502;
var statearr_18573_18637 = state_18502__$1;
(statearr_18573_18637[(2)] = null);

(statearr_18573_18637[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (10))){
var inst_18386 = (state_18502[(13)]);
var inst_18384 = (state_18502[(17)]);
var inst_18392 = cljs.core._nth.call(null,inst_18384,inst_18386);
var inst_18393 = cljs.core.nth.call(null,inst_18392,(0),null);
var inst_18394 = cljs.core.nth.call(null,inst_18392,(1),null);
var state_18502__$1 = (function (){var statearr_18574 = state_18502;
(statearr_18574[(26)] = inst_18393);

return statearr_18574;
})();
if(cljs.core.truth_(inst_18394)){
var statearr_18575_18638 = state_18502__$1;
(statearr_18575_18638[(1)] = (13));

} else {
var statearr_18576_18639 = state_18502__$1;
(statearr_18576_18639[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (18))){
var inst_18427 = (state_18502[(2)]);
var state_18502__$1 = state_18502;
var statearr_18577_18640 = state_18502__$1;
(statearr_18577_18640[(2)] = inst_18427);

(statearr_18577_18640[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (42))){
var state_18502__$1 = state_18502;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18502__$1,(45),dchan);
} else {
if((state_val_18503 === (37))){
var inst_18461 = (state_18502[(25)]);
var inst_18374 = (state_18502[(12)]);
var inst_18470 = (state_18502[(23)]);
var inst_18470__$1 = cljs.core.first.call(null,inst_18461);
var inst_18471 = cljs.core.async.put_BANG_.call(null,inst_18470__$1,inst_18374,done);
var state_18502__$1 = (function (){var statearr_18578 = state_18502;
(statearr_18578[(23)] = inst_18470__$1);

return statearr_18578;
})();
if(cljs.core.truth_(inst_18471)){
var statearr_18579_18641 = state_18502__$1;
(statearr_18579_18641[(1)] = (39));

} else {
var statearr_18580_18642 = state_18502__$1;
(statearr_18580_18642[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18503 === (8))){
var inst_18386 = (state_18502[(13)]);
var inst_18385 = (state_18502[(16)]);
var inst_18388 = (inst_18386 < inst_18385);
var inst_18389 = inst_18388;
var state_18502__$1 = state_18502;
if(cljs.core.truth_(inst_18389)){
var statearr_18581_18643 = state_18502__$1;
(statearr_18581_18643[(1)] = (10));

} else {
var statearr_18582_18644 = state_18502__$1;
(statearr_18582_18644[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14050__auto___18590,cs,m,dchan,dctr,done))
;
return ((function (switch__13994__auto__,c__14050__auto___18590,cs,m,dchan,dctr,done){
return (function() {
var state_machine__13995__auto__ = null;
var state_machine__13995__auto____0 = (function (){
var statearr_18586 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18586[(0)] = state_machine__13995__auto__);

(statearr_18586[(1)] = (1));

return statearr_18586;
});
var state_machine__13995__auto____1 = (function (state_18502){
while(true){
var ret_value__13996__auto__ = (function (){try{while(true){
var result__13997__auto__ = switch__13994__auto__.call(null,state_18502);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13997__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13997__auto__;
}
break;
}
}catch (e18587){if((e18587 instanceof Object)){
var ex__13998__auto__ = e18587;
var statearr_18588_18645 = state_18502;
(statearr_18588_18645[(5)] = ex__13998__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18502);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18587;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13996__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18646 = state_18502;
state_18502 = G__18646;
continue;
} else {
return ret_value__13996__auto__;
}
break;
}
});
state_machine__13995__auto__ = function(state_18502){
switch(arguments.length){
case 0:
return state_machine__13995__auto____0.call(this);
case 1:
return state_machine__13995__auto____1.call(this,state_18502);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__13995__auto____0;
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__13995__auto____1;
return state_machine__13995__auto__;
})()
;})(switch__13994__auto__,c__14050__auto___18590,cs,m,dchan,dctr,done))
})();
var state__14052__auto__ = (function (){var statearr_18589 = f__14051__auto__.call(null);
(statearr_18589[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14050__auto___18590);

return statearr_18589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14052__auto__);
});})(c__14050__auto___18590,cs,m,dchan,dctr,done))
);


return m;
});
/**
* Copies the mult source onto the supplied channel.
* 
* By default the channel will be closed when the source closes,
* but can be determined by the close? parameter.
*/
cljs.core.async.tap = (function() {
var tap = null;
var tap__2 = (function (mult,ch){
return tap.call(null,mult,ch,true);
});
var tap__3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});
tap = function(mult,ch,close_QMARK_){
switch(arguments.length){
case 2:
return tap__2.call(this,mult,ch);
case 3:
return tap__3.call(this,mult,ch,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
tap.cljs$core$IFn$_invoke$arity$2 = tap__2;
tap.cljs$core$IFn$_invoke$arity$3 = tap__3;
return tap;
})()
;
/**
* Disconnects a target channel from a mult
*/
cljs.core.async.untap = (function untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
* Disconnects all target channels from a mult
*/
cljs.core.async.untap_all = (function untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

cljs.core.async.Mix = (function (){var obj18648 = {};
return obj18648;
})();

cljs.core.async.admix_STAR_ = (function admix_STAR_(m,ch){
if((function (){var and__5090__auto__ = m;
if(and__5090__auto__){
return m.cljs$core$async$Mix$admix_STAR_$arity$2;
} else {
return and__5090__auto__;
}
})()){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5746__auto__ = (((m == null))?null:m);
return (function (){var or__5102__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5746__auto__)]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.unmix_STAR_ = (function unmix_STAR_(m,ch){
if((function (){var and__5090__auto__ = m;
if(and__5090__auto__){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2;
} else {
return and__5090__auto__;
}
})()){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5746__auto__ = (((m == null))?null:m);
return (function (){var or__5102__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5746__auto__)]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.unmix_all_STAR_ = (function unmix_all_STAR_(m){
if((function (){var and__5090__auto__ = m;
if(and__5090__auto__){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1;
} else {
return and__5090__auto__;
}
})()){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5746__auto__ = (((m == null))?null:m);
return (function (){var or__5102__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5746__auto__)]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
})().call(null,m);
}
});

cljs.core.async.toggle_STAR_ = (function toggle_STAR_(m,state_map){
if((function (){var and__5090__auto__ = m;
if(and__5090__auto__){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2;
} else {
return and__5090__auto__;
}
})()){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5746__auto__ = (((m == null))?null:m);
return (function (){var or__5102__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5746__auto__)]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
})().call(null,m,state_map);
}
});

cljs.core.async.solo_mode_STAR_ = (function solo_mode_STAR_(m,mode){
if((function (){var and__5090__auto__ = m;
if(and__5090__auto__){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2;
} else {
return and__5090__auto__;
}
})()){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5746__auto__ = (((m == null))?null:m);
return (function (){var or__5102__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5746__auto__)]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
})().call(null,m,mode);
}
});

/**
* @param {...*} var_args
*/
cljs.core.async.ioc_alts_BANG_ = (function() { 
var ioc_alts_BANG___delegate = function (state,cont_block,ports,p__18649){
var map__18654 = p__18649;
var map__18654__$1 = ((cljs.core.seq_QMARK_.call(null,map__18654))?cljs.core.apply.call(null,cljs.core.hash_map,map__18654):map__18654);
var opts = map__18654__$1;
var statearr_18655_18658 = state;
(statearr_18655_18658[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4126__auto__ = cljs.core.async.do_alts.call(null,((function (map__18654,map__18654__$1,opts){
return (function (val){
var statearr_18656_18659 = state;
(statearr_18656_18659[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__18654,map__18654__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4126__auto__)){
var cb = temp__4126__auto__;
var statearr_18657_18660 = state;
(statearr_18657_18660[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
};
var ioc_alts_BANG_ = function (state,cont_block,ports,var_args){
var p__18649 = null;
if (arguments.length > 3) {
var G__18661__i = 0, G__18661__a = new Array(arguments.length -  3);
while (G__18661__i < G__18661__a.length) {G__18661__a[G__18661__i] = arguments[G__18661__i + 3]; ++G__18661__i;}
  p__18649 = new cljs.core.IndexedSeq(G__18661__a,0);
} 
return ioc_alts_BANG___delegate.call(this,state,cont_block,ports,p__18649);};
ioc_alts_BANG_.cljs$lang$maxFixedArity = 3;
ioc_alts_BANG_.cljs$lang$applyTo = (function (arglist__18662){
var state = cljs.core.first(arglist__18662);
arglist__18662 = cljs.core.next(arglist__18662);
var cont_block = cljs.core.first(arglist__18662);
arglist__18662 = cljs.core.next(arglist__18662);
var ports = cljs.core.first(arglist__18662);
var p__18649 = cljs.core.rest(arglist__18662);
return ioc_alts_BANG___delegate(state,cont_block,ports,p__18649);
});
ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = ioc_alts_BANG___delegate;
return ioc_alts_BANG_;
})()
;
/**
* Creates and returns a mix of one or more input channels which will
* be put on the supplied out channel. Input sources can be added to
* the mix with 'admix', and removed with 'unmix'. A mix supports
* soloing, muting and pausing multiple inputs atomically using
* 'toggle', and can solo using either muting or pausing as determined
* by 'solo-mode'.
* 
* Each channel can have zero or more boolean modes set via 'toggle':
* 
* :solo - when true, only this (ond other soloed) channel(s) will appear
* in the mix output channel. :mute and :pause states of soloed
* channels are ignored. If solo-mode is :mute, non-soloed
* channels are muted, if :pause, non-soloed channels are
* paused.
* 
* :mute - muted channels will have their contents consumed but not included in the mix
* :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
*/
cljs.core.async.mix = (function mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t18782 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t18782 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta18783){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta18783 = meta18783;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t18782.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t18782.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t18782.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t18782.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t18782.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t18782.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t18782.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t18782.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t18782.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18784){
var self__ = this;
var _18784__$1 = this;
return self__.meta18783;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t18782.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18784,meta18783__$1){
var self__ = this;
var _18784__$1 = this;
return (new cljs.core.async.t18782(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta18783__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t18782.cljs$lang$type = true;

cljs.core.async.t18782.cljs$lang$ctorStr = "cljs.core.async/t18782";

cljs.core.async.t18782.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write.call(null,writer__5690__auto__,"cljs.core.async/t18782");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t18782 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function __GT_t18782(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18783){
return (new cljs.core.async.t18782(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18783));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t18782(change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14050__auto___18901 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14050__auto___18901,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__14051__auto__ = (function (){var switch__13994__auto__ = ((function (c__14050__auto___18901,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_18854){
var state_val_18855 = (state_18854[(1)]);
if((state_val_18855 === (7))){
var inst_18798 = (state_18854[(7)]);
var inst_18803 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18798);
var state_18854__$1 = state_18854;
var statearr_18856_18902 = state_18854__$1;
(statearr_18856_18902[(2)] = inst_18803);

(statearr_18856_18902[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (20))){
var inst_18813 = (state_18854[(8)]);
var state_18854__$1 = state_18854;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18854__$1,(23),out,inst_18813);
} else {
if((state_val_18855 === (1))){
var inst_18788 = (state_18854[(9)]);
var inst_18788__$1 = calc_state.call(null);
var inst_18789 = cljs.core.seq_QMARK_.call(null,inst_18788__$1);
var state_18854__$1 = (function (){var statearr_18857 = state_18854;
(statearr_18857[(9)] = inst_18788__$1);

return statearr_18857;
})();
if(inst_18789){
var statearr_18858_18903 = state_18854__$1;
(statearr_18858_18903[(1)] = (2));

} else {
var statearr_18859_18904 = state_18854__$1;
(statearr_18859_18904[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (24))){
var inst_18806 = (state_18854[(10)]);
var inst_18798 = inst_18806;
var state_18854__$1 = (function (){var statearr_18860 = state_18854;
(statearr_18860[(7)] = inst_18798);

return statearr_18860;
})();
var statearr_18861_18905 = state_18854__$1;
(statearr_18861_18905[(2)] = null);

(statearr_18861_18905[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (4))){
var inst_18788 = (state_18854[(9)]);
var inst_18794 = (state_18854[(2)]);
var inst_18795 = cljs.core.get.call(null,inst_18794,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_18796 = cljs.core.get.call(null,inst_18794,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18797 = cljs.core.get.call(null,inst_18794,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18798 = inst_18788;
var state_18854__$1 = (function (){var statearr_18862 = state_18854;
(statearr_18862[(11)] = inst_18795);

(statearr_18862[(7)] = inst_18798);

(statearr_18862[(12)] = inst_18796);

(statearr_18862[(13)] = inst_18797);

return statearr_18862;
})();
var statearr_18863_18906 = state_18854__$1;
(statearr_18863_18906[(2)] = null);

(statearr_18863_18906[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (15))){
var state_18854__$1 = state_18854;
var statearr_18864_18907 = state_18854__$1;
(statearr_18864_18907[(2)] = null);

(statearr_18864_18907[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (21))){
var inst_18806 = (state_18854[(10)]);
var inst_18798 = inst_18806;
var state_18854__$1 = (function (){var statearr_18865 = state_18854;
(statearr_18865[(7)] = inst_18798);

return statearr_18865;
})();
var statearr_18866_18908 = state_18854__$1;
(statearr_18866_18908[(2)] = null);

(statearr_18866_18908[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (13))){
var inst_18850 = (state_18854[(2)]);
var state_18854__$1 = state_18854;
var statearr_18867_18909 = state_18854__$1;
(statearr_18867_18909[(2)] = inst_18850);

(statearr_18867_18909[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (22))){
var inst_18848 = (state_18854[(2)]);
var state_18854__$1 = state_18854;
var statearr_18868_18910 = state_18854__$1;
(statearr_18868_18910[(2)] = inst_18848);

(statearr_18868_18910[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (6))){
var inst_18852 = (state_18854[(2)]);
var state_18854__$1 = state_18854;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18854__$1,inst_18852);
} else {
if((state_val_18855 === (25))){
var state_18854__$1 = state_18854;
var statearr_18869_18911 = state_18854__$1;
(statearr_18869_18911[(2)] = null);

(statearr_18869_18911[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (17))){
var inst_18828 = (state_18854[(14)]);
var state_18854__$1 = state_18854;
var statearr_18870_18912 = state_18854__$1;
(statearr_18870_18912[(2)] = inst_18828);

(statearr_18870_18912[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (3))){
var inst_18788 = (state_18854[(9)]);
var state_18854__$1 = state_18854;
var statearr_18871_18913 = state_18854__$1;
(statearr_18871_18913[(2)] = inst_18788);

(statearr_18871_18913[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (12))){
var inst_18814 = (state_18854[(15)]);
var inst_18828 = (state_18854[(14)]);
var inst_18809 = (state_18854[(16)]);
var inst_18828__$1 = inst_18809.call(null,inst_18814);
var state_18854__$1 = (function (){var statearr_18872 = state_18854;
(statearr_18872[(14)] = inst_18828__$1);

return statearr_18872;
})();
if(cljs.core.truth_(inst_18828__$1)){
var statearr_18873_18914 = state_18854__$1;
(statearr_18873_18914[(1)] = (17));

} else {
var statearr_18874_18915 = state_18854__$1;
(statearr_18874_18915[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (2))){
var inst_18788 = (state_18854[(9)]);
var inst_18791 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18788);
var state_18854__$1 = state_18854;
var statearr_18875_18916 = state_18854__$1;
(statearr_18875_18916[(2)] = inst_18791);

(statearr_18875_18916[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (23))){
var inst_18839 = (state_18854[(2)]);
var state_18854__$1 = state_18854;
if(cljs.core.truth_(inst_18839)){
var statearr_18876_18917 = state_18854__$1;
(statearr_18876_18917[(1)] = (24));

} else {
var statearr_18877_18918 = state_18854__$1;
(statearr_18877_18918[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (19))){
var inst_18836 = (state_18854[(2)]);
var state_18854__$1 = state_18854;
if(cljs.core.truth_(inst_18836)){
var statearr_18878_18919 = state_18854__$1;
(statearr_18878_18919[(1)] = (20));

} else {
var statearr_18879_18920 = state_18854__$1;
(statearr_18879_18920[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (11))){
var inst_18813 = (state_18854[(8)]);
var inst_18819 = (inst_18813 == null);
var state_18854__$1 = state_18854;
if(cljs.core.truth_(inst_18819)){
var statearr_18880_18921 = state_18854__$1;
(statearr_18880_18921[(1)] = (14));

} else {
var statearr_18881_18922 = state_18854__$1;
(statearr_18881_18922[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (9))){
var inst_18806 = (state_18854[(10)]);
var inst_18806__$1 = (state_18854[(2)]);
var inst_18807 = cljs.core.get.call(null,inst_18806__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_18808 = cljs.core.get.call(null,inst_18806__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18809 = cljs.core.get.call(null,inst_18806__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var state_18854__$1 = (function (){var statearr_18882 = state_18854;
(statearr_18882[(10)] = inst_18806__$1);

(statearr_18882[(16)] = inst_18809);

(statearr_18882[(17)] = inst_18808);

return statearr_18882;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18854__$1,(10),inst_18807);
} else {
if((state_val_18855 === (5))){
var inst_18798 = (state_18854[(7)]);
var inst_18801 = cljs.core.seq_QMARK_.call(null,inst_18798);
var state_18854__$1 = state_18854;
if(inst_18801){
var statearr_18883_18923 = state_18854__$1;
(statearr_18883_18923[(1)] = (7));

} else {
var statearr_18884_18924 = state_18854__$1;
(statearr_18884_18924[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (14))){
var inst_18814 = (state_18854[(15)]);
var inst_18821 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_18814);
var state_18854__$1 = state_18854;
var statearr_18885_18925 = state_18854__$1;
(statearr_18885_18925[(2)] = inst_18821);

(statearr_18885_18925[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (26))){
var inst_18844 = (state_18854[(2)]);
var state_18854__$1 = state_18854;
var statearr_18886_18926 = state_18854__$1;
(statearr_18886_18926[(2)] = inst_18844);

(statearr_18886_18926[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (16))){
var inst_18824 = (state_18854[(2)]);
var inst_18825 = calc_state.call(null);
var inst_18798 = inst_18825;
var state_18854__$1 = (function (){var statearr_18887 = state_18854;
(statearr_18887[(18)] = inst_18824);

(statearr_18887[(7)] = inst_18798);

return statearr_18887;
})();
var statearr_18888_18927 = state_18854__$1;
(statearr_18888_18927[(2)] = null);

(statearr_18888_18927[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (10))){
var inst_18813 = (state_18854[(8)]);
var inst_18814 = (state_18854[(15)]);
var inst_18812 = (state_18854[(2)]);
var inst_18813__$1 = cljs.core.nth.call(null,inst_18812,(0),null);
var inst_18814__$1 = cljs.core.nth.call(null,inst_18812,(1),null);
var inst_18815 = (inst_18813__$1 == null);
var inst_18816 = cljs.core._EQ_.call(null,inst_18814__$1,change);
var inst_18817 = (inst_18815) || (inst_18816);
var state_18854__$1 = (function (){var statearr_18889 = state_18854;
(statearr_18889[(8)] = inst_18813__$1);

(statearr_18889[(15)] = inst_18814__$1);

return statearr_18889;
})();
if(cljs.core.truth_(inst_18817)){
var statearr_18890_18928 = state_18854__$1;
(statearr_18890_18928[(1)] = (11));

} else {
var statearr_18891_18929 = state_18854__$1;
(statearr_18891_18929[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (18))){
var inst_18814 = (state_18854[(15)]);
var inst_18809 = (state_18854[(16)]);
var inst_18808 = (state_18854[(17)]);
var inst_18831 = cljs.core.empty_QMARK_.call(null,inst_18809);
var inst_18832 = inst_18808.call(null,inst_18814);
var inst_18833 = cljs.core.not.call(null,inst_18832);
var inst_18834 = (inst_18831) && (inst_18833);
var state_18854__$1 = state_18854;
var statearr_18892_18930 = state_18854__$1;
(statearr_18892_18930[(2)] = inst_18834);

(statearr_18892_18930[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (8))){
var inst_18798 = (state_18854[(7)]);
var state_18854__$1 = state_18854;
var statearr_18893_18931 = state_18854__$1;
(statearr_18893_18931[(2)] = inst_18798);

(statearr_18893_18931[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14050__auto___18901,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__13994__auto__,c__14050__auto___18901,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var state_machine__13995__auto__ = null;
var state_machine__13995__auto____0 = (function (){
var statearr_18897 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18897[(0)] = state_machine__13995__auto__);

(statearr_18897[(1)] = (1));

return statearr_18897;
});
var state_machine__13995__auto____1 = (function (state_18854){
while(true){
var ret_value__13996__auto__ = (function (){try{while(true){
var result__13997__auto__ = switch__13994__auto__.call(null,state_18854);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13997__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13997__auto__;
}
break;
}
}catch (e18898){if((e18898 instanceof Object)){
var ex__13998__auto__ = e18898;
var statearr_18899_18932 = state_18854;
(statearr_18899_18932[(5)] = ex__13998__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18854);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18898;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13996__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18933 = state_18854;
state_18854 = G__18933;
continue;
} else {
return ret_value__13996__auto__;
}
break;
}
});
state_machine__13995__auto__ = function(state_18854){
switch(arguments.length){
case 0:
return state_machine__13995__auto____0.call(this);
case 1:
return state_machine__13995__auto____1.call(this,state_18854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__13995__auto____0;
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__13995__auto____1;
return state_machine__13995__auto__;
})()
;})(switch__13994__auto__,c__14050__auto___18901,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__14052__auto__ = (function (){var statearr_18900 = f__14051__auto__.call(null);
(statearr_18900[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14050__auto___18901);

return statearr_18900;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14052__auto__);
});})(c__14050__auto___18901,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
* Adds ch as an input to the mix
*/
cljs.core.async.admix = (function admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
* Removes ch as an input to the mix
*/
cljs.core.async.unmix = (function unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
* removes all inputs from the mix
*/
cljs.core.async.unmix_all = (function unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
* Atomically sets the state(s) of one or more channels in a mix. The
* state map is a map of channels -> channel-state-map. A
* channel-state-map is a map of attrs -> boolean, where attr is one or
* more of :mute, :pause or :solo. Any states supplied are merged with
* the current state.
* 
* Note that channels can be added to a mix via toggle, which can be
* used to add channels in a particular (e.g. paused) state.
*/
cljs.core.async.toggle = (function toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
* Sets the solo mode of the mix. mode must be one of :mute or :pause
*/
cljs.core.async.solo_mode = (function solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

cljs.core.async.Pub = (function (){var obj18935 = {};
return obj18935;
})();

cljs.core.async.sub_STAR_ = (function sub_STAR_(p,v,ch,close_QMARK_){
if((function (){var and__5090__auto__ = p;
if(and__5090__auto__){
return p.cljs$core$async$Pub$sub_STAR_$arity$4;
} else {
return and__5090__auto__;
}
})()){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5746__auto__ = (((p == null))?null:p);
return (function (){var or__5102__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5746__auto__)]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
})().call(null,p,v,ch,close_QMARK_);
}
});

cljs.core.async.unsub_STAR_ = (function unsub_STAR_(p,v,ch){
if((function (){var and__5090__auto__ = p;
if(and__5090__auto__){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3;
} else {
return and__5090__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5746__auto__ = (((p == null))?null:p);
return (function (){var or__5102__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5746__auto__)]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
})().call(null,p,v,ch);
}
});

cljs.core.async.unsub_all_STAR_ = (function() {
var unsub_all_STAR_ = null;
var unsub_all_STAR___1 = (function (p){
if((function (){var and__5090__auto__ = p;
if(and__5090__auto__){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1;
} else {
return and__5090__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5746__auto__ = (((p == null))?null:p);
return (function (){var or__5102__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5746__auto__)]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p);
}
});
var unsub_all_STAR___2 = (function (p,v){
if((function (){var and__5090__auto__ = p;
if(and__5090__auto__){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2;
} else {
return and__5090__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5746__auto__ = (((p == null))?null:p);
return (function (){var or__5102__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5746__auto__)]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p,v);
}
});
unsub_all_STAR_ = function(p,v){
switch(arguments.length){
case 1:
return unsub_all_STAR___1.call(this,p);
case 2:
return unsub_all_STAR___2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = unsub_all_STAR___1;
unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = unsub_all_STAR___2;
return unsub_all_STAR_;
})()
;

/**
* Creates and returns a pub(lication) of the supplied channel,
* partitioned into topics by the topic-fn. topic-fn will be applied to
* each value on the channel and the result will determine the 'topic'
* on which that value will be put. Channels can be subscribed to
* receive copies of topics using 'sub', and unsubscribed using
* 'unsub'. Each topic will be handled by an internal mult on a
* dedicated channel. By default these internal channels are
* unbuffered, but a buf-fn can be supplied which, given a topic,
* creates a buffer with desired properties.
* 
* Each item is distributed to all subs in parallel and synchronously,
* i.e. each sub must accept before the next item is distributed. Use
* buffering/windowing to prevent slow subs from holding up the pub.
* 
* Items received when there are no matching subs get dropped.
* 
* Note that if buf-fns are used then each topic is handled
* asynchronously, i.e. if a channel is subscribed to more than one
* topic it should not expect them to be interleaved identically with
* the source.
*/
cljs.core.async.pub = (function() {
var pub = null;
var pub__2 = (function (ch,topic_fn){
return pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});
var pub__3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__5102__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__5102__auto__,mults){
return (function (p1__18936_SHARP_){
if(cljs.core.truth_(p1__18936_SHARP_.call(null,topic))){
return p1__18936_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__18936_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__5102__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t19059 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t19059 = (function (ensure_mult,mults,buf_fn,topic_fn,ch,pub,meta19060){
this.ensure_mult = ensure_mult;
this.mults = mults;
this.buf_fn = buf_fn;
this.topic_fn = topic_fn;
this.ch = ch;
this.pub = pub;
this.meta19060 = meta19060;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t19059.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t19059.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t19059.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4126__auto__)){
var m = temp__4126__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t19059.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t19059.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t19059.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t19059.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t19059.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_19061){
var self__ = this;
var _19061__$1 = this;
return self__.meta19060;
});})(mults,ensure_mult))
;

cljs.core.async.t19059.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_19061,meta19060__$1){
var self__ = this;
var _19061__$1 = this;
return (new cljs.core.async.t19059(self__.ensure_mult,self__.mults,self__.buf_fn,self__.topic_fn,self__.ch,self__.pub,meta19060__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t19059.cljs$lang$type = true;

cljs.core.async.t19059.cljs$lang$ctorStr = "cljs.core.async/t19059";

cljs.core.async.t19059.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write.call(null,writer__5690__auto__,"cljs.core.async/t19059");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t19059 = ((function (mults,ensure_mult){
return (function __GT_t19059(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,pub__$1,meta19060){
return (new cljs.core.async.t19059(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,pub__$1,meta19060));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t19059(ensure_mult,mults,buf_fn,topic_fn,ch,pub,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14050__auto___19181 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14050__auto___19181,mults,ensure_mult,p){
return (function (){
var f__14051__auto__ = (function (){var switch__13994__auto__ = ((function (c__14050__auto___19181,mults,ensure_mult,p){
return (function (state_19133){
var state_val_19134 = (state_19133[(1)]);
if((state_val_19134 === (7))){
var inst_19129 = (state_19133[(2)]);
var state_19133__$1 = state_19133;
var statearr_19135_19182 = state_19133__$1;
(statearr_19135_19182[(2)] = inst_19129);

(statearr_19135_19182[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19134 === (20))){
var state_19133__$1 = state_19133;
var statearr_19136_19183 = state_19133__$1;
(statearr_19136_19183[(2)] = null);

(statearr_19136_19183[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19134 === (1))){
var state_19133__$1 = state_19133;
var statearr_19137_19184 = state_19133__$1;
(statearr_19137_19184[(2)] = null);

(statearr_19137_19184[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19134 === (24))){
var inst_19112 = (state_19133[(7)]);
var inst_19121 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_19112);
var state_19133__$1 = state_19133;
var statearr_19138_19185 = state_19133__$1;
(statearr_19138_19185[(2)] = inst_19121);

(statearr_19138_19185[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19134 === (4))){
var inst_19064 = (state_19133[(8)]);
var inst_19064__$1 = (state_19133[(2)]);
var inst_19065 = (inst_19064__$1 == null);
var state_19133__$1 = (function (){var statearr_19139 = state_19133;
(statearr_19139[(8)] = inst_19064__$1);

return statearr_19139;
})();
if(cljs.core.truth_(inst_19065)){
var statearr_19140_19186 = state_19133__$1;
(statearr_19140_19186[(1)] = (5));

} else {
var statearr_19141_19187 = state_19133__$1;
(statearr_19141_19187[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19134 === (15))){
var inst_19106 = (state_19133[(2)]);
var state_19133__$1 = state_19133;
var statearr_19142_19188 = state_19133__$1;
(statearr_19142_19188[(2)] = inst_19106);

(statearr_19142_19188[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19134 === (21))){
var inst_19126 = (state_19133[(2)]);
var state_19133__$1 = (function (){var statearr_19143 = state_19133;
(statearr_19143[(9)] = inst_19126);

return statearr_19143;
})();
var statearr_19144_19189 = state_19133__$1;
(statearr_19144_19189[(2)] = null);

(statearr_19144_19189[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19134 === (13))){
var inst_19088 = (state_19133[(10)]);
var inst_19090 = cljs.core.chunked_seq_QMARK_.call(null,inst_19088);
var state_19133__$1 = state_19133;
if(inst_19090){
var statearr_19145_19190 = state_19133__$1;
(statearr_19145_19190[(1)] = (16));

} else {
var statearr_19146_19191 = state_19133__$1;
(statearr_19146_19191[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19134 === (22))){
var inst_19118 = (state_19133[(2)]);
var state_19133__$1 = state_19133;
if(cljs.core.truth_(inst_19118)){
var statearr_19147_19192 = state_19133__$1;
(statearr_19147_19192[(1)] = (23));

} else {
var statearr_19148_19193 = state_19133__$1;
(statearr_19148_19193[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19134 === (6))){
var inst_19112 = (state_19133[(7)]);
var inst_19114 = (state_19133[(11)]);
var inst_19064 = (state_19133[(8)]);
var inst_19112__$1 = topic_fn.call(null,inst_19064);
var inst_19113 = cljs.core.deref.call(null,mults);
var inst_19114__$1 = cljs.core.get.call(null,inst_19113,inst_19112__$1);
var state_19133__$1 = (function (){var statearr_19149 = state_19133;
(statearr_19149[(7)] = inst_19112__$1);

(statearr_19149[(11)] = inst_19114__$1);

return statearr_19149;
})();
if(cljs.core.truth_(inst_19114__$1)){
var statearr_19150_19194 = state_19133__$1;
(statearr_19150_19194[(1)] = (19));

} else {
var statearr_19151_19195 = state_19133__$1;
(statearr_19151_19195[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19134 === (25))){
var inst_19123 = (state_19133[(2)]);
var state_19133__$1 = state_19133;
var statearr_19152_19196 = state_19133__$1;
(statearr_19152_19196[(2)] = inst_19123);

(statearr_19152_19196[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19134 === (17))){
var inst_19088 = (state_19133[(10)]);
var inst_19097 = cljs.core.first.call(null,inst_19088);
var inst_19098 = cljs.core.async.muxch_STAR_.call(null,inst_19097);
var inst_19099 = cljs.core.async.close_BANG_.call(null,inst_19098);
var inst_19100 = cljs.core.next.call(null,inst_19088);
var inst_19074 = inst_19100;
var inst_19075 = null;
var inst_19076 = (0);
var inst_19077 = (0);
var state_19133__$1 = (function (){var statearr_19153 = state_19133;
(statearr_19153[(12)] = inst_19077);

(statearr_19153[(13)] = inst_19075);

(statearr_19153[(14)] = inst_19099);

(statearr_19153[(15)] = inst_19074);

(statearr_19153[(16)] = inst_19076);

return statearr_19153;
})();
var statearr_19154_19197 = state_19133__$1;
(statearr_19154_19197[(2)] = null);

(statearr_19154_19197[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19134 === (3))){
var inst_19131 = (state_19133[(2)]);
var state_19133__$1 = state_19133;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19133__$1,inst_19131);
} else {
if((state_val_19134 === (12))){
var inst_19108 = (state_19133[(2)]);
var state_19133__$1 = state_19133;
var statearr_19155_19198 = state_19133__$1;
(statearr_19155_19198[(2)] = inst_19108);

(statearr_19155_19198[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19134 === (2))){
var state_19133__$1 = state_19133;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19133__$1,(4),ch);
} else {
if((state_val_19134 === (23))){
var state_19133__$1 = state_19133;
var statearr_19156_19199 = state_19133__$1;
(statearr_19156_19199[(2)] = null);

(statearr_19156_19199[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19134 === (19))){
var inst_19114 = (state_19133[(11)]);
var inst_19064 = (state_19133[(8)]);
var inst_19116 = cljs.core.async.muxch_STAR_.call(null,inst_19114);
var state_19133__$1 = state_19133;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19133__$1,(22),inst_19116,inst_19064);
} else {
if((state_val_19134 === (11))){
var inst_19088 = (state_19133[(10)]);
var inst_19074 = (state_19133[(15)]);
var inst_19088__$1 = cljs.core.seq.call(null,inst_19074);
var state_19133__$1 = (function (){var statearr_19157 = state_19133;
(statearr_19157[(10)] = inst_19088__$1);

return statearr_19157;
})();
if(inst_19088__$1){
var statearr_19158_19200 = state_19133__$1;
(statearr_19158_19200[(1)] = (13));

} else {
var statearr_19159_19201 = state_19133__$1;
(statearr_19159_19201[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19134 === (9))){
var inst_19110 = (state_19133[(2)]);
var state_19133__$1 = state_19133;
var statearr_19160_19202 = state_19133__$1;
(statearr_19160_19202[(2)] = inst_19110);

(statearr_19160_19202[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19134 === (5))){
var inst_19071 = cljs.core.deref.call(null,mults);
var inst_19072 = cljs.core.vals.call(null,inst_19071);
var inst_19073 = cljs.core.seq.call(null,inst_19072);
var inst_19074 = inst_19073;
var inst_19075 = null;
var inst_19076 = (0);
var inst_19077 = (0);
var state_19133__$1 = (function (){var statearr_19161 = state_19133;
(statearr_19161[(12)] = inst_19077);

(statearr_19161[(13)] = inst_19075);

(statearr_19161[(15)] = inst_19074);

(statearr_19161[(16)] = inst_19076);

return statearr_19161;
})();
var statearr_19162_19203 = state_19133__$1;
(statearr_19162_19203[(2)] = null);

(statearr_19162_19203[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19134 === (14))){
var state_19133__$1 = state_19133;
var statearr_19166_19204 = state_19133__$1;
(statearr_19166_19204[(2)] = null);

(statearr_19166_19204[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19134 === (16))){
var inst_19088 = (state_19133[(10)]);
var inst_19092 = cljs.core.chunk_first.call(null,inst_19088);
var inst_19093 = cljs.core.chunk_rest.call(null,inst_19088);
var inst_19094 = cljs.core.count.call(null,inst_19092);
var inst_19074 = inst_19093;
var inst_19075 = inst_19092;
var inst_19076 = inst_19094;
var inst_19077 = (0);
var state_19133__$1 = (function (){var statearr_19167 = state_19133;
(statearr_19167[(12)] = inst_19077);

(statearr_19167[(13)] = inst_19075);

(statearr_19167[(15)] = inst_19074);

(statearr_19167[(16)] = inst_19076);

return statearr_19167;
})();
var statearr_19168_19205 = state_19133__$1;
(statearr_19168_19205[(2)] = null);

(statearr_19168_19205[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19134 === (10))){
var inst_19077 = (state_19133[(12)]);
var inst_19075 = (state_19133[(13)]);
var inst_19074 = (state_19133[(15)]);
var inst_19076 = (state_19133[(16)]);
var inst_19082 = cljs.core._nth.call(null,inst_19075,inst_19077);
var inst_19083 = cljs.core.async.muxch_STAR_.call(null,inst_19082);
var inst_19084 = cljs.core.async.close_BANG_.call(null,inst_19083);
var inst_19085 = (inst_19077 + (1));
var tmp19163 = inst_19075;
var tmp19164 = inst_19074;
var tmp19165 = inst_19076;
var inst_19074__$1 = tmp19164;
var inst_19075__$1 = tmp19163;
var inst_19076__$1 = tmp19165;
var inst_19077__$1 = inst_19085;
var state_19133__$1 = (function (){var statearr_19169 = state_19133;
(statearr_19169[(17)] = inst_19084);

(statearr_19169[(12)] = inst_19077__$1);

(statearr_19169[(13)] = inst_19075__$1);

(statearr_19169[(15)] = inst_19074__$1);

(statearr_19169[(16)] = inst_19076__$1);

return statearr_19169;
})();
var statearr_19170_19206 = state_19133__$1;
(statearr_19170_19206[(2)] = null);

(statearr_19170_19206[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19134 === (18))){
var inst_19103 = (state_19133[(2)]);
var state_19133__$1 = state_19133;
var statearr_19171_19207 = state_19133__$1;
(statearr_19171_19207[(2)] = inst_19103);

(statearr_19171_19207[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19134 === (8))){
var inst_19077 = (state_19133[(12)]);
var inst_19076 = (state_19133[(16)]);
var inst_19079 = (inst_19077 < inst_19076);
var inst_19080 = inst_19079;
var state_19133__$1 = state_19133;
if(cljs.core.truth_(inst_19080)){
var statearr_19172_19208 = state_19133__$1;
(statearr_19172_19208[(1)] = (10));

} else {
var statearr_19173_19209 = state_19133__$1;
(statearr_19173_19209[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14050__auto___19181,mults,ensure_mult,p))
;
return ((function (switch__13994__auto__,c__14050__auto___19181,mults,ensure_mult,p){
return (function() {
var state_machine__13995__auto__ = null;
var state_machine__13995__auto____0 = (function (){
var statearr_19177 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19177[(0)] = state_machine__13995__auto__);

(statearr_19177[(1)] = (1));

return statearr_19177;
});
var state_machine__13995__auto____1 = (function (state_19133){
while(true){
var ret_value__13996__auto__ = (function (){try{while(true){
var result__13997__auto__ = switch__13994__auto__.call(null,state_19133);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13997__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13997__auto__;
}
break;
}
}catch (e19178){if((e19178 instanceof Object)){
var ex__13998__auto__ = e19178;
var statearr_19179_19210 = state_19133;
(statearr_19179_19210[(5)] = ex__13998__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19133);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19178;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13996__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19211 = state_19133;
state_19133 = G__19211;
continue;
} else {
return ret_value__13996__auto__;
}
break;
}
});
state_machine__13995__auto__ = function(state_19133){
switch(arguments.length){
case 0:
return state_machine__13995__auto____0.call(this);
case 1:
return state_machine__13995__auto____1.call(this,state_19133);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__13995__auto____0;
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__13995__auto____1;
return state_machine__13995__auto__;
})()
;})(switch__13994__auto__,c__14050__auto___19181,mults,ensure_mult,p))
})();
var state__14052__auto__ = (function (){var statearr_19180 = f__14051__auto__.call(null);
(statearr_19180[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14050__auto___19181);

return statearr_19180;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14052__auto__);
});})(c__14050__auto___19181,mults,ensure_mult,p))
);


return p;
});
pub = function(ch,topic_fn,buf_fn){
switch(arguments.length){
case 2:
return pub__2.call(this,ch,topic_fn);
case 3:
return pub__3.call(this,ch,topic_fn,buf_fn);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pub.cljs$core$IFn$_invoke$arity$2 = pub__2;
pub.cljs$core$IFn$_invoke$arity$3 = pub__3;
return pub;
})()
;
/**
* Subscribes a channel to a topic of a pub.
* 
* By default the channel will be closed when the source closes,
* but can be determined by the close? parameter.
*/
cljs.core.async.sub = (function() {
var sub = null;
var sub__3 = (function (p,topic,ch){
return sub.call(null,p,topic,ch,true);
});
var sub__4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});
sub = function(p,topic,ch,close_QMARK_){
switch(arguments.length){
case 3:
return sub__3.call(this,p,topic,ch);
case 4:
return sub__4.call(this,p,topic,ch,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sub.cljs$core$IFn$_invoke$arity$3 = sub__3;
sub.cljs$core$IFn$_invoke$arity$4 = sub__4;
return sub;
})()
;
/**
* Unsubscribes a channel from a topic of a pub
*/
cljs.core.async.unsub = (function unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
* Unsubscribes all channels from a pub, or a topic of a pub
*/
cljs.core.async.unsub_all = (function() {
var unsub_all = null;
var unsub_all__1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});
var unsub_all__2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});
unsub_all = function(p,topic){
switch(arguments.length){
case 1:
return unsub_all__1.call(this,p);
case 2:
return unsub_all__2.call(this,p,topic);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unsub_all.cljs$core$IFn$_invoke$arity$1 = unsub_all__1;
unsub_all.cljs$core$IFn$_invoke$arity$2 = unsub_all__2;
return unsub_all;
})()
;
/**
* Takes a function and a collection of source channels, and returns a
* channel which contains the values produced by applying f to the set
* of first items taken from each source channel, followed by applying
* f to the set of second items from each channel, until any one of the
* channels is closed, at which point the output channel will be
* closed. The returned channel will be unbuffered by default, or a
* buf-or-n can be supplied
*/
cljs.core.async.map = (function() {
var map = null;
var map__2 = (function (f,chs){
return map.call(null,f,chs,null);
});
var map__3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__14050__auto___19348 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14050__auto___19348,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__14051__auto__ = (function (){var switch__13994__auto__ = ((function (c__14050__auto___19348,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_19318){
var state_val_19319 = (state_19318[(1)]);
if((state_val_19319 === (7))){
var state_19318__$1 = state_19318;
var statearr_19320_19349 = state_19318__$1;
(statearr_19320_19349[(2)] = null);

(statearr_19320_19349[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19319 === (1))){
var state_19318__$1 = state_19318;
var statearr_19321_19350 = state_19318__$1;
(statearr_19321_19350[(2)] = null);

(statearr_19321_19350[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19319 === (4))){
var inst_19282 = (state_19318[(7)]);
var inst_19284 = (inst_19282 < cnt);
var state_19318__$1 = state_19318;
if(cljs.core.truth_(inst_19284)){
var statearr_19322_19351 = state_19318__$1;
(statearr_19322_19351[(1)] = (6));

} else {
var statearr_19323_19352 = state_19318__$1;
(statearr_19323_19352[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19319 === (15))){
var inst_19314 = (state_19318[(2)]);
var state_19318__$1 = state_19318;
var statearr_19324_19353 = state_19318__$1;
(statearr_19324_19353[(2)] = inst_19314);

(statearr_19324_19353[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19319 === (13))){
var inst_19307 = cljs.core.async.close_BANG_.call(null,out);
var state_19318__$1 = state_19318;
var statearr_19325_19354 = state_19318__$1;
(statearr_19325_19354[(2)] = inst_19307);

(statearr_19325_19354[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19319 === (6))){
var state_19318__$1 = state_19318;
var statearr_19326_19355 = state_19318__$1;
(statearr_19326_19355[(2)] = null);

(statearr_19326_19355[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19319 === (3))){
var inst_19316 = (state_19318[(2)]);
var state_19318__$1 = state_19318;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19318__$1,inst_19316);
} else {
if((state_val_19319 === (12))){
var inst_19304 = (state_19318[(8)]);
var inst_19304__$1 = (state_19318[(2)]);
var inst_19305 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_19304__$1);
var state_19318__$1 = (function (){var statearr_19327 = state_19318;
(statearr_19327[(8)] = inst_19304__$1);

return statearr_19327;
})();
if(cljs.core.truth_(inst_19305)){
var statearr_19328_19356 = state_19318__$1;
(statearr_19328_19356[(1)] = (13));

} else {
var statearr_19329_19357 = state_19318__$1;
(statearr_19329_19357[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19319 === (2))){
var inst_19281 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_19282 = (0);
var state_19318__$1 = (function (){var statearr_19330 = state_19318;
(statearr_19330[(7)] = inst_19282);

(statearr_19330[(9)] = inst_19281);

return statearr_19330;
})();
var statearr_19331_19358 = state_19318__$1;
(statearr_19331_19358[(2)] = null);

(statearr_19331_19358[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19319 === (11))){
var inst_19282 = (state_19318[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_19318,(10),Object,null,(9));
var inst_19291 = chs__$1.call(null,inst_19282);
var inst_19292 = done.call(null,inst_19282);
var inst_19293 = cljs.core.async.take_BANG_.call(null,inst_19291,inst_19292);
var state_19318__$1 = state_19318;
var statearr_19332_19359 = state_19318__$1;
(statearr_19332_19359[(2)] = inst_19293);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19318__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19319 === (9))){
var inst_19282 = (state_19318[(7)]);
var inst_19295 = (state_19318[(2)]);
var inst_19296 = (inst_19282 + (1));
var inst_19282__$1 = inst_19296;
var state_19318__$1 = (function (){var statearr_19333 = state_19318;
(statearr_19333[(7)] = inst_19282__$1);

(statearr_19333[(10)] = inst_19295);

return statearr_19333;
})();
var statearr_19334_19360 = state_19318__$1;
(statearr_19334_19360[(2)] = null);

(statearr_19334_19360[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19319 === (5))){
var inst_19302 = (state_19318[(2)]);
var state_19318__$1 = (function (){var statearr_19335 = state_19318;
(statearr_19335[(11)] = inst_19302);

return statearr_19335;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19318__$1,(12),dchan);
} else {
if((state_val_19319 === (14))){
var inst_19304 = (state_19318[(8)]);
var inst_19309 = cljs.core.apply.call(null,f,inst_19304);
var state_19318__$1 = state_19318;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19318__$1,(16),out,inst_19309);
} else {
if((state_val_19319 === (16))){
var inst_19311 = (state_19318[(2)]);
var state_19318__$1 = (function (){var statearr_19336 = state_19318;
(statearr_19336[(12)] = inst_19311);

return statearr_19336;
})();
var statearr_19337_19361 = state_19318__$1;
(statearr_19337_19361[(2)] = null);

(statearr_19337_19361[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19319 === (10))){
var inst_19286 = (state_19318[(2)]);
var inst_19287 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_19318__$1 = (function (){var statearr_19338 = state_19318;
(statearr_19338[(13)] = inst_19286);

return statearr_19338;
})();
var statearr_19339_19362 = state_19318__$1;
(statearr_19339_19362[(2)] = inst_19287);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19318__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19319 === (8))){
var inst_19300 = (state_19318[(2)]);
var state_19318__$1 = state_19318;
var statearr_19340_19363 = state_19318__$1;
(statearr_19340_19363[(2)] = inst_19300);

(statearr_19340_19363[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14050__auto___19348,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__13994__auto__,c__14050__auto___19348,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var state_machine__13995__auto__ = null;
var state_machine__13995__auto____0 = (function (){
var statearr_19344 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19344[(0)] = state_machine__13995__auto__);

(statearr_19344[(1)] = (1));

return statearr_19344;
});
var state_machine__13995__auto____1 = (function (state_19318){
while(true){
var ret_value__13996__auto__ = (function (){try{while(true){
var result__13997__auto__ = switch__13994__auto__.call(null,state_19318);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13997__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13997__auto__;
}
break;
}
}catch (e19345){if((e19345 instanceof Object)){
var ex__13998__auto__ = e19345;
var statearr_19346_19364 = state_19318;
(statearr_19346_19364[(5)] = ex__13998__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19318);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19345;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13996__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19365 = state_19318;
state_19318 = G__19365;
continue;
} else {
return ret_value__13996__auto__;
}
break;
}
});
state_machine__13995__auto__ = function(state_19318){
switch(arguments.length){
case 0:
return state_machine__13995__auto____0.call(this);
case 1:
return state_machine__13995__auto____1.call(this,state_19318);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__13995__auto____0;
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__13995__auto____1;
return state_machine__13995__auto__;
})()
;})(switch__13994__auto__,c__14050__auto___19348,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__14052__auto__ = (function (){var statearr_19347 = f__14051__auto__.call(null);
(statearr_19347[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14050__auto___19348);

return statearr_19347;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14052__auto__);
});})(c__14050__auto___19348,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});
map = function(f,chs,buf_or_n){
switch(arguments.length){
case 2:
return map__2.call(this,f,chs);
case 3:
return map__3.call(this,f,chs,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
map.cljs$core$IFn$_invoke$arity$2 = map__2;
map.cljs$core$IFn$_invoke$arity$3 = map__3;
return map;
})()
;
/**
* Takes a collection of source channels and returns a channel which
* contains all values taken from them. The returned channel will be
* unbuffered by default, or a buf-or-n can be supplied. The channel
* will close after all the source channels have closed.
*/
cljs.core.async.merge = (function() {
var merge = null;
var merge__1 = (function (chs){
return merge.call(null,chs,null);
});
var merge__2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14050__auto___19473 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14050__auto___19473,out){
return (function (){
var f__14051__auto__ = (function (){var switch__13994__auto__ = ((function (c__14050__auto___19473,out){
return (function (state_19449){
var state_val_19450 = (state_19449[(1)]);
if((state_val_19450 === (7))){
var inst_19428 = (state_19449[(7)]);
var inst_19429 = (state_19449[(8)]);
var inst_19428__$1 = (state_19449[(2)]);
var inst_19429__$1 = cljs.core.nth.call(null,inst_19428__$1,(0),null);
var inst_19430 = cljs.core.nth.call(null,inst_19428__$1,(1),null);
var inst_19431 = (inst_19429__$1 == null);
var state_19449__$1 = (function (){var statearr_19451 = state_19449;
(statearr_19451[(9)] = inst_19430);

(statearr_19451[(7)] = inst_19428__$1);

(statearr_19451[(8)] = inst_19429__$1);

return statearr_19451;
})();
if(cljs.core.truth_(inst_19431)){
var statearr_19452_19474 = state_19449__$1;
(statearr_19452_19474[(1)] = (8));

} else {
var statearr_19453_19475 = state_19449__$1;
(statearr_19453_19475[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19450 === (1))){
var inst_19420 = cljs.core.vec.call(null,chs);
var inst_19421 = inst_19420;
var state_19449__$1 = (function (){var statearr_19454 = state_19449;
(statearr_19454[(10)] = inst_19421);

return statearr_19454;
})();
var statearr_19455_19476 = state_19449__$1;
(statearr_19455_19476[(2)] = null);

(statearr_19455_19476[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19450 === (4))){
var inst_19421 = (state_19449[(10)]);
var state_19449__$1 = state_19449;
return cljs.core.async.ioc_alts_BANG_.call(null,state_19449__$1,(7),inst_19421);
} else {
if((state_val_19450 === (6))){
var inst_19445 = (state_19449[(2)]);
var state_19449__$1 = state_19449;
var statearr_19456_19477 = state_19449__$1;
(statearr_19456_19477[(2)] = inst_19445);

(statearr_19456_19477[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19450 === (3))){
var inst_19447 = (state_19449[(2)]);
var state_19449__$1 = state_19449;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19449__$1,inst_19447);
} else {
if((state_val_19450 === (2))){
var inst_19421 = (state_19449[(10)]);
var inst_19423 = cljs.core.count.call(null,inst_19421);
var inst_19424 = (inst_19423 > (0));
var state_19449__$1 = state_19449;
if(cljs.core.truth_(inst_19424)){
var statearr_19458_19478 = state_19449__$1;
(statearr_19458_19478[(1)] = (4));

} else {
var statearr_19459_19479 = state_19449__$1;
(statearr_19459_19479[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19450 === (11))){
var inst_19421 = (state_19449[(10)]);
var inst_19438 = (state_19449[(2)]);
var tmp19457 = inst_19421;
var inst_19421__$1 = tmp19457;
var state_19449__$1 = (function (){var statearr_19460 = state_19449;
(statearr_19460[(10)] = inst_19421__$1);

(statearr_19460[(11)] = inst_19438);

return statearr_19460;
})();
var statearr_19461_19480 = state_19449__$1;
(statearr_19461_19480[(2)] = null);

(statearr_19461_19480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19450 === (9))){
var inst_19429 = (state_19449[(8)]);
var state_19449__$1 = state_19449;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19449__$1,(11),out,inst_19429);
} else {
if((state_val_19450 === (5))){
var inst_19443 = cljs.core.async.close_BANG_.call(null,out);
var state_19449__$1 = state_19449;
var statearr_19462_19481 = state_19449__$1;
(statearr_19462_19481[(2)] = inst_19443);

(statearr_19462_19481[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19450 === (10))){
var inst_19441 = (state_19449[(2)]);
var state_19449__$1 = state_19449;
var statearr_19463_19482 = state_19449__$1;
(statearr_19463_19482[(2)] = inst_19441);

(statearr_19463_19482[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19450 === (8))){
var inst_19421 = (state_19449[(10)]);
var inst_19430 = (state_19449[(9)]);
var inst_19428 = (state_19449[(7)]);
var inst_19429 = (state_19449[(8)]);
var inst_19433 = (function (){var c = inst_19430;
var v = inst_19429;
var vec__19426 = inst_19428;
var cs = inst_19421;
return ((function (c,v,vec__19426,cs,inst_19421,inst_19430,inst_19428,inst_19429,state_val_19450,c__14050__auto___19473,out){
return (function (p1__19366_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__19366_SHARP_);
});
;})(c,v,vec__19426,cs,inst_19421,inst_19430,inst_19428,inst_19429,state_val_19450,c__14050__auto___19473,out))
})();
var inst_19434 = cljs.core.filterv.call(null,inst_19433,inst_19421);
var inst_19421__$1 = inst_19434;
var state_19449__$1 = (function (){var statearr_19464 = state_19449;
(statearr_19464[(10)] = inst_19421__$1);

return statearr_19464;
})();
var statearr_19465_19483 = state_19449__$1;
(statearr_19465_19483[(2)] = null);

(statearr_19465_19483[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14050__auto___19473,out))
;
return ((function (switch__13994__auto__,c__14050__auto___19473,out){
return (function() {
var state_machine__13995__auto__ = null;
var state_machine__13995__auto____0 = (function (){
var statearr_19469 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19469[(0)] = state_machine__13995__auto__);

(statearr_19469[(1)] = (1));

return statearr_19469;
});
var state_machine__13995__auto____1 = (function (state_19449){
while(true){
var ret_value__13996__auto__ = (function (){try{while(true){
var result__13997__auto__ = switch__13994__auto__.call(null,state_19449);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13997__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13997__auto__;
}
break;
}
}catch (e19470){if((e19470 instanceof Object)){
var ex__13998__auto__ = e19470;
var statearr_19471_19484 = state_19449;
(statearr_19471_19484[(5)] = ex__13998__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19449);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19470;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13996__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19485 = state_19449;
state_19449 = G__19485;
continue;
} else {
return ret_value__13996__auto__;
}
break;
}
});
state_machine__13995__auto__ = function(state_19449){
switch(arguments.length){
case 0:
return state_machine__13995__auto____0.call(this);
case 1:
return state_machine__13995__auto____1.call(this,state_19449);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__13995__auto____0;
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__13995__auto____1;
return state_machine__13995__auto__;
})()
;})(switch__13994__auto__,c__14050__auto___19473,out))
})();
var state__14052__auto__ = (function (){var statearr_19472 = f__14051__auto__.call(null);
(statearr_19472[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14050__auto___19473);

return statearr_19472;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14052__auto__);
});})(c__14050__auto___19473,out))
);


return out;
});
merge = function(chs,buf_or_n){
switch(arguments.length){
case 1:
return merge__1.call(this,chs);
case 2:
return merge__2.call(this,chs,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
merge.cljs$core$IFn$_invoke$arity$1 = merge__1;
merge.cljs$core$IFn$_invoke$arity$2 = merge__2;
return merge;
})()
;
/**
* Returns a channel containing the single (collection) result of the
* items taken from the channel conjoined to the supplied
* collection. ch must close before into produces a result.
*/
cljs.core.async.into = (function into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
* Returns a channel that will return, at most, n items from ch. After n items
* have been returned, or ch has been closed, the return chanel will close.
* 
* The output channel is unbuffered by default, unless buf-or-n is given.
*/
cljs.core.async.take = (function() {
var take = null;
var take__2 = (function (n,ch){
return take.call(null,n,ch,null);
});
var take__3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14050__auto___19578 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14050__auto___19578,out){
return (function (){
var f__14051__auto__ = (function (){var switch__13994__auto__ = ((function (c__14050__auto___19578,out){
return (function (state_19555){
var state_val_19556 = (state_19555[(1)]);
if((state_val_19556 === (7))){
var inst_19537 = (state_19555[(7)]);
var inst_19537__$1 = (state_19555[(2)]);
var inst_19538 = (inst_19537__$1 == null);
var inst_19539 = cljs.core.not.call(null,inst_19538);
var state_19555__$1 = (function (){var statearr_19557 = state_19555;
(statearr_19557[(7)] = inst_19537__$1);

return statearr_19557;
})();
if(inst_19539){
var statearr_19558_19579 = state_19555__$1;
(statearr_19558_19579[(1)] = (8));

} else {
var statearr_19559_19580 = state_19555__$1;
(statearr_19559_19580[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19556 === (1))){
var inst_19532 = (0);
var state_19555__$1 = (function (){var statearr_19560 = state_19555;
(statearr_19560[(8)] = inst_19532);

return statearr_19560;
})();
var statearr_19561_19581 = state_19555__$1;
(statearr_19561_19581[(2)] = null);

(statearr_19561_19581[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19556 === (4))){
var state_19555__$1 = state_19555;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19555__$1,(7),ch);
} else {
if((state_val_19556 === (6))){
var inst_19550 = (state_19555[(2)]);
var state_19555__$1 = state_19555;
var statearr_19562_19582 = state_19555__$1;
(statearr_19562_19582[(2)] = inst_19550);

(statearr_19562_19582[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19556 === (3))){
var inst_19552 = (state_19555[(2)]);
var inst_19553 = cljs.core.async.close_BANG_.call(null,out);
var state_19555__$1 = (function (){var statearr_19563 = state_19555;
(statearr_19563[(9)] = inst_19552);

return statearr_19563;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19555__$1,inst_19553);
} else {
if((state_val_19556 === (2))){
var inst_19532 = (state_19555[(8)]);
var inst_19534 = (inst_19532 < n);
var state_19555__$1 = state_19555;
if(cljs.core.truth_(inst_19534)){
var statearr_19564_19583 = state_19555__$1;
(statearr_19564_19583[(1)] = (4));

} else {
var statearr_19565_19584 = state_19555__$1;
(statearr_19565_19584[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19556 === (11))){
var inst_19532 = (state_19555[(8)]);
var inst_19542 = (state_19555[(2)]);
var inst_19543 = (inst_19532 + (1));
var inst_19532__$1 = inst_19543;
var state_19555__$1 = (function (){var statearr_19566 = state_19555;
(statearr_19566[(10)] = inst_19542);

(statearr_19566[(8)] = inst_19532__$1);

return statearr_19566;
})();
var statearr_19567_19585 = state_19555__$1;
(statearr_19567_19585[(2)] = null);

(statearr_19567_19585[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19556 === (9))){
var state_19555__$1 = state_19555;
var statearr_19568_19586 = state_19555__$1;
(statearr_19568_19586[(2)] = null);

(statearr_19568_19586[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19556 === (5))){
var state_19555__$1 = state_19555;
var statearr_19569_19587 = state_19555__$1;
(statearr_19569_19587[(2)] = null);

(statearr_19569_19587[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19556 === (10))){
var inst_19547 = (state_19555[(2)]);
var state_19555__$1 = state_19555;
var statearr_19570_19588 = state_19555__$1;
(statearr_19570_19588[(2)] = inst_19547);

(statearr_19570_19588[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19556 === (8))){
var inst_19537 = (state_19555[(7)]);
var state_19555__$1 = state_19555;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19555__$1,(11),out,inst_19537);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14050__auto___19578,out))
;
return ((function (switch__13994__auto__,c__14050__auto___19578,out){
return (function() {
var state_machine__13995__auto__ = null;
var state_machine__13995__auto____0 = (function (){
var statearr_19574 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19574[(0)] = state_machine__13995__auto__);

(statearr_19574[(1)] = (1));

return statearr_19574;
});
var state_machine__13995__auto____1 = (function (state_19555){
while(true){
var ret_value__13996__auto__ = (function (){try{while(true){
var result__13997__auto__ = switch__13994__auto__.call(null,state_19555);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13997__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13997__auto__;
}
break;
}
}catch (e19575){if((e19575 instanceof Object)){
var ex__13998__auto__ = e19575;
var statearr_19576_19589 = state_19555;
(statearr_19576_19589[(5)] = ex__13998__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19555);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19575;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13996__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19590 = state_19555;
state_19555 = G__19590;
continue;
} else {
return ret_value__13996__auto__;
}
break;
}
});
state_machine__13995__auto__ = function(state_19555){
switch(arguments.length){
case 0:
return state_machine__13995__auto____0.call(this);
case 1:
return state_machine__13995__auto____1.call(this,state_19555);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__13995__auto____0;
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__13995__auto____1;
return state_machine__13995__auto__;
})()
;})(switch__13994__auto__,c__14050__auto___19578,out))
})();
var state__14052__auto__ = (function (){var statearr_19577 = f__14051__auto__.call(null);
(statearr_19577[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14050__auto___19578);

return statearr_19577;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14052__auto__);
});})(c__14050__auto___19578,out))
);


return out;
});
take = function(n,ch,buf_or_n){
switch(arguments.length){
case 2:
return take__2.call(this,n,ch);
case 3:
return take__3.call(this,n,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take.cljs$core$IFn$_invoke$arity$2 = take__2;
take.cljs$core$IFn$_invoke$arity$3 = take__3;
return take;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.map_LT_ = (function map_LT_(f,ch){
if(typeof cljs.core.async.t19598 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t19598 = (function (ch,f,map_LT_,meta19599){
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta19599 = meta19599;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t19598.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t19598.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t19598.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t19598.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t19601 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t19601 = (function (fn1,_,meta19599,map_LT_,f,ch,meta19602){
this.fn1 = fn1;
this._ = _;
this.meta19599 = meta19599;
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19602 = meta19602;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t19601.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t19601.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t19601.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__19591_SHARP_){
return f1.call(null,(((p1__19591_SHARP_ == null))?null:self__.f.call(null,p1__19591_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t19601.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_19603){
var self__ = this;
var _19603__$1 = this;
return self__.meta19602;
});})(___$1))
;

cljs.core.async.t19601.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_19603,meta19602__$1){
var self__ = this;
var _19603__$1 = this;
return (new cljs.core.async.t19601(self__.fn1,self__._,self__.meta19599,self__.map_LT_,self__.f,self__.ch,meta19602__$1));
});})(___$1))
;

cljs.core.async.t19601.cljs$lang$type = true;

cljs.core.async.t19601.cljs$lang$ctorStr = "cljs.core.async/t19601";

cljs.core.async.t19601.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write.call(null,writer__5690__auto__,"cljs.core.async/t19601");
});})(___$1))
;

cljs.core.async.__GT_t19601 = ((function (___$1){
return (function __GT_t19601(fn1__$1,___$2,meta19599__$1,map_LT___$1,f__$1,ch__$1,meta19602){
return (new cljs.core.async.t19601(fn1__$1,___$2,meta19599__$1,map_LT___$1,f__$1,ch__$1,meta19602));
});})(___$1))
;

}

return (new cljs.core.async.t19601(fn1,___$1,self__.meta19599,self__.map_LT_,self__.f,self__.ch,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__5090__auto__ = ret;
if(cljs.core.truth_(and__5090__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__5090__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t19598.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t19598.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t19598.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t19598.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19600){
var self__ = this;
var _19600__$1 = this;
return self__.meta19599;
});

cljs.core.async.t19598.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19600,meta19599__$1){
var self__ = this;
var _19600__$1 = this;
return (new cljs.core.async.t19598(self__.ch,self__.f,self__.map_LT_,meta19599__$1));
});

cljs.core.async.t19598.cljs$lang$type = true;

cljs.core.async.t19598.cljs$lang$ctorStr = "cljs.core.async/t19598";

cljs.core.async.t19598.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write.call(null,writer__5690__auto__,"cljs.core.async/t19598");
});

cljs.core.async.__GT_t19598 = (function __GT_t19598(ch__$1,f__$1,map_LT___$1,meta19599){
return (new cljs.core.async.t19598(ch__$1,f__$1,map_LT___$1,meta19599));
});

}

return (new cljs.core.async.t19598(ch,f,map_LT_,cljs.core.PersistentArrayMap.EMPTY));
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.map_GT_ = (function map_GT_(f,ch){
if(typeof cljs.core.async.t19607 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t19607 = (function (ch,f,map_GT_,meta19608){
this.ch = ch;
this.f = f;
this.map_GT_ = map_GT_;
this.meta19608 = meta19608;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t19607.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t19607.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t19607.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t19607.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t19607.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t19607.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t19607.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19609){
var self__ = this;
var _19609__$1 = this;
return self__.meta19608;
});

cljs.core.async.t19607.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19609,meta19608__$1){
var self__ = this;
var _19609__$1 = this;
return (new cljs.core.async.t19607(self__.ch,self__.f,self__.map_GT_,meta19608__$1));
});

cljs.core.async.t19607.cljs$lang$type = true;

cljs.core.async.t19607.cljs$lang$ctorStr = "cljs.core.async/t19607";

cljs.core.async.t19607.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write.call(null,writer__5690__auto__,"cljs.core.async/t19607");
});

cljs.core.async.__GT_t19607 = (function __GT_t19607(ch__$1,f__$1,map_GT___$1,meta19608){
return (new cljs.core.async.t19607(ch__$1,f__$1,map_GT___$1,meta19608));
});

}

return (new cljs.core.async.t19607(ch,f,map_GT_,cljs.core.PersistentArrayMap.EMPTY));
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.filter_GT_ = (function filter_GT_(p,ch){
if(typeof cljs.core.async.t19613 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t19613 = (function (ch,p,filter_GT_,meta19614){
this.ch = ch;
this.p = p;
this.filter_GT_ = filter_GT_;
this.meta19614 = meta19614;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t19613.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t19613.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t19613.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t19613.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t19613.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t19613.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t19613.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t19613.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19615){
var self__ = this;
var _19615__$1 = this;
return self__.meta19614;
});

cljs.core.async.t19613.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19615,meta19614__$1){
var self__ = this;
var _19615__$1 = this;
return (new cljs.core.async.t19613(self__.ch,self__.p,self__.filter_GT_,meta19614__$1));
});

cljs.core.async.t19613.cljs$lang$type = true;

cljs.core.async.t19613.cljs$lang$ctorStr = "cljs.core.async/t19613";

cljs.core.async.t19613.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write.call(null,writer__5690__auto__,"cljs.core.async/t19613");
});

cljs.core.async.__GT_t19613 = (function __GT_t19613(ch__$1,p__$1,filter_GT___$1,meta19614){
return (new cljs.core.async.t19613(ch__$1,p__$1,filter_GT___$1,meta19614));
});

}

return (new cljs.core.async.t19613(ch,p,filter_GT_,cljs.core.PersistentArrayMap.EMPTY));
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.remove_GT_ = (function remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.filter_LT_ = (function() {
var filter_LT_ = null;
var filter_LT___2 = (function (p,ch){
return filter_LT_.call(null,p,ch,null);
});
var filter_LT___3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14050__auto___19698 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14050__auto___19698,out){
return (function (){
var f__14051__auto__ = (function (){var switch__13994__auto__ = ((function (c__14050__auto___19698,out){
return (function (state_19677){
var state_val_19678 = (state_19677[(1)]);
if((state_val_19678 === (7))){
var inst_19673 = (state_19677[(2)]);
var state_19677__$1 = state_19677;
var statearr_19679_19699 = state_19677__$1;
(statearr_19679_19699[(2)] = inst_19673);

(statearr_19679_19699[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19678 === (1))){
var state_19677__$1 = state_19677;
var statearr_19680_19700 = state_19677__$1;
(statearr_19680_19700[(2)] = null);

(statearr_19680_19700[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19678 === (4))){
var inst_19659 = (state_19677[(7)]);
var inst_19659__$1 = (state_19677[(2)]);
var inst_19660 = (inst_19659__$1 == null);
var state_19677__$1 = (function (){var statearr_19681 = state_19677;
(statearr_19681[(7)] = inst_19659__$1);

return statearr_19681;
})();
if(cljs.core.truth_(inst_19660)){
var statearr_19682_19701 = state_19677__$1;
(statearr_19682_19701[(1)] = (5));

} else {
var statearr_19683_19702 = state_19677__$1;
(statearr_19683_19702[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19678 === (6))){
var inst_19659 = (state_19677[(7)]);
var inst_19664 = p.call(null,inst_19659);
var state_19677__$1 = state_19677;
if(cljs.core.truth_(inst_19664)){
var statearr_19684_19703 = state_19677__$1;
(statearr_19684_19703[(1)] = (8));

} else {
var statearr_19685_19704 = state_19677__$1;
(statearr_19685_19704[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19678 === (3))){
var inst_19675 = (state_19677[(2)]);
var state_19677__$1 = state_19677;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19677__$1,inst_19675);
} else {
if((state_val_19678 === (2))){
var state_19677__$1 = state_19677;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19677__$1,(4),ch);
} else {
if((state_val_19678 === (11))){
var inst_19667 = (state_19677[(2)]);
var state_19677__$1 = state_19677;
var statearr_19686_19705 = state_19677__$1;
(statearr_19686_19705[(2)] = inst_19667);

(statearr_19686_19705[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19678 === (9))){
var state_19677__$1 = state_19677;
var statearr_19687_19706 = state_19677__$1;
(statearr_19687_19706[(2)] = null);

(statearr_19687_19706[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19678 === (5))){
var inst_19662 = cljs.core.async.close_BANG_.call(null,out);
var state_19677__$1 = state_19677;
var statearr_19688_19707 = state_19677__$1;
(statearr_19688_19707[(2)] = inst_19662);

(statearr_19688_19707[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19678 === (10))){
var inst_19670 = (state_19677[(2)]);
var state_19677__$1 = (function (){var statearr_19689 = state_19677;
(statearr_19689[(8)] = inst_19670);

return statearr_19689;
})();
var statearr_19690_19708 = state_19677__$1;
(statearr_19690_19708[(2)] = null);

(statearr_19690_19708[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19678 === (8))){
var inst_19659 = (state_19677[(7)]);
var state_19677__$1 = state_19677;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19677__$1,(11),out,inst_19659);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14050__auto___19698,out))
;
return ((function (switch__13994__auto__,c__14050__auto___19698,out){
return (function() {
var state_machine__13995__auto__ = null;
var state_machine__13995__auto____0 = (function (){
var statearr_19694 = [null,null,null,null,null,null,null,null,null];
(statearr_19694[(0)] = state_machine__13995__auto__);

(statearr_19694[(1)] = (1));

return statearr_19694;
});
var state_machine__13995__auto____1 = (function (state_19677){
while(true){
var ret_value__13996__auto__ = (function (){try{while(true){
var result__13997__auto__ = switch__13994__auto__.call(null,state_19677);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13997__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13997__auto__;
}
break;
}
}catch (e19695){if((e19695 instanceof Object)){
var ex__13998__auto__ = e19695;
var statearr_19696_19709 = state_19677;
(statearr_19696_19709[(5)] = ex__13998__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19677);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19695;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13996__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19710 = state_19677;
state_19677 = G__19710;
continue;
} else {
return ret_value__13996__auto__;
}
break;
}
});
state_machine__13995__auto__ = function(state_19677){
switch(arguments.length){
case 0:
return state_machine__13995__auto____0.call(this);
case 1:
return state_machine__13995__auto____1.call(this,state_19677);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__13995__auto____0;
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__13995__auto____1;
return state_machine__13995__auto__;
})()
;})(switch__13994__auto__,c__14050__auto___19698,out))
})();
var state__14052__auto__ = (function (){var statearr_19697 = f__14051__auto__.call(null);
(statearr_19697[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14050__auto___19698);

return statearr_19697;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14052__auto__);
});})(c__14050__auto___19698,out))
);


return out;
});
filter_LT_ = function(p,ch,buf_or_n){
switch(arguments.length){
case 2:
return filter_LT___2.call(this,p,ch);
case 3:
return filter_LT___3.call(this,p,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
filter_LT_.cljs$core$IFn$_invoke$arity$2 = filter_LT___2;
filter_LT_.cljs$core$IFn$_invoke$arity$3 = filter_LT___3;
return filter_LT_;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.remove_LT_ = (function() {
var remove_LT_ = null;
var remove_LT___2 = (function (p,ch){
return remove_LT_.call(null,p,ch,null);
});
var remove_LT___3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});
remove_LT_ = function(p,ch,buf_or_n){
switch(arguments.length){
case 2:
return remove_LT___2.call(this,p,ch);
case 3:
return remove_LT___3.call(this,p,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
remove_LT_.cljs$core$IFn$_invoke$arity$2 = remove_LT___2;
remove_LT_.cljs$core$IFn$_invoke$arity$3 = remove_LT___3;
return remove_LT_;
})()
;
cljs.core.async.mapcat_STAR_ = (function mapcat_STAR_(f,in$,out){
var c__14050__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14050__auto__){
return (function (){
var f__14051__auto__ = (function (){var switch__13994__auto__ = ((function (c__14050__auto__){
return (function (state_19876){
var state_val_19877 = (state_19876[(1)]);
if((state_val_19877 === (7))){
var inst_19872 = (state_19876[(2)]);
var state_19876__$1 = state_19876;
var statearr_19878_19919 = state_19876__$1;
(statearr_19878_19919[(2)] = inst_19872);

(statearr_19878_19919[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19877 === (20))){
var inst_19842 = (state_19876[(7)]);
var inst_19853 = (state_19876[(2)]);
var inst_19854 = cljs.core.next.call(null,inst_19842);
var inst_19828 = inst_19854;
var inst_19829 = null;
var inst_19830 = (0);
var inst_19831 = (0);
var state_19876__$1 = (function (){var statearr_19879 = state_19876;
(statearr_19879[(8)] = inst_19853);

(statearr_19879[(9)] = inst_19828);

(statearr_19879[(10)] = inst_19829);

(statearr_19879[(11)] = inst_19831);

(statearr_19879[(12)] = inst_19830);

return statearr_19879;
})();
var statearr_19880_19920 = state_19876__$1;
(statearr_19880_19920[(2)] = null);

(statearr_19880_19920[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19877 === (1))){
var state_19876__$1 = state_19876;
var statearr_19881_19921 = state_19876__$1;
(statearr_19881_19921[(2)] = null);

(statearr_19881_19921[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19877 === (4))){
var inst_19817 = (state_19876[(13)]);
var inst_19817__$1 = (state_19876[(2)]);
var inst_19818 = (inst_19817__$1 == null);
var state_19876__$1 = (function (){var statearr_19882 = state_19876;
(statearr_19882[(13)] = inst_19817__$1);

return statearr_19882;
})();
if(cljs.core.truth_(inst_19818)){
var statearr_19883_19922 = state_19876__$1;
(statearr_19883_19922[(1)] = (5));

} else {
var statearr_19884_19923 = state_19876__$1;
(statearr_19884_19923[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19877 === (15))){
var state_19876__$1 = state_19876;
var statearr_19888_19924 = state_19876__$1;
(statearr_19888_19924[(2)] = null);

(statearr_19888_19924[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19877 === (21))){
var state_19876__$1 = state_19876;
var statearr_19889_19925 = state_19876__$1;
(statearr_19889_19925[(2)] = null);

(statearr_19889_19925[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19877 === (13))){
var inst_19828 = (state_19876[(9)]);
var inst_19829 = (state_19876[(10)]);
var inst_19831 = (state_19876[(11)]);
var inst_19830 = (state_19876[(12)]);
var inst_19838 = (state_19876[(2)]);
var inst_19839 = (inst_19831 + (1));
var tmp19885 = inst_19828;
var tmp19886 = inst_19829;
var tmp19887 = inst_19830;
var inst_19828__$1 = tmp19885;
var inst_19829__$1 = tmp19886;
var inst_19830__$1 = tmp19887;
var inst_19831__$1 = inst_19839;
var state_19876__$1 = (function (){var statearr_19890 = state_19876;
(statearr_19890[(9)] = inst_19828__$1);

(statearr_19890[(10)] = inst_19829__$1);

(statearr_19890[(14)] = inst_19838);

(statearr_19890[(11)] = inst_19831__$1);

(statearr_19890[(12)] = inst_19830__$1);

return statearr_19890;
})();
var statearr_19891_19926 = state_19876__$1;
(statearr_19891_19926[(2)] = null);

(statearr_19891_19926[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19877 === (22))){
var state_19876__$1 = state_19876;
var statearr_19892_19927 = state_19876__$1;
(statearr_19892_19927[(2)] = null);

(statearr_19892_19927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19877 === (6))){
var inst_19817 = (state_19876[(13)]);
var inst_19826 = f.call(null,inst_19817);
var inst_19827 = cljs.core.seq.call(null,inst_19826);
var inst_19828 = inst_19827;
var inst_19829 = null;
var inst_19830 = (0);
var inst_19831 = (0);
var state_19876__$1 = (function (){var statearr_19893 = state_19876;
(statearr_19893[(9)] = inst_19828);

(statearr_19893[(10)] = inst_19829);

(statearr_19893[(11)] = inst_19831);

(statearr_19893[(12)] = inst_19830);

return statearr_19893;
})();
var statearr_19894_19928 = state_19876__$1;
(statearr_19894_19928[(2)] = null);

(statearr_19894_19928[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19877 === (17))){
var inst_19842 = (state_19876[(7)]);
var inst_19846 = cljs.core.chunk_first.call(null,inst_19842);
var inst_19847 = cljs.core.chunk_rest.call(null,inst_19842);
var inst_19848 = cljs.core.count.call(null,inst_19846);
var inst_19828 = inst_19847;
var inst_19829 = inst_19846;
var inst_19830 = inst_19848;
var inst_19831 = (0);
var state_19876__$1 = (function (){var statearr_19895 = state_19876;
(statearr_19895[(9)] = inst_19828);

(statearr_19895[(10)] = inst_19829);

(statearr_19895[(11)] = inst_19831);

(statearr_19895[(12)] = inst_19830);

return statearr_19895;
})();
var statearr_19896_19929 = state_19876__$1;
(statearr_19896_19929[(2)] = null);

(statearr_19896_19929[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19877 === (3))){
var inst_19874 = (state_19876[(2)]);
var state_19876__$1 = state_19876;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19876__$1,inst_19874);
} else {
if((state_val_19877 === (12))){
var inst_19862 = (state_19876[(2)]);
var state_19876__$1 = state_19876;
var statearr_19897_19930 = state_19876__$1;
(statearr_19897_19930[(2)] = inst_19862);

(statearr_19897_19930[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19877 === (2))){
var state_19876__$1 = state_19876;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19876__$1,(4),in$);
} else {
if((state_val_19877 === (23))){
var inst_19870 = (state_19876[(2)]);
var state_19876__$1 = state_19876;
var statearr_19898_19931 = state_19876__$1;
(statearr_19898_19931[(2)] = inst_19870);

(statearr_19898_19931[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19877 === (19))){
var inst_19857 = (state_19876[(2)]);
var state_19876__$1 = state_19876;
var statearr_19899_19932 = state_19876__$1;
(statearr_19899_19932[(2)] = inst_19857);

(statearr_19899_19932[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19877 === (11))){
var inst_19842 = (state_19876[(7)]);
var inst_19828 = (state_19876[(9)]);
var inst_19842__$1 = cljs.core.seq.call(null,inst_19828);
var state_19876__$1 = (function (){var statearr_19900 = state_19876;
(statearr_19900[(7)] = inst_19842__$1);

return statearr_19900;
})();
if(inst_19842__$1){
var statearr_19901_19933 = state_19876__$1;
(statearr_19901_19933[(1)] = (14));

} else {
var statearr_19902_19934 = state_19876__$1;
(statearr_19902_19934[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19877 === (9))){
var inst_19864 = (state_19876[(2)]);
var inst_19865 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_19876__$1 = (function (){var statearr_19903 = state_19876;
(statearr_19903[(15)] = inst_19864);

return statearr_19903;
})();
if(cljs.core.truth_(inst_19865)){
var statearr_19904_19935 = state_19876__$1;
(statearr_19904_19935[(1)] = (21));

} else {
var statearr_19905_19936 = state_19876__$1;
(statearr_19905_19936[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19877 === (5))){
var inst_19820 = cljs.core.async.close_BANG_.call(null,out);
var state_19876__$1 = state_19876;
var statearr_19906_19937 = state_19876__$1;
(statearr_19906_19937[(2)] = inst_19820);

(statearr_19906_19937[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19877 === (14))){
var inst_19842 = (state_19876[(7)]);
var inst_19844 = cljs.core.chunked_seq_QMARK_.call(null,inst_19842);
var state_19876__$1 = state_19876;
if(inst_19844){
var statearr_19907_19938 = state_19876__$1;
(statearr_19907_19938[(1)] = (17));

} else {
var statearr_19908_19939 = state_19876__$1;
(statearr_19908_19939[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19877 === (16))){
var inst_19860 = (state_19876[(2)]);
var state_19876__$1 = state_19876;
var statearr_19909_19940 = state_19876__$1;
(statearr_19909_19940[(2)] = inst_19860);

(statearr_19909_19940[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19877 === (10))){
var inst_19829 = (state_19876[(10)]);
var inst_19831 = (state_19876[(11)]);
var inst_19836 = cljs.core._nth.call(null,inst_19829,inst_19831);
var state_19876__$1 = state_19876;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19876__$1,(13),out,inst_19836);
} else {
if((state_val_19877 === (18))){
var inst_19842 = (state_19876[(7)]);
var inst_19851 = cljs.core.first.call(null,inst_19842);
var state_19876__$1 = state_19876;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19876__$1,(20),out,inst_19851);
} else {
if((state_val_19877 === (8))){
var inst_19831 = (state_19876[(11)]);
var inst_19830 = (state_19876[(12)]);
var inst_19833 = (inst_19831 < inst_19830);
var inst_19834 = inst_19833;
var state_19876__$1 = state_19876;
if(cljs.core.truth_(inst_19834)){
var statearr_19910_19941 = state_19876__$1;
(statearr_19910_19941[(1)] = (10));

} else {
var statearr_19911_19942 = state_19876__$1;
(statearr_19911_19942[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14050__auto__))
;
return ((function (switch__13994__auto__,c__14050__auto__){
return (function() {
var state_machine__13995__auto__ = null;
var state_machine__13995__auto____0 = (function (){
var statearr_19915 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19915[(0)] = state_machine__13995__auto__);

(statearr_19915[(1)] = (1));

return statearr_19915;
});
var state_machine__13995__auto____1 = (function (state_19876){
while(true){
var ret_value__13996__auto__ = (function (){try{while(true){
var result__13997__auto__ = switch__13994__auto__.call(null,state_19876);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13997__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13997__auto__;
}
break;
}
}catch (e19916){if((e19916 instanceof Object)){
var ex__13998__auto__ = e19916;
var statearr_19917_19943 = state_19876;
(statearr_19917_19943[(5)] = ex__13998__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19876);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19916;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13996__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19944 = state_19876;
state_19876 = G__19944;
continue;
} else {
return ret_value__13996__auto__;
}
break;
}
});
state_machine__13995__auto__ = function(state_19876){
switch(arguments.length){
case 0:
return state_machine__13995__auto____0.call(this);
case 1:
return state_machine__13995__auto____1.call(this,state_19876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__13995__auto____0;
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__13995__auto____1;
return state_machine__13995__auto__;
})()
;})(switch__13994__auto__,c__14050__auto__))
})();
var state__14052__auto__ = (function (){var statearr_19918 = f__14051__auto__.call(null);
(statearr_19918[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14050__auto__);

return statearr_19918;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14052__auto__);
});})(c__14050__auto__))
);

return c__14050__auto__;
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.mapcat_LT_ = (function() {
var mapcat_LT_ = null;
var mapcat_LT___2 = (function (f,in$){
return mapcat_LT_.call(null,f,in$,null);
});
var mapcat_LT___3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});
mapcat_LT_ = function(f,in$,buf_or_n){
switch(arguments.length){
case 2:
return mapcat_LT___2.call(this,f,in$);
case 3:
return mapcat_LT___3.call(this,f,in$,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = mapcat_LT___2;
mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = mapcat_LT___3;
return mapcat_LT_;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.mapcat_GT_ = (function() {
var mapcat_GT_ = null;
var mapcat_GT___2 = (function (f,out){
return mapcat_GT_.call(null,f,out,null);
});
var mapcat_GT___3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});
mapcat_GT_ = function(f,out,buf_or_n){
switch(arguments.length){
case 2:
return mapcat_GT___2.call(this,f,out);
case 3:
return mapcat_GT___3.call(this,f,out,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = mapcat_GT___2;
mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = mapcat_GT___3;
return mapcat_GT_;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.unique = (function() {
var unique = null;
var unique__1 = (function (ch){
return unique.call(null,ch,null);
});
var unique__2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14050__auto___20041 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14050__auto___20041,out){
return (function (){
var f__14051__auto__ = (function (){var switch__13994__auto__ = ((function (c__14050__auto___20041,out){
return (function (state_20016){
var state_val_20017 = (state_20016[(1)]);
if((state_val_20017 === (7))){
var inst_20011 = (state_20016[(2)]);
var state_20016__$1 = state_20016;
var statearr_20018_20042 = state_20016__$1;
(statearr_20018_20042[(2)] = inst_20011);

(statearr_20018_20042[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20017 === (1))){
var inst_19993 = null;
var state_20016__$1 = (function (){var statearr_20019 = state_20016;
(statearr_20019[(7)] = inst_19993);

return statearr_20019;
})();
var statearr_20020_20043 = state_20016__$1;
(statearr_20020_20043[(2)] = null);

(statearr_20020_20043[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20017 === (4))){
var inst_19996 = (state_20016[(8)]);
var inst_19996__$1 = (state_20016[(2)]);
var inst_19997 = (inst_19996__$1 == null);
var inst_19998 = cljs.core.not.call(null,inst_19997);
var state_20016__$1 = (function (){var statearr_20021 = state_20016;
(statearr_20021[(8)] = inst_19996__$1);

return statearr_20021;
})();
if(inst_19998){
var statearr_20022_20044 = state_20016__$1;
(statearr_20022_20044[(1)] = (5));

} else {
var statearr_20023_20045 = state_20016__$1;
(statearr_20023_20045[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20017 === (6))){
var state_20016__$1 = state_20016;
var statearr_20024_20046 = state_20016__$1;
(statearr_20024_20046[(2)] = null);

(statearr_20024_20046[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20017 === (3))){
var inst_20013 = (state_20016[(2)]);
var inst_20014 = cljs.core.async.close_BANG_.call(null,out);
var state_20016__$1 = (function (){var statearr_20025 = state_20016;
(statearr_20025[(9)] = inst_20013);

return statearr_20025;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20016__$1,inst_20014);
} else {
if((state_val_20017 === (2))){
var state_20016__$1 = state_20016;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20016__$1,(4),ch);
} else {
if((state_val_20017 === (11))){
var inst_19996 = (state_20016[(8)]);
var inst_20005 = (state_20016[(2)]);
var inst_19993 = inst_19996;
var state_20016__$1 = (function (){var statearr_20026 = state_20016;
(statearr_20026[(7)] = inst_19993);

(statearr_20026[(10)] = inst_20005);

return statearr_20026;
})();
var statearr_20027_20047 = state_20016__$1;
(statearr_20027_20047[(2)] = null);

(statearr_20027_20047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20017 === (9))){
var inst_19996 = (state_20016[(8)]);
var state_20016__$1 = state_20016;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20016__$1,(11),out,inst_19996);
} else {
if((state_val_20017 === (5))){
var inst_19996 = (state_20016[(8)]);
var inst_19993 = (state_20016[(7)]);
var inst_20000 = cljs.core._EQ_.call(null,inst_19996,inst_19993);
var state_20016__$1 = state_20016;
if(inst_20000){
var statearr_20029_20048 = state_20016__$1;
(statearr_20029_20048[(1)] = (8));

} else {
var statearr_20030_20049 = state_20016__$1;
(statearr_20030_20049[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20017 === (10))){
var inst_20008 = (state_20016[(2)]);
var state_20016__$1 = state_20016;
var statearr_20031_20050 = state_20016__$1;
(statearr_20031_20050[(2)] = inst_20008);

(statearr_20031_20050[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20017 === (8))){
var inst_19993 = (state_20016[(7)]);
var tmp20028 = inst_19993;
var inst_19993__$1 = tmp20028;
var state_20016__$1 = (function (){var statearr_20032 = state_20016;
(statearr_20032[(7)] = inst_19993__$1);

return statearr_20032;
})();
var statearr_20033_20051 = state_20016__$1;
(statearr_20033_20051[(2)] = null);

(statearr_20033_20051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14050__auto___20041,out))
;
return ((function (switch__13994__auto__,c__14050__auto___20041,out){
return (function() {
var state_machine__13995__auto__ = null;
var state_machine__13995__auto____0 = (function (){
var statearr_20037 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20037[(0)] = state_machine__13995__auto__);

(statearr_20037[(1)] = (1));

return statearr_20037;
});
var state_machine__13995__auto____1 = (function (state_20016){
while(true){
var ret_value__13996__auto__ = (function (){try{while(true){
var result__13997__auto__ = switch__13994__auto__.call(null,state_20016);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13997__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13997__auto__;
}
break;
}
}catch (e20038){if((e20038 instanceof Object)){
var ex__13998__auto__ = e20038;
var statearr_20039_20052 = state_20016;
(statearr_20039_20052[(5)] = ex__13998__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20016);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20038;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13996__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20053 = state_20016;
state_20016 = G__20053;
continue;
} else {
return ret_value__13996__auto__;
}
break;
}
});
state_machine__13995__auto__ = function(state_20016){
switch(arguments.length){
case 0:
return state_machine__13995__auto____0.call(this);
case 1:
return state_machine__13995__auto____1.call(this,state_20016);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__13995__auto____0;
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__13995__auto____1;
return state_machine__13995__auto__;
})()
;})(switch__13994__auto__,c__14050__auto___20041,out))
})();
var state__14052__auto__ = (function (){var statearr_20040 = f__14051__auto__.call(null);
(statearr_20040[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14050__auto___20041);

return statearr_20040;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14052__auto__);
});})(c__14050__auto___20041,out))
);


return out;
});
unique = function(ch,buf_or_n){
switch(arguments.length){
case 1:
return unique__1.call(this,ch);
case 2:
return unique__2.call(this,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unique.cljs$core$IFn$_invoke$arity$1 = unique__1;
unique.cljs$core$IFn$_invoke$arity$2 = unique__2;
return unique;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.partition = (function() {
var partition = null;
var partition__2 = (function (n,ch){
return partition.call(null,n,ch,null);
});
var partition__3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14050__auto___20188 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14050__auto___20188,out){
return (function (){
var f__14051__auto__ = (function (){var switch__13994__auto__ = ((function (c__14050__auto___20188,out){
return (function (state_20158){
var state_val_20159 = (state_20158[(1)]);
if((state_val_20159 === (7))){
var inst_20154 = (state_20158[(2)]);
var state_20158__$1 = state_20158;
var statearr_20160_20189 = state_20158__$1;
(statearr_20160_20189[(2)] = inst_20154);

(statearr_20160_20189[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20159 === (1))){
var inst_20121 = (new Array(n));
var inst_20122 = inst_20121;
var inst_20123 = (0);
var state_20158__$1 = (function (){var statearr_20161 = state_20158;
(statearr_20161[(7)] = inst_20122);

(statearr_20161[(8)] = inst_20123);

return statearr_20161;
})();
var statearr_20162_20190 = state_20158__$1;
(statearr_20162_20190[(2)] = null);

(statearr_20162_20190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20159 === (4))){
var inst_20126 = (state_20158[(9)]);
var inst_20126__$1 = (state_20158[(2)]);
var inst_20127 = (inst_20126__$1 == null);
var inst_20128 = cljs.core.not.call(null,inst_20127);
var state_20158__$1 = (function (){var statearr_20163 = state_20158;
(statearr_20163[(9)] = inst_20126__$1);

return statearr_20163;
})();
if(inst_20128){
var statearr_20164_20191 = state_20158__$1;
(statearr_20164_20191[(1)] = (5));

} else {
var statearr_20165_20192 = state_20158__$1;
(statearr_20165_20192[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20159 === (15))){
var inst_20148 = (state_20158[(2)]);
var state_20158__$1 = state_20158;
var statearr_20166_20193 = state_20158__$1;
(statearr_20166_20193[(2)] = inst_20148);

(statearr_20166_20193[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20159 === (13))){
var state_20158__$1 = state_20158;
var statearr_20167_20194 = state_20158__$1;
(statearr_20167_20194[(2)] = null);

(statearr_20167_20194[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20159 === (6))){
var inst_20123 = (state_20158[(8)]);
var inst_20144 = (inst_20123 > (0));
var state_20158__$1 = state_20158;
if(cljs.core.truth_(inst_20144)){
var statearr_20168_20195 = state_20158__$1;
(statearr_20168_20195[(1)] = (12));

} else {
var statearr_20169_20196 = state_20158__$1;
(statearr_20169_20196[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20159 === (3))){
var inst_20156 = (state_20158[(2)]);
var state_20158__$1 = state_20158;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20158__$1,inst_20156);
} else {
if((state_val_20159 === (12))){
var inst_20122 = (state_20158[(7)]);
var inst_20146 = cljs.core.vec.call(null,inst_20122);
var state_20158__$1 = state_20158;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20158__$1,(15),out,inst_20146);
} else {
if((state_val_20159 === (2))){
var state_20158__$1 = state_20158;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20158__$1,(4),ch);
} else {
if((state_val_20159 === (11))){
var inst_20138 = (state_20158[(2)]);
var inst_20139 = (new Array(n));
var inst_20122 = inst_20139;
var inst_20123 = (0);
var state_20158__$1 = (function (){var statearr_20170 = state_20158;
(statearr_20170[(10)] = inst_20138);

(statearr_20170[(7)] = inst_20122);

(statearr_20170[(8)] = inst_20123);

return statearr_20170;
})();
var statearr_20171_20197 = state_20158__$1;
(statearr_20171_20197[(2)] = null);

(statearr_20171_20197[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20159 === (9))){
var inst_20122 = (state_20158[(7)]);
var inst_20136 = cljs.core.vec.call(null,inst_20122);
var state_20158__$1 = state_20158;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20158__$1,(11),out,inst_20136);
} else {
if((state_val_20159 === (5))){
var inst_20122 = (state_20158[(7)]);
var inst_20126 = (state_20158[(9)]);
var inst_20131 = (state_20158[(11)]);
var inst_20123 = (state_20158[(8)]);
var inst_20130 = (inst_20122[inst_20123] = inst_20126);
var inst_20131__$1 = (inst_20123 + (1));
var inst_20132 = (inst_20131__$1 < n);
var state_20158__$1 = (function (){var statearr_20172 = state_20158;
(statearr_20172[(12)] = inst_20130);

(statearr_20172[(11)] = inst_20131__$1);

return statearr_20172;
})();
if(cljs.core.truth_(inst_20132)){
var statearr_20173_20198 = state_20158__$1;
(statearr_20173_20198[(1)] = (8));

} else {
var statearr_20174_20199 = state_20158__$1;
(statearr_20174_20199[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20159 === (14))){
var inst_20151 = (state_20158[(2)]);
var inst_20152 = cljs.core.async.close_BANG_.call(null,out);
var state_20158__$1 = (function (){var statearr_20176 = state_20158;
(statearr_20176[(13)] = inst_20151);

return statearr_20176;
})();
var statearr_20177_20200 = state_20158__$1;
(statearr_20177_20200[(2)] = inst_20152);

(statearr_20177_20200[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20159 === (10))){
var inst_20142 = (state_20158[(2)]);
var state_20158__$1 = state_20158;
var statearr_20178_20201 = state_20158__$1;
(statearr_20178_20201[(2)] = inst_20142);

(statearr_20178_20201[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20159 === (8))){
var inst_20122 = (state_20158[(7)]);
var inst_20131 = (state_20158[(11)]);
var tmp20175 = inst_20122;
var inst_20122__$1 = tmp20175;
var inst_20123 = inst_20131;
var state_20158__$1 = (function (){var statearr_20179 = state_20158;
(statearr_20179[(7)] = inst_20122__$1);

(statearr_20179[(8)] = inst_20123);

return statearr_20179;
})();
var statearr_20180_20202 = state_20158__$1;
(statearr_20180_20202[(2)] = null);

(statearr_20180_20202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14050__auto___20188,out))
;
return ((function (switch__13994__auto__,c__14050__auto___20188,out){
return (function() {
var state_machine__13995__auto__ = null;
var state_machine__13995__auto____0 = (function (){
var statearr_20184 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20184[(0)] = state_machine__13995__auto__);

(statearr_20184[(1)] = (1));

return statearr_20184;
});
var state_machine__13995__auto____1 = (function (state_20158){
while(true){
var ret_value__13996__auto__ = (function (){try{while(true){
var result__13997__auto__ = switch__13994__auto__.call(null,state_20158);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13997__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13997__auto__;
}
break;
}
}catch (e20185){if((e20185 instanceof Object)){
var ex__13998__auto__ = e20185;
var statearr_20186_20203 = state_20158;
(statearr_20186_20203[(5)] = ex__13998__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20158);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20185;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13996__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20204 = state_20158;
state_20158 = G__20204;
continue;
} else {
return ret_value__13996__auto__;
}
break;
}
});
state_machine__13995__auto__ = function(state_20158){
switch(arguments.length){
case 0:
return state_machine__13995__auto____0.call(this);
case 1:
return state_machine__13995__auto____1.call(this,state_20158);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__13995__auto____0;
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__13995__auto____1;
return state_machine__13995__auto__;
})()
;})(switch__13994__auto__,c__14050__auto___20188,out))
})();
var state__14052__auto__ = (function (){var statearr_20187 = f__14051__auto__.call(null);
(statearr_20187[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14050__auto___20188);

return statearr_20187;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14052__auto__);
});})(c__14050__auto___20188,out))
);


return out;
});
partition = function(n,ch,buf_or_n){
switch(arguments.length){
case 2:
return partition__2.call(this,n,ch);
case 3:
return partition__3.call(this,n,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition.cljs$core$IFn$_invoke$arity$2 = partition__2;
partition.cljs$core$IFn$_invoke$arity$3 = partition__3;
return partition;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.partition_by = (function() {
var partition_by = null;
var partition_by__2 = (function (f,ch){
return partition_by.call(null,f,ch,null);
});
var partition_by__3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__14050__auto___20347 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__14050__auto___20347,out){
return (function (){
var f__14051__auto__ = (function (){var switch__13994__auto__ = ((function (c__14050__auto___20347,out){
return (function (state_20317){
var state_val_20318 = (state_20317[(1)]);
if((state_val_20318 === (7))){
var inst_20313 = (state_20317[(2)]);
var state_20317__$1 = state_20317;
var statearr_20319_20348 = state_20317__$1;
(statearr_20319_20348[(2)] = inst_20313);

(statearr_20319_20348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (1))){
var inst_20276 = [];
var inst_20277 = inst_20276;
var inst_20278 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_20317__$1 = (function (){var statearr_20320 = state_20317;
(statearr_20320[(7)] = inst_20277);

(statearr_20320[(8)] = inst_20278);

return statearr_20320;
})();
var statearr_20321_20349 = state_20317__$1;
(statearr_20321_20349[(2)] = null);

(statearr_20321_20349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (4))){
var inst_20281 = (state_20317[(9)]);
var inst_20281__$1 = (state_20317[(2)]);
var inst_20282 = (inst_20281__$1 == null);
var inst_20283 = cljs.core.not.call(null,inst_20282);
var state_20317__$1 = (function (){var statearr_20322 = state_20317;
(statearr_20322[(9)] = inst_20281__$1);

return statearr_20322;
})();
if(inst_20283){
var statearr_20323_20350 = state_20317__$1;
(statearr_20323_20350[(1)] = (5));

} else {
var statearr_20324_20351 = state_20317__$1;
(statearr_20324_20351[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (15))){
var inst_20307 = (state_20317[(2)]);
var state_20317__$1 = state_20317;
var statearr_20325_20352 = state_20317__$1;
(statearr_20325_20352[(2)] = inst_20307);

(statearr_20325_20352[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (13))){
var state_20317__$1 = state_20317;
var statearr_20326_20353 = state_20317__$1;
(statearr_20326_20353[(2)] = null);

(statearr_20326_20353[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (6))){
var inst_20277 = (state_20317[(7)]);
var inst_20302 = inst_20277.length;
var inst_20303 = (inst_20302 > (0));
var state_20317__$1 = state_20317;
if(cljs.core.truth_(inst_20303)){
var statearr_20327_20354 = state_20317__$1;
(statearr_20327_20354[(1)] = (12));

} else {
var statearr_20328_20355 = state_20317__$1;
(statearr_20328_20355[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (3))){
var inst_20315 = (state_20317[(2)]);
var state_20317__$1 = state_20317;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20317__$1,inst_20315);
} else {
if((state_val_20318 === (12))){
var inst_20277 = (state_20317[(7)]);
var inst_20305 = cljs.core.vec.call(null,inst_20277);
var state_20317__$1 = state_20317;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20317__$1,(15),out,inst_20305);
} else {
if((state_val_20318 === (2))){
var state_20317__$1 = state_20317;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20317__$1,(4),ch);
} else {
if((state_val_20318 === (11))){
var inst_20285 = (state_20317[(10)]);
var inst_20281 = (state_20317[(9)]);
var inst_20295 = (state_20317[(2)]);
var inst_20296 = [];
var inst_20297 = inst_20296.push(inst_20281);
var inst_20277 = inst_20296;
var inst_20278 = inst_20285;
var state_20317__$1 = (function (){var statearr_20329 = state_20317;
(statearr_20329[(11)] = inst_20295);

(statearr_20329[(12)] = inst_20297);

(statearr_20329[(7)] = inst_20277);

(statearr_20329[(8)] = inst_20278);

return statearr_20329;
})();
var statearr_20330_20356 = state_20317__$1;
(statearr_20330_20356[(2)] = null);

(statearr_20330_20356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (9))){
var inst_20277 = (state_20317[(7)]);
var inst_20293 = cljs.core.vec.call(null,inst_20277);
var state_20317__$1 = state_20317;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20317__$1,(11),out,inst_20293);
} else {
if((state_val_20318 === (5))){
var inst_20285 = (state_20317[(10)]);
var inst_20278 = (state_20317[(8)]);
var inst_20281 = (state_20317[(9)]);
var inst_20285__$1 = f.call(null,inst_20281);
var inst_20286 = cljs.core._EQ_.call(null,inst_20285__$1,inst_20278);
var inst_20287 = cljs.core.keyword_identical_QMARK_.call(null,inst_20278,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_20288 = (inst_20286) || (inst_20287);
var state_20317__$1 = (function (){var statearr_20331 = state_20317;
(statearr_20331[(10)] = inst_20285__$1);

return statearr_20331;
})();
if(cljs.core.truth_(inst_20288)){
var statearr_20332_20357 = state_20317__$1;
(statearr_20332_20357[(1)] = (8));

} else {
var statearr_20333_20358 = state_20317__$1;
(statearr_20333_20358[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (14))){
var inst_20310 = (state_20317[(2)]);
var inst_20311 = cljs.core.async.close_BANG_.call(null,out);
var state_20317__$1 = (function (){var statearr_20335 = state_20317;
(statearr_20335[(13)] = inst_20310);

return statearr_20335;
})();
var statearr_20336_20359 = state_20317__$1;
(statearr_20336_20359[(2)] = inst_20311);

(statearr_20336_20359[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (10))){
var inst_20300 = (state_20317[(2)]);
var state_20317__$1 = state_20317;
var statearr_20337_20360 = state_20317__$1;
(statearr_20337_20360[(2)] = inst_20300);

(statearr_20337_20360[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (8))){
var inst_20285 = (state_20317[(10)]);
var inst_20277 = (state_20317[(7)]);
var inst_20281 = (state_20317[(9)]);
var inst_20290 = inst_20277.push(inst_20281);
var tmp20334 = inst_20277;
var inst_20277__$1 = tmp20334;
var inst_20278 = inst_20285;
var state_20317__$1 = (function (){var statearr_20338 = state_20317;
(statearr_20338[(7)] = inst_20277__$1);

(statearr_20338[(14)] = inst_20290);

(statearr_20338[(8)] = inst_20278);

return statearr_20338;
})();
var statearr_20339_20361 = state_20317__$1;
(statearr_20339_20361[(2)] = null);

(statearr_20339_20361[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14050__auto___20347,out))
;
return ((function (switch__13994__auto__,c__14050__auto___20347,out){
return (function() {
var state_machine__13995__auto__ = null;
var state_machine__13995__auto____0 = (function (){
var statearr_20343 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20343[(0)] = state_machine__13995__auto__);

(statearr_20343[(1)] = (1));

return statearr_20343;
});
var state_machine__13995__auto____1 = (function (state_20317){
while(true){
var ret_value__13996__auto__ = (function (){try{while(true){
var result__13997__auto__ = switch__13994__auto__.call(null,state_20317);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13997__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13997__auto__;
}
break;
}
}catch (e20344){if((e20344 instanceof Object)){
var ex__13998__auto__ = e20344;
var statearr_20345_20362 = state_20317;
(statearr_20345_20362[(5)] = ex__13998__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20317);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20344;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13996__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20363 = state_20317;
state_20317 = G__20363;
continue;
} else {
return ret_value__13996__auto__;
}
break;
}
});
state_machine__13995__auto__ = function(state_20317){
switch(arguments.length){
case 0:
return state_machine__13995__auto____0.call(this);
case 1:
return state_machine__13995__auto____1.call(this,state_20317);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__13995__auto____0;
state_machine__13995__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__13995__auto____1;
return state_machine__13995__auto__;
})()
;})(switch__13994__auto__,c__14050__auto___20347,out))
})();
var state__14052__auto__ = (function (){var statearr_20346 = f__14051__auto__.call(null);
(statearr_20346[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14050__auto___20347);

return statearr_20346;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__14052__auto__);
});})(c__14050__auto___20347,out))
);


return out;
});
partition_by = function(f,ch,buf_or_n){
switch(arguments.length){
case 2:
return partition_by__2.call(this,f,ch);
case 3:
return partition_by__3.call(this,f,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition_by.cljs$core$IFn$_invoke$arity$2 = partition_by__2;
partition_by.cljs$core$IFn$_invoke$arity$3 = partition_by__3;
return partition_by;
})()
;

//# sourceMappingURL=async.js.map