// Compiled by ClojureScript 0.0-2816 {:target :nodejs, :static-fns true}
goog.provide('cljs.core');
goog.require('goog.string.StringBuffer');
goog.require('goog.array');
goog.require('goog.object');
goog.require('goog.string');
cljs.core._STAR_clojurescript_version_STAR_ = "0.0-2816";
cljs.core._STAR_unchecked_if_STAR_ = false;
if(typeof cljs.core._STAR_print_fn_STAR_ !== 'undefined'){
} else {
/**
* Each runtime environment provides a different way to print output.
* Whatever function *print-fn* is bound to will be passed any
* Strings which should be printed.
*/
cljs.core._STAR_print_fn_STAR_ = (function _STAR_print_fn_STAR_(_){
throw (new Error("No *print-fn* fn set for evaluation environment"));
});
}
/**
* Set *print-fn* to f.
*/
cljs.core.set_print_fn_BANG_ = (function set_print_fn_BANG_(f){
return cljs.core._STAR_print_fn_STAR_ = f;
});
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core._STAR_print_length_STAR_ = null;
cljs.core._STAR_print_level_STAR_ = null;
if(typeof cljs.core._STAR_loaded_libs_STAR_ !== 'undefined'){
} else {
cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = (function pr_opts(){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939),cljs.core._STAR_flush_on_newline_STAR_,new cljs.core.Keyword(null,"readably","readably",1129599760),cljs.core._STAR_print_readably_STAR_,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core._STAR_print_meta_STAR_,new cljs.core.Keyword(null,"dup","dup",556298533),cljs.core._STAR_print_dup_STAR_,new cljs.core.Keyword(null,"print-length","print-length",1931866356),cljs.core._STAR_print_length_STAR_], null);
});
/**
* Set *print-fn* to console.log
*/
cljs.core.enable_console_print_BANG_ = (function enable_console_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

return cljs.core._STAR_print_fn_STAR_ = (function() { 
var G__6603__delegate = function (args){
return console.log.apply(console,(function (){var G__6602 = args;
return (cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(G__6602) : cljs.core.into_array.call(null,G__6602));
})());
};
var G__6603 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__6604__i = 0, G__6604__a = new Array(arguments.length -  0);
while (G__6604__i < G__6604__a.length) {G__6604__a[G__6604__i] = arguments[G__6604__i + 0]; ++G__6604__i;}
  args = new cljs.core.IndexedSeq(G__6604__a,0);
} 
return G__6603__delegate.call(this,args);};
G__6603.cljs$lang$maxFixedArity = 0;
G__6603.cljs$lang$applyTo = (function (arglist__6605){
var args = cljs.core.seq(arglist__6605);
return G__6603__delegate(args);
});
G__6603.cljs$core$IFn$_invoke$arity$variadic = G__6603__delegate;
return G__6603;
})()
;
});
/**
* Internal - do not use!
*/
cljs.core.truth_ = (function truth_(x){
return (x != null && x !== false);
});
cljs.core.not_native = null;

/**
* Tests if 2 arguments are the same object
*/
cljs.core.identical_QMARK_ = (function identical_QMARK_(x,y){
return (x === y);
});
/**
* Returns true if x is nil, false otherwise.
*/
cljs.core.nil_QMARK_ = (function nil_QMARK_(x){
return (x == null);
});
cljs.core.array_QMARK_ = (function array_QMARK_(x){
return Array.isArray(x);
});
cljs.core.number_QMARK_ = (function number_QMARK_(n){
return typeof n === 'number';
});
/**
* Returns true if x is logical false, false otherwise.
*/
cljs.core.not = (function not(x){
if(cljs.core.truth_(x)){
return false;
} else {
return true;
}
});
/**
* Returns true if x is not nil, false otherwise.
*/
cljs.core.some_QMARK_ = (function some_QMARK_(x){
return !((x == null));
});
cljs.core.object_QMARK_ = (function object_QMARK_(x){
if(!((x == null))){
return (x.constructor === Object);
} else {
return false;
}
});
cljs.core.string_QMARK_ = (function string_QMARK_(x){
var G__6607 = x;
return goog.isString(G__6607);
});
/**
* Internal - do not use!
*/
cljs.core.native_satisfies_QMARK_ = (function native_satisfies_QMARK_(p,x){
var x__$1 = (((x == null))?null:x);
if((p[(function (){var G__6609 = x__$1;
return goog.typeOf(G__6609);
})()])){
return true;
} else {
if((p["_"])){
return true;
} else {
return false;

}
}
});
cljs.core.is_proto_ = (function is_proto_(x){
return (x.constructor.prototype === x);
});
/**
* When compiled for a command-line target, whatever
* function *main-fn* is set to will be called with the command-line
* argv as arguments
*/
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.type = (function type(x){
if((x == null)){
return null;
} else {
return x.constructor;
}
});
cljs.core.missing_protocol = (function missing_protocol(proto,obj){
var ty = cljs.core.type(obj);
var ty__$1 = (cljs.core.truth_((function (){var and__5090__auto__ = ty;
if(cljs.core.truth_(and__5090__auto__)){
return ty.cljs$lang$type;
} else {
return and__5090__auto__;
}
})())?ty.cljs$lang$ctorStr:(function (){var G__6611 = obj;
return goog.typeOf(G__6611);
})());
return (new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join("")));
});
cljs.core.type__GT_str = (function type__GT_str(ty){
var temp__4124__auto__ = ty.cljs$lang$ctorStr;
if(cljs.core.truth_(temp__4124__auto__)){
var s = temp__4124__auto__;
return s;
} else {
return [cljs.core.str(ty)].join('');
}
});
cljs.core.load_file = (function load_file(file){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
return goog.nodeGlobalRequire([cljs.core.str("resources/public/js/out"),cljs.core.str("/"),cljs.core.str(file)].join(''));
}
});
if((typeof Symbol !== 'undefined') && (((function (){var G__6613 = Symbol;
return goog.typeOf(G__6613);
})() === "function"))){
cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
cljs.core.ITER_SYMBOL = "@@iterator";
}
cljs.core.make_array = (function() {
var make_array = null;
var make_array__1 = (function (size){
return (new Array(size));
});
var make_array__2 = (function (type,size){
return make_array.cljs$core$IFn$_invoke$arity$1(size);
});
make_array = function(type,size){
switch(arguments.length){
case 1:
return make_array__1.call(this,type);
case 2:
return make_array__2.call(this,type,size);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
make_array.cljs$core$IFn$_invoke$arity$1 = make_array__1;
make_array.cljs$core$IFn$_invoke$arity$2 = make_array__2;
return make_array;
})()
;
/**
* Returns a javascript array, cloned from the passed in array
*/
cljs.core.aclone = (function aclone(arr){
var len = arr.length;
var new_arr = (new Array(len));
var n__5989__auto___6615 = len;
var i_6616 = (0);
while(true){
if((i_6616 < n__5989__auto___6615)){
(new_arr[i_6616] = (arr[i_6616]));

var G__6617 = (i_6616 + (1));
i_6616 = G__6617;
continue;
} else {
}
break;
}

return new_arr;
});
/**
* Creates a new javascript array.
* @param {...*} var_args
*/
cljs.core.array = (function array(var_args){
var a = (new Array(arguments.length));
var i = (0);
while(true){
if((i < a.length)){
(a[i] = (arguments[i]));

var G__6618 = (i + (1));
i = G__6618;
continue;
} else {
return a;
}
break;
}
});
/**
* Returns the value at the index.
* @param {...*} var_args
*/
cljs.core.aget = (function() {
var aget = null;
var aget__2 = (function (array,i){
return (array[i]);
});
var aget__3 = (function() { 
var G__6627__delegate = function (array,i,idxs){
var G__6624 = aget;
var G__6625 = aget.cljs$core$IFn$_invoke$arity$2(array,i);
var G__6626 = idxs;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__6624,G__6625,G__6626) : cljs.core.apply.call(null,G__6624,G__6625,G__6626));
};
var G__6627 = function (array,i,var_args){
var idxs = null;
if (arguments.length > 2) {
var G__6628__i = 0, G__6628__a = new Array(arguments.length -  2);
while (G__6628__i < G__6628__a.length) {G__6628__a[G__6628__i] = arguments[G__6628__i + 2]; ++G__6628__i;}
  idxs = new cljs.core.IndexedSeq(G__6628__a,0);
} 
return G__6627__delegate.call(this,array,i,idxs);};
G__6627.cljs$lang$maxFixedArity = 2;
G__6627.cljs$lang$applyTo = (function (arglist__6629){
var array = cljs.core.first(arglist__6629);
arglist__6629 = cljs.core.next(arglist__6629);
var i = cljs.core.first(arglist__6629);
var idxs = cljs.core.rest(arglist__6629);
return G__6627__delegate(array,i,idxs);
});
G__6627.cljs$core$IFn$_invoke$arity$variadic = G__6627__delegate;
return G__6627;
})()
;
aget = function(array,i,var_args){
var idxs = var_args;
switch(arguments.length){
case 2:
return aget__2.call(this,array,i);
default:
var G__6630 = null;
if (arguments.length > 2) {
var G__6631__i = 0, G__6631__a = new Array(arguments.length -  2);
while (G__6631__i < G__6631__a.length) {G__6631__a[G__6631__i] = arguments[G__6631__i + 2]; ++G__6631__i;}
G__6630 = new cljs.core.IndexedSeq(G__6631__a,0);
}
return aget__3.cljs$core$IFn$_invoke$arity$variadic(array,i, G__6630);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
aget.cljs$lang$maxFixedArity = 2;
aget.cljs$lang$applyTo = aget__3.cljs$lang$applyTo;
aget.cljs$core$IFn$_invoke$arity$2 = aget__2;
aget.cljs$core$IFn$_invoke$arity$variadic = aget__3.cljs$core$IFn$_invoke$arity$variadic;
return aget;
})()
;
/**
* Sets the value at the index.
* @param {...*} var_args
*/
cljs.core.aset = (function() {
var aset = null;
var aset__3 = (function (array,i,val){
return (array[i] = val);
});
var aset__4 = (function() { 
var G__6640__delegate = function (array,idx,idx2,idxv){
var G__6636 = aset;
var G__6637 = (array[idx]);
var G__6638 = idx2;
var G__6639 = idxv;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__6636,G__6637,G__6638,G__6639) : cljs.core.apply.call(null,G__6636,G__6637,G__6638,G__6639));
};
var G__6640 = function (array,idx,idx2,var_args){
var idxv = null;
if (arguments.length > 3) {
var G__6641__i = 0, G__6641__a = new Array(arguments.length -  3);
while (G__6641__i < G__6641__a.length) {G__6641__a[G__6641__i] = arguments[G__6641__i + 3]; ++G__6641__i;}
  idxv = new cljs.core.IndexedSeq(G__6641__a,0);
} 
return G__6640__delegate.call(this,array,idx,idx2,idxv);};
G__6640.cljs$lang$maxFixedArity = 3;
G__6640.cljs$lang$applyTo = (function (arglist__6642){
var array = cljs.core.first(arglist__6642);
arglist__6642 = cljs.core.next(arglist__6642);
var idx = cljs.core.first(arglist__6642);
arglist__6642 = cljs.core.next(arglist__6642);
var idx2 = cljs.core.first(arglist__6642);
var idxv = cljs.core.rest(arglist__6642);
return G__6640__delegate(array,idx,idx2,idxv);
});
G__6640.cljs$core$IFn$_invoke$arity$variadic = G__6640__delegate;
return G__6640;
})()
;
aset = function(array,idx,idx2,var_args){
var idxv = var_args;
switch(arguments.length){
case 3:
return aset__3.call(this,array,idx,idx2);
default:
var G__6643 = null;
if (arguments.length > 3) {
var G__6644__i = 0, G__6644__a = new Array(arguments.length -  3);
while (G__6644__i < G__6644__a.length) {G__6644__a[G__6644__i] = arguments[G__6644__i + 3]; ++G__6644__i;}
G__6643 = new cljs.core.IndexedSeq(G__6644__a,0);
}
return aset__4.cljs$core$IFn$_invoke$arity$variadic(array,idx,idx2, G__6643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
aset.cljs$lang$maxFixedArity = 3;
aset.cljs$lang$applyTo = aset__4.cljs$lang$applyTo;
aset.cljs$core$IFn$_invoke$arity$3 = aset__3;
aset.cljs$core$IFn$_invoke$arity$variadic = aset__4.cljs$core$IFn$_invoke$arity$variadic;
return aset;
})()
;
/**
* Returns the length of the array. Works on arrays of all types.
*/
cljs.core.alength = (function alength(array){
return array.length;
});
cljs.core.into_array = (function() {
var into_array = null;
var into_array__1 = (function (aseq){
return into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);
});
var into_array__2 = (function (type,aseq){
var G__6650 = (function (a,x){
a.push(x);

return a;
});
var G__6651 = [];
var G__6652 = aseq;
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__6650,G__6651,G__6652) : cljs.core.reduce.call(null,G__6650,G__6651,G__6652));
});
into_array = function(type,aseq){
switch(arguments.length){
case 1:
return into_array__1.call(this,type);
case 2:
return into_array__2.call(this,type,aseq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
into_array.cljs$core$IFn$_invoke$arity$1 = into_array__1;
into_array.cljs$core$IFn$_invoke$arity$2 = into_array__2;
return into_array;
})()
;
/**
* Invoke JavaScript object method via string. Needed when the
* string is not a valid unquoted property name.
* @param {...*} var_args
*/
cljs.core.js_invoke = (function() { 
var js_invoke__delegate = function (obj,s,args){
return (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
};
var js_invoke = function (obj,s,var_args){
var args = null;
if (arguments.length > 2) {
var G__6653__i = 0, G__6653__a = new Array(arguments.length -  2);
while (G__6653__i < G__6653__a.length) {G__6653__a[G__6653__i] = arguments[G__6653__i + 2]; ++G__6653__i;}
  args = new cljs.core.IndexedSeq(G__6653__a,0);
} 
return js_invoke__delegate.call(this,obj,s,args);};
js_invoke.cljs$lang$maxFixedArity = 2;
js_invoke.cljs$lang$applyTo = (function (arglist__6654){
var obj = cljs.core.first(arglist__6654);
arglist__6654 = cljs.core.next(arglist__6654);
var s = cljs.core.first(arglist__6654);
var args = cljs.core.rest(arglist__6654);
return js_invoke__delegate(obj,s,args);
});
js_invoke.cljs$core$IFn$_invoke$arity$variadic = js_invoke__delegate;
return js_invoke;
})()
;

cljs.core.Fn = (function (){var obj6656 = {};
return obj6656;
})();


cljs.core.IFn = (function (){var obj6658 = {};
return obj6658;
})();

cljs.core._invoke = (function() {
var _invoke = null;
var _invoke__1 = (function (this$){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IFn$_invoke$arity$1;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._invoke[(function (){var G__6704 = x__5746__auto__;
return goog.typeOf(G__6704);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._invoke["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$);
}
});
var _invoke__2 = (function (this$,a){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IFn$_invoke$arity$2;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._invoke[(function (){var G__6706 = x__5746__auto__;
return goog.typeOf(G__6706);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._invoke["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a);
}
});
var _invoke__3 = (function (this$,a,b){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IFn$_invoke$arity$3;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._invoke[(function (){var G__6708 = x__5746__auto__;
return goog.typeOf(G__6708);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._invoke["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b);
}
});
var _invoke__4 = (function (this$,a,b,c){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IFn$_invoke$arity$4;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._invoke[(function (){var G__6710 = x__5746__auto__;
return goog.typeOf(G__6710);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._invoke["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c);
}
});
var _invoke__5 = (function (this$,a,b,c,d){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IFn$_invoke$arity$5;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._invoke[(function (){var G__6712 = x__5746__auto__;
return goog.typeOf(G__6712);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._invoke["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d);
}
});
var _invoke__6 = (function (this$,a,b,c,d,e){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IFn$_invoke$arity$6;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._invoke[(function (){var G__6714 = x__5746__auto__;
return goog.typeOf(G__6714);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._invoke["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e);
}
});
var _invoke__7 = (function (this$,a,b,c,d,e,f){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IFn$_invoke$arity$7;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._invoke[(function (){var G__6716 = x__5746__auto__;
return goog.typeOf(G__6716);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._invoke["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f);
}
});
var _invoke__8 = (function (this$,a,b,c,d,e,f,g){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IFn$_invoke$arity$8;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._invoke[(function (){var G__6718 = x__5746__auto__;
return goog.typeOf(G__6718);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._invoke["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g);
}
});
var _invoke__9 = (function (this$,a,b,c,d,e,f,g,h){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IFn$_invoke$arity$9;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._invoke[(function (){var G__6720 = x__5746__auto__;
return goog.typeOf(G__6720);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._invoke["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h);
}
});
var _invoke__10 = (function (this$,a,b,c,d,e,f,g,h,i){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IFn$_invoke$arity$10;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._invoke[(function (){var G__6722 = x__5746__auto__;
return goog.typeOf(G__6722);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._invoke["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i);
}
});
var _invoke__11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IFn$_invoke$arity$11;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._invoke[(function (){var G__6724 = x__5746__auto__;
return goog.typeOf(G__6724);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._invoke["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j);
}
});
var _invoke__12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IFn$_invoke$arity$12;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._invoke[(function (){var G__6726 = x__5746__auto__;
return goog.typeOf(G__6726);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._invoke["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k);
}
});
var _invoke__13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IFn$_invoke$arity$13;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._invoke[(function (){var G__6728 = x__5746__auto__;
return goog.typeOf(G__6728);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._invoke["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l);
}
});
var _invoke__14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IFn$_invoke$arity$14;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._invoke[(function (){var G__6730 = x__5746__auto__;
return goog.typeOf(G__6730);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._invoke["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
}
});
var _invoke__15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IFn$_invoke$arity$15;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._invoke[(function (){var G__6732 = x__5746__auto__;
return goog.typeOf(G__6732);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._invoke["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}
});
var _invoke__16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IFn$_invoke$arity$16;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._invoke[(function (){var G__6734 = x__5746__auto__;
return goog.typeOf(G__6734);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._invoke["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
}
});
var _invoke__17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IFn$_invoke$arity$17;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._invoke[(function (){var G__6736 = x__5746__auto__;
return goog.typeOf(G__6736);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._invoke["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
}
});
var _invoke__18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IFn$_invoke$arity$18;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._invoke[(function (){var G__6738 = x__5746__auto__;
return goog.typeOf(G__6738);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._invoke["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
}
});
var _invoke__19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IFn$_invoke$arity$19;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._invoke[(function (){var G__6740 = x__5746__auto__;
return goog.typeOf(G__6740);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._invoke["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
}
});
var _invoke__20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IFn$_invoke$arity$20;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._invoke[(function (){var G__6742 = x__5746__auto__;
return goog.typeOf(G__6742);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._invoke["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
}
});
var _invoke__21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IFn$_invoke$arity$21;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._invoke[(function (){var G__6744 = x__5746__auto__;
return goog.typeOf(G__6744);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._invoke["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
}
});
var _invoke__22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IFn$_invoke$arity$22;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._invoke[(function (){var G__6746 = x__5746__auto__;
return goog.typeOf(G__6746);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._invoke["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
});
_invoke = function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return _invoke__1.call(this,this$);
case 2:
return _invoke__2.call(this,this$,a);
case 3:
return _invoke__3.call(this,this$,a,b);
case 4:
return _invoke__4.call(this,this$,a,b,c);
case 5:
return _invoke__5.call(this,this$,a,b,c,d);
case 6:
return _invoke__6.call(this,this$,a,b,c,d,e);
case 7:
return _invoke__7.call(this,this$,a,b,c,d,e,f);
case 8:
return _invoke__8.call(this,this$,a,b,c,d,e,f,g);
case 9:
return _invoke__9.call(this,this$,a,b,c,d,e,f,g,h);
case 10:
return _invoke__10.call(this,this$,a,b,c,d,e,f,g,h,i);
case 11:
return _invoke__11.call(this,this$,a,b,c,d,e,f,g,h,i,j);
case 12:
return _invoke__12.call(this,this$,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return _invoke__13.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return _invoke__14.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return _invoke__15.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return _invoke__16.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return _invoke__17.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return _invoke__18.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return _invoke__19.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return _invoke__20.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return _invoke__21.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return _invoke__22.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_invoke.cljs$core$IFn$_invoke$arity$1 = _invoke__1;
_invoke.cljs$core$IFn$_invoke$arity$2 = _invoke__2;
_invoke.cljs$core$IFn$_invoke$arity$3 = _invoke__3;
_invoke.cljs$core$IFn$_invoke$arity$4 = _invoke__4;
_invoke.cljs$core$IFn$_invoke$arity$5 = _invoke__5;
_invoke.cljs$core$IFn$_invoke$arity$6 = _invoke__6;
_invoke.cljs$core$IFn$_invoke$arity$7 = _invoke__7;
_invoke.cljs$core$IFn$_invoke$arity$8 = _invoke__8;
_invoke.cljs$core$IFn$_invoke$arity$9 = _invoke__9;
_invoke.cljs$core$IFn$_invoke$arity$10 = _invoke__10;
_invoke.cljs$core$IFn$_invoke$arity$11 = _invoke__11;
_invoke.cljs$core$IFn$_invoke$arity$12 = _invoke__12;
_invoke.cljs$core$IFn$_invoke$arity$13 = _invoke__13;
_invoke.cljs$core$IFn$_invoke$arity$14 = _invoke__14;
_invoke.cljs$core$IFn$_invoke$arity$15 = _invoke__15;
_invoke.cljs$core$IFn$_invoke$arity$16 = _invoke__16;
_invoke.cljs$core$IFn$_invoke$arity$17 = _invoke__17;
_invoke.cljs$core$IFn$_invoke$arity$18 = _invoke__18;
_invoke.cljs$core$IFn$_invoke$arity$19 = _invoke__19;
_invoke.cljs$core$IFn$_invoke$arity$20 = _invoke__20;
_invoke.cljs$core$IFn$_invoke$arity$21 = _invoke__21;
_invoke.cljs$core$IFn$_invoke$arity$22 = _invoke__22;
return _invoke;
})()
;


cljs.core.ICloneable = (function (){var obj6748 = {};
return obj6748;
})();

cljs.core._clone = (function _clone(value){
if((function (){var and__5090__auto__ = value;
if(and__5090__auto__){
return value.cljs$core$ICloneable$_clone$arity$1;
} else {
return and__5090__auto__;
}
})()){
return value.cljs$core$ICloneable$_clone$arity$1(value);
} else {
var x__5746__auto__ = (((value == null))?null:value);
return (function (){var or__5102__auto__ = (cljs.core._clone[(function (){var G__6752 = x__5746__auto__;
return goog.typeOf(G__6752);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._clone["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("ICloneable.-clone",value);
}
}
})().call(null,value);
}
});


cljs.core.ICounted = (function (){var obj6754 = {};
return obj6754;
})();

cljs.core._count = (function _count(coll){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$ICounted$_count$arity$1;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$ICounted$_count$arity$1(coll);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._count[(function (){var G__6758 = x__5746__auto__;
return goog.typeOf(G__6758);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._count["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("ICounted.-count",coll);
}
}
})().call(null,coll);
}
});


cljs.core.IEmptyableCollection = (function (){var obj6760 = {};
return obj6760;
})();

cljs.core._empty = (function _empty(coll){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._empty[(function (){var G__6764 = x__5746__auto__;
return goog.typeOf(G__6764);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._empty["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IEmptyableCollection.-empty",coll);
}
}
})().call(null,coll);
}
});


cljs.core.ICollection = (function (){var obj6766 = {};
return obj6766;
})();

cljs.core._conj = (function _conj(coll,o){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$ICollection$_conj$arity$2;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._conj[(function (){var G__6770 = x__5746__auto__;
return goog.typeOf(G__6770);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._conj["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("ICollection.-conj",coll);
}
}
})().call(null,coll,o);
}
});


cljs.core.IIndexed = (function (){var obj6772 = {};
return obj6772;
})();

cljs.core._nth = (function() {
var _nth = null;
var _nth__2 = (function (coll,n){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$IIndexed$_nth$arity$2;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._nth[(function (){var G__6778 = x__5746__auto__;
return goog.typeOf(G__6778);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._nth["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
})().call(null,coll,n);
}
});
var _nth__3 = (function (coll,n,not_found){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$IIndexed$_nth$arity$3;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._nth[(function (){var G__6780 = x__5746__auto__;
return goog.typeOf(G__6780);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._nth["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
})().call(null,coll,n,not_found);
}
});
_nth = function(coll,n,not_found){
switch(arguments.length){
case 2:
return _nth__2.call(this,coll,n);
case 3:
return _nth__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_nth.cljs$core$IFn$_invoke$arity$2 = _nth__2;
_nth.cljs$core$IFn$_invoke$arity$3 = _nth__3;
return _nth;
})()
;


cljs.core.ASeq = (function (){var obj6782 = {};
return obj6782;
})();


cljs.core.ISeq = (function (){var obj6784 = {};
return obj6784;
})();

cljs.core._first = (function _first(coll){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$ISeq$_first$arity$1;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$ISeq$_first$arity$1(coll);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._first[(function (){var G__6788 = x__5746__auto__;
return goog.typeOf(G__6788);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._first["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeq.-first",coll);
}
}
})().call(null,coll);
}
});

cljs.core._rest = (function _rest(coll){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$ISeq$_rest$arity$1;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._rest[(function (){var G__6792 = x__5746__auto__;
return goog.typeOf(G__6792);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._rest["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeq.-rest",coll);
}
}
})().call(null,coll);
}
});


cljs.core.INext = (function (){var obj6794 = {};
return obj6794;
})();

cljs.core._next = (function _next(coll){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$INext$_next$arity$1;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$INext$_next$arity$1(coll);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._next[(function (){var G__6798 = x__5746__auto__;
return goog.typeOf(G__6798);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._next["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("INext.-next",coll);
}
}
})().call(null,coll);
}
});


cljs.core.ILookup = (function (){var obj6800 = {};
return obj6800;
})();

cljs.core._lookup = (function() {
var _lookup = null;
var _lookup__2 = (function (o,k){
if((function (){var and__5090__auto__ = o;
if(and__5090__auto__){
return o.cljs$core$ILookup$_lookup$arity$2;
} else {
return and__5090__auto__;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else {
var x__5746__auto__ = (((o == null))?null:o);
return (function (){var or__5102__auto__ = (cljs.core._lookup[(function (){var G__6806 = x__5746__auto__;
return goog.typeOf(G__6806);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._lookup["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
})().call(null,o,k);
}
});
var _lookup__3 = (function (o,k,not_found){
if((function (){var and__5090__auto__ = o;
if(and__5090__auto__){
return o.cljs$core$ILookup$_lookup$arity$3;
} else {
return and__5090__auto__;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else {
var x__5746__auto__ = (((o == null))?null:o);
return (function (){var or__5102__auto__ = (cljs.core._lookup[(function (){var G__6808 = x__5746__auto__;
return goog.typeOf(G__6808);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._lookup["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
})().call(null,o,k,not_found);
}
});
_lookup = function(o,k,not_found){
switch(arguments.length){
case 2:
return _lookup__2.call(this,o,k);
case 3:
return _lookup__3.call(this,o,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_lookup.cljs$core$IFn$_invoke$arity$2 = _lookup__2;
_lookup.cljs$core$IFn$_invoke$arity$3 = _lookup__3;
return _lookup;
})()
;


cljs.core.IAssociative = (function (){var obj6810 = {};
return obj6810;
})();

cljs.core._contains_key_QMARK_ = (function _contains_key_QMARK_(coll,k){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._contains_key_QMARK_[(function (){var G__6814 = x__5746__auto__;
return goog.typeOf(G__6814);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._contains_key_QMARK_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IAssociative.-contains-key?",coll);
}
}
})().call(null,coll,k);
}
});

cljs.core._assoc = (function _assoc(coll,k,v){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$IAssociative$_assoc$arity$3;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._assoc[(function (){var G__6818 = x__5746__auto__;
return goog.typeOf(G__6818);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._assoc["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IAssociative.-assoc",coll);
}
}
})().call(null,coll,k,v);
}
});


cljs.core.IMap = (function (){var obj6820 = {};
return obj6820;
})();

cljs.core._dissoc = (function _dissoc(coll,k){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$IMap$_dissoc$arity$2;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._dissoc[(function (){var G__6824 = x__5746__auto__;
return goog.typeOf(G__6824);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._dissoc["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IMap.-dissoc",coll);
}
}
})().call(null,coll,k);
}
});


cljs.core.IMapEntry = (function (){var obj6826 = {};
return obj6826;
})();

cljs.core._key = (function _key(coll){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$IMapEntry$_key$arity$1;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._key[(function (){var G__6830 = x__5746__auto__;
return goog.typeOf(G__6830);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._key["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IMapEntry.-key",coll);
}
}
})().call(null,coll);
}
});

cljs.core._val = (function _val(coll){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$IMapEntry$_val$arity$1;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._val[(function (){var G__6834 = x__5746__auto__;
return goog.typeOf(G__6834);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._val["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IMapEntry.-val",coll);
}
}
})().call(null,coll);
}
});


cljs.core.ISet = (function (){var obj6836 = {};
return obj6836;
})();

cljs.core._disjoin = (function _disjoin(coll,v){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$ISet$_disjoin$arity$2;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._disjoin[(function (){var G__6840 = x__5746__auto__;
return goog.typeOf(G__6840);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._disjoin["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("ISet.-disjoin",coll);
}
}
})().call(null,coll,v);
}
});


cljs.core.IStack = (function (){var obj6842 = {};
return obj6842;
})();

cljs.core._peek = (function _peek(coll){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$IStack$_peek$arity$1;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$IStack$_peek$arity$1(coll);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._peek[(function (){var G__6846 = x__5746__auto__;
return goog.typeOf(G__6846);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._peek["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IStack.-peek",coll);
}
}
})().call(null,coll);
}
});

cljs.core._pop = (function _pop(coll){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$IStack$_pop$arity$1;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$IStack$_pop$arity$1(coll);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._pop[(function (){var G__6850 = x__5746__auto__;
return goog.typeOf(G__6850);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._pop["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IStack.-pop",coll);
}
}
})().call(null,coll);
}
});


cljs.core.IVector = (function (){var obj6852 = {};
return obj6852;
})();

cljs.core._assoc_n = (function _assoc_n(coll,n,val){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$IVector$_assoc_n$arity$3;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._assoc_n[(function (){var G__6856 = x__5746__auto__;
return goog.typeOf(G__6856);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._assoc_n["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IVector.-assoc-n",coll);
}
}
})().call(null,coll,n,val);
}
});


cljs.core.IDeref = (function (){var obj6858 = {};
return obj6858;
})();

cljs.core._deref = (function _deref(o){
if((function (){var and__5090__auto__ = o;
if(and__5090__auto__){
return o.cljs$core$IDeref$_deref$arity$1;
} else {
return and__5090__auto__;
}
})()){
return o.cljs$core$IDeref$_deref$arity$1(o);
} else {
var x__5746__auto__ = (((o == null))?null:o);
return (function (){var or__5102__auto__ = (cljs.core._deref[(function (){var G__6862 = x__5746__auto__;
return goog.typeOf(G__6862);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._deref["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IDeref.-deref",o);
}
}
})().call(null,o);
}
});


cljs.core.IDerefWithTimeout = (function (){var obj6864 = {};
return obj6864;
})();

cljs.core._deref_with_timeout = (function _deref_with_timeout(o,msec,timeout_val){
if((function (){var and__5090__auto__ = o;
if(and__5090__auto__){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3;
} else {
return and__5090__auto__;
}
})()){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else {
var x__5746__auto__ = (((o == null))?null:o);
return (function (){var or__5102__auto__ = (cljs.core._deref_with_timeout[(function (){var G__6868 = x__5746__auto__;
return goog.typeOf(G__6868);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._deref_with_timeout["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout",o);
}
}
})().call(null,o,msec,timeout_val);
}
});


cljs.core.IMeta = (function (){var obj6870 = {};
return obj6870;
})();

cljs.core._meta = (function _meta(o){
if((function (){var and__5090__auto__ = o;
if(and__5090__auto__){
return o.cljs$core$IMeta$_meta$arity$1;
} else {
return and__5090__auto__;
}
})()){
return o.cljs$core$IMeta$_meta$arity$1(o);
} else {
var x__5746__auto__ = (((o == null))?null:o);
return (function (){var or__5102__auto__ = (cljs.core._meta[(function (){var G__6874 = x__5746__auto__;
return goog.typeOf(G__6874);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._meta["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IMeta.-meta",o);
}
}
})().call(null,o);
}
});


cljs.core.IWithMeta = (function (){var obj6876 = {};
return obj6876;
})();

cljs.core._with_meta = (function _with_meta(o,meta){
if((function (){var and__5090__auto__ = o;
if(and__5090__auto__){
return o.cljs$core$IWithMeta$_with_meta$arity$2;
} else {
return and__5090__auto__;
}
})()){
return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else {
var x__5746__auto__ = (((o == null))?null:o);
return (function (){var or__5102__auto__ = (cljs.core._with_meta[(function (){var G__6880 = x__5746__auto__;
return goog.typeOf(G__6880);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._with_meta["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IWithMeta.-with-meta",o);
}
}
})().call(null,o,meta);
}
});


cljs.core.IReduce = (function (){var obj6882 = {};
return obj6882;
})();

cljs.core._reduce = (function() {
var _reduce = null;
var _reduce__2 = (function (coll,f){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$IReduce$_reduce$arity$2;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._reduce[(function (){var G__6888 = x__5746__auto__;
return goog.typeOf(G__6888);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._reduce["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
})().call(null,coll,f);
}
});
var _reduce__3 = (function (coll,f,start){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$IReduce$_reduce$arity$3;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._reduce[(function (){var G__6890 = x__5746__auto__;
return goog.typeOf(G__6890);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._reduce["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
})().call(null,coll,f,start);
}
});
_reduce = function(coll,f,start){
switch(arguments.length){
case 2:
return _reduce__2.call(this,coll,f);
case 3:
return _reduce__3.call(this,coll,f,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_reduce.cljs$core$IFn$_invoke$arity$2 = _reduce__2;
_reduce.cljs$core$IFn$_invoke$arity$3 = _reduce__3;
return _reduce;
})()
;


cljs.core.IKVReduce = (function (){var obj6892 = {};
return obj6892;
})();

cljs.core._kv_reduce = (function _kv_reduce(coll,f,init){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._kv_reduce[(function (){var G__6896 = x__5746__auto__;
return goog.typeOf(G__6896);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._kv_reduce["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IKVReduce.-kv-reduce",coll);
}
}
})().call(null,coll,f,init);
}
});


cljs.core.IEquiv = (function (){var obj6898 = {};
return obj6898;
})();

cljs.core._equiv = (function _equiv(o,other){
if((function (){var and__5090__auto__ = o;
if(and__5090__auto__){
return o.cljs$core$IEquiv$_equiv$arity$2;
} else {
return and__5090__auto__;
}
})()){
return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else {
var x__5746__auto__ = (((o == null))?null:o);
return (function (){var or__5102__auto__ = (cljs.core._equiv[(function (){var G__6902 = x__5746__auto__;
return goog.typeOf(G__6902);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._equiv["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IEquiv.-equiv",o);
}
}
})().call(null,o,other);
}
});


cljs.core.IHash = (function (){var obj6904 = {};
return obj6904;
})();

cljs.core._hash = (function _hash(o){
if((function (){var and__5090__auto__ = o;
if(and__5090__auto__){
return o.cljs$core$IHash$_hash$arity$1;
} else {
return and__5090__auto__;
}
})()){
return o.cljs$core$IHash$_hash$arity$1(o);
} else {
var x__5746__auto__ = (((o == null))?null:o);
return (function (){var or__5102__auto__ = (cljs.core._hash[(function (){var G__6908 = x__5746__auto__;
return goog.typeOf(G__6908);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._hash["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IHash.-hash",o);
}
}
})().call(null,o);
}
});


cljs.core.ISeqable = (function (){var obj6910 = {};
return obj6910;
})();

cljs.core._seq = (function _seq(o){
if((function (){var and__5090__auto__ = o;
if(and__5090__auto__){
return o.cljs$core$ISeqable$_seq$arity$1;
} else {
return and__5090__auto__;
}
})()){
return o.cljs$core$ISeqable$_seq$arity$1(o);
} else {
var x__5746__auto__ = (((o == null))?null:o);
return (function (){var or__5102__auto__ = (cljs.core._seq[(function (){var G__6914 = x__5746__auto__;
return goog.typeOf(G__6914);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._seq["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeqable.-seq",o);
}
}
})().call(null,o);
}
});


cljs.core.ISequential = (function (){var obj6916 = {};
return obj6916;
})();


cljs.core.IList = (function (){var obj6918 = {};
return obj6918;
})();


cljs.core.IRecord = (function (){var obj6920 = {};
return obj6920;
})();


cljs.core.IReversible = (function (){var obj6922 = {};
return obj6922;
})();

cljs.core._rseq = (function _rseq(coll){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$IReversible$_rseq$arity$1;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._rseq[(function (){var G__6926 = x__5746__auto__;
return goog.typeOf(G__6926);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._rseq["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IReversible.-rseq",coll);
}
}
})().call(null,coll);
}
});


cljs.core.ISorted = (function (){var obj6928 = {};
return obj6928;
})();

cljs.core._sorted_seq = (function _sorted_seq(coll,ascending_QMARK_){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$ISorted$_sorted_seq$arity$2;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._sorted_seq[(function (){var G__6932 = x__5746__auto__;
return goog.typeOf(G__6932);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._sorted_seq["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq",coll);
}
}
})().call(null,coll,ascending_QMARK_);
}
});

cljs.core._sorted_seq_from = (function _sorted_seq_from(coll,k,ascending_QMARK_){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._sorted_seq_from[(function (){var G__6936 = x__5746__auto__;
return goog.typeOf(G__6936);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._sorted_seq_from["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq-from",coll);
}
}
})().call(null,coll,k,ascending_QMARK_);
}
});

cljs.core._entry_key = (function _entry_key(coll,entry){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$ISorted$_entry_key$arity$2;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._entry_key[(function (){var G__6940 = x__5746__auto__;
return goog.typeOf(G__6940);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._entry_key["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-entry-key",coll);
}
}
})().call(null,coll,entry);
}
});

cljs.core._comparator = (function _comparator(coll){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$ISorted$_comparator$arity$1;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._comparator[(function (){var G__6944 = x__5746__auto__;
return goog.typeOf(G__6944);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._comparator["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-comparator",coll);
}
}
})().call(null,coll);
}
});


cljs.core.IWriter = (function (){var obj6946 = {};
return obj6946;
})();

cljs.core._write = (function _write(writer,s){
if((function (){var and__5090__auto__ = writer;
if(and__5090__auto__){
return writer.cljs$core$IWriter$_write$arity$2;
} else {
return and__5090__auto__;
}
})()){
return writer.cljs$core$IWriter$_write$arity$2(writer,s);
} else {
var x__5746__auto__ = (((writer == null))?null:writer);
return (function (){var or__5102__auto__ = (cljs.core._write[(function (){var G__6950 = x__5746__auto__;
return goog.typeOf(G__6950);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._write["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IWriter.-write",writer);
}
}
})().call(null,writer,s);
}
});

cljs.core._flush = (function _flush(writer){
if((function (){var and__5090__auto__ = writer;
if(and__5090__auto__){
return writer.cljs$core$IWriter$_flush$arity$1;
} else {
return and__5090__auto__;
}
})()){
return writer.cljs$core$IWriter$_flush$arity$1(writer);
} else {
var x__5746__auto__ = (((writer == null))?null:writer);
return (function (){var or__5102__auto__ = (cljs.core._flush[(function (){var G__6954 = x__5746__auto__;
return goog.typeOf(G__6954);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._flush["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IWriter.-flush",writer);
}
}
})().call(null,writer);
}
});


cljs.core.IPrintWithWriter = (function (){var obj6956 = {};
return obj6956;
})();

cljs.core._pr_writer = (function _pr_writer(o,writer,opts){
if((function (){var and__5090__auto__ = o;
if(and__5090__auto__){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3;
} else {
return and__5090__auto__;
}
})()){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);
} else {
var x__5746__auto__ = (((o == null))?null:o);
return (function (){var or__5102__auto__ = (cljs.core._pr_writer[(function (){var G__6960 = x__5746__auto__;
return goog.typeOf(G__6960);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._pr_writer["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer",o);
}
}
})().call(null,o,writer,opts);
}
});


cljs.core.IPending = (function (){var obj6962 = {};
return obj6962;
})();

cljs.core._realized_QMARK_ = (function _realized_QMARK_(d){
if((function (){var and__5090__auto__ = d;
if(and__5090__auto__){
return d.cljs$core$IPending$_realized_QMARK_$arity$1;
} else {
return and__5090__auto__;
}
})()){
return d.cljs$core$IPending$_realized_QMARK_$arity$1(d);
} else {
var x__5746__auto__ = (((d == null))?null:d);
return (function (){var or__5102__auto__ = (cljs.core._realized_QMARK_[(function (){var G__6966 = x__5746__auto__;
return goog.typeOf(G__6966);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._realized_QMARK_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IPending.-realized?",d);
}
}
})().call(null,d);
}
});


cljs.core.IWatchable = (function (){var obj6968 = {};
return obj6968;
})();

cljs.core._notify_watches = (function _notify_watches(this$,oldval,newval){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IWatchable$_notify_watches$arity$3;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._notify_watches[(function (){var G__6972 = x__5746__auto__;
return goog.typeOf(G__6972);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._notify_watches["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-notify-watches",this$);
}
}
})().call(null,this$,oldval,newval);
}
});

cljs.core._add_watch = (function _add_watch(this$,key,f){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IWatchable$_add_watch$arity$3;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._add_watch[(function (){var G__6976 = x__5746__auto__;
return goog.typeOf(G__6976);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._add_watch["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-add-watch",this$);
}
}
})().call(null,this$,key,f);
}
});

cljs.core._remove_watch = (function _remove_watch(this$,key){
if((function (){var and__5090__auto__ = this$;
if(and__5090__auto__){
return this$.cljs$core$IWatchable$_remove_watch$arity$2;
} else {
return and__5090__auto__;
}
})()){
return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else {
var x__5746__auto__ = (((this$ == null))?null:this$);
return (function (){var or__5102__auto__ = (cljs.core._remove_watch[(function (){var G__6980 = x__5746__auto__;
return goog.typeOf(G__6980);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._remove_watch["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-remove-watch",this$);
}
}
})().call(null,this$,key);
}
});


cljs.core.IEditableCollection = (function (){var obj6982 = {};
return obj6982;
})();

cljs.core._as_transient = (function _as_transient(coll){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._as_transient[(function (){var G__6986 = x__5746__auto__;
return goog.typeOf(G__6986);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._as_transient["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IEditableCollection.-as-transient",coll);
}
}
})().call(null,coll);
}
});


cljs.core.ITransientCollection = (function (){var obj6988 = {};
return obj6988;
})();

cljs.core._conj_BANG_ = (function _conj_BANG_(tcoll,val){
if((function (){var and__5090__auto__ = tcoll;
if(and__5090__auto__){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2;
} else {
return and__5090__auto__;
}
})()){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else {
var x__5746__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__5102__auto__ = (cljs.core._conj_BANG_[(function (){var G__6992 = x__5746__auto__;
return goog.typeOf(G__6992);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._conj_BANG_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientCollection.-conj!",tcoll);
}
}
})().call(null,tcoll,val);
}
});

cljs.core._persistent_BANG_ = (function _persistent_BANG_(tcoll){
if((function (){var and__5090__auto__ = tcoll;
if(and__5090__auto__){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1;
} else {
return and__5090__auto__;
}
})()){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else {
var x__5746__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__5102__auto__ = (cljs.core._persistent_BANG_[(function (){var G__6996 = x__5746__auto__;
return goog.typeOf(G__6996);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._persistent_BANG_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientCollection.-persistent!",tcoll);
}
}
})().call(null,tcoll);
}
});


cljs.core.ITransientAssociative = (function (){var obj6998 = {};
return obj6998;
})();

cljs.core._assoc_BANG_ = (function _assoc_BANG_(tcoll,key,val){
if((function (){var and__5090__auto__ = tcoll;
if(and__5090__auto__){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3;
} else {
return and__5090__auto__;
}
})()){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else {
var x__5746__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__5102__auto__ = (cljs.core._assoc_BANG_[(function (){var G__7002 = x__5746__auto__;
return goog.typeOf(G__7002);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._assoc_BANG_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientAssociative.-assoc!",tcoll);
}
}
})().call(null,tcoll,key,val);
}
});


cljs.core.ITransientMap = (function (){var obj7004 = {};
return obj7004;
})();

cljs.core._dissoc_BANG_ = (function _dissoc_BANG_(tcoll,key){
if((function (){var and__5090__auto__ = tcoll;
if(and__5090__auto__){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2;
} else {
return and__5090__auto__;
}
})()){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else {
var x__5746__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__5102__auto__ = (cljs.core._dissoc_BANG_[(function (){var G__7008 = x__5746__auto__;
return goog.typeOf(G__7008);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._dissoc_BANG_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientMap.-dissoc!",tcoll);
}
}
})().call(null,tcoll,key);
}
});


cljs.core.ITransientVector = (function (){var obj7010 = {};
return obj7010;
})();

cljs.core._assoc_n_BANG_ = (function _assoc_n_BANG_(tcoll,n,val){
if((function (){var and__5090__auto__ = tcoll;
if(and__5090__auto__){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3;
} else {
return and__5090__auto__;
}
})()){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else {
var x__5746__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__5102__auto__ = (cljs.core._assoc_n_BANG_[(function (){var G__7014 = x__5746__auto__;
return goog.typeOf(G__7014);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._assoc_n_BANG_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientVector.-assoc-n!",tcoll);
}
}
})().call(null,tcoll,n,val);
}
});

cljs.core._pop_BANG_ = (function _pop_BANG_(tcoll){
if((function (){var and__5090__auto__ = tcoll;
if(and__5090__auto__){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1;
} else {
return and__5090__auto__;
}
})()){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else {
var x__5746__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__5102__auto__ = (cljs.core._pop_BANG_[(function (){var G__7018 = x__5746__auto__;
return goog.typeOf(G__7018);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._pop_BANG_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientVector.-pop!",tcoll);
}
}
})().call(null,tcoll);
}
});


cljs.core.ITransientSet = (function (){var obj7020 = {};
return obj7020;
})();

cljs.core._disjoin_BANG_ = (function _disjoin_BANG_(tcoll,v){
if((function (){var and__5090__auto__ = tcoll;
if(and__5090__auto__){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2;
} else {
return and__5090__auto__;
}
})()){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else {
var x__5746__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__5102__auto__ = (cljs.core._disjoin_BANG_[(function (){var G__7024 = x__5746__auto__;
return goog.typeOf(G__7024);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._disjoin_BANG_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientSet.-disjoin!",tcoll);
}
}
})().call(null,tcoll,v);
}
});


cljs.core.IComparable = (function (){var obj7026 = {};
return obj7026;
})();

cljs.core._compare = (function _compare(x,y){
if((function (){var and__5090__auto__ = x;
if(and__5090__auto__){
return x.cljs$core$IComparable$_compare$arity$2;
} else {
return and__5090__auto__;
}
})()){
return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else {
var x__5746__auto__ = (((x == null))?null:x);
return (function (){var or__5102__auto__ = (cljs.core._compare[(function (){var G__7030 = x__5746__auto__;
return goog.typeOf(G__7030);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._compare["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IComparable.-compare",x);
}
}
})().call(null,x,y);
}
});


cljs.core.IChunk = (function (){var obj7032 = {};
return obj7032;
})();

cljs.core._drop_first = (function _drop_first(coll){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$IChunk$_drop_first$arity$1;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._drop_first[(function (){var G__7036 = x__5746__auto__;
return goog.typeOf(G__7036);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._drop_first["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunk.-drop-first",coll);
}
}
})().call(null,coll);
}
});


cljs.core.IChunkedSeq = (function (){var obj7038 = {};
return obj7038;
})();

cljs.core._chunked_first = (function _chunked_first(coll){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._chunked_first[(function (){var G__7042 = x__5746__auto__;
return goog.typeOf(G__7042);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._chunked_first["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first",coll);
}
}
})().call(null,coll);
}
});

cljs.core._chunked_rest = (function _chunked_rest(coll){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._chunked_rest[(function (){var G__7046 = x__5746__auto__;
return goog.typeOf(G__7046);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._chunked_rest["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest",coll);
}
}
})().call(null,coll);
}
});


cljs.core.IChunkedNext = (function (){var obj7048 = {};
return obj7048;
})();

cljs.core._chunked_next = (function _chunked_next(coll){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._chunked_next[(function (){var G__7052 = x__5746__auto__;
return goog.typeOf(G__7052);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._chunked_next["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedNext.-chunked-next",coll);
}
}
})().call(null,coll);
}
});


cljs.core.INamed = (function (){var obj7054 = {};
return obj7054;
})();

cljs.core._name = (function _name(x){
if((function (){var and__5090__auto__ = x;
if(and__5090__auto__){
return x.cljs$core$INamed$_name$arity$1;
} else {
return and__5090__auto__;
}
})()){
return x.cljs$core$INamed$_name$arity$1(x);
} else {
var x__5746__auto__ = (((x == null))?null:x);
return (function (){var or__5102__auto__ = (cljs.core._name[(function (){var G__7058 = x__5746__auto__;
return goog.typeOf(G__7058);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._name["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("INamed.-name",x);
}
}
})().call(null,x);
}
});

cljs.core._namespace = (function _namespace(x){
if((function (){var and__5090__auto__ = x;
if(and__5090__auto__){
return x.cljs$core$INamed$_namespace$arity$1;
} else {
return and__5090__auto__;
}
})()){
return x.cljs$core$INamed$_namespace$arity$1(x);
} else {
var x__5746__auto__ = (((x == null))?null:x);
return (function (){var or__5102__auto__ = (cljs.core._namespace[(function (){var G__7062 = x__5746__auto__;
return goog.typeOf(G__7062);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._namespace["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("INamed.-namespace",x);
}
}
})().call(null,x);
}
});


cljs.core.IAtom = (function (){var obj7064 = {};
return obj7064;
})();


cljs.core.IReset = (function (){var obj7066 = {};
return obj7066;
})();

cljs.core._reset_BANG_ = (function _reset_BANG_(o,new_value){
if((function (){var and__5090__auto__ = o;
if(and__5090__auto__){
return o.cljs$core$IReset$_reset_BANG_$arity$2;
} else {
return and__5090__auto__;
}
})()){
return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);
} else {
var x__5746__auto__ = (((o == null))?null:o);
return (function (){var or__5102__auto__ = (cljs.core._reset_BANG_[(function (){var G__7070 = x__5746__auto__;
return goog.typeOf(G__7070);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._reset_BANG_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IReset.-reset!",o);
}
}
})().call(null,o,new_value);
}
});


cljs.core.ISwap = (function (){var obj7072 = {};
return obj7072;
})();

cljs.core._swap_BANG_ = (function() {
var _swap_BANG_ = null;
var _swap_BANG___2 = (function (o,f){
if((function (){var and__5090__auto__ = o;
if(and__5090__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$2;
} else {
return and__5090__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);
} else {
var x__5746__auto__ = (((o == null))?null:o);
return (function (){var or__5102__auto__ = (cljs.core._swap_BANG_[(function (){var G__7082 = x__5746__auto__;
return goog.typeOf(G__7082);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f);
}
});
var _swap_BANG___3 = (function (o,f,a){
if((function (){var and__5090__auto__ = o;
if(and__5090__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$3;
} else {
return and__5090__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);
} else {
var x__5746__auto__ = (((o == null))?null:o);
return (function (){var or__5102__auto__ = (cljs.core._swap_BANG_[(function (){var G__7084 = x__5746__auto__;
return goog.typeOf(G__7084);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a);
}
});
var _swap_BANG___4 = (function (o,f,a,b){
if((function (){var and__5090__auto__ = o;
if(and__5090__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$4;
} else {
return and__5090__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);
} else {
var x__5746__auto__ = (((o == null))?null:o);
return (function (){var or__5102__auto__ = (cljs.core._swap_BANG_[(function (){var G__7086 = x__5746__auto__;
return goog.typeOf(G__7086);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a,b);
}
});
var _swap_BANG___5 = (function (o,f,a,b,xs){
if((function (){var and__5090__auto__ = o;
if(and__5090__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$5;
} else {
return and__5090__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);
} else {
var x__5746__auto__ = (((o == null))?null:o);
return (function (){var or__5102__auto__ = (cljs.core._swap_BANG_[(function (){var G__7088 = x__5746__auto__;
return goog.typeOf(G__7088);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a,b,xs);
}
});
_swap_BANG_ = function(o,f,a,b,xs){
switch(arguments.length){
case 2:
return _swap_BANG___2.call(this,o,f);
case 3:
return _swap_BANG___3.call(this,o,f,a);
case 4:
return _swap_BANG___4.call(this,o,f,a,b);
case 5:
return _swap_BANG___5.call(this,o,f,a,b,xs);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_swap_BANG_.cljs$core$IFn$_invoke$arity$2 = _swap_BANG___2;
_swap_BANG_.cljs$core$IFn$_invoke$arity$3 = _swap_BANG___3;
_swap_BANG_.cljs$core$IFn$_invoke$arity$4 = _swap_BANG___4;
_swap_BANG_.cljs$core$IFn$_invoke$arity$5 = _swap_BANG___5;
return _swap_BANG_;
})()
;


cljs.core.IVolatile = (function (){var obj7090 = {};
return obj7090;
})();

cljs.core._vreset_BANG_ = (function _vreset_BANG_(o,new_value){
if((function (){var and__5090__auto__ = o;
if(and__5090__auto__){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2;
} else {
return and__5090__auto__;
}
})()){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);
} else {
var x__5746__auto__ = (((o == null))?null:o);
return (function (){var or__5102__auto__ = (cljs.core._vreset_BANG_[(function (){var G__7094 = x__5746__auto__;
return goog.typeOf(G__7094);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._vreset_BANG_["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IVolatile.-vreset!",o);
}
}
})().call(null,o,new_value);
}
});


cljs.core.IIterable = (function (){var obj7096 = {};
return obj7096;
})();

cljs.core._iterator = (function _iterator(coll){
if((function (){var and__5090__auto__ = coll;
if(and__5090__auto__){
return coll.cljs$core$IIterable$_iterator$arity$1;
} else {
return and__5090__auto__;
}
})()){
return coll.cljs$core$IIterable$_iterator$arity$1(coll);
} else {
var x__5746__auto__ = (((coll == null))?null:coll);
return (function (){var or__5102__auto__ = (cljs.core._iterator[(function (){var G__7100 = x__5746__auto__;
return goog.typeOf(G__7100);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._iterator["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IIterable.-iterator",coll);
}
}
})().call(null,coll);
}
});


/**
* @constructor
*/
cljs.core.StringBufferWriter = (function (sb){
this.sb = sb;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 1073741824;
})
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
return self__.sb.append(s);
});

cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
});

cljs.core.StringBufferWriter.cljs$lang$type = true;

cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter";

cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/StringBufferWriter");
});

cljs.core.__GT_StringBufferWriter = (function __GT_StringBufferWriter(sb){
return (new cljs.core.StringBufferWriter(sb));
});

/**
* Support so that collections can implement toString without
* loading all the printing machinery.
*/
cljs.core.pr_str_STAR_ = (function pr_str_STAR_(obj){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());

writer.cljs$core$IWriter$_flush$arity$1(null);

return [cljs.core.str(sb)].join('');
});
cljs.core.int_rotate_left = (function int_rotate_left(x,n){
return ((x << n) | (x >>> (- n)));
});
if((typeof Math.imul !== 'undefined') && (!(((function (){var G__7103 = (4294967295);
var G__7104 = (5);
return (Math.imul.cljs$core$IFn$_invoke$arity$2 ? Math.imul.cljs$core$IFn$_invoke$arity$2(G__7103,G__7104) : Math.imul.call(null,G__7103,G__7104));
})() === (0))))){
cljs.core.imul = (function imul(a,b){
var G__7107 = a;
var G__7108 = b;
return (Math.imul.cljs$core$IFn$_invoke$arity$2 ? Math.imul.cljs$core$IFn$_invoke$arity$2(G__7107,G__7108) : Math.imul.call(null,G__7107,G__7108));
});
} else {
cljs.core.imul = (function imul(a,b){
var ah = ((a >>> (16)) & (65535));
var al = (a & (65535));
var bh = ((b >>> (16)) & (65535));
var bl = (b & (65535));
return (((al * bl) + ((((ah * bl) + (al * bh)) << (16)) >>> (0))) | (0));
});
}
cljs.core.m3_seed = (0);
cljs.core.m3_C1 = (3432918353);
cljs.core.m3_C2 = (461845907);
cljs.core.m3_mix_K1 = (function m3_mix_K1(k1){
return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul(k1,cljs.core.m3_C1),(15)),cljs.core.m3_C2);
});
cljs.core.m3_mix_H1 = (function m3_mix_H1(h1,k1){
return (cljs.core.imul(cljs.core.int_rotate_left((h1 ^ k1),(13)),(5)) + (3864292196));
});
cljs.core.m3_fmix = (function m3_fmix(h1,len){
var h1__$1 = h1;
var h1__$2 = (h1__$1 ^ len);
var h1__$3 = (h1__$2 ^ (h1__$2 >>> (16)));
var h1__$4 = cljs.core.imul(h1__$3,(2246822507));
var h1__$5 = (h1__$4 ^ (h1__$4 >>> (13)));
var h1__$6 = cljs.core.imul(h1__$5,(3266489909));
var h1__$7 = (h1__$6 ^ (h1__$6 >>> (16)));
return h1__$7;
});
cljs.core.m3_hash_int = (function m3_hash_int(in$){
if((in$ === (0))){
return in$;
} else {
var k1 = cljs.core.m3_mix_K1(in$);
var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);
return cljs.core.m3_fmix(h1,(4));
}
});
cljs.core.m3_hash_unencoded_chars = (function m3_hash_unencoded_chars(in$){
var h1 = (function (){var i = (1);
var h1 = cljs.core.m3_seed;
while(true){
if((i < in$.length)){
var G__7109 = (i + (2));
var G__7110 = cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) << (16)))));
i = G__7109;
h1 = G__7110;
continue;
} else {
return h1;
}
break;
}
})();
var h1__$1 = ((((in$.length & (1)) === (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);
return cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));
});



cljs.core.string_hash_cache = (function (){var obj7112 = {};
return obj7112;
})();
cljs.core.string_hash_cache_count = (0);
cljs.core.hash_string_STAR_ = (function hash_string_STAR_(s){
if(!((s == null))){
var len = s.length;
if((len > (0))){
var i = (0);
var hash = (0);
while(true){
if((i < len)){
var G__7113 = (i + (1));
var G__7114 = (cljs.core.imul((31),hash) + s.charCodeAt(i));
i = G__7113;
hash = G__7114;
continue;
} else {
return hash;
}
break;
}
} else {
return (0);
}
} else {
return (0);
}
});
cljs.core.add_to_string_hash_cache = (function add_to_string_hash_cache(k){
var h = cljs.core.hash_string_STAR_(k);
(cljs.core.string_hash_cache[k] = h);

cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + (1));

return h;
});
cljs.core.hash_string = (function hash_string(k){
if((cljs.core.string_hash_cache_count > (255))){
cljs.core.string_hash_cache = (function (){var obj7118 = {};
return obj7118;
})();

cljs.core.string_hash_cache_count = (0);
} else {
}

var h = (cljs.core.string_hash_cache[k]);
if(typeof h === 'number'){
return h;
} else {
return cljs.core.add_to_string_hash_cache(k);
}
});
cljs.core.hash = (function hash(o){
if((function (){var G__7121 = o;
if(G__7121){
var bit__5776__auto__ = (G__7121.cljs$lang$protocol_mask$partition0$ & (4194304));
if((bit__5776__auto__) || (G__7121.cljs$core$IHash$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$IHash$_hash$arity$1(null);
} else {
if(typeof o === 'number'){
return ((function (){var G__7122 = o;
return (Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__7122) : Math.floor.call(null,G__7122));
})() % (2147483647));
} else {
if(o === true){
return (1);
} else {
if(o === false){
return (0);
} else {
if(typeof o === 'string'){
return cljs.core.m3_hash_int(cljs.core.hash_string(o));
} else {
if((o instanceof Date)){
return o.valueOf();
} else {
if((o == null)){
return (0);
} else {
return cljs.core._hash(o);

}
}
}
}
}
}
}
});
cljs.core.hash_combine = (function hash_combine(seed,hash){
return (seed ^ (((hash + (2654435769)) + (seed << (6))) + (seed >> (2))));
});
cljs.core.instance_QMARK_ = (function instance_QMARK_(t,o){
return (o instanceof t);
});
cljs.core.symbol_QMARK_ = (function symbol_QMARK_(x){
return (x instanceof cljs.core.Symbol);
});
cljs.core.hash_symbol = (function hash_symbol(sym){
return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));
});
cljs.core.compare_symbols = (function compare_symbols(a,b){
if((a.str === b.str)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__5090__auto__ = cljs.core.not(a.ns);
if(and__5090__auto__){
return b.ns;
} else {
return and__5090__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__7129 = a.ns;
var G__7130 = b.ns;
return goog.array.defaultCompare(G__7129,G__7130);
})();
if(((0) === nsc)){
var G__7131 = a.name;
var G__7132 = b.name;
return goog.array.defaultCompare(G__7131,G__7132);
} else {
return nsc;
}
}
} else {
var G__7133 = a.name;
var G__7134 = b.name;
return goog.array.defaultCompare(G__7133,G__7134);

}
}
}
});

/**
* @constructor
*/
cljs.core.Symbol = (function (ns,name,str,_hash,_meta){
this.ns = ns;
this.name = name;
this.str = str;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2154168321;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,self__.str);
});

cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = (function (sym){
var self__ = this;
var sym__$1 = this;
var h__5523__auto__ = self__._hash;
if(!((h__5523__auto__ == null))){
return h__5523__auto__;
} else {
var h__5523__auto____$1 = cljs.core.hash_symbol(sym__$1);
self__._hash = h__5523__auto____$1;

return h__5523__auto____$1;
}
});

cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));
});

cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Symbol.prototype.call = (function() {
var G__7136 = null;
var G__7136__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,null);
});
var G__7136__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});
G__7136 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__7136__2.call(this,self__,coll);
case 3:
return G__7136__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7136.cljs$core$IFn$_invoke$arity$2 = G__7136__2;
G__7136.cljs$core$IFn$_invoke$arity$3 = G__7136__3;
return G__7136;
})()
;

cljs.core.Symbol.prototype.apply = (function (self__,args7135){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args7135)));
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var sym = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,null);
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var sym = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});

cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Symbol)){
return (self__.str === other.str);
} else {
return false;
}
});

cljs.core.Symbol.prototype.toString = (function (){
var self__ = this;
var _ = this;
return self__.str;
});

cljs.core.Symbol.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Symbol.cljs$lang$type = true;

cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol";

cljs.core.Symbol.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/Symbol");
});

cljs.core.__GT_Symbol = (function __GT_Symbol(ns,name,str,_hash,_meta){
return (new cljs.core.Symbol(ns,name,str,_hash,_meta));
});

cljs.core.symbol = (function() {
var symbol = null;
var symbol__1 = (function (name){
if((name instanceof cljs.core.Symbol)){
return name;
} else {
return symbol.cljs$core$IFn$_invoke$arity$2(null,name);
}
});
var symbol__2 = (function (ns,name){
var sym_str = ((!((ns == null)))?[cljs.core.str(ns),cljs.core.str("/"),cljs.core.str(name)].join(''):name);
return (new cljs.core.Symbol(ns,name,sym_str,null,null));
});
symbol = function(ns,name){
switch(arguments.length){
case 1:
return symbol__1.call(this,ns);
case 2:
return symbol__2.call(this,ns,name);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
symbol.cljs$core$IFn$_invoke$arity$1 = symbol__1;
symbol.cljs$core$IFn$_invoke$arity$2 = symbol__2;
return symbol;
})()
;

/**
* @constructor
*/
cljs.core.Var = (function (val,sym,_meta){
this.val = val;
this.sym = sym;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 163841;
})
cljs.core.Var.prototype.call = (function() {
var G__7184 = null;
var G__7184__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null);
});
var G__7184__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a);
});
var G__7184__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b);
});
var G__7184__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c);
});
var G__7184__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d);
});
var G__7184__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e);
});
var G__7184__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f);
});
var G__7184__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g);
});
var G__7184__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h);
});
var G__7184__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i);
});
var G__7184__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j);
});
var G__7184__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k);
});
var G__7184__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});
var G__7184__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});
var G__7184__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});
var G__7184__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});
var G__7184__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});
var G__7184__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});
var G__7184__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});
var G__7184__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});
var G__7184__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});
var G__7184__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__7140 = (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})();
var G__7141 = a;
var G__7142 = b;
var G__7143 = c;
var G__7144 = d;
var G__7145 = e;
var G__7146 = f;
var G__7147 = g;
var G__7148 = h;
var G__7149 = i;
var G__7150 = j;
var G__7151 = k;
var G__7152 = l;
var G__7153 = m;
var G__7154 = n;
var G__7155 = o;
var G__7156 = p;
var G__7157 = q;
var G__7158 = r;
var G__7159 = s;
var G__7160 = t;
var G__7161 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__7140,G__7141,G__7142,G__7143,G__7144,G__7145,G__7146,G__7147,G__7148,G__7149,G__7150,G__7151,G__7152,G__7153,G__7154,G__7155,G__7156,G__7157,G__7158,G__7159,G__7160,G__7161) : cljs.core.apply.call(null,G__7140,G__7141,G__7142,G__7143,G__7144,G__7145,G__7146,G__7147,G__7148,G__7149,G__7150,G__7151,G__7152,G__7153,G__7154,G__7155,G__7156,G__7157,G__7158,G__7159,G__7160,G__7161));
});
G__7184 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__7184__1.call(this,self__);
case 2:
return G__7184__2.call(this,self__,a);
case 3:
return G__7184__3.call(this,self__,a,b);
case 4:
return G__7184__4.call(this,self__,a,b,c);
case 5:
return G__7184__5.call(this,self__,a,b,c,d);
case 6:
return G__7184__6.call(this,self__,a,b,c,d,e);
case 7:
return G__7184__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__7184__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__7184__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__7184__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__7184__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__7184__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__7184__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__7184__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__7184__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__7184__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__7184__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__7184__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__7184__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__7184__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__7184__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__7184__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7184.cljs$core$IFn$_invoke$arity$1 = G__7184__1;
G__7184.cljs$core$IFn$_invoke$arity$2 = G__7184__2;
G__7184.cljs$core$IFn$_invoke$arity$3 = G__7184__3;
G__7184.cljs$core$IFn$_invoke$arity$4 = G__7184__4;
G__7184.cljs$core$IFn$_invoke$arity$5 = G__7184__5;
G__7184.cljs$core$IFn$_invoke$arity$6 = G__7184__6;
G__7184.cljs$core$IFn$_invoke$arity$7 = G__7184__7;
G__7184.cljs$core$IFn$_invoke$arity$8 = G__7184__8;
G__7184.cljs$core$IFn$_invoke$arity$9 = G__7184__9;
G__7184.cljs$core$IFn$_invoke$arity$10 = G__7184__10;
G__7184.cljs$core$IFn$_invoke$arity$11 = G__7184__11;
G__7184.cljs$core$IFn$_invoke$arity$12 = G__7184__12;
G__7184.cljs$core$IFn$_invoke$arity$13 = G__7184__13;
G__7184.cljs$core$IFn$_invoke$arity$14 = G__7184__14;
G__7184.cljs$core$IFn$_invoke$arity$15 = G__7184__15;
G__7184.cljs$core$IFn$_invoke$arity$16 = G__7184__16;
G__7184.cljs$core$IFn$_invoke$arity$17 = G__7184__17;
G__7184.cljs$core$IFn$_invoke$arity$18 = G__7184__18;
G__7184.cljs$core$IFn$_invoke$arity$19 = G__7184__19;
G__7184.cljs$core$IFn$_invoke$arity$20 = G__7184__20;
G__7184.cljs$core$IFn$_invoke$arity$21 = G__7184__21;
G__7184.cljs$core$IFn$_invoke$arity$22 = G__7184__22;
return G__7184;
})()
;

cljs.core.Var.prototype.apply = (function (self__,args7139){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args7139)));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__7162 = (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})();
var G__7163 = a;
var G__7164 = b;
var G__7165 = c;
var G__7166 = d;
var G__7167 = e;
var G__7168 = f;
var G__7169 = g;
var G__7170 = h;
var G__7171 = i;
var G__7172 = j;
var G__7173 = k;
var G__7174 = l;
var G__7175 = m;
var G__7176 = n;
var G__7177 = o;
var G__7178 = p;
var G__7179 = q;
var G__7180 = r;
var G__7181 = s;
var G__7182 = t;
var G__7183 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__7162,G__7163,G__7164,G__7165,G__7166,G__7167,G__7168,G__7169,G__7170,G__7171,G__7172,G__7173,G__7174,G__7175,G__7176,G__7177,G__7178,G__7179,G__7180,G__7181,G__7182,G__7183) : cljs.core.apply.call(null,G__7162,G__7163,G__7164,G__7165,G__7166,G__7167,G__7168,G__7169,G__7170,G__7171,G__7172,G__7173,G__7174,G__7175,G__7176,G__7177,G__7178,G__7179,G__7180,G__7181,G__7182,G__7183));
});

cljs.core.Var.prototype.cljs$core$Fn$ = true;

cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
});

cljs.core.Var.cljs$lang$type = true;

cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var";

cljs.core.Var.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/Var");
});

cljs.core.__GT_Var = (function __GT_Var(val,sym,_meta){
return (new cljs.core.Var(val,sym,_meta));
});



cljs.core.iterable_QMARK_ = (function iterable_QMARK_(x){
var G__7186 = x;
if(G__7186){
var bit__5783__auto__ = null;
if(cljs.core.truth_((function (){var or__5102__auto__ = bit__5783__auto__;
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
return G__7186.cljs$core$IIterable$;
}
})())){
return true;
} else {
if((!G__7186.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,G__7186);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,G__7186);
}
});
cljs.core.clone = (function clone(value){
return cljs.core._clone(value);
});
cljs.core.cloneable_QMARK_ = (function cloneable_QMARK_(value){
var G__7188 = value;
if(G__7188){
var bit__5783__auto__ = (G__7188.cljs$lang$protocol_mask$partition1$ & (8192));
if((bit__5783__auto__) || (G__7188.cljs$core$ICloneable$)){
return true;
} else {
if((!G__7188.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,G__7188);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,G__7188);
}
});
/**
* Returns a seq on the collection. If the collection is
* empty, returns nil.  (seq nil) returns nil. seq also works on
* Strings.
*/
cljs.core.seq = (function seq(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__7190 = coll;
if(G__7190){
var bit__5776__auto__ = (G__7190.cljs$lang$protocol_mask$partition0$ & (8388608));
if((bit__5776__auto__) || (G__7190.cljs$core$ISeqable$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeqable$_seq$arity$1(null);
} else {
if(Array.isArray(coll)){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0)));
}
} else {
if(typeof coll === 'string'){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0)));
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){
return cljs.core._seq(coll);
} else {
throw (new Error([cljs.core.str(coll),cljs.core.str(" is not ISeqable")].join('')));

}
}
}
}
}
});
/**
* Returns the first item in the collection. Calls seq on its
* argument. If coll is nil, returns nil.
*/
cljs.core.first = (function first(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__7192 = coll;
if(G__7192){
var bit__5776__auto__ = (G__7192.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__5776__auto__) || (G__7192.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeq$_first$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if((s == null)){
return null;
} else {
return cljs.core._first(s);
}
}
}
});
/**
* Returns a possibly empty seq of the items after the first. Calls seq on its
* argument.
*/
cljs.core.rest = (function rest(coll){
if(!((coll == null))){
if((function (){var G__7194 = coll;
if(G__7194){
var bit__5776__auto__ = (G__7194.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__5776__auto__) || (G__7194.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeq$_rest$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if(s){
return cljs.core._rest(s);
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return cljs.core.List.EMPTY;
}
});
/**
* Returns a seq of the items after the first. Calls seq on its
* argument.  If there are no more items, returns nil
*/
cljs.core.next = (function next(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__7196 = coll;
if(G__7196){
var bit__5776__auto__ = (G__7196.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__5776__auto__) || (G__7196.cljs$core$INext$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
}
});
/**
* Equality. Returns true if x equals y, false if not. Compares
* numbers and collections in a type-independent manner.  Clojure's immutable data
* structures define -equiv (and thus =) as a value, not an identity,
* comparison.
* @param {...*} var_args
*/
cljs.core._EQ_ = (function() {
var _EQ_ = null;
var _EQ___1 = (function (x){
return true;
});
var _EQ___2 = (function (x,y){
if((x == null)){
return (y == null);
} else {
return ((x === y)) || (cljs.core._equiv(x,y));
}
});
var _EQ___3 = (function() { 
var G__7201__delegate = function (x,y,more){
while(true){
if(_EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__7202 = y;
var G__7203 = cljs.core.first(more);
var G__7204 = cljs.core.next(more);
x = G__7202;
y = G__7203;
more = G__7204;
continue;
} else {
return _EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__7201 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__7205__i = 0, G__7205__a = new Array(arguments.length -  2);
while (G__7205__i < G__7205__a.length) {G__7205__a[G__7205__i] = arguments[G__7205__i + 2]; ++G__7205__i;}
  more = new cljs.core.IndexedSeq(G__7205__a,0);
} 
return G__7201__delegate.call(this,x,y,more);};
G__7201.cljs$lang$maxFixedArity = 2;
G__7201.cljs$lang$applyTo = (function (arglist__7206){
var x = cljs.core.first(arglist__7206);
arglist__7206 = cljs.core.next(arglist__7206);
var y = cljs.core.first(arglist__7206);
var more = cljs.core.rest(arglist__7206);
return G__7201__delegate(x,y,more);
});
G__7201.cljs$core$IFn$_invoke$arity$variadic = G__7201__delegate;
return G__7201;
})()
;
_EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _EQ___1.call(this,x);
case 2:
return _EQ___2.call(this,x,y);
default:
var G__7207 = null;
if (arguments.length > 2) {
var G__7208__i = 0, G__7208__a = new Array(arguments.length -  2);
while (G__7208__i < G__7208__a.length) {G__7208__a[G__7208__i] = arguments[G__7208__i + 2]; ++G__7208__i;}
G__7207 = new cljs.core.IndexedSeq(G__7208__a,0);
}
return _EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__7207);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_EQ_.cljs$lang$maxFixedArity = 2;
_EQ_.cljs$lang$applyTo = _EQ___3.cljs$lang$applyTo;
_EQ_.cljs$core$IFn$_invoke$arity$1 = _EQ___1;
_EQ_.cljs$core$IFn$_invoke$arity$2 = _EQ___2;
_EQ_.cljs$core$IFn$_invoke$arity$variadic = _EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return _EQ_;
})()
;

/**
* @constructor
*/
cljs.core.ES6Iterator = (function (s){
this.s = s;
})
cljs.core.ES6Iterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return {"done": false, "value": x};
} else {
return {"done": true, "value": null};
}
});

cljs.core.ES6Iterator.cljs$lang$type = true;

cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator";

cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/ES6Iterator");
});

cljs.core.__GT_ES6Iterator = (function __GT_ES6Iterator(s){
return (new cljs.core.ES6Iterator(s));
});

cljs.core.es6_iterator = (function es6_iterator(coll){
return (new cljs.core.ES6Iterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6IteratorSeq = (function (value,iter,_rest){
this.value = value;
this.iter = iter;
this._rest = _rest;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 8388672;
})
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.value;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if((self__._rest == null)){
self__._rest = (function (){var G__7209 = self__.iter;
return (cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(G__7209) : cljs.core.es6_iterator_seq.call(null,G__7209));
})();
} else {
}

return self__._rest;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ES6IteratorSeq.cljs$lang$type = true;

cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq";

cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/ES6IteratorSeq");
});

cljs.core.__GT_ES6IteratorSeq = (function __GT_ES6IteratorSeq(value,iter,_rest){
return (new cljs.core.ES6IteratorSeq(value,iter,_rest));
});

cljs.core.es6_iterator_seq = (function es6_iterator_seq(iter){
var v = iter.next();
if(cljs.core.truth_(v.done)){
return cljs.core.List.EMPTY;
} else {
return (new cljs.core.ES6IteratorSeq(v.value,iter,null));
}
});
/**
* Mix final collection hash for ordered or unordered collections.
* hash-basis is the combined collection hash, count is the number
* of elements included in the basis. Note this is the hash code
* consistent with =, different from .hashCode.
* See http://clojure.org/data_structures#hash for full algorithms.
*/
cljs.core.mix_collection_hash = (function mix_collection_hash(hash_basis,count){
var h1 = cljs.core.m3_seed;
var k1 = cljs.core.m3_mix_K1(hash_basis);
var h1__$1 = cljs.core.m3_mix_H1(h1,k1);
return cljs.core.m3_fmix(h1__$1,count);
});
/**
* Returns the hash code, consistent with =, for an external ordered
* collection implementing Iterable.
* See http://clojure.org/data_structures#hash for full algorithms.
*/
cljs.core.hash_ordered_coll = (function hash_ordered_coll(coll){
var n = (0);
var hash_code = (1);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__7210 = (n + (1));
var G__7211 = ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__7212 = cljs.core.next(coll__$1);
n = G__7210;
hash_code = G__7211;
coll__$1 = G__7212;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash((1),(0));
/**
* Returns the hash code, consistent with =, for an external unordered
* collection implementing Iterable. For maps, the iterator should
* return map entries whose hash is computed as
* (hash-ordered-coll [k v]).
* See http://clojure.org/data_structures#hash for full algorithms.
*/
cljs.core.hash_unordered_coll = (function hash_unordered_coll(coll){
var n = (0);
var hash_code = (0);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__7213 = (n + (1));
var G__7214 = ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__7215 = cljs.core.next(coll__$1);
n = G__7213;
hash_code = G__7214;
coll__$1 = G__7215;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash((0),(0));


(cljs.core.ICounted["null"] = true);

(cljs.core._count["null"] = (function (_){
return (0);
}));
Date.prototype.cljs$core$IEquiv$ = true;

Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var o__$1 = this;
return ((other instanceof Date)) && ((o__$1.toString() === other.toString()));
});
(cljs.core.IEquiv["number"] = true);

(cljs.core._equiv["number"] = (function (x,o){
return (x === o);
}));
(cljs.core.IMeta["function"] = true);

(cljs.core._meta["function"] = (function (_){
return null;
}));

(cljs.core.Fn["function"] = true);
(cljs.core.IHash["_"] = true);

(cljs.core._hash["_"] = (function (o){
var G__7216 = o;
return goog.getUid(G__7216);
}));
/**
* Returns a number one greater than num.
*/
cljs.core.inc = (function inc(x){
return (x + (1));
});

/**
* @constructor
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32768;
})
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function (o){
var self__ = this;
var o__$1 = this;
return self__.val;
});

cljs.core.Reduced.cljs$lang$type = true;

cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced";

cljs.core.Reduced.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/Reduced");
});

cljs.core.__GT_Reduced = (function __GT_Reduced(val){
return (new cljs.core.Reduced(val));
});

/**
* Wraps x in a way such that a reduce will terminate with the value x
*/
cljs.core.reduced = (function reduced(x){
return (new cljs.core.Reduced(x));
});
/**
* Returns true if x is the result of a call to reduced
*/
cljs.core.reduced_QMARK_ = (function reduced_QMARK_(r){
return (r instanceof cljs.core.Reduced);
});
/**
* If x is already reduced?, returns it, else returns (reduced x)
*/
cljs.core.ensure_reduced = (function ensure_reduced(x){
if(cljs.core.reduced_QMARK_(x)){
return x;
} else {
return cljs.core.reduced(x);
}
});
/**
* If x is reduced?, returns (deref x), else returns x
*/
cljs.core.unreduced = (function unreduced(x){
if(cljs.core.reduced_QMARK_(x)){
var G__7218 = x;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__7218) : cljs.core.deref.call(null,G__7218));
} else {
return x;
}
});
cljs.core.deref = (function deref(o){
return cljs.core._deref(o);
});
/**
* Accepts any collection which satisfies the ICount and IIndexed protocols and
* reduces them without incurring seq initialization
*/
cljs.core.ci_reduce = (function() {
var ci_reduce = null;
var ci_reduce__2 = (function (cicoll,f){
var cnt = cljs.core._count(cicoll);
if((cnt === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,(0));
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__7225 = val;
var G__7226 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7225,G__7226) : f.call(null,G__7225,G__7226));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__7231 = nval;
var G__7232 = (n + (1));
val = G__7231;
n = G__7232;
continue;
}
} else {
return val;
}
break;
}
}
});
var ci_reduce__3 = (function (cicoll,f,val){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__7227 = val__$1;
var G__7228 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7227,G__7228) : f.call(null,G__7227,G__7228));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__7233 = nval;
var G__7234 = (n + (1));
val__$1 = G__7233;
n = G__7234;
continue;
}
} else {
return val__$1;
}
break;
}
});
var ci_reduce__4 = (function (cicoll,f,val,idx){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__7229 = val__$1;
var G__7230 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7229,G__7230) : f.call(null,G__7229,G__7230));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__7235 = nval;
var G__7236 = (n + (1));
val__$1 = G__7235;
n = G__7236;
continue;
}
} else {
return val__$1;
}
break;
}
});
ci_reduce = function(cicoll,f,val,idx){
switch(arguments.length){
case 2:
return ci_reduce__2.call(this,cicoll,f);
case 3:
return ci_reduce__3.call(this,cicoll,f,val);
case 4:
return ci_reduce__4.call(this,cicoll,f,val,idx);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
ci_reduce.cljs$core$IFn$_invoke$arity$2 = ci_reduce__2;
ci_reduce.cljs$core$IFn$_invoke$arity$3 = ci_reduce__3;
ci_reduce.cljs$core$IFn$_invoke$arity$4 = ci_reduce__4;
return ci_reduce;
})()
;
cljs.core.array_reduce = (function() {
var array_reduce = null;
var array_reduce__2 = (function (arr,f){
var cnt = arr.length;
if((arr.length === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = (arr[(0)]);
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__7243 = val;
var G__7244 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7243,G__7244) : f.call(null,G__7243,G__7244));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__7249 = nval;
var G__7250 = (n + (1));
val = G__7249;
n = G__7250;
continue;
}
} else {
return val;
}
break;
}
}
});
var array_reduce__3 = (function (arr,f,val){
var cnt = arr.length;
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__7245 = val__$1;
var G__7246 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7245,G__7246) : f.call(null,G__7245,G__7246));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__7251 = nval;
var G__7252 = (n + (1));
val__$1 = G__7251;
n = G__7252;
continue;
}
} else {
return val__$1;
}
break;
}
});
var array_reduce__4 = (function (arr,f,val,idx){
var cnt = arr.length;
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__7247 = val__$1;
var G__7248 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7247,G__7248) : f.call(null,G__7247,G__7248));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__7253 = nval;
var G__7254 = (n + (1));
val__$1 = G__7253;
n = G__7254;
continue;
}
} else {
return val__$1;
}
break;
}
});
array_reduce = function(arr,f,val,idx){
switch(arguments.length){
case 2:
return array_reduce__2.call(this,arr,f);
case 3:
return array_reduce__3.call(this,arr,f,val);
case 4:
return array_reduce__4.call(this,arr,f,val,idx);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
array_reduce.cljs$core$IFn$_invoke$arity$2 = array_reduce__2;
array_reduce.cljs$core$IFn$_invoke$arity$3 = array_reduce__3;
array_reduce.cljs$core$IFn$_invoke$arity$4 = array_reduce__4;
return array_reduce;
})()
;



/**
* Returns true if coll implements count in constant time
*/
cljs.core.counted_QMARK_ = (function counted_QMARK_(x){
var G__7256 = x;
if(G__7256){
var bit__5783__auto__ = (G__7256.cljs$lang$protocol_mask$partition0$ & (2));
if((bit__5783__auto__) || (G__7256.cljs$core$ICounted$)){
return true;
} else {
if((!G__7256.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,G__7256);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,G__7256);
}
});
/**
* Returns true if coll implements nth in constant time
*/
cljs.core.indexed_QMARK_ = (function indexed_QMARK_(x){
var G__7258 = x;
if(G__7258){
var bit__5783__auto__ = (G__7258.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__5783__auto__) || (G__7258.cljs$core$IIndexed$)){
return true;
} else {
if((!G__7258.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,G__7258);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,G__7258);
}
});

/**
* @constructor
*/
cljs.core.IndexedSeqIterator = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.IndexedSeqIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.IndexedSeqIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.IndexedSeqIterator.cljs$lang$type = true;

cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator";

cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/IndexedSeqIterator");
});

cljs.core.__GT_IndexedSeqIterator = (function __GT_IndexedSeqIterator(arr,i){
return (new cljs.core.IndexedSeqIterator(arr,i));
});


/**
* @constructor
*/
cljs.core.IndexedSeq = (function (arr,i){
this.arr = arr;
this.i = i;
this.cljs$lang$protocol_mask$partition0$ = 166199550;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.IndexedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.IndexedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return not_found;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$ = true;

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1))));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr.length - self__.i);
});

cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var c = cljs.core._count(coll__$1);
if((c > (0))){
return (new cljs.core.RSeq(coll__$1,(c - (1)),null));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
var G__7259 = coll__$1;
var G__7260 = other;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__7259,G__7260) : cljs.core.equiv_sequential.call(null,G__7259,G__7260));
});

cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr[self__.i]);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1))));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__7261 = o;
var G__7262 = coll__$1;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__7261,G__7262) : cljs.core.cons.call(null,G__7261,G__7262));
});

cljs.core.IndexedSeq.cljs$lang$type = true;

cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq";

cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/IndexedSeq");
});

cljs.core.__GT_IndexedSeq = (function __GT_IndexedSeq(arr,i){
return (new cljs.core.IndexedSeq(arr,i));
});

(cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));
cljs.core.prim_seq = (function() {
var prim_seq = null;
var prim_seq__1 = (function (prim){
return prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));
});
var prim_seq__2 = (function (prim,i){
if((i < prim.length)){
return (new cljs.core.IndexedSeq(prim,i));
} else {
return null;
}
});
prim_seq = function(prim,i){
switch(arguments.length){
case 1:
return prim_seq__1.call(this,prim);
case 2:
return prim_seq__2.call(this,prim,i);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
prim_seq.cljs$core$IFn$_invoke$arity$1 = prim_seq__1;
prim_seq.cljs$core$IFn$_invoke$arity$2 = prim_seq__2;
return prim_seq;
})()
;
cljs.core.array_seq = (function() {
var array_seq = null;
var array_seq__1 = (function (array){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));
});
var array_seq__2 = (function (array,i){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);
});
array_seq = function(array,i){
switch(arguments.length){
case 1:
return array_seq__1.call(this,array);
case 2:
return array_seq__2.call(this,array,i);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
array_seq.cljs$core$IFn$_invoke$arity$1 = array_seq__1;
array_seq.cljs$core$IFn$_invoke$arity$2 = array_seq__2;
return array_seq;
})()
;


/**
* @constructor
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.RSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.RSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));
});

cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return null;
}
});

cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.i + (1));
});

cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
var G__7265 = coll__$1;
var G__7266 = other;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__7265,G__7266) : cljs.core.equiv_sequential.call(null,G__7265,G__7266));
});

cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__7267 = cljs.core.List.EMPTY;
var G__7268 = self__.meta;
return (cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2(G__7267,G__7268) : cljs.core.with_meta.call(null,G__7267,G__7268));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (col,f){
var self__ = this;
var col__$1 = this;
var G__7269 = f;
var G__7270 = col__$1;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(G__7269,G__7270) : cljs.core.seq_reduce.call(null,G__7269,G__7270));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (col,f,start){
var self__ = this;
var col__$1 = this;
var G__7271 = f;
var G__7272 = start;
var G__7273 = col__$1;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(G__7271,G__7272,G__7273) : cljs.core.seq_reduce.call(null,G__7271,G__7272,G__7273));
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci,self__.i);
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,new_meta));
});

cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__7274 = o;
var G__7275 = coll__$1;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__7274,G__7275) : cljs.core.cons.call(null,G__7274,G__7275));
});

cljs.core.RSeq.cljs$lang$type = true;

cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq";

cljs.core.RSeq.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/RSeq");
});

cljs.core.__GT_RSeq = (function __GT_RSeq(ci,i,meta){
return (new cljs.core.RSeq(ci,i,meta));
});

(cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));
/**
* Same as (first (next x))
*/
cljs.core.second = (function second(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
* Same as (first (first x))
*/
cljs.core.ffirst = (function ffirst(coll){
return cljs.core.first(cljs.core.first(coll));
});
/**
* Same as (next (first x))
*/
cljs.core.nfirst = (function nfirst(coll){
return cljs.core.next(cljs.core.first(coll));
});
/**
* Same as (first (next x))
*/
cljs.core.fnext = (function fnext(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
* Same as (next (next x))
*/
cljs.core.nnext = (function nnext(coll){
return cljs.core.next(cljs.core.next(coll));
});
/**
* Return the last item in coll, in linear time
*/
cljs.core.last = (function last(s){
while(true){
var sn = cljs.core.next(s);
if(!((sn == null))){
var G__7276 = sn;
s = G__7276;
continue;
} else {
return cljs.core.first(s);
}
break;
}
});
(cljs.core.IEquiv["_"] = true);

(cljs.core._equiv["_"] = (function (x,o){
return (x === o);
}));
/**
* conj[oin]. Returns a new collection with the xs
* 'added'. (conj nil item) returns (item).  The 'addition' may
* happen at different 'places' depending on the concrete type.
* @param {...*} var_args
*/
cljs.core.conj = (function() {
var conj = null;
var conj__0 = (function (){
return cljs.core.PersistentVector.EMPTY;
});
var conj__1 = (function (coll){
return coll;
});
var conj__2 = (function (coll,x){
if(!((coll == null))){
return cljs.core._conj(coll,x);
} else {
return cljs.core._conj(cljs.core.List.EMPTY,x);
}
});
var conj__3 = (function() { 
var G__7281__delegate = function (coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__7282 = conj.cljs$core$IFn$_invoke$arity$2(coll,x);
var G__7283 = cljs.core.first(xs);
var G__7284 = cljs.core.next(xs);
coll = G__7282;
x = G__7283;
xs = G__7284;
continue;
} else {
return conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
break;
}
};
var G__7281 = function (coll,x,var_args){
var xs = null;
if (arguments.length > 2) {
var G__7285__i = 0, G__7285__a = new Array(arguments.length -  2);
while (G__7285__i < G__7285__a.length) {G__7285__a[G__7285__i] = arguments[G__7285__i + 2]; ++G__7285__i;}
  xs = new cljs.core.IndexedSeq(G__7285__a,0);
} 
return G__7281__delegate.call(this,coll,x,xs);};
G__7281.cljs$lang$maxFixedArity = 2;
G__7281.cljs$lang$applyTo = (function (arglist__7286){
var coll = cljs.core.first(arglist__7286);
arglist__7286 = cljs.core.next(arglist__7286);
var x = cljs.core.first(arglist__7286);
var xs = cljs.core.rest(arglist__7286);
return G__7281__delegate(coll,x,xs);
});
G__7281.cljs$core$IFn$_invoke$arity$variadic = G__7281__delegate;
return G__7281;
})()
;
conj = function(coll,x,var_args){
var xs = var_args;
switch(arguments.length){
case 0:
return conj__0.call(this);
case 1:
return conj__1.call(this,coll);
case 2:
return conj__2.call(this,coll,x);
default:
var G__7287 = null;
if (arguments.length > 2) {
var G__7288__i = 0, G__7288__a = new Array(arguments.length -  2);
while (G__7288__i < G__7288__a.length) {G__7288__a[G__7288__i] = arguments[G__7288__i + 2]; ++G__7288__i;}
G__7287 = new cljs.core.IndexedSeq(G__7288__a,0);
}
return conj__3.cljs$core$IFn$_invoke$arity$variadic(coll,x, G__7287);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
conj.cljs$lang$maxFixedArity = 2;
conj.cljs$lang$applyTo = conj__3.cljs$lang$applyTo;
conj.cljs$core$IFn$_invoke$arity$0 = conj__0;
conj.cljs$core$IFn$_invoke$arity$1 = conj__1;
conj.cljs$core$IFn$_invoke$arity$2 = conj__2;
conj.cljs$core$IFn$_invoke$arity$variadic = conj__3.cljs$core$IFn$_invoke$arity$variadic;
return conj;
})()
;
/**
* Returns an empty collection of the same category as coll, or nil
*/
cljs.core.empty = (function empty(coll){
if((coll == null)){
return null;
} else {
return cljs.core._empty(coll);
}
});
cljs.core.accumulating_seq_count = (function accumulating_seq_count(coll){
var s = cljs.core.seq(coll);
var acc = (0);
while(true){
if(cljs.core.counted_QMARK_(s)){
return (acc + cljs.core._count(s));
} else {
var G__7289 = cljs.core.next(s);
var G__7290 = (acc + (1));
s = G__7289;
acc = G__7290;
continue;
}
break;
}
});
/**
* Returns the number of items in the collection. (count nil) returns
* 0.  Also works on strings, arrays, and Maps
*/
cljs.core.count = (function count(coll){
if(!((coll == null))){
if((function (){var G__7292 = coll;
if(G__7292){
var bit__5776__auto__ = (G__7292.cljs$lang$protocol_mask$partition0$ & (2));
if((bit__5776__auto__) || (G__7292.cljs$core$ICounted$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ICounted$_count$arity$1(null);
} else {
if(Array.isArray(coll)){
return coll.length;
} else {
if(typeof coll === 'string'){
return coll.length;
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,coll)){
return cljs.core._count(coll);
} else {
return cljs.core.accumulating_seq_count(coll);

}
}
}
}
} else {
return (0);
}
});
cljs.core.linear_traversal_nth = (function() {
var linear_traversal_nth = null;
var linear_traversal_nth__2 = (function (coll,n){
while(true){
if((coll == null)){
throw (new Error("Index out of bounds"));
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.seq(coll)){
var G__7293 = cljs.core.next(coll);
var G__7294 = (n - (1));
coll = G__7293;
n = G__7294;
continue;
} else {
throw (new Error("Index out of bounds"));

}
}
}
}
break;
}
});
var linear_traversal_nth__3 = (function (coll,n,not_found){
while(true){
if((coll == null)){
return not_found;
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
return not_found;
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.seq(coll)){
var G__7295 = cljs.core.next(coll);
var G__7296 = (n - (1));
var G__7297 = not_found;
coll = G__7295;
n = G__7296;
not_found = G__7297;
continue;
} else {
return not_found;

}
}
}
}
break;
}
});
linear_traversal_nth = function(coll,n,not_found){
switch(arguments.length){
case 2:
return linear_traversal_nth__2.call(this,coll,n);
case 3:
return linear_traversal_nth__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = linear_traversal_nth__2;
linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = linear_traversal_nth__3;
return linear_traversal_nth;
})()
;
/**
* Returns the value at the index. get returns nil if index out of
* bounds, nth throws an exception unless not-found is supplied.  nth
* also works for strings, arrays, regex Matchers and Lists, and,
* in O(n) time, for sequences.
*/
cljs.core.nth = (function() {
var nth = null;
var nth__2 = (function (coll,n){
if(!(typeof n === 'number')){
throw (new Error("index argument to nth must be a number"));
} else {
if((coll == null)){
return coll;
} else {
if((function (){var G__7302 = coll;
if(G__7302){
var bit__5776__auto__ = (G__7302.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__5776__auto__) || (G__7302.cljs$core$IIndexed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
if(Array.isArray(coll)){
if((n < coll.length)){
return (coll[n]);
} else {
return null;
}
} else {
if(typeof coll === 'string'){
if((n < coll.length)){
return (coll[n]);
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if((function (){var G__7303 = coll;
if(G__7303){
var bit__5783__auto__ = (G__7303.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__5783__auto__) || (G__7303.cljs$core$ISeq$)){
return true;
} else {
if((!G__7303.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__7303);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__7303);
}
})()){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});
var nth__3 = (function (coll,n,not_found){
if(!(typeof n === 'number')){
throw (new Error("index argument to nth must be a number."));
} else {
if((coll == null)){
return not_found;
} else {
if((function (){var G__7304 = coll;
if(G__7304){
var bit__5776__auto__ = (G__7304.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__5776__auto__) || (G__7304.cljs$core$IIndexed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$3(null,n,not_found);
} else {
if(Array.isArray(coll)){
if((n < coll.length)){
return (coll[n]);
} else {
return not_found;
}
} else {
if(typeof coll === 'string'){
if((n < coll.length)){
return (coll[n]);
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if((function (){var G__7305 = coll;
if(G__7305){
var bit__5783__auto__ = (G__7305.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__5783__auto__) || (G__7305.cljs$core$ISeq$)){
return true;
} else {
if((!G__7305.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__7305);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__7305);
}
})()){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});
nth = function(coll,n,not_found){
switch(arguments.length){
case 2:
return nth__2.call(this,coll,n);
case 3:
return nth__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
nth.cljs$core$IFn$_invoke$arity$2 = nth__2;
nth.cljs$core$IFn$_invoke$arity$3 = nth__3;
return nth;
})()
;
/**
* Returns the nth rest of coll, coll when n is 0.
*/
cljs.core.nthrest = (function nthrest(coll,n){
var n__$1 = n;
var xs = coll;
while(true){
if(((n__$1 > (0))) && (cljs.core.seq(xs))){
var G__7306 = (n__$1 - (1));
var G__7307 = cljs.core.rest(xs);
n__$1 = G__7306;
xs = G__7307;
continue;
} else {
return xs;
}
break;
}
});
/**
* Returns the value mapped to key, not-found or nil if key not present.
*/
cljs.core.get = (function() {
var get = null;
var get__2 = (function (o,k){
if((o == null)){
return null;
} else {
if((function (){var G__7310 = o;
if(G__7310){
var bit__5776__auto__ = (G__7310.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__5776__auto__) || (G__7310.cljs$core$ILookup$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$2(null,k);
} else {
if(Array.isArray(o)){
if((k < o.length)){
return (o[k]);
} else {
return null;
}
} else {
if(typeof o === 'string'){
if((k < o.length)){
return (o[k]);
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o,k);
} else {
return null;

}
}
}
}
}
});
var get__3 = (function (o,k,not_found){
if(!((o == null))){
if((function (){var G__7311 = o;
if(G__7311){
var bit__5776__auto__ = (G__7311.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__5776__auto__) || (G__7311.cljs$core$ILookup$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
} else {
if(Array.isArray(o)){
if((k < o.length)){
return (o[k]);
} else {
return not_found;
}
} else {
if(typeof o === 'string'){
if((k < o.length)){
return (o[k]);
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
} else {
return not_found;

}
}
}
}
} else {
return not_found;
}
});
get = function(o,k,not_found){
switch(arguments.length){
case 2:
return get__2.call(this,o,k);
case 3:
return get__3.call(this,o,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
get.cljs$core$IFn$_invoke$arity$2 = get__2;
get.cljs$core$IFn$_invoke$arity$3 = get__3;
return get;
})()
;
/**
* assoc[iate]. When applied to a map, returns a new map of the
* same (hashed/sorted) type, that contains the mapping of key(s) to
* val(s). When applied to a vector, returns a new vector that
* contains val at index.
* @param {...*} var_args
*/
cljs.core.assoc = (function() {
var assoc = null;
var assoc__3 = (function (coll,k,v){
if(!((coll == null))){
return cljs.core._assoc(coll,k,v);
} else {
return cljs.core.PersistentHashMap.fromArrays([k],[v]);
}
});
var assoc__4 = (function() { 
var G__7315__delegate = function (coll,k,v,kvs){
while(true){
var ret = assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);
if(cljs.core.truth_(kvs)){
var G__7316 = ret;
var G__7317 = cljs.core.first(kvs);
var G__7318 = cljs.core.second(kvs);
var G__7319 = cljs.core.nnext(kvs);
coll = G__7316;
k = G__7317;
v = G__7318;
kvs = G__7319;
continue;
} else {
return ret;
}
break;
}
};
var G__7315 = function (coll,k,v,var_args){
var kvs = null;
if (arguments.length > 3) {
var G__7320__i = 0, G__7320__a = new Array(arguments.length -  3);
while (G__7320__i < G__7320__a.length) {G__7320__a[G__7320__i] = arguments[G__7320__i + 3]; ++G__7320__i;}
  kvs = new cljs.core.IndexedSeq(G__7320__a,0);
} 
return G__7315__delegate.call(this,coll,k,v,kvs);};
G__7315.cljs$lang$maxFixedArity = 3;
G__7315.cljs$lang$applyTo = (function (arglist__7321){
var coll = cljs.core.first(arglist__7321);
arglist__7321 = cljs.core.next(arglist__7321);
var k = cljs.core.first(arglist__7321);
arglist__7321 = cljs.core.next(arglist__7321);
var v = cljs.core.first(arglist__7321);
var kvs = cljs.core.rest(arglist__7321);
return G__7315__delegate(coll,k,v,kvs);
});
G__7315.cljs$core$IFn$_invoke$arity$variadic = G__7315__delegate;
return G__7315;
})()
;
assoc = function(coll,k,v,var_args){
var kvs = var_args;
switch(arguments.length){
case 3:
return assoc__3.call(this,coll,k,v);
default:
var G__7322 = null;
if (arguments.length > 3) {
var G__7323__i = 0, G__7323__a = new Array(arguments.length -  3);
while (G__7323__i < G__7323__a.length) {G__7323__a[G__7323__i] = arguments[G__7323__i + 3]; ++G__7323__i;}
G__7322 = new cljs.core.IndexedSeq(G__7323__a,0);
}
return assoc__4.cljs$core$IFn$_invoke$arity$variadic(coll,k,v, G__7322);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
assoc.cljs$lang$maxFixedArity = 3;
assoc.cljs$lang$applyTo = assoc__4.cljs$lang$applyTo;
assoc.cljs$core$IFn$_invoke$arity$3 = assoc__3;
assoc.cljs$core$IFn$_invoke$arity$variadic = assoc__4.cljs$core$IFn$_invoke$arity$variadic;
return assoc;
})()
;
/**
* dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
* that does not contain a mapping for key(s).
* @param {...*} var_args
*/
cljs.core.dissoc = (function() {
var dissoc = null;
var dissoc__1 = (function (coll){
return coll;
});
var dissoc__2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._dissoc(coll,k);
}
});
var dissoc__3 = (function() { 
var G__7326__delegate = function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__7327 = ret;
var G__7328 = cljs.core.first(ks);
var G__7329 = cljs.core.next(ks);
coll = G__7327;
k = G__7328;
ks = G__7329;
continue;
} else {
return ret;
}
}
break;
}
};
var G__7326 = function (coll,k,var_args){
var ks = null;
if (arguments.length > 2) {
var G__7330__i = 0, G__7330__a = new Array(arguments.length -  2);
while (G__7330__i < G__7330__a.length) {G__7330__a[G__7330__i] = arguments[G__7330__i + 2]; ++G__7330__i;}
  ks = new cljs.core.IndexedSeq(G__7330__a,0);
} 
return G__7326__delegate.call(this,coll,k,ks);};
G__7326.cljs$lang$maxFixedArity = 2;
G__7326.cljs$lang$applyTo = (function (arglist__7331){
var coll = cljs.core.first(arglist__7331);
arglist__7331 = cljs.core.next(arglist__7331);
var k = cljs.core.first(arglist__7331);
var ks = cljs.core.rest(arglist__7331);
return G__7326__delegate(coll,k,ks);
});
G__7326.cljs$core$IFn$_invoke$arity$variadic = G__7326__delegate;
return G__7326;
})()
;
dissoc = function(coll,k,var_args){
var ks = var_args;
switch(arguments.length){
case 1:
return dissoc__1.call(this,coll);
case 2:
return dissoc__2.call(this,coll,k);
default:
var G__7332 = null;
if (arguments.length > 2) {
var G__7333__i = 0, G__7333__a = new Array(arguments.length -  2);
while (G__7333__i < G__7333__a.length) {G__7333__a[G__7333__i] = arguments[G__7333__i + 2]; ++G__7333__i;}
G__7332 = new cljs.core.IndexedSeq(G__7333__a,0);
}
return dissoc__3.cljs$core$IFn$_invoke$arity$variadic(coll,k, G__7332);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
dissoc.cljs$lang$maxFixedArity = 2;
dissoc.cljs$lang$applyTo = dissoc__3.cljs$lang$applyTo;
dissoc.cljs$core$IFn$_invoke$arity$1 = dissoc__1;
dissoc.cljs$core$IFn$_invoke$arity$2 = dissoc__2;
dissoc.cljs$core$IFn$_invoke$arity$variadic = dissoc__3.cljs$core$IFn$_invoke$arity$variadic;
return dissoc;
})()
;
cljs.core.fn_QMARK_ = (function fn_QMARK_(f){
var or__5102__auto__ = (function (){var G__7338 = f;
return goog.isFunction(G__7338);
})();
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
var G__7339 = f;
if(G__7339){
var bit__5783__auto__ = null;
if(cljs.core.truth_((function (){var or__5102__auto____$1 = bit__5783__auto__;
if(cljs.core.truth_(or__5102__auto____$1)){
return or__5102__auto____$1;
} else {
return G__7339.cljs$core$Fn$;
}
})())){
return true;
} else {
if((!G__7339.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,G__7339);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,G__7339);
}
}
});

/**
* @constructor
*/
cljs.core.MetaFn = (function (afn,meta){
this.afn = afn;
this.meta = meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393217;
})
cljs.core.MetaFn.prototype.call = (function() {
var G__7805 = null;
var G__7805__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});
var G__7805__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__7341 = a;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__7341) : self__.afn.call(null,G__7341));
});
var G__7805__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__7342 = a;
var G__7343 = b;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__7342,G__7343) : self__.afn.call(null,G__7342,G__7343));
});
var G__7805__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__7344 = a;
var G__7345 = b;
var G__7346 = c;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__7344,G__7345,G__7346) : self__.afn.call(null,G__7344,G__7345,G__7346));
});
var G__7805__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__7347 = a;
var G__7348 = b;
var G__7349 = c;
var G__7350 = d;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__7347,G__7348,G__7349,G__7350) : self__.afn.call(null,G__7347,G__7348,G__7349,G__7350));
});
var G__7805__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__7351 = a;
var G__7352 = b;
var G__7353 = c;
var G__7354 = d;
var G__7355 = e;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__7351,G__7352,G__7353,G__7354,G__7355) : self__.afn.call(null,G__7351,G__7352,G__7353,G__7354,G__7355));
});
var G__7805__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__7356 = a;
var G__7357 = b;
var G__7358 = c;
var G__7359 = d;
var G__7360 = e;
var G__7361 = f;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__7356,G__7357,G__7358,G__7359,G__7360,G__7361) : self__.afn.call(null,G__7356,G__7357,G__7358,G__7359,G__7360,G__7361));
});
var G__7805__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__7362 = a;
var G__7363 = b;
var G__7364 = c;
var G__7365 = d;
var G__7366 = e;
var G__7367 = f;
var G__7368 = g;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__7362,G__7363,G__7364,G__7365,G__7366,G__7367,G__7368) : self__.afn.call(null,G__7362,G__7363,G__7364,G__7365,G__7366,G__7367,G__7368));
});
var G__7805__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__7369 = a;
var G__7370 = b;
var G__7371 = c;
var G__7372 = d;
var G__7373 = e;
var G__7374 = f;
var G__7375 = g;
var G__7376 = h;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__7369,G__7370,G__7371,G__7372,G__7373,G__7374,G__7375,G__7376) : self__.afn.call(null,G__7369,G__7370,G__7371,G__7372,G__7373,G__7374,G__7375,G__7376));
});
var G__7805__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__7377 = a;
var G__7378 = b;
var G__7379 = c;
var G__7380 = d;
var G__7381 = e;
var G__7382 = f;
var G__7383 = g;
var G__7384 = h;
var G__7385 = i;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__7377,G__7378,G__7379,G__7380,G__7381,G__7382,G__7383,G__7384,G__7385) : self__.afn.call(null,G__7377,G__7378,G__7379,G__7380,G__7381,G__7382,G__7383,G__7384,G__7385));
});
var G__7805__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__7386 = a;
var G__7387 = b;
var G__7388 = c;
var G__7389 = d;
var G__7390 = e;
var G__7391 = f;
var G__7392 = g;
var G__7393 = h;
var G__7394 = i;
var G__7395 = j;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__7386,G__7387,G__7388,G__7389,G__7390,G__7391,G__7392,G__7393,G__7394,G__7395) : self__.afn.call(null,G__7386,G__7387,G__7388,G__7389,G__7390,G__7391,G__7392,G__7393,G__7394,G__7395));
});
var G__7805__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__7396 = a;
var G__7397 = b;
var G__7398 = c;
var G__7399 = d;
var G__7400 = e;
var G__7401 = f;
var G__7402 = g;
var G__7403 = h;
var G__7404 = i;
var G__7405 = j;
var G__7406 = k;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__7396,G__7397,G__7398,G__7399,G__7400,G__7401,G__7402,G__7403,G__7404,G__7405,G__7406) : self__.afn.call(null,G__7396,G__7397,G__7398,G__7399,G__7400,G__7401,G__7402,G__7403,G__7404,G__7405,G__7406));
});
var G__7805__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__7407 = a;
var G__7408 = b;
var G__7409 = c;
var G__7410 = d;
var G__7411 = e;
var G__7412 = f;
var G__7413 = g;
var G__7414 = h;
var G__7415 = i;
var G__7416 = j;
var G__7417 = k;
var G__7418 = l;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__7407,G__7408,G__7409,G__7410,G__7411,G__7412,G__7413,G__7414,G__7415,G__7416,G__7417,G__7418) : self__.afn.call(null,G__7407,G__7408,G__7409,G__7410,G__7411,G__7412,G__7413,G__7414,G__7415,G__7416,G__7417,G__7418));
});
var G__7805__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__7419 = a;
var G__7420 = b;
var G__7421 = c;
var G__7422 = d;
var G__7423 = e;
var G__7424 = f;
var G__7425 = g;
var G__7426 = h;
var G__7427 = i;
var G__7428 = j;
var G__7429 = k;
var G__7430 = l;
var G__7431 = m;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__7419,G__7420,G__7421,G__7422,G__7423,G__7424,G__7425,G__7426,G__7427,G__7428,G__7429,G__7430,G__7431) : self__.afn.call(null,G__7419,G__7420,G__7421,G__7422,G__7423,G__7424,G__7425,G__7426,G__7427,G__7428,G__7429,G__7430,G__7431));
});
var G__7805__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__7432 = a;
var G__7433 = b;
var G__7434 = c;
var G__7435 = d;
var G__7436 = e;
var G__7437 = f;
var G__7438 = g;
var G__7439 = h;
var G__7440 = i;
var G__7441 = j;
var G__7442 = k;
var G__7443 = l;
var G__7444 = m;
var G__7445 = n;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__7432,G__7433,G__7434,G__7435,G__7436,G__7437,G__7438,G__7439,G__7440,G__7441,G__7442,G__7443,G__7444,G__7445) : self__.afn.call(null,G__7432,G__7433,G__7434,G__7435,G__7436,G__7437,G__7438,G__7439,G__7440,G__7441,G__7442,G__7443,G__7444,G__7445));
});
var G__7805__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__7446 = a;
var G__7447 = b;
var G__7448 = c;
var G__7449 = d;
var G__7450 = e;
var G__7451 = f;
var G__7452 = g;
var G__7453 = h;
var G__7454 = i;
var G__7455 = j;
var G__7456 = k;
var G__7457 = l;
var G__7458 = m;
var G__7459 = n;
var G__7460 = o;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__7446,G__7447,G__7448,G__7449,G__7450,G__7451,G__7452,G__7453,G__7454,G__7455,G__7456,G__7457,G__7458,G__7459,G__7460) : self__.afn.call(null,G__7446,G__7447,G__7448,G__7449,G__7450,G__7451,G__7452,G__7453,G__7454,G__7455,G__7456,G__7457,G__7458,G__7459,G__7460));
});
var G__7805__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__7461 = a;
var G__7462 = b;
var G__7463 = c;
var G__7464 = d;
var G__7465 = e;
var G__7466 = f;
var G__7467 = g;
var G__7468 = h;
var G__7469 = i;
var G__7470 = j;
var G__7471 = k;
var G__7472 = l;
var G__7473 = m;
var G__7474 = n;
var G__7475 = o;
var G__7476 = p;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__7461,G__7462,G__7463,G__7464,G__7465,G__7466,G__7467,G__7468,G__7469,G__7470,G__7471,G__7472,G__7473,G__7474,G__7475,G__7476) : self__.afn.call(null,G__7461,G__7462,G__7463,G__7464,G__7465,G__7466,G__7467,G__7468,G__7469,G__7470,G__7471,G__7472,G__7473,G__7474,G__7475,G__7476));
});
var G__7805__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__7477 = a;
var G__7478 = b;
var G__7479 = c;
var G__7480 = d;
var G__7481 = e;
var G__7482 = f;
var G__7483 = g;
var G__7484 = h;
var G__7485 = i;
var G__7486 = j;
var G__7487 = k;
var G__7488 = l;
var G__7489 = m;
var G__7490 = n;
var G__7491 = o;
var G__7492 = p;
var G__7493 = q;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__7477,G__7478,G__7479,G__7480,G__7481,G__7482,G__7483,G__7484,G__7485,G__7486,G__7487,G__7488,G__7489,G__7490,G__7491,G__7492,G__7493) : self__.afn.call(null,G__7477,G__7478,G__7479,G__7480,G__7481,G__7482,G__7483,G__7484,G__7485,G__7486,G__7487,G__7488,G__7489,G__7490,G__7491,G__7492,G__7493));
});
var G__7805__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__7494 = a;
var G__7495 = b;
var G__7496 = c;
var G__7497 = d;
var G__7498 = e;
var G__7499 = f;
var G__7500 = g;
var G__7501 = h;
var G__7502 = i;
var G__7503 = j;
var G__7504 = k;
var G__7505 = l;
var G__7506 = m;
var G__7507 = n;
var G__7508 = o;
var G__7509 = p;
var G__7510 = q;
var G__7511 = r;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__7494,G__7495,G__7496,G__7497,G__7498,G__7499,G__7500,G__7501,G__7502,G__7503,G__7504,G__7505,G__7506,G__7507,G__7508,G__7509,G__7510,G__7511) : self__.afn.call(null,G__7494,G__7495,G__7496,G__7497,G__7498,G__7499,G__7500,G__7501,G__7502,G__7503,G__7504,G__7505,G__7506,G__7507,G__7508,G__7509,G__7510,G__7511));
});
var G__7805__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__7512 = a;
var G__7513 = b;
var G__7514 = c;
var G__7515 = d;
var G__7516 = e;
var G__7517 = f;
var G__7518 = g;
var G__7519 = h;
var G__7520 = i;
var G__7521 = j;
var G__7522 = k;
var G__7523 = l;
var G__7524 = m;
var G__7525 = n;
var G__7526 = o;
var G__7527 = p;
var G__7528 = q;
var G__7529 = r;
var G__7530 = s;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__7512,G__7513,G__7514,G__7515,G__7516,G__7517,G__7518,G__7519,G__7520,G__7521,G__7522,G__7523,G__7524,G__7525,G__7526,G__7527,G__7528,G__7529,G__7530) : self__.afn.call(null,G__7512,G__7513,G__7514,G__7515,G__7516,G__7517,G__7518,G__7519,G__7520,G__7521,G__7522,G__7523,G__7524,G__7525,G__7526,G__7527,G__7528,G__7529,G__7530));
});
var G__7805__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__7531 = a;
var G__7532 = b;
var G__7533 = c;
var G__7534 = d;
var G__7535 = e;
var G__7536 = f;
var G__7537 = g;
var G__7538 = h;
var G__7539 = i;
var G__7540 = j;
var G__7541 = k;
var G__7542 = l;
var G__7543 = m;
var G__7544 = n;
var G__7545 = o;
var G__7546 = p;
var G__7547 = q;
var G__7548 = r;
var G__7549 = s;
var G__7550 = t;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__7531,G__7532,G__7533,G__7534,G__7535,G__7536,G__7537,G__7538,G__7539,G__7540,G__7541,G__7542,G__7543,G__7544,G__7545,G__7546,G__7547,G__7548,G__7549,G__7550) : self__.afn.call(null,G__7531,G__7532,G__7533,G__7534,G__7535,G__7536,G__7537,G__7538,G__7539,G__7540,G__7541,G__7542,G__7543,G__7544,G__7545,G__7546,G__7547,G__7548,G__7549,G__7550));
});
var G__7805__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__7551 = self__.afn;
var G__7552 = a;
var G__7553 = b;
var G__7554 = c;
var G__7555 = d;
var G__7556 = e;
var G__7557 = f;
var G__7558 = g;
var G__7559 = h;
var G__7560 = i;
var G__7561 = j;
var G__7562 = k;
var G__7563 = l;
var G__7564 = m;
var G__7565 = n;
var G__7566 = o;
var G__7567 = p;
var G__7568 = q;
var G__7569 = r;
var G__7570 = s;
var G__7571 = t;
var G__7572 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__7551,G__7552,G__7553,G__7554,G__7555,G__7556,G__7557,G__7558,G__7559,G__7560,G__7561,G__7562,G__7563,G__7564,G__7565,G__7566,G__7567,G__7568,G__7569,G__7570,G__7571,G__7572) : cljs.core.apply.call(null,G__7551,G__7552,G__7553,G__7554,G__7555,G__7556,G__7557,G__7558,G__7559,G__7560,G__7561,G__7562,G__7563,G__7564,G__7565,G__7566,G__7567,G__7568,G__7569,G__7570,G__7571,G__7572));
});
G__7805 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__7805__1.call(this,self__);
case 2:
return G__7805__2.call(this,self__,a);
case 3:
return G__7805__3.call(this,self__,a,b);
case 4:
return G__7805__4.call(this,self__,a,b,c);
case 5:
return G__7805__5.call(this,self__,a,b,c,d);
case 6:
return G__7805__6.call(this,self__,a,b,c,d,e);
case 7:
return G__7805__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__7805__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__7805__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__7805__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__7805__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__7805__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__7805__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__7805__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__7805__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__7805__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__7805__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__7805__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__7805__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__7805__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__7805__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__7805__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7805.cljs$core$IFn$_invoke$arity$1 = G__7805__1;
G__7805.cljs$core$IFn$_invoke$arity$2 = G__7805__2;
G__7805.cljs$core$IFn$_invoke$arity$3 = G__7805__3;
G__7805.cljs$core$IFn$_invoke$arity$4 = G__7805__4;
G__7805.cljs$core$IFn$_invoke$arity$5 = G__7805__5;
G__7805.cljs$core$IFn$_invoke$arity$6 = G__7805__6;
G__7805.cljs$core$IFn$_invoke$arity$7 = G__7805__7;
G__7805.cljs$core$IFn$_invoke$arity$8 = G__7805__8;
G__7805.cljs$core$IFn$_invoke$arity$9 = G__7805__9;
G__7805.cljs$core$IFn$_invoke$arity$10 = G__7805__10;
G__7805.cljs$core$IFn$_invoke$arity$11 = G__7805__11;
G__7805.cljs$core$IFn$_invoke$arity$12 = G__7805__12;
G__7805.cljs$core$IFn$_invoke$arity$13 = G__7805__13;
G__7805.cljs$core$IFn$_invoke$arity$14 = G__7805__14;
G__7805.cljs$core$IFn$_invoke$arity$15 = G__7805__15;
G__7805.cljs$core$IFn$_invoke$arity$16 = G__7805__16;
G__7805.cljs$core$IFn$_invoke$arity$17 = G__7805__17;
G__7805.cljs$core$IFn$_invoke$arity$18 = G__7805__18;
G__7805.cljs$core$IFn$_invoke$arity$19 = G__7805__19;
G__7805.cljs$core$IFn$_invoke$arity$20 = G__7805__20;
G__7805.cljs$core$IFn$_invoke$arity$21 = G__7805__21;
G__7805.cljs$core$IFn$_invoke$arity$22 = G__7805__22;
return G__7805;
})()
;

cljs.core.MetaFn.prototype.apply = (function (self__,args7340){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args7340)));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
var G__7573 = a;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__7573) : self__.afn.call(null,G__7573));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
var G__7574 = a;
var G__7575 = b;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__7574,G__7575) : self__.afn.call(null,G__7574,G__7575));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
var G__7576 = a;
var G__7577 = b;
var G__7578 = c;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__7576,G__7577,G__7578) : self__.afn.call(null,G__7576,G__7577,G__7578));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
var G__7579 = a;
var G__7580 = b;
var G__7581 = c;
var G__7582 = d;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__7579,G__7580,G__7581,G__7582) : self__.afn.call(null,G__7579,G__7580,G__7581,G__7582));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
var G__7583 = a;
var G__7584 = b;
var G__7585 = c;
var G__7586 = d;
var G__7587 = e;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__7583,G__7584,G__7585,G__7586,G__7587) : self__.afn.call(null,G__7583,G__7584,G__7585,G__7586,G__7587));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
var G__7588 = a;
var G__7589 = b;
var G__7590 = c;
var G__7591 = d;
var G__7592 = e;
var G__7593 = f;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__7588,G__7589,G__7590,G__7591,G__7592,G__7593) : self__.afn.call(null,G__7588,G__7589,G__7590,G__7591,G__7592,G__7593));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
var G__7594 = a;
var G__7595 = b;
var G__7596 = c;
var G__7597 = d;
var G__7598 = e;
var G__7599 = f;
var G__7600 = g;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__7594,G__7595,G__7596,G__7597,G__7598,G__7599,G__7600) : self__.afn.call(null,G__7594,G__7595,G__7596,G__7597,G__7598,G__7599,G__7600));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
var G__7601 = a;
var G__7602 = b;
var G__7603 = c;
var G__7604 = d;
var G__7605 = e;
var G__7606 = f;
var G__7607 = g;
var G__7608 = h;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__7601,G__7602,G__7603,G__7604,G__7605,G__7606,G__7607,G__7608) : self__.afn.call(null,G__7601,G__7602,G__7603,G__7604,G__7605,G__7606,G__7607,G__7608));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
var G__7609 = a;
var G__7610 = b;
var G__7611 = c;
var G__7612 = d;
var G__7613 = e;
var G__7614 = f;
var G__7615 = g;
var G__7616 = h;
var G__7617 = i;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__7609,G__7610,G__7611,G__7612,G__7613,G__7614,G__7615,G__7616,G__7617) : self__.afn.call(null,G__7609,G__7610,G__7611,G__7612,G__7613,G__7614,G__7615,G__7616,G__7617));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
var G__7618 = a;
var G__7619 = b;
var G__7620 = c;
var G__7621 = d;
var G__7622 = e;
var G__7623 = f;
var G__7624 = g;
var G__7625 = h;
var G__7626 = i;
var G__7627 = j;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__7618,G__7619,G__7620,G__7621,G__7622,G__7623,G__7624,G__7625,G__7626,G__7627) : self__.afn.call(null,G__7618,G__7619,G__7620,G__7621,G__7622,G__7623,G__7624,G__7625,G__7626,G__7627));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
var G__7628 = a;
var G__7629 = b;
var G__7630 = c;
var G__7631 = d;
var G__7632 = e;
var G__7633 = f;
var G__7634 = g;
var G__7635 = h;
var G__7636 = i;
var G__7637 = j;
var G__7638 = k;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__7628,G__7629,G__7630,G__7631,G__7632,G__7633,G__7634,G__7635,G__7636,G__7637,G__7638) : self__.afn.call(null,G__7628,G__7629,G__7630,G__7631,G__7632,G__7633,G__7634,G__7635,G__7636,G__7637,G__7638));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
var G__7639 = a;
var G__7640 = b;
var G__7641 = c;
var G__7642 = d;
var G__7643 = e;
var G__7644 = f;
var G__7645 = g;
var G__7646 = h;
var G__7647 = i;
var G__7648 = j;
var G__7649 = k;
var G__7650 = l;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__7639,G__7640,G__7641,G__7642,G__7643,G__7644,G__7645,G__7646,G__7647,G__7648,G__7649,G__7650) : self__.afn.call(null,G__7639,G__7640,G__7641,G__7642,G__7643,G__7644,G__7645,G__7646,G__7647,G__7648,G__7649,G__7650));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
var G__7651 = a;
var G__7652 = b;
var G__7653 = c;
var G__7654 = d;
var G__7655 = e;
var G__7656 = f;
var G__7657 = g;
var G__7658 = h;
var G__7659 = i;
var G__7660 = j;
var G__7661 = k;
var G__7662 = l;
var G__7663 = m;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__7651,G__7652,G__7653,G__7654,G__7655,G__7656,G__7657,G__7658,G__7659,G__7660,G__7661,G__7662,G__7663) : self__.afn.call(null,G__7651,G__7652,G__7653,G__7654,G__7655,G__7656,G__7657,G__7658,G__7659,G__7660,G__7661,G__7662,G__7663));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
var G__7664 = a;
var G__7665 = b;
var G__7666 = c;
var G__7667 = d;
var G__7668 = e;
var G__7669 = f;
var G__7670 = g;
var G__7671 = h;
var G__7672 = i;
var G__7673 = j;
var G__7674 = k;
var G__7675 = l;
var G__7676 = m;
var G__7677 = n;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__7664,G__7665,G__7666,G__7667,G__7668,G__7669,G__7670,G__7671,G__7672,G__7673,G__7674,G__7675,G__7676,G__7677) : self__.afn.call(null,G__7664,G__7665,G__7666,G__7667,G__7668,G__7669,G__7670,G__7671,G__7672,G__7673,G__7674,G__7675,G__7676,G__7677));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
var G__7678 = a;
var G__7679 = b;
var G__7680 = c;
var G__7681 = d;
var G__7682 = e;
var G__7683 = f;
var G__7684 = g;
var G__7685 = h;
var G__7686 = i;
var G__7687 = j;
var G__7688 = k;
var G__7689 = l;
var G__7690 = m;
var G__7691 = n;
var G__7692 = o;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__7678,G__7679,G__7680,G__7681,G__7682,G__7683,G__7684,G__7685,G__7686,G__7687,G__7688,G__7689,G__7690,G__7691,G__7692) : self__.afn.call(null,G__7678,G__7679,G__7680,G__7681,G__7682,G__7683,G__7684,G__7685,G__7686,G__7687,G__7688,G__7689,G__7690,G__7691,G__7692));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
var G__7693 = a;
var G__7694 = b;
var G__7695 = c;
var G__7696 = d;
var G__7697 = e;
var G__7698 = f;
var G__7699 = g;
var G__7700 = h;
var G__7701 = i;
var G__7702 = j;
var G__7703 = k;
var G__7704 = l;
var G__7705 = m;
var G__7706 = n;
var G__7707 = o;
var G__7708 = p;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__7693,G__7694,G__7695,G__7696,G__7697,G__7698,G__7699,G__7700,G__7701,G__7702,G__7703,G__7704,G__7705,G__7706,G__7707,G__7708) : self__.afn.call(null,G__7693,G__7694,G__7695,G__7696,G__7697,G__7698,G__7699,G__7700,G__7701,G__7702,G__7703,G__7704,G__7705,G__7706,G__7707,G__7708));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
var G__7709 = a;
var G__7710 = b;
var G__7711 = c;
var G__7712 = d;
var G__7713 = e;
var G__7714 = f;
var G__7715 = g;
var G__7716 = h;
var G__7717 = i;
var G__7718 = j;
var G__7719 = k;
var G__7720 = l;
var G__7721 = m;
var G__7722 = n;
var G__7723 = o;
var G__7724 = p;
var G__7725 = q;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__7709,G__7710,G__7711,G__7712,G__7713,G__7714,G__7715,G__7716,G__7717,G__7718,G__7719,G__7720,G__7721,G__7722,G__7723,G__7724,G__7725) : self__.afn.call(null,G__7709,G__7710,G__7711,G__7712,G__7713,G__7714,G__7715,G__7716,G__7717,G__7718,G__7719,G__7720,G__7721,G__7722,G__7723,G__7724,G__7725));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
var G__7726 = a;
var G__7727 = b;
var G__7728 = c;
var G__7729 = d;
var G__7730 = e;
var G__7731 = f;
var G__7732 = g;
var G__7733 = h;
var G__7734 = i;
var G__7735 = j;
var G__7736 = k;
var G__7737 = l;
var G__7738 = m;
var G__7739 = n;
var G__7740 = o;
var G__7741 = p;
var G__7742 = q;
var G__7743 = r;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__7726,G__7727,G__7728,G__7729,G__7730,G__7731,G__7732,G__7733,G__7734,G__7735,G__7736,G__7737,G__7738,G__7739,G__7740,G__7741,G__7742,G__7743) : self__.afn.call(null,G__7726,G__7727,G__7728,G__7729,G__7730,G__7731,G__7732,G__7733,G__7734,G__7735,G__7736,G__7737,G__7738,G__7739,G__7740,G__7741,G__7742,G__7743));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
var G__7744 = a;
var G__7745 = b;
var G__7746 = c;
var G__7747 = d;
var G__7748 = e;
var G__7749 = f;
var G__7750 = g;
var G__7751 = h;
var G__7752 = i;
var G__7753 = j;
var G__7754 = k;
var G__7755 = l;
var G__7756 = m;
var G__7757 = n;
var G__7758 = o;
var G__7759 = p;
var G__7760 = q;
var G__7761 = r;
var G__7762 = s;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__7744,G__7745,G__7746,G__7747,G__7748,G__7749,G__7750,G__7751,G__7752,G__7753,G__7754,G__7755,G__7756,G__7757,G__7758,G__7759,G__7760,G__7761,G__7762) : self__.afn.call(null,G__7744,G__7745,G__7746,G__7747,G__7748,G__7749,G__7750,G__7751,G__7752,G__7753,G__7754,G__7755,G__7756,G__7757,G__7758,G__7759,G__7760,G__7761,G__7762));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
var G__7763 = a;
var G__7764 = b;
var G__7765 = c;
var G__7766 = d;
var G__7767 = e;
var G__7768 = f;
var G__7769 = g;
var G__7770 = h;
var G__7771 = i;
var G__7772 = j;
var G__7773 = k;
var G__7774 = l;
var G__7775 = m;
var G__7776 = n;
var G__7777 = o;
var G__7778 = p;
var G__7779 = q;
var G__7780 = r;
var G__7781 = s;
var G__7782 = t;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__7763,G__7764,G__7765,G__7766,G__7767,G__7768,G__7769,G__7770,G__7771,G__7772,G__7773,G__7774,G__7775,G__7776,G__7777,G__7778,G__7779,G__7780,G__7781,G__7782) : self__.afn.call(null,G__7763,G__7764,G__7765,G__7766,G__7767,G__7768,G__7769,G__7770,G__7771,G__7772,G__7773,G__7774,G__7775,G__7776,G__7777,G__7778,G__7779,G__7780,G__7781,G__7782));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__7783 = self__.afn;
var G__7784 = a;
var G__7785 = b;
var G__7786 = c;
var G__7787 = d;
var G__7788 = e;
var G__7789 = f;
var G__7790 = g;
var G__7791 = h;
var G__7792 = i;
var G__7793 = j;
var G__7794 = k;
var G__7795 = l;
var G__7796 = m;
var G__7797 = n;
var G__7798 = o;
var G__7799 = p;
var G__7800 = q;
var G__7801 = r;
var G__7802 = s;
var G__7803 = t;
var G__7804 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__7783,G__7784,G__7785,G__7786,G__7787,G__7788,G__7789,G__7790,G__7791,G__7792,G__7793,G__7794,G__7795,G__7796,G__7797,G__7798,G__7799,G__7800,G__7801,G__7802,G__7803,G__7804) : cljs.core.apply.call(null,G__7783,G__7784,G__7785,G__7786,G__7787,G__7788,G__7789,G__7790,G__7791,G__7792,G__7793,G__7794,G__7795,G__7796,G__7797,G__7798,G__7799,G__7800,G__7801,G__7802,G__7803,G__7804));
});

cljs.core.MetaFn.prototype.cljs$core$Fn$ = true;

cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.MetaFn(self__.afn,new_meta));
});

cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.MetaFn.cljs$lang$type = true;

cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn";

cljs.core.MetaFn.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/MetaFn");
});

cljs.core.__GT_MetaFn = (function __GT_MetaFn(afn,meta){
return (new cljs.core.MetaFn(afn,meta));
});

/**
* Returns an object of the same type and value as obj, with
* map m as its metadata.
*/
cljs.core.with_meta = (function with_meta(o,meta){
if((cljs.core.fn_QMARK_(o)) && (!((function (){var G__7809 = o;
if(G__7809){
var bit__5783__auto__ = (G__7809.cljs$lang$protocol_mask$partition0$ & (262144));
if((bit__5783__auto__) || (G__7809.cljs$core$IWithMeta$)){
return true;
} else {
if((!G__7809.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta,G__7809);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta,G__7809);
}
})()))){
return (new cljs.core.MetaFn(o,meta));
} else {
if((o == null)){
return null;
} else {
return cljs.core._with_meta(o,meta);
}
}
});
/**
* Returns the metadata of obj, returns nil if there is no metadata.
*/
cljs.core.meta = (function meta(o){
if((function (){var and__5090__auto__ = !((o == null));
if(and__5090__auto__){
var G__7813 = o;
if(G__7813){
var bit__5783__auto__ = (G__7813.cljs$lang$protocol_mask$partition0$ & (131072));
if((bit__5783__auto__) || (G__7813.cljs$core$IMeta$)){
return true;
} else {
if((!G__7813.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__7813);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__7813);
}
} else {
return and__5090__auto__;
}
})()){
return cljs.core._meta(o);
} else {
return null;
}
});
/**
* For a list or queue, same as first, for a vector, same as, but much
* more efficient than, last. If the collection is empty, returns nil.
*/
cljs.core.peek = (function peek(coll){
if((coll == null)){
return null;
} else {
return cljs.core._peek(coll);
}
});
/**
* For a list or queue, returns a new list/queue without the first
* item, for a vector, returns a new vector without the last item.
* Note - not the same as next/butlast.
*/
cljs.core.pop = (function pop(coll){
if((coll == null)){
return null;
} else {
return cljs.core._pop(coll);
}
});
/**
* disj[oin]. Returns a new set of the same (hashed/sorted) type, that
* does not contain key(s).
* @param {...*} var_args
*/
cljs.core.disj = (function() {
var disj = null;
var disj__1 = (function (coll){
return coll;
});
var disj__2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._disjoin(coll,k);
}
});
var disj__3 = (function() { 
var G__7816__delegate = function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = disj.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__7817 = ret;
var G__7818 = cljs.core.first(ks);
var G__7819 = cljs.core.next(ks);
coll = G__7817;
k = G__7818;
ks = G__7819;
continue;
} else {
return ret;
}
}
break;
}
};
var G__7816 = function (coll,k,var_args){
var ks = null;
if (arguments.length > 2) {
var G__7820__i = 0, G__7820__a = new Array(arguments.length -  2);
while (G__7820__i < G__7820__a.length) {G__7820__a[G__7820__i] = arguments[G__7820__i + 2]; ++G__7820__i;}
  ks = new cljs.core.IndexedSeq(G__7820__a,0);
} 
return G__7816__delegate.call(this,coll,k,ks);};
G__7816.cljs$lang$maxFixedArity = 2;
G__7816.cljs$lang$applyTo = (function (arglist__7821){
var coll = cljs.core.first(arglist__7821);
arglist__7821 = cljs.core.next(arglist__7821);
var k = cljs.core.first(arglist__7821);
var ks = cljs.core.rest(arglist__7821);
return G__7816__delegate(coll,k,ks);
});
G__7816.cljs$core$IFn$_invoke$arity$variadic = G__7816__delegate;
return G__7816;
})()
;
disj = function(coll,k,var_args){
var ks = var_args;
switch(arguments.length){
case 1:
return disj__1.call(this,coll);
case 2:
return disj__2.call(this,coll,k);
default:
var G__7822 = null;
if (arguments.length > 2) {
var G__7823__i = 0, G__7823__a = new Array(arguments.length -  2);
while (G__7823__i < G__7823__a.length) {G__7823__a[G__7823__i] = arguments[G__7823__i + 2]; ++G__7823__i;}
G__7822 = new cljs.core.IndexedSeq(G__7823__a,0);
}
return disj__3.cljs$core$IFn$_invoke$arity$variadic(coll,k, G__7822);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
disj.cljs$lang$maxFixedArity = 2;
disj.cljs$lang$applyTo = disj__3.cljs$lang$applyTo;
disj.cljs$core$IFn$_invoke$arity$1 = disj__1;
disj.cljs$core$IFn$_invoke$arity$2 = disj__2;
disj.cljs$core$IFn$_invoke$arity$variadic = disj__3.cljs$core$IFn$_invoke$arity$variadic;
return disj;
})()
;
/**
* Returns true if coll has no items - same as (not (seq coll)).
* Please use the idiom (seq x) rather than (not (empty? x))
*/
cljs.core.empty_QMARK_ = (function empty_QMARK_(coll){
return ((coll == null)) || (cljs.core.not(cljs.core.seq(coll)));
});
/**
* Returns true if x satisfies ICollection
*/
cljs.core.coll_QMARK_ = (function coll_QMARK_(x){
if((x == null)){
return false;
} else {
var G__7825 = x;
if(G__7825){
var bit__5783__auto__ = (G__7825.cljs$lang$protocol_mask$partition0$ & (8));
if((bit__5783__auto__) || (G__7825.cljs$core$ICollection$)){
return true;
} else {
if((!G__7825.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,G__7825);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,G__7825);
}
}
});
/**
* Returns true if x satisfies ISet
*/
cljs.core.set_QMARK_ = (function set_QMARK_(x){
if((x == null)){
return false;
} else {
var G__7827 = x;
if(G__7827){
var bit__5783__auto__ = (G__7827.cljs$lang$protocol_mask$partition0$ & (4096));
if((bit__5783__auto__) || (G__7827.cljs$core$ISet$)){
return true;
} else {
if((!G__7827.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,G__7827);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,G__7827);
}
}
});
/**
* Returns true if coll implements Associative
*/
cljs.core.associative_QMARK_ = (function associative_QMARK_(x){
var G__7829 = x;
if(G__7829){
var bit__5783__auto__ = (G__7829.cljs$lang$protocol_mask$partition0$ & (512));
if((bit__5783__auto__) || (G__7829.cljs$core$IAssociative$)){
return true;
} else {
if((!G__7829.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,G__7829);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,G__7829);
}
});
/**
* Returns true if coll satisfies ISequential
*/
cljs.core.sequential_QMARK_ = (function sequential_QMARK_(x){
var G__7831 = x;
if(G__7831){
var bit__5783__auto__ = (G__7831.cljs$lang$protocol_mask$partition0$ & (16777216));
if((bit__5783__auto__) || (G__7831.cljs$core$ISequential$)){
return true;
} else {
if((!G__7831.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,G__7831);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,G__7831);
}
});
/**
* Returns true if coll satisfies ISorted
*/
cljs.core.sorted_QMARK_ = (function sorted_QMARK_(x){
var G__7833 = x;
if(G__7833){
var bit__5783__auto__ = (G__7833.cljs$lang$protocol_mask$partition0$ & (268435456));
if((bit__5783__auto__) || (G__7833.cljs$core$ISorted$)){
return true;
} else {
if((!G__7833.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,G__7833);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,G__7833);
}
});
/**
* Returns true if coll satisfies IReduce
*/
cljs.core.reduceable_QMARK_ = (function reduceable_QMARK_(x){
var G__7835 = x;
if(G__7835){
var bit__5783__auto__ = (G__7835.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__5783__auto__) || (G__7835.cljs$core$IReduce$)){
return true;
} else {
if((!G__7835.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,G__7835);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,G__7835);
}
});
/**
* Return true if x satisfies IMap
*/
cljs.core.map_QMARK_ = (function map_QMARK_(x){
if((x == null)){
return false;
} else {
var G__7837 = x;
if(G__7837){
var bit__5783__auto__ = (G__7837.cljs$lang$protocol_mask$partition0$ & (1024));
if((bit__5783__auto__) || (G__7837.cljs$core$IMap$)){
return true;
} else {
if((!G__7837.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,G__7837);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,G__7837);
}
}
});
/**
* Return true if x satisfies IVector
*/
cljs.core.vector_QMARK_ = (function vector_QMARK_(x){
var G__7839 = x;
if(G__7839){
var bit__5783__auto__ = (G__7839.cljs$lang$protocol_mask$partition0$ & (16384));
if((bit__5783__auto__) || (G__7839.cljs$core$IVector$)){
return true;
} else {
if((!G__7839.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,G__7839);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,G__7839);
}
});

cljs.core.chunked_seq_QMARK_ = (function chunked_seq_QMARK_(x){
var G__7841 = x;
if(G__7841){
var bit__5776__auto__ = (G__7841.cljs$lang$protocol_mask$partition1$ & (512));
if((bit__5776__auto__) || (G__7841.cljs$core$IChunkedSeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
* @param {...*} var_args
*/
cljs.core.js_obj = (function() {
var js_obj = null;
var js_obj__0 = (function (){
var obj7847 = {};
return obj7847;
});
var js_obj__1 = (function() { 
var G__7850__delegate = function (keyvals){
var G__7848 = goog.object.create;
var G__7849 = keyvals;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(G__7848,G__7849) : cljs.core.apply.call(null,G__7848,G__7849));
};
var G__7850 = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__7851__i = 0, G__7851__a = new Array(arguments.length -  0);
while (G__7851__i < G__7851__a.length) {G__7851__a[G__7851__i] = arguments[G__7851__i + 0]; ++G__7851__i;}
  keyvals = new cljs.core.IndexedSeq(G__7851__a,0);
} 
return G__7850__delegate.call(this,keyvals);};
G__7850.cljs$lang$maxFixedArity = 0;
G__7850.cljs$lang$applyTo = (function (arglist__7852){
var keyvals = cljs.core.seq(arglist__7852);
return G__7850__delegate(keyvals);
});
G__7850.cljs$core$IFn$_invoke$arity$variadic = G__7850__delegate;
return G__7850;
})()
;
js_obj = function(var_args){
var keyvals = var_args;
switch(arguments.length){
case 0:
return js_obj__0.call(this);
default:
var G__7853 = null;
if (arguments.length > 0) {
var G__7854__i = 0, G__7854__a = new Array(arguments.length -  0);
while (G__7854__i < G__7854__a.length) {G__7854__a[G__7854__i] = arguments[G__7854__i + 0]; ++G__7854__i;}
G__7853 = new cljs.core.IndexedSeq(G__7854__a,0);
}
return js_obj__1.cljs$core$IFn$_invoke$arity$variadic(G__7853);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
js_obj.cljs$lang$maxFixedArity = 0;
js_obj.cljs$lang$applyTo = js_obj__1.cljs$lang$applyTo;
js_obj.cljs$core$IFn$_invoke$arity$0 = js_obj__0;
js_obj.cljs$core$IFn$_invoke$arity$variadic = js_obj__1.cljs$core$IFn$_invoke$arity$variadic;
return js_obj;
})()
;
cljs.core.js_keys = (function js_keys(obj){
var keys = [];
var G__7857_7859 = obj;
var G__7858_7860 = ((function (G__7857_7859,keys){
return (function (val,key,obj__$1){
return keys.push(key);
});})(G__7857_7859,keys))
;
goog.object.forEach(G__7857_7859,G__7858_7860);

return keys;
});
cljs.core.js_delete = (function js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function array_copy(from,i,to,j,len){
var i__$1 = i;
var j__$1 = j;
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__7861 = (i__$1 + (1));
var G__7862 = (j__$1 + (1));
var G__7863 = (len__$1 - (1));
i__$1 = G__7861;
j__$1 = G__7862;
len__$1 = G__7863;
continue;
}
break;
}
});
cljs.core.array_copy_downward = (function array_copy_downward(from,i,to,j,len){
var i__$1 = (i + (len - (1)));
var j__$1 = (j + (len - (1)));
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__7864 = (i__$1 - (1));
var G__7865 = (j__$1 - (1));
var G__7866 = (len__$1 - (1));
i__$1 = G__7864;
j__$1 = G__7865;
len__$1 = G__7866;
continue;
}
break;
}
});
cljs.core.lookup_sentinel = (function (){var obj7868 = {};
return obj7868;
})();
/**
* Returns true if x is the value false, false otherwise.
*/
cljs.core.false_QMARK_ = (function false_QMARK_(x){
return x === false;
});
/**
* Returns true if x is the value true, false otherwise.
*/
cljs.core.true_QMARK_ = (function true_QMARK_(x){
return x === true;
});
cljs.core.undefined_QMARK_ = (function undefined_QMARK_(x){
return (void 0 === x);
});
/**
* Return true if s satisfies ISeq
*/
cljs.core.seq_QMARK_ = (function seq_QMARK_(s){
if((s == null)){
return false;
} else {
var G__7870 = s;
if(G__7870){
var bit__5783__auto__ = (G__7870.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__5783__auto__) || (G__7870.cljs$core$ISeq$)){
return true;
} else {
if((!G__7870.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__7870);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__7870);
}
}
});
/**
* Return true if s satisfies ISeqable
*/
cljs.core.seqable_QMARK_ = (function seqable_QMARK_(s){
var G__7872 = s;
if(G__7872){
var bit__5783__auto__ = (G__7872.cljs$lang$protocol_mask$partition0$ & (8388608));
if((bit__5783__auto__) || (G__7872.cljs$core$ISeqable$)){
return true;
} else {
if((!G__7872.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,G__7872);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,G__7872);
}
});
cljs.core.boolean$ = (function boolean$(x){
if(cljs.core.truth_(x)){
return true;
} else {
return false;
}
});
cljs.core.ifn_QMARK_ = (function ifn_QMARK_(f){
var or__5102__auto__ = cljs.core.fn_QMARK_(f);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var G__7876 = f;
if(G__7876){
var bit__5783__auto__ = (G__7876.cljs$lang$protocol_mask$partition0$ & (1));
if((bit__5783__auto__) || (G__7876.cljs$core$IFn$)){
return true;
} else {
if((!G__7876.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,G__7876);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,G__7876);
}
}
});
/**
* Returns true if n is an integer.
*/
cljs.core.integer_QMARK_ = (function integer_QMARK_(n){
return (typeof n === 'number') && (cljs.core.not((function (){var G__7889 = n;
return isNaN(G__7889);
})())) && (!((n === Infinity))) && (((function (){var G__7890 = n;
return parseFloat(G__7890);
})() === (function (){var G__7891 = n;
var G__7892 = (10);
return parseInt(G__7891,G__7892);
})()));
});
/**
* Returns true if key is present in the given collection, otherwise
* returns false.  Note that for numerically indexed collections like
* vectors and arrays, this tests if the numeric key is within the
* range of indexes. 'contains?' operates constant or logarithmic time;
* it will not perform a linear search for a value.  See also 'some'.
*/
cljs.core.contains_QMARK_ = (function contains_QMARK_(coll,v){
if((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return false;
} else {
return true;
}
});
/**
* Returns the map entry for key, or nil if key not present.
*/
cljs.core.find = (function find(coll,k){
if((!((coll == null))) && (cljs.core.associative_QMARK_(coll)) && (cljs.core.contains_QMARK_(coll,k))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k)], null);
} else {
return null;
}
});
/**
* Returns true if no two of the arguments are =
* @param {...*} var_args
*/
cljs.core.distinct_QMARK_ = (function() {
var distinct_QMARK_ = null;
var distinct_QMARK___1 = (function (x){
return true;
});
var distinct_QMARK___2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});
var distinct_QMARK___3 = (function() { 
var G__7893__delegate = function (x,y,more){
if(!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y))){
var s = cljs.core.PersistentHashSet.fromArray([x,y], true);
var xs = more;
while(true){
var x__$1 = cljs.core.first(xs);
var etc = cljs.core.next(xs);
if(cljs.core.truth_(xs)){
if(cljs.core.contains_QMARK_(s,x__$1)){
return false;
} else {
var G__7894 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);
var G__7895 = etc;
s = G__7894;
xs = G__7895;
continue;
}
} else {
return true;
}
break;
}
} else {
return false;
}
};
var G__7893 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__7896__i = 0, G__7896__a = new Array(arguments.length -  2);
while (G__7896__i < G__7896__a.length) {G__7896__a[G__7896__i] = arguments[G__7896__i + 2]; ++G__7896__i;}
  more = new cljs.core.IndexedSeq(G__7896__a,0);
} 
return G__7893__delegate.call(this,x,y,more);};
G__7893.cljs$lang$maxFixedArity = 2;
G__7893.cljs$lang$applyTo = (function (arglist__7897){
var x = cljs.core.first(arglist__7897);
arglist__7897 = cljs.core.next(arglist__7897);
var y = cljs.core.first(arglist__7897);
var more = cljs.core.rest(arglist__7897);
return G__7893__delegate(x,y,more);
});
G__7893.cljs$core$IFn$_invoke$arity$variadic = G__7893__delegate;
return G__7893;
})()
;
distinct_QMARK_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return distinct_QMARK___1.call(this,x);
case 2:
return distinct_QMARK___2.call(this,x,y);
default:
var G__7898 = null;
if (arguments.length > 2) {
var G__7899__i = 0, G__7899__a = new Array(arguments.length -  2);
while (G__7899__i < G__7899__a.length) {G__7899__a[G__7899__i] = arguments[G__7899__i + 2]; ++G__7899__i;}
G__7898 = new cljs.core.IndexedSeq(G__7899__a,0);
}
return distinct_QMARK___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__7898);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
distinct_QMARK_.cljs$lang$maxFixedArity = 2;
distinct_QMARK_.cljs$lang$applyTo = distinct_QMARK___3.cljs$lang$applyTo;
distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = distinct_QMARK___1;
distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = distinct_QMARK___2;
distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = distinct_QMARK___3.cljs$core$IFn$_invoke$arity$variadic;
return distinct_QMARK_;
})()
;
/**
* Comparator. Returns a negative number, zero, or a positive number
* when x is logically 'less than', 'equal to', or 'greater than'
* y. Uses IComparable if available and google.array.defaultCompare for objects
* of the same type and special-cases nil to be less than any other object.
*/
cljs.core.compare = (function compare(x,y){
if((x === y)){
return (0);
} else {
if((x == null)){
return (-1);
} else {
if((y == null)){
return (1);
} else {
if((cljs.core.type(x) === cljs.core.type(y))){
if((function (){var G__7903 = x;
if(G__7903){
var bit__5776__auto__ = (G__7903.cljs$lang$protocol_mask$partition1$ & (2048));
if((bit__5776__auto__) || (G__7903.cljs$core$IComparable$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$IComparable$_compare$arity$2(null,y);
} else {
var G__7904 = x;
var G__7905 = y;
return goog.array.defaultCompare(G__7904,G__7905);
}
} else {
throw (new Error("compare on non-nil objects of different types"));

}
}
}
}
});
/**
* Compare indexed collection.
*/
cljs.core.compare_indexed = (function() {
var compare_indexed = null;
var compare_indexed__2 = (function (xs,ys){
var xl = cljs.core.count(xs);
var yl = cljs.core.count(ys);
if((xl < yl)){
return (-1);
} else {
if((xl > yl)){
return (1);
} else {
return compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));

}
}
});
var compare_indexed__4 = (function (xs,ys,len,n){
while(true){
var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));
if(((d === (0))) && (((n + (1)) < len))){
var G__7910 = xs;
var G__7911 = ys;
var G__7912 = len;
var G__7913 = (n + (1));
xs = G__7910;
ys = G__7911;
len = G__7912;
n = G__7913;
continue;
} else {
return d;
}
break;
}
});
compare_indexed = function(xs,ys,len,n){
switch(arguments.length){
case 2:
return compare_indexed__2.call(this,xs,ys);
case 4:
return compare_indexed__4.call(this,xs,ys,len,n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
compare_indexed.cljs$core$IFn$_invoke$arity$2 = compare_indexed__2;
compare_indexed.cljs$core$IFn$_invoke$arity$4 = compare_indexed__4;
return compare_indexed;
})()
;
/**
* Given a fn that might be boolean valued or a comparator,
* return a fn that is a comparator.
*/
cljs.core.fn__GT_comparator = (function fn__GT_comparator(f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){
return cljs.core.compare;
} else {
return (function (x,y){
var r = (function (){var G__7918 = x;
var G__7919 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7918,G__7919) : f.call(null,G__7918,G__7919));
})();
if(typeof r === 'number'){
return r;
} else {
if(cljs.core.truth_(r)){
return (-1);
} else {
if(cljs.core.truth_((function (){var G__7920 = y;
var G__7921 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7920,G__7921) : f.call(null,G__7920,G__7921));
})())){
return (1);
} else {
return (0);
}
}
}
});
}
});
/**
* Returns a sorted sequence of the items in coll. Comp can be
* boolean-valued comparison function, or a -/0/+ valued comparator.
* Comp defaults to compare.
*/
cljs.core.sort = (function() {
var sort = null;
var sort__1 = (function (coll){
return sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);
});
var sort__2 = (function (comp,coll){
if(cljs.core.seq(coll)){
var a = (function (){var G__7927 = coll;
return (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__7927) : cljs.core.to_array.call(null,G__7927));
})();
var G__7928_7930 = a;
var G__7929_7931 = cljs.core.fn__GT_comparator(comp);
goog.array.stableSort(G__7928_7930,G__7929_7931);

return cljs.core.seq(a);
} else {
return cljs.core.List.EMPTY;
}
});
sort = function(comp,coll){
switch(arguments.length){
case 1:
return sort__1.call(this,comp);
case 2:
return sort__2.call(this,comp,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sort.cljs$core$IFn$_invoke$arity$1 = sort__1;
sort.cljs$core$IFn$_invoke$arity$2 = sort__2;
return sort;
})()
;
/**
* Returns a sorted sequence of the items in coll, where the sort
* order is determined by comparing (keyfn item).  Comp can be
* boolean-valued comparison funcion, or a -/0/+ valued comparator.
* Comp defaults to compare.
*/
cljs.core.sort_by = (function() {
var sort_by = null;
var sort_by__2 = (function (keyfn,coll){
return sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);
});
var sort_by__3 = (function (keyfn,comp,coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (x,y){
return cljs.core.fn__GT_comparator(comp).call(null,(function (){var G__7937 = x;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__7937) : keyfn.call(null,G__7937));
})(),(function (){var G__7938 = y;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__7938) : keyfn.call(null,G__7938));
})());
}),coll);
});
sort_by = function(keyfn,comp,coll){
switch(arguments.length){
case 2:
return sort_by__2.call(this,keyfn,comp);
case 3:
return sort_by__3.call(this,keyfn,comp,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sort_by.cljs$core$IFn$_invoke$arity$2 = sort_by__2;
sort_by.cljs$core$IFn$_invoke$arity$3 = sort_by__3;
return sort_by;
})()
;
cljs.core.seq_reduce = (function() {
var seq_reduce = null;
var seq_reduce__2 = (function (f,coll){
var temp__4124__auto__ = cljs.core.seq(coll);
if(temp__4124__auto__){
var s = temp__4124__auto__;
var G__7944 = f;
var G__7945 = cljs.core.first(s);
var G__7946 = cljs.core.next(s);
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__7944,G__7945,G__7946) : cljs.core.reduce.call(null,G__7944,G__7945,G__7946));
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
});
var seq_reduce__3 = (function (f,val,coll){
var val__$1 = val;
var coll__$1 = cljs.core.seq(coll);
while(true){
if(coll__$1){
var nval = (function (){var G__7947 = val__$1;
var G__7948 = cljs.core.first(coll__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7947,G__7948) : f.call(null,G__7947,G__7948));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__7949 = nval;
var G__7950 = cljs.core.next(coll__$1);
val__$1 = G__7949;
coll__$1 = G__7950;
continue;
}
} else {
return val__$1;
}
break;
}
});
seq_reduce = function(f,val,coll){
switch(arguments.length){
case 2:
return seq_reduce__2.call(this,f,val);
case 3:
return seq_reduce__3.call(this,f,val,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
seq_reduce.cljs$core$IFn$_invoke$arity$2 = seq_reduce__2;
seq_reduce.cljs$core$IFn$_invoke$arity$3 = seq_reduce__3;
return seq_reduce;
})()
;
/**
* Return a random permutation of coll
*/
cljs.core.shuffle = (function shuffle(coll){
var a = (function (){var G__7954 = coll;
return (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__7954) : cljs.core.to_array.call(null,G__7954));
})();
var G__7955_7957 = a;
goog.array.shuffle(G__7955_7957);

var G__7956 = a;
return (cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(G__7956) : cljs.core.vec.call(null,G__7956));
});
/**
* f should be a function of 2 arguments. If val is not supplied,
* returns the result of applying f to the first 2 items in coll, then
* applying f to that result and the 3rd item, etc. If coll contains no
* items, f must accept no arguments as well, and reduce returns the
* result of calling f with no arguments.  If coll has only 1 item, it
* is returned and f is not called.  If val is supplied, returns the
* result of applying f to val and the first item in coll, then
* applying f to that result and the 2nd item, etc. If coll contains no
* items, returns val and f is not called.
*/
cljs.core.reduce = (function() {
var reduce = null;
var reduce__2 = (function (f,coll){
if((function (){var G__7960 = coll;
if(G__7960){
var bit__5776__auto__ = (G__7960.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__5776__auto__) || (G__7960.cljs$core$IReduce$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$2(null,f);
} else {
if(Array.isArray(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);

}
}
}
}
});
var reduce__3 = (function (f,val,coll){
if((function (){var G__7961 = coll;
if(G__7961){
var bit__5776__auto__ = (G__7961.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__5776__auto__) || (G__7961.cljs$core$IReduce$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$3(null,f,val);
} else {
if(Array.isArray(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);

}
}
}
}
});
reduce = function(f,val,coll){
switch(arguments.length){
case 2:
return reduce__2.call(this,f,val);
case 3:
return reduce__3.call(this,f,val,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
reduce.cljs$core$IFn$_invoke$arity$2 = reduce__2;
reduce.cljs$core$IFn$_invoke$arity$3 = reduce__3;
return reduce;
})()
;
/**
* Reduces an associative collection. f should be a function of 3
* arguments. Returns the result of applying f to init, the first key
* and the first value in coll, then applying f to that result and the
* 2nd key and value, etc. If coll contains no entries, returns init
* and f is not called. Note that reduce-kv is supported on vectors,
* where the keys will be the ordinals.
*/
cljs.core.reduce_kv = (function reduce_kv(f,init,coll){
if(!((coll == null))){
return cljs.core._kv_reduce(coll,f,init);
} else {
return init;
}
});
cljs.core.identity = (function identity(x){
return x;
});
cljs.core.completing = (function() {
var completing = null;
var completing__1 = (function (f){
return completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);
});
var completing__2 = (function (f,cf){
return (function() {
var G__7970 = null;
var G__7970__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
var G__7970__1 = (function (x){
var G__7967 = x;
return (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(G__7967) : cf.call(null,G__7967));
});
var G__7970__2 = (function (x,y){
var G__7968 = x;
var G__7969 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7968,G__7969) : f.call(null,G__7968,G__7969));
});
G__7970 = function(x,y){
switch(arguments.length){
case 0:
return G__7970__0.call(this);
case 1:
return G__7970__1.call(this,x);
case 2:
return G__7970__2.call(this,x,y);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7970.cljs$core$IFn$_invoke$arity$0 = G__7970__0;
G__7970.cljs$core$IFn$_invoke$arity$1 = G__7970__1;
G__7970.cljs$core$IFn$_invoke$arity$2 = G__7970__2;
return G__7970;
})()
});
completing = function(f,cf){
switch(arguments.length){
case 1:
return completing__1.call(this,f);
case 2:
return completing__2.call(this,f,cf);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
completing.cljs$core$IFn$_invoke$arity$1 = completing__1;
completing.cljs$core$IFn$_invoke$arity$2 = completing__2;
return completing;
})()
;
/**
* reduce with a transformation of f (xf). If init is not
* supplied, (f) will be called to produce it. f should be a reducing
* step function that accepts both 1 and 2 arguments, if it accepts
* only 2 you can add the arity-1 with 'completing'. Returns the result
* of applying (the transformed) xf to init and the first item in coll,
* then applying xf to that result and the 2nd item, etc. If coll
* contains no items, returns init and f is not called. Note that
* certain transforms may inject or skip items.
*/
cljs.core.transduce = (function() {
var transduce = null;
var transduce__3 = (function (xform,f,coll){
return transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),coll);
});
var transduce__4 = (function (xform,f,init,coll){
var f__$1 = (function (){var G__7977 = f;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__7977) : xform.call(null,G__7977));
})();
var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);
var G__7978 = ret;
return (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(G__7978) : f__$1.call(null,G__7978));
});
transduce = function(xform,f,init,coll){
switch(arguments.length){
case 3:
return transduce__3.call(this,xform,f,init);
case 4:
return transduce__4.call(this,xform,f,init,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
transduce.cljs$core$IFn$_invoke$arity$3 = transduce__3;
transduce.cljs$core$IFn$_invoke$arity$4 = transduce__4;
return transduce;
})()
;
/**
* Returns the sum of nums. (+) returns 0.
* @param {...*} var_args
*/
cljs.core._PLUS_ = (function() {
var _PLUS_ = null;
var _PLUS___0 = (function (){
return (0);
});
var _PLUS___1 = (function (x){
return x;
});
var _PLUS___2 = (function (x,y){
return (x + y);
});
var _PLUS___3 = (function() { 
var G__7979__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(_PLUS_,(x + y),more);
};
var G__7979 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__7980__i = 0, G__7980__a = new Array(arguments.length -  2);
while (G__7980__i < G__7980__a.length) {G__7980__a[G__7980__i] = arguments[G__7980__i + 2]; ++G__7980__i;}
  more = new cljs.core.IndexedSeq(G__7980__a,0);
} 
return G__7979__delegate.call(this,x,y,more);};
G__7979.cljs$lang$maxFixedArity = 2;
G__7979.cljs$lang$applyTo = (function (arglist__7981){
var x = cljs.core.first(arglist__7981);
arglist__7981 = cljs.core.next(arglist__7981);
var y = cljs.core.first(arglist__7981);
var more = cljs.core.rest(arglist__7981);
return G__7979__delegate(x,y,more);
});
G__7979.cljs$core$IFn$_invoke$arity$variadic = G__7979__delegate;
return G__7979;
})()
;
_PLUS_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return _PLUS___0.call(this);
case 1:
return _PLUS___1.call(this,x);
case 2:
return _PLUS___2.call(this,x,y);
default:
var G__7982 = null;
if (arguments.length > 2) {
var G__7983__i = 0, G__7983__a = new Array(arguments.length -  2);
while (G__7983__i < G__7983__a.length) {G__7983__a[G__7983__i] = arguments[G__7983__i + 2]; ++G__7983__i;}
G__7982 = new cljs.core.IndexedSeq(G__7983__a,0);
}
return _PLUS___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__7982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_PLUS_.cljs$lang$maxFixedArity = 2;
_PLUS_.cljs$lang$applyTo = _PLUS___3.cljs$lang$applyTo;
_PLUS_.cljs$core$IFn$_invoke$arity$0 = _PLUS___0;
_PLUS_.cljs$core$IFn$_invoke$arity$1 = _PLUS___1;
_PLUS_.cljs$core$IFn$_invoke$arity$2 = _PLUS___2;
_PLUS_.cljs$core$IFn$_invoke$arity$variadic = _PLUS___3.cljs$core$IFn$_invoke$arity$variadic;
return _PLUS_;
})()
;
/**
* If no ys are supplied, returns the negation of x, else subtracts
* the ys from x and returns the result.
* @param {...*} var_args
*/
cljs.core._ = (function() {
var _ = null;
var ___1 = (function (x){
return (- x);
});
var ___2 = (function (x,y){
return (x - y);
});
var ___3 = (function() { 
var G__7984__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(_,(x - y),more);
};
var G__7984 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__7985__i = 0, G__7985__a = new Array(arguments.length -  2);
while (G__7985__i < G__7985__a.length) {G__7985__a[G__7985__i] = arguments[G__7985__i + 2]; ++G__7985__i;}
  more = new cljs.core.IndexedSeq(G__7985__a,0);
} 
return G__7984__delegate.call(this,x,y,more);};
G__7984.cljs$lang$maxFixedArity = 2;
G__7984.cljs$lang$applyTo = (function (arglist__7986){
var x = cljs.core.first(arglist__7986);
arglist__7986 = cljs.core.next(arglist__7986);
var y = cljs.core.first(arglist__7986);
var more = cljs.core.rest(arglist__7986);
return G__7984__delegate(x,y,more);
});
G__7984.cljs$core$IFn$_invoke$arity$variadic = G__7984__delegate;
return G__7984;
})()
;
_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return ___1.call(this,x);
case 2:
return ___2.call(this,x,y);
default:
var G__7987 = null;
if (arguments.length > 2) {
var G__7988__i = 0, G__7988__a = new Array(arguments.length -  2);
while (G__7988__i < G__7988__a.length) {G__7988__a[G__7988__i] = arguments[G__7988__i + 2]; ++G__7988__i;}
G__7987 = new cljs.core.IndexedSeq(G__7988__a,0);
}
return ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__7987);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_.cljs$lang$maxFixedArity = 2;
_.cljs$lang$applyTo = ___3.cljs$lang$applyTo;
_.cljs$core$IFn$_invoke$arity$1 = ___1;
_.cljs$core$IFn$_invoke$arity$2 = ___2;
_.cljs$core$IFn$_invoke$arity$variadic = ___3.cljs$core$IFn$_invoke$arity$variadic;
return _;
})()
;
/**
* Returns the product of nums. (*) returns 1.
* @param {...*} var_args
*/
cljs.core._STAR_ = (function() {
var _STAR_ = null;
var _STAR___0 = (function (){
return (1);
});
var _STAR___1 = (function (x){
return x;
});
var _STAR___2 = (function (x,y){
return (x * y);
});
var _STAR___3 = (function() { 
var G__7989__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(_STAR_,(x * y),more);
};
var G__7989 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__7990__i = 0, G__7990__a = new Array(arguments.length -  2);
while (G__7990__i < G__7990__a.length) {G__7990__a[G__7990__i] = arguments[G__7990__i + 2]; ++G__7990__i;}
  more = new cljs.core.IndexedSeq(G__7990__a,0);
} 
return G__7989__delegate.call(this,x,y,more);};
G__7989.cljs$lang$maxFixedArity = 2;
G__7989.cljs$lang$applyTo = (function (arglist__7991){
var x = cljs.core.first(arglist__7991);
arglist__7991 = cljs.core.next(arglist__7991);
var y = cljs.core.first(arglist__7991);
var more = cljs.core.rest(arglist__7991);
return G__7989__delegate(x,y,more);
});
G__7989.cljs$core$IFn$_invoke$arity$variadic = G__7989__delegate;
return G__7989;
})()
;
_STAR_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return _STAR___0.call(this);
case 1:
return _STAR___1.call(this,x);
case 2:
return _STAR___2.call(this,x,y);
default:
var G__7992 = null;
if (arguments.length > 2) {
var G__7993__i = 0, G__7993__a = new Array(arguments.length -  2);
while (G__7993__i < G__7993__a.length) {G__7993__a[G__7993__i] = arguments[G__7993__i + 2]; ++G__7993__i;}
G__7992 = new cljs.core.IndexedSeq(G__7993__a,0);
}
return _STAR___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__7992);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_STAR_.cljs$lang$maxFixedArity = 2;
_STAR_.cljs$lang$applyTo = _STAR___3.cljs$lang$applyTo;
_STAR_.cljs$core$IFn$_invoke$arity$0 = _STAR___0;
_STAR_.cljs$core$IFn$_invoke$arity$1 = _STAR___1;
_STAR_.cljs$core$IFn$_invoke$arity$2 = _STAR___2;
_STAR_.cljs$core$IFn$_invoke$arity$variadic = _STAR___3.cljs$core$IFn$_invoke$arity$variadic;
return _STAR_;
})()
;
/**
* If no denominators are supplied, returns 1/numerator,
* else returns numerator divided by all of the denominators.
* @param {...*} var_args
*/
cljs.core._SLASH_ = (function() {
var _SLASH_ = null;
var _SLASH___1 = (function (x){
return _SLASH_.cljs$core$IFn$_invoke$arity$2((1),x);
});
var _SLASH___2 = (function (x,y){
return (x / y);
});
var _SLASH___3 = (function() { 
var G__7998__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(_SLASH_,_SLASH_.cljs$core$IFn$_invoke$arity$2(x,y),more);
};
var G__7998 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__7999__i = 0, G__7999__a = new Array(arguments.length -  2);
while (G__7999__i < G__7999__a.length) {G__7999__a[G__7999__i] = arguments[G__7999__i + 2]; ++G__7999__i;}
  more = new cljs.core.IndexedSeq(G__7999__a,0);
} 
return G__7998__delegate.call(this,x,y,more);};
G__7998.cljs$lang$maxFixedArity = 2;
G__7998.cljs$lang$applyTo = (function (arglist__8000){
var x = cljs.core.first(arglist__8000);
arglist__8000 = cljs.core.next(arglist__8000);
var y = cljs.core.first(arglist__8000);
var more = cljs.core.rest(arglist__8000);
return G__7998__delegate(x,y,more);
});
G__7998.cljs$core$IFn$_invoke$arity$variadic = G__7998__delegate;
return G__7998;
})()
;
_SLASH_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _SLASH___1.call(this,x);
case 2:
return _SLASH___2.call(this,x,y);
default:
var G__8001 = null;
if (arguments.length > 2) {
var G__8002__i = 0, G__8002__a = new Array(arguments.length -  2);
while (G__8002__i < G__8002__a.length) {G__8002__a[G__8002__i] = arguments[G__8002__i + 2]; ++G__8002__i;}
G__8001 = new cljs.core.IndexedSeq(G__8002__a,0);
}
return _SLASH___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8001);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_SLASH_.cljs$lang$maxFixedArity = 2;
_SLASH_.cljs$lang$applyTo = _SLASH___3.cljs$lang$applyTo;
_SLASH_.cljs$core$IFn$_invoke$arity$1 = _SLASH___1;
_SLASH_.cljs$core$IFn$_invoke$arity$2 = _SLASH___2;
_SLASH_.cljs$core$IFn$_invoke$arity$variadic = _SLASH___3.cljs$core$IFn$_invoke$arity$variadic;
return _SLASH_;
})()
;
/**
* Returns non-nil if nums are in monotonically increasing order,
* otherwise false.
* @param {...*} var_args
*/
cljs.core._LT_ = (function() {
var _LT_ = null;
var _LT___1 = (function (x){
return true;
});
var _LT___2 = (function (x,y){
return (x < y);
});
var _LT___3 = (function() { 
var G__8003__delegate = function (x,y,more){
while(true){
if((x < y)){
if(cljs.core.next(more)){
var G__8004 = y;
var G__8005 = cljs.core.first(more);
var G__8006 = cljs.core.next(more);
x = G__8004;
y = G__8005;
more = G__8006;
continue;
} else {
return (y < cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__8003 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8007__i = 0, G__8007__a = new Array(arguments.length -  2);
while (G__8007__i < G__8007__a.length) {G__8007__a[G__8007__i] = arguments[G__8007__i + 2]; ++G__8007__i;}
  more = new cljs.core.IndexedSeq(G__8007__a,0);
} 
return G__8003__delegate.call(this,x,y,more);};
G__8003.cljs$lang$maxFixedArity = 2;
G__8003.cljs$lang$applyTo = (function (arglist__8008){
var x = cljs.core.first(arglist__8008);
arglist__8008 = cljs.core.next(arglist__8008);
var y = cljs.core.first(arglist__8008);
var more = cljs.core.rest(arglist__8008);
return G__8003__delegate(x,y,more);
});
G__8003.cljs$core$IFn$_invoke$arity$variadic = G__8003__delegate;
return G__8003;
})()
;
_LT_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _LT___1.call(this,x);
case 2:
return _LT___2.call(this,x,y);
default:
var G__8009 = null;
if (arguments.length > 2) {
var G__8010__i = 0, G__8010__a = new Array(arguments.length -  2);
while (G__8010__i < G__8010__a.length) {G__8010__a[G__8010__i] = arguments[G__8010__i + 2]; ++G__8010__i;}
G__8009 = new cljs.core.IndexedSeq(G__8010__a,0);
}
return _LT___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8009);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_LT_.cljs$lang$maxFixedArity = 2;
_LT_.cljs$lang$applyTo = _LT___3.cljs$lang$applyTo;
_LT_.cljs$core$IFn$_invoke$arity$1 = _LT___1;
_LT_.cljs$core$IFn$_invoke$arity$2 = _LT___2;
_LT_.cljs$core$IFn$_invoke$arity$variadic = _LT___3.cljs$core$IFn$_invoke$arity$variadic;
return _LT_;
})()
;
/**
* Returns non-nil if nums are in monotonically non-decreasing order,
* otherwise false.
* @param {...*} var_args
*/
cljs.core._LT__EQ_ = (function() {
var _LT__EQ_ = null;
var _LT__EQ___1 = (function (x){
return true;
});
var _LT__EQ___2 = (function (x,y){
return (x <= y);
});
var _LT__EQ___3 = (function() { 
var G__8011__delegate = function (x,y,more){
while(true){
if((x <= y)){
if(cljs.core.next(more)){
var G__8012 = y;
var G__8013 = cljs.core.first(more);
var G__8014 = cljs.core.next(more);
x = G__8012;
y = G__8013;
more = G__8014;
continue;
} else {
return (y <= cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__8011 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8015__i = 0, G__8015__a = new Array(arguments.length -  2);
while (G__8015__i < G__8015__a.length) {G__8015__a[G__8015__i] = arguments[G__8015__i + 2]; ++G__8015__i;}
  more = new cljs.core.IndexedSeq(G__8015__a,0);
} 
return G__8011__delegate.call(this,x,y,more);};
G__8011.cljs$lang$maxFixedArity = 2;
G__8011.cljs$lang$applyTo = (function (arglist__8016){
var x = cljs.core.first(arglist__8016);
arglist__8016 = cljs.core.next(arglist__8016);
var y = cljs.core.first(arglist__8016);
var more = cljs.core.rest(arglist__8016);
return G__8011__delegate(x,y,more);
});
G__8011.cljs$core$IFn$_invoke$arity$variadic = G__8011__delegate;
return G__8011;
})()
;
_LT__EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _LT__EQ___1.call(this,x);
case 2:
return _LT__EQ___2.call(this,x,y);
default:
var G__8017 = null;
if (arguments.length > 2) {
var G__8018__i = 0, G__8018__a = new Array(arguments.length -  2);
while (G__8018__i < G__8018__a.length) {G__8018__a[G__8018__i] = arguments[G__8018__i + 2]; ++G__8018__i;}
G__8017 = new cljs.core.IndexedSeq(G__8018__a,0);
}
return _LT__EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8017);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_LT__EQ_.cljs$lang$maxFixedArity = 2;
_LT__EQ_.cljs$lang$applyTo = _LT__EQ___3.cljs$lang$applyTo;
_LT__EQ_.cljs$core$IFn$_invoke$arity$1 = _LT__EQ___1;
_LT__EQ_.cljs$core$IFn$_invoke$arity$2 = _LT__EQ___2;
_LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = _LT__EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return _LT__EQ_;
})()
;
/**
* Returns non-nil if nums are in monotonically decreasing order,
* otherwise false.
* @param {...*} var_args
*/
cljs.core._GT_ = (function() {
var _GT_ = null;
var _GT___1 = (function (x){
return true;
});
var _GT___2 = (function (x,y){
return (x > y);
});
var _GT___3 = (function() { 
var G__8019__delegate = function (x,y,more){
while(true){
if((x > y)){
if(cljs.core.next(more)){
var G__8020 = y;
var G__8021 = cljs.core.first(more);
var G__8022 = cljs.core.next(more);
x = G__8020;
y = G__8021;
more = G__8022;
continue;
} else {
return (y > cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__8019 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8023__i = 0, G__8023__a = new Array(arguments.length -  2);
while (G__8023__i < G__8023__a.length) {G__8023__a[G__8023__i] = arguments[G__8023__i + 2]; ++G__8023__i;}
  more = new cljs.core.IndexedSeq(G__8023__a,0);
} 
return G__8019__delegate.call(this,x,y,more);};
G__8019.cljs$lang$maxFixedArity = 2;
G__8019.cljs$lang$applyTo = (function (arglist__8024){
var x = cljs.core.first(arglist__8024);
arglist__8024 = cljs.core.next(arglist__8024);
var y = cljs.core.first(arglist__8024);
var more = cljs.core.rest(arglist__8024);
return G__8019__delegate(x,y,more);
});
G__8019.cljs$core$IFn$_invoke$arity$variadic = G__8019__delegate;
return G__8019;
})()
;
_GT_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _GT___1.call(this,x);
case 2:
return _GT___2.call(this,x,y);
default:
var G__8025 = null;
if (arguments.length > 2) {
var G__8026__i = 0, G__8026__a = new Array(arguments.length -  2);
while (G__8026__i < G__8026__a.length) {G__8026__a[G__8026__i] = arguments[G__8026__i + 2]; ++G__8026__i;}
G__8025 = new cljs.core.IndexedSeq(G__8026__a,0);
}
return _GT___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_GT_.cljs$lang$maxFixedArity = 2;
_GT_.cljs$lang$applyTo = _GT___3.cljs$lang$applyTo;
_GT_.cljs$core$IFn$_invoke$arity$1 = _GT___1;
_GT_.cljs$core$IFn$_invoke$arity$2 = _GT___2;
_GT_.cljs$core$IFn$_invoke$arity$variadic = _GT___3.cljs$core$IFn$_invoke$arity$variadic;
return _GT_;
})()
;
/**
* Returns non-nil if nums are in monotonically non-increasing order,
* otherwise false.
* @param {...*} var_args
*/
cljs.core._GT__EQ_ = (function() {
var _GT__EQ_ = null;
var _GT__EQ___1 = (function (x){
return true;
});
var _GT__EQ___2 = (function (x,y){
return (x >= y);
});
var _GT__EQ___3 = (function() { 
var G__8027__delegate = function (x,y,more){
while(true){
if((x >= y)){
if(cljs.core.next(more)){
var G__8028 = y;
var G__8029 = cljs.core.first(more);
var G__8030 = cljs.core.next(more);
x = G__8028;
y = G__8029;
more = G__8030;
continue;
} else {
return (y >= cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__8027 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8031__i = 0, G__8031__a = new Array(arguments.length -  2);
while (G__8031__i < G__8031__a.length) {G__8031__a[G__8031__i] = arguments[G__8031__i + 2]; ++G__8031__i;}
  more = new cljs.core.IndexedSeq(G__8031__a,0);
} 
return G__8027__delegate.call(this,x,y,more);};
G__8027.cljs$lang$maxFixedArity = 2;
G__8027.cljs$lang$applyTo = (function (arglist__8032){
var x = cljs.core.first(arglist__8032);
arglist__8032 = cljs.core.next(arglist__8032);
var y = cljs.core.first(arglist__8032);
var more = cljs.core.rest(arglist__8032);
return G__8027__delegate(x,y,more);
});
G__8027.cljs$core$IFn$_invoke$arity$variadic = G__8027__delegate;
return G__8027;
})()
;
_GT__EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _GT__EQ___1.call(this,x);
case 2:
return _GT__EQ___2.call(this,x,y);
default:
var G__8033 = null;
if (arguments.length > 2) {
var G__8034__i = 0, G__8034__a = new Array(arguments.length -  2);
while (G__8034__i < G__8034__a.length) {G__8034__a[G__8034__i] = arguments[G__8034__i + 2]; ++G__8034__i;}
G__8033 = new cljs.core.IndexedSeq(G__8034__a,0);
}
return _GT__EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8033);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_GT__EQ_.cljs$lang$maxFixedArity = 2;
_GT__EQ_.cljs$lang$applyTo = _GT__EQ___3.cljs$lang$applyTo;
_GT__EQ_.cljs$core$IFn$_invoke$arity$1 = _GT__EQ___1;
_GT__EQ_.cljs$core$IFn$_invoke$arity$2 = _GT__EQ___2;
_GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = _GT__EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return _GT__EQ_;
})()
;
/**
* Returns a number one less than num.
*/
cljs.core.dec = (function dec(x){
return (x - (1));
});
/**
* Returns the greatest of the nums.
* @param {...*} var_args
*/
cljs.core.max = (function() {
var max = null;
var max__1 = (function (x){
return x;
});
var max__2 = (function (x,y){
var x__5419__auto__ = x;
var y__5420__auto__ = y;
return ((x__5419__auto__ > y__5420__auto__) ? x__5419__auto__ : y__5420__auto__);
});
var max__3 = (function() { 
var G__8035__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(max,(function (){var x__5419__auto__ = x;
var y__5420__auto__ = y;
return ((x__5419__auto__ > y__5420__auto__) ? x__5419__auto__ : y__5420__auto__);
})(),more);
};
var G__8035 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8036__i = 0, G__8036__a = new Array(arguments.length -  2);
while (G__8036__i < G__8036__a.length) {G__8036__a[G__8036__i] = arguments[G__8036__i + 2]; ++G__8036__i;}
  more = new cljs.core.IndexedSeq(G__8036__a,0);
} 
return G__8035__delegate.call(this,x,y,more);};
G__8035.cljs$lang$maxFixedArity = 2;
G__8035.cljs$lang$applyTo = (function (arglist__8037){
var x = cljs.core.first(arglist__8037);
arglist__8037 = cljs.core.next(arglist__8037);
var y = cljs.core.first(arglist__8037);
var more = cljs.core.rest(arglist__8037);
return G__8035__delegate(x,y,more);
});
G__8035.cljs$core$IFn$_invoke$arity$variadic = G__8035__delegate;
return G__8035;
})()
;
max = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return max__1.call(this,x);
case 2:
return max__2.call(this,x,y);
default:
var G__8038 = null;
if (arguments.length > 2) {
var G__8039__i = 0, G__8039__a = new Array(arguments.length -  2);
while (G__8039__i < G__8039__a.length) {G__8039__a[G__8039__i] = arguments[G__8039__i + 2]; ++G__8039__i;}
G__8038 = new cljs.core.IndexedSeq(G__8039__a,0);
}
return max__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8038);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
max.cljs$lang$maxFixedArity = 2;
max.cljs$lang$applyTo = max__3.cljs$lang$applyTo;
max.cljs$core$IFn$_invoke$arity$1 = max__1;
max.cljs$core$IFn$_invoke$arity$2 = max__2;
max.cljs$core$IFn$_invoke$arity$variadic = max__3.cljs$core$IFn$_invoke$arity$variadic;
return max;
})()
;
/**
* Returns the least of the nums.
* @param {...*} var_args
*/
cljs.core.min = (function() {
var min = null;
var min__1 = (function (x){
return x;
});
var min__2 = (function (x,y){
var x__5426__auto__ = x;
var y__5427__auto__ = y;
return ((x__5426__auto__ < y__5427__auto__) ? x__5426__auto__ : y__5427__auto__);
});
var min__3 = (function() { 
var G__8040__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(min,(function (){var x__5426__auto__ = x;
var y__5427__auto__ = y;
return ((x__5426__auto__ < y__5427__auto__) ? x__5426__auto__ : y__5427__auto__);
})(),more);
};
var G__8040 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8041__i = 0, G__8041__a = new Array(arguments.length -  2);
while (G__8041__i < G__8041__a.length) {G__8041__a[G__8041__i] = arguments[G__8041__i + 2]; ++G__8041__i;}
  more = new cljs.core.IndexedSeq(G__8041__a,0);
} 
return G__8040__delegate.call(this,x,y,more);};
G__8040.cljs$lang$maxFixedArity = 2;
G__8040.cljs$lang$applyTo = (function (arglist__8042){
var x = cljs.core.first(arglist__8042);
arglist__8042 = cljs.core.next(arglist__8042);
var y = cljs.core.first(arglist__8042);
var more = cljs.core.rest(arglist__8042);
return G__8040__delegate(x,y,more);
});
G__8040.cljs$core$IFn$_invoke$arity$variadic = G__8040__delegate;
return G__8040;
})()
;
min = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return min__1.call(this,x);
case 2:
return min__2.call(this,x,y);
default:
var G__8043 = null;
if (arguments.length > 2) {
var G__8044__i = 0, G__8044__a = new Array(arguments.length -  2);
while (G__8044__i < G__8044__a.length) {G__8044__a[G__8044__i] = arguments[G__8044__i + 2]; ++G__8044__i;}
G__8043 = new cljs.core.IndexedSeq(G__8044__a,0);
}
return min__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8043);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
min.cljs$lang$maxFixedArity = 2;
min.cljs$lang$applyTo = min__3.cljs$lang$applyTo;
min.cljs$core$IFn$_invoke$arity$1 = min__1;
min.cljs$core$IFn$_invoke$arity$2 = min__2;
min.cljs$core$IFn$_invoke$arity$variadic = min__3.cljs$core$IFn$_invoke$arity$variadic;
return min;
})()
;
cljs.core.byte$ = (function byte$(x){
return x;
});
/**
* Coerce to char
*/
cljs.core.char$ = (function char$(x){
if(typeof x === 'number'){
return String.fromCharCode(x);
} else {
if((typeof x === 'string') && ((x.length === (1)))){
return x;
} else {
throw (new Error("Argument to char must be a character or number"));

}
}
});
cljs.core.short$ = (function short$(x){
return x;
});
cljs.core.float$ = (function float$(x){
return x;
});
cljs.core.double$ = (function double$(x){
return x;
});
cljs.core.unchecked_byte = (function unchecked_byte(x){
return x;
});
cljs.core.unchecked_char = (function unchecked_char(x){
return x;
});
cljs.core.unchecked_short = (function unchecked_short(x){
return x;
});
cljs.core.unchecked_float = (function unchecked_float(x){
return x;
});
cljs.core.unchecked_double = (function unchecked_double(x){
return x;
});
/**
* Returns the sum of nums. (+) returns 0.
* @param {...*} var_args
*/
cljs.core.unchecked_add = (function() {
var unchecked_add = null;
var unchecked_add__0 = (function (){
return (0);
});
var unchecked_add__1 = (function (x){
return x;
});
var unchecked_add__2 = (function (x,y){
return (x + y);
});
var unchecked_add__3 = (function() { 
var G__8045__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(unchecked_add,(x + y),more);
};
var G__8045 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8046__i = 0, G__8046__a = new Array(arguments.length -  2);
while (G__8046__i < G__8046__a.length) {G__8046__a[G__8046__i] = arguments[G__8046__i + 2]; ++G__8046__i;}
  more = new cljs.core.IndexedSeq(G__8046__a,0);
} 
return G__8045__delegate.call(this,x,y,more);};
G__8045.cljs$lang$maxFixedArity = 2;
G__8045.cljs$lang$applyTo = (function (arglist__8047){
var x = cljs.core.first(arglist__8047);
arglist__8047 = cljs.core.next(arglist__8047);
var y = cljs.core.first(arglist__8047);
var more = cljs.core.rest(arglist__8047);
return G__8045__delegate(x,y,more);
});
G__8045.cljs$core$IFn$_invoke$arity$variadic = G__8045__delegate;
return G__8045;
})()
;
unchecked_add = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return unchecked_add__0.call(this);
case 1:
return unchecked_add__1.call(this,x);
case 2:
return unchecked_add__2.call(this,x,y);
default:
var G__8048 = null;
if (arguments.length > 2) {
var G__8049__i = 0, G__8049__a = new Array(arguments.length -  2);
while (G__8049__i < G__8049__a.length) {G__8049__a[G__8049__i] = arguments[G__8049__i + 2]; ++G__8049__i;}
G__8048 = new cljs.core.IndexedSeq(G__8049__a,0);
}
return unchecked_add__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8048);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unchecked_add.cljs$lang$maxFixedArity = 2;
unchecked_add.cljs$lang$applyTo = unchecked_add__3.cljs$lang$applyTo;
unchecked_add.cljs$core$IFn$_invoke$arity$0 = unchecked_add__0;
unchecked_add.cljs$core$IFn$_invoke$arity$1 = unchecked_add__1;
unchecked_add.cljs$core$IFn$_invoke$arity$2 = unchecked_add__2;
unchecked_add.cljs$core$IFn$_invoke$arity$variadic = unchecked_add__3.cljs$core$IFn$_invoke$arity$variadic;
return unchecked_add;
})()
;
/**
* Returns the sum of nums. (+) returns 0.
* @param {...*} var_args
*/
cljs.core.unchecked_add_int = (function() {
var unchecked_add_int = null;
var unchecked_add_int__0 = (function (){
return (0);
});
var unchecked_add_int__1 = (function (x){
return x;
});
var unchecked_add_int__2 = (function (x,y){
return (x + y);
});
var unchecked_add_int__3 = (function() { 
var G__8050__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(unchecked_add_int,(x + y),more);
};
var G__8050 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8051__i = 0, G__8051__a = new Array(arguments.length -  2);
while (G__8051__i < G__8051__a.length) {G__8051__a[G__8051__i] = arguments[G__8051__i + 2]; ++G__8051__i;}
  more = new cljs.core.IndexedSeq(G__8051__a,0);
} 
return G__8050__delegate.call(this,x,y,more);};
G__8050.cljs$lang$maxFixedArity = 2;
G__8050.cljs$lang$applyTo = (function (arglist__8052){
var x = cljs.core.first(arglist__8052);
arglist__8052 = cljs.core.next(arglist__8052);
var y = cljs.core.first(arglist__8052);
var more = cljs.core.rest(arglist__8052);
return G__8050__delegate(x,y,more);
});
G__8050.cljs$core$IFn$_invoke$arity$variadic = G__8050__delegate;
return G__8050;
})()
;
unchecked_add_int = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return unchecked_add_int__0.call(this);
case 1:
return unchecked_add_int__1.call(this,x);
case 2:
return unchecked_add_int__2.call(this,x,y);
default:
var G__8053 = null;
if (arguments.length > 2) {
var G__8054__i = 0, G__8054__a = new Array(arguments.length -  2);
while (G__8054__i < G__8054__a.length) {G__8054__a[G__8054__i] = arguments[G__8054__i + 2]; ++G__8054__i;}
G__8053 = new cljs.core.IndexedSeq(G__8054__a,0);
}
return unchecked_add_int__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8053);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unchecked_add_int.cljs$lang$maxFixedArity = 2;
unchecked_add_int.cljs$lang$applyTo = unchecked_add_int__3.cljs$lang$applyTo;
unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = unchecked_add_int__0;
unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = unchecked_add_int__1;
unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = unchecked_add_int__2;
unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = unchecked_add_int__3.cljs$core$IFn$_invoke$arity$variadic;
return unchecked_add_int;
})()
;
cljs.core.unchecked_dec = (function unchecked_dec(x){
return (x - (1));
});
cljs.core.unchecked_dec_int = (function unchecked_dec_int(x){
return (x - (1));
});
/**
* If no denominators are supplied, returns 1/numerator,
* else returns numerator divided by all of the denominators.
* @param {...*} var_args
*/
cljs.core.unchecked_divide_int = (function() {
var unchecked_divide_int = null;
var unchecked_divide_int__1 = (function (x){
return unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((1),x);
});
var unchecked_divide_int__2 = (function (x,y){
return (x / y);
});
var unchecked_divide_int__3 = (function() { 
var G__8059__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(unchecked_divide_int,unchecked_divide_int.cljs$core$IFn$_invoke$arity$2(x,y),more);
};
var G__8059 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8060__i = 0, G__8060__a = new Array(arguments.length -  2);
while (G__8060__i < G__8060__a.length) {G__8060__a[G__8060__i] = arguments[G__8060__i + 2]; ++G__8060__i;}
  more = new cljs.core.IndexedSeq(G__8060__a,0);
} 
return G__8059__delegate.call(this,x,y,more);};
G__8059.cljs$lang$maxFixedArity = 2;
G__8059.cljs$lang$applyTo = (function (arglist__8061){
var x = cljs.core.first(arglist__8061);
arglist__8061 = cljs.core.next(arglist__8061);
var y = cljs.core.first(arglist__8061);
var more = cljs.core.rest(arglist__8061);
return G__8059__delegate(x,y,more);
});
G__8059.cljs$core$IFn$_invoke$arity$variadic = G__8059__delegate;
return G__8059;
})()
;
unchecked_divide_int = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return unchecked_divide_int__1.call(this,x);
case 2:
return unchecked_divide_int__2.call(this,x,y);
default:
var G__8062 = null;
if (arguments.length > 2) {
var G__8063__i = 0, G__8063__a = new Array(arguments.length -  2);
while (G__8063__i < G__8063__a.length) {G__8063__a[G__8063__i] = arguments[G__8063__i + 2]; ++G__8063__i;}
G__8062 = new cljs.core.IndexedSeq(G__8063__a,0);
}
return unchecked_divide_int__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unchecked_divide_int.cljs$lang$maxFixedArity = 2;
unchecked_divide_int.cljs$lang$applyTo = unchecked_divide_int__3.cljs$lang$applyTo;
unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = unchecked_divide_int__1;
unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = unchecked_divide_int__2;
unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = unchecked_divide_int__3.cljs$core$IFn$_invoke$arity$variadic;
return unchecked_divide_int;
})()
;
cljs.core.unchecked_inc = (function unchecked_inc(x){
return (x + (1));
});
cljs.core.unchecked_inc_int = (function unchecked_inc_int(x){
return (x + (1));
});
/**
* Returns the product of nums. (*) returns 1.
* @param {...*} var_args
*/
cljs.core.unchecked_multiply = (function() {
var unchecked_multiply = null;
var unchecked_multiply__0 = (function (){
return (1);
});
var unchecked_multiply__1 = (function (x){
return x;
});
var unchecked_multiply__2 = (function (x,y){
return (x * y);
});
var unchecked_multiply__3 = (function() { 
var G__8064__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(unchecked_multiply,(x * y),more);
};
var G__8064 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8065__i = 0, G__8065__a = new Array(arguments.length -  2);
while (G__8065__i < G__8065__a.length) {G__8065__a[G__8065__i] = arguments[G__8065__i + 2]; ++G__8065__i;}
  more = new cljs.core.IndexedSeq(G__8065__a,0);
} 
return G__8064__delegate.call(this,x,y,more);};
G__8064.cljs$lang$maxFixedArity = 2;
G__8064.cljs$lang$applyTo = (function (arglist__8066){
var x = cljs.core.first(arglist__8066);
arglist__8066 = cljs.core.next(arglist__8066);
var y = cljs.core.first(arglist__8066);
var more = cljs.core.rest(arglist__8066);
return G__8064__delegate(x,y,more);
});
G__8064.cljs$core$IFn$_invoke$arity$variadic = G__8064__delegate;
return G__8064;
})()
;
unchecked_multiply = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return unchecked_multiply__0.call(this);
case 1:
return unchecked_multiply__1.call(this,x);
case 2:
return unchecked_multiply__2.call(this,x,y);
default:
var G__8067 = null;
if (arguments.length > 2) {
var G__8068__i = 0, G__8068__a = new Array(arguments.length -  2);
while (G__8068__i < G__8068__a.length) {G__8068__a[G__8068__i] = arguments[G__8068__i + 2]; ++G__8068__i;}
G__8067 = new cljs.core.IndexedSeq(G__8068__a,0);
}
return unchecked_multiply__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8067);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unchecked_multiply.cljs$lang$maxFixedArity = 2;
unchecked_multiply.cljs$lang$applyTo = unchecked_multiply__3.cljs$lang$applyTo;
unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = unchecked_multiply__0;
unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = unchecked_multiply__1;
unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = unchecked_multiply__2;
unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = unchecked_multiply__3.cljs$core$IFn$_invoke$arity$variadic;
return unchecked_multiply;
})()
;
/**
* Returns the product of nums. (*) returns 1.
* @param {...*} var_args
*/
cljs.core.unchecked_multiply_int = (function() {
var unchecked_multiply_int = null;
var unchecked_multiply_int__0 = (function (){
return (1);
});
var unchecked_multiply_int__1 = (function (x){
return x;
});
var unchecked_multiply_int__2 = (function (x,y){
return (x * y);
});
var unchecked_multiply_int__3 = (function() { 
var G__8069__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(unchecked_multiply_int,(x * y),more);
};
var G__8069 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8070__i = 0, G__8070__a = new Array(arguments.length -  2);
while (G__8070__i < G__8070__a.length) {G__8070__a[G__8070__i] = arguments[G__8070__i + 2]; ++G__8070__i;}
  more = new cljs.core.IndexedSeq(G__8070__a,0);
} 
return G__8069__delegate.call(this,x,y,more);};
G__8069.cljs$lang$maxFixedArity = 2;
G__8069.cljs$lang$applyTo = (function (arglist__8071){
var x = cljs.core.first(arglist__8071);
arglist__8071 = cljs.core.next(arglist__8071);
var y = cljs.core.first(arglist__8071);
var more = cljs.core.rest(arglist__8071);
return G__8069__delegate(x,y,more);
});
G__8069.cljs$core$IFn$_invoke$arity$variadic = G__8069__delegate;
return G__8069;
})()
;
unchecked_multiply_int = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return unchecked_multiply_int__0.call(this);
case 1:
return unchecked_multiply_int__1.call(this,x);
case 2:
return unchecked_multiply_int__2.call(this,x,y);
default:
var G__8072 = null;
if (arguments.length > 2) {
var G__8073__i = 0, G__8073__a = new Array(arguments.length -  2);
while (G__8073__i < G__8073__a.length) {G__8073__a[G__8073__i] = arguments[G__8073__i + 2]; ++G__8073__i;}
G__8072 = new cljs.core.IndexedSeq(G__8073__a,0);
}
return unchecked_multiply_int__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8072);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unchecked_multiply_int.cljs$lang$maxFixedArity = 2;
unchecked_multiply_int.cljs$lang$applyTo = unchecked_multiply_int__3.cljs$lang$applyTo;
unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = unchecked_multiply_int__0;
unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = unchecked_multiply_int__1;
unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = unchecked_multiply_int__2;
unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = unchecked_multiply_int__3.cljs$core$IFn$_invoke$arity$variadic;
return unchecked_multiply_int;
})()
;
cljs.core.unchecked_negate = (function unchecked_negate(x){
return (- x);
});
cljs.core.unchecked_negate_int = (function unchecked_negate_int(x){
return (- x);
});
cljs.core.unchecked_remainder_int = (function unchecked_remainder_int(x,n){
var G__8076 = x;
var G__8077 = n;
return (cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(G__8076,G__8077) : cljs.core.mod.call(null,G__8076,G__8077));
});
/**
* If no ys are supplied, returns the negation of x, else subtracts
* the ys from x and returns the result.
* @param {...*} var_args
*/
cljs.core.unchecked_subtract = (function() {
var unchecked_subtract = null;
var unchecked_subtract__1 = (function (x){
return (- x);
});
var unchecked_subtract__2 = (function (x,y){
return (x - y);
});
var unchecked_subtract__3 = (function() { 
var G__8078__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(unchecked_subtract,(x - y),more);
};
var G__8078 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8079__i = 0, G__8079__a = new Array(arguments.length -  2);
while (G__8079__i < G__8079__a.length) {G__8079__a[G__8079__i] = arguments[G__8079__i + 2]; ++G__8079__i;}
  more = new cljs.core.IndexedSeq(G__8079__a,0);
} 
return G__8078__delegate.call(this,x,y,more);};
G__8078.cljs$lang$maxFixedArity = 2;
G__8078.cljs$lang$applyTo = (function (arglist__8080){
var x = cljs.core.first(arglist__8080);
arglist__8080 = cljs.core.next(arglist__8080);
var y = cljs.core.first(arglist__8080);
var more = cljs.core.rest(arglist__8080);
return G__8078__delegate(x,y,more);
});
G__8078.cljs$core$IFn$_invoke$arity$variadic = G__8078__delegate;
return G__8078;
})()
;
unchecked_subtract = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return unchecked_subtract__1.call(this,x);
case 2:
return unchecked_subtract__2.call(this,x,y);
default:
var G__8081 = null;
if (arguments.length > 2) {
var G__8082__i = 0, G__8082__a = new Array(arguments.length -  2);
while (G__8082__i < G__8082__a.length) {G__8082__a[G__8082__i] = arguments[G__8082__i + 2]; ++G__8082__i;}
G__8081 = new cljs.core.IndexedSeq(G__8082__a,0);
}
return unchecked_subtract__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8081);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unchecked_subtract.cljs$lang$maxFixedArity = 2;
unchecked_subtract.cljs$lang$applyTo = unchecked_subtract__3.cljs$lang$applyTo;
unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = unchecked_subtract__1;
unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = unchecked_subtract__2;
unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = unchecked_subtract__3.cljs$core$IFn$_invoke$arity$variadic;
return unchecked_subtract;
})()
;
/**
* If no ys are supplied, returns the negation of x, else subtracts
* the ys from x and returns the result.
* @param {...*} var_args
*/
cljs.core.unchecked_subtract_int = (function() {
var unchecked_subtract_int = null;
var unchecked_subtract_int__1 = (function (x){
return (- x);
});
var unchecked_subtract_int__2 = (function (x,y){
return (x - y);
});
var unchecked_subtract_int__3 = (function() { 
var G__8083__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(unchecked_subtract_int,(x - y),more);
};
var G__8083 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8084__i = 0, G__8084__a = new Array(arguments.length -  2);
while (G__8084__i < G__8084__a.length) {G__8084__a[G__8084__i] = arguments[G__8084__i + 2]; ++G__8084__i;}
  more = new cljs.core.IndexedSeq(G__8084__a,0);
} 
return G__8083__delegate.call(this,x,y,more);};
G__8083.cljs$lang$maxFixedArity = 2;
G__8083.cljs$lang$applyTo = (function (arglist__8085){
var x = cljs.core.first(arglist__8085);
arglist__8085 = cljs.core.next(arglist__8085);
var y = cljs.core.first(arglist__8085);
var more = cljs.core.rest(arglist__8085);
return G__8083__delegate(x,y,more);
});
G__8083.cljs$core$IFn$_invoke$arity$variadic = G__8083__delegate;
return G__8083;
})()
;
unchecked_subtract_int = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return unchecked_subtract_int__1.call(this,x);
case 2:
return unchecked_subtract_int__2.call(this,x,y);
default:
var G__8086 = null;
if (arguments.length > 2) {
var G__8087__i = 0, G__8087__a = new Array(arguments.length -  2);
while (G__8087__i < G__8087__a.length) {G__8087__a[G__8087__i] = arguments[G__8087__i + 2]; ++G__8087__i;}
G__8086 = new cljs.core.IndexedSeq(G__8087__a,0);
}
return unchecked_subtract_int__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8086);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unchecked_subtract_int.cljs$lang$maxFixedArity = 2;
unchecked_subtract_int.cljs$lang$applyTo = unchecked_subtract_int__3.cljs$lang$applyTo;
unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = unchecked_subtract_int__1;
unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = unchecked_subtract_int__2;
unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = unchecked_subtract_int__3.cljs$core$IFn$_invoke$arity$variadic;
return unchecked_subtract_int;
})()
;
cljs.core.fix = (function fix(q){
if((q >= (0))){
var G__8090 = q;
return (Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__8090) : Math.floor.call(null,G__8090));
} else {
var G__8091 = q;
return (Math.ceil.cljs$core$IFn$_invoke$arity$1 ? Math.ceil.cljs$core$IFn$_invoke$arity$1(G__8091) : Math.ceil.call(null,G__8091));
}
});
/**
* Coerce to int by stripping decimal places.
*/
cljs.core.int$ = (function int$(x){
return (x | (0));
});
/**
* Coerce to int by stripping decimal places.
*/
cljs.core.unchecked_int = (function unchecked_int(x){
return cljs.core.fix(x);
});
/**
* Coerce to long by stripping decimal places. Identical to `int'.
*/
cljs.core.long$ = (function long$(x){
return cljs.core.fix(x);
});
/**
* Coerce to long by stripping decimal places. Identical to `int'.
*/
cljs.core.unchecked_long = (function unchecked_long(x){
return cljs.core.fix(x);
});
cljs.core.booleans = (function booleans(x){
return x;
});
cljs.core.bytes = (function bytes(x){
return x;
});
cljs.core.chars = (function chars(x){
return x;
});
cljs.core.shorts = (function shorts(x){
return x;
});
cljs.core.ints = (function ints(x){
return x;
});
cljs.core.floats = (function floats(x){
return x;
});
cljs.core.doubles = (function doubles(x){
return x;
});
cljs.core.longs = (function longs(x){
return x;
});
/**
* Modulus of num and div with original javascript behavior. i.e. bug for negative numbers
*/
cljs.core.js_mod = (function js_mod(n,d){
return (n % d);
});
/**
* Modulus of num and div. Truncates toward negative infinity.
*/
cljs.core.mod = (function mod(n,d){
return (((n % d) + d) % d);
});
/**
* quot[ient] of dividing numerator by denominator.
*/
cljs.core.quot = (function quot(n,d){
var rem = (n % d);
return cljs.core.fix(((n - rem) / d));
});
/**
* remainder of dividing numerator by denominator.
*/
cljs.core.rem = (function rem(n,d){
var q = cljs.core.quot(n,d);
return (n - (d * q));
});
/**
* Bitwise exclusive or
* @param {...*} var_args
*/
cljs.core.bit_xor = (function() {
var bit_xor = null;
var bit_xor__2 = (function (x,y){
return (x ^ y);
});
var bit_xor__3 = (function() { 
var G__8092__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(bit_xor,(x ^ y),more);
};
var G__8092 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8093__i = 0, G__8093__a = new Array(arguments.length -  2);
while (G__8093__i < G__8093__a.length) {G__8093__a[G__8093__i] = arguments[G__8093__i + 2]; ++G__8093__i;}
  more = new cljs.core.IndexedSeq(G__8093__a,0);
} 
return G__8092__delegate.call(this,x,y,more);};
G__8092.cljs$lang$maxFixedArity = 2;
G__8092.cljs$lang$applyTo = (function (arglist__8094){
var x = cljs.core.first(arglist__8094);
arglist__8094 = cljs.core.next(arglist__8094);
var y = cljs.core.first(arglist__8094);
var more = cljs.core.rest(arglist__8094);
return G__8092__delegate(x,y,more);
});
G__8092.cljs$core$IFn$_invoke$arity$variadic = G__8092__delegate;
return G__8092;
})()
;
bit_xor = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return bit_xor__2.call(this,x,y);
default:
var G__8095 = null;
if (arguments.length > 2) {
var G__8096__i = 0, G__8096__a = new Array(arguments.length -  2);
while (G__8096__i < G__8096__a.length) {G__8096__a[G__8096__i] = arguments[G__8096__i + 2]; ++G__8096__i;}
G__8095 = new cljs.core.IndexedSeq(G__8096__a,0);
}
return bit_xor__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8095);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
bit_xor.cljs$lang$maxFixedArity = 2;
bit_xor.cljs$lang$applyTo = bit_xor__3.cljs$lang$applyTo;
bit_xor.cljs$core$IFn$_invoke$arity$2 = bit_xor__2;
bit_xor.cljs$core$IFn$_invoke$arity$variadic = bit_xor__3.cljs$core$IFn$_invoke$arity$variadic;
return bit_xor;
})()
;
/**
* Bitwise and
* @param {...*} var_args
*/
cljs.core.bit_and = (function() {
var bit_and = null;
var bit_and__2 = (function (x,y){
return (x & y);
});
var bit_and__3 = (function() { 
var G__8097__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(bit_and,(x & y),more);
};
var G__8097 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8098__i = 0, G__8098__a = new Array(arguments.length -  2);
while (G__8098__i < G__8098__a.length) {G__8098__a[G__8098__i] = arguments[G__8098__i + 2]; ++G__8098__i;}
  more = new cljs.core.IndexedSeq(G__8098__a,0);
} 
return G__8097__delegate.call(this,x,y,more);};
G__8097.cljs$lang$maxFixedArity = 2;
G__8097.cljs$lang$applyTo = (function (arglist__8099){
var x = cljs.core.first(arglist__8099);
arglist__8099 = cljs.core.next(arglist__8099);
var y = cljs.core.first(arglist__8099);
var more = cljs.core.rest(arglist__8099);
return G__8097__delegate(x,y,more);
});
G__8097.cljs$core$IFn$_invoke$arity$variadic = G__8097__delegate;
return G__8097;
})()
;
bit_and = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return bit_and__2.call(this,x,y);
default:
var G__8100 = null;
if (arguments.length > 2) {
var G__8101__i = 0, G__8101__a = new Array(arguments.length -  2);
while (G__8101__i < G__8101__a.length) {G__8101__a[G__8101__i] = arguments[G__8101__i + 2]; ++G__8101__i;}
G__8100 = new cljs.core.IndexedSeq(G__8101__a,0);
}
return bit_and__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8100);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
bit_and.cljs$lang$maxFixedArity = 2;
bit_and.cljs$lang$applyTo = bit_and__3.cljs$lang$applyTo;
bit_and.cljs$core$IFn$_invoke$arity$2 = bit_and__2;
bit_and.cljs$core$IFn$_invoke$arity$variadic = bit_and__3.cljs$core$IFn$_invoke$arity$variadic;
return bit_and;
})()
;
/**
* Bitwise or
* @param {...*} var_args
*/
cljs.core.bit_or = (function() {
var bit_or = null;
var bit_or__2 = (function (x,y){
return (x | y);
});
var bit_or__3 = (function() { 
var G__8102__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(bit_or,(x | y),more);
};
var G__8102 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8103__i = 0, G__8103__a = new Array(arguments.length -  2);
while (G__8103__i < G__8103__a.length) {G__8103__a[G__8103__i] = arguments[G__8103__i + 2]; ++G__8103__i;}
  more = new cljs.core.IndexedSeq(G__8103__a,0);
} 
return G__8102__delegate.call(this,x,y,more);};
G__8102.cljs$lang$maxFixedArity = 2;
G__8102.cljs$lang$applyTo = (function (arglist__8104){
var x = cljs.core.first(arglist__8104);
arglist__8104 = cljs.core.next(arglist__8104);
var y = cljs.core.first(arglist__8104);
var more = cljs.core.rest(arglist__8104);
return G__8102__delegate(x,y,more);
});
G__8102.cljs$core$IFn$_invoke$arity$variadic = G__8102__delegate;
return G__8102;
})()
;
bit_or = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return bit_or__2.call(this,x,y);
default:
var G__8105 = null;
if (arguments.length > 2) {
var G__8106__i = 0, G__8106__a = new Array(arguments.length -  2);
while (G__8106__i < G__8106__a.length) {G__8106__a[G__8106__i] = arguments[G__8106__i + 2]; ++G__8106__i;}
G__8105 = new cljs.core.IndexedSeq(G__8106__a,0);
}
return bit_or__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8105);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
bit_or.cljs$lang$maxFixedArity = 2;
bit_or.cljs$lang$applyTo = bit_or__3.cljs$lang$applyTo;
bit_or.cljs$core$IFn$_invoke$arity$2 = bit_or__2;
bit_or.cljs$core$IFn$_invoke$arity$variadic = bit_or__3.cljs$core$IFn$_invoke$arity$variadic;
return bit_or;
})()
;
/**
* Bitwise and
* @param {...*} var_args
*/
cljs.core.bit_and_not = (function() {
var bit_and_not = null;
var bit_and_not__2 = (function (x,y){
return (x & ~y);
});
var bit_and_not__3 = (function() { 
var G__8107__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(bit_and_not,(x & ~y),more);
};
var G__8107 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8108__i = 0, G__8108__a = new Array(arguments.length -  2);
while (G__8108__i < G__8108__a.length) {G__8108__a[G__8108__i] = arguments[G__8108__i + 2]; ++G__8108__i;}
  more = new cljs.core.IndexedSeq(G__8108__a,0);
} 
return G__8107__delegate.call(this,x,y,more);};
G__8107.cljs$lang$maxFixedArity = 2;
G__8107.cljs$lang$applyTo = (function (arglist__8109){
var x = cljs.core.first(arglist__8109);
arglist__8109 = cljs.core.next(arglist__8109);
var y = cljs.core.first(arglist__8109);
var more = cljs.core.rest(arglist__8109);
return G__8107__delegate(x,y,more);
});
G__8107.cljs$core$IFn$_invoke$arity$variadic = G__8107__delegate;
return G__8107;
})()
;
bit_and_not = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return bit_and_not__2.call(this,x,y);
default:
var G__8110 = null;
if (arguments.length > 2) {
var G__8111__i = 0, G__8111__a = new Array(arguments.length -  2);
while (G__8111__i < G__8111__a.length) {G__8111__a[G__8111__i] = arguments[G__8111__i + 2]; ++G__8111__i;}
G__8110 = new cljs.core.IndexedSeq(G__8111__a,0);
}
return bit_and_not__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
bit_and_not.cljs$lang$maxFixedArity = 2;
bit_and_not.cljs$lang$applyTo = bit_and_not__3.cljs$lang$applyTo;
bit_and_not.cljs$core$IFn$_invoke$arity$2 = bit_and_not__2;
bit_and_not.cljs$core$IFn$_invoke$arity$variadic = bit_and_not__3.cljs$core$IFn$_invoke$arity$variadic;
return bit_and_not;
})()
;
/**
* Clear bit at index n
*/
cljs.core.bit_clear = (function bit_clear(x,n){
return (x & ~(1 << n));
});
/**
* Flip bit at index n
*/
cljs.core.bit_flip = (function bit_flip(x,n){
return (x ^ (1 << n));
});
/**
* Bitwise complement
*/
cljs.core.bit_not = (function bit_not(x){
return (~ x);
});
/**
* Set bit at index n
*/
cljs.core.bit_set = (function bit_set(x,n){
return (x | (1 << n));
});
/**
* Test bit at index n
*/
cljs.core.bit_test = (function bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
* Bitwise shift left
*/
cljs.core.bit_shift_left = (function bit_shift_left(x,n){
return (x << n);
});
/**
* Bitwise shift right
*/
cljs.core.bit_shift_right = (function bit_shift_right(x,n){
return (x >> n);
});
/**
* DEPRECATED: Bitwise shift right with zero fill
*/
cljs.core.bit_shift_right_zero_fill = (function bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
* Bitwise shift right with zero fill
*/
cljs.core.unsigned_bit_shift_right = (function unsigned_bit_shift_right(x,n){
return (x >>> n);
});
/**
* Counts the number of bits set in n
*/
cljs.core.bit_count = (function bit_count(v){
var v__$1 = (v - ((v >> (1)) & (1431655765)));
var v__$2 = ((v__$1 & (858993459)) + ((v__$1 >> (2)) & (858993459)));
return ((((v__$2 + (v__$2 >> (4))) & (252645135)) * (16843009)) >> (24));
});
/**
* Returns non-nil if nums all have the equivalent
* value, otherwise false. Behavior on non nums is
* undefined.
* @param {...*} var_args
*/
cljs.core._EQ__EQ_ = (function() {
var _EQ__EQ_ = null;
var _EQ__EQ___1 = (function (x){
return true;
});
var _EQ__EQ___2 = (function (x,y){
return cljs.core._equiv(x,y);
});
var _EQ__EQ___3 = (function() { 
var G__8116__delegate = function (x,y,more){
while(true){
if(_EQ__EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__8117 = y;
var G__8118 = cljs.core.first(more);
var G__8119 = cljs.core.next(more);
x = G__8117;
y = G__8118;
more = G__8119;
continue;
} else {
return _EQ__EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__8116 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8120__i = 0, G__8120__a = new Array(arguments.length -  2);
while (G__8120__i < G__8120__a.length) {G__8120__a[G__8120__i] = arguments[G__8120__i + 2]; ++G__8120__i;}
  more = new cljs.core.IndexedSeq(G__8120__a,0);
} 
return G__8116__delegate.call(this,x,y,more);};
G__8116.cljs$lang$maxFixedArity = 2;
G__8116.cljs$lang$applyTo = (function (arglist__8121){
var x = cljs.core.first(arglist__8121);
arglist__8121 = cljs.core.next(arglist__8121);
var y = cljs.core.first(arglist__8121);
var more = cljs.core.rest(arglist__8121);
return G__8116__delegate(x,y,more);
});
G__8116.cljs$core$IFn$_invoke$arity$variadic = G__8116__delegate;
return G__8116;
})()
;
_EQ__EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _EQ__EQ___1.call(this,x);
case 2:
return _EQ__EQ___2.call(this,x,y);
default:
var G__8122 = null;
if (arguments.length > 2) {
var G__8123__i = 0, G__8123__a = new Array(arguments.length -  2);
while (G__8123__i < G__8123__a.length) {G__8123__a[G__8123__i] = arguments[G__8123__i + 2]; ++G__8123__i;}
G__8122 = new cljs.core.IndexedSeq(G__8123__a,0);
}
return _EQ__EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8122);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_EQ__EQ_.cljs$lang$maxFixedArity = 2;
_EQ__EQ_.cljs$lang$applyTo = _EQ__EQ___3.cljs$lang$applyTo;
_EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = _EQ__EQ___1;
_EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = _EQ__EQ___2;
_EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = _EQ__EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return _EQ__EQ_;
})()
;
/**
* Returns true if num is greater than zero, else false
*/
cljs.core.pos_QMARK_ = (function pos_QMARK_(n){
return (n > (0));
});
cljs.core.zero_QMARK_ = (function zero_QMARK_(n){
return (n === (0));
});
/**
* Returns true if num is less than zero, else false
*/
cljs.core.neg_QMARK_ = (function neg_QMARK_(x){
return (x < (0));
});
/**
* Returns the nth next of coll, (seq coll) when n is 0.
*/
cljs.core.nthnext = (function nthnext(coll,n){
var n__$1 = n;
var xs = cljs.core.seq(coll);
while(true){
if((xs) && ((n__$1 > (0)))){
var G__8124 = (n__$1 - (1));
var G__8125 = cljs.core.next(xs);
n__$1 = G__8124;
xs = G__8125;
continue;
} else {
return xs;
}
break;
}
});
/**
* With no args, returns the empty string. With one arg x, returns
* x.toString().  (str nil) returns the empty string. With more than
* one arg, returns the concatenation of the str values of the args.
* @param {...*} var_args
*/
cljs.core.str = (function() {
var str = null;
var str__0 = (function (){
return "";
});
var str__1 = (function (x){
if((x == null)){
return "";
} else {
var G__8129 = x;
return goog.string.buildString(G__8129);
}
});
var str__2 = (function() { 
var G__8130__delegate = function (x,ys){
var sb = (new goog.string.StringBuffer(str.cljs$core$IFn$_invoke$arity$1(x)));
var more = ys;
while(true){
if(cljs.core.truth_(more)){
var G__8131 = sb.append(str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(more)));
var G__8132 = cljs.core.next(more);
sb = G__8131;
more = G__8132;
continue;
} else {
return sb.toString();
}
break;
}
};
var G__8130 = function (x,var_args){
var ys = null;
if (arguments.length > 1) {
var G__8133__i = 0, G__8133__a = new Array(arguments.length -  1);
while (G__8133__i < G__8133__a.length) {G__8133__a[G__8133__i] = arguments[G__8133__i + 1]; ++G__8133__i;}
  ys = new cljs.core.IndexedSeq(G__8133__a,0);
} 
return G__8130__delegate.call(this,x,ys);};
G__8130.cljs$lang$maxFixedArity = 1;
G__8130.cljs$lang$applyTo = (function (arglist__8134){
var x = cljs.core.first(arglist__8134);
var ys = cljs.core.rest(arglist__8134);
return G__8130__delegate(x,ys);
});
G__8130.cljs$core$IFn$_invoke$arity$variadic = G__8130__delegate;
return G__8130;
})()
;
str = function(x,var_args){
var ys = var_args;
switch(arguments.length){
case 0:
return str__0.call(this);
case 1:
return str__1.call(this,x);
default:
var G__8135 = null;
if (arguments.length > 1) {
var G__8136__i = 0, G__8136__a = new Array(arguments.length -  1);
while (G__8136__i < G__8136__a.length) {G__8136__a[G__8136__i] = arguments[G__8136__i + 1]; ++G__8136__i;}
G__8135 = new cljs.core.IndexedSeq(G__8136__a,0);
}
return str__2.cljs$core$IFn$_invoke$arity$variadic(x, G__8135);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
str.cljs$lang$maxFixedArity = 1;
str.cljs$lang$applyTo = str__2.cljs$lang$applyTo;
str.cljs$core$IFn$_invoke$arity$0 = str__0;
str.cljs$core$IFn$_invoke$arity$1 = str__1;
str.cljs$core$IFn$_invoke$arity$variadic = str__2.cljs$core$IFn$_invoke$arity$variadic;
return str;
})()
;
/**
* Returns the substring of s beginning at start inclusive, and ending
* at end (defaults to length of string), exclusive.
*/
cljs.core.subs = (function() {
var subs = null;
var subs__2 = (function (s,start){
return s.substring(start);
});
var subs__3 = (function (s,start,end){
return s.substring(start,end);
});
subs = function(s,start,end){
switch(arguments.length){
case 2:
return subs__2.call(this,s,start);
case 3:
return subs__3.call(this,s,start,end);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
subs.cljs$core$IFn$_invoke$arity$2 = subs__2;
subs.cljs$core$IFn$_invoke$arity$3 = subs__3;
return subs;
})()
;

/**
* Assumes x is sequential. Returns true if x equals y, otherwise
* returns false.
*/
cljs.core.equiv_sequential = (function equiv_sequential(x,y){
return cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?(((cljs.core.counted_QMARK_(x)) && (cljs.core.counted_QMARK_(y)) && (!((cljs.core.count(x) === cljs.core.count(y)))))?false:(function (){var xs = cljs.core.seq(x);
var ys = cljs.core.seq(y);
while(true){
if((xs == null)){
return (ys == null);
} else {
if((ys == null)){
return false;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){
var G__8137 = cljs.core.next(xs);
var G__8138 = cljs.core.next(ys);
xs = G__8137;
ys = G__8138;
continue;
} else {
return false;

}
}
}
break;
}
})()):null));
});
cljs.core.hash_coll = (function hash_coll(coll){
if(cljs.core.seq(coll)){
var res = cljs.core.hash(cljs.core.first(coll));
var s = cljs.core.next(coll);
while(true){
if((s == null)){
return res;
} else {
var G__8139 = cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));
var G__8140 = cljs.core.next(s);
res = G__8139;
s = G__8140;
continue;
}
break;
}
} else {
return (0);
}
});

cljs.core.hash_imap = (function hash_imap(m){
var h = (0);
var s = cljs.core.seq(m);
while(true){
if(s){
var e = cljs.core.first(s);
var G__8145 = ((h + (cljs.core.hash((function (){var G__8143 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__8143) : cljs.core.key.call(null,G__8143));
})()) ^ cljs.core.hash((function (){var G__8144 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__8144) : cljs.core.val.call(null,G__8144));
})()))) % (4503599627370496));
var G__8146 = cljs.core.next(s);
h = G__8145;
s = G__8146;
continue;
} else {
return h;
}
break;
}
});
cljs.core.hash_iset = (function hash_iset(s){
var h = (0);
var s__$1 = cljs.core.seq(s);
while(true){
if(s__$1){
var e = cljs.core.first(s__$1);
var G__8147 = ((h + cljs.core.hash(e)) % (4503599627370496));
var G__8148 = cljs.core.next(s__$1);
h = G__8147;
s__$1 = G__8148;
continue;
} else {
return h;
}
break;
}
});


/**
* Takes a JavaScript object and a map of names to functions and
* attaches said functions as methods on the object.  Any references to
* JavaScript's implicit this (via the this-as macro) will resolve to the
* object that the function is attached.
*/
cljs.core.extend_object_BANG_ = (function extend_object_BANG_(obj,fn_map){
var seq__8159_8169 = cljs.core.seq(fn_map);
var chunk__8160_8170 = null;
var count__8161_8171 = (0);
var i__8162_8172 = (0);
while(true){
if((i__8162_8172 < count__8161_8171)){
var vec__8163_8173 = chunk__8160_8170.cljs$core$IIndexed$_nth$arity$2(null,i__8162_8172);
var key_name_8174 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8163_8173,(0),null);
var f_8175 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8163_8173,(1),null);
var str_name_8176 = (function (){var G__8164 = key_name_8174;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__8164) : cljs.core.name.call(null,G__8164));
})();
(obj[str_name_8176] = f_8175);

var G__8177 = seq__8159_8169;
var G__8178 = chunk__8160_8170;
var G__8179 = count__8161_8171;
var G__8180 = (i__8162_8172 + (1));
seq__8159_8169 = G__8177;
chunk__8160_8170 = G__8178;
count__8161_8171 = G__8179;
i__8162_8172 = G__8180;
continue;
} else {
var temp__4126__auto___8181 = cljs.core.seq(seq__8159_8169);
if(temp__4126__auto___8181){
var seq__8159_8182__$1 = temp__4126__auto___8181;
if(cljs.core.chunked_seq_QMARK_(seq__8159_8182__$1)){
var c__5889__auto___8183 = (function (){var G__8165 = seq__8159_8182__$1;
return (cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(G__8165) : cljs.core.chunk_first.call(null,G__8165));
})();
var G__8184 = (function (){var G__8166 = seq__8159_8182__$1;
return (cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(G__8166) : cljs.core.chunk_rest.call(null,G__8166));
})();
var G__8185 = c__5889__auto___8183;
var G__8186 = cljs.core.count(c__5889__auto___8183);
var G__8187 = (0);
seq__8159_8169 = G__8184;
chunk__8160_8170 = G__8185;
count__8161_8171 = G__8186;
i__8162_8172 = G__8187;
continue;
} else {
var vec__8167_8188 = cljs.core.first(seq__8159_8182__$1);
var key_name_8189 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8167_8188,(0),null);
var f_8190 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8167_8188,(1),null);
var str_name_8191 = (function (){var G__8168 = key_name_8189;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__8168) : cljs.core.name.call(null,G__8168));
})();
(obj[str_name_8191] = f_8190);

var G__8192 = cljs.core.next(seq__8159_8182__$1);
var G__8193 = null;
var G__8194 = (0);
var G__8195 = (0);
seq__8159_8169 = G__8192;
chunk__8160_8170 = G__8193;
count__8161_8171 = G__8194;
i__8162_8172 = G__8195;
continue;
}
} else {
}
}
break;
}

return obj;
});

/**
* @constructor
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65937646;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.List.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.List.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return null;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._rest(coll__$1);
});

cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5523__auto__ = self__.__hash;
if(!((h__5523__auto__ == null))){
return h__5523__auto__;
} else {
var h__5523__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5523__auto____$1;

return h__5523__auto____$1;
}
});

cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(meta__$1,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));
});

cljs.core.List.cljs$lang$type = true;

cljs.core.List.cljs$lang$ctorStr = "cljs.core/List";

cljs.core.List.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/List");
});

cljs.core.__GT_List = (function __GT_List(meta,first,rest,count,__hash){
return (new cljs.core.List(meta,first,rest,count,__hash));
});

(cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));

/**
* @constructor
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 65937614;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.EmptyList.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.EmptyList.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.EmptyList(self__.meta));
});

cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (0);
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
throw (new Error("Can't pop empty list"));
});

cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.empty_ordered_hash;
});

cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.EmptyList(meta__$1));
});

cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,null,(1),null));
});

cljs.core.EmptyList.cljs$lang$type = true;

cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList";

cljs.core.EmptyList.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/EmptyList");
});

cljs.core.__GT_EmptyList = (function __GT_EmptyList(meta){
return (new cljs.core.EmptyList(meta));
});

cljs.core.List.EMPTY = (new cljs.core.EmptyList(null));
(cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));
cljs.core.reversible_QMARK_ = (function reversible_QMARK_(coll){
var G__8197 = coll;
if(G__8197){
var bit__5783__auto__ = (G__8197.cljs$lang$protocol_mask$partition0$ & (134217728));
if((bit__5783__auto__) || (G__8197.cljs$core$IReversible$)){
return true;
} else {
if((!G__8197.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,G__8197);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,G__8197);
}
});
cljs.core.rseq = (function rseq(coll){
return cljs.core._rseq(coll);
});
/**
* Returns a seq of the items in coll in reverse order. Not lazy.
*/
cljs.core.reverse = (function reverse(coll){
if(cljs.core.reversible_QMARK_(coll)){
return cljs.core.rseq(coll);
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
* @param {...*} var_args
*/
cljs.core.list = (function() { 
var list__delegate = function (xs){
var arr = ((((xs instanceof cljs.core.IndexedSeq)) && ((xs.i === (0))))?xs.arr:(function (){var arr = [];
var xs__$1 = xs;
while(true){
if(!((xs__$1 == null))){
arr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));

var G__8198 = xs__$1.cljs$core$INext$_next$arity$1(null);
xs__$1 = G__8198;
continue;
} else {
return arr;
}
break;
}
})());
var i = arr.length;
var r = cljs.core.List.EMPTY;
while(true){
if((i > (0))){
var G__8199 = (i - (1));
var G__8200 = r.cljs$core$ICollection$_conj$arity$2(null,(arr[(i - (1))]));
i = G__8199;
r = G__8200;
continue;
} else {
return r;
}
break;
}
};
var list = function (var_args){
var xs = null;
if (arguments.length > 0) {
var G__8201__i = 0, G__8201__a = new Array(arguments.length -  0);
while (G__8201__i < G__8201__a.length) {G__8201__a[G__8201__i] = arguments[G__8201__i + 0]; ++G__8201__i;}
  xs = new cljs.core.IndexedSeq(G__8201__a,0);
} 
return list__delegate.call(this,xs);};
list.cljs$lang$maxFixedArity = 0;
list.cljs$lang$applyTo = (function (arglist__8202){
var xs = cljs.core.seq(arglist__8202);
return list__delegate(xs);
});
list.cljs$core$IFn$_invoke$arity$variadic = list__delegate;
return list;
})()
;

/**
* @constructor
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65929452;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Cons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Cons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return null;
} else {
return cljs.core.seq(self__.rest);
}
});

cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5523__auto__ = self__.__hash;
if(!((h__5523__auto__ == null))){
return h__5523__auto__;
} else {
var h__5523__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5523__auto____$1;

return h__5523__auto____$1;
}
});

cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(meta__$1,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(null,o,coll__$1,self__.__hash));
});

cljs.core.Cons.cljs$lang$type = true;

cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons";

cljs.core.Cons.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/Cons");
});

cljs.core.__GT_Cons = (function __GT_Cons(meta,first,rest,__hash){
return (new cljs.core.Cons(meta,first,rest,__hash));
});

(cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));
/**
* Returns a new seq where x is the first element and seq is the rest.
*/
cljs.core.cons = (function cons(x,coll){
if((function (){var or__5102__auto__ = (coll == null);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var G__8206 = coll;
if(G__8206){
var bit__5776__auto__ = (G__8206.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__5776__auto__) || (G__8206.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
return (new cljs.core.Cons(null,x,coll,null));
} else {
return (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));
}
});
cljs.core.list_QMARK_ = (function list_QMARK_(x){
var G__8208 = x;
if(G__8208){
var bit__5783__auto__ = (G__8208.cljs$lang$protocol_mask$partition0$ & (33554432));
if((bit__5783__auto__) || (G__8208.cljs$core$IList$)){
return true;
} else {
if((!G__8208.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,G__8208);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,G__8208);
}
});
cljs.core.hash_keyword = (function hash_keyword(k){
return ((cljs.core.hash_symbol(k) + (2654435769)) | (0));
});
cljs.core.compare_keywords = (function compare_keywords(a,b){
if((a.fqn === b.fqn)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__5090__auto__ = cljs.core.not(a.ns);
if(and__5090__auto__){
return b.ns;
} else {
return and__5090__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__8215 = a.ns;
var G__8216 = b.ns;
return goog.array.defaultCompare(G__8215,G__8216);
})();
if(((0) === nsc)){
var G__8217 = a.name;
var G__8218 = b.name;
return goog.array.defaultCompare(G__8217,G__8218);
} else {
return nsc;
}
}
} else {
var G__8219 = a.name;
var G__8220 = b.name;
return goog.array.defaultCompare(G__8219,G__8220);

}
}
}
});

/**
* @constructor
*/
cljs.core.Keyword = (function (ns,name,fqn,_hash){
this.ns = ns;
this.name = name;
this.fqn = fqn;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 2153775105;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,[cljs.core.str(":"),cljs.core.str(self__.fqn)].join(''));
});

cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__5523__auto__ = self__._hash;
if(!((h__5523__auto__ == null))){
return h__5523__auto__;
} else {
var h__5523__auto____$1 = cljs.core.hash_keyword(this$__$1);
self__._hash = h__5523__auto____$1;

return h__5523__auto____$1;
}
});

cljs.core.Keyword.prototype.call = (function() {
var G__8222 = null;
var G__8222__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});
var G__8222__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});
G__8222 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__8222__2.call(this,self__,coll);
case 3:
return G__8222__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8222.cljs$core$IFn$_invoke$arity$2 = G__8222__2;
G__8222.cljs$core$IFn$_invoke$arity$3 = G__8222__3;
return G__8222;
})()
;

cljs.core.Keyword.prototype.apply = (function (self__,args8221){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args8221)));
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});

cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Keyword)){
return (self__.fqn === other.fqn);
} else {
return false;
}
});

cljs.core.Keyword.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [cljs.core.str(":"),cljs.core.str(self__.fqn)].join('');
});

cljs.core.Keyword.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Keyword.cljs$lang$type = true;

cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword";

cljs.core.Keyword.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/Keyword");
});

cljs.core.__GT_Keyword = (function __GT_Keyword(ns,name,fqn,_hash){
return (new cljs.core.Keyword(ns,name,fqn,_hash));
});

cljs.core.keyword_QMARK_ = (function keyword_QMARK_(x){
return (x instanceof cljs.core.Keyword);
});
cljs.core.keyword_identical_QMARK_ = (function keyword_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if(((x instanceof cljs.core.Keyword)) && ((y instanceof cljs.core.Keyword))){
return (x.fqn === y.fqn);
} else {
return false;
}
}
});
/**
* Returns the namespace String of a symbol or keyword, or nil if not present.
*/
cljs.core.namespace = (function namespace(x){
if((function (){var G__8224 = x;
if(G__8224){
var bit__5776__auto__ = (G__8224.cljs$lang$protocol_mask$partition1$ & (4096));
if((bit__5776__auto__) || (G__8224.cljs$core$INamed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$INamed$_namespace$arity$1(null);
} else {
throw (new Error([cljs.core.str("Doesn't support namespace: "),cljs.core.str(x)].join('')));
}
});
/**
* Returns a Keyword with the given namespace and name.  Do not use :
* in the keyword strings, it will be added automatically.
*/
cljs.core.keyword = (function() {
var keyword = null;
var keyword__1 = (function (name){
if((name instanceof cljs.core.Keyword)){
return name;
} else {
if((name instanceof cljs.core.Symbol)){
return (new cljs.core.Keyword(cljs.core.namespace(name),(function (){var G__8226 = name;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__8226) : cljs.core.name.call(null,G__8226));
})(),name.str,null));
} else {
if(typeof name === 'string'){
var parts = name.split("/");
if((parts.length === (2))){
return (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));
} else {
return (new cljs.core.Keyword(null,(parts[(0)]),name,null));
}
} else {
return null;
}
}
}
});
var keyword__2 = (function (ns,name){
return (new cljs.core.Keyword(ns,name,[cljs.core.str((cljs.core.truth_(ns)?[cljs.core.str(ns),cljs.core.str("/")].join(''):null)),cljs.core.str(name)].join(''),null));
});
keyword = function(ns,name){
switch(arguments.length){
case 1:
return keyword__1.call(this,ns);
case 2:
return keyword__2.call(this,ns,name);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
keyword.cljs$core$IFn$_invoke$arity$1 = keyword__1;
keyword.cljs$core$IFn$_invoke$arity$2 = keyword__2;
return keyword;
})()
;

/**
* @constructor
*/
cljs.core.LazySeq = (function (meta,fn,s,__hash){
this.meta = meta;
this.fn = fn;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
})
cljs.core.LazySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.LazySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.LazySeq.prototype.sval = (function (){
var self__ = this;
var coll = this;
if((self__.fn == null)){
return self__.s;
} else {
self__.s = (function (){return (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null));
})();

self__.fn = null;

return self__.s;
}
});

cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.next(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5523__auto__ = self__.__hash;
if(!((h__5523__auto__ == null))){
return h__5523__auto__;
} else {
var h__5523__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5523__auto____$1;

return h__5523__auto____$1;
}
});

cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if(!((self__.s == null))){
return cljs.core.rest(self__.s);
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.sval();

if((self__.s == null)){
return null;
} else {
var ls = self__.s;
while(true){
if((ls instanceof cljs.core.LazySeq)){
var G__8227 = ls.sval();
ls = G__8227;
continue;
} else {
self__.s = ls;

return cljs.core.seq(self__.s);
}
break;
}
}
});

cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.LazySeq(meta__$1,self__.fn,self__.s,self__.__hash));
});

cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.LazySeq.cljs$lang$type = true;

cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq";

cljs.core.LazySeq.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/LazySeq");
});

cljs.core.__GT_LazySeq = (function __GT_LazySeq(meta,fn,s,__hash){
return (new cljs.core.LazySeq(meta,fn,s,__hash));
});

(cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));

/**
* @constructor
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2;
})
cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.end;
});

cljs.core.ChunkBuffer.prototype.add = (function (o){
var self__ = this;
var _ = this;
(self__.buf[self__.end] = o);

return self__.end = (self__.end + (1));
});

cljs.core.ChunkBuffer.prototype.chunk = (function (o){
var self__ = this;
var _ = this;
var ret = (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));
self__.buf = null;

return ret;
});

cljs.core.ChunkBuffer.cljs$lang$type = true;

cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer";

cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/ChunkBuffer");
});

cljs.core.__GT_ChunkBuffer = (function __GT_ChunkBuffer(buf,end){
return (new cljs.core.ChunkBuffer(buf,end));
});

cljs.core.chunk_buffer = (function chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));
});

/**
* @constructor
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 524306;
})
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));
});

cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);
});

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = true;

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.off === self__.end)){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));
}
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.arr[(self__.off + i)]);
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if(((i >= (0))) && ((i < (self__.end - self__.off)))){
return (self__.arr[(self__.off + i)]);
} else {
return not_found;
}
});

cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.end - self__.off);
});

cljs.core.ArrayChunk.cljs$lang$type = true;

cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk";

cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/ArrayChunk");
});

cljs.core.__GT_ArrayChunk = (function __GT_ArrayChunk(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk = (function() {
var array_chunk = null;
var array_chunk__1 = (function (arr){
return (new cljs.core.ArrayChunk(arr,(0),arr.length));
});
var array_chunk__2 = (function (arr,off){
return (new cljs.core.ArrayChunk(arr,off,arr.length));
});
var array_chunk__3 = (function (arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});
array_chunk = function(arr,off,end){
switch(arguments.length){
case 1:
return array_chunk__1.call(this,arr);
case 2:
return array_chunk__2.call(this,arr,off);
case 3:
return array_chunk__3.call(this,arr,off,end);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
array_chunk.cljs$core$IFn$_invoke$arity$1 = array_chunk__1;
array_chunk.cljs$core$IFn$_invoke$arity$2 = array_chunk__2;
array_chunk.cljs$core$IFn$_invoke$arity$3 = array_chunk__3;
return array_chunk;
})()
;

/**
* @constructor
*/
cljs.core.ChunkedCons = (function (chunk,more,meta,__hash){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850732;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedCons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedCons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
var more__$1 = cljs.core._seq(self__.more);
if((more__$1 == null)){
return null;
} else {
return more__$1;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5523__auto__ = self__.__hash;
if(!((h__5523__auto__ == null))){
return h__5523__auto__;
} else {
var h__5523__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5523__auto____$1;

return h__5523__auto____$1;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk,(0));
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.chunk;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ChunkedCons(self__.chunk,self__.more,m,self__.__hash));
});

cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,this$__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return null;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.cljs$lang$type = true;

cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons";

cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/ChunkedCons");
});

cljs.core.__GT_ChunkedCons = (function __GT_ChunkedCons(chunk,more,meta,__hash){
return (new cljs.core.ChunkedCons(chunk,more,meta,__hash));
});

(cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));
cljs.core.chunk_cons = (function chunk_cons(chunk,rest){
if((cljs.core._count(chunk) === (0))){
return rest;
} else {
return (new cljs.core.ChunkedCons(chunk,rest,null,null));
}
});
cljs.core.chunk_append = (function chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function chunk_first(s){
return cljs.core._chunked_first(s);
});
cljs.core.chunk_rest = (function chunk_rest(s){
return cljs.core._chunked_rest(s);
});
cljs.core.chunk_next = (function chunk_next(s){
if((function (){var G__8229 = s;
if(G__8229){
var bit__5776__auto__ = (G__8229.cljs$lang$protocol_mask$partition1$ & (1024));
if((bit__5776__auto__) || (G__8229.cljs$core$IChunkedNext$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core._chunked_next(s);
} else {
return cljs.core.seq(cljs.core._chunked_rest(s));
}
});
/**
* Naive impl of to-array as a start.
*/
cljs.core.to_array = (function to_array(s){
var ary = [];
var s__$1 = s;
while(true){
if(cljs.core.seq(s__$1)){
ary.push(cljs.core.first(s__$1));

var G__8230 = cljs.core.next(s__$1);
s__$1 = G__8230;
continue;
} else {
return ary;
}
break;
}
});
/**
* Returns a (potentially-ragged) 2-dimensional array
* containing the contents of coll.
*/
cljs.core.to_array_2d = (function to_array_2d(coll){
var ret = (new Array(cljs.core.count(coll)));
var i_8231 = (0);
var xs_8232 = cljs.core.seq(coll);
while(true){
if(xs_8232){
(ret[i_8231] = cljs.core.to_array(cljs.core.first(xs_8232)));

var G__8233 = (i_8231 + (1));
var G__8234 = cljs.core.next(xs_8232);
i_8231 = G__8233;
xs_8232 = G__8234;
continue;
} else {
}
break;
}

return ret;
});
cljs.core.int_array = (function() {
var int_array = null;
var int_array__1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});
var int_array__2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__8237 = (i + (1));
var G__8238 = cljs.core.next(s__$1);
i = G__8237;
s__$1 = G__8238;
continue;
} else {
return a;
}
break;
}
} else {
var n__5989__auto___8239 = size;
var i_8240 = (0);
while(true){
if((i_8240 < n__5989__auto___8239)){
(a[i_8240] = init_val_or_seq);

var G__8241 = (i_8240 + (1));
i_8240 = G__8241;
continue;
} else {
}
break;
}

return a;
}
});
int_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return int_array__1.call(this,size);
case 2:
return int_array__2.call(this,size,init_val_or_seq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
int_array.cljs$core$IFn$_invoke$arity$1 = int_array__1;
int_array.cljs$core$IFn$_invoke$arity$2 = int_array__2;
return int_array;
})()
;
cljs.core.long_array = (function() {
var long_array = null;
var long_array__1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});
var long_array__2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__8244 = (i + (1));
var G__8245 = cljs.core.next(s__$1);
i = G__8244;
s__$1 = G__8245;
continue;
} else {
return a;
}
break;
}
} else {
var n__5989__auto___8246 = size;
var i_8247 = (0);
while(true){
if((i_8247 < n__5989__auto___8246)){
(a[i_8247] = init_val_or_seq);

var G__8248 = (i_8247 + (1));
i_8247 = G__8248;
continue;
} else {
}
break;
}

return a;
}
});
long_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return long_array__1.call(this,size);
case 2:
return long_array__2.call(this,size,init_val_or_seq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
long_array.cljs$core$IFn$_invoke$arity$1 = long_array__1;
long_array.cljs$core$IFn$_invoke$arity$2 = long_array__2;
return long_array;
})()
;
cljs.core.double_array = (function() {
var double_array = null;
var double_array__1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});
var double_array__2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__8251 = (i + (1));
var G__8252 = cljs.core.next(s__$1);
i = G__8251;
s__$1 = G__8252;
continue;
} else {
return a;
}
break;
}
} else {
var n__5989__auto___8253 = size;
var i_8254 = (0);
while(true){
if((i_8254 < n__5989__auto___8253)){
(a[i_8254] = init_val_or_seq);

var G__8255 = (i_8254 + (1));
i_8254 = G__8255;
continue;
} else {
}
break;
}

return a;
}
});
double_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return double_array__1.call(this,size);
case 2:
return double_array__2.call(this,size,init_val_or_seq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
double_array.cljs$core$IFn$_invoke$arity$1 = double_array__1;
double_array.cljs$core$IFn$_invoke$arity$2 = double_array__2;
return double_array;
})()
;
cljs.core.object_array = (function() {
var object_array = null;
var object_array__1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});
var object_array__2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__8258 = (i + (1));
var G__8259 = cljs.core.next(s__$1);
i = G__8258;
s__$1 = G__8259;
continue;
} else {
return a;
}
break;
}
} else {
var n__5989__auto___8260 = size;
var i_8261 = (0);
while(true){
if((i_8261 < n__5989__auto___8260)){
(a[i_8261] = init_val_or_seq);

var G__8262 = (i_8261 + (1));
i_8261 = G__8262;
continue;
} else {
}
break;
}

return a;
}
});
object_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return object_array__1.call(this,size);
case 2:
return object_array__2.call(this,size,init_val_or_seq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
object_array.cljs$core$IFn$_invoke$arity$1 = object_array__1;
object_array.cljs$core$IFn$_invoke$arity$2 = object_array__2;
return object_array;
})()
;
cljs.core.bounded_count = (function bounded_count(s,n){
if(cljs.core.counted_QMARK_(s)){
return cljs.core.count(s);
} else {
var s__$1 = s;
var i = n;
var sum = (0);
while(true){
if(((i > (0))) && (cljs.core.seq(s__$1))){
var G__8263 = cljs.core.next(s__$1);
var G__8264 = (i - (1));
var G__8265 = (sum + (1));
s__$1 = G__8263;
i = G__8264;
sum = G__8265;
continue;
} else {
return sum;
}
break;
}
}
});
cljs.core.spread = (function spread(arglist){
if((arglist == null)){
return null;
} else {
if((cljs.core.next(arglist) == null)){
return cljs.core.seq(cljs.core.first(arglist));
} else {
return cljs.core.cons(cljs.core.first(arglist),spread(cljs.core.next(arglist)));

}
}
});
/**
* Returns a lazy seq representing the concatenation of the elements in the supplied colls.
* @param {...*} var_args
*/
cljs.core.concat = (function() {
var concat = null;
var concat__0 = (function (){
return (new cljs.core.LazySeq(null,(function (){
return null;
}),null,null));
});
var concat__1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return x;
}),null,null));
});
var concat__2 = (function (x,y){
return (new cljs.core.LazySeq(null,(function (){
var s = cljs.core.seq(x);
if(s){
if(cljs.core.chunked_seq_QMARK_(s)){
return cljs.core.chunk_cons(cljs.core.chunk_first(s),concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));
} else {
return cljs.core.cons(cljs.core.first(s),concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));
}
} else {
return y;
}
}),null,null));
});
var concat__3 = (function() { 
var G__8285__delegate = function (x,y,zs){
var cat = (function cat(xys,zs__$1){
return (new cljs.core.LazySeq(null,(function (){
var xys__$1 = cljs.core.seq(xys);
if(xys__$1){
if(cljs.core.chunked_seq_QMARK_(xys__$1)){
return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cat(cljs.core.chunk_rest(xys__$1),zs__$1));
} else {
return cljs.core.cons(cljs.core.first(xys__$1),cat(cljs.core.rest(xys__$1),zs__$1));
}
} else {
if(cljs.core.truth_(zs__$1)){
return cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);
};
var G__8285 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__8286__i = 0, G__8286__a = new Array(arguments.length -  2);
while (G__8286__i < G__8286__a.length) {G__8286__a[G__8286__i] = arguments[G__8286__i + 2]; ++G__8286__i;}
  zs = new cljs.core.IndexedSeq(G__8286__a,0);
} 
return G__8285__delegate.call(this,x,y,zs);};
G__8285.cljs$lang$maxFixedArity = 2;
G__8285.cljs$lang$applyTo = (function (arglist__8287){
var x = cljs.core.first(arglist__8287);
arglist__8287 = cljs.core.next(arglist__8287);
var y = cljs.core.first(arglist__8287);
var zs = cljs.core.rest(arglist__8287);
return G__8285__delegate(x,y,zs);
});
G__8285.cljs$core$IFn$_invoke$arity$variadic = G__8285__delegate;
return G__8285;
})()
;
concat = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return concat__0.call(this);
case 1:
return concat__1.call(this,x);
case 2:
return concat__2.call(this,x,y);
default:
var G__8288 = null;
if (arguments.length > 2) {
var G__8289__i = 0, G__8289__a = new Array(arguments.length -  2);
while (G__8289__i < G__8289__a.length) {G__8289__a[G__8289__i] = arguments[G__8289__i + 2]; ++G__8289__i;}
G__8288 = new cljs.core.IndexedSeq(G__8289__a,0);
}
return concat__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8288);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
concat.cljs$lang$maxFixedArity = 2;
concat.cljs$lang$applyTo = concat__3.cljs$lang$applyTo;
concat.cljs$core$IFn$_invoke$arity$0 = concat__0;
concat.cljs$core$IFn$_invoke$arity$1 = concat__1;
concat.cljs$core$IFn$_invoke$arity$2 = concat__2;
concat.cljs$core$IFn$_invoke$arity$variadic = concat__3.cljs$core$IFn$_invoke$arity$variadic;
return concat;
})()
;
/**
* Creates a new list containing the items prepended to the rest, the
* last of which will be treated as a sequence.
* @param {...*} var_args
*/
cljs.core.list_STAR_ = (function() {
var list_STAR_ = null;
var list_STAR___1 = (function (args){
return cljs.core.seq(args);
});
var list_STAR___2 = (function (a,args){
return cljs.core.cons(a,args);
});
var list_STAR___3 = (function (a,b,args){
return cljs.core.cons(a,cljs.core.cons(b,args));
});
var list_STAR___4 = (function (a,b,c,args){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));
});
var list_STAR___5 = (function() { 
var G__8290__delegate = function (a,b,c,d,more){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));
};
var G__8290 = function (a,b,c,d,var_args){
var more = null;
if (arguments.length > 4) {
var G__8291__i = 0, G__8291__a = new Array(arguments.length -  4);
while (G__8291__i < G__8291__a.length) {G__8291__a[G__8291__i] = arguments[G__8291__i + 4]; ++G__8291__i;}
  more = new cljs.core.IndexedSeq(G__8291__a,0);
} 
return G__8290__delegate.call(this,a,b,c,d,more);};
G__8290.cljs$lang$maxFixedArity = 4;
G__8290.cljs$lang$applyTo = (function (arglist__8292){
var a = cljs.core.first(arglist__8292);
arglist__8292 = cljs.core.next(arglist__8292);
var b = cljs.core.first(arglist__8292);
arglist__8292 = cljs.core.next(arglist__8292);
var c = cljs.core.first(arglist__8292);
arglist__8292 = cljs.core.next(arglist__8292);
var d = cljs.core.first(arglist__8292);
var more = cljs.core.rest(arglist__8292);
return G__8290__delegate(a,b,c,d,more);
});
G__8290.cljs$core$IFn$_invoke$arity$variadic = G__8290__delegate;
return G__8290;
})()
;
list_STAR_ = function(a,b,c,d,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return list_STAR___1.call(this,a);
case 2:
return list_STAR___2.call(this,a,b);
case 3:
return list_STAR___3.call(this,a,b,c);
case 4:
return list_STAR___4.call(this,a,b,c,d);
default:
var G__8293 = null;
if (arguments.length > 4) {
var G__8294__i = 0, G__8294__a = new Array(arguments.length -  4);
while (G__8294__i < G__8294__a.length) {G__8294__a[G__8294__i] = arguments[G__8294__i + 4]; ++G__8294__i;}
G__8293 = new cljs.core.IndexedSeq(G__8294__a,0);
}
return list_STAR___5.cljs$core$IFn$_invoke$arity$variadic(a,b,c,d, G__8293);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
list_STAR_.cljs$lang$maxFixedArity = 4;
list_STAR_.cljs$lang$applyTo = list_STAR___5.cljs$lang$applyTo;
list_STAR_.cljs$core$IFn$_invoke$arity$1 = list_STAR___1;
list_STAR_.cljs$core$IFn$_invoke$arity$2 = list_STAR___2;
list_STAR_.cljs$core$IFn$_invoke$arity$3 = list_STAR___3;
list_STAR_.cljs$core$IFn$_invoke$arity$4 = list_STAR___4;
list_STAR_.cljs$core$IFn$_invoke$arity$variadic = list_STAR___5.cljs$core$IFn$_invoke$arity$variadic;
return list_STAR_;
})()
;
/**
* Returns a new, transient version of the collection, in constant time.
*/
cljs.core.transient$ = (function transient$(coll){
return cljs.core._as_transient(coll);
});
/**
* Returns a new, persistent version of the transient collection, in
* constant time. The transient collection cannot be used after this
* call, any such use will throw an exception.
*/
cljs.core.persistent_BANG_ = (function persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_(tcoll);
});
/**
* Adds x to the transient collection, and return coll. The 'addition'
* may happen at different 'places' depending on the concrete type.
* @param {...*} var_args
*/
cljs.core.conj_BANG_ = (function() {
var conj_BANG_ = null;
var conj_BANG___0 = (function (){
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
});
var conj_BANG___1 = (function (coll){
return coll;
});
var conj_BANG___2 = (function (tcoll,val){
return cljs.core._conj_BANG_(tcoll,val);
});
var conj_BANG___3 = (function() { 
var G__8295__delegate = function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._conj_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__8296 = ntcoll;
var G__8297 = cljs.core.first(vals);
var G__8298 = cljs.core.next(vals);
tcoll = G__8296;
val = G__8297;
vals = G__8298;
continue;
} else {
return ntcoll;
}
break;
}
};
var G__8295 = function (tcoll,val,var_args){
var vals = null;
if (arguments.length > 2) {
var G__8299__i = 0, G__8299__a = new Array(arguments.length -  2);
while (G__8299__i < G__8299__a.length) {G__8299__a[G__8299__i] = arguments[G__8299__i + 2]; ++G__8299__i;}
  vals = new cljs.core.IndexedSeq(G__8299__a,0);
} 
return G__8295__delegate.call(this,tcoll,val,vals);};
G__8295.cljs$lang$maxFixedArity = 2;
G__8295.cljs$lang$applyTo = (function (arglist__8300){
var tcoll = cljs.core.first(arglist__8300);
arglist__8300 = cljs.core.next(arglist__8300);
var val = cljs.core.first(arglist__8300);
var vals = cljs.core.rest(arglist__8300);
return G__8295__delegate(tcoll,val,vals);
});
G__8295.cljs$core$IFn$_invoke$arity$variadic = G__8295__delegate;
return G__8295;
})()
;
conj_BANG_ = function(tcoll,val,var_args){
var vals = var_args;
switch(arguments.length){
case 0:
return conj_BANG___0.call(this);
case 1:
return conj_BANG___1.call(this,tcoll);
case 2:
return conj_BANG___2.call(this,tcoll,val);
default:
var G__8301 = null;
if (arguments.length > 2) {
var G__8302__i = 0, G__8302__a = new Array(arguments.length -  2);
while (G__8302__i < G__8302__a.length) {G__8302__a[G__8302__i] = arguments[G__8302__i + 2]; ++G__8302__i;}
G__8301 = new cljs.core.IndexedSeq(G__8302__a,0);
}
return conj_BANG___3.cljs$core$IFn$_invoke$arity$variadic(tcoll,val, G__8301);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
conj_BANG_.cljs$lang$maxFixedArity = 2;
conj_BANG_.cljs$lang$applyTo = conj_BANG___3.cljs$lang$applyTo;
conj_BANG_.cljs$core$IFn$_invoke$arity$0 = conj_BANG___0;
conj_BANG_.cljs$core$IFn$_invoke$arity$1 = conj_BANG___1;
conj_BANG_.cljs$core$IFn$_invoke$arity$2 = conj_BANG___2;
conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = conj_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return conj_BANG_;
})()
;
/**
* When applied to a transient map, adds mapping of key(s) to
* val(s). When applied to a transient vector, sets the val at index.
* Note - index must be <= (count vector). Returns coll.
* @param {...*} var_args
*/
cljs.core.assoc_BANG_ = (function() {
var assoc_BANG_ = null;
var assoc_BANG___3 = (function (tcoll,key,val){
return cljs.core._assoc_BANG_(tcoll,key,val);
});
var assoc_BANG___4 = (function() { 
var G__8303__delegate = function (tcoll,key,val,kvs){
while(true){
var ntcoll = cljs.core._assoc_BANG_(tcoll,key,val);
if(cljs.core.truth_(kvs)){
var G__8304 = ntcoll;
var G__8305 = cljs.core.first(kvs);
var G__8306 = cljs.core.second(kvs);
var G__8307 = cljs.core.nnext(kvs);
tcoll = G__8304;
key = G__8305;
val = G__8306;
kvs = G__8307;
continue;
} else {
return ntcoll;
}
break;
}
};
var G__8303 = function (tcoll,key,val,var_args){
var kvs = null;
if (arguments.length > 3) {
var G__8308__i = 0, G__8308__a = new Array(arguments.length -  3);
while (G__8308__i < G__8308__a.length) {G__8308__a[G__8308__i] = arguments[G__8308__i + 3]; ++G__8308__i;}
  kvs = new cljs.core.IndexedSeq(G__8308__a,0);
} 
return G__8303__delegate.call(this,tcoll,key,val,kvs);};
G__8303.cljs$lang$maxFixedArity = 3;
G__8303.cljs$lang$applyTo = (function (arglist__8309){
var tcoll = cljs.core.first(arglist__8309);
arglist__8309 = cljs.core.next(arglist__8309);
var key = cljs.core.first(arglist__8309);
arglist__8309 = cljs.core.next(arglist__8309);
var val = cljs.core.first(arglist__8309);
var kvs = cljs.core.rest(arglist__8309);
return G__8303__delegate(tcoll,key,val,kvs);
});
G__8303.cljs$core$IFn$_invoke$arity$variadic = G__8303__delegate;
return G__8303;
})()
;
assoc_BANG_ = function(tcoll,key,val,var_args){
var kvs = var_args;
switch(arguments.length){
case 3:
return assoc_BANG___3.call(this,tcoll,key,val);
default:
var G__8310 = null;
if (arguments.length > 3) {
var G__8311__i = 0, G__8311__a = new Array(arguments.length -  3);
while (G__8311__i < G__8311__a.length) {G__8311__a[G__8311__i] = arguments[G__8311__i + 3]; ++G__8311__i;}
G__8310 = new cljs.core.IndexedSeq(G__8311__a,0);
}
return assoc_BANG___4.cljs$core$IFn$_invoke$arity$variadic(tcoll,key,val, G__8310);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
assoc_BANG_.cljs$lang$maxFixedArity = 3;
assoc_BANG_.cljs$lang$applyTo = assoc_BANG___4.cljs$lang$applyTo;
assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = assoc_BANG___3;
assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = assoc_BANG___4.cljs$core$IFn$_invoke$arity$variadic;
return assoc_BANG_;
})()
;
/**
* Returns a transient map that doesn't contain a mapping for key(s).
* @param {...*} var_args
*/
cljs.core.dissoc_BANG_ = (function() {
var dissoc_BANG_ = null;
var dissoc_BANG___2 = (function (tcoll,key){
return cljs.core._dissoc_BANG_(tcoll,key);
});
var dissoc_BANG___3 = (function() { 
var G__8312__delegate = function (tcoll,key,ks){
while(true){
var ntcoll = cljs.core._dissoc_BANG_(tcoll,key);
if(cljs.core.truth_(ks)){
var G__8313 = ntcoll;
var G__8314 = cljs.core.first(ks);
var G__8315 = cljs.core.next(ks);
tcoll = G__8313;
key = G__8314;
ks = G__8315;
continue;
} else {
return ntcoll;
}
break;
}
};
var G__8312 = function (tcoll,key,var_args){
var ks = null;
if (arguments.length > 2) {
var G__8316__i = 0, G__8316__a = new Array(arguments.length -  2);
while (G__8316__i < G__8316__a.length) {G__8316__a[G__8316__i] = arguments[G__8316__i + 2]; ++G__8316__i;}
  ks = new cljs.core.IndexedSeq(G__8316__a,0);
} 
return G__8312__delegate.call(this,tcoll,key,ks);};
G__8312.cljs$lang$maxFixedArity = 2;
G__8312.cljs$lang$applyTo = (function (arglist__8317){
var tcoll = cljs.core.first(arglist__8317);
arglist__8317 = cljs.core.next(arglist__8317);
var key = cljs.core.first(arglist__8317);
var ks = cljs.core.rest(arglist__8317);
return G__8312__delegate(tcoll,key,ks);
});
G__8312.cljs$core$IFn$_invoke$arity$variadic = G__8312__delegate;
return G__8312;
})()
;
dissoc_BANG_ = function(tcoll,key,var_args){
var ks = var_args;
switch(arguments.length){
case 2:
return dissoc_BANG___2.call(this,tcoll,key);
default:
var G__8318 = null;
if (arguments.length > 2) {
var G__8319__i = 0, G__8319__a = new Array(arguments.length -  2);
while (G__8319__i < G__8319__a.length) {G__8319__a[G__8319__i] = arguments[G__8319__i + 2]; ++G__8319__i;}
G__8318 = new cljs.core.IndexedSeq(G__8319__a,0);
}
return dissoc_BANG___3.cljs$core$IFn$_invoke$arity$variadic(tcoll,key, G__8318);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
dissoc_BANG_.cljs$lang$maxFixedArity = 2;
dissoc_BANG_.cljs$lang$applyTo = dissoc_BANG___3.cljs$lang$applyTo;
dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = dissoc_BANG___2;
dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = dissoc_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return dissoc_BANG_;
})()
;
/**
* Removes the last item from a transient vector. If
* the collection is empty, throws an exception. Returns coll
*/
cljs.core.pop_BANG_ = (function pop_BANG_(tcoll){
return cljs.core._pop_BANG_(tcoll);
});
/**
* disj[oin]. Returns a transient set of the same (hashed/sorted) type, that
* does not contain key(s).
* @param {...*} var_args
*/
cljs.core.disj_BANG_ = (function() {
var disj_BANG_ = null;
var disj_BANG___2 = (function (tcoll,val){
return cljs.core._disjoin_BANG_(tcoll,val);
});
var disj_BANG___3 = (function() { 
var G__8320__delegate = function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._disjoin_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__8321 = ntcoll;
var G__8322 = cljs.core.first(vals);
var G__8323 = cljs.core.next(vals);
tcoll = G__8321;
val = G__8322;
vals = G__8323;
continue;
} else {
return ntcoll;
}
break;
}
};
var G__8320 = function (tcoll,val,var_args){
var vals = null;
if (arguments.length > 2) {
var G__8324__i = 0, G__8324__a = new Array(arguments.length -  2);
while (G__8324__i < G__8324__a.length) {G__8324__a[G__8324__i] = arguments[G__8324__i + 2]; ++G__8324__i;}
  vals = new cljs.core.IndexedSeq(G__8324__a,0);
} 
return G__8320__delegate.call(this,tcoll,val,vals);};
G__8320.cljs$lang$maxFixedArity = 2;
G__8320.cljs$lang$applyTo = (function (arglist__8325){
var tcoll = cljs.core.first(arglist__8325);
arglist__8325 = cljs.core.next(arglist__8325);
var val = cljs.core.first(arglist__8325);
var vals = cljs.core.rest(arglist__8325);
return G__8320__delegate(tcoll,val,vals);
});
G__8320.cljs$core$IFn$_invoke$arity$variadic = G__8320__delegate;
return G__8320;
})()
;
disj_BANG_ = function(tcoll,val,var_args){
var vals = var_args;
switch(arguments.length){
case 2:
return disj_BANG___2.call(this,tcoll,val);
default:
var G__8326 = null;
if (arguments.length > 2) {
var G__8327__i = 0, G__8327__a = new Array(arguments.length -  2);
while (G__8327__i < G__8327__a.length) {G__8327__a[G__8327__i] = arguments[G__8327__i + 2]; ++G__8327__i;}
G__8326 = new cljs.core.IndexedSeq(G__8327__a,0);
}
return disj_BANG___3.cljs$core$IFn$_invoke$arity$variadic(tcoll,val, G__8326);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
disj_BANG_.cljs$lang$maxFixedArity = 2;
disj_BANG_.cljs$lang$applyTo = disj_BANG___3.cljs$lang$applyTo;
disj_BANG_.cljs$core$IFn$_invoke$arity$2 = disj_BANG___2;
disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = disj_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return disj_BANG_;
})()
;

cljs.core.apply_to = (function apply_to(f,argc,args){
var args__$1 = cljs.core.seq(args);
if((argc === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var a6033 = cljs.core._first(args__$1);
var args__$2 = cljs.core._rest(args__$1);
if((argc === (1))){
if(f.cljs$core$IFn$_invoke$arity$1){
return f.cljs$core$IFn$_invoke$arity$1(a6033);
} else {
var G__8538 = a6033;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8538) : f.call(null,G__8538));
}
} else {
var b6034 = cljs.core._first(args__$2);
var args__$3 = cljs.core._rest(args__$2);
if((argc === (2))){
if(f.cljs$core$IFn$_invoke$arity$2){
return f.cljs$core$IFn$_invoke$arity$2(a6033,b6034);
} else {
var G__8539 = a6033;
var G__8540 = b6034;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8539,G__8540) : f.call(null,G__8539,G__8540));
}
} else {
var c6035 = cljs.core._first(args__$3);
var args__$4 = cljs.core._rest(args__$3);
if((argc === (3))){
if(f.cljs$core$IFn$_invoke$arity$3){
return f.cljs$core$IFn$_invoke$arity$3(a6033,b6034,c6035);
} else {
var G__8541 = a6033;
var G__8542 = b6034;
var G__8543 = c6035;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8541,G__8542,G__8543) : f.call(null,G__8541,G__8542,G__8543));
}
} else {
var d6036 = cljs.core._first(args__$4);
var args__$5 = cljs.core._rest(args__$4);
if((argc === (4))){
if(f.cljs$core$IFn$_invoke$arity$4){
return f.cljs$core$IFn$_invoke$arity$4(a6033,b6034,c6035,d6036);
} else {
var G__8544 = a6033;
var G__8545 = b6034;
var G__8546 = c6035;
var G__8547 = d6036;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__8544,G__8545,G__8546,G__8547) : f.call(null,G__8544,G__8545,G__8546,G__8547));
}
} else {
var e6037 = cljs.core._first(args__$5);
var args__$6 = cljs.core._rest(args__$5);
if((argc === (5))){
if(f.cljs$core$IFn$_invoke$arity$5){
return f.cljs$core$IFn$_invoke$arity$5(a6033,b6034,c6035,d6036,e6037);
} else {
var G__8548 = a6033;
var G__8549 = b6034;
var G__8550 = c6035;
var G__8551 = d6036;
var G__8552 = e6037;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__8548,G__8549,G__8550,G__8551,G__8552) : f.call(null,G__8548,G__8549,G__8550,G__8551,G__8552));
}
} else {
var f6038 = cljs.core._first(args__$6);
var args__$7 = cljs.core._rest(args__$6);
if((argc === (6))){
if(f.cljs$core$IFn$_invoke$arity$6){
return f.cljs$core$IFn$_invoke$arity$6(a6033,b6034,c6035,d6036,e6037,f6038);
} else {
var G__8553 = a6033;
var G__8554 = b6034;
var G__8555 = c6035;
var G__8556 = d6036;
var G__8557 = e6037;
var G__8558 = f6038;
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__8553,G__8554,G__8555,G__8556,G__8557,G__8558) : f.call(null,G__8553,G__8554,G__8555,G__8556,G__8557,G__8558));
}
} else {
var g6039 = cljs.core._first(args__$7);
var args__$8 = cljs.core._rest(args__$7);
if((argc === (7))){
if(f.cljs$core$IFn$_invoke$arity$7){
return f.cljs$core$IFn$_invoke$arity$7(a6033,b6034,c6035,d6036,e6037,f6038,g6039);
} else {
var G__8559 = a6033;
var G__8560 = b6034;
var G__8561 = c6035;
var G__8562 = d6036;
var G__8563 = e6037;
var G__8564 = f6038;
var G__8565 = g6039;
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(G__8559,G__8560,G__8561,G__8562,G__8563,G__8564,G__8565) : f.call(null,G__8559,G__8560,G__8561,G__8562,G__8563,G__8564,G__8565));
}
} else {
var h6040 = cljs.core._first(args__$8);
var args__$9 = cljs.core._rest(args__$8);
if((argc === (8))){
if(f.cljs$core$IFn$_invoke$arity$8){
return f.cljs$core$IFn$_invoke$arity$8(a6033,b6034,c6035,d6036,e6037,f6038,g6039,h6040);
} else {
var G__8566 = a6033;
var G__8567 = b6034;
var G__8568 = c6035;
var G__8569 = d6036;
var G__8570 = e6037;
var G__8571 = f6038;
var G__8572 = g6039;
var G__8573 = h6040;
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(G__8566,G__8567,G__8568,G__8569,G__8570,G__8571,G__8572,G__8573) : f.call(null,G__8566,G__8567,G__8568,G__8569,G__8570,G__8571,G__8572,G__8573));
}
} else {
var i6041 = cljs.core._first(args__$9);
var args__$10 = cljs.core._rest(args__$9);
if((argc === (9))){
if(f.cljs$core$IFn$_invoke$arity$9){
return f.cljs$core$IFn$_invoke$arity$9(a6033,b6034,c6035,d6036,e6037,f6038,g6039,h6040,i6041);
} else {
var G__8574 = a6033;
var G__8575 = b6034;
var G__8576 = c6035;
var G__8577 = d6036;
var G__8578 = e6037;
var G__8579 = f6038;
var G__8580 = g6039;
var G__8581 = h6040;
var G__8582 = i6041;
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(G__8574,G__8575,G__8576,G__8577,G__8578,G__8579,G__8580,G__8581,G__8582) : f.call(null,G__8574,G__8575,G__8576,G__8577,G__8578,G__8579,G__8580,G__8581,G__8582));
}
} else {
var j6042 = cljs.core._first(args__$10);
var args__$11 = cljs.core._rest(args__$10);
if((argc === (10))){
if(f.cljs$core$IFn$_invoke$arity$10){
return f.cljs$core$IFn$_invoke$arity$10(a6033,b6034,c6035,d6036,e6037,f6038,g6039,h6040,i6041,j6042);
} else {
var G__8583 = a6033;
var G__8584 = b6034;
var G__8585 = c6035;
var G__8586 = d6036;
var G__8587 = e6037;
var G__8588 = f6038;
var G__8589 = g6039;
var G__8590 = h6040;
var G__8591 = i6041;
var G__8592 = j6042;
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(G__8583,G__8584,G__8585,G__8586,G__8587,G__8588,G__8589,G__8590,G__8591,G__8592) : f.call(null,G__8583,G__8584,G__8585,G__8586,G__8587,G__8588,G__8589,G__8590,G__8591,G__8592));
}
} else {
var k6043 = cljs.core._first(args__$11);
var args__$12 = cljs.core._rest(args__$11);
if((argc === (11))){
if(f.cljs$core$IFn$_invoke$arity$11){
return f.cljs$core$IFn$_invoke$arity$11(a6033,b6034,c6035,d6036,e6037,f6038,g6039,h6040,i6041,j6042,k6043);
} else {
var G__8593 = a6033;
var G__8594 = b6034;
var G__8595 = c6035;
var G__8596 = d6036;
var G__8597 = e6037;
var G__8598 = f6038;
var G__8599 = g6039;
var G__8600 = h6040;
var G__8601 = i6041;
var G__8602 = j6042;
var G__8603 = k6043;
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(G__8593,G__8594,G__8595,G__8596,G__8597,G__8598,G__8599,G__8600,G__8601,G__8602,G__8603) : f.call(null,G__8593,G__8594,G__8595,G__8596,G__8597,G__8598,G__8599,G__8600,G__8601,G__8602,G__8603));
}
} else {
var l6044 = cljs.core._first(args__$12);
var args__$13 = cljs.core._rest(args__$12);
if((argc === (12))){
if(f.cljs$core$IFn$_invoke$arity$12){
return f.cljs$core$IFn$_invoke$arity$12(a6033,b6034,c6035,d6036,e6037,f6038,g6039,h6040,i6041,j6042,k6043,l6044);
} else {
var G__8604 = a6033;
var G__8605 = b6034;
var G__8606 = c6035;
var G__8607 = d6036;
var G__8608 = e6037;
var G__8609 = f6038;
var G__8610 = g6039;
var G__8611 = h6040;
var G__8612 = i6041;
var G__8613 = j6042;
var G__8614 = k6043;
var G__8615 = l6044;
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(G__8604,G__8605,G__8606,G__8607,G__8608,G__8609,G__8610,G__8611,G__8612,G__8613,G__8614,G__8615) : f.call(null,G__8604,G__8605,G__8606,G__8607,G__8608,G__8609,G__8610,G__8611,G__8612,G__8613,G__8614,G__8615));
}
} else {
var m6045 = cljs.core._first(args__$13);
var args__$14 = cljs.core._rest(args__$13);
if((argc === (13))){
if(f.cljs$core$IFn$_invoke$arity$13){
return f.cljs$core$IFn$_invoke$arity$13(a6033,b6034,c6035,d6036,e6037,f6038,g6039,h6040,i6041,j6042,k6043,l6044,m6045);
} else {
var G__8616 = a6033;
var G__8617 = b6034;
var G__8618 = c6035;
var G__8619 = d6036;
var G__8620 = e6037;
var G__8621 = f6038;
var G__8622 = g6039;
var G__8623 = h6040;
var G__8624 = i6041;
var G__8625 = j6042;
var G__8626 = k6043;
var G__8627 = l6044;
var G__8628 = m6045;
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(G__8616,G__8617,G__8618,G__8619,G__8620,G__8621,G__8622,G__8623,G__8624,G__8625,G__8626,G__8627,G__8628) : f.call(null,G__8616,G__8617,G__8618,G__8619,G__8620,G__8621,G__8622,G__8623,G__8624,G__8625,G__8626,G__8627,G__8628));
}
} else {
var n6046 = cljs.core._first(args__$14);
var args__$15 = cljs.core._rest(args__$14);
if((argc === (14))){
if(f.cljs$core$IFn$_invoke$arity$14){
return f.cljs$core$IFn$_invoke$arity$14(a6033,b6034,c6035,d6036,e6037,f6038,g6039,h6040,i6041,j6042,k6043,l6044,m6045,n6046);
} else {
var G__8629 = a6033;
var G__8630 = b6034;
var G__8631 = c6035;
var G__8632 = d6036;
var G__8633 = e6037;
var G__8634 = f6038;
var G__8635 = g6039;
var G__8636 = h6040;
var G__8637 = i6041;
var G__8638 = j6042;
var G__8639 = k6043;
var G__8640 = l6044;
var G__8641 = m6045;
var G__8642 = n6046;
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(G__8629,G__8630,G__8631,G__8632,G__8633,G__8634,G__8635,G__8636,G__8637,G__8638,G__8639,G__8640,G__8641,G__8642) : f.call(null,G__8629,G__8630,G__8631,G__8632,G__8633,G__8634,G__8635,G__8636,G__8637,G__8638,G__8639,G__8640,G__8641,G__8642));
}
} else {
var o6047 = cljs.core._first(args__$15);
var args__$16 = cljs.core._rest(args__$15);
if((argc === (15))){
if(f.cljs$core$IFn$_invoke$arity$15){
return f.cljs$core$IFn$_invoke$arity$15(a6033,b6034,c6035,d6036,e6037,f6038,g6039,h6040,i6041,j6042,k6043,l6044,m6045,n6046,o6047);
} else {
var G__8643 = a6033;
var G__8644 = b6034;
var G__8645 = c6035;
var G__8646 = d6036;
var G__8647 = e6037;
var G__8648 = f6038;
var G__8649 = g6039;
var G__8650 = h6040;
var G__8651 = i6041;
var G__8652 = j6042;
var G__8653 = k6043;
var G__8654 = l6044;
var G__8655 = m6045;
var G__8656 = n6046;
var G__8657 = o6047;
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(G__8643,G__8644,G__8645,G__8646,G__8647,G__8648,G__8649,G__8650,G__8651,G__8652,G__8653,G__8654,G__8655,G__8656,G__8657) : f.call(null,G__8643,G__8644,G__8645,G__8646,G__8647,G__8648,G__8649,G__8650,G__8651,G__8652,G__8653,G__8654,G__8655,G__8656,G__8657));
}
} else {
var p6048 = cljs.core._first(args__$16);
var args__$17 = cljs.core._rest(args__$16);
if((argc === (16))){
if(f.cljs$core$IFn$_invoke$arity$16){
return f.cljs$core$IFn$_invoke$arity$16(a6033,b6034,c6035,d6036,e6037,f6038,g6039,h6040,i6041,j6042,k6043,l6044,m6045,n6046,o6047,p6048);
} else {
var G__8658 = a6033;
var G__8659 = b6034;
var G__8660 = c6035;
var G__8661 = d6036;
var G__8662 = e6037;
var G__8663 = f6038;
var G__8664 = g6039;
var G__8665 = h6040;
var G__8666 = i6041;
var G__8667 = j6042;
var G__8668 = k6043;
var G__8669 = l6044;
var G__8670 = m6045;
var G__8671 = n6046;
var G__8672 = o6047;
var G__8673 = p6048;
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(G__8658,G__8659,G__8660,G__8661,G__8662,G__8663,G__8664,G__8665,G__8666,G__8667,G__8668,G__8669,G__8670,G__8671,G__8672,G__8673) : f.call(null,G__8658,G__8659,G__8660,G__8661,G__8662,G__8663,G__8664,G__8665,G__8666,G__8667,G__8668,G__8669,G__8670,G__8671,G__8672,G__8673));
}
} else {
var q6049 = cljs.core._first(args__$17);
var args__$18 = cljs.core._rest(args__$17);
if((argc === (17))){
if(f.cljs$core$IFn$_invoke$arity$17){
return f.cljs$core$IFn$_invoke$arity$17(a6033,b6034,c6035,d6036,e6037,f6038,g6039,h6040,i6041,j6042,k6043,l6044,m6045,n6046,o6047,p6048,q6049);
} else {
var G__8674 = a6033;
var G__8675 = b6034;
var G__8676 = c6035;
var G__8677 = d6036;
var G__8678 = e6037;
var G__8679 = f6038;
var G__8680 = g6039;
var G__8681 = h6040;
var G__8682 = i6041;
var G__8683 = j6042;
var G__8684 = k6043;
var G__8685 = l6044;
var G__8686 = m6045;
var G__8687 = n6046;
var G__8688 = o6047;
var G__8689 = p6048;
var G__8690 = q6049;
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(G__8674,G__8675,G__8676,G__8677,G__8678,G__8679,G__8680,G__8681,G__8682,G__8683,G__8684,G__8685,G__8686,G__8687,G__8688,G__8689,G__8690) : f.call(null,G__8674,G__8675,G__8676,G__8677,G__8678,G__8679,G__8680,G__8681,G__8682,G__8683,G__8684,G__8685,G__8686,G__8687,G__8688,G__8689,G__8690));
}
} else {
var r6050 = cljs.core._first(args__$18);
var args__$19 = cljs.core._rest(args__$18);
if((argc === (18))){
if(f.cljs$core$IFn$_invoke$arity$18){
return f.cljs$core$IFn$_invoke$arity$18(a6033,b6034,c6035,d6036,e6037,f6038,g6039,h6040,i6041,j6042,k6043,l6044,m6045,n6046,o6047,p6048,q6049,r6050);
} else {
var G__8691 = a6033;
var G__8692 = b6034;
var G__8693 = c6035;
var G__8694 = d6036;
var G__8695 = e6037;
var G__8696 = f6038;
var G__8697 = g6039;
var G__8698 = h6040;
var G__8699 = i6041;
var G__8700 = j6042;
var G__8701 = k6043;
var G__8702 = l6044;
var G__8703 = m6045;
var G__8704 = n6046;
var G__8705 = o6047;
var G__8706 = p6048;
var G__8707 = q6049;
var G__8708 = r6050;
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(G__8691,G__8692,G__8693,G__8694,G__8695,G__8696,G__8697,G__8698,G__8699,G__8700,G__8701,G__8702,G__8703,G__8704,G__8705,G__8706,G__8707,G__8708) : f.call(null,G__8691,G__8692,G__8693,G__8694,G__8695,G__8696,G__8697,G__8698,G__8699,G__8700,G__8701,G__8702,G__8703,G__8704,G__8705,G__8706,G__8707,G__8708));
}
} else {
var s6051 = cljs.core._first(args__$19);
var args__$20 = cljs.core._rest(args__$19);
if((argc === (19))){
if(f.cljs$core$IFn$_invoke$arity$19){
return f.cljs$core$IFn$_invoke$arity$19(a6033,b6034,c6035,d6036,e6037,f6038,g6039,h6040,i6041,j6042,k6043,l6044,m6045,n6046,o6047,p6048,q6049,r6050,s6051);
} else {
var G__8709 = a6033;
var G__8710 = b6034;
var G__8711 = c6035;
var G__8712 = d6036;
var G__8713 = e6037;
var G__8714 = f6038;
var G__8715 = g6039;
var G__8716 = h6040;
var G__8717 = i6041;
var G__8718 = j6042;
var G__8719 = k6043;
var G__8720 = l6044;
var G__8721 = m6045;
var G__8722 = n6046;
var G__8723 = o6047;
var G__8724 = p6048;
var G__8725 = q6049;
var G__8726 = r6050;
var G__8727 = s6051;
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(G__8709,G__8710,G__8711,G__8712,G__8713,G__8714,G__8715,G__8716,G__8717,G__8718,G__8719,G__8720,G__8721,G__8722,G__8723,G__8724,G__8725,G__8726,G__8727) : f.call(null,G__8709,G__8710,G__8711,G__8712,G__8713,G__8714,G__8715,G__8716,G__8717,G__8718,G__8719,G__8720,G__8721,G__8722,G__8723,G__8724,G__8725,G__8726,G__8727));
}
} else {
var t6052 = cljs.core._first(args__$20);
var args__$21 = cljs.core._rest(args__$20);
if((argc === (20))){
if(f.cljs$core$IFn$_invoke$arity$20){
return f.cljs$core$IFn$_invoke$arity$20(a6033,b6034,c6035,d6036,e6037,f6038,g6039,h6040,i6041,j6042,k6043,l6044,m6045,n6046,o6047,p6048,q6049,r6050,s6051,t6052);
} else {
var G__8728 = a6033;
var G__8729 = b6034;
var G__8730 = c6035;
var G__8731 = d6036;
var G__8732 = e6037;
var G__8733 = f6038;
var G__8734 = g6039;
var G__8735 = h6040;
var G__8736 = i6041;
var G__8737 = j6042;
var G__8738 = k6043;
var G__8739 = l6044;
var G__8740 = m6045;
var G__8741 = n6046;
var G__8742 = o6047;
var G__8743 = p6048;
var G__8744 = q6049;
var G__8745 = r6050;
var G__8746 = s6051;
var G__8747 = t6052;
return (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(G__8728,G__8729,G__8730,G__8731,G__8732,G__8733,G__8734,G__8735,G__8736,G__8737,G__8738,G__8739,G__8740,G__8741,G__8742,G__8743,G__8744,G__8745,G__8746,G__8747) : f.call(null,G__8728,G__8729,G__8730,G__8731,G__8732,G__8733,G__8734,G__8735,G__8736,G__8737,G__8738,G__8739,G__8740,G__8741,G__8742,G__8743,G__8744,G__8745,G__8746,G__8747));
}
} else {
throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
* Applies fn f to the argument list formed by prepending intervening arguments to args.
* First cut.  Not lazy.  Needs to use emitted toApply.
* @param {...*} var_args
*/
cljs.core.apply = (function() {
var apply = null;
var apply__2 = (function (f,args){
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(args,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,args);
} else {
return f.cljs$lang$applyTo(args);
}
} else {
return f.apply(f,cljs.core.to_array(args));
}
});
var apply__3 = (function (f,x,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});
var apply__4 = (function (f,x,y,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});
var apply__5 = (function (f,x,y,z,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});
var apply__6 = (function() { 
var G__8748__delegate = function (f,a,b,c,d,args){
var arglist = cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(args)))));
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
};
var G__8748 = function (f,a,b,c,d,var_args){
var args = null;
if (arguments.length > 5) {
var G__8749__i = 0, G__8749__a = new Array(arguments.length -  5);
while (G__8749__i < G__8749__a.length) {G__8749__a[G__8749__i] = arguments[G__8749__i + 5]; ++G__8749__i;}
  args = new cljs.core.IndexedSeq(G__8749__a,0);
} 
return G__8748__delegate.call(this,f,a,b,c,d,args);};
G__8748.cljs$lang$maxFixedArity = 5;
G__8748.cljs$lang$applyTo = (function (arglist__8750){
var f = cljs.core.first(arglist__8750);
arglist__8750 = cljs.core.next(arglist__8750);
var a = cljs.core.first(arglist__8750);
arglist__8750 = cljs.core.next(arglist__8750);
var b = cljs.core.first(arglist__8750);
arglist__8750 = cljs.core.next(arglist__8750);
var c = cljs.core.first(arglist__8750);
arglist__8750 = cljs.core.next(arglist__8750);
var d = cljs.core.first(arglist__8750);
var args = cljs.core.rest(arglist__8750);
return G__8748__delegate(f,a,b,c,d,args);
});
G__8748.cljs$core$IFn$_invoke$arity$variadic = G__8748__delegate;
return G__8748;
})()
;
apply = function(f,a,b,c,d,var_args){
var args = var_args;
switch(arguments.length){
case 2:
return apply__2.call(this,f,a);
case 3:
return apply__3.call(this,f,a,b);
case 4:
return apply__4.call(this,f,a,b,c);
case 5:
return apply__5.call(this,f,a,b,c,d);
default:
var G__8751 = null;
if (arguments.length > 5) {
var G__8752__i = 0, G__8752__a = new Array(arguments.length -  5);
while (G__8752__i < G__8752__a.length) {G__8752__a[G__8752__i] = arguments[G__8752__i + 5]; ++G__8752__i;}
G__8751 = new cljs.core.IndexedSeq(G__8752__a,0);
}
return apply__6.cljs$core$IFn$_invoke$arity$variadic(f,a,b,c,d, G__8751);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
apply.cljs$lang$maxFixedArity = 5;
apply.cljs$lang$applyTo = apply__6.cljs$lang$applyTo;
apply.cljs$core$IFn$_invoke$arity$2 = apply__2;
apply.cljs$core$IFn$_invoke$arity$3 = apply__3;
apply.cljs$core$IFn$_invoke$arity$4 = apply__4;
apply.cljs$core$IFn$_invoke$arity$5 = apply__5;
apply.cljs$core$IFn$_invoke$arity$variadic = apply__6.cljs$core$IFn$_invoke$arity$variadic;
return apply;
})()
;
/**
* Returns an object of the same type and value as obj, with
* (apply f (meta obj) args) as its metadata.
* @param {...*} var_args
*/
cljs.core.vary_meta = (function() {
var vary_meta = null;
var vary_meta__2 = (function (obj,f){
return cljs.core.with_meta(obj,(function (){var G__8768 = cljs.core.meta(obj);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8768) : f.call(null,G__8768));
})());
});
var vary_meta__3 = (function (obj,f,a){
return cljs.core.with_meta(obj,(function (){var G__8769 = cljs.core.meta(obj);
var G__8770 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8769,G__8770) : f.call(null,G__8769,G__8770));
})());
});
var vary_meta__4 = (function (obj,f,a,b){
return cljs.core.with_meta(obj,(function (){var G__8771 = cljs.core.meta(obj);
var G__8772 = a;
var G__8773 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8771,G__8772,G__8773) : f.call(null,G__8771,G__8772,G__8773));
})());
});
var vary_meta__5 = (function (obj,f,a,b,c){
return cljs.core.with_meta(obj,(function (){var G__8774 = cljs.core.meta(obj);
var G__8775 = a;
var G__8776 = b;
var G__8777 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__8774,G__8775,G__8776,G__8777) : f.call(null,G__8774,G__8775,G__8776,G__8777));
})());
});
var vary_meta__6 = (function (obj,f,a,b,c,d){
return cljs.core.with_meta(obj,(function (){var G__8778 = cljs.core.meta(obj);
var G__8779 = a;
var G__8780 = b;
var G__8781 = c;
var G__8782 = d;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__8778,G__8779,G__8780,G__8781,G__8782) : f.call(null,G__8778,G__8779,G__8780,G__8781,G__8782));
})());
});
var vary_meta__7 = (function() { 
var G__8783__delegate = function (obj,f,a,b,c,d,args){
return cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.array_seq([d,args], 0)));
};
var G__8783 = function (obj,f,a,b,c,d,var_args){
var args = null;
if (arguments.length > 6) {
var G__8784__i = 0, G__8784__a = new Array(arguments.length -  6);
while (G__8784__i < G__8784__a.length) {G__8784__a[G__8784__i] = arguments[G__8784__i + 6]; ++G__8784__i;}
  args = new cljs.core.IndexedSeq(G__8784__a,0);
} 
return G__8783__delegate.call(this,obj,f,a,b,c,d,args);};
G__8783.cljs$lang$maxFixedArity = 6;
G__8783.cljs$lang$applyTo = (function (arglist__8785){
var obj = cljs.core.first(arglist__8785);
arglist__8785 = cljs.core.next(arglist__8785);
var f = cljs.core.first(arglist__8785);
arglist__8785 = cljs.core.next(arglist__8785);
var a = cljs.core.first(arglist__8785);
arglist__8785 = cljs.core.next(arglist__8785);
var b = cljs.core.first(arglist__8785);
arglist__8785 = cljs.core.next(arglist__8785);
var c = cljs.core.first(arglist__8785);
arglist__8785 = cljs.core.next(arglist__8785);
var d = cljs.core.first(arglist__8785);
var args = cljs.core.rest(arglist__8785);
return G__8783__delegate(obj,f,a,b,c,d,args);
});
G__8783.cljs$core$IFn$_invoke$arity$variadic = G__8783__delegate;
return G__8783;
})()
;
vary_meta = function(obj,f,a,b,c,d,var_args){
var args = var_args;
switch(arguments.length){
case 2:
return vary_meta__2.call(this,obj,f);
case 3:
return vary_meta__3.call(this,obj,f,a);
case 4:
return vary_meta__4.call(this,obj,f,a,b);
case 5:
return vary_meta__5.call(this,obj,f,a,b,c);
case 6:
return vary_meta__6.call(this,obj,f,a,b,c,d);
default:
var G__8786 = null;
if (arguments.length > 6) {
var G__8787__i = 0, G__8787__a = new Array(arguments.length -  6);
while (G__8787__i < G__8787__a.length) {G__8787__a[G__8787__i] = arguments[G__8787__i + 6]; ++G__8787__i;}
G__8786 = new cljs.core.IndexedSeq(G__8787__a,0);
}
return vary_meta__7.cljs$core$IFn$_invoke$arity$variadic(obj,f,a,b,c,d, G__8786);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
vary_meta.cljs$lang$maxFixedArity = 6;
vary_meta.cljs$lang$applyTo = vary_meta__7.cljs$lang$applyTo;
vary_meta.cljs$core$IFn$_invoke$arity$2 = vary_meta__2;
vary_meta.cljs$core$IFn$_invoke$arity$3 = vary_meta__3;
vary_meta.cljs$core$IFn$_invoke$arity$4 = vary_meta__4;
vary_meta.cljs$core$IFn$_invoke$arity$5 = vary_meta__5;
vary_meta.cljs$core$IFn$_invoke$arity$6 = vary_meta__6;
vary_meta.cljs$core$IFn$_invoke$arity$variadic = vary_meta__7.cljs$core$IFn$_invoke$arity$variadic;
return vary_meta;
})()
;
/**
* Same as (not (= obj1 obj2))
* @param {...*} var_args
*/
cljs.core.not_EQ_ = (function() {
var not_EQ_ = null;
var not_EQ___1 = (function (x){
return false;
});
var not_EQ___2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});
var not_EQ___3 = (function() { 
var G__8788__delegate = function (x,y,more){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more));
};
var G__8788 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8789__i = 0, G__8789__a = new Array(arguments.length -  2);
while (G__8789__i < G__8789__a.length) {G__8789__a[G__8789__i] = arguments[G__8789__i + 2]; ++G__8789__i;}
  more = new cljs.core.IndexedSeq(G__8789__a,0);
} 
return G__8788__delegate.call(this,x,y,more);};
G__8788.cljs$lang$maxFixedArity = 2;
G__8788.cljs$lang$applyTo = (function (arglist__8790){
var x = cljs.core.first(arglist__8790);
arglist__8790 = cljs.core.next(arglist__8790);
var y = cljs.core.first(arglist__8790);
var more = cljs.core.rest(arglist__8790);
return G__8788__delegate(x,y,more);
});
G__8788.cljs$core$IFn$_invoke$arity$variadic = G__8788__delegate;
return G__8788;
})()
;
not_EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return not_EQ___1.call(this,x);
case 2:
return not_EQ___2.call(this,x,y);
default:
var G__8791 = null;
if (arguments.length > 2) {
var G__8792__i = 0, G__8792__a = new Array(arguments.length -  2);
while (G__8792__i < G__8792__a.length) {G__8792__a[G__8792__i] = arguments[G__8792__i + 2]; ++G__8792__i;}
G__8791 = new cljs.core.IndexedSeq(G__8792__a,0);
}
return not_EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
not_EQ_.cljs$lang$maxFixedArity = 2;
not_EQ_.cljs$lang$applyTo = not_EQ___3.cljs$lang$applyTo;
not_EQ_.cljs$core$IFn$_invoke$arity$1 = not_EQ___1;
not_EQ_.cljs$core$IFn$_invoke$arity$2 = not_EQ___2;
not_EQ_.cljs$core$IFn$_invoke$arity$variadic = not_EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return not_EQ_;
})()
;
/**
* If coll is empty, returns nil, else coll
*/
cljs.core.not_empty = (function not_empty(coll){
if(cljs.core.seq(coll)){
return coll;
} else {
return null;
}
});
cljs.core.nil_iter = (function nil_iter(){
if(typeof cljs.core.t8796 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.t8796 = (function (nil_iter,meta8797){
this.nil_iter = nil_iter;
this.meta8797 = meta8797;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.t8796.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return false;
});

cljs.core.t8796.prototype.next = (function (){
var self__ = this;
var _ = this;
return (new Error("No such element"));
});

cljs.core.t8796.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.t8796.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_8798){
var self__ = this;
var _8798__$1 = this;
return self__.meta8797;
});

cljs.core.t8796.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_8798,meta8797__$1){
var self__ = this;
var _8798__$1 = this;
return (new cljs.core.t8796(self__.nil_iter,meta8797__$1));
});

cljs.core.t8796.cljs$lang$type = true;

cljs.core.t8796.cljs$lang$ctorStr = "cljs.core/t8796";

cljs.core.t8796.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/t8796");
});

cljs.core.__GT_t8796 = (function __GT_t8796(nil_iter__$1,meta8797){
return (new cljs.core.t8796(nil_iter__$1,meta8797));
});

}

return (new cljs.core.t8796(nil_iter,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.StringIter = (function (s,i){
this.s = s;
this.i = i;
})
cljs.core.StringIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.s.length);
});

cljs.core.StringIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.s.charAt(self__.i);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.StringIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.StringIter.cljs$lang$type = true;

cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter";

cljs.core.StringIter.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/StringIter");
});

cljs.core.__GT_StringIter = (function __GT_StringIter(s,i){
return (new cljs.core.StringIter(s,i));
});

cljs.core.string_iter = (function string_iter(x){
return (new cljs.core.StringIter(x,(0)));
});

/**
* @constructor
*/
cljs.core.ArrayIter = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.ArrayIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.ArrayIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.ArrayIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.ArrayIter.cljs$lang$type = true;

cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter";

cljs.core.ArrayIter.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/ArrayIter");
});

cljs.core.__GT_ArrayIter = (function __GT_ArrayIter(arr,i){
return (new cljs.core.ArrayIter(arr,i));
});

cljs.core.array_iter = (function array_iter(x){
return (new cljs.core.ArrayIter(x,(0)));
});
cljs.core.INIT = {};
cljs.core.START = {};

/**
* @constructor
*/
cljs.core.SeqIter = (function (_seq,_next){
this._seq = _seq;
this._next = _next;
})
cljs.core.SeqIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__._seq === cljs.core.INIT)){
self__._seq = cljs.core.START;

self__._next = cljs.core.seq(self__._next);
} else {
if((self__._seq === self__._next)){
self__._next = cljs.core.next(self__._seq);
} else {
}
}

return !((self__._next == null));
});

cljs.core.SeqIter.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(cljs.core.not(this$.hasNext())){
throw (new Error("No such element"));
} else {
self__._seq = self__._next;

return cljs.core.first(self__._next);
}
});

cljs.core.SeqIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.SeqIter.cljs$lang$type = true;

cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter";

cljs.core.SeqIter.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/SeqIter");
});

cljs.core.__GT_SeqIter = (function __GT_SeqIter(_seq,_next){
return (new cljs.core.SeqIter(_seq,_next));
});

cljs.core.seq_iter = (function seq_iter(coll){
return (new cljs.core.SeqIter(cljs.core.INIT,coll));
});
cljs.core.iter = (function iter(coll){
if((coll == null)){
return cljs.core.nil_iter();
} else {
if(typeof coll === 'string'){
return cljs.core.string_iter(coll);
} else {
if(Array.isArray(coll)){
return cljs.core.array_iter(coll);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core._iterator(coll);
} else {
if(cljs.core.seqable_QMARK_(coll)){
return cljs.core.seq_iter(coll);
} else {
throw (new Error([cljs.core.str("Cannot create iterator from "),cljs.core.str(coll)].join('')));

}
}
}
}
}
});
cljs.core.lazy_transformer = (function lazy_transformer(stepper){
return (new cljs.core.LazyTransformer(stepper,null,null,null));
});

/**
* @constructor
*/
cljs.core.Stepper = (function (xform,iter){
this.xform = xform;
this.iter = iter;
})
cljs.core.Stepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__5090__auto__ = !((lt.stepper == null));
if(and__5090__auto__){
return self__.iter.hasNext();
} else {
return and__5090__auto__;
}
})())){
if(cljs.core.reduced_QMARK_((function (){var G__8799 = lt;
var G__8800 = self__.iter.next();
return (self__.xform.cljs$core$IFn$_invoke$arity$2 ? self__.xform.cljs$core$IFn$_invoke$arity$2(G__8799,G__8800) : self__.xform.call(null,G__8799,G__8800));
})())){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
var G__8801 = lt;
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__8801) : self__.xform.call(null,G__8801));
}
});

cljs.core.Stepper.cljs$lang$type = true;

cljs.core.Stepper.cljs$lang$ctorStr = "cljs.core/Stepper";

cljs.core.Stepper.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/Stepper");
});

cljs.core.__GT_Stepper = (function __GT_Stepper(xform,iter){
return (new cljs.core.Stepper(xform,iter));
});

cljs.core.stepper = (function stepper(xform,iter){
var stepfn = (function() {
var stepfn = null;
var stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return result;
});
var stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
stepfn = function(result,input){
switch(arguments.length){
case 1:
return stepfn__1.call(this,result);
case 2:
return stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
stepfn.cljs$core$IFn$_invoke$arity$1 = stepfn__1;
stepfn.cljs$core$IFn$_invoke$arity$2 = stepfn__2;
return stepfn;
})()
;
return (new cljs.core.Stepper((function (){var G__8803 = stepfn;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__8803) : xform.call(null,G__8803));
})(),iter));
});

/**
* @constructor
*/
cljs.core.MultiStepper = (function (xform,iters,nexts){
this.xform = xform;
this.iters = iters;
this.nexts = nexts;
})
cljs.core.MultiStepper.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var iters__$1 = cljs.core.seq(self__.iters);
while(true){
if(!((iters__$1 == null))){
var iter = cljs.core.first(iters__$1);
if(cljs.core.not(iter.hasNext())){
return false;
} else {
var G__8805 = cljs.core.next(iters__$1);
iters__$1 = G__8805;
continue;
}
} else {
return true;
}
break;
}
});

cljs.core.MultiStepper.prototype.next = (function (){
var self__ = this;
var _ = this;
var n__5989__auto___8806 = self__.iters.length;
var i_8807 = (0);
while(true){
if((i_8807 < n__5989__auto___8806)){
(self__.nexts[i_8807] = (self__.iters[i_8807]).next());

var G__8808 = (i_8807 + (1));
i_8807 = G__8808;
continue;
} else {
}
break;
}

return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(self__.nexts,(0));
});

cljs.core.MultiStepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__5090__auto__ = !((lt.stepper == null));
if(and__5090__auto__){
return this$.hasNext();
} else {
return and__5090__auto__;
}
})())){
if(cljs.core.reduced_QMARK_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xform,cljs.core.cons(lt,this$.next())))){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
var G__8804 = lt;
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__8804) : self__.xform.call(null,G__8804));
}
});

cljs.core.MultiStepper.cljs$lang$type = true;

cljs.core.MultiStepper.cljs$lang$ctorStr = "cljs.core/MultiStepper";

cljs.core.MultiStepper.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/MultiStepper");
});

cljs.core.__GT_MultiStepper = (function __GT_MultiStepper(xform,iters,nexts){
return (new cljs.core.MultiStepper(xform,iters,nexts));
});

cljs.core.multi_stepper = (function() {
var multi_stepper = null;
var multi_stepper__2 = (function (xform,iters){
return multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length)));
});
var multi_stepper__3 = (function (xform,iters,nexts){
var stepfn = (function() {
var stepfn = null;
var stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return lt;
});
var stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
stepfn = function(result,input){
switch(arguments.length){
case 1:
return stepfn__1.call(this,result);
case 2:
return stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
stepfn.cljs$core$IFn$_invoke$arity$1 = stepfn__1;
stepfn.cljs$core$IFn$_invoke$arity$2 = stepfn__2;
return stepfn;
})()
;
return (new cljs.core.MultiStepper((function (){var G__8813 = stepfn;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__8813) : xform.call(null,G__8813));
})(),iters,nexts));
});
multi_stepper = function(xform,iters,nexts){
switch(arguments.length){
case 2:
return multi_stepper__2.call(this,xform,iters);
case 3:
return multi_stepper__3.call(this,xform,iters,nexts);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
multi_stepper.cljs$core$IFn$_invoke$arity$2 = multi_stepper__2;
multi_stepper.cljs$core$IFn$_invoke$arity$3 = multi_stepper__3;
return multi_stepper;
})()
;

/**
* @constructor
*/
cljs.core.LazyTransformer = (function (stepper,first,rest,meta){
this.stepper = stepper;
this.first = first;
this.rest = rest;
this.meta = meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 31719628;
})
cljs.core.LazyTransformer.prototype.cljs$core$INext$_next$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return cljs.core._seq(self__.rest);
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return self__.first;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
self__.stepper.step(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return this$__$1;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.hash_ordered_coll(this$__$1);
});

cljs.core.LazyTransformer.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
var s = cljs.core._seq(this$__$1);
if(!((s == null))){
return cljs.core.equiv_sequential(this$__$1,other);
} else {
return (cljs.core.sequential_QMARK_(other)) && ((cljs.core.seq(other) == null));
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.LazyTransformer.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,cljs.core._seq(this$__$1));
});

cljs.core.LazyTransformer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,new_meta){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.LazyTransformer(self__.stepper,self__.first,self__.rest,new_meta));
});

cljs.core.LazyTransformer.cljs$lang$type = true;

cljs.core.LazyTransformer.cljs$lang$ctorStr = "cljs.core/LazyTransformer";

cljs.core.LazyTransformer.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/LazyTransformer");
});

cljs.core.__GT_LazyTransformer = (function __GT_LazyTransformer(stepper,first,rest,meta){
return (new cljs.core.LazyTransformer(stepper,first,rest,meta));
});

(cljs.core.LazyTransformer.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));
cljs.core.LazyTransformer.create = (function (xform,coll){
return (new cljs.core.LazyTransformer(cljs.core.stepper(xform,cljs.core.iter(coll)),null,null,null));
});
cljs.core.LazyTransformer.createMulti = (function (xform,colls){
var iters = [];
var seq__8814_8818 = cljs.core.seq(colls);
var chunk__8815_8819 = null;
var count__8816_8820 = (0);
var i__8817_8821 = (0);
while(true){
if((i__8817_8821 < count__8816_8820)){
var coll_8822 = chunk__8815_8819.cljs$core$IIndexed$_nth$arity$2(null,i__8817_8821);
iters.push(cljs.core.iter(coll_8822));

var G__8823 = seq__8814_8818;
var G__8824 = chunk__8815_8819;
var G__8825 = count__8816_8820;
var G__8826 = (i__8817_8821 + (1));
seq__8814_8818 = G__8823;
chunk__8815_8819 = G__8824;
count__8816_8820 = G__8825;
i__8817_8821 = G__8826;
continue;
} else {
var temp__4126__auto___8827 = cljs.core.seq(seq__8814_8818);
if(temp__4126__auto___8827){
var seq__8814_8828__$1 = temp__4126__auto___8827;
if(cljs.core.chunked_seq_QMARK_(seq__8814_8828__$1)){
var c__5889__auto___8829 = cljs.core.chunk_first(seq__8814_8828__$1);
var G__8830 = cljs.core.chunk_rest(seq__8814_8828__$1);
var G__8831 = c__5889__auto___8829;
var G__8832 = cljs.core.count(c__5889__auto___8829);
var G__8833 = (0);
seq__8814_8818 = G__8830;
chunk__8815_8819 = G__8831;
count__8816_8820 = G__8832;
i__8817_8821 = G__8833;
continue;
} else {
var coll_8834 = cljs.core.first(seq__8814_8828__$1);
iters.push(cljs.core.iter(coll_8834));

var G__8835 = cljs.core.next(seq__8814_8828__$1);
var G__8836 = null;
var G__8837 = (0);
var G__8838 = (0);
seq__8814_8818 = G__8835;
chunk__8815_8819 = G__8836;
count__8816_8820 = G__8837;
i__8817_8821 = G__8838;
continue;
}
} else {
}
}
break;
}

return (new cljs.core.LazyTransformer(cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length))),null,null,null));
});
/**
* Coerces coll to a (possibly empty) sequence, if it is not already
* one. Will not force a lazy seq. (sequence nil) yields (), When a
* transducer is supplied, returns a lazy sequence of applications of
* the transform to the items in coll(s), i.e. to the set of first
* items of each coll, followed by the set of second
* items in each coll, until any one of the colls is exhausted.  Any
* remaining items in other colls are ignored. The transform should accept
* number-of-colls arguments
* @param {...*} var_args
*/
cljs.core.sequence = (function() {
var sequence = null;
var sequence__1 = (function (coll){
if(cljs.core.seq_QMARK_(coll)){
return coll;
} else {
var or__5102__auto__ = cljs.core.seq(coll);
if(or__5102__auto__){
return or__5102__auto__;
} else {
return cljs.core.List.EMPTY;
}
}
});
var sequence__2 = (function (xform,coll){
return cljs.core.LazyTransformer.create(xform,coll);
});
var sequence__3 = (function() { 
var G__8839__delegate = function (xform,coll,colls){
return cljs.core.LazyTransformer.createMulti(xform,cljs.core.to_array(cljs.core.cons(coll,colls)));
};
var G__8839 = function (xform,coll,var_args){
var colls = null;
if (arguments.length > 2) {
var G__8840__i = 0, G__8840__a = new Array(arguments.length -  2);
while (G__8840__i < G__8840__a.length) {G__8840__a[G__8840__i] = arguments[G__8840__i + 2]; ++G__8840__i;}
  colls = new cljs.core.IndexedSeq(G__8840__a,0);
} 
return G__8839__delegate.call(this,xform,coll,colls);};
G__8839.cljs$lang$maxFixedArity = 2;
G__8839.cljs$lang$applyTo = (function (arglist__8841){
var xform = cljs.core.first(arglist__8841);
arglist__8841 = cljs.core.next(arglist__8841);
var coll = cljs.core.first(arglist__8841);
var colls = cljs.core.rest(arglist__8841);
return G__8839__delegate(xform,coll,colls);
});
G__8839.cljs$core$IFn$_invoke$arity$variadic = G__8839__delegate;
return G__8839;
})()
;
sequence = function(xform,coll,var_args){
var colls = var_args;
switch(arguments.length){
case 1:
return sequence__1.call(this,xform);
case 2:
return sequence__2.call(this,xform,coll);
default:
var G__8842 = null;
if (arguments.length > 2) {
var G__8843__i = 0, G__8843__a = new Array(arguments.length -  2);
while (G__8843__i < G__8843__a.length) {G__8843__a[G__8843__i] = arguments[G__8843__i + 2]; ++G__8843__i;}
G__8842 = new cljs.core.IndexedSeq(G__8843__a,0);
}
return sequence__3.cljs$core$IFn$_invoke$arity$variadic(xform,coll, G__8842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sequence.cljs$lang$maxFixedArity = 2;
sequence.cljs$lang$applyTo = sequence__3.cljs$lang$applyTo;
sequence.cljs$core$IFn$_invoke$arity$1 = sequence__1;
sequence.cljs$core$IFn$_invoke$arity$2 = sequence__2;
sequence.cljs$core$IFn$_invoke$arity$variadic = sequence__3.cljs$core$IFn$_invoke$arity$variadic;
return sequence;
})()
;
/**
* Returns true if (pred x) is logical true for every x in coll, else
* false.
*/
cljs.core.every_QMARK_ = (function every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq(coll) == null)){
return true;
} else {
if(cljs.core.truth_((function (){var G__8845 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8845) : pred.call(null,G__8845));
})())){
var G__8846 = pred;
var G__8847 = cljs.core.next(coll);
pred = G__8846;
coll = G__8847;
continue;
} else {
return false;

}
}
break;
}
});
/**
* Returns false if (pred x) is logical true for every x in
* coll, else true.
*/
cljs.core.not_every_QMARK_ = (function not_every_QMARK_(pred,coll){
return !(cljs.core.every_QMARK_(pred,coll));
});
/**
* Returns the first logical true value of (pred x) for any x in coll,
* else nil.  One common idiom is to use a set as pred, for example
* this will return :fred if :fred is in the sequence, otherwise nil:
* (some #{:fred} coll)
*/
cljs.core.some = (function some(pred,coll){
while(true){
if(cljs.core.seq(coll)){
var or__5102__auto__ = (function (){var G__8851 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8851) : pred.call(null,G__8851));
})();
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
var G__8852 = pred;
var G__8853 = cljs.core.next(coll);
pred = G__8852;
coll = G__8853;
continue;
}
} else {
return null;
}
break;
}
});
/**
* Returns false if (pred x) is logical true for any x in coll,
* else true.
*/
cljs.core.not_any_QMARK_ = (function not_any_QMARK_(pred,coll){
return cljs.core.not(cljs.core.some(pred,coll));
});
/**
* Returns true if n is even, throws an exception if n is not an integer
*/
cljs.core.even_QMARK_ = (function even_QMARK_(n){
if(cljs.core.integer_QMARK_(n)){
return ((n & (1)) === (0));
} else {
throw (new Error([cljs.core.str("Argument must be an integer: "),cljs.core.str(n)].join('')));
}
});
/**
* Returns true if n is odd, throws an exception if n is not an integer
*/
cljs.core.odd_QMARK_ = (function odd_QMARK_(n){
return !(cljs.core.even_QMARK_(n));
});
/**
* Takes a fn f and returns a fn that takes the same arguments as f,
* has the same effects, if any, and returns the opposite truth value.
*/
cljs.core.complement = (function complement(f){
return (function() {
var G__8860 = null;
var G__8860__0 = (function (){
return cljs.core.not((function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})());
});
var G__8860__1 = (function (x){
return cljs.core.not((function (){var G__8857 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8857) : f.call(null,G__8857));
})());
});
var G__8860__2 = (function (x,y){
return cljs.core.not((function (){var G__8858 = x;
var G__8859 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8858,G__8859) : f.call(null,G__8858,G__8859));
})());
});
var G__8860__3 = (function() { 
var G__8861__delegate = function (x,y,zs){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs));
};
var G__8861 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__8862__i = 0, G__8862__a = new Array(arguments.length -  2);
while (G__8862__i < G__8862__a.length) {G__8862__a[G__8862__i] = arguments[G__8862__i + 2]; ++G__8862__i;}
  zs = new cljs.core.IndexedSeq(G__8862__a,0);
} 
return G__8861__delegate.call(this,x,y,zs);};
G__8861.cljs$lang$maxFixedArity = 2;
G__8861.cljs$lang$applyTo = (function (arglist__8863){
var x = cljs.core.first(arglist__8863);
arglist__8863 = cljs.core.next(arglist__8863);
var y = cljs.core.first(arglist__8863);
var zs = cljs.core.rest(arglist__8863);
return G__8861__delegate(x,y,zs);
});
G__8861.cljs$core$IFn$_invoke$arity$variadic = G__8861__delegate;
return G__8861;
})()
;
G__8860 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return G__8860__0.call(this);
case 1:
return G__8860__1.call(this,x);
case 2:
return G__8860__2.call(this,x,y);
default:
var G__8864 = null;
if (arguments.length > 2) {
var G__8865__i = 0, G__8865__a = new Array(arguments.length -  2);
while (G__8865__i < G__8865__a.length) {G__8865__a[G__8865__i] = arguments[G__8865__i + 2]; ++G__8865__i;}
G__8864 = new cljs.core.IndexedSeq(G__8865__a,0);
}
return G__8860__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8860.cljs$lang$maxFixedArity = 2;
G__8860.cljs$lang$applyTo = G__8860__3.cljs$lang$applyTo;
G__8860.cljs$core$IFn$_invoke$arity$0 = G__8860__0;
G__8860.cljs$core$IFn$_invoke$arity$1 = G__8860__1;
G__8860.cljs$core$IFn$_invoke$arity$2 = G__8860__2;
G__8860.cljs$core$IFn$_invoke$arity$variadic = G__8860__3.cljs$core$IFn$_invoke$arity$variadic;
return G__8860;
})()
});
/**
* Returns a function that takes any number of arguments and returns x.
*/
cljs.core.constantly = (function constantly(x){
return (function() { 
var G__8866__delegate = function (args){
return x;
};
var G__8866 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__8867__i = 0, G__8867__a = new Array(arguments.length -  0);
while (G__8867__i < G__8867__a.length) {G__8867__a[G__8867__i] = arguments[G__8867__i + 0]; ++G__8867__i;}
  args = new cljs.core.IndexedSeq(G__8867__a,0);
} 
return G__8866__delegate.call(this,args);};
G__8866.cljs$lang$maxFixedArity = 0;
G__8866.cljs$lang$applyTo = (function (arglist__8868){
var args = cljs.core.seq(arglist__8868);
return G__8866__delegate(args);
});
G__8866.cljs$core$IFn$_invoke$arity$variadic = G__8866__delegate;
return G__8866;
})()
;
});
/**
* Takes a set of functions and returns a fn that is the composition
* of those fns.  The returned fn takes a variable number of args,
* applies the rightmost of fns to the args, the next
* fn (right-to-left) to the result, etc.
* @param {...*} var_args
*/
cljs.core.comp = (function() {
var comp = null;
var comp__0 = (function (){
return cljs.core.identity;
});
var comp__1 = (function (f){
return f;
});
var comp__2 = (function (f,g){
return (function() {
var G__8923 = null;
var G__8923__0 = (function (){
var G__8896 = (function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8896) : f.call(null,G__8896));
});
var G__8923__1 = (function (x){
var G__8897 = (function (){var G__8898 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__8898) : g.call(null,G__8898));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8897) : f.call(null,G__8897));
});
var G__8923__2 = (function (x,y){
var G__8899 = (function (){var G__8900 = x;
var G__8901 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__8900,G__8901) : g.call(null,G__8900,G__8901));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8899) : f.call(null,G__8899));
});
var G__8923__3 = (function (x,y,z){
var G__8902 = (function (){var G__8903 = x;
var G__8904 = y;
var G__8905 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__8903,G__8904,G__8905) : g.call(null,G__8903,G__8904,G__8905));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8902) : f.call(null,G__8902));
});
var G__8923__4 = (function() { 
var G__8924__delegate = function (x,y,z,args){
var G__8906 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8906) : f.call(null,G__8906));
};
var G__8924 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8925__i = 0, G__8925__a = new Array(arguments.length -  3);
while (G__8925__i < G__8925__a.length) {G__8925__a[G__8925__i] = arguments[G__8925__i + 3]; ++G__8925__i;}
  args = new cljs.core.IndexedSeq(G__8925__a,0);
} 
return G__8924__delegate.call(this,x,y,z,args);};
G__8924.cljs$lang$maxFixedArity = 3;
G__8924.cljs$lang$applyTo = (function (arglist__8926){
var x = cljs.core.first(arglist__8926);
arglist__8926 = cljs.core.next(arglist__8926);
var y = cljs.core.first(arglist__8926);
arglist__8926 = cljs.core.next(arglist__8926);
var z = cljs.core.first(arglist__8926);
var args = cljs.core.rest(arglist__8926);
return G__8924__delegate(x,y,z,args);
});
G__8924.cljs$core$IFn$_invoke$arity$variadic = G__8924__delegate;
return G__8924;
})()
;
G__8923 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__8923__0.call(this);
case 1:
return G__8923__1.call(this,x);
case 2:
return G__8923__2.call(this,x,y);
case 3:
return G__8923__3.call(this,x,y,z);
default:
var G__8927 = null;
if (arguments.length > 3) {
var G__8928__i = 0, G__8928__a = new Array(arguments.length -  3);
while (G__8928__i < G__8928__a.length) {G__8928__a[G__8928__i] = arguments[G__8928__i + 3]; ++G__8928__i;}
G__8927 = new cljs.core.IndexedSeq(G__8928__a,0);
}
return G__8923__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8923.cljs$lang$maxFixedArity = 3;
G__8923.cljs$lang$applyTo = G__8923__4.cljs$lang$applyTo;
G__8923.cljs$core$IFn$_invoke$arity$0 = G__8923__0;
G__8923.cljs$core$IFn$_invoke$arity$1 = G__8923__1;
G__8923.cljs$core$IFn$_invoke$arity$2 = G__8923__2;
G__8923.cljs$core$IFn$_invoke$arity$3 = G__8923__3;
G__8923.cljs$core$IFn$_invoke$arity$variadic = G__8923__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8923;
})()
});
var comp__3 = (function (f,g,h){
return (function() {
var G__8929 = null;
var G__8929__0 = (function (){
var G__8907 = (function (){var G__8908 = (function (){return (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__8908) : g.call(null,G__8908));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8907) : f.call(null,G__8907));
});
var G__8929__1 = (function (x){
var G__8909 = (function (){var G__8910 = (function (){var G__8911 = x;
return (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(G__8911) : h.call(null,G__8911));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__8910) : g.call(null,G__8910));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8909) : f.call(null,G__8909));
});
var G__8929__2 = (function (x,y){
var G__8912 = (function (){var G__8913 = (function (){var G__8914 = x;
var G__8915 = y;
return (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(G__8914,G__8915) : h.call(null,G__8914,G__8915));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__8913) : g.call(null,G__8913));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8912) : f.call(null,G__8912));
});
var G__8929__3 = (function (x,y,z){
var G__8916 = (function (){var G__8917 = (function (){var G__8918 = x;
var G__8919 = y;
var G__8920 = z;
return (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(G__8918,G__8919,G__8920) : h.call(null,G__8918,G__8919,G__8920));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__8917) : g.call(null,G__8917));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8916) : f.call(null,G__8916));
});
var G__8929__4 = (function() { 
var G__8930__delegate = function (x,y,z,args){
var G__8921 = (function (){var G__8922 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__8922) : g.call(null,G__8922));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8921) : f.call(null,G__8921));
};
var G__8930 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8931__i = 0, G__8931__a = new Array(arguments.length -  3);
while (G__8931__i < G__8931__a.length) {G__8931__a[G__8931__i] = arguments[G__8931__i + 3]; ++G__8931__i;}
  args = new cljs.core.IndexedSeq(G__8931__a,0);
} 
return G__8930__delegate.call(this,x,y,z,args);};
G__8930.cljs$lang$maxFixedArity = 3;
G__8930.cljs$lang$applyTo = (function (arglist__8932){
var x = cljs.core.first(arglist__8932);
arglist__8932 = cljs.core.next(arglist__8932);
var y = cljs.core.first(arglist__8932);
arglist__8932 = cljs.core.next(arglist__8932);
var z = cljs.core.first(arglist__8932);
var args = cljs.core.rest(arglist__8932);
return G__8930__delegate(x,y,z,args);
});
G__8930.cljs$core$IFn$_invoke$arity$variadic = G__8930__delegate;
return G__8930;
})()
;
G__8929 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__8929__0.call(this);
case 1:
return G__8929__1.call(this,x);
case 2:
return G__8929__2.call(this,x,y);
case 3:
return G__8929__3.call(this,x,y,z);
default:
var G__8933 = null;
if (arguments.length > 3) {
var G__8934__i = 0, G__8934__a = new Array(arguments.length -  3);
while (G__8934__i < G__8934__a.length) {G__8934__a[G__8934__i] = arguments[G__8934__i + 3]; ++G__8934__i;}
G__8933 = new cljs.core.IndexedSeq(G__8934__a,0);
}
return G__8929__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8933);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8929.cljs$lang$maxFixedArity = 3;
G__8929.cljs$lang$applyTo = G__8929__4.cljs$lang$applyTo;
G__8929.cljs$core$IFn$_invoke$arity$0 = G__8929__0;
G__8929.cljs$core$IFn$_invoke$arity$1 = G__8929__1;
G__8929.cljs$core$IFn$_invoke$arity$2 = G__8929__2;
G__8929.cljs$core$IFn$_invoke$arity$3 = G__8929__3;
G__8929.cljs$core$IFn$_invoke$arity$variadic = G__8929__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8929;
})()
});
var comp__4 = (function() { 
var G__8935__delegate = function (f1,f2,f3,fs){
var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));
return ((function (fs__$1){
return (function() { 
var G__8936__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);
var fs__$2 = cljs.core.next(fs__$1);
while(true){
if(fs__$2){
var G__8937 = cljs.core.first(fs__$2).call(null,ret);
var G__8938 = cljs.core.next(fs__$2);
ret = G__8937;
fs__$2 = G__8938;
continue;
} else {
return ret;
}
break;
}
};
var G__8936 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__8939__i = 0, G__8939__a = new Array(arguments.length -  0);
while (G__8939__i < G__8939__a.length) {G__8939__a[G__8939__i] = arguments[G__8939__i + 0]; ++G__8939__i;}
  args = new cljs.core.IndexedSeq(G__8939__a,0);
} 
return G__8936__delegate.call(this,args);};
G__8936.cljs$lang$maxFixedArity = 0;
G__8936.cljs$lang$applyTo = (function (arglist__8940){
var args = cljs.core.seq(arglist__8940);
return G__8936__delegate(args);
});
G__8936.cljs$core$IFn$_invoke$arity$variadic = G__8936__delegate;
return G__8936;
})()
;
;})(fs__$1))
};
var G__8935 = function (f1,f2,f3,var_args){
var fs = null;
if (arguments.length > 3) {
var G__8941__i = 0, G__8941__a = new Array(arguments.length -  3);
while (G__8941__i < G__8941__a.length) {G__8941__a[G__8941__i] = arguments[G__8941__i + 3]; ++G__8941__i;}
  fs = new cljs.core.IndexedSeq(G__8941__a,0);
} 
return G__8935__delegate.call(this,f1,f2,f3,fs);};
G__8935.cljs$lang$maxFixedArity = 3;
G__8935.cljs$lang$applyTo = (function (arglist__8942){
var f1 = cljs.core.first(arglist__8942);
arglist__8942 = cljs.core.next(arglist__8942);
var f2 = cljs.core.first(arglist__8942);
arglist__8942 = cljs.core.next(arglist__8942);
var f3 = cljs.core.first(arglist__8942);
var fs = cljs.core.rest(arglist__8942);
return G__8935__delegate(f1,f2,f3,fs);
});
G__8935.cljs$core$IFn$_invoke$arity$variadic = G__8935__delegate;
return G__8935;
})()
;
comp = function(f1,f2,f3,var_args){
var fs = var_args;
switch(arguments.length){
case 0:
return comp__0.call(this);
case 1:
return comp__1.call(this,f1);
case 2:
return comp__2.call(this,f1,f2);
case 3:
return comp__3.call(this,f1,f2,f3);
default:
var G__8943 = null;
if (arguments.length > 3) {
var G__8944__i = 0, G__8944__a = new Array(arguments.length -  3);
while (G__8944__i < G__8944__a.length) {G__8944__a[G__8944__i] = arguments[G__8944__i + 3]; ++G__8944__i;}
G__8943 = new cljs.core.IndexedSeq(G__8944__a,0);
}
return comp__4.cljs$core$IFn$_invoke$arity$variadic(f1,f2,f3, G__8943);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
comp.cljs$lang$maxFixedArity = 3;
comp.cljs$lang$applyTo = comp__4.cljs$lang$applyTo;
comp.cljs$core$IFn$_invoke$arity$0 = comp__0;
comp.cljs$core$IFn$_invoke$arity$1 = comp__1;
comp.cljs$core$IFn$_invoke$arity$2 = comp__2;
comp.cljs$core$IFn$_invoke$arity$3 = comp__3;
comp.cljs$core$IFn$_invoke$arity$variadic = comp__4.cljs$core$IFn$_invoke$arity$variadic;
return comp;
})()
;
/**
* Takes a function f and fewer than the normal arguments to f, and
* returns a fn that takes a variable number of additional args. When
* called, the returned function calls f with args + additional args.
* @param {...*} var_args
*/
cljs.core.partial = (function() {
var partial = null;
var partial__1 = (function (f){
return f;
});
var partial__2 = (function (f,arg1){
return (function() {
var G__9029 = null;
var G__9029__0 = (function (){
var G__8987 = arg1;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8987) : f.call(null,G__8987));
});
var G__9029__1 = (function (x){
var G__8988 = arg1;
var G__8989 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8988,G__8989) : f.call(null,G__8988,G__8989));
});
var G__9029__2 = (function (x,y){
var G__8990 = arg1;
var G__8991 = x;
var G__8992 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8990,G__8991,G__8992) : f.call(null,G__8990,G__8991,G__8992));
});
var G__9029__3 = (function (x,y,z){
var G__8993 = arg1;
var G__8994 = x;
var G__8995 = y;
var G__8996 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__8993,G__8994,G__8995,G__8996) : f.call(null,G__8993,G__8994,G__8995,G__8996));
});
var G__9029__4 = (function() { 
var G__9030__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.array_seq([args], 0));
};
var G__9030 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9031__i = 0, G__9031__a = new Array(arguments.length -  3);
while (G__9031__i < G__9031__a.length) {G__9031__a[G__9031__i] = arguments[G__9031__i + 3]; ++G__9031__i;}
  args = new cljs.core.IndexedSeq(G__9031__a,0);
} 
return G__9030__delegate.call(this,x,y,z,args);};
G__9030.cljs$lang$maxFixedArity = 3;
G__9030.cljs$lang$applyTo = (function (arglist__9032){
var x = cljs.core.first(arglist__9032);
arglist__9032 = cljs.core.next(arglist__9032);
var y = cljs.core.first(arglist__9032);
arglist__9032 = cljs.core.next(arglist__9032);
var z = cljs.core.first(arglist__9032);
var args = cljs.core.rest(arglist__9032);
return G__9030__delegate(x,y,z,args);
});
G__9030.cljs$core$IFn$_invoke$arity$variadic = G__9030__delegate;
return G__9030;
})()
;
G__9029 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9029__0.call(this);
case 1:
return G__9029__1.call(this,x);
case 2:
return G__9029__2.call(this,x,y);
case 3:
return G__9029__3.call(this,x,y,z);
default:
var G__9033 = null;
if (arguments.length > 3) {
var G__9034__i = 0, G__9034__a = new Array(arguments.length -  3);
while (G__9034__i < G__9034__a.length) {G__9034__a[G__9034__i] = arguments[G__9034__i + 3]; ++G__9034__i;}
G__9033 = new cljs.core.IndexedSeq(G__9034__a,0);
}
return G__9029__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9033);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9029.cljs$lang$maxFixedArity = 3;
G__9029.cljs$lang$applyTo = G__9029__4.cljs$lang$applyTo;
G__9029.cljs$core$IFn$_invoke$arity$0 = G__9029__0;
G__9029.cljs$core$IFn$_invoke$arity$1 = G__9029__1;
G__9029.cljs$core$IFn$_invoke$arity$2 = G__9029__2;
G__9029.cljs$core$IFn$_invoke$arity$3 = G__9029__3;
G__9029.cljs$core$IFn$_invoke$arity$variadic = G__9029__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9029;
})()
});
var partial__3 = (function (f,arg1,arg2){
return (function() {
var G__9035 = null;
var G__9035__0 = (function (){
var G__8997 = arg1;
var G__8998 = arg2;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8997,G__8998) : f.call(null,G__8997,G__8998));
});
var G__9035__1 = (function (x){
var G__8999 = arg1;
var G__9000 = arg2;
var G__9001 = x;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8999,G__9000,G__9001) : f.call(null,G__8999,G__9000,G__9001));
});
var G__9035__2 = (function (x,y){
var G__9002 = arg1;
var G__9003 = arg2;
var G__9004 = x;
var G__9005 = y;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9002,G__9003,G__9004,G__9005) : f.call(null,G__9002,G__9003,G__9004,G__9005));
});
var G__9035__3 = (function (x,y,z){
var G__9006 = arg1;
var G__9007 = arg2;
var G__9008 = x;
var G__9009 = y;
var G__9010 = z;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__9006,G__9007,G__9008,G__9009,G__9010) : f.call(null,G__9006,G__9007,G__9008,G__9009,G__9010));
});
var G__9035__4 = (function() { 
var G__9036__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.array_seq([z,args], 0));
};
var G__9036 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9037__i = 0, G__9037__a = new Array(arguments.length -  3);
while (G__9037__i < G__9037__a.length) {G__9037__a[G__9037__i] = arguments[G__9037__i + 3]; ++G__9037__i;}
  args = new cljs.core.IndexedSeq(G__9037__a,0);
} 
return G__9036__delegate.call(this,x,y,z,args);};
G__9036.cljs$lang$maxFixedArity = 3;
G__9036.cljs$lang$applyTo = (function (arglist__9038){
var x = cljs.core.first(arglist__9038);
arglist__9038 = cljs.core.next(arglist__9038);
var y = cljs.core.first(arglist__9038);
arglist__9038 = cljs.core.next(arglist__9038);
var z = cljs.core.first(arglist__9038);
var args = cljs.core.rest(arglist__9038);
return G__9036__delegate(x,y,z,args);
});
G__9036.cljs$core$IFn$_invoke$arity$variadic = G__9036__delegate;
return G__9036;
})()
;
G__9035 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9035__0.call(this);
case 1:
return G__9035__1.call(this,x);
case 2:
return G__9035__2.call(this,x,y);
case 3:
return G__9035__3.call(this,x,y,z);
default:
var G__9039 = null;
if (arguments.length > 3) {
var G__9040__i = 0, G__9040__a = new Array(arguments.length -  3);
while (G__9040__i < G__9040__a.length) {G__9040__a[G__9040__i] = arguments[G__9040__i + 3]; ++G__9040__i;}
G__9039 = new cljs.core.IndexedSeq(G__9040__a,0);
}
return G__9035__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9039);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9035.cljs$lang$maxFixedArity = 3;
G__9035.cljs$lang$applyTo = G__9035__4.cljs$lang$applyTo;
G__9035.cljs$core$IFn$_invoke$arity$0 = G__9035__0;
G__9035.cljs$core$IFn$_invoke$arity$1 = G__9035__1;
G__9035.cljs$core$IFn$_invoke$arity$2 = G__9035__2;
G__9035.cljs$core$IFn$_invoke$arity$3 = G__9035__3;
G__9035.cljs$core$IFn$_invoke$arity$variadic = G__9035__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9035;
})()
});
var partial__4 = (function (f,arg1,arg2,arg3){
return (function() {
var G__9041 = null;
var G__9041__0 = (function (){
var G__9011 = arg1;
var G__9012 = arg2;
var G__9013 = arg3;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9011,G__9012,G__9013) : f.call(null,G__9011,G__9012,G__9013));
});
var G__9041__1 = (function (x){
var G__9014 = arg1;
var G__9015 = arg2;
var G__9016 = arg3;
var G__9017 = x;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9014,G__9015,G__9016,G__9017) : f.call(null,G__9014,G__9015,G__9016,G__9017));
});
var G__9041__2 = (function (x,y){
var G__9018 = arg1;
var G__9019 = arg2;
var G__9020 = arg3;
var G__9021 = x;
var G__9022 = y;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__9018,G__9019,G__9020,G__9021,G__9022) : f.call(null,G__9018,G__9019,G__9020,G__9021,G__9022));
});
var G__9041__3 = (function (x,y,z){
var G__9023 = arg1;
var G__9024 = arg2;
var G__9025 = arg3;
var G__9026 = x;
var G__9027 = y;
var G__9028 = z;
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__9023,G__9024,G__9025,G__9026,G__9027,G__9028) : f.call(null,G__9023,G__9024,G__9025,G__9026,G__9027,G__9028));
});
var G__9041__4 = (function() { 
var G__9042__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.array_seq([y,z,args], 0));
};
var G__9042 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9043__i = 0, G__9043__a = new Array(arguments.length -  3);
while (G__9043__i < G__9043__a.length) {G__9043__a[G__9043__i] = arguments[G__9043__i + 3]; ++G__9043__i;}
  args = new cljs.core.IndexedSeq(G__9043__a,0);
} 
return G__9042__delegate.call(this,x,y,z,args);};
G__9042.cljs$lang$maxFixedArity = 3;
G__9042.cljs$lang$applyTo = (function (arglist__9044){
var x = cljs.core.first(arglist__9044);
arglist__9044 = cljs.core.next(arglist__9044);
var y = cljs.core.first(arglist__9044);
arglist__9044 = cljs.core.next(arglist__9044);
var z = cljs.core.first(arglist__9044);
var args = cljs.core.rest(arglist__9044);
return G__9042__delegate(x,y,z,args);
});
G__9042.cljs$core$IFn$_invoke$arity$variadic = G__9042__delegate;
return G__9042;
})()
;
G__9041 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9041__0.call(this);
case 1:
return G__9041__1.call(this,x);
case 2:
return G__9041__2.call(this,x,y);
case 3:
return G__9041__3.call(this,x,y,z);
default:
var G__9045 = null;
if (arguments.length > 3) {
var G__9046__i = 0, G__9046__a = new Array(arguments.length -  3);
while (G__9046__i < G__9046__a.length) {G__9046__a[G__9046__i] = arguments[G__9046__i + 3]; ++G__9046__i;}
G__9045 = new cljs.core.IndexedSeq(G__9046__a,0);
}
return G__9041__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9045);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9041.cljs$lang$maxFixedArity = 3;
G__9041.cljs$lang$applyTo = G__9041__4.cljs$lang$applyTo;
G__9041.cljs$core$IFn$_invoke$arity$0 = G__9041__0;
G__9041.cljs$core$IFn$_invoke$arity$1 = G__9041__1;
G__9041.cljs$core$IFn$_invoke$arity$2 = G__9041__2;
G__9041.cljs$core$IFn$_invoke$arity$3 = G__9041__3;
G__9041.cljs$core$IFn$_invoke$arity$variadic = G__9041__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9041;
})()
});
var partial__5 = (function() { 
var G__9047__delegate = function (f,arg1,arg2,arg3,more){
return (function() { 
var G__9048__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args));
};
var G__9048 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__9049__i = 0, G__9049__a = new Array(arguments.length -  0);
while (G__9049__i < G__9049__a.length) {G__9049__a[G__9049__i] = arguments[G__9049__i + 0]; ++G__9049__i;}
  args = new cljs.core.IndexedSeq(G__9049__a,0);
} 
return G__9048__delegate.call(this,args);};
G__9048.cljs$lang$maxFixedArity = 0;
G__9048.cljs$lang$applyTo = (function (arglist__9050){
var args = cljs.core.seq(arglist__9050);
return G__9048__delegate(args);
});
G__9048.cljs$core$IFn$_invoke$arity$variadic = G__9048__delegate;
return G__9048;
})()
;
};
var G__9047 = function (f,arg1,arg2,arg3,var_args){
var more = null;
if (arguments.length > 4) {
var G__9051__i = 0, G__9051__a = new Array(arguments.length -  4);
while (G__9051__i < G__9051__a.length) {G__9051__a[G__9051__i] = arguments[G__9051__i + 4]; ++G__9051__i;}
  more = new cljs.core.IndexedSeq(G__9051__a,0);
} 
return G__9047__delegate.call(this,f,arg1,arg2,arg3,more);};
G__9047.cljs$lang$maxFixedArity = 4;
G__9047.cljs$lang$applyTo = (function (arglist__9052){
var f = cljs.core.first(arglist__9052);
arglist__9052 = cljs.core.next(arglist__9052);
var arg1 = cljs.core.first(arglist__9052);
arglist__9052 = cljs.core.next(arglist__9052);
var arg2 = cljs.core.first(arglist__9052);
arglist__9052 = cljs.core.next(arglist__9052);
var arg3 = cljs.core.first(arglist__9052);
var more = cljs.core.rest(arglist__9052);
return G__9047__delegate(f,arg1,arg2,arg3,more);
});
G__9047.cljs$core$IFn$_invoke$arity$variadic = G__9047__delegate;
return G__9047;
})()
;
partial = function(f,arg1,arg2,arg3,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return partial__1.call(this,f);
case 2:
return partial__2.call(this,f,arg1);
case 3:
return partial__3.call(this,f,arg1,arg2);
case 4:
return partial__4.call(this,f,arg1,arg2,arg3);
default:
var G__9053 = null;
if (arguments.length > 4) {
var G__9054__i = 0, G__9054__a = new Array(arguments.length -  4);
while (G__9054__i < G__9054__a.length) {G__9054__a[G__9054__i] = arguments[G__9054__i + 4]; ++G__9054__i;}
G__9053 = new cljs.core.IndexedSeq(G__9054__a,0);
}
return partial__5.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3, G__9053);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partial.cljs$lang$maxFixedArity = 4;
partial.cljs$lang$applyTo = partial__5.cljs$lang$applyTo;
partial.cljs$core$IFn$_invoke$arity$1 = partial__1;
partial.cljs$core$IFn$_invoke$arity$2 = partial__2;
partial.cljs$core$IFn$_invoke$arity$3 = partial__3;
partial.cljs$core$IFn$_invoke$arity$4 = partial__4;
partial.cljs$core$IFn$_invoke$arity$variadic = partial__5.cljs$core$IFn$_invoke$arity$variadic;
return partial;
})()
;
/**
* Takes a function f, and returns a function that calls f, replacing
* a nil first argument to f with the supplied value x. Higher arity
* versions can replace arguments in the second and third
* positions (y, z). Note that the function f can take any number of
* arguments, not just the one(s) being nil-patched.
*/
cljs.core.fnil = (function() {
var fnil = null;
var fnil__2 = (function (f,x){
return (function() {
var G__9087 = null;
var G__9087__1 = (function (a){
var G__9071 = (((a == null))?x:a);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9071) : f.call(null,G__9071));
});
var G__9087__2 = (function (a,b){
var G__9072 = (((a == null))?x:a);
var G__9073 = b;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9072,G__9073) : f.call(null,G__9072,G__9073));
});
var G__9087__3 = (function (a,b,c){
var G__9074 = (((a == null))?x:a);
var G__9075 = b;
var G__9076 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9074,G__9075,G__9076) : f.call(null,G__9074,G__9075,G__9076));
});
var G__9087__4 = (function() { 
var G__9088__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),b,c,ds);
};
var G__9088 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__9089__i = 0, G__9089__a = new Array(arguments.length -  3);
while (G__9089__i < G__9089__a.length) {G__9089__a[G__9089__i] = arguments[G__9089__i + 3]; ++G__9089__i;}
  ds = new cljs.core.IndexedSeq(G__9089__a,0);
} 
return G__9088__delegate.call(this,a,b,c,ds);};
G__9088.cljs$lang$maxFixedArity = 3;
G__9088.cljs$lang$applyTo = (function (arglist__9090){
var a = cljs.core.first(arglist__9090);
arglist__9090 = cljs.core.next(arglist__9090);
var b = cljs.core.first(arglist__9090);
arglist__9090 = cljs.core.next(arglist__9090);
var c = cljs.core.first(arglist__9090);
var ds = cljs.core.rest(arglist__9090);
return G__9088__delegate(a,b,c,ds);
});
G__9088.cljs$core$IFn$_invoke$arity$variadic = G__9088__delegate;
return G__9088;
})()
;
G__9087 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return G__9087__1.call(this,a);
case 2:
return G__9087__2.call(this,a,b);
case 3:
return G__9087__3.call(this,a,b,c);
default:
var G__9091 = null;
if (arguments.length > 3) {
var G__9092__i = 0, G__9092__a = new Array(arguments.length -  3);
while (G__9092__i < G__9092__a.length) {G__9092__a[G__9092__i] = arguments[G__9092__i + 3]; ++G__9092__i;}
G__9091 = new cljs.core.IndexedSeq(G__9092__a,0);
}
return G__9087__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__9091);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9087.cljs$lang$maxFixedArity = 3;
G__9087.cljs$lang$applyTo = G__9087__4.cljs$lang$applyTo;
G__9087.cljs$core$IFn$_invoke$arity$1 = G__9087__1;
G__9087.cljs$core$IFn$_invoke$arity$2 = G__9087__2;
G__9087.cljs$core$IFn$_invoke$arity$3 = G__9087__3;
G__9087.cljs$core$IFn$_invoke$arity$variadic = G__9087__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9087;
})()
});
var fnil__3 = (function (f,x,y){
return (function() {
var G__9093 = null;
var G__9093__2 = (function (a,b){
var G__9077 = (((a == null))?x:a);
var G__9078 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9077,G__9078) : f.call(null,G__9077,G__9078));
});
var G__9093__3 = (function (a,b,c){
var G__9079 = (((a == null))?x:a);
var G__9080 = (((b == null))?y:b);
var G__9081 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9079,G__9080,G__9081) : f.call(null,G__9079,G__9080,G__9081));
});
var G__9093__4 = (function() { 
var G__9094__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__9094 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__9095__i = 0, G__9095__a = new Array(arguments.length -  3);
while (G__9095__i < G__9095__a.length) {G__9095__a[G__9095__i] = arguments[G__9095__i + 3]; ++G__9095__i;}
  ds = new cljs.core.IndexedSeq(G__9095__a,0);
} 
return G__9094__delegate.call(this,a,b,c,ds);};
G__9094.cljs$lang$maxFixedArity = 3;
G__9094.cljs$lang$applyTo = (function (arglist__9096){
var a = cljs.core.first(arglist__9096);
arglist__9096 = cljs.core.next(arglist__9096);
var b = cljs.core.first(arglist__9096);
arglist__9096 = cljs.core.next(arglist__9096);
var c = cljs.core.first(arglist__9096);
var ds = cljs.core.rest(arglist__9096);
return G__9094__delegate(a,b,c,ds);
});
G__9094.cljs$core$IFn$_invoke$arity$variadic = G__9094__delegate;
return G__9094;
})()
;
G__9093 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__9093__2.call(this,a,b);
case 3:
return G__9093__3.call(this,a,b,c);
default:
var G__9097 = null;
if (arguments.length > 3) {
var G__9098__i = 0, G__9098__a = new Array(arguments.length -  3);
while (G__9098__i < G__9098__a.length) {G__9098__a[G__9098__i] = arguments[G__9098__i + 3]; ++G__9098__i;}
G__9097 = new cljs.core.IndexedSeq(G__9098__a,0);
}
return G__9093__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__9097);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9093.cljs$lang$maxFixedArity = 3;
G__9093.cljs$lang$applyTo = G__9093__4.cljs$lang$applyTo;
G__9093.cljs$core$IFn$_invoke$arity$2 = G__9093__2;
G__9093.cljs$core$IFn$_invoke$arity$3 = G__9093__3;
G__9093.cljs$core$IFn$_invoke$arity$variadic = G__9093__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9093;
})()
});
var fnil__4 = (function (f,x,y,z){
return (function() {
var G__9099 = null;
var G__9099__2 = (function (a,b){
var G__9082 = (((a == null))?x:a);
var G__9083 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9082,G__9083) : f.call(null,G__9082,G__9083));
});
var G__9099__3 = (function (a,b,c){
var G__9084 = (((a == null))?x:a);
var G__9085 = (((b == null))?y:b);
var G__9086 = (((c == null))?z:c);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9084,G__9085,G__9086) : f.call(null,G__9084,G__9085,G__9086));
});
var G__9099__4 = (function() { 
var G__9100__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__9100 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__9101__i = 0, G__9101__a = new Array(arguments.length -  3);
while (G__9101__i < G__9101__a.length) {G__9101__a[G__9101__i] = arguments[G__9101__i + 3]; ++G__9101__i;}
  ds = new cljs.core.IndexedSeq(G__9101__a,0);
} 
return G__9100__delegate.call(this,a,b,c,ds);};
G__9100.cljs$lang$maxFixedArity = 3;
G__9100.cljs$lang$applyTo = (function (arglist__9102){
var a = cljs.core.first(arglist__9102);
arglist__9102 = cljs.core.next(arglist__9102);
var b = cljs.core.first(arglist__9102);
arglist__9102 = cljs.core.next(arglist__9102);
var c = cljs.core.first(arglist__9102);
var ds = cljs.core.rest(arglist__9102);
return G__9100__delegate(a,b,c,ds);
});
G__9100.cljs$core$IFn$_invoke$arity$variadic = G__9100__delegate;
return G__9100;
})()
;
G__9099 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__9099__2.call(this,a,b);
case 3:
return G__9099__3.call(this,a,b,c);
default:
var G__9103 = null;
if (arguments.length > 3) {
var G__9104__i = 0, G__9104__a = new Array(arguments.length -  3);
while (G__9104__i < G__9104__a.length) {G__9104__a[G__9104__i] = arguments[G__9104__i + 3]; ++G__9104__i;}
G__9103 = new cljs.core.IndexedSeq(G__9104__a,0);
}
return G__9099__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__9103);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9099.cljs$lang$maxFixedArity = 3;
G__9099.cljs$lang$applyTo = G__9099__4.cljs$lang$applyTo;
G__9099.cljs$core$IFn$_invoke$arity$2 = G__9099__2;
G__9099.cljs$core$IFn$_invoke$arity$3 = G__9099__3;
G__9099.cljs$core$IFn$_invoke$arity$variadic = G__9099__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9099;
})()
});
fnil = function(f,x,y,z){
switch(arguments.length){
case 2:
return fnil__2.call(this,f,x);
case 3:
return fnil__3.call(this,f,x,y);
case 4:
return fnil__4.call(this,f,x,y,z);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fnil.cljs$core$IFn$_invoke$arity$2 = fnil__2;
fnil.cljs$core$IFn$_invoke$arity$3 = fnil__3;
fnil.cljs$core$IFn$_invoke$arity$4 = fnil__4;
return fnil;
})()
;
/**
* Returns a lazy sequence consisting of the result of applying f to 0
* and the first item of coll, followed by applying f to 1 and the second
* item in coll, etc, until coll is exhausted. Thus function f should
* accept 2 arguments, index and item.
*/
cljs.core.map_indexed = (function() {
var map_indexed = null;
var map_indexed__1 = (function (f){
return (function (rf){
var i = (function (){var G__9135 = (-1);
return (cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1(G__9135) : cljs.core.volatile_BANG_.call(null,G__9135));
})();
return ((function (i){
return (function() {
var G__9165 = null;
var G__9165__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9165__1 = (function (result){
var G__9136 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9136) : rf.call(null,G__9136));
});
var G__9165__2 = (function (result,input){
var G__9137 = result;
var G__9138 = (function (){var G__9139 = cljs.core._vreset_BANG_(i,(cljs.core._deref(i) + (1)));
var G__9140 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9139,G__9140) : f.call(null,G__9139,G__9140));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9137,G__9138) : rf.call(null,G__9137,G__9138));
});
G__9165 = function(result,input){
switch(arguments.length){
case 0:
return G__9165__0.call(this);
case 1:
return G__9165__1.call(this,result);
case 2:
return G__9165__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9165.cljs$core$IFn$_invoke$arity$0 = G__9165__0;
G__9165.cljs$core$IFn$_invoke$arity$1 = G__9165__1;
G__9165.cljs$core$IFn$_invoke$arity$2 = G__9165__2;
return G__9165;
})()
;})(i))
});
});
var map_indexed__2 = (function (f,coll){
var mapi = (function mapi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll__$1);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5989__auto___9166 = size;
var i_9167 = (0);
while(true){
if((i_9167 < n__5989__auto___9166)){
cljs.core.chunk_append(b,(function (){var G__9161 = (idx + i_9167);
var G__9162 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_9167);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9161,G__9162) : f.call(null,G__9161,G__9162));
})());

var G__9168 = (i_9167 + (1));
i_9167 = G__9168;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),mapi((idx + size),cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__9163 = idx;
var G__9164 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9163,G__9164) : f.call(null,G__9163,G__9164));
})(),mapi((idx + (1)),cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
return mapi((0),coll);
});
map_indexed = function(f,coll){
switch(arguments.length){
case 1:
return map_indexed__1.call(this,f);
case 2:
return map_indexed__2.call(this,f,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
map_indexed.cljs$core$IFn$_invoke$arity$1 = map_indexed__1;
map_indexed.cljs$core$IFn$_invoke$arity$2 = map_indexed__2;
return map_indexed;
})()
;
/**
* Returns a lazy sequence of the non-nil results of (f item). Note,
* this means false return values will be included.  f must be free of
* side-effects.  Returns a transducer when no collection is provided.
*/
cljs.core.keep = (function() {
var keep = null;
var keep__1 = (function (f){
return (function (rf){
return (function() {
var G__9187 = null;
var G__9187__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9187__1 = (function (result){
var G__9181 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9181) : rf.call(null,G__9181));
});
var G__9187__2 = (function (result,input){
var v = (function (){var G__9182 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9182) : f.call(null,G__9182));
})();
if((v == null)){
return result;
} else {
var G__9183 = result;
var G__9184 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9183,G__9184) : rf.call(null,G__9183,G__9184));
}
});
G__9187 = function(result,input){
switch(arguments.length){
case 0:
return G__9187__0.call(this);
case 1:
return G__9187__1.call(this,result);
case 2:
return G__9187__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9187.cljs$core$IFn$_invoke$arity$0 = G__9187__0;
G__9187.cljs$core$IFn$_invoke$arity$1 = G__9187__1;
G__9187.cljs$core$IFn$_invoke$arity$2 = G__9187__2;
return G__9187;
})()
});
});
var keep__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5989__auto___9188 = size;
var i_9189 = (0);
while(true){
if((i_9189 < n__5989__auto___9188)){
var x_9190 = (function (){var G__9185 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_9189);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9185) : f.call(null,G__9185));
})();
if((x_9190 == null)){
} else {
cljs.core.chunk_append(b,x_9190);
}

var G__9191 = (i_9189 + (1));
i_9189 = G__9191;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__9186 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9186) : f.call(null,G__9186));
})();
if((x == null)){
return keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));
} else {
return cljs.core.cons(x,keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
keep = function(f,coll){
switch(arguments.length){
case 1:
return keep__1.call(this,f);
case 2:
return keep__2.call(this,f,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
keep.cljs$core$IFn$_invoke$arity$1 = keep__1;
keep.cljs$core$IFn$_invoke$arity$2 = keep__2;
return keep;
})()
;

/**
* @constructor
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition0$ = 6455296;
this.cljs$lang$protocol_mask$partition1$ = 16386;
})
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var G__9192 = this$__$1;
return goog.getUid(G__9192);
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
var seq__9193 = cljs.core.seq(self__.watches);
var chunk__9194 = null;
var count__9195 = (0);
var i__9196 = (0);
while(true){
if((i__9196 < count__9195)){
var vec__9197 = chunk__9194.cljs$core$IIndexed$_nth$arity$2(null,i__9196);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9197,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9197,(1),null);
var G__9198_9207 = key;
var G__9199_9208 = this$__$1;
var G__9200_9209 = oldval;
var G__9201_9210 = newval;
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9198_9207,G__9199_9208,G__9200_9209,G__9201_9210) : f.call(null,G__9198_9207,G__9199_9208,G__9200_9209,G__9201_9210));

var G__9211 = seq__9193;
var G__9212 = chunk__9194;
var G__9213 = count__9195;
var G__9214 = (i__9196 + (1));
seq__9193 = G__9211;
chunk__9194 = G__9212;
count__9195 = G__9213;
i__9196 = G__9214;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__9193);
if(temp__4126__auto__){
var seq__9193__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9193__$1)){
var c__5889__auto__ = cljs.core.chunk_first(seq__9193__$1);
var G__9215 = cljs.core.chunk_rest(seq__9193__$1);
var G__9216 = c__5889__auto__;
var G__9217 = cljs.core.count(c__5889__auto__);
var G__9218 = (0);
seq__9193 = G__9215;
chunk__9194 = G__9216;
count__9195 = G__9217;
i__9196 = G__9218;
continue;
} else {
var vec__9202 = cljs.core.first(seq__9193__$1);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9202,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9202,(1),null);
var G__9203_9219 = key;
var G__9204_9220 = this$__$1;
var G__9205_9221 = oldval;
var G__9206_9222 = newval;
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9203_9219,G__9204_9220,G__9205_9221,G__9206_9222) : f.call(null,G__9203_9219,G__9204_9220,G__9205_9221,G__9206_9222));

var G__9223 = cljs.core.next(seq__9193__$1);
var G__9224 = null;
var G__9225 = (0);
var G__9226 = (0);
seq__9193 = G__9223;
chunk__9194 = G__9224;
count__9195 = G__9225;
i__9196 = G__9226;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key,f);

return this$__$1;
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key);
});

cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return (o__$1 === other);
});

cljs.core.Atom.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Atom.cljs$lang$type = true;

cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom";

cljs.core.Atom.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/Atom");
});

cljs.core.__GT_Atom = (function __GT_Atom(state,meta,validator,watches){
return (new cljs.core.Atom(state,meta,validator,watches));
});

/**
* Creates and returns an Atom with an initial value of x and zero or
* more options (in any order):
* 
* :meta metadata-map
* 
* :validator validate-fn
* 
* If metadata-map is supplied, it will be come the metadata on the
* atom. validate-fn must be nil or a side-effect-free fn of one
* argument, which will be passed the intended new state on any state
* change. If the new state is unacceptable, the validate-fn should
* return false or throw an Error.  If either of these error conditions
* occur, then the value of the atom will not change.
* @param {...*} var_args
*/
cljs.core.atom = (function() {
var atom = null;
var atom__1 = (function (x){
return (new cljs.core.Atom(x,null,null,null));
});
var atom__2 = (function() { 
var G__9230__delegate = function (x,p__9227){
var map__9229 = p__9227;
var map__9229__$1 = ((cljs.core.seq_QMARK_(map__9229))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9229):map__9229);
var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9229__$1,new cljs.core.Keyword(null,"validator","validator",-1966190681));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9229__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
return (new cljs.core.Atom(x,meta,validator,null));
};
var G__9230 = function (x,var_args){
var p__9227 = null;
if (arguments.length > 1) {
var G__9231__i = 0, G__9231__a = new Array(arguments.length -  1);
while (G__9231__i < G__9231__a.length) {G__9231__a[G__9231__i] = arguments[G__9231__i + 1]; ++G__9231__i;}
  p__9227 = new cljs.core.IndexedSeq(G__9231__a,0);
} 
return G__9230__delegate.call(this,x,p__9227);};
G__9230.cljs$lang$maxFixedArity = 1;
G__9230.cljs$lang$applyTo = (function (arglist__9232){
var x = cljs.core.first(arglist__9232);
var p__9227 = cljs.core.rest(arglist__9232);
return G__9230__delegate(x,p__9227);
});
G__9230.cljs$core$IFn$_invoke$arity$variadic = G__9230__delegate;
return G__9230;
})()
;
atom = function(x,var_args){
var p__9227 = var_args;
switch(arguments.length){
case 1:
return atom__1.call(this,x);
default:
var G__9233 = null;
if (arguments.length > 1) {
var G__9234__i = 0, G__9234__a = new Array(arguments.length -  1);
while (G__9234__i < G__9234__a.length) {G__9234__a[G__9234__i] = arguments[G__9234__i + 1]; ++G__9234__i;}
G__9233 = new cljs.core.IndexedSeq(G__9234__a,0);
}
return atom__2.cljs$core$IFn$_invoke$arity$variadic(x, G__9233);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
atom.cljs$lang$maxFixedArity = 1;
atom.cljs$lang$applyTo = atom__2.cljs$lang$applyTo;
atom.cljs$core$IFn$_invoke$arity$1 = atom__1;
atom.cljs$core$IFn$_invoke$arity$variadic = atom__2.cljs$core$IFn$_invoke$arity$variadic;
return atom;
})()
;
/**
* Sets the value of atom to newval without regard for the
* current value. Returns newval.
*/
cljs.core.reset_BANG_ = (function reset_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((function (){var G__9237 = new_value;
return (validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(G__9237) : validate.call(null,G__9237));
})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Validator rejected reference state"),cljs.core.str("\n"),cljs.core.str((function (){var G__9238 = cljs.core.list(new cljs.core.Symbol(null,"validate","validate",1439230700,null),new cljs.core.Symbol(null,"new-value","new-value",-1567397401,null));
return (cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__9238) : cljs.core.pr_str.call(null,G__9238));
})())].join('')));
}
}

var old_value = a.state;
a.state = new_value;

if((a.watches == null)){
} else {
cljs.core._notify_watches(a,old_value,new_value);
}

return new_value;
} else {
return cljs.core._reset_BANG_(a,new_value);
}
});
/**
* Atomically swaps the value of atom to be:
* (apply f current-value-of-atom args). Note that f may be called
* multiple times, and thus should be free of side effects.  Returns
* the value that was swapped in.
* @param {...*} var_args
*/
cljs.core.swap_BANG_ = (function() {
var swap_BANG_ = null;
var swap_BANG___2 = (function (a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__9245 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9245) : f.call(null,G__9245));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f);
}
});
var swap_BANG___3 = (function (a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__9246 = a.state;
var G__9247 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9246,G__9247) : f.call(null,G__9246,G__9247));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x);
}
});
var swap_BANG___4 = (function (a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__9248 = a.state;
var G__9249 = x;
var G__9250 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9248,G__9249,G__9250) : f.call(null,G__9248,G__9249,G__9250));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y);
}
});
var swap_BANG___5 = (function() { 
var G__9251__delegate = function (a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more);
}
};
var G__9251 = function (a,f,x,y,var_args){
var more = null;
if (arguments.length > 4) {
var G__9252__i = 0, G__9252__a = new Array(arguments.length -  4);
while (G__9252__i < G__9252__a.length) {G__9252__a[G__9252__i] = arguments[G__9252__i + 4]; ++G__9252__i;}
  more = new cljs.core.IndexedSeq(G__9252__a,0);
} 
return G__9251__delegate.call(this,a,f,x,y,more);};
G__9251.cljs$lang$maxFixedArity = 4;
G__9251.cljs$lang$applyTo = (function (arglist__9253){
var a = cljs.core.first(arglist__9253);
arglist__9253 = cljs.core.next(arglist__9253);
var f = cljs.core.first(arglist__9253);
arglist__9253 = cljs.core.next(arglist__9253);
var x = cljs.core.first(arglist__9253);
arglist__9253 = cljs.core.next(arglist__9253);
var y = cljs.core.first(arglist__9253);
var more = cljs.core.rest(arglist__9253);
return G__9251__delegate(a,f,x,y,more);
});
G__9251.cljs$core$IFn$_invoke$arity$variadic = G__9251__delegate;
return G__9251;
})()
;
swap_BANG_ = function(a,f,x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return swap_BANG___2.call(this,a,f);
case 3:
return swap_BANG___3.call(this,a,f,x);
case 4:
return swap_BANG___4.call(this,a,f,x,y);
default:
var G__9254 = null;
if (arguments.length > 4) {
var G__9255__i = 0, G__9255__a = new Array(arguments.length -  4);
while (G__9255__i < G__9255__a.length) {G__9255__a[G__9255__i] = arguments[G__9255__i + 4]; ++G__9255__i;}
G__9254 = new cljs.core.IndexedSeq(G__9255__a,0);
}
return swap_BANG___5.cljs$core$IFn$_invoke$arity$variadic(a,f,x,y, G__9254);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
swap_BANG_.cljs$lang$maxFixedArity = 4;
swap_BANG_.cljs$lang$applyTo = swap_BANG___5.cljs$lang$applyTo;
swap_BANG_.cljs$core$IFn$_invoke$arity$2 = swap_BANG___2;
swap_BANG_.cljs$core$IFn$_invoke$arity$3 = swap_BANG___3;
swap_BANG_.cljs$core$IFn$_invoke$arity$4 = swap_BANG___4;
swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = swap_BANG___5.cljs$core$IFn$_invoke$arity$variadic;
return swap_BANG_;
})()
;
/**
* Atomically sets the value of atom to newval if and only if the
* current value of the atom is equal to oldval. Returns true if
* set happened, else false.
*/
cljs.core.compare_and_set_BANG_ = (function compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null),oldval)){
cljs.core.reset_BANG_(a,newval);

return true;
} else {
return false;
}
});
/**
* Sets the validator-fn for an atom. validator-fn must be nil or a
* side-effect-free fn of one argument, which will be passed the intended
* new state on any state change. If the new state is unacceptable, the
* validator-fn should return false or throw an Error. If the current state
* is not acceptable to the new validator, an Error will be thrown and the
* validator will not be changed.
*/
cljs.core.set_validator_BANG_ = (function set_validator_BANG_(iref,val){
return iref.validator = val;
});
/**
* Gets the validator-fn for a var/ref/agent/atom.
*/
cljs.core.get_validator = (function get_validator(iref){
return iref.validator;
});

/**
* @constructor
*/
cljs.core.Volatile = (function (state){
this.state = state;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32768;
})
cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Volatile.prototype.cljs$core$IVolatile$ = true;

cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = (function (_,new_state){
var self__ = this;
var ___$1 = this;
return self__.state = new_state;
});

cljs.core.Volatile.cljs$lang$type = true;

cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile";

cljs.core.Volatile.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/Volatile");
});

cljs.core.__GT_Volatile = (function __GT_Volatile(state){
return (new cljs.core.Volatile(state));
});

/**
* Creates and returns a Volatile with an initial value of val.
*/
cljs.core.volatile_BANG_ = (function volatile_BANG_(val){
return (new cljs.core.Volatile(val));
});
/**
* Returns true if x is a volatile.
*/
cljs.core.volatile_QMARK_ = (function volatile_QMARK_(x){
return (x instanceof cljs.core.Volatile);
});
/**
* Sets the value of volatile to newval without regard for the
* current value. Returns newval.
*/
cljs.core.vreset_BANG_ = (function vreset_BANG_(vol,newval){
return cljs.core._vreset_BANG_(vol,newval);
});
/**
* Returns a lazy sequence of the non-nil results of (f index item). Note,
* this means false return values will be included.  f must be free of
* side-effects.  Returns a stateful transducer when no collection is
* provided.
*/
cljs.core.keep_indexed = (function() {
var keep_indexed = null;
var keep_indexed__1 = (function (f){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__9322 = null;
var G__9322__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9322__1 = (function (result){
var G__9289 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9289) : rf.call(null,G__9289));
});
var G__9322__2 = (function (result,input){
var i = ia.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(ia.cljs$core$IDeref$_deref$arity$1(null) + (1)));
var v = (function (){var G__9290 = i;
var G__9291 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9290,G__9291) : f.call(null,G__9290,G__9291));
})();
if((v == null)){
return result;
} else {
var G__9292 = result;
var G__9293 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9292,G__9293) : rf.call(null,G__9292,G__9293));
}
});
G__9322 = function(result,input){
switch(arguments.length){
case 0:
return G__9322__0.call(this);
case 1:
return G__9322__1.call(this,result);
case 2:
return G__9322__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9322.cljs$core$IFn$_invoke$arity$0 = G__9322__0;
G__9322.cljs$core$IFn$_invoke$arity$1 = G__9322__1;
G__9322.cljs$core$IFn$_invoke$arity$2 = G__9322__2;
return G__9322;
})()
;})(ia))
});
});
var keep_indexed__2 = (function (f,coll){
var keepi = (function keepi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll__$1);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5989__auto___9323 = size;
var i_9324 = (0);
while(true){
if((i_9324 < n__5989__auto___9323)){
var x_9325 = (function (){var G__9318 = (idx + i_9324);
var G__9319 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_9324);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9318,G__9319) : f.call(null,G__9318,G__9319));
})();
if((x_9325 == null)){
} else {
cljs.core.chunk_append(b,x_9325);
}

var G__9326 = (i_9324 + (1));
i_9324 = G__9326;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),keepi((idx + size),cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__9320 = idx;
var G__9321 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9320,G__9321) : f.call(null,G__9320,G__9321));
})();
if((x == null)){
return keepi((idx + (1)),cljs.core.rest(s));
} else {
return cljs.core.cons(x,keepi((idx + (1)),cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
return keepi((0),coll);
});
keep_indexed = function(f,coll){
switch(arguments.length){
case 1:
return keep_indexed__1.call(this,f);
case 2:
return keep_indexed__2.call(this,f,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
keep_indexed.cljs$core$IFn$_invoke$arity$1 = keep_indexed__1;
keep_indexed.cljs$core$IFn$_invoke$arity$2 = keep_indexed__2;
return keep_indexed;
})()
;
/**
* Takes a set of predicates and returns a function f that returns true if all of its
* composing predicates return a logical true value against all of its arguments, else it returns
* false. Note that f is short-circuiting in that it will stop execution on the first
* argument that triggers a logical false result against the original predicates.
* @param {...*} var_args
*/
cljs.core.every_pred = (function() {
var every_pred = null;
var every_pred__1 = (function (p){
return (function() {
var ep1 = null;
var ep1__0 = (function (){
return true;
});
var ep1__1 = (function (x){
return cljs.core.boolean$((function (){var G__9540 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__9540) : p.call(null,G__9540));
})());
});
var ep1__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__5090__auto__ = (function (){var G__9542 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__9542) : p.call(null,G__9542));
})();
if(cljs.core.truth_(and__5090__auto__)){
var G__9543 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__9543) : p.call(null,G__9543));
} else {
return and__5090__auto__;
}
})());
});
var ep1__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__5090__auto__ = (function (){var G__9545 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__9545) : p.call(null,G__9545));
})();
if(cljs.core.truth_(and__5090__auto__)){
var and__5090__auto____$1 = (function (){var G__9547 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__9547) : p.call(null,G__9547));
})();
if(cljs.core.truth_(and__5090__auto____$1)){
var G__9548 = z;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__9548) : p.call(null,G__9548));
} else {
return and__5090__auto____$1;
}
} else {
return and__5090__auto__;
}
})());
});
var ep1__4 = (function() { 
var G__9717__delegate = function (x,y,z,args){
return cljs.core.boolean$((ep1.cljs$core$IFn$_invoke$arity$3(x,y,z)) && (cljs.core.every_QMARK_(p,args)));
};
var G__9717 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9718__i = 0, G__9718__a = new Array(arguments.length -  3);
while (G__9718__i < G__9718__a.length) {G__9718__a[G__9718__i] = arguments[G__9718__i + 3]; ++G__9718__i;}
  args = new cljs.core.IndexedSeq(G__9718__a,0);
} 
return G__9717__delegate.call(this,x,y,z,args);};
G__9717.cljs$lang$maxFixedArity = 3;
G__9717.cljs$lang$applyTo = (function (arglist__9719){
var x = cljs.core.first(arglist__9719);
arglist__9719 = cljs.core.next(arglist__9719);
var y = cljs.core.first(arglist__9719);
arglist__9719 = cljs.core.next(arglist__9719);
var z = cljs.core.first(arglist__9719);
var args = cljs.core.rest(arglist__9719);
return G__9717__delegate(x,y,z,args);
});
G__9717.cljs$core$IFn$_invoke$arity$variadic = G__9717__delegate;
return G__9717;
})()
;
ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return ep1__0.call(this);
case 1:
return ep1__1.call(this,x);
case 2:
return ep1__2.call(this,x,y);
case 3:
return ep1__3.call(this,x,y,z);
default:
var G__9720 = null;
if (arguments.length > 3) {
var G__9721__i = 0, G__9721__a = new Array(arguments.length -  3);
while (G__9721__i < G__9721__a.length) {G__9721__a[G__9721__i] = arguments[G__9721__i + 3]; ++G__9721__i;}
G__9720 = new cljs.core.IndexedSeq(G__9721__a,0);
}
return ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9720);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
ep1.cljs$lang$maxFixedArity = 3;
ep1.cljs$lang$applyTo = ep1__4.cljs$lang$applyTo;
ep1.cljs$core$IFn$_invoke$arity$0 = ep1__0;
ep1.cljs$core$IFn$_invoke$arity$1 = ep1__1;
ep1.cljs$core$IFn$_invoke$arity$2 = ep1__2;
ep1.cljs$core$IFn$_invoke$arity$3 = ep1__3;
ep1.cljs$core$IFn$_invoke$arity$variadic = ep1__4.cljs$core$IFn$_invoke$arity$variadic;
return ep1;
})()
});
var every_pred__2 = (function (p1,p2){
return (function() {
var ep2 = null;
var ep2__0 = (function (){
return true;
});
var ep2__1 = (function (x){
return cljs.core.boolean$((function (){var and__5090__auto__ = (function (){var G__9580 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9580) : p1.call(null,G__9580));
})();
if(cljs.core.truth_(and__5090__auto__)){
var G__9581 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9581) : p2.call(null,G__9581));
} else {
return and__5090__auto__;
}
})());
});
var ep2__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__5090__auto__ = (function (){var G__9583 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9583) : p1.call(null,G__9583));
})();
if(cljs.core.truth_(and__5090__auto__)){
var and__5090__auto____$1 = (function (){var G__9585 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9585) : p1.call(null,G__9585));
})();
if(cljs.core.truth_(and__5090__auto____$1)){
var and__5090__auto____$2 = (function (){var G__9587 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9587) : p2.call(null,G__9587));
})();
if(cljs.core.truth_(and__5090__auto____$2)){
var G__9588 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9588) : p2.call(null,G__9588));
} else {
return and__5090__auto____$2;
}
} else {
return and__5090__auto____$1;
}
} else {
return and__5090__auto__;
}
})());
});
var ep2__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__5090__auto__ = (function (){var G__9590 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9590) : p1.call(null,G__9590));
})();
if(cljs.core.truth_(and__5090__auto__)){
var and__5090__auto____$1 = (function (){var G__9592 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9592) : p1.call(null,G__9592));
})();
if(cljs.core.truth_(and__5090__auto____$1)){
var and__5090__auto____$2 = (function (){var G__9594 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9594) : p1.call(null,G__9594));
})();
if(cljs.core.truth_(and__5090__auto____$2)){
var and__5090__auto____$3 = (function (){var G__9596 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9596) : p2.call(null,G__9596));
})();
if(cljs.core.truth_(and__5090__auto____$3)){
var and__5090__auto____$4 = (function (){var G__9598 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9598) : p2.call(null,G__9598));
})();
if(cljs.core.truth_(and__5090__auto____$4)){
var G__9599 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9599) : p2.call(null,G__9599));
} else {
return and__5090__auto____$4;
}
} else {
return and__5090__auto____$3;
}
} else {
return and__5090__auto____$2;
}
} else {
return and__5090__auto____$1;
}
} else {
return and__5090__auto__;
}
})());
});
var ep2__4 = (function() { 
var G__9722__delegate = function (x,y,z,args){
return cljs.core.boolean$((ep2.cljs$core$IFn$_invoke$arity$3(x,y,z)) && (cljs.core.every_QMARK_((function (p1__9327_SHARP_){
var and__5090__auto__ = (function (){var G__9604 = p1__9327_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9604) : p1.call(null,G__9604));
})();
if(cljs.core.truth_(and__5090__auto__)){
var G__9605 = p1__9327_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9605) : p2.call(null,G__9605));
} else {
return and__5090__auto__;
}
}),args)));
};
var G__9722 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9723__i = 0, G__9723__a = new Array(arguments.length -  3);
while (G__9723__i < G__9723__a.length) {G__9723__a[G__9723__i] = arguments[G__9723__i + 3]; ++G__9723__i;}
  args = new cljs.core.IndexedSeq(G__9723__a,0);
} 
return G__9722__delegate.call(this,x,y,z,args);};
G__9722.cljs$lang$maxFixedArity = 3;
G__9722.cljs$lang$applyTo = (function (arglist__9724){
var x = cljs.core.first(arglist__9724);
arglist__9724 = cljs.core.next(arglist__9724);
var y = cljs.core.first(arglist__9724);
arglist__9724 = cljs.core.next(arglist__9724);
var z = cljs.core.first(arglist__9724);
var args = cljs.core.rest(arglist__9724);
return G__9722__delegate(x,y,z,args);
});
G__9722.cljs$core$IFn$_invoke$arity$variadic = G__9722__delegate;
return G__9722;
})()
;
ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return ep2__0.call(this);
case 1:
return ep2__1.call(this,x);
case 2:
return ep2__2.call(this,x,y);
case 3:
return ep2__3.call(this,x,y,z);
default:
var G__9725 = null;
if (arguments.length > 3) {
var G__9726__i = 0, G__9726__a = new Array(arguments.length -  3);
while (G__9726__i < G__9726__a.length) {G__9726__a[G__9726__i] = arguments[G__9726__i + 3]; ++G__9726__i;}
G__9725 = new cljs.core.IndexedSeq(G__9726__a,0);
}
return ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9725);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
ep2.cljs$lang$maxFixedArity = 3;
ep2.cljs$lang$applyTo = ep2__4.cljs$lang$applyTo;
ep2.cljs$core$IFn$_invoke$arity$0 = ep2__0;
ep2.cljs$core$IFn$_invoke$arity$1 = ep2__1;
ep2.cljs$core$IFn$_invoke$arity$2 = ep2__2;
ep2.cljs$core$IFn$_invoke$arity$3 = ep2__3;
ep2.cljs$core$IFn$_invoke$arity$variadic = ep2__4.cljs$core$IFn$_invoke$arity$variadic;
return ep2;
})()
});
var every_pred__3 = (function (p1,p2,p3){
return (function() {
var ep3 = null;
var ep3__0 = (function (){
return true;
});
var ep3__1 = (function (x){
return cljs.core.boolean$((function (){var and__5090__auto__ = (function (){var G__9651 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9651) : p1.call(null,G__9651));
})();
if(cljs.core.truth_(and__5090__auto__)){
var and__5090__auto____$1 = (function (){var G__9653 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9653) : p2.call(null,G__9653));
})();
if(cljs.core.truth_(and__5090__auto____$1)){
var G__9654 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__9654) : p3.call(null,G__9654));
} else {
return and__5090__auto____$1;
}
} else {
return and__5090__auto__;
}
})());
});
var ep3__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__5090__auto__ = (function (){var G__9656 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9656) : p1.call(null,G__9656));
})();
if(cljs.core.truth_(and__5090__auto__)){
var and__5090__auto____$1 = (function (){var G__9658 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9658) : p2.call(null,G__9658));
})();
if(cljs.core.truth_(and__5090__auto____$1)){
var and__5090__auto____$2 = (function (){var G__9660 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__9660) : p3.call(null,G__9660));
})();
if(cljs.core.truth_(and__5090__auto____$2)){
var and__5090__auto____$3 = (function (){var G__9662 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9662) : p1.call(null,G__9662));
})();
if(cljs.core.truth_(and__5090__auto____$3)){
var and__5090__auto____$4 = (function (){var G__9664 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9664) : p2.call(null,G__9664));
})();
if(cljs.core.truth_(and__5090__auto____$4)){
var G__9665 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__9665) : p3.call(null,G__9665));
} else {
return and__5090__auto____$4;
}
} else {
return and__5090__auto____$3;
}
} else {
return and__5090__auto____$2;
}
} else {
return and__5090__auto____$1;
}
} else {
return and__5090__auto__;
}
})());
});
var ep3__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__5090__auto__ = (function (){var G__9667 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9667) : p1.call(null,G__9667));
})();
if(cljs.core.truth_(and__5090__auto__)){
var and__5090__auto____$1 = (function (){var G__9669 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9669) : p2.call(null,G__9669));
})();
if(cljs.core.truth_(and__5090__auto____$1)){
var and__5090__auto____$2 = (function (){var G__9671 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__9671) : p3.call(null,G__9671));
})();
if(cljs.core.truth_(and__5090__auto____$2)){
var and__5090__auto____$3 = (function (){var G__9673 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9673) : p1.call(null,G__9673));
})();
if(cljs.core.truth_(and__5090__auto____$3)){
var and__5090__auto____$4 = (function (){var G__9675 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9675) : p2.call(null,G__9675));
})();
if(cljs.core.truth_(and__5090__auto____$4)){
var and__5090__auto____$5 = (function (){var G__9677 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__9677) : p3.call(null,G__9677));
})();
if(cljs.core.truth_(and__5090__auto____$5)){
var and__5090__auto____$6 = (function (){var G__9679 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9679) : p1.call(null,G__9679));
})();
if(cljs.core.truth_(and__5090__auto____$6)){
var and__5090__auto____$7 = (function (){var G__9681 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9681) : p2.call(null,G__9681));
})();
if(cljs.core.truth_(and__5090__auto____$7)){
var G__9682 = z;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__9682) : p3.call(null,G__9682));
} else {
return and__5090__auto____$7;
}
} else {
return and__5090__auto____$6;
}
} else {
return and__5090__auto____$5;
}
} else {
return and__5090__auto____$4;
}
} else {
return and__5090__auto____$3;
}
} else {
return and__5090__auto____$2;
}
} else {
return and__5090__auto____$1;
}
} else {
return and__5090__auto__;
}
})());
});
var ep3__4 = (function() { 
var G__9727__delegate = function (x,y,z,args){
return cljs.core.boolean$((ep3.cljs$core$IFn$_invoke$arity$3(x,y,z)) && (cljs.core.every_QMARK_((function (p1__9328_SHARP_){
var and__5090__auto__ = (function (){var G__9689 = p1__9328_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9689) : p1.call(null,G__9689));
})();
if(cljs.core.truth_(and__5090__auto__)){
var and__5090__auto____$1 = (function (){var G__9691 = p1__9328_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9691) : p2.call(null,G__9691));
})();
if(cljs.core.truth_(and__5090__auto____$1)){
var G__9692 = p1__9328_SHARP_;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__9692) : p3.call(null,G__9692));
} else {
return and__5090__auto____$1;
}
} else {
return and__5090__auto__;
}
}),args)));
};
var G__9727 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9728__i = 0, G__9728__a = new Array(arguments.length -  3);
while (G__9728__i < G__9728__a.length) {G__9728__a[G__9728__i] = arguments[G__9728__i + 3]; ++G__9728__i;}
  args = new cljs.core.IndexedSeq(G__9728__a,0);
} 
return G__9727__delegate.call(this,x,y,z,args);};
G__9727.cljs$lang$maxFixedArity = 3;
G__9727.cljs$lang$applyTo = (function (arglist__9729){
var x = cljs.core.first(arglist__9729);
arglist__9729 = cljs.core.next(arglist__9729);
var y = cljs.core.first(arglist__9729);
arglist__9729 = cljs.core.next(arglist__9729);
var z = cljs.core.first(arglist__9729);
var args = cljs.core.rest(arglist__9729);
return G__9727__delegate(x,y,z,args);
});
G__9727.cljs$core$IFn$_invoke$arity$variadic = G__9727__delegate;
return G__9727;
})()
;
ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return ep3__0.call(this);
case 1:
return ep3__1.call(this,x);
case 2:
return ep3__2.call(this,x,y);
case 3:
return ep3__3.call(this,x,y,z);
default:
var G__9730 = null;
if (arguments.length > 3) {
var G__9731__i = 0, G__9731__a = new Array(arguments.length -  3);
while (G__9731__i < G__9731__a.length) {G__9731__a[G__9731__i] = arguments[G__9731__i + 3]; ++G__9731__i;}
G__9730 = new cljs.core.IndexedSeq(G__9731__a,0);
}
return ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9730);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
ep3.cljs$lang$maxFixedArity = 3;
ep3.cljs$lang$applyTo = ep3__4.cljs$lang$applyTo;
ep3.cljs$core$IFn$_invoke$arity$0 = ep3__0;
ep3.cljs$core$IFn$_invoke$arity$1 = ep3__1;
ep3.cljs$core$IFn$_invoke$arity$2 = ep3__2;
ep3.cljs$core$IFn$_invoke$arity$3 = ep3__3;
ep3.cljs$core$IFn$_invoke$arity$variadic = ep3__4.cljs$core$IFn$_invoke$arity$variadic;
return ep3;
})()
});
var every_pred__4 = (function() { 
var G__9732__delegate = function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var epn = null;
var epn__0 = (function (){
return true;
});
var epn__1 = (function (x){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__9329_SHARP_){
var G__9708 = x;
return (p1__9329_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9329_SHARP_.cljs$core$IFn$_invoke$arity$1(G__9708) : p1__9329_SHARP_.call(null,G__9708));
});})(ps__$1))
,ps__$1);
});
var epn__2 = (function (x,y){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__9330_SHARP_){
var and__5090__auto__ = (function (){var G__9710 = x;
return (p1__9330_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9330_SHARP_.cljs$core$IFn$_invoke$arity$1(G__9710) : p1__9330_SHARP_.call(null,G__9710));
})();
if(cljs.core.truth_(and__5090__auto__)){
var G__9711 = y;
return (p1__9330_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9330_SHARP_.cljs$core$IFn$_invoke$arity$1(G__9711) : p1__9330_SHARP_.call(null,G__9711));
} else {
return and__5090__auto__;
}
});})(ps__$1))
,ps__$1);
});
var epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__9331_SHARP_){
var and__5090__auto__ = (function (){var G__9713 = x;
return (p1__9331_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9331_SHARP_.cljs$core$IFn$_invoke$arity$1(G__9713) : p1__9331_SHARP_.call(null,G__9713));
})();
if(cljs.core.truth_(and__5090__auto__)){
var and__5090__auto____$1 = (function (){var G__9715 = y;
return (p1__9331_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9331_SHARP_.cljs$core$IFn$_invoke$arity$1(G__9715) : p1__9331_SHARP_.call(null,G__9715));
})();
if(cljs.core.truth_(and__5090__auto____$1)){
var G__9716 = z;
return (p1__9331_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9331_SHARP_.cljs$core$IFn$_invoke$arity$1(G__9716) : p1__9331_SHARP_.call(null,G__9716));
} else {
return and__5090__auto____$1;
}
} else {
return and__5090__auto__;
}
});})(ps__$1))
,ps__$1);
});
var epn__4 = (function() { 
var G__9733__delegate = function (x,y,z,args){
return cljs.core.boolean$((epn.cljs$core$IFn$_invoke$arity$3(x,y,z)) && (cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__9332_SHARP_){
return cljs.core.every_QMARK_(p1__9332_SHARP_,args);
});})(ps__$1))
,ps__$1)));
};
var G__9733 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9734__i = 0, G__9734__a = new Array(arguments.length -  3);
while (G__9734__i < G__9734__a.length) {G__9734__a[G__9734__i] = arguments[G__9734__i + 3]; ++G__9734__i;}
  args = new cljs.core.IndexedSeq(G__9734__a,0);
} 
return G__9733__delegate.call(this,x,y,z,args);};
G__9733.cljs$lang$maxFixedArity = 3;
G__9733.cljs$lang$applyTo = (function (arglist__9735){
var x = cljs.core.first(arglist__9735);
arglist__9735 = cljs.core.next(arglist__9735);
var y = cljs.core.first(arglist__9735);
arglist__9735 = cljs.core.next(arglist__9735);
var z = cljs.core.first(arglist__9735);
var args = cljs.core.rest(arglist__9735);
return G__9733__delegate(x,y,z,args);
});
G__9733.cljs$core$IFn$_invoke$arity$variadic = G__9733__delegate;
return G__9733;
})()
;
epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return epn__0.call(this);
case 1:
return epn__1.call(this,x);
case 2:
return epn__2.call(this,x,y);
case 3:
return epn__3.call(this,x,y,z);
default:
var G__9736 = null;
if (arguments.length > 3) {
var G__9737__i = 0, G__9737__a = new Array(arguments.length -  3);
while (G__9737__i < G__9737__a.length) {G__9737__a[G__9737__i] = arguments[G__9737__i + 3]; ++G__9737__i;}
G__9736 = new cljs.core.IndexedSeq(G__9737__a,0);
}
return epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9736);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
epn.cljs$lang$maxFixedArity = 3;
epn.cljs$lang$applyTo = epn__4.cljs$lang$applyTo;
epn.cljs$core$IFn$_invoke$arity$0 = epn__0;
epn.cljs$core$IFn$_invoke$arity$1 = epn__1;
epn.cljs$core$IFn$_invoke$arity$2 = epn__2;
epn.cljs$core$IFn$_invoke$arity$3 = epn__3;
epn.cljs$core$IFn$_invoke$arity$variadic = epn__4.cljs$core$IFn$_invoke$arity$variadic;
return epn;
})()
;})(ps__$1))
};
var G__9732 = function (p1,p2,p3,var_args){
var ps = null;
if (arguments.length > 3) {
var G__9738__i = 0, G__9738__a = new Array(arguments.length -  3);
while (G__9738__i < G__9738__a.length) {G__9738__a[G__9738__i] = arguments[G__9738__i + 3]; ++G__9738__i;}
  ps = new cljs.core.IndexedSeq(G__9738__a,0);
} 
return G__9732__delegate.call(this,p1,p2,p3,ps);};
G__9732.cljs$lang$maxFixedArity = 3;
G__9732.cljs$lang$applyTo = (function (arglist__9739){
var p1 = cljs.core.first(arglist__9739);
arglist__9739 = cljs.core.next(arglist__9739);
var p2 = cljs.core.first(arglist__9739);
arglist__9739 = cljs.core.next(arglist__9739);
var p3 = cljs.core.first(arglist__9739);
var ps = cljs.core.rest(arglist__9739);
return G__9732__delegate(p1,p2,p3,ps);
});
G__9732.cljs$core$IFn$_invoke$arity$variadic = G__9732__delegate;
return G__9732;
})()
;
every_pred = function(p1,p2,p3,var_args){
var ps = var_args;
switch(arguments.length){
case 1:
return every_pred__1.call(this,p1);
case 2:
return every_pred__2.call(this,p1,p2);
case 3:
return every_pred__3.call(this,p1,p2,p3);
default:
var G__9740 = null;
if (arguments.length > 3) {
var G__9741__i = 0, G__9741__a = new Array(arguments.length -  3);
while (G__9741__i < G__9741__a.length) {G__9741__a[G__9741__i] = arguments[G__9741__i + 3]; ++G__9741__i;}
G__9740 = new cljs.core.IndexedSeq(G__9741__a,0);
}
return every_pred__4.cljs$core$IFn$_invoke$arity$variadic(p1,p2,p3, G__9740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
every_pred.cljs$lang$maxFixedArity = 3;
every_pred.cljs$lang$applyTo = every_pred__4.cljs$lang$applyTo;
every_pred.cljs$core$IFn$_invoke$arity$1 = every_pred__1;
every_pred.cljs$core$IFn$_invoke$arity$2 = every_pred__2;
every_pred.cljs$core$IFn$_invoke$arity$3 = every_pred__3;
every_pred.cljs$core$IFn$_invoke$arity$variadic = every_pred__4.cljs$core$IFn$_invoke$arity$variadic;
return every_pred;
})()
;
/**
* Takes a set of predicates and returns a function f that returns the first logical true value
* returned by one of its composing predicates against any of its arguments, else it returns
* logical false. Note that f is short-circuiting in that it will stop execution on the first
* argument that triggers a logical true result against the original predicates.
* @param {...*} var_args
*/
cljs.core.some_fn = (function() {
var some_fn = null;
var some_fn__1 = (function (p){
return (function() {
var sp1 = null;
var sp1__0 = (function (){
return null;
});
var sp1__1 = (function (x){
var G__9947 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__9947) : p.call(null,G__9947));
});
var sp1__2 = (function (x,y){
var or__5102__auto__ = (function (){var G__9949 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__9949) : p.call(null,G__9949));
})();
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
var G__9950 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__9950) : p.call(null,G__9950));
}
});
var sp1__3 = (function (x,y,z){
var or__5102__auto__ = (function (){var G__9952 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__9952) : p.call(null,G__9952));
})();
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (function (){var G__9954 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__9954) : p.call(null,G__9954));
})();
if(cljs.core.truth_(or__5102__auto____$1)){
return or__5102__auto____$1;
} else {
var G__9955 = z;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__9955) : p.call(null,G__9955));
}
}
});
var sp1__4 = (function() { 
var G__10116__delegate = function (x,y,z,args){
var or__5102__auto__ = sp1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
return cljs.core.some(p,args);
}
};
var G__10116 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__10117__i = 0, G__10117__a = new Array(arguments.length -  3);
while (G__10117__i < G__10117__a.length) {G__10117__a[G__10117__i] = arguments[G__10117__i + 3]; ++G__10117__i;}
  args = new cljs.core.IndexedSeq(G__10117__a,0);
} 
return G__10116__delegate.call(this,x,y,z,args);};
G__10116.cljs$lang$maxFixedArity = 3;
G__10116.cljs$lang$applyTo = (function (arglist__10118){
var x = cljs.core.first(arglist__10118);
arglist__10118 = cljs.core.next(arglist__10118);
var y = cljs.core.first(arglist__10118);
arglist__10118 = cljs.core.next(arglist__10118);
var z = cljs.core.first(arglist__10118);
var args = cljs.core.rest(arglist__10118);
return G__10116__delegate(x,y,z,args);
});
G__10116.cljs$core$IFn$_invoke$arity$variadic = G__10116__delegate;
return G__10116;
})()
;
sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return sp1__0.call(this);
case 1:
return sp1__1.call(this,x);
case 2:
return sp1__2.call(this,x,y);
case 3:
return sp1__3.call(this,x,y,z);
default:
var G__10119 = null;
if (arguments.length > 3) {
var G__10120__i = 0, G__10120__a = new Array(arguments.length -  3);
while (G__10120__i < G__10120__a.length) {G__10120__a[G__10120__i] = arguments[G__10120__i + 3]; ++G__10120__i;}
G__10119 = new cljs.core.IndexedSeq(G__10120__a,0);
}
return sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__10119);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sp1.cljs$lang$maxFixedArity = 3;
sp1.cljs$lang$applyTo = sp1__4.cljs$lang$applyTo;
sp1.cljs$core$IFn$_invoke$arity$0 = sp1__0;
sp1.cljs$core$IFn$_invoke$arity$1 = sp1__1;
sp1.cljs$core$IFn$_invoke$arity$2 = sp1__2;
sp1.cljs$core$IFn$_invoke$arity$3 = sp1__3;
sp1.cljs$core$IFn$_invoke$arity$variadic = sp1__4.cljs$core$IFn$_invoke$arity$variadic;
return sp1;
})()
});
var some_fn__2 = (function (p1,p2){
return (function() {
var sp2 = null;
var sp2__0 = (function (){
return null;
});
var sp2__1 = (function (x){
var or__5102__auto__ = (function (){var G__9987 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9987) : p1.call(null,G__9987));
})();
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
var G__9988 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9988) : p2.call(null,G__9988));
}
});
var sp2__2 = (function (x,y){
var or__5102__auto__ = (function (){var G__9990 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9990) : p1.call(null,G__9990));
})();
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (function (){var G__9992 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9992) : p1.call(null,G__9992));
})();
if(cljs.core.truth_(or__5102__auto____$1)){
return or__5102__auto____$1;
} else {
var or__5102__auto____$2 = (function (){var G__9994 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9994) : p2.call(null,G__9994));
})();
if(cljs.core.truth_(or__5102__auto____$2)){
return or__5102__auto____$2;
} else {
var G__9995 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__9995) : p2.call(null,G__9995));
}
}
}
});
var sp2__3 = (function (x,y,z){
var or__5102__auto__ = (function (){var G__9997 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9997) : p1.call(null,G__9997));
})();
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (function (){var G__9999 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__9999) : p1.call(null,G__9999));
})();
if(cljs.core.truth_(or__5102__auto____$1)){
return or__5102__auto____$1;
} else {
var or__5102__auto____$2 = (function (){var G__10001 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10001) : p1.call(null,G__10001));
})();
if(cljs.core.truth_(or__5102__auto____$2)){
return or__5102__auto____$2;
} else {
var or__5102__auto____$3 = (function (){var G__10003 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10003) : p2.call(null,G__10003));
})();
if(cljs.core.truth_(or__5102__auto____$3)){
return or__5102__auto____$3;
} else {
var or__5102__auto____$4 = (function (){var G__10005 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10005) : p2.call(null,G__10005));
})();
if(cljs.core.truth_(or__5102__auto____$4)){
return or__5102__auto____$4;
} else {
var G__10006 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10006) : p2.call(null,G__10006));
}
}
}
}
}
});
var sp2__4 = (function() { 
var G__10121__delegate = function (x,y,z,args){
var or__5102__auto__ = sp2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
return cljs.core.some(((function (or__5102__auto__){
return (function (p1__9742_SHARP_){
var or__5102__auto____$1 = (function (){var G__10008 = p1__9742_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10008) : p1.call(null,G__10008));
})();
if(cljs.core.truth_(or__5102__auto____$1)){
return or__5102__auto____$1;
} else {
var G__10009 = p1__9742_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10009) : p2.call(null,G__10009));
}
});})(or__5102__auto__))
,args);
}
};
var G__10121 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__10122__i = 0, G__10122__a = new Array(arguments.length -  3);
while (G__10122__i < G__10122__a.length) {G__10122__a[G__10122__i] = arguments[G__10122__i + 3]; ++G__10122__i;}
  args = new cljs.core.IndexedSeq(G__10122__a,0);
} 
return G__10121__delegate.call(this,x,y,z,args);};
G__10121.cljs$lang$maxFixedArity = 3;
G__10121.cljs$lang$applyTo = (function (arglist__10123){
var x = cljs.core.first(arglist__10123);
arglist__10123 = cljs.core.next(arglist__10123);
var y = cljs.core.first(arglist__10123);
arglist__10123 = cljs.core.next(arglist__10123);
var z = cljs.core.first(arglist__10123);
var args = cljs.core.rest(arglist__10123);
return G__10121__delegate(x,y,z,args);
});
G__10121.cljs$core$IFn$_invoke$arity$variadic = G__10121__delegate;
return G__10121;
})()
;
sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return sp2__0.call(this);
case 1:
return sp2__1.call(this,x);
case 2:
return sp2__2.call(this,x,y);
case 3:
return sp2__3.call(this,x,y,z);
default:
var G__10124 = null;
if (arguments.length > 3) {
var G__10125__i = 0, G__10125__a = new Array(arguments.length -  3);
while (G__10125__i < G__10125__a.length) {G__10125__a[G__10125__i] = arguments[G__10125__i + 3]; ++G__10125__i;}
G__10124 = new cljs.core.IndexedSeq(G__10125__a,0);
}
return sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__10124);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sp2.cljs$lang$maxFixedArity = 3;
sp2.cljs$lang$applyTo = sp2__4.cljs$lang$applyTo;
sp2.cljs$core$IFn$_invoke$arity$0 = sp2__0;
sp2.cljs$core$IFn$_invoke$arity$1 = sp2__1;
sp2.cljs$core$IFn$_invoke$arity$2 = sp2__2;
sp2.cljs$core$IFn$_invoke$arity$3 = sp2__3;
sp2.cljs$core$IFn$_invoke$arity$variadic = sp2__4.cljs$core$IFn$_invoke$arity$variadic;
return sp2;
})()
});
var some_fn__3 = (function (p1,p2,p3){
return (function() {
var sp3 = null;
var sp3__0 = (function (){
return null;
});
var sp3__1 = (function (x){
var or__5102__auto__ = (function (){var G__10055 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10055) : p1.call(null,G__10055));
})();
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (function (){var G__10057 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10057) : p2.call(null,G__10057));
})();
if(cljs.core.truth_(or__5102__auto____$1)){
return or__5102__auto____$1;
} else {
var G__10058 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10058) : p3.call(null,G__10058));
}
}
});
var sp3__2 = (function (x,y){
var or__5102__auto__ = (function (){var G__10060 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10060) : p1.call(null,G__10060));
})();
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (function (){var G__10062 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10062) : p2.call(null,G__10062));
})();
if(cljs.core.truth_(or__5102__auto____$1)){
return or__5102__auto____$1;
} else {
var or__5102__auto____$2 = (function (){var G__10064 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10064) : p3.call(null,G__10064));
})();
if(cljs.core.truth_(or__5102__auto____$2)){
return or__5102__auto____$2;
} else {
var or__5102__auto____$3 = (function (){var G__10066 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10066) : p1.call(null,G__10066));
})();
if(cljs.core.truth_(or__5102__auto____$3)){
return or__5102__auto____$3;
} else {
var or__5102__auto____$4 = (function (){var G__10068 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10068) : p2.call(null,G__10068));
})();
if(cljs.core.truth_(or__5102__auto____$4)){
return or__5102__auto____$4;
} else {
var G__10069 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10069) : p3.call(null,G__10069));
}
}
}
}
}
});
var sp3__3 = (function (x,y,z){
var or__5102__auto__ = (function (){var G__10071 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10071) : p1.call(null,G__10071));
})();
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (function (){var G__10073 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10073) : p2.call(null,G__10073));
})();
if(cljs.core.truth_(or__5102__auto____$1)){
return or__5102__auto____$1;
} else {
var or__5102__auto____$2 = (function (){var G__10075 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10075) : p3.call(null,G__10075));
})();
if(cljs.core.truth_(or__5102__auto____$2)){
return or__5102__auto____$2;
} else {
var or__5102__auto____$3 = (function (){var G__10077 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10077) : p1.call(null,G__10077));
})();
if(cljs.core.truth_(or__5102__auto____$3)){
return or__5102__auto____$3;
} else {
var or__5102__auto____$4 = (function (){var G__10079 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10079) : p2.call(null,G__10079));
})();
if(cljs.core.truth_(or__5102__auto____$4)){
return or__5102__auto____$4;
} else {
var or__5102__auto____$5 = (function (){var G__10081 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10081) : p3.call(null,G__10081));
})();
if(cljs.core.truth_(or__5102__auto____$5)){
return or__5102__auto____$5;
} else {
var or__5102__auto____$6 = (function (){var G__10083 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10083) : p1.call(null,G__10083));
})();
if(cljs.core.truth_(or__5102__auto____$6)){
return or__5102__auto____$6;
} else {
var or__5102__auto____$7 = (function (){var G__10085 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10085) : p2.call(null,G__10085));
})();
if(cljs.core.truth_(or__5102__auto____$7)){
return or__5102__auto____$7;
} else {
var G__10086 = z;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10086) : p3.call(null,G__10086));
}
}
}
}
}
}
}
}
});
var sp3__4 = (function() { 
var G__10126__delegate = function (x,y,z,args){
var or__5102__auto__ = sp3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
return cljs.core.some(((function (or__5102__auto__){
return (function (p1__9743_SHARP_){
var or__5102__auto____$1 = (function (){var G__10088 = p1__9743_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10088) : p1.call(null,G__10088));
})();
if(cljs.core.truth_(or__5102__auto____$1)){
return or__5102__auto____$1;
} else {
var or__5102__auto____$2 = (function (){var G__10090 = p1__9743_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10090) : p2.call(null,G__10090));
})();
if(cljs.core.truth_(or__5102__auto____$2)){
return or__5102__auto____$2;
} else {
var G__10091 = p1__9743_SHARP_;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10091) : p3.call(null,G__10091));
}
}
});})(or__5102__auto__))
,args);
}
};
var G__10126 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__10127__i = 0, G__10127__a = new Array(arguments.length -  3);
while (G__10127__i < G__10127__a.length) {G__10127__a[G__10127__i] = arguments[G__10127__i + 3]; ++G__10127__i;}
  args = new cljs.core.IndexedSeq(G__10127__a,0);
} 
return G__10126__delegate.call(this,x,y,z,args);};
G__10126.cljs$lang$maxFixedArity = 3;
G__10126.cljs$lang$applyTo = (function (arglist__10128){
var x = cljs.core.first(arglist__10128);
arglist__10128 = cljs.core.next(arglist__10128);
var y = cljs.core.first(arglist__10128);
arglist__10128 = cljs.core.next(arglist__10128);
var z = cljs.core.first(arglist__10128);
var args = cljs.core.rest(arglist__10128);
return G__10126__delegate(x,y,z,args);
});
G__10126.cljs$core$IFn$_invoke$arity$variadic = G__10126__delegate;
return G__10126;
})()
;
sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return sp3__0.call(this);
case 1:
return sp3__1.call(this,x);
case 2:
return sp3__2.call(this,x,y);
case 3:
return sp3__3.call(this,x,y,z);
default:
var G__10129 = null;
if (arguments.length > 3) {
var G__10130__i = 0, G__10130__a = new Array(arguments.length -  3);
while (G__10130__i < G__10130__a.length) {G__10130__a[G__10130__i] = arguments[G__10130__i + 3]; ++G__10130__i;}
G__10129 = new cljs.core.IndexedSeq(G__10130__a,0);
}
return sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__10129);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sp3.cljs$lang$maxFixedArity = 3;
sp3.cljs$lang$applyTo = sp3__4.cljs$lang$applyTo;
sp3.cljs$core$IFn$_invoke$arity$0 = sp3__0;
sp3.cljs$core$IFn$_invoke$arity$1 = sp3__1;
sp3.cljs$core$IFn$_invoke$arity$2 = sp3__2;
sp3.cljs$core$IFn$_invoke$arity$3 = sp3__3;
sp3.cljs$core$IFn$_invoke$arity$variadic = sp3__4.cljs$core$IFn$_invoke$arity$variadic;
return sp3;
})()
});
var some_fn__4 = (function() { 
var G__10131__delegate = function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var spn = null;
var spn__0 = (function (){
return null;
});
var spn__1 = (function (x){
return cljs.core.some(((function (ps__$1){
return (function (p1__9744_SHARP_){
var G__10107 = x;
return (p1__9744_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9744_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10107) : p1__9744_SHARP_.call(null,G__10107));
});})(ps__$1))
,ps__$1);
});
var spn__2 = (function (x,y){
return cljs.core.some(((function (ps__$1){
return (function (p1__9745_SHARP_){
var or__5102__auto__ = (function (){var G__10109 = x;
return (p1__9745_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9745_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10109) : p1__9745_SHARP_.call(null,G__10109));
})();
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
var G__10110 = y;
return (p1__9745_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9745_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10110) : p1__9745_SHARP_.call(null,G__10110));
}
});})(ps__$1))
,ps__$1);
});
var spn__3 = (function (x,y,z){
return cljs.core.some(((function (ps__$1){
return (function (p1__9746_SHARP_){
var or__5102__auto__ = (function (){var G__10112 = x;
return (p1__9746_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9746_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10112) : p1__9746_SHARP_.call(null,G__10112));
})();
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (function (){var G__10114 = y;
return (p1__9746_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9746_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10114) : p1__9746_SHARP_.call(null,G__10114));
})();
if(cljs.core.truth_(or__5102__auto____$1)){
return or__5102__auto____$1;
} else {
var G__10115 = z;
return (p1__9746_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9746_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10115) : p1__9746_SHARP_.call(null,G__10115));
}
}
});})(ps__$1))
,ps__$1);
});
var spn__4 = (function() { 
var G__10132__delegate = function (x,y,z,args){
var or__5102__auto__ = spn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
return cljs.core.some(((function (or__5102__auto__,ps__$1){
return (function (p1__9747_SHARP_){
return cljs.core.some(p1__9747_SHARP_,args);
});})(or__5102__auto__,ps__$1))
,ps__$1);
}
};
var G__10132 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__10133__i = 0, G__10133__a = new Array(arguments.length -  3);
while (G__10133__i < G__10133__a.length) {G__10133__a[G__10133__i] = arguments[G__10133__i + 3]; ++G__10133__i;}
  args = new cljs.core.IndexedSeq(G__10133__a,0);
} 
return G__10132__delegate.call(this,x,y,z,args);};
G__10132.cljs$lang$maxFixedArity = 3;
G__10132.cljs$lang$applyTo = (function (arglist__10134){
var x = cljs.core.first(arglist__10134);
arglist__10134 = cljs.core.next(arglist__10134);
var y = cljs.core.first(arglist__10134);
arglist__10134 = cljs.core.next(arglist__10134);
var z = cljs.core.first(arglist__10134);
var args = cljs.core.rest(arglist__10134);
return G__10132__delegate(x,y,z,args);
});
G__10132.cljs$core$IFn$_invoke$arity$variadic = G__10132__delegate;
return G__10132;
})()
;
spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return spn__0.call(this);
case 1:
return spn__1.call(this,x);
case 2:
return spn__2.call(this,x,y);
case 3:
return spn__3.call(this,x,y,z);
default:
var G__10135 = null;
if (arguments.length > 3) {
var G__10136__i = 0, G__10136__a = new Array(arguments.length -  3);
while (G__10136__i < G__10136__a.length) {G__10136__a[G__10136__i] = arguments[G__10136__i + 3]; ++G__10136__i;}
G__10135 = new cljs.core.IndexedSeq(G__10136__a,0);
}
return spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__10135);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
spn.cljs$lang$maxFixedArity = 3;
spn.cljs$lang$applyTo = spn__4.cljs$lang$applyTo;
spn.cljs$core$IFn$_invoke$arity$0 = spn__0;
spn.cljs$core$IFn$_invoke$arity$1 = spn__1;
spn.cljs$core$IFn$_invoke$arity$2 = spn__2;
spn.cljs$core$IFn$_invoke$arity$3 = spn__3;
spn.cljs$core$IFn$_invoke$arity$variadic = spn__4.cljs$core$IFn$_invoke$arity$variadic;
return spn;
})()
;})(ps__$1))
};
var G__10131 = function (p1,p2,p3,var_args){
var ps = null;
if (arguments.length > 3) {
var G__10137__i = 0, G__10137__a = new Array(arguments.length -  3);
while (G__10137__i < G__10137__a.length) {G__10137__a[G__10137__i] = arguments[G__10137__i + 3]; ++G__10137__i;}
  ps = new cljs.core.IndexedSeq(G__10137__a,0);
} 
return G__10131__delegate.call(this,p1,p2,p3,ps);};
G__10131.cljs$lang$maxFixedArity = 3;
G__10131.cljs$lang$applyTo = (function (arglist__10138){
var p1 = cljs.core.first(arglist__10138);
arglist__10138 = cljs.core.next(arglist__10138);
var p2 = cljs.core.first(arglist__10138);
arglist__10138 = cljs.core.next(arglist__10138);
var p3 = cljs.core.first(arglist__10138);
var ps = cljs.core.rest(arglist__10138);
return G__10131__delegate(p1,p2,p3,ps);
});
G__10131.cljs$core$IFn$_invoke$arity$variadic = G__10131__delegate;
return G__10131;
})()
;
some_fn = function(p1,p2,p3,var_args){
var ps = var_args;
switch(arguments.length){
case 1:
return some_fn__1.call(this,p1);
case 2:
return some_fn__2.call(this,p1,p2);
case 3:
return some_fn__3.call(this,p1,p2,p3);
default:
var G__10139 = null;
if (arguments.length > 3) {
var G__10140__i = 0, G__10140__a = new Array(arguments.length -  3);
while (G__10140__i < G__10140__a.length) {G__10140__a[G__10140__i] = arguments[G__10140__i + 3]; ++G__10140__i;}
G__10139 = new cljs.core.IndexedSeq(G__10140__a,0);
}
return some_fn__4.cljs$core$IFn$_invoke$arity$variadic(p1,p2,p3, G__10139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
some_fn.cljs$lang$maxFixedArity = 3;
some_fn.cljs$lang$applyTo = some_fn__4.cljs$lang$applyTo;
some_fn.cljs$core$IFn$_invoke$arity$1 = some_fn__1;
some_fn.cljs$core$IFn$_invoke$arity$2 = some_fn__2;
some_fn.cljs$core$IFn$_invoke$arity$3 = some_fn__3;
some_fn.cljs$core$IFn$_invoke$arity$variadic = some_fn__4.cljs$core$IFn$_invoke$arity$variadic;
return some_fn;
})()
;
/**
* Returns a lazy sequence consisting of the result of applying f to
* the set of first items of each coll, followed by applying f to the
* set of second items in each coll, until any one of the colls is
* exhausted.  Any remaining items in other colls are ignored. Function
* f should accept number-of-colls arguments. Returns a transducer when
* no collection is provided.
* @param {...*} var_args
*/
cljs.core.map = (function() {
var map = null;
var map__1 = (function (f){
return (function (rf){
return (function() {
var G__10195 = null;
var G__10195__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__10195__1 = (function (result){
var G__10181 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10181) : rf.call(null,G__10181));
});
var G__10195__2 = (function (result,input){
var G__10182 = result;
var G__10183 = (function (){var G__10184 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10184) : f.call(null,G__10184));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10182,G__10183) : rf.call(null,G__10182,G__10183));
});
var G__10195__3 = (function() { 
var G__10196__delegate = function (result,input,inputs){
var G__10185 = result;
var G__10186 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,input,inputs);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10185,G__10186) : rf.call(null,G__10185,G__10186));
};
var G__10196 = function (result,input,var_args){
var inputs = null;
if (arguments.length > 2) {
var G__10197__i = 0, G__10197__a = new Array(arguments.length -  2);
while (G__10197__i < G__10197__a.length) {G__10197__a[G__10197__i] = arguments[G__10197__i + 2]; ++G__10197__i;}
  inputs = new cljs.core.IndexedSeq(G__10197__a,0);
} 
return G__10196__delegate.call(this,result,input,inputs);};
G__10196.cljs$lang$maxFixedArity = 2;
G__10196.cljs$lang$applyTo = (function (arglist__10198){
var result = cljs.core.first(arglist__10198);
arglist__10198 = cljs.core.next(arglist__10198);
var input = cljs.core.first(arglist__10198);
var inputs = cljs.core.rest(arglist__10198);
return G__10196__delegate(result,input,inputs);
});
G__10196.cljs$core$IFn$_invoke$arity$variadic = G__10196__delegate;
return G__10196;
})()
;
G__10195 = function(result,input,var_args){
var inputs = var_args;
switch(arguments.length){
case 0:
return G__10195__0.call(this);
case 1:
return G__10195__1.call(this,result);
case 2:
return G__10195__2.call(this,result,input);
default:
var G__10199 = null;
if (arguments.length > 2) {
var G__10200__i = 0, G__10200__a = new Array(arguments.length -  2);
while (G__10200__i < G__10200__a.length) {G__10200__a[G__10200__i] = arguments[G__10200__i + 2]; ++G__10200__i;}
G__10199 = new cljs.core.IndexedSeq(G__10200__a,0);
}
return G__10195__3.cljs$core$IFn$_invoke$arity$variadic(result,input, G__10199);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10195.cljs$lang$maxFixedArity = 2;
G__10195.cljs$lang$applyTo = G__10195__3.cljs$lang$applyTo;
G__10195.cljs$core$IFn$_invoke$arity$0 = G__10195__0;
G__10195.cljs$core$IFn$_invoke$arity$1 = G__10195__1;
G__10195.cljs$core$IFn$_invoke$arity$2 = G__10195__2;
G__10195.cljs$core$IFn$_invoke$arity$variadic = G__10195__3.cljs$core$IFn$_invoke$arity$variadic;
return G__10195;
})()
});
});
var map__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5989__auto___10201 = size;
var i_10202 = (0);
while(true){
if((i_10202 < n__5989__auto___10201)){
cljs.core.chunk_append(b,(function (){var G__10187 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_10202);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10187) : f.call(null,G__10187));
})());

var G__10203 = (i_10202 + (1));
i_10202 = G__10203;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__10188 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10188) : f.call(null,G__10188));
})(),map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
var map__3 = (function (f,c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons((function (){var G__10189 = cljs.core.first(s1);
var G__10190 = cljs.core.first(s2);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10189,G__10190) : f.call(null,G__10189,G__10190));
})(),map.cljs$core$IFn$_invoke$arity$3(f,cljs.core.rest(s1),cljs.core.rest(s2)));
} else {
return null;
}
}),null,null));
});
var map__4 = (function (f,c1,c2,c3){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
var s3 = cljs.core.seq(c3);
if((s1) && (s2) && (s3)){
return cljs.core.cons((function (){var G__10191 = cljs.core.first(s1);
var G__10192 = cljs.core.first(s2);
var G__10193 = cljs.core.first(s3);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10191,G__10192,G__10193) : f.call(null,G__10191,G__10192,G__10193));
})(),map.cljs$core$IFn$_invoke$arity$4(f,cljs.core.rest(s1),cljs.core.rest(s2),cljs.core.rest(s3)));
} else {
return null;
}
}),null,null));
});
var map__5 = (function() { 
var G__10204__delegate = function (f,c1,c2,c3,colls){
var step = (function step(cs){
return (new cljs.core.LazySeq(null,(function (){
var ss = map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cs);
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.cons(map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),step(map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});
return map.cljs$core$IFn$_invoke$arity$2(((function (step){
return (function (p1__10141_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,p1__10141_SHARP_);
});})(step))
,step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c3,cljs.core.array_seq([c2,c1], 0))));
};
var G__10204 = function (f,c1,c2,c3,var_args){
var colls = null;
if (arguments.length > 4) {
var G__10205__i = 0, G__10205__a = new Array(arguments.length -  4);
while (G__10205__i < G__10205__a.length) {G__10205__a[G__10205__i] = arguments[G__10205__i + 4]; ++G__10205__i;}
  colls = new cljs.core.IndexedSeq(G__10205__a,0);
} 
return G__10204__delegate.call(this,f,c1,c2,c3,colls);};
G__10204.cljs$lang$maxFixedArity = 4;
G__10204.cljs$lang$applyTo = (function (arglist__10206){
var f = cljs.core.first(arglist__10206);
arglist__10206 = cljs.core.next(arglist__10206);
var c1 = cljs.core.first(arglist__10206);
arglist__10206 = cljs.core.next(arglist__10206);
var c2 = cljs.core.first(arglist__10206);
arglist__10206 = cljs.core.next(arglist__10206);
var c3 = cljs.core.first(arglist__10206);
var colls = cljs.core.rest(arglist__10206);
return G__10204__delegate(f,c1,c2,c3,colls);
});
G__10204.cljs$core$IFn$_invoke$arity$variadic = G__10204__delegate;
return G__10204;
})()
;
map = function(f,c1,c2,c3,var_args){
var colls = var_args;
switch(arguments.length){
case 1:
return map__1.call(this,f);
case 2:
return map__2.call(this,f,c1);
case 3:
return map__3.call(this,f,c1,c2);
case 4:
return map__4.call(this,f,c1,c2,c3);
default:
var G__10207 = null;
if (arguments.length > 4) {
var G__10208__i = 0, G__10208__a = new Array(arguments.length -  4);
while (G__10208__i < G__10208__a.length) {G__10208__a[G__10208__i] = arguments[G__10208__i + 4]; ++G__10208__i;}
G__10207 = new cljs.core.IndexedSeq(G__10208__a,0);
}
return map__5.cljs$core$IFn$_invoke$arity$variadic(f,c1,c2,c3, G__10207);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
map.cljs$lang$maxFixedArity = 4;
map.cljs$lang$applyTo = map__5.cljs$lang$applyTo;
map.cljs$core$IFn$_invoke$arity$1 = map__1;
map.cljs$core$IFn$_invoke$arity$2 = map__2;
map.cljs$core$IFn$_invoke$arity$3 = map__3;
map.cljs$core$IFn$_invoke$arity$4 = map__4;
map.cljs$core$IFn$_invoke$arity$variadic = map__5.cljs$core$IFn$_invoke$arity$variadic;
return map;
})()
;
/**
* Returns a lazy sequence of the first n items in coll, or all items if
* there are fewer than n.  Returns a stateful transducer when
* no collection is provided.
*/
cljs.core.take = (function() {
var take = null;
var take__1 = (function (n){
return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__10217 = null;
var G__10217__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__10217__1 = (function (result){
var G__10214 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10214) : rf.call(null,G__10214));
});
var G__10217__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
var nn = na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));
var result__$1 = (((n__$1 > (0)))?(function (){var G__10215 = result;
var G__10216 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10215,G__10216) : rf.call(null,G__10215,G__10216));
})():result);
if(!((nn > (0)))){
return cljs.core.ensure_reduced(result__$1);
} else {
return result__$1;
}
});
G__10217 = function(result,input){
switch(arguments.length){
case 0:
return G__10217__0.call(this);
case 1:
return G__10217__1.call(this,result);
case 2:
return G__10217__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10217.cljs$core$IFn$_invoke$arity$0 = G__10217__0;
G__10217.cljs$core$IFn$_invoke$arity$1 = G__10217__1;
G__10217.cljs$core$IFn$_invoke$arity$2 = G__10217__2;
return G__10217;
})()
;})(na))
});
});
var take__2 = (function (n,coll){
return (new cljs.core.LazySeq(null,(function (){
if((n > (0))){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.cons(cljs.core.first(s),take.cljs$core$IFn$_invoke$arity$2((n - (1)),cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});
take = function(n,coll){
switch(arguments.length){
case 1:
return take__1.call(this,n);
case 2:
return take__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take.cljs$core$IFn$_invoke$arity$1 = take__1;
take.cljs$core$IFn$_invoke$arity$2 = take__2;
return take;
})()
;
/**
* Returns a lazy sequence of all but the first n items in coll.
* Returns a stateful transducer when no collection is provided.
*/
cljs.core.drop = (function() {
var drop = null;
var drop__1 = (function (n){
return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__10224 = null;
var G__10224__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__10224__1 = (function (result){
var G__10221 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10221) : rf.call(null,G__10221));
});
var G__10224__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));

if((n__$1 > (0))){
return result;
} else {
var G__10222 = result;
var G__10223 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10222,G__10223) : rf.call(null,G__10222,G__10223));
}
});
G__10224 = function(result,input){
switch(arguments.length){
case 0:
return G__10224__0.call(this);
case 1:
return G__10224__1.call(this,result);
case 2:
return G__10224__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10224.cljs$core$IFn$_invoke$arity$0 = G__10224__0;
G__10224.cljs$core$IFn$_invoke$arity$1 = G__10224__1;
G__10224.cljs$core$IFn$_invoke$arity$2 = G__10224__2;
return G__10224;
})()
;})(na))
});
});
var drop__2 = (function (n,coll){
var step = (function (n__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(((n__$1 > (0))) && (s)){
var G__10225 = (n__$1 - (1));
var G__10226 = cljs.core.rest(s);
n__$1 = G__10225;
coll__$1 = G__10226;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(n,coll);
});})(step))
,null,null));
});
drop = function(n,coll){
switch(arguments.length){
case 1:
return drop__1.call(this,n);
case 2:
return drop__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
drop.cljs$core$IFn$_invoke$arity$1 = drop__1;
drop.cljs$core$IFn$_invoke$arity$2 = drop__2;
return drop;
})()
;
/**
* Return a lazy sequence of all but the last n (default 1) items in coll
*/
cljs.core.drop_last = (function() {
var drop_last = null;
var drop_last__1 = (function (s){
return drop_last.cljs$core$IFn$_invoke$arity$2((1),s);
});
var drop_last__2 = (function (n,s){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((function (x,_){
return x;
}),s,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
});
drop_last = function(n,s){
switch(arguments.length){
case 1:
return drop_last__1.call(this,n);
case 2:
return drop_last__2.call(this,n,s);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
drop_last.cljs$core$IFn$_invoke$arity$1 = drop_last__1;
drop_last.cljs$core$IFn$_invoke$arity$2 = drop_last__2;
return drop_last;
})()
;
/**
* Returns a seq of the last n items in coll.  Depending on the type
* of coll may be no better than linear time.  For vectors, see also subvec.
*/
cljs.core.take_last = (function take_last(n,coll){
var s = cljs.core.seq(coll);
var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll));
while(true){
if(lead){
var G__10229 = cljs.core.next(s);
var G__10230 = cljs.core.next(lead);
s = G__10229;
lead = G__10230;
continue;
} else {
return s;
}
break;
}
});
/**
* Returns a lazy sequence of the items in coll starting from the
* first item for which (pred item) returns logical false.  Returns a
* stateful transducer when no collection is provided.
*/
cljs.core.drop_while = (function() {
var drop_while = null;
var drop_while__1 = (function (pred){
return (function (rf){
var da = cljs.core.volatile_BANG_(true);
return ((function (da){
return (function() {
var G__10243 = null;
var G__10243__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__10243__1 = (function (result){
var G__10237 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10237) : rf.call(null,G__10237));
});
var G__10243__2 = (function (result,input){
var drop_QMARK_ = cljs.core.deref(da);
if(cljs.core.truth_((function (){var and__5090__auto__ = drop_QMARK_;
if(cljs.core.truth_(and__5090__auto__)){
var G__10238 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__10238) : pred.call(null,G__10238));
} else {
return and__5090__auto__;
}
})())){
return result;
} else {
cljs.core.vreset_BANG_(da,null);

var G__10239 = result;
var G__10240 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10239,G__10240) : rf.call(null,G__10239,G__10240));
}
});
G__10243 = function(result,input){
switch(arguments.length){
case 0:
return G__10243__0.call(this);
case 1:
return G__10243__1.call(this,result);
case 2:
return G__10243__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10243.cljs$core$IFn$_invoke$arity$0 = G__10243__0;
G__10243.cljs$core$IFn$_invoke$arity$1 = G__10243__1;
G__10243.cljs$core$IFn$_invoke$arity$2 = G__10243__2;
return G__10243;
})()
;})(da))
});
});
var drop_while__2 = (function (pred,coll){
var step = (function (pred__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(cljs.core.truth_((function (){var and__5090__auto__ = s;
if(and__5090__auto__){
var G__10242 = cljs.core.first(s);
return (pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__10242) : pred__$1.call(null,G__10242));
} else {
return and__5090__auto__;
}
})())){
var G__10244 = pred__$1;
var G__10245 = cljs.core.rest(s);
pred__$1 = G__10244;
coll__$1 = G__10245;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(pred,coll);
});})(step))
,null,null));
});
drop_while = function(pred,coll){
switch(arguments.length){
case 1:
return drop_while__1.call(this,pred);
case 2:
return drop_while__2.call(this,pred,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
drop_while.cljs$core$IFn$_invoke$arity$1 = drop_while__1;
drop_while.cljs$core$IFn$_invoke$arity$2 = drop_while__2;
return drop_while;
})()
;
/**
* Returns a lazy (infinite!) sequence of repetitions of the items in coll.
*/
cljs.core.cycle = (function cycle(coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(s,cycle(s));
} else {
return null;
}
}),null,null));
});
/**
* Returns a vector of [(take n coll) (drop n coll)]
*/
cljs.core.split_at = (function split_at(n,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll)], null);
});
/**
* Returns a lazy (infinite!, or length n if supplied) sequence of xs.
*/
cljs.core.repeat = (function() {
var repeat = null;
var repeat__1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(x,repeat.cljs$core$IFn$_invoke$arity$1(x));
}),null,null));
});
var repeat__2 = (function (n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,repeat.cljs$core$IFn$_invoke$arity$1(x));
});
repeat = function(n,x){
switch(arguments.length){
case 1:
return repeat__1.call(this,n);
case 2:
return repeat__2.call(this,n,x);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
repeat.cljs$core$IFn$_invoke$arity$1 = repeat__1;
repeat.cljs$core$IFn$_invoke$arity$2 = repeat__2;
return repeat;
})()
;
/**
* Returns a lazy seq of n xs.
*/
cljs.core.replicate = (function replicate(n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});
/**
* Takes a function of no args, presumably with side effects, and
* returns an infinite (or length n if supplied) lazy sequence of calls
* to it
*/
cljs.core.repeatedly = (function() {
var repeatedly = null;
var repeatedly__1 = (function (f){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}),null,null));
});
var repeatedly__2 = (function (n,f){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,repeatedly.cljs$core$IFn$_invoke$arity$1(f));
});
repeatedly = function(n,f){
switch(arguments.length){
case 1:
return repeatedly__1.call(this,n);
case 2:
return repeatedly__2.call(this,n,f);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
repeatedly.cljs$core$IFn$_invoke$arity$1 = repeatedly__1;
repeatedly.cljs$core$IFn$_invoke$arity$2 = repeatedly__2;
return repeatedly;
})()
;
/**
* Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
*/
cljs.core.iterate = (function iterate(f,x){
return cljs.core.cons(x,(new cljs.core.LazySeq(null,(function (){
return iterate(f,(function (){var G__10254 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10254) : f.call(null,G__10254));
})());
}),null,null)));
});
/**
* Returns a lazy seq of the first item in each coll, then the second etc.
* @param {...*} var_args
*/
cljs.core.interleave = (function() {
var interleave = null;
var interleave__2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
return null;
}
}),null,null));
});
var interleave__3 = (function() { 
var G__10257__delegate = function (c1,c2,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.array_seq([c1], 0)));
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(interleave,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
};
var G__10257 = function (c1,c2,var_args){
var colls = null;
if (arguments.length > 2) {
var G__10258__i = 0, G__10258__a = new Array(arguments.length -  2);
while (G__10258__i < G__10258__a.length) {G__10258__a[G__10258__i] = arguments[G__10258__i + 2]; ++G__10258__i;}
  colls = new cljs.core.IndexedSeq(G__10258__a,0);
} 
return G__10257__delegate.call(this,c1,c2,colls);};
G__10257.cljs$lang$maxFixedArity = 2;
G__10257.cljs$lang$applyTo = (function (arglist__10259){
var c1 = cljs.core.first(arglist__10259);
arglist__10259 = cljs.core.next(arglist__10259);
var c2 = cljs.core.first(arglist__10259);
var colls = cljs.core.rest(arglist__10259);
return G__10257__delegate(c1,c2,colls);
});
G__10257.cljs$core$IFn$_invoke$arity$variadic = G__10257__delegate;
return G__10257;
})()
;
interleave = function(c1,c2,var_args){
var colls = var_args;
switch(arguments.length){
case 2:
return interleave__2.call(this,c1,c2);
default:
var G__10260 = null;
if (arguments.length > 2) {
var G__10261__i = 0, G__10261__a = new Array(arguments.length -  2);
while (G__10261__i < G__10261__a.length) {G__10261__a[G__10261__i] = arguments[G__10261__i + 2]; ++G__10261__i;}
G__10260 = new cljs.core.IndexedSeq(G__10261__a,0);
}
return interleave__3.cljs$core$IFn$_invoke$arity$variadic(c1,c2, G__10260);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
interleave.cljs$lang$maxFixedArity = 2;
interleave.cljs$lang$applyTo = interleave__3.cljs$lang$applyTo;
interleave.cljs$core$IFn$_invoke$arity$2 = interleave__2;
interleave.cljs$core$IFn$_invoke$arity$variadic = interleave__3.cljs$core$IFn$_invoke$arity$variadic;
return interleave;
})()
;
/**
* Returns a lazy seq of the elements of coll separated by sep
*/
cljs.core.interpose = (function() {
var interpose = null;
var interpose__1 = (function (sep){
return (function (rf){
var started = cljs.core.volatile_BANG_(false);
return ((function (started){
return (function() {
var G__10276 = null;
var G__10276__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__10276__1 = (function (result){
var G__10269 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10269) : rf.call(null,G__10269));
});
var G__10276__2 = (function (result,input){
if(cljs.core.truth_(cljs.core.deref(started))){
var sepr = (function (){var G__10270 = result;
var G__10271 = sep;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10270,G__10271) : rf.call(null,G__10270,G__10271));
})();
if(cljs.core.reduced_QMARK_(sepr)){
return sepr;
} else {
var G__10272 = sepr;
var G__10273 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10272,G__10273) : rf.call(null,G__10272,G__10273));
}
} else {
cljs.core.vreset_BANG_(started,true);

var G__10274 = result;
var G__10275 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10274,G__10275) : rf.call(null,G__10274,G__10275));
}
});
G__10276 = function(result,input){
switch(arguments.length){
case 0:
return G__10276__0.call(this);
case 1:
return G__10276__1.call(this,result);
case 2:
return G__10276__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10276.cljs$core$IFn$_invoke$arity$0 = G__10276__0;
G__10276.cljs$core$IFn$_invoke$arity$1 = G__10276__1;
G__10276.cljs$core$IFn$_invoke$arity$2 = G__10276__2;
return G__10276;
})()
;})(started))
});
});
var interpose__2 = (function (sep,coll){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep),coll));
});
interpose = function(sep,coll){
switch(arguments.length){
case 1:
return interpose__1.call(this,sep);
case 2:
return interpose__2.call(this,sep,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
interpose.cljs$core$IFn$_invoke$arity$1 = interpose__1;
interpose.cljs$core$IFn$_invoke$arity$2 = interpose__2;
return interpose;
})()
;
/**
* Take a collection of collections, and return a lazy seq
* of items from the inner collection
*/
cljs.core.flatten1 = (function flatten1(colls){
var cat = (function cat(coll,colls__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4124__auto__ = cljs.core.seq(coll);
if(temp__4124__auto__){
var coll__$1 = temp__4124__auto__;
return cljs.core.cons(cljs.core.first(coll__$1),cat(cljs.core.rest(coll__$1),colls__$1));
} else {
if(cljs.core.seq(colls__$1)){
return cat(cljs.core.first(colls__$1),cljs.core.rest(colls__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(null,colls);
});
/**
* Returns the result of applying concat to the result of applying map
* to f and colls.  Thus function f should return a collection. Returns
* a transducer when no collections are provided
* @param {...*} var_args
*/
cljs.core.mapcat = (function() {
var mapcat = null;
var mapcat__1 = (function (f){
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f),cljs.core.cat);
});
var mapcat__2 = (function() { 
var G__10285__delegate = function (f,colls){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,colls));
};
var G__10285 = function (f,var_args){
var colls = null;
if (arguments.length > 1) {
var G__10286__i = 0, G__10286__a = new Array(arguments.length -  1);
while (G__10286__i < G__10286__a.length) {G__10286__a[G__10286__i] = arguments[G__10286__i + 1]; ++G__10286__i;}
  colls = new cljs.core.IndexedSeq(G__10286__a,0);
} 
return G__10285__delegate.call(this,f,colls);};
G__10285.cljs$lang$maxFixedArity = 1;
G__10285.cljs$lang$applyTo = (function (arglist__10287){
var f = cljs.core.first(arglist__10287);
var colls = cljs.core.rest(arglist__10287);
return G__10285__delegate(f,colls);
});
G__10285.cljs$core$IFn$_invoke$arity$variadic = G__10285__delegate;
return G__10285;
})()
;
mapcat = function(f,var_args){
var colls = var_args;
switch(arguments.length){
case 1:
return mapcat__1.call(this,f);
default:
var G__10288 = null;
if (arguments.length > 1) {
var G__10289__i = 0, G__10289__a = new Array(arguments.length -  1);
while (G__10289__i < G__10289__a.length) {G__10289__a[G__10289__i] = arguments[G__10289__i + 1]; ++G__10289__i;}
G__10288 = new cljs.core.IndexedSeq(G__10289__a,0);
}
return mapcat__2.cljs$core$IFn$_invoke$arity$variadic(f, G__10288);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat.cljs$lang$maxFixedArity = 1;
mapcat.cljs$lang$applyTo = mapcat__2.cljs$lang$applyTo;
mapcat.cljs$core$IFn$_invoke$arity$1 = mapcat__1;
mapcat.cljs$core$IFn$_invoke$arity$variadic = mapcat__2.cljs$core$IFn$_invoke$arity$variadic;
return mapcat;
})()
;
/**
* Returns a lazy sequence of the items in coll for which
* (pred item) returns true. pred must be free of side-effects.
* Returns a transducer when no collection is provided.
*/
cljs.core.filter = (function() {
var filter = null;
var filter__1 = (function (pred){
return (function (rf){
return (function() {
var G__10308 = null;
var G__10308__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__10308__1 = (function (result){
var G__10302 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10302) : rf.call(null,G__10302));
});
var G__10308__2 = (function (result,input){
if(cljs.core.truth_((function (){var G__10303 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__10303) : pred.call(null,G__10303));
})())){
var G__10304 = result;
var G__10305 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10304,G__10305) : rf.call(null,G__10304,G__10305));
} else {
return result;
}
});
G__10308 = function(result,input){
switch(arguments.length){
case 0:
return G__10308__0.call(this);
case 1:
return G__10308__1.call(this,result);
case 2:
return G__10308__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10308.cljs$core$IFn$_invoke$arity$0 = G__10308__0;
G__10308.cljs$core$IFn$_invoke$arity$1 = G__10308__1;
G__10308.cljs$core$IFn$_invoke$arity$2 = G__10308__2;
return G__10308;
})()
});
});
var filter__2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5989__auto___10309 = size;
var i_10310 = (0);
while(true){
if((i_10310 < n__5989__auto___10309)){
if(cljs.core.truth_((function (){var G__10306 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_10310);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__10306) : pred.call(null,G__10306));
})())){
cljs.core.chunk_append(b,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_10310));
} else {
}

var G__10311 = (i_10310 + (1));
i_10310 = G__10311;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),filter.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.chunk_rest(s)));
} else {
var f = cljs.core.first(s);
var r = cljs.core.rest(s);
if(cljs.core.truth_((function (){var G__10307 = f;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__10307) : pred.call(null,G__10307));
})())){
return cljs.core.cons(f,filter.cljs$core$IFn$_invoke$arity$2(pred,r));
} else {
return filter.cljs$core$IFn$_invoke$arity$2(pred,r);
}
}
} else {
return null;
}
}),null,null));
});
filter = function(pred,coll){
switch(arguments.length){
case 1:
return filter__1.call(this,pred);
case 2:
return filter__2.call(this,pred,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
filter.cljs$core$IFn$_invoke$arity$1 = filter__1;
filter.cljs$core$IFn$_invoke$arity$2 = filter__2;
return filter;
})()
;
/**
* Returns a lazy sequence of the items in coll for which
* (pred item) returns false. pred must be free of side-effects.
* Returns a transducer when no collection is provided.
*/
cljs.core.remove = (function() {
var remove = null;
var remove__1 = (function (pred){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
});
var remove__2 = (function (pred,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred),coll);
});
remove = function(pred,coll){
switch(arguments.length){
case 1:
return remove__1.call(this,pred);
case 2:
return remove__2.call(this,pred,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
remove.cljs$core$IFn$_invoke$arity$1 = remove__1;
remove.cljs$core$IFn$_invoke$arity$2 = remove__2;
return remove;
})()
;
/**
* Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
* branch? must be a fn of one arg that returns true if passed a node
* that can have children (but may not).  children must be a fn of one
* arg that returns a sequence of the children. Will only be called on
* nodes for which branch? returns true. Root is the root node of the
* tree.
*/
cljs.core.tree_seq = (function tree_seq(branch_QMARK_,children,root){
var walk = (function walk(node){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(node,(cljs.core.truth_((function (){var G__10318 = node;
return (branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(G__10318) : branch_QMARK_.call(null,G__10318));
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(walk,cljs.core.array_seq([(function (){var G__10319 = node;
return (children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(G__10319) : children.call(null,G__10319));
})()], 0)):null));
}),null,null));
});
return walk(root);
});
/**
* Takes any nested combination of sequential things (lists, vectors,
* etc.) and returns their contents as a single, flat sequence.
* (flatten nil) returns nil.
*/
cljs.core.flatten = (function flatten(x){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__10320_SHARP_){
return !(cljs.core.sequential_QMARK_(p1__10320_SHARP_));
}),cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
* Returns a new coll consisting of to-coll with all of the items of
* from-coll conjoined. A transducer may be supplied.
*/
cljs.core.into = (function() {
var into = null;
var into__2 = (function (to,from){
if(!((to == null))){
if((function (){var G__10323 = to;
if(G__10323){
var bit__5776__auto__ = (G__10323.cljs$lang$protocol_mask$partition1$ & (4));
if((bit__5776__auto__) || (G__10323.cljs$core$IEditableCollection$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,to,from);
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,from);
}
});
var into__3 = (function (to,xform,from){
if((function (){var G__10324 = to;
if(G__10324){
var bit__5776__auto__ = (G__10324.cljs$lang$protocol_mask$partition1$ & (4));
if((bit__5776__auto__) || (G__10324.cljs$core$IEditableCollection$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj,to,from);
}
});
into = function(to,xform,from){
switch(arguments.length){
case 2:
return into__2.call(this,to,xform);
case 3:
return into__3.call(this,to,xform,from);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
into.cljs$core$IFn$_invoke$arity$2 = into__2;
into.cljs$core$IFn$_invoke$arity$3 = into__3;
return into;
})()
;
/**
* Returns a vector consisting of the result of applying f to the
* set of first items of each coll, followed by applying f to the set
* of second items in each coll, until any one of the colls is
* exhausted.  Any remaining items in other colls are ignored. Function
* f should accept number-of-colls arguments.
* @param {...*} var_args
*/
cljs.core.mapv = (function() {
var mapv = null;
var mapv__2 = (function (f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(function (){var G__10326 = o;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10326) : f.call(null,G__10326));
})());
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
var mapv__3 = (function (f,c1,c2){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,c1,c2));
});
var mapv__4 = (function (f,c1,c2,c3){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,c1,c2,c3));
});
var mapv__5 = (function() { 
var G__10327__delegate = function (f,c1,c2,c3,colls){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,c1,c2,c3,cljs.core.array_seq([colls], 0)));
};
var G__10327 = function (f,c1,c2,c3,var_args){
var colls = null;
if (arguments.length > 4) {
var G__10328__i = 0, G__10328__a = new Array(arguments.length -  4);
while (G__10328__i < G__10328__a.length) {G__10328__a[G__10328__i] = arguments[G__10328__i + 4]; ++G__10328__i;}
  colls = new cljs.core.IndexedSeq(G__10328__a,0);
} 
return G__10327__delegate.call(this,f,c1,c2,c3,colls);};
G__10327.cljs$lang$maxFixedArity = 4;
G__10327.cljs$lang$applyTo = (function (arglist__10329){
var f = cljs.core.first(arglist__10329);
arglist__10329 = cljs.core.next(arglist__10329);
var c1 = cljs.core.first(arglist__10329);
arglist__10329 = cljs.core.next(arglist__10329);
var c2 = cljs.core.first(arglist__10329);
arglist__10329 = cljs.core.next(arglist__10329);
var c3 = cljs.core.first(arglist__10329);
var colls = cljs.core.rest(arglist__10329);
return G__10327__delegate(f,c1,c2,c3,colls);
});
G__10327.cljs$core$IFn$_invoke$arity$variadic = G__10327__delegate;
return G__10327;
})()
;
mapv = function(f,c1,c2,c3,var_args){
var colls = var_args;
switch(arguments.length){
case 2:
return mapv__2.call(this,f,c1);
case 3:
return mapv__3.call(this,f,c1,c2);
case 4:
return mapv__4.call(this,f,c1,c2,c3);
default:
var G__10330 = null;
if (arguments.length > 4) {
var G__10331__i = 0, G__10331__a = new Array(arguments.length -  4);
while (G__10331__i < G__10331__a.length) {G__10331__a[G__10331__i] = arguments[G__10331__i + 4]; ++G__10331__i;}
G__10330 = new cljs.core.IndexedSeq(G__10331__a,0);
}
return mapv__5.cljs$core$IFn$_invoke$arity$variadic(f,c1,c2,c3, G__10330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapv.cljs$lang$maxFixedArity = 4;
mapv.cljs$lang$applyTo = mapv__5.cljs$lang$applyTo;
mapv.cljs$core$IFn$_invoke$arity$2 = mapv__2;
mapv.cljs$core$IFn$_invoke$arity$3 = mapv__3;
mapv.cljs$core$IFn$_invoke$arity$4 = mapv__4;
mapv.cljs$core$IFn$_invoke$arity$variadic = mapv__5.cljs$core$IFn$_invoke$arity$variadic;
return mapv;
})()
;
/**
* Returns a vector of the items in coll for which
* (pred item) returns true. pred must be free of side-effects.
*/
cljs.core.filterv = (function filterv(pred,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
if(cljs.core.truth_((function (){var G__10333 = o;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__10333) : pred.call(null,G__10333));
})())){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,o);
} else {
return v;
}
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
/**
* Returns a lazy sequence of lists of n items each, at offsets step
* apart. If step is not supplied, defaults to n, i.e. the partitions
* do not overlap. If a pad collection is supplied, use its elements as
* necessary to complete last partition up to n items. In case there are
* not enough padding elements, return a partition with less than n items.
*/
cljs.core.partition = (function() {
var partition = null;
var partition__2 = (function (n,coll){
return partition.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});
var partition__3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,partition.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});
var partition__4 = (function (n,step,pad,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,partition.cljs$core$IFn$_invoke$arity$4(n,step,pad,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return cljs.core._conj(cljs.core.List.EMPTY,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p,pad)));
}
} else {
return null;
}
}),null,null));
});
partition = function(n,step,pad,coll){
switch(arguments.length){
case 2:
return partition__2.call(this,n,step);
case 3:
return partition__3.call(this,n,step,pad);
case 4:
return partition__4.call(this,n,step,pad,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition.cljs$core$IFn$_invoke$arity$2 = partition__2;
partition.cljs$core$IFn$_invoke$arity$3 = partition__3;
partition.cljs$core$IFn$_invoke$arity$4 = partition__4;
return partition;
})()
;
/**
* Returns the value in a nested associative structure,
* where ks is a sequence of keys. Returns nil if the key is not present,
* or the not-found value if supplied.
*/
cljs.core.get_in = (function() {
var get_in = null;
var get_in__2 = (function (m,ks){
return get_in.cljs$core$IFn$_invoke$arity$3(m,ks,null);
});
var get_in__3 = (function (m,ks,not_found){
var sentinel = cljs.core.lookup_sentinel;
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if(ks__$1){
if(!((function (){var G__10348 = m__$1;
if(G__10348){
var bit__5783__auto__ = (G__10348.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__5783__auto__) || (G__10348.cljs$core$ILookup$)){
return true;
} else {
if((!G__10348.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,G__10348);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,G__10348);
}
})())){
return not_found;
} else {
var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.first(ks__$1),sentinel);
if((sentinel === m__$2)){
return not_found;
} else {
var G__10349 = sentinel;
var G__10350 = m__$2;
var G__10351 = cljs.core.next(ks__$1);
sentinel = G__10349;
m__$1 = G__10350;
ks__$1 = G__10351;
continue;
}
}
} else {
return m__$1;
}
break;
}
});
get_in = function(m,ks,not_found){
switch(arguments.length){
case 2:
return get_in__2.call(this,m,ks);
case 3:
return get_in__3.call(this,m,ks,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
get_in.cljs$core$IFn$_invoke$arity$2 = get_in__2;
get_in.cljs$core$IFn$_invoke$arity$3 = get_in__3;
return get_in;
})()
;
/**
* Associates a value in a nested associative structure, where ks is a
* sequence of keys and v is the new value and returns a new nested structure.
* If any levels do not exist, hash-maps will be created.
*/
cljs.core.assoc_in = (function assoc_in(m,p__10352,v){
var vec__10357 = p__10352;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10357,(0),null);
var ks = cljs.core.nthnext(vec__10357,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,assoc_in(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,v));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
/**
* 'Updates' a value in a nested associative structure, where ks is a
* sequence of keys and f is a function that will take the old value
* and any supplied args and return the new value, and returns a new
* nested structure.  If any levels do not exist, hash-maps will be
* created.
* @param {...*} var_args
*/
cljs.core.update_in = (function() {
var update_in = null;
var update_in__3 = (function (m,p__10358,f){
var vec__10396 = p__10358;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10396,(0),null);
var ks = cljs.core.nthnext(vec__10396,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__10397 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10397) : f.call(null,G__10397));
})());
}
});
var update_in__4 = (function (m,p__10359,f,a){
var vec__10398 = p__10359;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10398,(0),null);
var ks = cljs.core.nthnext(vec__10398,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__10399 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__10400 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10399,G__10400) : f.call(null,G__10399,G__10400));
})());
}
});
var update_in__5 = (function (m,p__10360,f,a,b){
var vec__10401 = p__10360;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10401,(0),null);
var ks = cljs.core.nthnext(vec__10401,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__10402 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__10403 = a;
var G__10404 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10402,G__10403,G__10404) : f.call(null,G__10402,G__10403,G__10404));
})());
}
});
var update_in__6 = (function (m,p__10361,f,a,b,c){
var vec__10405 = p__10361;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10405,(0),null);
var ks = cljs.core.nthnext(vec__10405,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b,c));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__10406 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__10407 = a;
var G__10408 = b;
var G__10409 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__10406,G__10407,G__10408,G__10409) : f.call(null,G__10406,G__10407,G__10408,G__10409));
})());
}
});
var update_in__7 = (function() { 
var G__10411__delegate = function (m,p__10362,f,a,b,c,args){
var vec__10410 = p__10362;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10410,(0),null);
var ks = cljs.core.nthnext(vec__10410,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(update_in,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,cljs.core.array_seq([b,c,args], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),a,b,c,cljs.core.array_seq([args], 0)));
}
};
var G__10411 = function (m,p__10362,f,a,b,c,var_args){
var args = null;
if (arguments.length > 6) {
var G__10412__i = 0, G__10412__a = new Array(arguments.length -  6);
while (G__10412__i < G__10412__a.length) {G__10412__a[G__10412__i] = arguments[G__10412__i + 6]; ++G__10412__i;}
  args = new cljs.core.IndexedSeq(G__10412__a,0);
} 
return G__10411__delegate.call(this,m,p__10362,f,a,b,c,args);};
G__10411.cljs$lang$maxFixedArity = 6;
G__10411.cljs$lang$applyTo = (function (arglist__10413){
var m = cljs.core.first(arglist__10413);
arglist__10413 = cljs.core.next(arglist__10413);
var p__10362 = cljs.core.first(arglist__10413);
arglist__10413 = cljs.core.next(arglist__10413);
var f = cljs.core.first(arglist__10413);
arglist__10413 = cljs.core.next(arglist__10413);
var a = cljs.core.first(arglist__10413);
arglist__10413 = cljs.core.next(arglist__10413);
var b = cljs.core.first(arglist__10413);
arglist__10413 = cljs.core.next(arglist__10413);
var c = cljs.core.first(arglist__10413);
var args = cljs.core.rest(arglist__10413);
return G__10411__delegate(m,p__10362,f,a,b,c,args);
});
G__10411.cljs$core$IFn$_invoke$arity$variadic = G__10411__delegate;
return G__10411;
})()
;
update_in = function(m,p__10362,f,a,b,c,var_args){
var args = var_args;
switch(arguments.length){
case 3:
return update_in__3.call(this,m,p__10362,f);
case 4:
return update_in__4.call(this,m,p__10362,f,a);
case 5:
return update_in__5.call(this,m,p__10362,f,a,b);
case 6:
return update_in__6.call(this,m,p__10362,f,a,b,c);
default:
var G__10414 = null;
if (arguments.length > 6) {
var G__10415__i = 0, G__10415__a = new Array(arguments.length -  6);
while (G__10415__i < G__10415__a.length) {G__10415__a[G__10415__i] = arguments[G__10415__i + 6]; ++G__10415__i;}
G__10414 = new cljs.core.IndexedSeq(G__10415__a,0);
}
return update_in__7.cljs$core$IFn$_invoke$arity$variadic(m,p__10362,f,a,b,c, G__10414);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
update_in.cljs$lang$maxFixedArity = 6;
update_in.cljs$lang$applyTo = update_in__7.cljs$lang$applyTo;
update_in.cljs$core$IFn$_invoke$arity$3 = update_in__3;
update_in.cljs$core$IFn$_invoke$arity$4 = update_in__4;
update_in.cljs$core$IFn$_invoke$arity$5 = update_in__5;
update_in.cljs$core$IFn$_invoke$arity$6 = update_in__6;
update_in.cljs$core$IFn$_invoke$arity$variadic = update_in__7.cljs$core$IFn$_invoke$arity$variadic;
return update_in;
})()
;
/**
* 'Updates' a value in an associative structure, where k is a
* key and f is a function that will take the old value
* and any supplied args and return the new value, and returns a new
* structure.  If the key does not exist, nil is passed as the old value.
* @param {...*} var_args
*/
cljs.core.update = (function() {
var update = null;
var update__3 = (function (m,k,f){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__10426 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10426) : f.call(null,G__10426));
})());
});
var update__4 = (function (m,k,f,x){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__10427 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__10428 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10427,G__10428) : f.call(null,G__10427,G__10428));
})());
});
var update__5 = (function (m,k,f,x,y){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__10429 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__10430 = x;
var G__10431 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10429,G__10430,G__10431) : f.call(null,G__10429,G__10430,G__10431));
})());
});
var update__6 = (function (m,k,f,x,y,z){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__10432 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__10433 = x;
var G__10434 = y;
var G__10435 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__10432,G__10433,G__10434,G__10435) : f.call(null,G__10432,G__10433,G__10434,G__10435));
})());
});
var update__7 = (function() { 
var G__10436__delegate = function (m,k,f,x,y,z,more){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),x,y,z,cljs.core.array_seq([more], 0)));
};
var G__10436 = function (m,k,f,x,y,z,var_args){
var more = null;
if (arguments.length > 6) {
var G__10437__i = 0, G__10437__a = new Array(arguments.length -  6);
while (G__10437__i < G__10437__a.length) {G__10437__a[G__10437__i] = arguments[G__10437__i + 6]; ++G__10437__i;}
  more = new cljs.core.IndexedSeq(G__10437__a,0);
} 
return G__10436__delegate.call(this,m,k,f,x,y,z,more);};
G__10436.cljs$lang$maxFixedArity = 6;
G__10436.cljs$lang$applyTo = (function (arglist__10438){
var m = cljs.core.first(arglist__10438);
arglist__10438 = cljs.core.next(arglist__10438);
var k = cljs.core.first(arglist__10438);
arglist__10438 = cljs.core.next(arglist__10438);
var f = cljs.core.first(arglist__10438);
arglist__10438 = cljs.core.next(arglist__10438);
var x = cljs.core.first(arglist__10438);
arglist__10438 = cljs.core.next(arglist__10438);
var y = cljs.core.first(arglist__10438);
arglist__10438 = cljs.core.next(arglist__10438);
var z = cljs.core.first(arglist__10438);
var more = cljs.core.rest(arglist__10438);
return G__10436__delegate(m,k,f,x,y,z,more);
});
G__10436.cljs$core$IFn$_invoke$arity$variadic = G__10436__delegate;
return G__10436;
})()
;
update = function(m,k,f,x,y,z,var_args){
var more = var_args;
switch(arguments.length){
case 3:
return update__3.call(this,m,k,f);
case 4:
return update__4.call(this,m,k,f,x);
case 5:
return update__5.call(this,m,k,f,x,y);
case 6:
return update__6.call(this,m,k,f,x,y,z);
default:
var G__10439 = null;
if (arguments.length > 6) {
var G__10440__i = 0, G__10440__a = new Array(arguments.length -  6);
while (G__10440__i < G__10440__a.length) {G__10440__a[G__10440__i] = arguments[G__10440__i + 6]; ++G__10440__i;}
G__10439 = new cljs.core.IndexedSeq(G__10440__a,0);
}
return update__7.cljs$core$IFn$_invoke$arity$variadic(m,k,f,x,y,z, G__10439);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
update.cljs$lang$maxFixedArity = 6;
update.cljs$lang$applyTo = update__7.cljs$lang$applyTo;
update.cljs$core$IFn$_invoke$arity$3 = update__3;
update.cljs$core$IFn$_invoke$arity$4 = update__4;
update.cljs$core$IFn$_invoke$arity$5 = update__5;
update.cljs$core$IFn$_invoke$arity$6 = update__6;
update.cljs$core$IFn$_invoke$arity$variadic = update__7.cljs$core$IFn$_invoke$arity$variadic;
return update;
})()
;

/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
})

cljs.core.VectorNode.cljs$lang$type = true;

cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode";

cljs.core.VectorNode.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/VectorNode");
});

cljs.core.__GT_VectorNode = (function __GT_VectorNode(edit,arr){
return (new cljs.core.VectorNode(edit,arr));
});

cljs.core.pv_fresh_node = (function pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
});
cljs.core.pv_aget = (function pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,cljs.core.aclone(node.arr)));
});
cljs.core.tail_off = (function tail_off(pv){
var cnt = pv.cnt;
if((cnt < (32))){
return (0);
} else {
return (((cnt - (1)) >>> (5)) << (5));
}
});
cljs.core.new_path = (function new_path(edit,level,node){
var ll = level;
var ret = node;
while(true){
if((ll === (0))){
return ret;
} else {
var embed = ret;
var r = cljs.core.pv_fresh_node(edit);
var _ = cljs.core.pv_aset(r,(0),embed);
var G__10441 = (ll - (5));
var G__10442 = r;
ll = G__10441;
ret = G__10442;
continue;
}
break;
}
});
cljs.core.push_tail = (function push_tail(pv,level,parent,tailnode){
var ret = cljs.core.pv_clone_node(parent);
var subidx = (((pv.cnt - (1)) >>> level) & (31));
if(((5) === level)){
cljs.core.pv_aset(ret,subidx,tailnode);

return ret;
} else {
var child = cljs.core.pv_aget(parent,subidx);
if(!((child == null))){
var node_to_insert = push_tail(pv,(level - (5)),child,tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
} else {
var node_to_insert = cljs.core.new_path(null,(level - (5)),tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
}
}
});
cljs.core.vector_index_out_of_bounds = (function vector_index_out_of_bounds(i,cnt){
throw (new Error([cljs.core.str("No item "),cljs.core.str(i),cljs.core.str(" in vector of length "),cljs.core.str(cnt)].join('')));
});
cljs.core.first_array_for_longvec = (function first_array_for_longvec(pv){
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__10447 = cljs.core.pv_aget(node,(0));
var G__10448 = (level - (5));
node = G__10447;
level = G__10448;
continue;
} else {
return node.arr;
}
break;
}
});
cljs.core.unchecked_array_for = (function unchecked_array_for(pv,i){
if((i >= cljs.core.tail_off(pv))){
return pv.tail;
} else {
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__10449 = cljs.core.pv_aget(node,((i >>> level) & (31)));
var G__10450 = (level - (5));
node = G__10449;
level = G__10450;
continue;
} else {
return node.arr;
}
break;
}
}
});
cljs.core.array_for = (function array_for(pv,i){
if((((0) <= i)) && ((i < pv.cnt))){
return cljs.core.unchecked_array_for(pv,i);
} else {
return cljs.core.vector_index_out_of_bounds(i,pv.cnt);
}
});
cljs.core.do_assoc = (function do_assoc(pv,level,node,i,val){
var ret = cljs.core.pv_clone_node(node);
if((level === (0))){
cljs.core.pv_aset(ret,(i & (31)),val);

return ret;
} else {
var subidx = ((i >>> level) & (31));
cljs.core.pv_aset(ret,subidx,do_assoc(pv,(level - (5)),cljs.core.pv_aget(node,subidx),i,val));

return ret;
}
});
cljs.core.pop_tail = (function pop_tail(pv,level,node){
var subidx = (((pv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = pop_tail(pv,(level - (5)),cljs.core.pv_aget(node,subidx));
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,new_child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,null);

return ret;

}
}
});

/**
* @constructor
*/
cljs.core.RangedIterator = (function (i,base,arr,v,start,end){
this.i = i;
this.base = base;
this.arr = arr;
this.v = v;
this.start = start;
this.end = end;
})
cljs.core.RangedIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
return (self__.i < self__.end);
});

cljs.core.RangedIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(((self__.i - self__.base) === (32))){
self__.arr = cljs.core.unchecked_array_for(self__.v,self__.i);

self__.base = (self__.base + (32));
} else {
}

var ret = (self__.arr[(self__.i & (31))]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.RangedIterator.cljs$lang$type = true;

cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator";

cljs.core.RangedIterator.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/RangedIterator");
});

cljs.core.__GT_RangedIterator = (function __GT_RangedIterator(i,base,arr,v,start,end){
return (new cljs.core.RangedIterator(i,base,arr,v,start,end));
});

cljs.core.ranged_iterator = (function ranged_iterator(v,start,end){
var i = start;
return (new cljs.core.RangedIterator(i,(i - (i % (32))),(((start < cljs.core.count(v)))?cljs.core.unchecked_array_for(v,i):null),v,start,end));
});







/**
* @constructor
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167668511;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentVector.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentVector.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__10460 = init__$2;
var G__10461 = (j + i);
var G__10462 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10460,G__10461,G__10462) : f.call(null,G__10460,G__10461,G__10462));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__10473 = (j + (1));
var G__10474 = init__$3;
j = G__10473;
init__$2 = G__10474;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__10463 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10463) : cljs.core.deref.call(null,G__10463));
} else {
var G__10475 = (i + len);
var G__10476 = init__$2;
i = G__10475;
init__$1 = G__10476;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return (cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(coll__$1) <= n)){
var new_tail = cljs.core.aclone(self__.tail);
(new_tail[(n & (31))] = val);

return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc(coll__$1,self__.shift,self__.root,n,val),self__.tail,null));
}
} else {
if((n === self__.cnt)){
return cljs.core._conj(coll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds  [0,"),cljs.core.str(self__.cnt),cljs.core.str("]")].join('')));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.ranged_iterator(this$__$1,(0),self__.cnt);
});

cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(0));
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(1));
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(self__.cnt - (1)));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
} else {
if(((1) < (self__.cnt - cljs.core.tail_off(coll__$1)))){
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt - (1)),self__.shift,self__.root,self__.tail.slice((0),(-1)),null));
} else {
var new_tail = cljs.core.unchecked_array_for(coll__$1,(self__.cnt - (2)));
var nr = cljs.core.pop_tail(coll__$1,self__.shift,self__.root);
var new_root = (((nr == null))?cljs.core.PersistentVector.EMPTY_NODE:nr);
var cnt_1 = (self__.cnt - (1));
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
return (new cljs.core.PersistentVector(self__.meta,cnt_1,(self__.shift - (5)),cljs.core.pv_aget(new_root,(0)),new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null));
}

}
}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return (new cljs.core.RSeq(coll__$1,(self__.cnt - (1)),null));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5523__auto__ = self__.__hash;
if(!((h__5523__auto__ == null))){
return h__5523__auto__;
} else {
var h__5523__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5523__auto____$1;

return h__5523__auto____$1;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((other instanceof cljs.core.PersistentVector)){
if((self__.cnt === cljs.core.count(other))){
var me_iter = cljs.core._iterator(coll__$1);
var you_iter = cljs.core._iterator(other);
while(true){
if(cljs.core.truth_(me_iter.hasNext())){
var x = me_iter.next();
var y = you_iter.next();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_sequential(coll__$1,other);
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientVector(self__.cnt,self__.shift,(function (){var G__10464 = self__.root;
return (cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1(G__10464) : cljs.core.tv_editable_root.call(null,G__10464));
})(),(function (){var G__10465 = self__.tail;
return (cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1(G__10465) : cljs.core.tv_editable_tail.call(null,G__10465));
})()));
});

cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (v,f){
var self__ = this;
var v__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(v__$1,f);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__10466 = init__$2;
var G__10467 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10466,G__10467) : f.call(null,G__10466,G__10467));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__10477 = (j + (1));
var G__10478 = init__$3;
j = G__10477;
init__$2 = G__10478;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__10468 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10468) : cljs.core.deref.call(null,G__10468));
} else {
var G__10479 = (i + len);
var G__10480 = init__$2;
i = G__10479;
init__$1 = G__10480;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._assoc_n(coll__$1,k,v);
} else {
throw (new Error("Vector's key for assoc must be a number."));
}
});

cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
return null;
} else {
if((self__.cnt <= (32))){
return (new cljs.core.IndexedSeq(self__.tail,(0)));
} else {
var G__10469 = coll__$1;
var G__10470 = cljs.core.first_array_for_longvec(coll__$1);
var G__10471 = (0);
var G__10472 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__10469,G__10470,G__10471,G__10472) : cljs.core.chunked_seq.call(null,G__10469,G__10470,G__10471,G__10472));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentVector(meta__$1,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(((self__.cnt - cljs.core.tail_off(coll__$1)) < (32))){
var len = self__.tail.length;
var new_tail = (new Array((len + (1))));
var n__5989__auto___10481 = len;
var i_10482 = (0);
while(true){
if((i_10482 < n__5989__auto___10481)){
(new_tail[i_10482] = (self__.tail[i_10482]));

var G__10483 = (i_10482 + (1));
i_10482 = G__10483;
continue;
} else {
}
break;
}

(new_tail[len] = o);

return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),self__.shift,self__.root,new_tail,null));
} else {
var root_overflow_QMARK_ = ((self__.cnt >>> (5)) > ((1) << self__.shift));
var new_shift = ((root_overflow_QMARK_)?(self__.shift + (5)):self__.shift);
var new_root = ((root_overflow_QMARK_)?(function (){var n_r = cljs.core.pv_fresh_node(null);
cljs.core.pv_aset(n_r,(0),self__.root);

cljs.core.pv_aset(n_r,(1),cljs.core.new_path(null,self__.shift,(new cljs.core.VectorNode(null,self__.tail))));

return n_r;
})():cljs.core.push_tail(coll__$1,self__.shift,self__.root,(new cljs.core.VectorNode(null,self__.tail))));
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),new_shift,new_root,[o],null));
}
});

cljs.core.PersistentVector.prototype.call = (function() {
var G__10484 = null;
var G__10484__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__10484__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__10484 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__10484__2.call(this,self__,k);
case 3:
return G__10484__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10484.cljs$core$IFn$_invoke$arity$2 = G__10484__2;
G__10484.cljs$core$IFn$_invoke$arity$3 = G__10484__3;
return G__10484;
})()
;

cljs.core.PersistentVector.prototype.apply = (function (self__,args10459){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args10459)));
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.PersistentVector.cljs$lang$type = true;

cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector";

cljs.core.PersistentVector.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/PersistentVector");
});

cljs.core.__GT_PersistentVector = (function __GT_PersistentVector(meta,cnt,shift,root,tail,__hash){
return (new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash));
});

cljs.core.PersistentVector.EMPTY_NODE = (new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,(0),(5),cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash));
cljs.core.PersistentVector.fromArray = (function (xs,no_clone){
var l = xs.length;
var xs__$1 = ((no_clone)?xs:cljs.core.aclone(xs));
if((l < (32))){
return (new cljs.core.PersistentVector(null,l,(5),cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null));
} else {
var node = xs__$1.slice((0),(32));
var v = (new cljs.core.PersistentVector(null,(32),(5),cljs.core.PersistentVector.EMPTY_NODE,node,null));
var i = (32);
var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
while(true){
if((i < l)){
var G__10485 = (i + (1));
var G__10486 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out,(xs__$1[i]));
i = G__10485;
out = G__10486;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));
cljs.core.vec = (function vec(coll){
if(Array.isArray(coll)){
return cljs.core.PersistentVector.fromArray(coll,true);
} else {
return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core._as_transient(cljs.core.PersistentVector.EMPTY),coll));
}
});
/**
* @param {...*} var_args
*/
cljs.core.vector = (function() { 
var vector__delegate = function (args){
if(((args instanceof cljs.core.IndexedSeq)) && ((args.i === (0)))){
return cljs.core.PersistentVector.fromArray(args.arr,true);
} else {
return cljs.core.vec(args);
}
};
var vector = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__10487__i = 0, G__10487__a = new Array(arguments.length -  0);
while (G__10487__i < G__10487__a.length) {G__10487__a[G__10487__i] = arguments[G__10487__i + 0]; ++G__10487__i;}
  args = new cljs.core.IndexedSeq(G__10487__a,0);
} 
return vector__delegate.call(this,args);};
vector.cljs$lang$maxFixedArity = 0;
vector.cljs$lang$applyTo = (function (arglist__10488){
var args = cljs.core.seq(arglist__10488);
return vector__delegate(args);
});
vector.cljs$core$IFn$_invoke$arity$variadic = vector__delegate;
return vector;
})()
;

/**
* @constructor
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta,__hash){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375020;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__10489 = self__.vec;
var G__10490 = self__.node;
var G__10491 = self__.i;
var G__10492 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__10489,G__10490,G__10491,G__10492) : cljs.core.chunked_seq.call(null,G__10489,G__10490,G__10491,G__10492));
})();
if((s == null)){
return null;
} else {
return s;
}
} else {
return cljs.core._chunked_next(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5523__auto__ = self__.__hash;
if(!((h__5523__auto__ == null))){
return h__5523__auto__;
} else {
var h__5523__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5523__auto____$1;

return h__5523__auto____$1;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((function (){var G__10493 = self__.vec;
var G__10494 = (self__.i + self__.off);
var G__10495 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__10493,G__10494,G__10495) : cljs.core.subvec.call(null,G__10493,G__10494,G__10495));
})(),f);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((function (){var G__10496 = self__.vec;
var G__10497 = (self__.i + self__.off);
var G__10498 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__10496,G__10497,G__10498) : cljs.core.subvec.call(null,G__10496,G__10497,G__10498));
})(),f,start);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.node[self__.off]);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__10499 = self__.vec;
var G__10500 = self__.node;
var G__10501 = self__.i;
var G__10502 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__10499,G__10500,G__10501,G__10502) : cljs.core.chunked_seq.call(null,G__10499,G__10500,G__10501,G__10502));
})();
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
} else {
return cljs.core._chunked_rest(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node,self__.off);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__10503 = self__.vec;
var G__10504 = cljs.core.unchecked_array_for(self__.vec,end);
var G__10505 = end;
var G__10506 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__10503,G__10504,G__10505,G__10506) : cljs.core.chunked_seq.call(null,G__10503,G__10504,G__10505,G__10506));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
var G__10507 = self__.vec;
var G__10508 = self__.node;
var G__10509 = self__.i;
var G__10510 = self__.off;
var G__10511 = m;
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(G__10507,G__10508,G__10509,G__10510,G__10511) : cljs.core.chunked_seq.call(null,G__10507,G__10508,G__10509,G__10510,G__10511));
});

cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__10512 = self__.vec;
var G__10513 = cljs.core.unchecked_array_for(self__.vec,end);
var G__10514 = end;
var G__10515 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__10512,G__10513,G__10514,G__10515) : cljs.core.chunked_seq.call(null,G__10512,G__10513,G__10514,G__10515));
} else {
return null;
}
});

cljs.core.ChunkedSeq.cljs$lang$type = true;

cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq";

cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/ChunkedSeq");
});

cljs.core.__GT_ChunkedSeq = (function __GT_ChunkedSeq(vec,node,i,off,meta,__hash){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash));
});

(cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));
cljs.core.chunked_seq = (function() {
var chunked_seq = null;
var chunked_seq__3 = (function (vec,i,off){
return (new cljs.core.ChunkedSeq(vec,cljs.core.array_for(vec,i),i,off,null,null));
});
var chunked_seq__4 = (function (vec,node,i,off){
return (new cljs.core.ChunkedSeq(vec,node,i,off,null,null));
});
var chunked_seq__5 = (function (vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,null));
});
chunked_seq = function(vec,node,i,off,meta){
switch(arguments.length){
case 3:
return chunked_seq__3.call(this,vec,node,i);
case 4:
return chunked_seq__4.call(this,vec,node,i,off);
case 5:
return chunked_seq__5.call(this,vec,node,i,off,meta);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chunked_seq.cljs$core$IFn$_invoke$arity$3 = chunked_seq__3;
chunked_seq.cljs$core$IFn$_invoke$arity$4 = chunked_seq__4;
chunked_seq.cljs$core$IFn$_invoke$arity$5 = chunked_seq__5;
return chunked_seq;
})()
;

/**
* @constructor
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166617887;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Subvec.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Subvec.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return cljs.core.vector_index_out_of_bounds(n,(self__.end - self__.start));
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.start + n));
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return not_found;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v,(self__.start + n),not_found);
}
});

cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
var v_pos = (self__.start + n);
var G__10517 = self__.meta;
var G__10518 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v,v_pos,val);
var G__10519 = self__.start;
var G__10520 = (function (){var x__5419__auto__ = self__.end;
var y__5420__auto__ = (v_pos + (1));
return ((x__5419__auto__ > y__5420__auto__) ? x__5419__auto__ : y__5420__auto__);
})();
var G__10521 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__10517,G__10518,G__10519,G__10520,G__10521) : cljs.core.build_subvec.call(null,G__10517,G__10518,G__10519,G__10520,G__10521));
});

cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash));
});

cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.end - self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.end - (1)));
});

cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
throw (new Error("Can't pop empty vector"));
} else {
var G__10522 = self__.meta;
var G__10523 = self__.v;
var G__10524 = self__.start;
var G__10525 = (self__.end - (1));
var G__10526 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__10522,G__10523,G__10524,G__10525,G__10526) : cljs.core.build_subvec.call(null,G__10522,G__10523,G__10524,G__10525,G__10526));
}
});

cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(!((self__.start === self__.end))){
return (new cljs.core.RSeq(coll__$1,((self__.end - self__.start) - (1)),null));
} else {
return null;
}
});

cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5523__auto__ = self__.__hash;
if(!((h__5523__auto__ == null))){
return h__5523__auto__;
} else {
var h__5523__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5523__auto____$1;

return h__5523__auto____$1;
}
});

cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start__$1){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,start__$1);
});

cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,key,val){
var self__ = this;
var coll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n(coll__$1,key,val);
} else {
throw (new Error("Subvec's key for assoc must be a number."));
}
});

cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var subvec_seq = ((function (coll__$1){
return (function subvec_seq(i){
if((i === self__.end)){
return null;
} else {
return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i),(new cljs.core.LazySeq(null,((function (coll__$1){
return (function (){
return subvec_seq((i + (1)));
});})(coll__$1))
,null,null)));
}
});})(coll__$1))
;
return subvec_seq(self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
var G__10528 = meta__$1;
var G__10529 = self__.v;
var G__10530 = self__.start;
var G__10531 = self__.end;
var G__10532 = self__.__hash;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__10528,G__10529,G__10530,G__10531,G__10532) : cljs.core.build_subvec.call(null,G__10528,G__10529,G__10530,G__10531,G__10532));
});

cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__10533 = self__.meta;
var G__10534 = cljs.core._assoc_n(self__.v,self__.end,o);
var G__10535 = self__.start;
var G__10536 = (self__.end + (1));
var G__10537 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__10533,G__10534,G__10535,G__10536,G__10537) : cljs.core.build_subvec.call(null,G__10533,G__10534,G__10535,G__10536,G__10537));
});

cljs.core.Subvec.prototype.call = (function() {
var G__10538 = null;
var G__10538__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__10538__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__10538 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__10538__2.call(this,self__,k);
case 3:
return G__10538__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10538.cljs$core$IFn$_invoke$arity$2 = G__10538__2;
G__10538.cljs$core$IFn$_invoke$arity$3 = G__10538__3;
return G__10538;
})()
;

cljs.core.Subvec.prototype.apply = (function (self__,args10516){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args10516)));
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.Subvec.cljs$lang$type = true;

cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec";

cljs.core.Subvec.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/Subvec");
});

cljs.core.__GT_Subvec = (function __GT_Subvec(meta,v,start,end,__hash){
return (new cljs.core.Subvec(meta,v,start,end,__hash));
});

(cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));
cljs.core.build_subvec = (function build_subvec(meta,v,start,end,__hash){
while(true){
if((v instanceof cljs.core.Subvec)){
var G__10539 = meta;
var G__10540 = v.v;
var G__10541 = (v.start + start);
var G__10542 = (v.start + end);
var G__10543 = __hash;
meta = G__10539;
v = G__10540;
start = G__10541;
end = G__10542;
__hash = G__10543;
continue;
} else {
var c = cljs.core.count(v);
if(((start < (0))) || ((end < (0))) || ((start > c)) || ((end > c))){
throw (new Error("Index out of bounds"));
} else {
}

return (new cljs.core.Subvec(meta,v,start,end,__hash));
}
break;
}
});
/**
* Returns a persistent vector of the items in vector from
* start (inclusive) to end (exclusive).  If end is not supplied,
* defaults to (count vector). This operation is O(1) and very fast, as
* the resulting vector shares structure with the original and no
* trimming is done.
*/
cljs.core.subvec = (function() {
var subvec = null;
var subvec__2 = (function (v,start){
return subvec.cljs$core$IFn$_invoke$arity$3(v,start,cljs.core.count(v));
});
var subvec__3 = (function (v,start,end){
return cljs.core.build_subvec(null,v,start,end,null);
});
subvec = function(v,start,end){
switch(arguments.length){
case 2:
return subvec__2.call(this,v,start);
case 3:
return subvec__3.call(this,v,start,end);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
subvec.cljs$core$IFn$_invoke$arity$2 = subvec__2;
subvec.cljs$core$IFn$_invoke$arity$3 = subvec__3;
return subvec;
})()
;
cljs.core.tv_ensure_editable = (function tv_ensure_editable(edit,node){
if((edit === node.edit)){
return node;
} else {
return (new cljs.core.VectorNode(edit,cljs.core.aclone(node.arr)));
}
});
cljs.core.tv_editable_root = (function tv_editable_root(node){
return (new cljs.core.VectorNode((function (){var obj10550 = {};
return obj10550;
})(),cljs.core.aclone(node.arr)));
});
cljs.core.tv_editable_tail = (function tv_editable_tail(tl){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy(tl,(0),ret,(0),tl.length);

return ret;
});
cljs.core.tv_push_tail = (function tv_push_tail(tv,level,parent,tail_node){
var ret = cljs.core.tv_ensure_editable(tv.root.edit,parent);
var subidx = (((tv.cnt - (1)) >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(((level === (5)))?tail_node:(function (){var child = cljs.core.pv_aget(ret,subidx);
if(!((child == null))){
return tv_push_tail(tv,(level - (5)),child,tail_node);
} else {
return cljs.core.new_path(tv.root.edit,(level - (5)),tail_node);
}
})()));

return ret;
});
cljs.core.tv_pop_tail = (function tv_pop_tail(tv,level,node){
var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit,node);
var subidx = (((tv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = tv_pop_tail(tv,(level - (5)),cljs.core.pv_aget(node__$1,subidx));
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,new_child);

return node__$1;
}
} else {
if((subidx === (0))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,null);

return node__$1;

}
}
});
cljs.core.unchecked_editable_array_for = (function unchecked_editable_array_for(tv,i){
if((i >= cljs.core.tail_off(tv))){
return tv.tail;
} else {
var root = tv.root;
var node = root;
var level = tv.shift;
while(true){
if((level > (0))){
var G__10558 = cljs.core.tv_ensure_editable(root.edit,cljs.core.pv_aget(node,((i >>> level) & (31))));
var G__10559 = (level - (5));
node = G__10558;
level = G__10559;
continue;
} else {
return node.arr;
}
break;
}
}
});

/**
* @constructor
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition0$ = 275;
this.cljs$lang$protocol_mask$partition1$ = 88;
})
cljs.core.TransientVector.prototype.call = (function() {
var G__10563 = null;
var G__10563__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__10563__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__10563 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__10563__2.call(this,self__,k);
case 3:
return G__10563__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10563.cljs$core$IFn$_invoke$arity$2 = G__10563__2;
G__10563.cljs$core$IFn$_invoke$arity$3 = G__10563__3;
return G__10563;
})()
;

cljs.core.TransientVector.prototype.apply = (function (self__,args10560){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args10560)));
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
} else {
throw (new Error("nth after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,n);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return self__.cnt;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function (tcoll,n,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(tcoll__$1) <= n)){
(self__.tail[(n & (31))] = val);

return tcoll__$1;
} else {
var new_root = ((function (tcoll__$1){
return (function go(level,node){
var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit,node);
if((level === (0))){
cljs.core.pv_aset(node__$1,(n & (31)),val);

return node__$1;
} else {
var subidx = ((n >>> level) & (31));
cljs.core.pv_aset(node__$1,subidx,go((level - (5)),cljs.core.pv_aget(node__$1,subidx)));

return node__$1;
}
});})(tcoll__$1))
.call(null,self__.shift,self__.root);
self__.root = new_root;

return tcoll__$1;
}
} else {
if((n === self__.cnt)){
return cljs.core._conj_BANG_(tcoll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds for TransientVector of length"),cljs.core.str(self__.cnt)].join('')));

}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
self__.cnt = (0);

return tcoll__$1;
} else {
if((((self__.cnt - (1)) & (31)) > (0))){
self__.cnt = (self__.cnt - (1));

return tcoll__$1;
} else {
var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1,(self__.cnt - (2)));
var new_root = (function (){var nr = cljs.core.tv_pop_tail(tcoll__$1,self__.shift,self__.root);
if(!((nr == null))){
return nr;
} else {
return (new cljs.core.VectorNode(self__.root.edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
}
})();
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit,cljs.core.pv_aget(new_root,(0)));
self__.root = new_root__$1;

self__.shift = (self__.shift - (5));

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
} else {
self__.root = new_root;

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
}

}
}
}
} else {
throw (new Error("pop! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n_BANG_(tcoll__$1,key,val);
} else {
throw (new Error("TransientVector's key for assoc! must be a number."));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((self__.cnt - cljs.core.tail_off(tcoll__$1)) < (32))){
(self__.tail[(self__.cnt & (31))] = o);

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var tail_node = (new cljs.core.VectorNode(self__.root.edit,self__.tail));
var new_tail = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(new_tail[(0)] = o);

self__.tail = new_tail;

if(((self__.cnt >>> (5)) > ((1) << self__.shift))){
var new_root_array = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var new_shift = (self__.shift + (5));
(new_root_array[(0)] = self__.root);

(new_root_array[(1)] = cljs.core.new_path(self__.root.edit,self__.shift,tail_node));

self__.root = (new cljs.core.VectorNode(self__.root.edit,new_root_array));

self__.shift = new_shift;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var new_root = cljs.core.tv_push_tail(tcoll__$1,self__.shift,self__.root,tail_node);
self__.root = new_root;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
self__.root.edit = null;

var len = (self__.cnt - cljs.core.tail_off(tcoll__$1));
var trimmed_tail = (new Array(len));
cljs.core.array_copy(self__.tail,(0),trimmed_tail,(0),len);

return (new cljs.core.PersistentVector(null,self__.cnt,self__.shift,self__.root,trimmed_tail,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientVector.cljs$lang$type = true;

cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector";

cljs.core.TransientVector.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/TransientVector");
});

cljs.core.__GT_TransientVector = (function __GT_TransientVector(cnt,shift,root,tail){
return (new cljs.core.TransientVector(cnt,shift,root,tail));
});


/**
* @constructor
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 31850572;
})
cljs.core.PersistentQueueSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueueSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5523__auto__ = self__.__hash;
if(!((h__5523__auto__ == null))){
return h__5523__auto__;
} else {
var h__5523__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5523__auto____$1;

return h__5523__auto____$1;
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var temp__4124__auto__ = cljs.core.next(self__.front);
if(temp__4124__auto__){
var f1 = temp__4124__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((self__.rear == null)){
return cljs.core._empty(coll__$1);
} else {
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
}
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueSeq(meta__$1,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentQueueSeq.cljs$lang$type = true;

cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq";

cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/PersistentQueueSeq");
});

cljs.core.__GT_PersistentQueueSeq = (function __GT_PersistentQueueSeq(meta,front,rear,__hash){
return (new cljs.core.PersistentQueueSeq(meta,front,rear,__hash));
});

(cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));

/**
* @constructor
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentQueue.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueue.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(self__.meta,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
var temp__4124__auto__ = cljs.core.next(self__.front);
if(temp__4124__auto__){
var f1 = temp__4124__auto__;
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),f1,self__.rear,null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),cljs.core.seq(self__.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else {
return coll__$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5523__auto__ = self__.__hash;
if(!((h__5523__auto__ == null))){
return h__5523__auto__;
} else {
var h__5523__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5523__auto____$1;

return h__5523__auto____$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentQueue.EMPTY,self__.meta);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.rest(cljs.core.seq(coll__$1));
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var rear__$1 = cljs.core.seq(self__.rear);
if(cljs.core.truth_((function (){var or__5102__auto__ = self__.front;
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
return rear__$1;
}
})())){
return (new cljs.core.PersistentQueueSeq(null,self__.front,cljs.core.seq(rear__$1),null));
} else {
return null;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(meta__$1,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),self__.front,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__5102__auto__ = self__.rear;
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front,o),cljs.core.PersistentVector.EMPTY,null));
}
});

cljs.core.PersistentQueue.cljs$lang$type = true;

cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue";

cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/PersistentQueue");
});

cljs.core.__GT_PersistentQueue = (function __GT_PersistentQueue(meta,count,front,rear,__hash){
return (new cljs.core.PersistentQueue(meta,count,front,rear,__hash));
});

cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,(0),null,cljs.core.PersistentVector.EMPTY,cljs.core.empty_ordered_hash));
(cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));

/**
* @constructor
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2097152;
})
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return false;
});

cljs.core.NeverEquiv.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NeverEquiv.cljs$lang$type = true;

cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv";

cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/NeverEquiv");
});

cljs.core.__GT_NeverEquiv = (function __GT_NeverEquiv(){
return (new cljs.core.NeverEquiv());
});

cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
* Assumes y is a map. Returns true if x equals y, otherwise returns
* false.
*/
cljs.core.equiv_map = (function equiv_map(x,y){
return cljs.core.boolean$(((cljs.core.map_QMARK_(y))?(((cljs.core.count(x) === cljs.core.count(y)))?cljs.core.every_QMARK_(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (xkv){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,cljs.core.first(xkv),cljs.core.never_equiv),cljs.core.second(xkv));
}),x)):null):null));
});
cljs.core.scan_array = (function scan_array(incr,k,array){
var len = array.length;
var i = (0);
while(true){
if((i < len)){
if((k === (array[i]))){
return i;
} else {
var G__10564 = (i + incr);
i = G__10564;
continue;
}
} else {
return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function obj_map_compare_keys(a,b){
var a__$1 = cljs.core.hash(a);
var b__$1 = cljs.core.hash(b);
if((a__$1 < b__$1)){
return (-1);
} else {
if((a__$1 > b__$1)){
return (1);
} else {
return (0);

}
}
});
cljs.core.obj_map__GT_hash_map = (function obj_map__GT_hash_map(m,k,v){
var ks = m.keys;
var len = ks.length;
var so = m.strobj;
var mm = cljs.core.meta(m);
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var k__$1 = (ks[i]);
var G__10565 = (i + (1));
var G__10566 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k__$1,(so[k__$1]));
i = G__10565;
out = G__10566;
continue;
} else {
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k,v)),mm);
}
break;
}
});
cljs.core.obj_clone = (function obj_clone(obj,ks){
var new_obj = (function (){var obj10570 = {};
return obj10570;
})();
var l = ks.length;
var i_10571 = (0);
while(true){
if((i_10571 < l)){
var k_10572 = (ks[i_10571]);
(new_obj[k_10572] = (obj[k_10572]));

var G__10573 = (i_10571 + (1));
i_10571 = G__10573;
continue;
} else {
}
break;
}

return new_obj;
});

/**
* @constructor
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 4;
})
cljs.core.ObjMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ObjMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__5090__auto__ = (function (){var G__10577 = k;
return goog.isString(G__10577);
})();
if(cljs.core.truth_(and__5090__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__5090__auto__;
}
})())){
return (self__.strobj[k]);
} else {
return not_found;
}
});

cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.keys.length;
var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
var init__$1 = init;
while(true){
if(cljs.core.seq(keys__$1)){
var k = cljs.core.first(keys__$1);
var init__$2 = (function (){var G__10578 = init__$1;
var G__10579 = k;
var G__10580 = (self__.strobj[k]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10578,G__10579,G__10580) : f.call(null,G__10578,G__10579,G__10580));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__10581 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10581) : cljs.core.deref.call(null,G__10581));
} else {
var G__10587 = cljs.core.rest(keys__$1);
var G__10588 = init__$2;
keys__$1 = G__10587;
init__$1 = G__10588;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.keys.length;
});

cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5523__auto__ = self__.__hash;
if(!((h__5523__auto__ == null))){
return h__5523__auto__;
} else {
var h__5523__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__5523__auto____$1;

return h__5523__auto____$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1));
});

cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.ObjMap.EMPTY,self__.meta);
});

cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__5090__auto__ = (function (){var G__10583 = k;
return goog.isString(G__10583);
})();
if(cljs.core.truth_(and__5090__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__5090__auto__;
}
})())){
var new_keys = cljs.core.aclone(self__.keys);
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
new_keys.splice(cljs.core.scan_array((1),k,new_keys),(1));

delete new_strobj[k];

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
} else {
return coll__$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var G__10584 = k;
return goog.isString(G__10584);
})())){
if(((self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD)) || ((self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD))){
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
} else {
if(!((cljs.core.scan_array((1),k,self__.keys) == null))){
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
(new_strobj[k] = v);

return (new cljs.core.ObjMap(self__.meta,self__.keys,new_strobj,(self__.update_count + (1)),null));
} else {
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
var new_keys = cljs.core.aclone(self__.keys);
(new_strobj[k] = v);

new_keys.push(k);

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
}
}
} else {
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__5090__auto__ = (function (){var G__10586 = k;
return goog.isString(G__10586);
})();
if(cljs.core.truth_(and__5090__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__5090__auto__;
}
})())){
return true;
} else {
return false;
}
});

cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.keys.length > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (coll__$1){
return (function (p1__10574_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__10574_SHARP_,(self__.strobj[p1__10574_SHARP_])],null));
});})(coll__$1))
,self__.keys.sort(cljs.core.obj_map_compare_keys));
} else {
return null;
}
});

cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ObjMap(meta__$1,self__.keys,self__.strobj,self__.update_count,self__.__hash));
});

cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,coll__$1,entry);
}
});

cljs.core.ObjMap.prototype.call = (function() {
var G__10589 = null;
var G__10589__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__10589__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__10589 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__10589__2.call(this,self__,k);
case 3:
return G__10589__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10589.cljs$core$IFn$_invoke$arity$2 = G__10589__2;
G__10589.cljs$core$IFn$_invoke$arity$3 = G__10589__3;
return G__10589;
})()
;

cljs.core.ObjMap.prototype.apply = (function (self__,args10575){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args10575)));
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.ObjMap.cljs$lang$type = true;

cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap";

cljs.core.ObjMap.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/ObjMap");
});

cljs.core.__GT_ObjMap = (function __GT_ObjMap(meta,keys,strobj,update_count,__hash){
return (new cljs.core.ObjMap(meta,keys,strobj,update_count,__hash));
});

cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],(function (){var obj10591 = {};
return obj10591;
})(),(0),cljs.core.empty_unordered_hash));
cljs.core.ObjMap.HASHMAP_THRESHOLD = (8);
cljs.core.ObjMap.fromObject = (function (ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,(0),null));
});

/**
* @constructor
*/
cljs.core.ES6EntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6EntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var vec__10592 = cljs.core.first(self__.s);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10592,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10592,(1),null);
self__.s = cljs.core.next(self__.s);

return {"done": false, "value": [k,v]};
} else {
return {"done": true, "value": null};
}
});

cljs.core.ES6EntriesIterator.cljs$lang$type = true;

cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator";

cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/ES6EntriesIterator");
});

cljs.core.__GT_ES6EntriesIterator = (function __GT_ES6EntriesIterator(s){
return (new cljs.core.ES6EntriesIterator(s));
});

cljs.core.es6_entries_iterator = (function es6_entries_iterator(coll){
return (new cljs.core.ES6EntriesIterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6SetEntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6SetEntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return {"done": false, "value": [x,x]};
} else {
return {"done": true, "value": null};
}
});

cljs.core.ES6SetEntriesIterator.cljs$lang$type = true;

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator";

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/ES6SetEntriesIterator");
});

cljs.core.__GT_ES6SetEntriesIterator = (function __GT_ES6SetEntriesIterator(s){
return (new cljs.core.ES6SetEntriesIterator(s));
});

cljs.core.es6_set_entries_iterator = (function es6_set_entries_iterator(coll){
return (new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll)));
});
cljs.core.array_map_index_of_nil_QMARK_ = (function array_map_index_of_nil_QMARK_(arr,m,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((arr[i]) == null)){
return i;
} else {
var G__10593 = (i + (2));
i = G__10593;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of_keyword_QMARK_ = (function array_map_index_of_keyword_QMARK_(arr,m,k){
var len = arr.length;
var kstr = k.fqn;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((function (){var k_SINGLEQUOTE_ = (arr[i]);
return ((k_SINGLEQUOTE_ instanceof cljs.core.Keyword)) && ((kstr === k_SINGLEQUOTE_.fqn));
})()){
return i;
} else {
var G__10594 = (i + (2));
i = G__10594;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of_symbol_QMARK_ = (function array_map_index_of_symbol_QMARK_(arr,m,k){
var len = arr.length;
var kstr = k.str;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((function (){var k_SINGLEQUOTE_ = (arr[i]);
return ((k_SINGLEQUOTE_ instanceof cljs.core.Symbol)) && ((kstr === k_SINGLEQUOTE_.str));
})()){
return i;
} else {
var G__10595 = (i + (2));
i = G__10595;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of_identical_QMARK_ = (function array_map_index_of_identical_QMARK_(arr,m,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((k === (arr[i]))){
return i;
} else {
var G__10596 = (i + (2));
i = G__10596;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of_equiv_QMARK_ = (function array_map_index_of_equiv_QMARK_(arr,m,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(arr[i]))){
return i;
} else {
var G__10597 = (i + (2));
i = G__10597;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of = (function array_map_index_of(m,k){
var arr = m.arr;
if((k instanceof cljs.core.Keyword)){
return cljs.core.array_map_index_of_keyword_QMARK_(arr,m,k);
} else {
if(cljs.core.truth_((function (){var or__5102__auto__ = (function (){var G__10601 = k;
return goog.isString(G__10601);
})();
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
return typeof k === 'number';
}
})())){
return cljs.core.array_map_index_of_identical_QMARK_(arr,m,k);
} else {
if((k instanceof cljs.core.Symbol)){
return cljs.core.array_map_index_of_symbol_QMARK_(arr,m,k);
} else {
if((k == null)){
return cljs.core.array_map_index_of_nil_QMARK_(arr,m,k);
} else {
return cljs.core.array_map_index_of_equiv_QMARK_(arr,m,k);

}
}
}
}
});
cljs.core.array_map_extend_kv = (function array_map_extend_kv(m,k,v){
var arr = m.arr;
var l = arr.length;
var narr = (new Array((l + (2))));
var i_10602 = (0);
while(true){
if((i_10602 < l)){
(narr[i_10602] = (arr[i_10602]));

var G__10603 = (i_10602 + (1));
i_10602 = G__10603;
continue;
} else {
}
break;
}

(narr[l] = k);

(narr[(l + (1))] = v);

return narr;
});

/**
* @constructor
*/
cljs.core.PersistentArrayMapSeq = (function (arr,i,_meta){
this.arr = arr;
this.i = i;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
})
cljs.core.PersistentArrayMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return null;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return ((self__.arr.length - self__.i) / (2));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMapSeq(self__.arr,self__.i,new_meta));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentArrayMapSeq.cljs$lang$type = true;

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq";

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/PersistentArrayMapSeq");
});

cljs.core.__GT_PersistentArrayMapSeq = (function __GT_PersistentArrayMapSeq(arr,i,_meta){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
});

(cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));
cljs.core.persistent_array_map_seq = (function persistent_array_map_seq(arr,i,_meta){
if((i <= (arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
} else {
return null;
}
});


/**
* @constructor
*/
cljs.core.PersistentArrayMapIterator = (function (arr,i,cnt){
this.arr = arr;
this.i = i;
this.cnt = cnt;
})
cljs.core.PersistentArrayMapIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.cnt);
});

cljs.core.PersistentArrayMapIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
self__.i = (self__.i + (2));

return ret;
});

cljs.core.PersistentArrayMapIterator.cljs$lang$type = true;

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator";

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/PersistentArrayMapIterator");
});

cljs.core.__GT_PersistentArrayMapIterator = (function __GT_PersistentArrayMapIterator(arr,i,cnt){
return (new cljs.core.PersistentArrayMapIterator(arr,i,cnt));
});


/**
* @constructor
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentArrayMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__10605 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__10605) : cljs.core.keys.call(null,G__10605));
})());
});

cljs.core.PersistentArrayMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentArrayMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__10606 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__10606) : cljs.core.vals.call(null,G__10606));
})());
});

cljs.core.PersistentArrayMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentArrayMap.prototype.get = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentArrayMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__10607 = cljs.core.seq(coll);
var chunk__10608 = null;
var count__10609 = (0);
var i__10610 = (0);
while(true){
if((i__10610 < count__10609)){
var vec__10611 = chunk__10608.cljs$core$IIndexed$_nth$arity$2(null,i__10610);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10611,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10611,(1),null);
var G__10612_10625 = v;
var G__10613_10626 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10612_10625,G__10613_10626) : f.call(null,G__10612_10625,G__10613_10626));

var G__10627 = seq__10607;
var G__10628 = chunk__10608;
var G__10629 = count__10609;
var G__10630 = (i__10610 + (1));
seq__10607 = G__10627;
chunk__10608 = G__10628;
count__10609 = G__10629;
i__10610 = G__10630;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__10607);
if(temp__4126__auto__){
var seq__10607__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10607__$1)){
var c__5889__auto__ = cljs.core.chunk_first(seq__10607__$1);
var G__10631 = cljs.core.chunk_rest(seq__10607__$1);
var G__10632 = c__5889__auto__;
var G__10633 = cljs.core.count(c__5889__auto__);
var G__10634 = (0);
seq__10607 = G__10631;
chunk__10608 = G__10632;
count__10609 = G__10633;
i__10610 = G__10634;
continue;
} else {
var vec__10614 = cljs.core.first(seq__10607__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10614,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10614,(1),null);
var G__10615_10635 = v;
var G__10616_10636 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10615_10635,G__10616_10636) : f.call(null,G__10615_10635,G__10616_10636));

var G__10637 = cljs.core.next(seq__10607__$1);
var G__10638 = null;
var G__10639 = (0);
var G__10640 = (0);
seq__10607 = G__10637;
chunk__10608 = G__10638;
count__10609 = G__10639;
i__10610 = G__10640;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var G__10617 = init__$1;
var G__10618 = (self__.arr[i]);
var G__10619 = (self__.arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10617,G__10618,G__10619) : f.call(null,G__10617,G__10618,G__10619));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__10620 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10620) : cljs.core.deref.call(null,G__10620));
} else {
var G__10641 = (i + (2));
var G__10642 = init__$2;
i = G__10641;
init__$1 = G__10642;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.PersistentArrayMapIterator(self__.arr,(0),(self__.cnt * (2))));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5523__auto__ = self__.__hash;
if(!((h__5523__auto__ == null))){
return h__5523__auto__;
} else {
var h__5523__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__5523__auto____$1;

return h__5523__auto____$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((function (){var G__10621 = other;
if(G__10621){
var bit__5776__auto__ = (G__10621.cljs$lang$protocol_mask$partition0$ & (1024));
if((bit__5776__auto__) || (G__10621.cljs$core$IMap$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
var alen = self__.arr.length;
var other__$1 = other;
if((self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null))){
var i = (0);
while(true){
if((i < alen)){
var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null,(self__.arr[i]),cljs.core.lookup_sentinel);
if(!((v === cljs.core.lookup_sentinel))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(i + (1))]),v)){
var G__10643 = (i + (2));
i = G__10643;
continue;
} else {
return false;
}
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_map(coll__$1,other);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientArrayMap((function (){var obj10623 = {};
return obj10623;
})(),self__.arr.length,cljs.core.aclone(self__.arr)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY,self__.meta);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx >= (0))){
var len = self__.arr.length;
var new_len = (len - (2));
if((new_len === (0))){
return cljs.core._empty(coll__$1);
} else {
var new_arr = (new Array(new_len));
var s = (0);
var d = (0);
while(true){
if((s >= len)){
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt - (1)),new_arr,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(self__.arr[s]))){
var G__10644 = (s + (2));
var G__10645 = d;
s = G__10644;
d = G__10645;
continue;
} else {
(new_arr[d] = (self__.arr[s]));

(new_arr[(d + (1))] = (self__.arr[(s + (1))]));

var G__10646 = (s + (2));
var G__10647 = (d + (2));
s = G__10646;
d = G__10647;
continue;

}
}
break;
}
}
} else {
return coll__$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
if((self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr__$1 = cljs.core.array_map_extend_kv(coll__$1,k,v);
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt + (1)),arr__$1,null));
} else {
return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1),k,v),self__.meta);
}
} else {
if((v === (self__.arr[(idx + (1))]))){
return coll__$1;
} else {
var arr__$1 = (function (){var G__10624 = cljs.core.aclone(self__.arr);
(G__10624[(idx + (1))] = v);

return G__10624;
})();
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,arr__$1,null));

}
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((cljs.core.array_map_index_of(coll__$1,k) === (-1)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.persistent_array_map_seq(self__.arr,(0),null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMap(meta__$1,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__10648 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__10649 = cljs.core.next(es);
ret = G__10648;
es = G__10649;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentArrayMap.prototype.call = (function() {
var G__10650 = null;
var G__10650__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__10650__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__10650 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__10650__2.call(this,self__,k);
case 3:
return G__10650__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10650.cljs$core$IFn$_invoke$arity$2 = G__10650__2;
G__10650.cljs$core$IFn$_invoke$arity$3 = G__10650__3;
return G__10650;
})()
;

cljs.core.PersistentArrayMap.prototype.apply = (function (self__,args10604){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args10604)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.cljs$lang$type = true;

cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap";

cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/PersistentArrayMap");
});

cljs.core.__GT_PersistentArrayMap = (function __GT_PersistentArrayMap(meta,cnt,arr,__hash){
return (new cljs.core.PersistentArrayMap(meta,cnt,arr,__hash));
});

cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,(0),[],cljs.core.empty_unordered_hash));
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = (8);
cljs.core.PersistentArrayMap.fromArray = (function (arr,no_clone,no_check){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
if(no_check){
var cnt = (arr__$1.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr__$1,null));
} else {
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < len)){
var G__10651 = (i + (2));
var G__10652 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__10651;
ret = G__10652;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
}
});
(cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 56;
this.cljs$lang$protocol_mask$partition0$ = 258;
})
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx >= (0))){
(self__.arr[idx] = (self__.arr[(self__.len - (2))]));

(self__.arr[(idx + (1))] = (self__.arr[(self__.len - (1))]));

var G__10653_10661 = self__.arr;
G__10653_10661.pop();

G__10653_10661.pop();


self__.len = (self__.len - (2));
} else {
}

return tcoll__$1;
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx === (-1))){
if(((self__.len + (2)) <= ((2) * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))){
self__.len = (self__.len + (2));

self__.arr.push(key);

self__.arr.push(val);

return tcoll__$1;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((function (){var G__10654 = self__.len;
var G__10655 = self__.arr;
return (cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2(G__10654,G__10655) : cljs.core.array__GT_transient_hash_map.call(null,G__10654,G__10655));
})(),key,val);
}
} else {
if((val === (self__.arr[(idx + (1))]))){
return tcoll__$1;
} else {
(self__.arr[(idx + (1))] = val);

return tcoll__$1;
}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
if((function (){var G__10656 = o;
if(G__10656){
var bit__5783__auto__ = (G__10656.cljs$lang$protocol_mask$partition0$ & (2048));
if((bit__5783__auto__) || (G__10656.cljs$core$IMapEntry$)){
return true;
} else {
if((!G__10656.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__10656);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__10656);
}
})()){
return cljs.core._assoc_BANG_(tcoll__$1,(function (){var G__10657 = o;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__10657) : cljs.core.key.call(null,G__10657));
})(),(function (){var G__10658 = o;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__10658) : cljs.core.val.call(null,G__10658));
})());
} else {
var es = cljs.core.seq(o);
var tcoll__$2 = tcoll__$1;
while(true){
var temp__4124__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
var G__10662 = cljs.core.next(es);
var G__10663 = cljs.core._assoc_BANG_(tcoll__$2,(function (){var G__10659 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__10659) : cljs.core.key.call(null,G__10659));
})(),(function (){var G__10660 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__10660) : cljs.core.val.call(null,G__10660));
})());
es = G__10662;
tcoll__$2 = G__10663;
continue;
} else {
return tcoll__$2;
}
break;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
self__.editable_QMARK_ = false;

return (new cljs.core.PersistentArrayMap(null,cljs.core.quot(self__.len,(2)),self__.arr,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,k,null);
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
} else {
throw (new Error("lookup after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
return cljs.core.quot(self__.len,(2));
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientArrayMap.cljs$lang$type = true;

cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap";

cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/TransientArrayMap");
});

cljs.core.__GT_TransientArrayMap = (function __GT_TransientArrayMap(editable_QMARK_,len,arr){
return (new cljs.core.TransientArrayMap(editable_QMARK_,len,arr));
});


cljs.core.array__GT_transient_hash_map = (function array__GT_transient_hash_map(len,arr){
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i = (0);
while(true){
if((i < len)){
var G__10664 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,(arr[i]),(arr[(i + (1))]));
var G__10665 = (i + (2));
out = G__10664;
i = G__10665;
continue;
} else {
return out;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
})

cljs.core.Box.cljs$lang$type = true;

cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box";

cljs.core.Box.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/Box");
});

cljs.core.__GT_Box = (function __GT_Box(val){
return (new cljs.core.Box(val));
});






cljs.core.key_test = (function key_test(key,other){
if((key === other)){
return true;
} else {
if(cljs.core.keyword_identical_QMARK_(key,other)){
return true;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,other);

}
}
});
cljs.core.mask = (function mask(hash,shift){
return ((hash >>> shift) & (31));
});
cljs.core.clone_and_set = (function() {
var clone_and_set = null;
var clone_and_set__3 = (function (arr,i,a){
var G__10668 = cljs.core.aclone(arr);
(G__10668[i] = a);

return G__10668;
});
var clone_and_set__5 = (function (arr,i,a,j,b){
var G__10669 = cljs.core.aclone(arr);
(G__10669[i] = a);

(G__10669[j] = b);

return G__10669;
});
clone_and_set = function(arr,i,a,j,b){
switch(arguments.length){
case 3:
return clone_and_set__3.call(this,arr,i,a);
case 5:
return clone_and_set__5.call(this,arr,i,a,j,b);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
clone_and_set.cljs$core$IFn$_invoke$arity$3 = clone_and_set__3;
clone_and_set.cljs$core$IFn$_invoke$arity$5 = clone_and_set__5;
return clone_and_set;
})()
;
cljs.core.remove_pair = (function remove_pair(arr,i){
var new_arr = (new Array((arr.length - (2))));
cljs.core.array_copy(arr,(0),new_arr,(0),((2) * i));

cljs.core.array_copy(arr,((2) * (i + (1))),new_arr,((2) * i),(new_arr.length - ((2) * i)));

return new_arr;
});
cljs.core.bitmap_indexed_node_index = (function bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count((bitmap & (bit - (1))));
});
cljs.core.bitpos = (function bitpos(hash,shift){
return ((1) << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function() {
var edit_and_set = null;
var edit_and_set__4 = (function (inode,edit,i,a){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

return editable;
});
var edit_and_set__6 = (function (inode,edit,i,a,j,b){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

(editable.arr[j] = b);

return editable;
});
edit_and_set = function(inode,edit,i,a,j,b){
switch(arguments.length){
case 4:
return edit_and_set__4.call(this,inode,edit,i,a);
case 6:
return edit_and_set__6.call(this,inode,edit,i,a,j,b);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
edit_and_set.cljs$core$IFn$_invoke$arity$4 = edit_and_set__4;
edit_and_set.cljs$core$IFn$_invoke$arity$6 = edit_and_set__6;
return edit_and_set;
})()
;
cljs.core.inode_kv_reduce = (function inode_kv_reduce(arr,f,init){
var len = arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var k = (arr[i]);
if(!((k == null))){
var G__10674 = init__$1;
var G__10675 = k;
var G__10676 = (arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10674,G__10675,G__10676) : f.call(null,G__10674,G__10675,G__10676));
} else {
var node = (arr[(i + (1))]);
if(!((node == null))){
return node.kv_reduce(f,init__$1);
} else {
return init__$1;
}
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__10677 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10677) : cljs.core.deref.call(null,G__10677));
} else {
var G__10678 = (i + (2));
var G__10679 = init__$2;
i = G__10678;
init__$1 = G__10679;
continue;
}
} else {
return init__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
})
cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var n = cljs.core.bit_count(self__.bitmap);
var new_arr = (new Array((((n < (0)))?(4):((2) * (n + (1))))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * n));

return (new cljs.core.BitmapIndexedNode(e,self__.bitmap,new_arr));
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
} else {
if((self__.bitmap === bit)){
return null;
} else {
return inode.edit_and_remove_pair(edit__$1,bit,idx);

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
(removed_leaf_QMARK_[(0)] = true);

return inode.edit_and_remove_pair(edit__$1,bit,idx);
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function (e,bit,i){
var self__ = this;
var inode = this;
if((self__.bitmap === bit)){
return null;
} else {
var editable = inode.ensure_editable(e);
var earr = editable.arr;
var len = earr.length;
editable.bitmap = (bit ^ editable.bitmap);

cljs.core.array_copy(earr,((2) * (i + (1))),earr,((2) * i),(len - ((2) * (i + (1)))));

(earr[(len - (2))] = null);

(earr[(len - (1))] = null);

return editable;
}
});

cljs.core.BitmapIndexedNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__10680 = self__.arr;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__10680) : cljs.core.create_inode_seq.call(null,G__10680));
});

cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return val_or_node;
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((((2) * n) < self__.arr.length)){
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
added_leaf_QMARK_.val = true;

cljs.core.array_copy_downward(earr,((2) * idx),earr,((2) * (idx + (1))),((2) * (n - idx)));

(earr[((2) * idx)] = key);

(earr[(((2) * idx) + (1))] = val);

editable.bitmap = (editable.bitmap | bit);

return editable;
} else {
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_10694 = (0);
var j_10695 = (0);
while(true){
if((i_10694 < (32))){
if((((self__.bitmap >>> i_10694) & (1)) === (0))){
var G__10696 = (i_10694 + (1));
var G__10697 = j_10695;
i_10694 = G__10696;
j_10695 = G__10697;
continue;
} else {
(nodes[i_10694] = ((!(((self__.arr[j_10695]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),cljs.core.hash((self__.arr[j_10695])),(self__.arr[j_10695]),(self__.arr[(j_10695 + (1))]),added_leaf_QMARK_):(self__.arr[(j_10695 + (1))])));

var G__10698 = (i_10694 + (1));
var G__10699 = (j_10695 + (2));
i_10694 = G__10698;
j_10695 = G__10699;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(edit__$1,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (4)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

var editable = inode.ensure_editable(edit__$1);
editable.arr = new_arr;

editable.bitmap = (editable.bitmap | bit);

return editable;

}
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),val);
}
} else {
added_leaf_QMARK_.val = true;

return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__10681 = edit__$1;
var G__10682 = (shift + (5));
var G__10683 = key_or_nil;
var G__10684 = val_or_node;
var G__10685 = hash;
var G__10686 = key;
var G__10687 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(G__10681,G__10682,G__10683,G__10684,G__10685,G__10686,G__10687) : cljs.core.create_node.call(null,G__10681,G__10682,G__10683,G__10684,G__10685,G__10686,G__10687));
})());

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_10700 = (0);
var j_10701 = (0);
while(true){
if((i_10700 < (32))){
if((((self__.bitmap >>> i_10700) & (1)) === (0))){
var G__10702 = (i_10700 + (1));
var G__10703 = j_10701;
i_10700 = G__10702;
j_10701 = G__10703;
continue;
} else {
(nodes[i_10700] = ((!(((self__.arr[j_10701]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),cljs.core.hash((self__.arr[j_10701])),(self__.arr[j_10701]),(self__.arr[(j_10701 + (1))]),added_leaf_QMARK_):(self__.arr[(j_10701 + (1))])));

var G__10704 = (i_10700 + (1));
var G__10705 = (j_10701 + (2));
i_10700 = G__10704;
j_10701 = G__10705;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(null,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap | bit),new_arr));
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),val)));
}
} else {
added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__10688 = (shift + (5));
var G__10689 = key_or_nil;
var G__10690 = val_or_node;
var G__10691 = hash;
var G__10692 = key;
var G__10693 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(G__10688,G__10689,G__10690,G__10691,G__10692,G__10693) : cljs.core.create_node.call(null,G__10688,G__10689,G__10690,G__10691,G__10692,G__10693));
})())));

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_find((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_or_nil,val_or_node], null);
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without((shift + (5)),hash,key);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
} else {
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.cljs$lang$type = true;

cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode";

cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/BitmapIndexedNode");
});

cljs.core.__GT_BitmapIndexedNode = (function __GT_BitmapIndexedNode(edit,bitmap,arr){
return (new cljs.core.BitmapIndexedNode(edit,bitmap,arr));
});

cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,(0),[]));
cljs.core.pack_array_node = (function pack_array_node(array_node,edit,idx){
var arr = array_node.arr;
var len = arr.length;
var new_arr = (new Array(((2) * (array_node.cnt - (1)))));
var i = (0);
var j = (1);
var bitmap = (0);
while(true){
if((i < len)){
if((!((i === idx))) && (!(((arr[i]) == null)))){
(new_arr[j] = (arr[i]));

var G__10706 = (i + (1));
var G__10707 = (j + (2));
var G__10708 = (bitmap | ((1) << i));
i = G__10706;
j = G__10707;
bitmap = G__10708;
continue;
} else {
var G__10709 = (i + (1));
var G__10710 = j;
var G__10711 = bitmap;
i = G__10709;
j = G__10710;
bitmap = G__10711;
continue;
}
} else {
return (new cljs.core.BitmapIndexedNode(edit,bitmap,new_arr));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.ArrayNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
return (new cljs.core.ArrayNode(e,self__.cnt,cljs.core.aclone(self__.arr)));
}
});

cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return inode;
} else {
var n = node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,edit__$1,idx);
} else {
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
editable.cnt = (editable.cnt - (1));

return editable;
}
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);

}
}
}
});

cljs.core.ArrayNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__10712 = self__.arr;
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(G__10712) : cljs.core.create_array_node_seq.call(null,G__10712));
});

cljs.core.ArrayNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var node = (self__.arr[i]);
if(!((node == null))){
var init__$2 = node.kv_reduce(f,init__$1);
if(cljs.core.reduced_QMARK_(init__$2)){
var G__10713 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10713) : cljs.core.deref.call(null,G__10713));
} else {
var G__10714 = (i + (1));
var G__10715 = init__$2;
i = G__10714;
init__$1 = G__10715;
continue;
}
} else {
var G__10716 = (i + (1));
var G__10717 = init__$1;
i = G__10716;
init__$1 = G__10717;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ArrayNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));
editable.cnt = (editable.cnt + (1));

return editable;
} else {
var n = node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
}
}
});

cljs.core.ArrayNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return (new cljs.core.ArrayNode(null,(self__.cnt + (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_))));
} else {
var n = node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
}
});

cljs.core.ArrayNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_find((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
var n = node.inode_without((shift + (5)),hash,key);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,null,idx);
} else {
return (new cljs.core.ArrayNode(null,(self__.cnt - (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));

}
}
} else {
return inode;
}
});

cljs.core.ArrayNode.cljs$lang$type = true;

cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode";

cljs.core.ArrayNode.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/ArrayNode");
});

cljs.core.__GT_ArrayNode = (function __GT_ArrayNode(edit,cnt,arr){
return (new cljs.core.ArrayNode(edit,cnt,arr));
});

cljs.core.hash_collision_node_find_index = (function hash_collision_node_find_index(arr,cnt,key){
var lim = ((2) * cnt);
var i = (0);
while(true){
if((i < lim)){
if(cljs.core.key_test(key,(arr[i]))){
return i;
} else {
var G__10718 = (i + (2));
i = G__10718;
continue;
}
} else {
return (-1);
}
break;
}
});

/**
* @constructor
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.HashCollisionNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var new_arr = (new Array(((2) * (self__.cnt + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * self__.cnt));

return (new cljs.core.HashCollisionNode(e,self__.collision_hash,self__.cnt,new_arr));
}
});

cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
(removed_leaf_QMARK_[(0)] = true);

if((self__.cnt === (1))){
return null;
} else {
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(earr[idx] = (earr[(((2) * self__.cnt) - (2))]));

(earr[(idx + (1))] = (earr[(((2) * self__.cnt) - (1))]));

(earr[(((2) * self__.cnt) - (1))] = null);

(earr[(((2) * self__.cnt) - (2))] = null);

editable.cnt = (editable.cnt - (1));

return editable;
}
}
});

cljs.core.HashCollisionNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__10719 = self__.arr;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__10719) : cljs.core.create_inode_seq.call(null,G__10719));
});

cljs.core.HashCollisionNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.HashCollisionNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (self__.arr[(idx + (1))]);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
if((self__.arr.length > ((2) * self__.cnt))){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * self__.cnt),key,(((2) * self__.cnt) + (1)),val);
added_leaf_QMARK_.val = true;

editable.cnt = (editable.cnt + (1));

return editable;
} else {
var len = self__.arr.length;
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return inode.ensure_editable_array(edit__$1,(self__.cnt + (1)),new_arr);
}
} else {
if(((self__.arr[(idx + (1))]) === val)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(idx + (1)),val);
}
}
} else {
return (new cljs.core.BitmapIndexedNode(edit__$1,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode,null,null])).inode_assoc_BANG_(edit__$1,shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
var len = ((2) * self__.cnt);
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt + (1)),new_arr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[idx]),val)){
return inode;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(idx + (1)),val)));
}
}
} else {
return (new cljs.core.BitmapIndexedNode(null,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function (e,count,array){
var self__ = this;
var inode = this;
if((e === self__.edit)){
self__.arr = array;

self__.cnt = count;

return inode;
} else {
return (new cljs.core.HashCollisionNode(self__.edit,self__.collision_hash,count,array));
}
});

cljs.core.HashCollisionNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[idx]),(self__.arr[(idx + (1))])], null);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
if((self__.cnt === (1))){
return null;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt - (1)),cljs.core.remove_pair(self__.arr,cljs.core.quot(idx,(2)))));

}
}
});

cljs.core.HashCollisionNode.cljs$lang$type = true;

cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode";

cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/HashCollisionNode");
});

cljs.core.__GT_HashCollisionNode = (function __GT_HashCollisionNode(edit,collision_hash,cnt,arr){
return (new cljs.core.HashCollisionNode(edit,collision_hash,cnt,arr));
});

cljs.core.create_node = (function() {
var create_node = null;
var create_node__6 = (function (shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});
var create_node__7 = (function (edit,shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});
create_node = function(edit,shift,key1,val1,key2hash,key2,val2){
switch(arguments.length){
case 6:
return create_node__6.call(this,edit,shift,key1,val1,key2hash,key2);
case 7:
return create_node__7.call(this,edit,shift,key1,val1,key2hash,key2,val2);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
create_node.cljs$core$IFn$_invoke$arity$6 = create_node__6;
create_node.cljs$core$IFn$_invoke$arity$7 = create_node__7;
return create_node;
})()
;

/**
* @constructor
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
})
cljs.core.NodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.NodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5523__auto__ = self__.__hash;
if(!((h__5523__auto__ == null))){
return h__5523__auto__;
} else {
var h__5523__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5523__auto____$1;

return h__5523__auto____$1;
}
});

cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.nodes[self__.i]),(self__.nodes[(self__.i + (1))])], null);
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
var G__10720 = self__.nodes;
var G__10721 = (self__.i + (2));
var G__10722 = null;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__10720,G__10721,G__10722) : cljs.core.create_inode_seq.call(null,G__10720,G__10721,G__10722));
} else {
var G__10723 = self__.nodes;
var G__10724 = self__.i;
var G__10725 = cljs.core.next(self__.s);
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__10723,G__10724,G__10725) : cljs.core.create_inode_seq.call(null,G__10723,G__10724,G__10725));
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.NodeSeq.cljs$lang$type = true;

cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq";

cljs.core.NodeSeq.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/NodeSeq");
});

cljs.core.__GT_NodeSeq = (function __GT_NodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.NodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));
cljs.core.create_inode_seq = (function() {
var create_inode_seq = null;
var create_inode_seq__1 = (function (nodes){
return create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
});
var create_inode_seq__3 = (function (nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
if(!(((nodes[j]) == null))){
return (new cljs.core.NodeSeq(null,nodes,j,null,null));
} else {
var temp__4124__auto__ = (nodes[(j + (1))]);
if(cljs.core.truth_(temp__4124__auto__)){
var node = temp__4124__auto__;
var temp__4124__auto____$1 = node.inode_seq();
if(cljs.core.truth_(temp__4124__auto____$1)){
var node_seq = temp__4124__auto____$1;
return (new cljs.core.NodeSeq(null,nodes,(j + (2)),node_seq,null));
} else {
var G__10729 = (j + (2));
j = G__10729;
continue;
}
} else {
var G__10730 = (j + (2));
j = G__10730;
continue;
}
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
});
create_inode_seq = function(nodes,i,s){
switch(arguments.length){
case 1:
return create_inode_seq__1.call(this,nodes);
case 3:
return create_inode_seq__3.call(this,nodes,i,s);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
create_inode_seq.cljs$core$IFn$_invoke$arity$1 = create_inode_seq__1;
create_inode_seq.cljs$core$IFn$_invoke$arity$3 = create_inode_seq__3;
return create_inode_seq;
})()
;

/**
* @constructor
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
})
cljs.core.ArrayNodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ArrayNodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5523__auto__ = self__.__hash;
if(!((h__5523__auto__ == null))){
return h__5523__auto__;
} else {
var h__5523__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5523__auto____$1;

return h__5523__auto____$1;
}
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.s);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__10731 = null;
var G__10732 = self__.nodes;
var G__10733 = self__.i;
var G__10734 = cljs.core.next(self__.s);
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(G__10731,G__10732,G__10733,G__10734) : cljs.core.create_array_node_seq.call(null,G__10731,G__10732,G__10733,G__10734));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ArrayNodeSeq.cljs$lang$type = true;

cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq";

cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/ArrayNodeSeq");
});

cljs.core.__GT_ArrayNodeSeq = (function __GT_ArrayNodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));
cljs.core.create_array_node_seq = (function() {
var create_array_node_seq = null;
var create_array_node_seq__1 = (function (nodes){
return create_array_node_seq.cljs$core$IFn$_invoke$arity$4(null,nodes,(0),null);
});
var create_array_node_seq__4 = (function (meta,nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
var temp__4124__auto__ = (nodes[j]);
if(cljs.core.truth_(temp__4124__auto__)){
var nj = temp__4124__auto__;
var temp__4124__auto____$1 = nj.inode_seq();
if(cljs.core.truth_(temp__4124__auto____$1)){
var ns = temp__4124__auto____$1;
return (new cljs.core.ArrayNodeSeq(meta,nodes,(j + (1)),ns,null));
} else {
var G__10739 = (j + (1));
j = G__10739;
continue;
}
} else {
var G__10740 = (j + (1));
j = G__10740;
continue;
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,null));
}
});
create_array_node_seq = function(meta,nodes,i,s){
switch(arguments.length){
case 1:
return create_array_node_seq__1.call(this,meta);
case 4:
return create_array_node_seq__4.call(this,meta,nodes,i,s);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = create_array_node_seq__1;
create_array_node_seq.cljs$core$IFn$_invoke$arity$4 = create_array_node_seq__4;
return create_array_node_seq;
})()
;

/**
* @constructor
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__10742 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__10742) : cljs.core.keys.call(null,G__10742));
})());
});

cljs.core.PersistentHashMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__10743 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__10743) : cljs.core.vals.call(null,G__10743));
})());
});

cljs.core.PersistentHashMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashMap.prototype.get = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__10744 = cljs.core.seq(coll);
var chunk__10745 = null;
var count__10746 = (0);
var i__10747 = (0);
while(true){
if((i__10747 < count__10746)){
var vec__10748 = chunk__10745.cljs$core$IIndexed$_nth$arity$2(null,i__10747);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10748,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10748,(1),null);
var G__10749_10760 = v;
var G__10750_10761 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10749_10760,G__10750_10761) : f.call(null,G__10749_10760,G__10750_10761));

var G__10762 = seq__10744;
var G__10763 = chunk__10745;
var G__10764 = count__10746;
var G__10765 = (i__10747 + (1));
seq__10744 = G__10762;
chunk__10745 = G__10763;
count__10746 = G__10764;
i__10747 = G__10765;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__10744);
if(temp__4126__auto__){
var seq__10744__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10744__$1)){
var c__5889__auto__ = cljs.core.chunk_first(seq__10744__$1);
var G__10766 = cljs.core.chunk_rest(seq__10744__$1);
var G__10767 = c__5889__auto__;
var G__10768 = cljs.core.count(c__5889__auto__);
var G__10769 = (0);
seq__10744 = G__10766;
chunk__10745 = G__10767;
count__10746 = G__10768;
i__10747 = G__10769;
continue;
} else {
var vec__10751 = cljs.core.first(seq__10744__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10751,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10751,(1),null);
var G__10752_10770 = v;
var G__10753_10771 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10752_10770,G__10753_10771) : f.call(null,G__10752_10770,G__10753_10771));

var G__10772 = cljs.core.next(seq__10744__$1);
var G__10773 = null;
var G__10774 = (0);
var G__10775 = (0);
seq__10744 = G__10772;
chunk__10745 = G__10773;
count__10746 = G__10774;
i__10747 = G__10775;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var init__$1 = ((self__.has_nil_QMARK_)?(function (){var G__10754 = init;
var G__10755 = null;
var G__10756 = self__.nil_val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10754,G__10755,G__10756) : f.call(null,G__10754,G__10755,G__10756));
})():init);
if(cljs.core.reduced_QMARK_(init__$1)){
var G__10757 = init__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10757) : cljs.core.deref.call(null,G__10757));
} else {
if(!((self__.root == null))){
return self__.root.kv_reduce(f,init__$1);
} else {
return init__$1;

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashMap(self__.meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5523__auto__ = self__.__hash;
if(!((h__5523__auto__ == null))){
return h__5523__auto__;
} else {
var h__5523__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__5523__auto____$1;

return h__5523__auto____$1;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashMap((function (){var obj10759 = {};
return obj10759;
})(),self__.root,self__.cnt,self__.has_nil_QMARK_,self__.nil_val));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY,self__.meta);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),self__.root,false,null,null));
} else {
return coll__$1;
}
} else {
if((self__.root == null)){
return coll__$1;
} else {
var new_root = self__.root.inode_without((0),cljs.core.hash(k),k);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if((self__.has_nil_QMARK_) && ((v === self__.nil_val))){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((self__.has_nil_QMARK_)?self__.cnt:(self__.cnt + (1))),self__.root,true,v,null));
}
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var new_root = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc((0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((added_leaf_QMARK_.val)?(self__.cnt + (1)):self__.cnt),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
return self__.has_nil_QMARK_;
} else {
if((self__.root == null)){
return false;
} else {
return !((self__.root.inode_lookup((0),cljs.core.hash(k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel));

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var s = ((!((self__.root == null)))?self__.root.inode_seq():null);
if(self__.has_nil_QMARK_){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,self__.nil_val], null),s);
} else {
return s;
}
} else {
return null;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashMap(meta__$1,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__10776 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__10777 = cljs.core.next(es);
ret = G__10776;
es = G__10777;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentHashMap.prototype.call = (function() {
var G__10778 = null;
var G__10778__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__10778__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__10778 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__10778__2.call(this,self__,k);
case 3:
return G__10778__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10778.cljs$core$IFn$_invoke$arity$2 = G__10778__2;
G__10778.cljs$core$IFn$_invoke$arity$3 = G__10778__3;
return G__10778;
})()
;

cljs.core.PersistentHashMap.prototype.apply = (function (self__,args10741){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args10741)));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.cljs$lang$type = true;

cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap";

cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/PersistentHashMap");
});

cljs.core.__GT_PersistentHashMap = (function __GT_PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
return (new cljs.core.PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash));
});

cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,(0),null,false,null,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashMap.fromArray = (function (arr,no_clone){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__10779 = (i + (2));
var G__10780 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__10779;
ret = G__10780;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
});
cljs.core.PersistentHashMap.fromArrays = (function (ks,vs){
var len = ks.length;
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__10781 = (i + (1));
var G__10782 = out.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(ks[i]),(vs[i]));
i = G__10781;
out = G__10782;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});
(cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition1$ = 56;
this.cljs$lang$protocol_mask$partition0$ = 258;
})
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.without_BANG_(key);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.assoc_BANG_(key,val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.conj_BANG_(val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.persistent_BANG_();
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.edit){
return self__.count;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.conj_BANG_ = (function (o){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((function (){var G__10783 = o;
if(G__10783){
var bit__5783__auto__ = (G__10783.cljs$lang$protocol_mask$partition0$ & (2048));
if((bit__5783__auto__) || (G__10783.cljs$core$IMapEntry$)){
return true;
} else {
if((!G__10783.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__10783);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__10783);
}
})()){
return tcoll.assoc_BANG_((function (){var G__10784 = o;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__10784) : cljs.core.key.call(null,G__10784));
})(),(function (){var G__10785 = o;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__10785) : cljs.core.val.call(null,G__10785));
})());
} else {
var es = cljs.core.seq(o);
var tcoll__$1 = tcoll;
while(true){
var temp__4124__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
var G__10788 = cljs.core.next(es);
var G__10789 = tcoll__$1.assoc_BANG_((function (){var G__10786 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__10786) : cljs.core.key.call(null,G__10786));
})(),(function (){var G__10787 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__10787) : cljs.core.val.call(null,G__10787));
})());
es = G__10788;
tcoll__$1 = G__10789;
continue;
} else {
return tcoll__$1;
}
break;
}
}
} else {
throw (new Error("conj! after persistent"));
}
});

cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function (k,v){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if((self__.nil_val === v)){
} else {
self__.nil_val = v;
}

if(self__.has_nil_QMARK_){
} else {
self__.count = (self__.count + (1));

self__.has_nil_QMARK_ = true;
}

return tcoll;
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var node = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc_BANG_(self__.edit,(0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(added_leaf_QMARK_.val){
self__.count = (self__.count + (1));
} else {
}

return tcoll;
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.without_BANG_ = (function (k){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if(self__.has_nil_QMARK_){
self__.has_nil_QMARK_ = false;

self__.nil_val = null;

self__.count = (self__.count - (1));

return tcoll;
} else {
return tcoll;
}
} else {
if((self__.root == null)){
return tcoll;
} else {
var removed_leaf_QMARK_ = (new cljs.core.Box(false));
var node = self__.root.inode_without_BANG_(self__.edit,(0),cljs.core.hash(k),k,removed_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(cljs.core.truth_((removed_leaf_QMARK_[(0)]))){
self__.count = (self__.count - (1));
} else {
}

return tcoll;
}
}
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function (){
var self__ = this;
var tcoll = this;
if(self__.edit){
self__.edit = null;

return (new cljs.core.PersistentHashMap(null,self__.count,self__.root,self__.has_nil_QMARK_,self__.nil_val,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientHashMap.cljs$lang$type = true;

cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap";

cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/TransientHashMap");
});

cljs.core.__GT_TransientHashMap = (function __GT_TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val){
return (new cljs.core.TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val));
});

cljs.core.tree_map_seq_push = (function tree_map_seq_push(node,stack,ascending_QMARK_){
var t = node;
var stack__$1 = stack;
while(true){
if(!((t == null))){
var G__10790 = ((ascending_QMARK_)?t.left:t.right);
var G__10791 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1,t);
t = G__10790;
stack__$1 = G__10791;
continue;
} else {
return stack__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374862;
})
cljs.core.PersistentTreeMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt < (0))){
return (cljs.core.count(cljs.core.next(coll__$1)) + (1));
} else {
return self__.cnt;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5523__auto__ = self__.__hash;
if(!((h__5523__auto__ == null))){
return h__5523__auto__;
} else {
var h__5523__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5523__auto____$1;

return h__5523__auto____$1;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.peek(self__.stack);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if(!((next_stack == null))){
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMapSeq(meta__$1,self__.stack,self__.ascending_QMARK_,self__.cnt,self__.__hash));
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq";

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/PersistentTreeMapSeq");
});

cljs.core.__GT_PersistentTreeMapSeq = (function __GT_PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash){
return (new cljs.core.PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash));
});

(cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));
cljs.core.create_tree_map_seq = (function create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push(tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});

cljs.core.balance_left = (function balance_left(key,val,ins,right){
if((ins instanceof cljs.core.RedNode)){
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else {
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function balance_right(key,val,left,ins){
if((ins instanceof cljs.core.RedNode)){
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else {
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function balance_left_del(key,val,del,right){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else {
if((right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right(key,val,del,right.redden());
} else {
if(((right instanceof cljs.core.RedNode)) && ((right.left instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right(right.key,right.val,right.left.right,right.right.redden()),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.balance_right_del = (function balance_right_del(key,val,left,del){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else {
if((left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left(key,val,left.redden(),del);
} else {
if(((left instanceof cljs.core.RedNode)) && ((left.right instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left(left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.tree_map_kv_reduce = (function tree_map_kv_reduce(node,f,init){
var init__$1 = ((!((node.left == null)))?tree_map_kv_reduce(node.left,f,init):init);
if(cljs.core.reduced_QMARK_(init__$1)){
var G__10804 = init__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10804) : cljs.core.deref.call(null,G__10804));
} else {
var init__$2 = (function (){var G__10805 = init__$1;
var G__10806 = node.key;
var G__10807 = node.val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10805,G__10806,G__10807) : f.call(null,G__10805,G__10806,G__10807));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__10808 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10808) : cljs.core.deref.call(null,G__10808));
} else {
var init__$3 = ((!((node.right == null)))?tree_map_kv_reduce(node.right,f,init__$2):init__$2);
if(cljs.core.reduced_QMARK_(init__$3)){
var G__10809 = init__$3;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10809) : cljs.core.deref.call(null,G__10809));
} else {
return init__$3;
}
}
}
});

/**
* @constructor
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
})
cljs.core.BlackNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return ins.balance_right(node);
});

cljs.core.BlackNode.prototype.redden = (function (){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.BlackNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return node;
});

cljs.core.BlackNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return ins.balance_left(node);
});

cljs.core.BlackNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.BlackNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));
});

cljs.core.BlackNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));
});

cljs.core.BlackNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_left_del(self__.key,self__.val,del,self__.right);
});

cljs.core.BlackNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.BlackNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_right_del(self__.key,self__.val,self__.left,del);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5523__auto__ = self__.__hash;
if(!((h__5523__auto__ == null))){
return h__5523__auto__;
} else {
var h__5523__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5523__auto____$1;

return h__5523__auto____$1;
}
});

cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY,self__.val),self__.key);
});

cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.BlackNode.prototype.call = (function() {
var G__10811 = null;
var G__10811__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__10811__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__10811 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__10811__2.call(this,self__,k);
case 3:
return G__10811__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10811.cljs$core$IFn$_invoke$arity$2 = G__10811__2;
G__10811.cljs$core$IFn$_invoke$arity$3 = G__10811__3;
return G__10811;
})()
;

cljs.core.BlackNode.prototype.apply = (function (self__,args10810){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args10810)));
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.BlackNode.cljs$lang$type = true;

cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode";

cljs.core.BlackNode.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/BlackNode");
});

cljs.core.__GT_BlackNode = (function __GT_BlackNode(key,val,left,right,__hash){
return (new cljs.core.BlackNode(key,val,left,right,__hash));
});

(cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));

/**
* @constructor
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
})
cljs.core.RedNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,ins,null));
});

cljs.core.RedNode.prototype.redden = (function (){
var self__ = this;
var node = this;
throw (new Error("red-black tree invariant violation"));
});

cljs.core.RedNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.RedNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,ins,self__.right,null));
});

cljs.core.RedNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.RedNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,self__.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,self__.right,parent.right,null)),null));
} else {
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.right.key,self__.right.val,(new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,self__.right.right,parent.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));

}
}
});

cljs.core.RedNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left,null)),self__.right.blacken(),null));
} else {
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.left.key,self__.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left.left,null)),(new cljs.core.BlackNode(self__.key,self__.val,self__.left.right,self__.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));

}
}
});

cljs.core.RedNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,del,self__.right,null));
});

cljs.core.RedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.RedNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,del,null));
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5523__auto__ = self__.__hash;
if(!((h__5523__auto__ == null))){
return h__5523__auto__;
} else {
var h__5523__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5523__auto____$1;

return h__5523__auto____$1;
}
});

cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY,self__.val),self__.key);
});

cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.RedNode.prototype.call = (function() {
var G__10813 = null;
var G__10813__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__10813__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__10813 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__10813__2.call(this,self__,k);
case 3:
return G__10813__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10813.cljs$core$IFn$_invoke$arity$2 = G__10813__2;
G__10813.cljs$core$IFn$_invoke$arity$3 = G__10813__3;
return G__10813;
})()
;

cljs.core.RedNode.prototype.apply = (function (self__,args10812){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args10812)));
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.RedNode.cljs$lang$type = true;

cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode";

cljs.core.RedNode.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/RedNode");
});

cljs.core.__GT_RedNode = (function __GT_RedNode(key,val,left,right,__hash){
return (new cljs.core.RedNode(key,val,left,right,__hash));
});

(cljs.core.RedNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));
cljs.core.tree_map_add = (function tree_map_add(comp,tree,k,v,found){
if((tree == null)){
return (new cljs.core.RedNode(k,v,null,null,null));
} else {
var c = (function (){var G__10826 = k;
var G__10827 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__10826,G__10827) : comp.call(null,G__10826,G__10827));
})();
if((c === (0))){
(found[(0)] = tree);

return null;
} else {
if((c < (0))){
var ins = tree_map_add(comp,tree.left,k,v,found);
if(!((ins == null))){
return tree.add_left(ins);
} else {
return null;
}
} else {
var ins = tree_map_add(comp,tree.right,k,v,found);
if(!((ins == null))){
return tree.add_right(ins);
} else {
return null;
}

}
}
}
});
cljs.core.tree_map_append = (function tree_map_append(left,right){
if((left == null)){
return right;
} else {
if((right == null)){
return left;
} else {
if((left instanceof cljs.core.RedNode)){
if((right instanceof cljs.core.RedNode)){
var app = tree_map_append(left.right,right.left);
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.RedNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.RedNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(new cljs.core.RedNode(right.key,right.val,app,right.right,null)),null));
}
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,tree_map_append(left.right,right),null));
}
} else {
if((right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(right.key,right.val,tree_map_append(left,right.left),right.right,null));
} else {
var app = tree_map_append(left.right,right.left);
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.BlackNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.BlackNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return cljs.core.balance_left_del(left.key,left.val,left.left,(new cljs.core.BlackNode(right.key,right.val,app,right.right,null)));
}

}
}
}
}
});
cljs.core.tree_map_remove = (function tree_map_remove(comp,tree,k,found){
if(!((tree == null))){
var c = (function (){var G__10846 = k;
var G__10847 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__10846,G__10847) : comp.call(null,G__10846,G__10847));
})();
if((c === (0))){
(found[(0)] = tree);

return cljs.core.tree_map_append(tree.left,tree.right);
} else {
if((c < (0))){
var del = tree_map_remove(comp,tree.left,k,found);
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left_del(tree.key,tree.val,del,tree.right);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,del,tree.right,null));
}
} else {
return null;
}
} else {
var del = tree_map_remove(comp,tree.right,k,found);
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right_del(tree.key,tree.val,tree.left,del);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,tree.left,del,null));
}
} else {
return null;
}

}
}
} else {
return null;
}
});
cljs.core.tree_map_replace = (function tree_map_replace(comp,tree,k,v){
var tk = tree.key;
var c = (function (){var G__10858 = k;
var G__10859 = tk;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__10858,G__10859) : comp.call(null,G__10858,G__10859));
})();
if((c === (0))){
return tree.replace(tk,v,tree.left,tree.right);
} else {
if((c < (0))){
return tree.replace(tk,tree.val,tree_map_replace(comp,tree.left,k,v),tree.right);
} else {
return tree.replace(tk,tree.val,tree.left,tree_map_replace(comp,tree.right,k,v));

}
}
});

/**
* @constructor
*/
cljs.core.PersistentTreeMap = (function (comp,tree,cnt,meta,__hash){
this.comp = comp;
this.tree = tree;
this.cnt = cnt;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 418776847;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__10861 = cljs.core.seq(coll);
var chunk__10862 = null;
var count__10863 = (0);
var i__10864 = (0);
while(true){
if((i__10864 < count__10863)){
var vec__10865 = chunk__10862.cljs$core$IIndexed$_nth$arity$2(null,i__10864);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10865,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10865,(1),null);
var G__10866_10878 = v;
var G__10867_10879 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10866_10878,G__10867_10879) : f.call(null,G__10866_10878,G__10867_10879));

var G__10880 = seq__10861;
var G__10881 = chunk__10862;
var G__10882 = count__10863;
var G__10883 = (i__10864 + (1));
seq__10861 = G__10880;
chunk__10862 = G__10881;
count__10863 = G__10882;
i__10864 = G__10883;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__10861);
if(temp__4126__auto__){
var seq__10861__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10861__$1)){
var c__5889__auto__ = cljs.core.chunk_first(seq__10861__$1);
var G__10884 = cljs.core.chunk_rest(seq__10861__$1);
var G__10885 = c__5889__auto__;
var G__10886 = cljs.core.count(c__5889__auto__);
var G__10887 = (0);
seq__10861 = G__10884;
chunk__10862 = G__10885;
count__10863 = G__10886;
i__10864 = G__10887;
continue;
} else {
var vec__10868 = cljs.core.first(seq__10861__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10868,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10868,(1),null);
var G__10869_10888 = v;
var G__10870_10889 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10869_10888,G__10870_10889) : f.call(null,G__10869_10888,G__10870_10889));

var G__10890 = cljs.core.next(seq__10861__$1);
var G__10891 = null;
var G__10892 = (0);
var G__10893 = (0);
seq__10861 = G__10890;
chunk__10862 = G__10891;
count__10863 = G__10892;
i__10864 = G__10893;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.get = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__10871 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__10871) : cljs.core.keys.call(null,G__10871));
})());
});

cljs.core.PersistentTreeMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__10872 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__10872) : cljs.core.vals.call(null,G__10872));
})());
});

cljs.core.PersistentTreeMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMap.prototype.entry_at = (function (k){
var self__ = this;
var coll = this;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__10873 = k;
var G__10874 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__10873,G__10874) : self__.comp.call(null,G__10873,G__10874));
})();
if((c === (0))){
return t;
} else {
if((c < (0))){
var G__10894 = t.left;
t = G__10894;
continue;
} else {
var G__10895 = t.right;
t = G__10895;
continue;

}
}
} else {
return null;
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var n = coll__$1.entry_at(k);
if(!((n == null))){
return n.val;
} else {
return not_found;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
if(!((self__.tree == null))){
return cljs.core.tree_map_kv_reduce(self__.tree,f,init);
} else {
return init;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,self__.meta,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,false,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5523__auto__ = self__.__hash;
if(!((h__5523__auto__ == null))){
return h__5523__auto__;
} else {
var h__5523__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__5523__auto____$1;

return h__5523__auto____$1;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,(0)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_remove(self__.comp,self__.tree,k,found);
if((t == null)){
if((cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0)) == null)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt - (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_add(self__.comp,self__.tree,k,v,found);
if((t == null)){
var found_node = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v,found_node.val)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,cljs.core.tree_map_replace(self__.comp,self__.tree,k,v),self__.cnt,self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt + (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((coll__$1.entry_at(k) == null));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,true,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,meta__$1,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__10896 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__10897 = cljs.core.next(es);
ret = G__10896;
es = G__10897;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentTreeMap.prototype.call = (function() {
var G__10898 = null;
var G__10898__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__10898__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__10898 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__10898__2.call(this,self__,k);
case 3:
return G__10898__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10898.cljs$core$IFn$_invoke$arity$2 = G__10898__2;
G__10898.cljs$core$IFn$_invoke$arity$3 = G__10898__3;
return G__10898;
})()
;

cljs.core.PersistentTreeMap.prototype.apply = (function (self__,args10860){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args10860)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,ascending_QMARK_,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var stack = null;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__10875 = k;
var G__10876 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__10875,G__10876) : self__.comp.call(null,G__10875,G__10876));
})();
if((c === (0))){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t),ascending_QMARK_,(-1),null));
} else {
if(cljs.core.truth_(ascending_QMARK_)){
if((c < (0))){
var G__10899 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__10900 = t.left;
stack = G__10899;
t = G__10900;
continue;
} else {
var G__10901 = stack;
var G__10902 = t.right;
stack = G__10901;
t = G__10902;
continue;
}
} else {
if((c > (0))){
var G__10903 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__10904 = t.right;
stack = G__10903;
t = G__10904;
continue;
} else {
var G__10905 = stack;
var G__10906 = t.left;
stack = G__10905;
t = G__10906;
continue;
}

}
}
} else {
if((stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,stack,ascending_QMARK_,(-1),null));
}
}
break;
}
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
var G__10877 = entry;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__10877) : cljs.core.key.call(null,G__10877));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.comp;
});

cljs.core.PersistentTreeMap.cljs$lang$type = true;

cljs.core.PersistentTreeMap.cljs$lang$ctorStr = "cljs.core/PersistentTreeMap";

cljs.core.PersistentTreeMap.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/PersistentTreeMap");
});

cljs.core.__GT_PersistentTreeMap = (function __GT_PersistentTreeMap(comp,tree,cnt,meta,__hash){
return (new cljs.core.PersistentTreeMap(comp,tree,cnt,meta,__hash));
});

cljs.core.PersistentTreeMap.EMPTY = (new cljs.core.PersistentTreeMap(cljs.core.compare,null,(0),null,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));
/**
* keyval => key val
* Returns a new hash map with supplied mappings.
* @param {...*} var_args
*/
cljs.core.hash_map = (function() { 
var hash_map__delegate = function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if(in$){
var G__10907 = cljs.core.nnext(in$);
var G__10908 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__10907;
out = G__10908;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
};
var hash_map = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__10909__i = 0, G__10909__a = new Array(arguments.length -  0);
while (G__10909__i < G__10909__a.length) {G__10909__a[G__10909__i] = arguments[G__10909__i + 0]; ++G__10909__i;}
  keyvals = new cljs.core.IndexedSeq(G__10909__a,0);
} 
return hash_map__delegate.call(this,keyvals);};
hash_map.cljs$lang$maxFixedArity = 0;
hash_map.cljs$lang$applyTo = (function (arglist__10910){
var keyvals = cljs.core.seq(arglist__10910);
return hash_map__delegate(keyvals);
});
hash_map.cljs$core$IFn$_invoke$arity$variadic = hash_map__delegate;
return hash_map;
})()
;
/**
* keyval => key val
* Returns a new array map with supplied mappings.
* @param {...*} var_args
*/
cljs.core.array_map = (function() { 
var array_map__delegate = function (keyvals){
return cljs.core.PersistentArrayMap.fromArray(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.array,keyvals),true,false);
};
var array_map = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__10911__i = 0, G__10911__a = new Array(arguments.length -  0);
while (G__10911__i < G__10911__a.length) {G__10911__a[G__10911__i] = arguments[G__10911__i + 0]; ++G__10911__i;}
  keyvals = new cljs.core.IndexedSeq(G__10911__a,0);
} 
return array_map__delegate.call(this,keyvals);};
array_map.cljs$lang$maxFixedArity = 0;
array_map.cljs$lang$applyTo = (function (arglist__10912){
var keyvals = cljs.core.seq(arglist__10912);
return array_map__delegate(keyvals);
});
array_map.cljs$core$IFn$_invoke$arity$variadic = array_map__delegate;
return array_map;
})()
;
/**
* keyval => key val
* Returns a new object map with supplied mappings.
* @param {...*} var_args
*/
cljs.core.obj_map = (function() { 
var obj_map__delegate = function (keyvals){
var ks = [];
var obj = (function (){var obj10916 = {};
return obj10916;
})();
var kvs = cljs.core.seq(keyvals);
while(true){
if(kvs){
ks.push(cljs.core.first(kvs));

(obj[cljs.core.first(kvs)] = cljs.core.second(kvs));

var G__10917 = cljs.core.nnext(kvs);
kvs = G__10917;
continue;
} else {
return cljs.core.ObjMap.fromObject(ks,obj);
}
break;
}
};
var obj_map = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__10918__i = 0, G__10918__a = new Array(arguments.length -  0);
while (G__10918__i < G__10918__a.length) {G__10918__a[G__10918__i] = arguments[G__10918__i + 0]; ++G__10918__i;}
  keyvals = new cljs.core.IndexedSeq(G__10918__a,0);
} 
return obj_map__delegate.call(this,keyvals);};
obj_map.cljs$lang$maxFixedArity = 0;
obj_map.cljs$lang$applyTo = (function (arglist__10919){
var keyvals = cljs.core.seq(arglist__10919);
return obj_map__delegate(keyvals);
});
obj_map.cljs$core$IFn$_invoke$arity$variadic = obj_map__delegate;
return obj_map;
})()
;
/**
* keyval => key val
* Returns a new sorted map with supplied mappings.
* @param {...*} var_args
*/
cljs.core.sorted_map = (function() { 
var sorted_map__delegate = function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.PersistentTreeMap.EMPTY;
while(true){
if(in$){
var G__10920 = cljs.core.nnext(in$);
var G__10921 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__10920;
out = G__10921;
continue;
} else {
return out;
}
break;
}
};
var sorted_map = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__10922__i = 0, G__10922__a = new Array(arguments.length -  0);
while (G__10922__i < G__10922__a.length) {G__10922__a[G__10922__i] = arguments[G__10922__i + 0]; ++G__10922__i;}
  keyvals = new cljs.core.IndexedSeq(G__10922__a,0);
} 
return sorted_map__delegate.call(this,keyvals);};
sorted_map.cljs$lang$maxFixedArity = 0;
sorted_map.cljs$lang$applyTo = (function (arglist__10923){
var keyvals = cljs.core.seq(arglist__10923);
return sorted_map__delegate(keyvals);
});
sorted_map.cljs$core$IFn$_invoke$arity$variadic = sorted_map__delegate;
return sorted_map;
})()
;
/**
* keyval => key val
* Returns a new sorted map with supplied mappings, using the supplied comparator.
* @param {...*} var_args
*/
cljs.core.sorted_map_by = (function() { 
var sorted_map_by__delegate = function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = (new cljs.core.PersistentTreeMap(cljs.core.fn__GT_comparator(comparator),null,(0),null,(0)));
while(true){
if(in$){
var G__10924 = cljs.core.nnext(in$);
var G__10925 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__10924;
out = G__10925;
continue;
} else {
return out;
}
break;
}
};
var sorted_map_by = function (comparator,var_args){
var keyvals = null;
if (arguments.length > 1) {
var G__10926__i = 0, G__10926__a = new Array(arguments.length -  1);
while (G__10926__i < G__10926__a.length) {G__10926__a[G__10926__i] = arguments[G__10926__i + 1]; ++G__10926__i;}
  keyvals = new cljs.core.IndexedSeq(G__10926__a,0);
} 
return sorted_map_by__delegate.call(this,comparator,keyvals);};
sorted_map_by.cljs$lang$maxFixedArity = 1;
sorted_map_by.cljs$lang$applyTo = (function (arglist__10927){
var comparator = cljs.core.first(arglist__10927);
var keyvals = cljs.core.rest(arglist__10927);
return sorted_map_by__delegate(comparator,keyvals);
});
sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = sorted_map_by__delegate;
return sorted_map_by;
})()
;

/**
* @constructor
*/
cljs.core.KeySeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
})
cljs.core.KeySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.KeySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.KeySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.KeySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__10928 = self__.mseq;
if(G__10928){
var bit__5783__auto__ = (G__10928.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__5783__auto__) || (G__10928.cljs$core$INext$)){
return true;
} else {
if((!G__10928.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__10928);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__10928);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.KeySeq(nseq,self__._meta));
}
});

cljs.core.KeySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.KeySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_key$arity$1(null);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__10929 = self__.mseq;
if(G__10929){
var bit__5783__auto__ = (G__10929.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__5783__auto__) || (G__10929.cljs$core$INext$)){
return true;
} else {
if((!G__10929.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__10929);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__10929);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.KeySeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.KeySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.KeySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.KeySeq(self__.mseq,new_meta));
});

cljs.core.KeySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.KeySeq.cljs$lang$type = true;

cljs.core.KeySeq.cljs$lang$ctorStr = "cljs.core/KeySeq";

cljs.core.KeySeq.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/KeySeq");
});

cljs.core.__GT_KeySeq = (function __GT_KeySeq(mseq,_meta){
return (new cljs.core.KeySeq(mseq,_meta));
});

(cljs.core.KeySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));
/**
* Returns a sequence of the map's keys.
*/
cljs.core.keys = (function keys(hash_map){
var temp__4126__auto__ = cljs.core.seq(hash_map);
if(temp__4126__auto__){
var mseq = temp__4126__auto__;
return (new cljs.core.KeySeq(mseq,null));
} else {
return null;
}
});
/**
* Returns the key of the map entry.
*/
cljs.core.key = (function key(map_entry){
return cljs.core._key(map_entry);
});

/**
* @constructor
*/
cljs.core.ValSeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
})
cljs.core.ValSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ValSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ValSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.ValSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__10930 = self__.mseq;
if(G__10930){
var bit__5783__auto__ = (G__10930.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__5783__auto__) || (G__10930.cljs$core$INext$)){
return true;
} else {
if((!G__10930.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__10930);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__10930);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.ValSeq(nseq,self__._meta));
}
});

cljs.core.ValSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ValSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_val$arity$1(null);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__10931 = self__.mseq;
if(G__10931){
var bit__5783__auto__ = (G__10931.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__5783__auto__) || (G__10931.cljs$core$INext$)){
return true;
} else {
if((!G__10931.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__10931);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__10931);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.ValSeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ValSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ValSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ValSeq(self__.mseq,new_meta));
});

cljs.core.ValSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ValSeq.cljs$lang$type = true;

cljs.core.ValSeq.cljs$lang$ctorStr = "cljs.core/ValSeq";

cljs.core.ValSeq.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/ValSeq");
});

cljs.core.__GT_ValSeq = (function __GT_ValSeq(mseq,_meta){
return (new cljs.core.ValSeq(mseq,_meta));
});

(cljs.core.ValSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));
/**
* Returns a sequence of the map's values.
*/
cljs.core.vals = (function vals(hash_map){
var temp__4126__auto__ = cljs.core.seq(hash_map);
if(temp__4126__auto__){
var mseq = temp__4126__auto__;
return (new cljs.core.ValSeq(mseq,null));
} else {
return null;
}
});
/**
* Returns the value in the map entry.
*/
cljs.core.val = (function val(map_entry){
return cljs.core._val(map_entry);
});
/**
* Returns a map that consists of the rest of the maps conj-ed onto
* the first.  If a key occurs in more than one map, the mapping from
* the latter (left-to-right) will be the mapping in the result.
* @param {...*} var_args
*/
cljs.core.merge = (function() { 
var merge__delegate = function (maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__10932_SHARP_,p2__10933_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__5102__auto__ = p1__10932_SHARP_;
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),p2__10933_SHARP_);
}),maps);
} else {
return null;
}
};
var merge = function (var_args){
var maps = null;
if (arguments.length > 0) {
var G__10934__i = 0, G__10934__a = new Array(arguments.length -  0);
while (G__10934__i < G__10934__a.length) {G__10934__a[G__10934__i] = arguments[G__10934__i + 0]; ++G__10934__i;}
  maps = new cljs.core.IndexedSeq(G__10934__a,0);
} 
return merge__delegate.call(this,maps);};
merge.cljs$lang$maxFixedArity = 0;
merge.cljs$lang$applyTo = (function (arglist__10935){
var maps = cljs.core.seq(arglist__10935);
return merge__delegate(maps);
});
merge.cljs$core$IFn$_invoke$arity$variadic = merge__delegate;
return merge;
})()
;
/**
* Returns a map that consists of the rest of the maps conj-ed onto
* the first.  If a key occurs in more than one map, the mapping(s)
* from the latter (left-to-right) will be combined with the mapping in
* the result by calling (f val-in-result val-in-latter).
* @param {...*} var_args
*/
cljs.core.merge_with = (function() { 
var merge_with__delegate = function (f,maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.first(e);
var v = cljs.core.second(e);
if(cljs.core.contains_QMARK_(m,k)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__10938 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__10939 = v;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10938,G__10939) : f.call(null,G__10938,G__10939));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
var merge2 = ((function (merge_entry){
return (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry,(function (){var or__5102__auto__ = m1;
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq(m2));
});})(merge_entry))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2,maps);
} else {
return null;
}
};
var merge_with = function (f,var_args){
var maps = null;
if (arguments.length > 1) {
var G__10940__i = 0, G__10940__a = new Array(arguments.length -  1);
while (G__10940__i < G__10940__a.length) {G__10940__a[G__10940__i] = arguments[G__10940__i + 1]; ++G__10940__i;}
  maps = new cljs.core.IndexedSeq(G__10940__a,0);
} 
return merge_with__delegate.call(this,f,maps);};
merge_with.cljs$lang$maxFixedArity = 1;
merge_with.cljs$lang$applyTo = (function (arglist__10941){
var f = cljs.core.first(arglist__10941);
var maps = cljs.core.rest(arglist__10941);
return merge_with__delegate(f,maps);
});
merge_with.cljs$core$IFn$_invoke$arity$variadic = merge_with__delegate;
return merge_with;
})()
;
/**
* Returns a map containing only those entries in map whose key is in keys
*/
cljs.core.select_keys = (function select_keys(map,keyseq){
var ret = cljs.core.PersistentArrayMap.EMPTY;
var keys = cljs.core.seq(keyseq);
while(true){
if(keys){
var key = cljs.core.first(keys);
var entry = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map,key,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185));
var G__10942 = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(entry,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,key,entry):ret);
var G__10943 = cljs.core.next(keys);
ret = G__10942;
keys = G__10943;
continue;
} else {
return cljs.core.with_meta(ret,cljs.core.meta(map));
}
break;
}
});

/**
* @constructor
*/
cljs.core.PersistentHashSet = (function (meta,hash_map,__hash){
this.meta = meta;
this.hash_map = hash_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 15077647;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__10946 = cljs.core.seq(coll);
var chunk__10947 = null;
var count__10948 = (0);
var i__10949 = (0);
while(true){
if((i__10949 < count__10948)){
var vec__10950 = chunk__10947.cljs$core$IIndexed$_nth$arity$2(null,i__10949);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10950,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10950,(1),null);
var G__10951_10956 = v;
var G__10952_10957 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10951_10956,G__10952_10957) : f.call(null,G__10951_10956,G__10952_10957));

var G__10958 = seq__10946;
var G__10959 = chunk__10947;
var G__10960 = count__10948;
var G__10961 = (i__10949 + (1));
seq__10946 = G__10958;
chunk__10947 = G__10959;
count__10948 = G__10960;
i__10949 = G__10961;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__10946);
if(temp__4126__auto__){
var seq__10946__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10946__$1)){
var c__5889__auto__ = cljs.core.chunk_first(seq__10946__$1);
var G__10962 = cljs.core.chunk_rest(seq__10946__$1);
var G__10963 = c__5889__auto__;
var G__10964 = cljs.core.count(c__5889__auto__);
var G__10965 = (0);
seq__10946 = G__10962;
chunk__10947 = G__10963;
count__10948 = G__10964;
i__10949 = G__10965;
continue;
} else {
var vec__10953 = cljs.core.first(seq__10946__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10953,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10953,(1),null);
var G__10954_10966 = v;
var G__10955_10967 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10954_10966,G__10955_10967) : f.call(null,G__10954_10966,G__10955_10967));

var G__10968 = cljs.core.next(seq__10946__$1);
var G__10969 = null;
var G__10970 = (0);
var G__10971 = (0);
seq__10946 = G__10968;
chunk__10947 = G__10969;
count__10948 = G__10970;
i__10949 = G__10971;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
if(cljs.core._contains_key_QMARK_(self__.hash_map,v)){
return v;
} else {
return not_found;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._count(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5523__auto__ = self__.__hash;
if(!((h__5523__auto__ == null))){
return h__5523__auto__;
} else {
var h__5523__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__5523__auto____$1;

return h__5523__auto____$1;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__10944_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__10944_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashSet(cljs.core._as_transient(self__.hash_map)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentHashSet.EMPTY,self__.meta);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core._dissoc(self__.hash_map,v),null));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(meta__$1,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.hash_map,o,null),null));
});

cljs.core.PersistentHashSet.prototype.call = (function() {
var G__10972 = null;
var G__10972__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__10972__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__10972 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__10972__2.call(this,self__,k);
case 3:
return G__10972__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10972.cljs$core$IFn$_invoke$arity$2 = G__10972__2;
G__10972.cljs$core$IFn$_invoke$arity$3 = G__10972__3;
return G__10972;
})()
;

cljs.core.PersistentHashSet.prototype.apply = (function (self__,args10945){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args10945)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashSet.cljs$lang$type = true;

cljs.core.PersistentHashSet.cljs$lang$ctorStr = "cljs.core/PersistentHashSet";

cljs.core.PersistentHashSet.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/PersistentHashSet");
});

cljs.core.__GT_PersistentHashSet = (function __GT_PersistentHashSet(meta,hash_map,__hash){
return (new cljs.core.PersistentHashSet(meta,hash_map,__hash));
});

cljs.core.PersistentHashSet.EMPTY = (new cljs.core.PersistentHashSet(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashSet.fromArray = (function (items,no_clone){
var len = items.length;
if((len <= cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr = ((no_clone)?items:cljs.core.aclone(items));
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < len)){
var G__10973 = (i + (1));
var G__10974 = cljs.core._assoc_BANG_(out,(items[i]),null);
i = G__10973;
out = G__10974;
continue;
} else {
return (new cljs.core.PersistentHashSet(null,cljs.core._persistent_BANG_(out),null));
}
break;
}
} else {
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < len)){
var G__10975 = (i + (1));
var G__10976 = cljs.core._conj_BANG_(out,(items[i]));
i = G__10975;
out = G__10976;
continue;
} else {
return cljs.core._persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentHashSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientHashSet = (function (transient_map){
this.transient_map = transient_map;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 136;
})
cljs.core.TransientHashSet.prototype.call = (function() {
var G__10978 = null;
var G__10978__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});
var G__10978__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});
G__10978 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__10978__2.call(this,self__,k);
case 3:
return G__10978__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10978.cljs$core$IFn$_invoke$arity$2 = G__10978__2;
G__10978.cljs$core$IFn$_invoke$arity$3 = G__10978__3;
return G__10978;
})()
;

cljs.core.TransientHashSet.prototype.apply = (function (self__,args10977){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args10977)));
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,v,null);
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,v,not_found){
var self__ = this;
var tcoll__$1 = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return v;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return cljs.core.count(self__.transient_map);
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(self__.transient_map,v);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(self__.transient_map,o,null);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return (new cljs.core.PersistentHashSet(null,cljs.core.persistent_BANG_(self__.transient_map),null));
});

cljs.core.TransientHashSet.cljs$lang$type = true;

cljs.core.TransientHashSet.cljs$lang$ctorStr = "cljs.core/TransientHashSet";

cljs.core.TransientHashSet.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/TransientHashSet");
});

cljs.core.__GT_TransientHashSet = (function __GT_TransientHashSet(transient_map){
return (new cljs.core.TransientHashSet(transient_map));
});


/**
* @constructor
*/
cljs.core.PersistentTreeSet = (function (meta,tree_map,__hash){
this.meta = meta;
this.tree_map = tree_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 417730831;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__10981 = cljs.core.seq(coll);
var chunk__10982 = null;
var count__10983 = (0);
var i__10984 = (0);
while(true){
if((i__10984 < count__10983)){
var vec__10985 = chunk__10982.cljs$core$IIndexed$_nth$arity$2(null,i__10984);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10985,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10985,(1),null);
var G__10986_10991 = v;
var G__10987_10992 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10986_10991,G__10987_10992) : f.call(null,G__10986_10991,G__10987_10992));

var G__10993 = seq__10981;
var G__10994 = chunk__10982;
var G__10995 = count__10983;
var G__10996 = (i__10984 + (1));
seq__10981 = G__10993;
chunk__10982 = G__10994;
count__10983 = G__10995;
i__10984 = G__10996;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__10981);
if(temp__4126__auto__){
var seq__10981__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10981__$1)){
var c__5889__auto__ = cljs.core.chunk_first(seq__10981__$1);
var G__10997 = cljs.core.chunk_rest(seq__10981__$1);
var G__10998 = c__5889__auto__;
var G__10999 = cljs.core.count(c__5889__auto__);
var G__11000 = (0);
seq__10981 = G__10997;
chunk__10982 = G__10998;
count__10983 = G__10999;
i__10984 = G__11000;
continue;
} else {
var vec__10988 = cljs.core.first(seq__10981__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10988,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10988,(1),null);
var G__10989_11001 = v;
var G__10990_11002 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10989_11001,G__10990_11002) : f.call(null,G__10989_11001,G__10990_11002));

var G__11003 = cljs.core.next(seq__10981__$1);
var G__11004 = null;
var G__11005 = (0);
var G__11006 = (0);
seq__10981 = G__11003;
chunk__10982 = G__11004;
count__10983 = G__11005;
i__10984 = G__11006;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
var n = self__.tree_map.entry_at(v);
if(!((n == null))){
return n.key;
} else {
return not_found;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.count(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.count(self__.tree_map) > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core.rseq(self__.tree_map));
} else {
return null;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5523__auto__ = self__.__hash;
if(!((h__5523__auto__ == null))){
return h__5523__auto__;
} else {
var h__5523__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__5523__auto____$1;

return h__5523__auto____$1;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__10979_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__10979_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core._empty(self__.tree_map),(0)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.tree_map,v),null));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(meta__$1,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.tree_map,o,null),null));
});

cljs.core.PersistentTreeSet.prototype.call = (function() {
var G__11007 = null;
var G__11007__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__11007__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__11007 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11007__2.call(this,self__,k);
case 3:
return G__11007__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11007.cljs$core$IFn$_invoke$arity$2 = G__11007__2;
G__11007.cljs$core$IFn$_invoke$arity$3 = G__11007__3;
return G__11007;
})()
;

cljs.core.PersistentTreeSet.prototype.apply = (function (self__,args10980){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args10980)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq(self__.tree_map,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq_from(self__.tree_map,k,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return entry;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._comparator(self__.tree_map);
});

cljs.core.PersistentTreeSet.cljs$lang$type = true;

cljs.core.PersistentTreeSet.cljs$lang$ctorStr = "cljs.core/PersistentTreeSet";

cljs.core.PersistentTreeSet.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/PersistentTreeSet");
});

cljs.core.__GT_PersistentTreeSet = (function __GT_PersistentTreeSet(meta,tree_map,__hash){
return (new cljs.core.PersistentTreeSet(meta,tree_map,__hash));
});

cljs.core.PersistentTreeSet.EMPTY = (new cljs.core.PersistentTreeSet(null,cljs.core.PersistentTreeMap.EMPTY,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));
cljs.core.set_from_indexed_seq = (function set_from_indexed_seq(iseq){
var arr = iseq.arr;
var ret = (function (){var a__5983__auto__ = arr;
var i = (0);
var res = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < a__5983__auto__.length)){
var G__11008 = (i + (1));
var G__11009 = res.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,(arr[i]));
i = G__11008;
res = G__11009;
continue;
} else {
return res;
}
break;
}
})();
return ret.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
});
/**
* Returns a set of the distinct elements of coll.
*/
cljs.core.set = (function set(coll){
var in$ = cljs.core.seq(coll);
if((in$ == null)){
return cljs.core.PersistentHashSet.EMPTY;
} else {
if(((in$ instanceof cljs.core.IndexedSeq)) && ((in$.i === (0)))){
return cljs.core.set_from_indexed_seq(in$);
} else {
var in$__$1 = in$;
var out = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if(!((in$__$1 == null))){
var G__11010 = in$__$1.cljs$core$INext$_next$arity$1(null);
var G__11011 = out.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,in$__$1.cljs$core$ISeq$_first$arity$1(null));
in$__$1 = G__11010;
out = G__11011;
continue;
} else {
return out.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
}
break;
}

}
}
});
/**
* @param {...*} var_args
*/
cljs.core.hash_set = (function() {
var hash_set = null;
var hash_set__0 = (function (){
return cljs.core.PersistentHashSet.EMPTY;
});
var hash_set__1 = (function() { 
var G__11012__delegate = function (keys){
return cljs.core.set(keys);
};
var G__11012 = function (var_args){
var keys = null;
if (arguments.length > 0) {
var G__11013__i = 0, G__11013__a = new Array(arguments.length -  0);
while (G__11013__i < G__11013__a.length) {G__11013__a[G__11013__i] = arguments[G__11013__i + 0]; ++G__11013__i;}
  keys = new cljs.core.IndexedSeq(G__11013__a,0);
} 
return G__11012__delegate.call(this,keys);};
G__11012.cljs$lang$maxFixedArity = 0;
G__11012.cljs$lang$applyTo = (function (arglist__11014){
var keys = cljs.core.seq(arglist__11014);
return G__11012__delegate(keys);
});
G__11012.cljs$core$IFn$_invoke$arity$variadic = G__11012__delegate;
return G__11012;
})()
;
hash_set = function(var_args){
var keys = var_args;
switch(arguments.length){
case 0:
return hash_set__0.call(this);
default:
var G__11015 = null;
if (arguments.length > 0) {
var G__11016__i = 0, G__11016__a = new Array(arguments.length -  0);
while (G__11016__i < G__11016__a.length) {G__11016__a[G__11016__i] = arguments[G__11016__i + 0]; ++G__11016__i;}
G__11015 = new cljs.core.IndexedSeq(G__11016__a,0);
}
return hash_set__1.cljs$core$IFn$_invoke$arity$variadic(G__11015);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hash_set.cljs$lang$maxFixedArity = 0;
hash_set.cljs$lang$applyTo = hash_set__1.cljs$lang$applyTo;
hash_set.cljs$core$IFn$_invoke$arity$0 = hash_set__0;
hash_set.cljs$core$IFn$_invoke$arity$variadic = hash_set__1.cljs$core$IFn$_invoke$arity$variadic;
return hash_set;
})()
;
/**
* Returns a new sorted set with supplied keys.
* @param {...*} var_args
*/
cljs.core.sorted_set = (function() { 
var sorted_set__delegate = function (keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,cljs.core.PersistentTreeSet.EMPTY,keys);
};
var sorted_set = function (var_args){
var keys = null;
if (arguments.length > 0) {
var G__11017__i = 0, G__11017__a = new Array(arguments.length -  0);
while (G__11017__i < G__11017__a.length) {G__11017__a[G__11017__i] = arguments[G__11017__i + 0]; ++G__11017__i;}
  keys = new cljs.core.IndexedSeq(G__11017__a,0);
} 
return sorted_set__delegate.call(this,keys);};
sorted_set.cljs$lang$maxFixedArity = 0;
sorted_set.cljs$lang$applyTo = (function (arglist__11018){
var keys = cljs.core.seq(arglist__11018);
return sorted_set__delegate(keys);
});
sorted_set.cljs$core$IFn$_invoke$arity$variadic = sorted_set__delegate;
return sorted_set;
})()
;
/**
* Returns a new sorted set with supplied keys, using the supplied comparator.
* @param {...*} var_args
*/
cljs.core.sorted_set_by = (function() { 
var sorted_set_by__delegate = function (comparator,keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,(new cljs.core.PersistentTreeSet(null,cljs.core.sorted_map_by(comparator),(0))),keys);
};
var sorted_set_by = function (comparator,var_args){
var keys = null;
if (arguments.length > 1) {
var G__11019__i = 0, G__11019__a = new Array(arguments.length -  1);
while (G__11019__i < G__11019__a.length) {G__11019__a[G__11019__i] = arguments[G__11019__i + 1]; ++G__11019__i;}
  keys = new cljs.core.IndexedSeq(G__11019__a,0);
} 
return sorted_set_by__delegate.call(this,comparator,keys);};
sorted_set_by.cljs$lang$maxFixedArity = 1;
sorted_set_by.cljs$lang$applyTo = (function (arglist__11020){
var comparator = cljs.core.first(arglist__11020);
var keys = cljs.core.rest(arglist__11020);
return sorted_set_by__delegate(comparator,keys);
});
sorted_set_by.cljs$core$IFn$_invoke$arity$variadic = sorted_set_by__delegate;
return sorted_set_by;
})()
;
/**
* Given a map of replacement pairs and a vector/collection, returns a
* vector/seq with any elements = a key in smap replaced with the
* corresponding val in smap.  Returns a transducer when no collection
* is provided.
*/
cljs.core.replace = (function() {
var replace = null;
var replace__1 = (function (smap){
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__11021_SHARP_){
var temp__4124__auto__ = cljs.core.find(smap,p1__11021_SHARP_);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
return cljs.core.val(e);
} else {
return p1__11021_SHARP_;
}
}));
});
var replace__2 = (function (smap,coll){
if(cljs.core.vector_QMARK_(coll)){
var n = cljs.core.count(coll);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (n){
return (function (v,i){
var temp__4124__auto__ = cljs.core.find(smap,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(v,i));
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,i,cljs.core.second(e));
} else {
return v;
}
});})(n))
,coll,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.iterate(cljs.core.inc,(0))));
} else {
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__11022_SHARP_){
var temp__4124__auto__ = cljs.core.find(smap,p1__11022_SHARP_);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
return cljs.core.second(e);
} else {
return p1__11022_SHARP_;
}
}),coll);
}
});
replace = function(smap,coll){
switch(arguments.length){
case 1:
return replace__1.call(this,smap);
case 2:
return replace__2.call(this,smap,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
replace.cljs$core$IFn$_invoke$arity$1 = replace__1;
replace.cljs$core$IFn$_invoke$arity$2 = replace__2;
return replace;
})()
;
/**
* Returns a lazy sequence of the elements of coll with duplicates removed
*/
cljs.core.distinct = (function() {
var distinct = null;
var distinct__0 = (function (){
return (function (rf){
var seen = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
return ((function (seen){
return (function() {
var G__11043 = null;
var G__11043__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11043__1 = (function (result){
var G__11033 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11033) : rf.call(null,G__11033));
});
var G__11043__2 = (function (result,input){
if(cljs.core.contains_QMARK_((function (){var G__11034 = seen;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11034) : cljs.core.deref.call(null,G__11034));
})(),input)){
return result;
} else {
seen.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen.cljs$core$IDeref$_deref$arity$1(null),input));

var G__11035 = result;
var G__11036 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11035,G__11036) : rf.call(null,G__11035,G__11036));
}
});
G__11043 = function(result,input){
switch(arguments.length){
case 0:
return G__11043__0.call(this);
case 1:
return G__11043__1.call(this,result);
case 2:
return G__11043__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11043.cljs$core$IFn$_invoke$arity$0 = G__11043__0;
G__11043.cljs$core$IFn$_invoke$arity$1 = G__11043__1;
G__11043.cljs$core$IFn$_invoke$arity$2 = G__11043__2;
return G__11043;
})()
;})(seen))
});
});
var distinct__1 = (function (coll){
var step = (function step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
return (function (p__11041,seen__$1){
while(true){
var vec__11042 = p__11041;
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11042,(0),null);
var xs__$1 = vec__11042;
var temp__4126__auto__ = cljs.core.seq(xs__$1);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.contains_QMARK_(seen__$1,f)){
var G__11044 = cljs.core.rest(s);
var G__11045 = seen__$1;
p__11041 = G__11044;
seen__$1 = G__11045;
continue;
} else {
return cljs.core.cons(f,step(cljs.core.rest(s),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1,f)));
}
} else {
return null;
}
break;
}
}).call(null,xs,seen);
}),null,null));
});
return step(coll,cljs.core.PersistentHashSet.EMPTY);
});
distinct = function(coll){
switch(arguments.length){
case 0:
return distinct__0.call(this);
case 1:
return distinct__1.call(this,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
distinct.cljs$core$IFn$_invoke$arity$0 = distinct__0;
distinct.cljs$core$IFn$_invoke$arity$1 = distinct__1;
return distinct;
})()
;
cljs.core.butlast = (function butlast(s){
var ret = cljs.core.PersistentVector.EMPTY;
var s__$1 = s;
while(true){
if(cljs.core.next(s__$1)){
var G__11046 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,cljs.core.first(s__$1));
var G__11047 = cljs.core.next(s__$1);
ret = G__11046;
s__$1 = G__11047;
continue;
} else {
return cljs.core.seq(ret);
}
break;
}
});
/**
* Returns the name String of a string, symbol or keyword.
*/
cljs.core.name = (function name(x){
if((function (){var G__11049 = x;
if(G__11049){
var bit__5776__auto__ = (G__11049.cljs$lang$protocol_mask$partition1$ & (4096));
if((bit__5776__auto__) || (G__11049.cljs$core$INamed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$INamed$_name$arity$1(null);
} else {
if(typeof x === 'string'){
return x;
} else {
throw (new Error([cljs.core.str("Doesn't support name: "),cljs.core.str(x)].join('')));
}
}
});
/**
* Returns a map with the keys mapped to the corresponding vals.
*/
cljs.core.zipmap = (function zipmap(keys,vals){
var map = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var ks = cljs.core.seq(keys);
var vs = cljs.core.seq(vals);
while(true){
if((ks) && (vs)){
var G__11050 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(map,cljs.core.first(ks),cljs.core.first(vs));
var G__11051 = cljs.core.next(ks);
var G__11052 = cljs.core.next(vs);
map = G__11050;
ks = G__11051;
vs = G__11052;
continue;
} else {
return cljs.core.persistent_BANG_(map);
}
break;
}
});
/**
* Returns the x for which (k x), a number, is greatest.
* @param {...*} var_args
*/
cljs.core.max_key = (function() {
var max_key = null;
var max_key__2 = (function (k,x){
return x;
});
var max_key__3 = (function (k,x,y){
if(((function (){var G__11063 = x;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__11063) : k.call(null,G__11063));
})() > (function (){var G__11064 = y;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__11064) : k.call(null,G__11064));
})())){
return x;
} else {
return y;
}
});
var max_key__4 = (function() { 
var G__11065__delegate = function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__11053_SHARP_,p2__11054_SHARP_){
return max_key.cljs$core$IFn$_invoke$arity$3(k,p1__11053_SHARP_,p2__11054_SHARP_);
}),max_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
};
var G__11065 = function (k,x,y,var_args){
var more = null;
if (arguments.length > 3) {
var G__11066__i = 0, G__11066__a = new Array(arguments.length -  3);
while (G__11066__i < G__11066__a.length) {G__11066__a[G__11066__i] = arguments[G__11066__i + 3]; ++G__11066__i;}
  more = new cljs.core.IndexedSeq(G__11066__a,0);
} 
return G__11065__delegate.call(this,k,x,y,more);};
G__11065.cljs$lang$maxFixedArity = 3;
G__11065.cljs$lang$applyTo = (function (arglist__11067){
var k = cljs.core.first(arglist__11067);
arglist__11067 = cljs.core.next(arglist__11067);
var x = cljs.core.first(arglist__11067);
arglist__11067 = cljs.core.next(arglist__11067);
var y = cljs.core.first(arglist__11067);
var more = cljs.core.rest(arglist__11067);
return G__11065__delegate(k,x,y,more);
});
G__11065.cljs$core$IFn$_invoke$arity$variadic = G__11065__delegate;
return G__11065;
})()
;
max_key = function(k,x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return max_key__2.call(this,k,x);
case 3:
return max_key__3.call(this,k,x,y);
default:
var G__11068 = null;
if (arguments.length > 3) {
var G__11069__i = 0, G__11069__a = new Array(arguments.length -  3);
while (G__11069__i < G__11069__a.length) {G__11069__a[G__11069__i] = arguments[G__11069__i + 3]; ++G__11069__i;}
G__11068 = new cljs.core.IndexedSeq(G__11069__a,0);
}
return max_key__4.cljs$core$IFn$_invoke$arity$variadic(k,x,y, G__11068);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
max_key.cljs$lang$maxFixedArity = 3;
max_key.cljs$lang$applyTo = max_key__4.cljs$lang$applyTo;
max_key.cljs$core$IFn$_invoke$arity$2 = max_key__2;
max_key.cljs$core$IFn$_invoke$arity$3 = max_key__3;
max_key.cljs$core$IFn$_invoke$arity$variadic = max_key__4.cljs$core$IFn$_invoke$arity$variadic;
return max_key;
})()
;
/**
* Returns the x for which (k x), a number, is least.
* @param {...*} var_args
*/
cljs.core.min_key = (function() {
var min_key = null;
var min_key__2 = (function (k,x){
return x;
});
var min_key__3 = (function (k,x,y){
if(((function (){var G__11080 = x;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__11080) : k.call(null,G__11080));
})() < (function (){var G__11081 = y;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__11081) : k.call(null,G__11081));
})())){
return x;
} else {
return y;
}
});
var min_key__4 = (function() { 
var G__11082__delegate = function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__11070_SHARP_,p2__11071_SHARP_){
return min_key.cljs$core$IFn$_invoke$arity$3(k,p1__11070_SHARP_,p2__11071_SHARP_);
}),min_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
};
var G__11082 = function (k,x,y,var_args){
var more = null;
if (arguments.length > 3) {
var G__11083__i = 0, G__11083__a = new Array(arguments.length -  3);
while (G__11083__i < G__11083__a.length) {G__11083__a[G__11083__i] = arguments[G__11083__i + 3]; ++G__11083__i;}
  more = new cljs.core.IndexedSeq(G__11083__a,0);
} 
return G__11082__delegate.call(this,k,x,y,more);};
G__11082.cljs$lang$maxFixedArity = 3;
G__11082.cljs$lang$applyTo = (function (arglist__11084){
var k = cljs.core.first(arglist__11084);
arglist__11084 = cljs.core.next(arglist__11084);
var x = cljs.core.first(arglist__11084);
arglist__11084 = cljs.core.next(arglist__11084);
var y = cljs.core.first(arglist__11084);
var more = cljs.core.rest(arglist__11084);
return G__11082__delegate(k,x,y,more);
});
G__11082.cljs$core$IFn$_invoke$arity$variadic = G__11082__delegate;
return G__11082;
})()
;
min_key = function(k,x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return min_key__2.call(this,k,x);
case 3:
return min_key__3.call(this,k,x,y);
default:
var G__11085 = null;
if (arguments.length > 3) {
var G__11086__i = 0, G__11086__a = new Array(arguments.length -  3);
while (G__11086__i < G__11086__a.length) {G__11086__a[G__11086__i] = arguments[G__11086__i + 3]; ++G__11086__i;}
G__11085 = new cljs.core.IndexedSeq(G__11086__a,0);
}
return min_key__4.cljs$core$IFn$_invoke$arity$variadic(k,x,y, G__11085);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
min_key.cljs$lang$maxFixedArity = 3;
min_key.cljs$lang$applyTo = min_key__4.cljs$lang$applyTo;
min_key.cljs$core$IFn$_invoke$arity$2 = min_key__2;
min_key.cljs$core$IFn$_invoke$arity$3 = min_key__3;
min_key.cljs$core$IFn$_invoke$arity$variadic = min_key__4.cljs$core$IFn$_invoke$arity$variadic;
return min_key;
})()
;

/**
* @constructor
*/
cljs.core.ArrayList = (function (arr){
this.arr = arr;
})
cljs.core.ArrayList.prototype.add = (function (x){
var self__ = this;
var _ = this;
return self__.arr.push(x);
});

cljs.core.ArrayList.prototype.size = (function (){
var self__ = this;
var _ = this;
return self__.arr.length;
});

cljs.core.ArrayList.prototype.clear = (function (){
var self__ = this;
var _ = this;
return self__.arr = [];
});

cljs.core.ArrayList.prototype.isEmpty = (function (){
var self__ = this;
var _ = this;
return (self__.arr.length === (0));
});

cljs.core.ArrayList.prototype.toArray = (function (){
var self__ = this;
var _ = this;
return self__.arr;
});

cljs.core.ArrayList.cljs$lang$type = true;

cljs.core.ArrayList.cljs$lang$ctorStr = "cljs.core/ArrayList";

cljs.core.ArrayList.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/ArrayList");
});

cljs.core.__GT_ArrayList = (function __GT_ArrayList(arr){
return (new cljs.core.ArrayList(arr));
});

cljs.core.array_list = (function array_list(){
return (new cljs.core.ArrayList([]));
});
/**
* Returns a lazy sequence of lists like partition, but may include
* partitions with fewer than n items at the end.  Returns a stateful
* transducer when no collection is provided.
*/
cljs.core.partition_all = (function() {
var partition_all = null;
var partition_all__1 = (function (n){
return (function (rf){
var a = cljs.core.array_list();
return ((function (a){
return (function() {
var G__11103 = null;
var G__11103__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11103__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((function (){var G__11098 = result;
var G__11099 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11098,G__11099) : rf.call(null,G__11098,G__11099));
})());
})());
var G__11100 = result__$1;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11100) : rf.call(null,G__11100));
});
var G__11103__2 = (function (result,input){
a.add(input);

if((n === a.size())){
var v = cljs.core.vec(a.toArray());
a.clear();

var G__11101 = result;
var G__11102 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11101,G__11102) : rf.call(null,G__11101,G__11102));
} else {
return result;
}
});
G__11103 = function(result,input){
switch(arguments.length){
case 0:
return G__11103__0.call(this);
case 1:
return G__11103__1.call(this,result);
case 2:
return G__11103__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11103.cljs$core$IFn$_invoke$arity$0 = G__11103__0;
G__11103.cljs$core$IFn$_invoke$arity$1 = G__11103__1;
G__11103.cljs$core$IFn$_invoke$arity$2 = G__11103__2;
return G__11103;
})()
;})(a))
});
});
var partition_all__2 = (function (n,coll){
return partition_all.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});
var partition_all__3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.cons(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s),partition_all.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
}),null,null));
});
partition_all = function(n,step,coll){
switch(arguments.length){
case 1:
return partition_all__1.call(this,n);
case 2:
return partition_all__2.call(this,n,step);
case 3:
return partition_all__3.call(this,n,step,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition_all.cljs$core$IFn$_invoke$arity$1 = partition_all__1;
partition_all.cljs$core$IFn$_invoke$arity$2 = partition_all__2;
partition_all.cljs$core$IFn$_invoke$arity$3 = partition_all__3;
return partition_all;
})()
;
/**
* Returns a lazy sequence of successive items from coll while
* (pred item) returns true. pred must be free of side-effects.
* Returns a transducer when no collection is provided.
*/
cljs.core.take_while = (function() {
var take_while = null;
var take_while__1 = (function (pred){
return (function (rf){
return (function() {
var G__11116 = null;
var G__11116__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11116__1 = (function (result){
var G__11111 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11111) : rf.call(null,G__11111));
});
var G__11116__2 = (function (result,input){
if(cljs.core.truth_((function (){var G__11112 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11112) : pred.call(null,G__11112));
})())){
var G__11113 = result;
var G__11114 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11113,G__11114) : rf.call(null,G__11113,G__11114));
} else {
return cljs.core.reduced(result);
}
});
G__11116 = function(result,input){
switch(arguments.length){
case 0:
return G__11116__0.call(this);
case 1:
return G__11116__1.call(this,result);
case 2:
return G__11116__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11116.cljs$core$IFn$_invoke$arity$0 = G__11116__0;
G__11116.cljs$core$IFn$_invoke$arity$1 = G__11116__1;
G__11116.cljs$core$IFn$_invoke$arity$2 = G__11116__2;
return G__11116;
})()
});
});
var take_while__2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.truth_((function (){var G__11115 = cljs.core.first(s);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11115) : pred.call(null,G__11115));
})())){
return cljs.core.cons(cljs.core.first(s),take_while.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});
take_while = function(pred,coll){
switch(arguments.length){
case 1:
return take_while__1.call(this,pred);
case 2:
return take_while__2.call(this,pred,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take_while.cljs$core$IFn$_invoke$arity$1 = take_while__1;
take_while.cljs$core$IFn$_invoke$arity$2 = take_while__2;
return take_while;
})()
;
cljs.core.mk_bound_fn = (function mk_bound_fn(sc,test,key){
return (function (e){
var comp = cljs.core._comparator(sc);
var G__11121 = (function (){var G__11123 = cljs.core._entry_key(sc,e);
var G__11124 = key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__11123,G__11124) : comp.call(null,G__11123,G__11124));
})();
var G__11122 = (0);
return (test.cljs$core$IFn$_invoke$arity$2 ? test.cljs$core$IFn$_invoke$arity$2(G__11121,G__11122) : test.call(null,G__11121,G__11122));
});
});
/**
* sc must be a sorted collection, test(s) one of <, <=, > or
* >=. Returns a seq of those entries with keys ek for
* which (test (.. sc comparator (compare ek key)) 0) is true
*/
cljs.core.subseq = (function() {
var subseq = null;
var subseq__3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._GT_,cljs.core._GT__EQ_], true).call(null,test))){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,key,true);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__11128 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11128,(0),null);
var s = vec__11128;
if(cljs.core.truth_((function (){var G__11129 = e;
return (include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__11129) : include.call(null,G__11129));
})())){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,true));
}
});
var subseq__5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,start_key,true);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__11130 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11130,(0),null);
var s = vec__11130;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,end_test,end_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,start_test,start_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});
subseq = function(sc,start_test,start_key,end_test,end_key){
switch(arguments.length){
case 3:
return subseq__3.call(this,sc,start_test,start_key);
case 5:
return subseq__5.call(this,sc,start_test,start_key,end_test,end_key);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
subseq.cljs$core$IFn$_invoke$arity$3 = subseq__3;
subseq.cljs$core$IFn$_invoke$arity$5 = subseq__5;
return subseq;
})()
;
/**
* sc must be a sorted collection, test(s) one of <, <=, > or
* >=. Returns a reverse seq of those entries with keys ek for
* which (test (.. sc comparator (compare ek key)) 0) is true
*/
cljs.core.rsubseq = (function() {
var rsubseq = null;
var rsubseq__3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._LT_,cljs.core._LT__EQ_], true).call(null,test))){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,key,false);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__11134 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11134,(0),null);
var s = vec__11134;
if(cljs.core.truth_((function (){var G__11135 = e;
return (include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__11135) : include.call(null,G__11135));
})())){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,false));
}
});
var rsubseq__5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,end_key,false);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__11136 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11136,(0),null);
var s = vec__11136;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,start_test,start_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,end_test,end_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});
rsubseq = function(sc,start_test,start_key,end_test,end_key){
switch(arguments.length){
case 3:
return rsubseq__3.call(this,sc,start_test,start_key);
case 5:
return rsubseq__5.call(this,sc,start_test,start_key,end_test,end_key);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
rsubseq.cljs$core$IFn$_invoke$arity$3 = rsubseq__3;
rsubseq.cljs$core$IFn$_invoke$arity$5 = rsubseq__5;
return rsubseq;
})()
;

/**
* @constructor
*/
cljs.core.RangeIterator = (function (i,end,step){
this.i = i;
this.end = end;
this.step = step;
})
cljs.core.RangeIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__.step > (0))){
return (self__.i < self__.end);
} else {
return (self__.i > self__.end);
}
});

cljs.core.RangeIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.i;
self__.i = (self__.i + self__.step);

return ret;
});

cljs.core.RangeIterator.cljs$lang$type = true;

cljs.core.RangeIterator.cljs$lang$ctorStr = "cljs.core/RangeIterator";

cljs.core.RangeIterator.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/RangeIterator");
});

cljs.core.__GT_RangeIterator = (function __GT_RangeIterator(i,end,step){
return (new cljs.core.RangeIterator(i,end,step));
});


/**
* @constructor
*/
cljs.core.Range = (function (meta,start,end,step,__hash){
this.meta = meta;
this.start = start;
this.end = end;
this.step = step;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375006;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Range.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Range.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (rng,n){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
throw (new Error("Index out of bounds"));
}
}
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (rng,n,not_found){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
return not_found;
}
}
});

cljs.core.Range.prototype.cljs$core$IIterable$ = true;

cljs.core.Range.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RangeIterator(self__.start,self__.end,self__.step));
});

cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return self__.meta;
});

cljs.core.Range.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Range(self__.meta,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$INext$_next$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if(((self__.start + self__.step) < self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
} else {
if(((self__.start + self__.step) > self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
}
});

cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(cljs.core.not(cljs.core._seq(rng__$1))){
return (0);
} else {
var G__11137 = ((self__.end - self__.start) / self__.step);
return (Math.ceil.cljs$core$IFn$_invoke$arity$1 ? Math.ceil.cljs$core$IFn$_invoke$arity$1(G__11137) : Math.ceil.call(null,G__11137));
}
});

cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
var h__5523__auto__ = self__.__hash;
if(!((h__5523__auto__ == null))){
return h__5523__auto__;
} else {
var h__5523__auto____$1 = cljs.core.hash_ordered_coll(rng__$1);
self__.__hash = h__5523__auto____$1;

return h__5523__auto____$1;
}
});

cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (rng,other){
var self__ = this;
var rng__$1 = this;
return cljs.core.equiv_sequential(rng__$1,other);
});

cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (rng,f){
var self__ = this;
var rng__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(rng__$1,f);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (rng,f,init){
var self__ = this;
var rng__$1 = this;
var i = self__.start;
var ret = init;
while(true){
if((((self__.step > (0)))?(i < self__.end):(i > self__.end))){
var ret__$1 = (function (){var G__11138 = ret;
var G__11139 = i;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11138,G__11139) : f.call(null,G__11138,G__11139));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
var G__11140 = ret__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11140) : cljs.core.deref.call(null,G__11140));
} else {
var G__11141 = (i + self__.step);
var G__11142 = ret__$1;
i = G__11141;
ret = G__11142;
continue;
}
} else {
return ret;
}
break;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((cljs.core._seq(rng__$1) == null)){
return null;
} else {
return self__.start;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(!((cljs.core._seq(rng__$1) == null))){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if((self__.start < self__.end)){
return rng__$1;
} else {
return null;
}
} else {
if((self__.start > self__.end)){
return rng__$1;
} else {
return null;
}
}
});

cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (rng,meta__$1){
var self__ = this;
var rng__$1 = this;
return (new cljs.core.Range(meta__$1,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = (function (rng,o){
var self__ = this;
var rng__$1 = this;
return cljs.core.cons(o,rng__$1);
});

cljs.core.Range.cljs$lang$type = true;

cljs.core.Range.cljs$lang$ctorStr = "cljs.core/Range";

cljs.core.Range.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/Range");
});

cljs.core.__GT_Range = (function __GT_Range(meta,start,end,step,__hash){
return (new cljs.core.Range(meta,start,end,step,__hash));
});

(cljs.core.Range.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));
/**
* Returns a lazy seq of nums from start (inclusive) to end
* (exclusive), by step, where start defaults to 0, step to 1,
* and end to infinity.
*/
cljs.core.range = (function() {
var range = null;
var range__0 = (function (){
return range.cljs$core$IFn$_invoke$arity$3((0),Number.MAX_VALUE,(1));
});
var range__1 = (function (end){
return range.cljs$core$IFn$_invoke$arity$3((0),end,(1));
});
var range__2 = (function (start,end){
return range.cljs$core$IFn$_invoke$arity$3(start,end,(1));
});
var range__3 = (function (start,end,step){
return (new cljs.core.Range(null,start,end,step,null));
});
range = function(start,end,step){
switch(arguments.length){
case 0:
return range__0.call(this);
case 1:
return range__1.call(this,start);
case 2:
return range__2.call(this,start,end);
case 3:
return range__3.call(this,start,end,step);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
range.cljs$core$IFn$_invoke$arity$0 = range__0;
range.cljs$core$IFn$_invoke$arity$1 = range__1;
range.cljs$core$IFn$_invoke$arity$2 = range__2;
range.cljs$core$IFn$_invoke$arity$3 = range__3;
return range;
})()
;
/**
* Returns a lazy seq of every nth item in coll.  Returns a stateful
* transducer when no collection is provided.
*/
cljs.core.take_nth = (function() {
var take_nth = null;
var take_nth__1 = (function (n){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__11160 = null;
var G__11160__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11160__1 = (function (result){
var G__11157 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11157) : rf.call(null,G__11157));
});
var G__11160__2 = (function (result,input){
var i = ia.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(ia.cljs$core$IDeref$_deref$arity$1(null) + (1)));
if((cljs.core.rem(i,n) === (0))){
var G__11158 = result;
var G__11159 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11158,G__11159) : rf.call(null,G__11158,G__11159));
} else {
return result;
}
});
G__11160 = function(result,input){
switch(arguments.length){
case 0:
return G__11160__0.call(this);
case 1:
return G__11160__1.call(this,result);
case 2:
return G__11160__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11160.cljs$core$IFn$_invoke$arity$0 = G__11160__0;
G__11160.cljs$core$IFn$_invoke$arity$1 = G__11160__1;
G__11160.cljs$core$IFn$_invoke$arity$2 = G__11160__2;
return G__11160;
})()
;})(ia))
});
});
var take_nth__2 = (function (n,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.cons(cljs.core.first(s),take_nth.cljs$core$IFn$_invoke$arity$2(n,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s)));
} else {
return null;
}
}),null,null));
});
take_nth = function(n,coll){
switch(arguments.length){
case 1:
return take_nth__1.call(this,n);
case 2:
return take_nth__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take_nth.cljs$core$IFn$_invoke$arity$1 = take_nth__1;
take_nth.cljs$core$IFn$_invoke$arity$2 = take_nth__2;
return take_nth;
})()
;
/**
* Returns a vector of [(take-while pred coll) (drop-while pred coll)]
*/
cljs.core.split_with = (function split_with(pred,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred,coll),cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(pred,coll)], null);
});
/**
* Applies f to each value in coll, splitting it each time f returns a
* new value.  Returns a lazy seq of partitions.  Returns a stateful
* transducer when no collection is provided.
*/
cljs.core.partition_by = (function() {
var partition_by = null;
var partition_by__1 = (function (f){
return (function (rf){
var a = cljs.core.array_list();
var pa = cljs.core.volatile_BANG_(new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439));
return ((function (a,pa){
return (function() {
var G__11182 = null;
var G__11182__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11182__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((function (){var G__11173 = result;
var G__11174 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11173,G__11174) : rf.call(null,G__11173,G__11174));
})());
})());
var G__11175 = result__$1;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11175) : rf.call(null,G__11175));
});
var G__11182__2 = (function (result,input){
var pval = (function (){var G__11176 = pa;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11176) : cljs.core.deref.call(null,G__11176));
})();
var val = (function (){var G__11177 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11177) : f.call(null,G__11177));
})();
cljs.core.vreset_BANG_(pa,val);

if((cljs.core.keyword_identical_QMARK_(pval,new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,pval))){
a.add(input);

return result;
} else {
var v = cljs.core.vec(a.toArray());
a.clear();

var ret = (function (){var G__11178 = result;
var G__11179 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11178,G__11179) : rf.call(null,G__11178,G__11179));
})();
if(cljs.core.reduced_QMARK_(ret)){
} else {
a.add(input);
}

return ret;
}
});
G__11182 = function(result,input){
switch(arguments.length){
case 0:
return G__11182__0.call(this);
case 1:
return G__11182__1.call(this,result);
case 2:
return G__11182__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11182.cljs$core$IFn$_invoke$arity$0 = G__11182__0;
G__11182.cljs$core$IFn$_invoke$arity$1 = G__11182__1;
G__11182.cljs$core$IFn$_invoke$arity$2 = G__11182__2;
return G__11182;
})()
;})(a,pa))
});
});
var partition_by__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
var fst = cljs.core.first(s);
var fv = (function (){var G__11180 = fst;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11180) : f.call(null,G__11180));
})();
var run = cljs.core.cons(fst,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (fst,fv,s,temp__4126__auto__){
return (function (p1__11161_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fv,(function (){var G__11181 = p1__11161_SHARP_;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11181) : f.call(null,G__11181));
})());
});})(fst,fv,s,temp__4126__auto__))
,cljs.core.next(s)));
return cljs.core.cons(run,partition_by.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(cljs.core.count(run),s))));
} else {
return null;
}
}),null,null));
});
partition_by = function(f,coll){
switch(arguments.length){
case 1:
return partition_by__1.call(this,f);
case 2:
return partition_by__2.call(this,f,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition_by.cljs$core$IFn$_invoke$arity$1 = partition_by__1;
partition_by.cljs$core$IFn$_invoke$arity$2 = partition_by__2;
return partition_by;
})()
;
/**
* Returns a map from distinct items in coll to the number of times
* they appear.
*/
cljs.core.frequencies = (function frequencies(coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (counts,x){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(counts,x,(cljs.core.get.cljs$core$IFn$_invoke$arity$3(counts,x,(0)) + (1)));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
* Returns a lazy seq of the intermediate values of the reduction (as
* per reduce) of coll by f, starting with init.
*/
cljs.core.reductions = (function() {
var reductions = null;
var reductions__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4124__auto__ = cljs.core.seq(coll);
if(temp__4124__auto__){
var s = temp__4124__auto__;
return reductions.cljs$core$IFn$_invoke$arity$3(f,cljs.core.first(s),cljs.core.rest(s));
} else {
return cljs.core._conj(cljs.core.List.EMPTY,(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})());
}
}),null,null));
});
var reductions__3 = (function (f,init,coll){
return cljs.core.cons(init,(new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return reductions.cljs$core$IFn$_invoke$arity$3(f,(function (){var G__11191 = init;
var G__11192 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11191,G__11192) : f.call(null,G__11191,G__11192));
})(),cljs.core.rest(s));
} else {
return null;
}
}),null,null)));
});
reductions = function(f,init,coll){
switch(arguments.length){
case 2:
return reductions__2.call(this,f,init);
case 3:
return reductions__3.call(this,f,init,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
reductions.cljs$core$IFn$_invoke$arity$2 = reductions__2;
reductions.cljs$core$IFn$_invoke$arity$3 = reductions__3;
return reductions;
})()
;
/**
* Takes a set of functions and returns a fn that is the juxtaposition
* of those fns.  The returned fn takes a variable number of args, and
* returns a vector containing the result of applying each fn to the
* args (left-to-right).
* ((juxt a b c) x) => [(a x) (b x) (c x)]
* @param {...*} var_args
*/
cljs.core.juxt = (function() {
var juxt = null;
var juxt__1 = (function (f){
return (function() {
var G__11287 = null;
var G__11287__0 = (function (){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})()],null));
});
var G__11287__1 = (function (x){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__11245 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11245) : f.call(null,G__11245));
})()],null));
});
var G__11287__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__11246 = x;
var G__11247 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11246,G__11247) : f.call(null,G__11246,G__11247));
})()],null));
});
var G__11287__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__11248 = x;
var G__11249 = y;
var G__11250 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11248,G__11249,G__11250) : f.call(null,G__11248,G__11249,G__11250));
})()],null));
});
var G__11287__4 = (function() { 
var G__11288__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args)],null));
};
var G__11288 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__11289__i = 0, G__11289__a = new Array(arguments.length -  3);
while (G__11289__i < G__11289__a.length) {G__11289__a[G__11289__i] = arguments[G__11289__i + 3]; ++G__11289__i;}
  args = new cljs.core.IndexedSeq(G__11289__a,0);
} 
return G__11288__delegate.call(this,x,y,z,args);};
G__11288.cljs$lang$maxFixedArity = 3;
G__11288.cljs$lang$applyTo = (function (arglist__11290){
var x = cljs.core.first(arglist__11290);
arglist__11290 = cljs.core.next(arglist__11290);
var y = cljs.core.first(arglist__11290);
arglist__11290 = cljs.core.next(arglist__11290);
var z = cljs.core.first(arglist__11290);
var args = cljs.core.rest(arglist__11290);
return G__11288__delegate(x,y,z,args);
});
G__11288.cljs$core$IFn$_invoke$arity$variadic = G__11288__delegate;
return G__11288;
})()
;
G__11287 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__11287__0.call(this);
case 1:
return G__11287__1.call(this,x);
case 2:
return G__11287__2.call(this,x,y);
case 3:
return G__11287__3.call(this,x,y,z);
default:
var G__11291 = null;
if (arguments.length > 3) {
var G__11292__i = 0, G__11292__a = new Array(arguments.length -  3);
while (G__11292__i < G__11292__a.length) {G__11292__a[G__11292__i] = arguments[G__11292__i + 3]; ++G__11292__i;}
G__11291 = new cljs.core.IndexedSeq(G__11292__a,0);
}
return G__11287__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__11291);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11287.cljs$lang$maxFixedArity = 3;
G__11287.cljs$lang$applyTo = G__11287__4.cljs$lang$applyTo;
G__11287.cljs$core$IFn$_invoke$arity$0 = G__11287__0;
G__11287.cljs$core$IFn$_invoke$arity$1 = G__11287__1;
G__11287.cljs$core$IFn$_invoke$arity$2 = G__11287__2;
G__11287.cljs$core$IFn$_invoke$arity$3 = G__11287__3;
G__11287.cljs$core$IFn$_invoke$arity$variadic = G__11287__4.cljs$core$IFn$_invoke$arity$variadic;
return G__11287;
})()
});
var juxt__2 = (function (f,g){
return (function() {
var G__11293 = null;
var G__11293__0 = (function (){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),(function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})()],null));
});
var G__11293__1 = (function (x){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__11251 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11251) : f.call(null,G__11251));
})(),(function (){var G__11252 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__11252) : g.call(null,G__11252));
})()],null));
});
var G__11293__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__11253 = x;
var G__11254 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11253,G__11254) : f.call(null,G__11253,G__11254));
})(),(function (){var G__11255 = x;
var G__11256 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__11255,G__11256) : g.call(null,G__11255,G__11256));
})()],null));
});
var G__11293__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__11257 = x;
var G__11258 = y;
var G__11259 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11257,G__11258,G__11259) : f.call(null,G__11257,G__11258,G__11259));
})(),(function (){var G__11260 = x;
var G__11261 = y;
var G__11262 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__11260,G__11261,G__11262) : g.call(null,G__11260,G__11261,G__11262));
})()],null));
});
var G__11293__4 = (function() { 
var G__11294__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args)],null));
};
var G__11294 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__11295__i = 0, G__11295__a = new Array(arguments.length -  3);
while (G__11295__i < G__11295__a.length) {G__11295__a[G__11295__i] = arguments[G__11295__i + 3]; ++G__11295__i;}
  args = new cljs.core.IndexedSeq(G__11295__a,0);
} 
return G__11294__delegate.call(this,x,y,z,args);};
G__11294.cljs$lang$maxFixedArity = 3;
G__11294.cljs$lang$applyTo = (function (arglist__11296){
var x = cljs.core.first(arglist__11296);
arglist__11296 = cljs.core.next(arglist__11296);
var y = cljs.core.first(arglist__11296);
arglist__11296 = cljs.core.next(arglist__11296);
var z = cljs.core.first(arglist__11296);
var args = cljs.core.rest(arglist__11296);
return G__11294__delegate(x,y,z,args);
});
G__11294.cljs$core$IFn$_invoke$arity$variadic = G__11294__delegate;
return G__11294;
})()
;
G__11293 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__11293__0.call(this);
case 1:
return G__11293__1.call(this,x);
case 2:
return G__11293__2.call(this,x,y);
case 3:
return G__11293__3.call(this,x,y,z);
default:
var G__11297 = null;
if (arguments.length > 3) {
var G__11298__i = 0, G__11298__a = new Array(arguments.length -  3);
while (G__11298__i < G__11298__a.length) {G__11298__a[G__11298__i] = arguments[G__11298__i + 3]; ++G__11298__i;}
G__11297 = new cljs.core.IndexedSeq(G__11298__a,0);
}
return G__11293__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__11297);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11293.cljs$lang$maxFixedArity = 3;
G__11293.cljs$lang$applyTo = G__11293__4.cljs$lang$applyTo;
G__11293.cljs$core$IFn$_invoke$arity$0 = G__11293__0;
G__11293.cljs$core$IFn$_invoke$arity$1 = G__11293__1;
G__11293.cljs$core$IFn$_invoke$arity$2 = G__11293__2;
G__11293.cljs$core$IFn$_invoke$arity$3 = G__11293__3;
G__11293.cljs$core$IFn$_invoke$arity$variadic = G__11293__4.cljs$core$IFn$_invoke$arity$variadic;
return G__11293;
})()
});
var juxt__3 = (function (f,g,h){
return (function() {
var G__11299 = null;
var G__11299__0 = (function (){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),(function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})(),(function (){return (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
})()],null));
});
var G__11299__1 = (function (x){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__11263 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11263) : f.call(null,G__11263));
})(),(function (){var G__11264 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__11264) : g.call(null,G__11264));
})(),(function (){var G__11265 = x;
return (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(G__11265) : h.call(null,G__11265));
})()],null));
});
var G__11299__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__11266 = x;
var G__11267 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11266,G__11267) : f.call(null,G__11266,G__11267));
})(),(function (){var G__11268 = x;
var G__11269 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__11268,G__11269) : g.call(null,G__11268,G__11269));
})(),(function (){var G__11270 = x;
var G__11271 = y;
return (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(G__11270,G__11271) : h.call(null,G__11270,G__11271));
})()],null));
});
var G__11299__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__11272 = x;
var G__11273 = y;
var G__11274 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11272,G__11273,G__11274) : f.call(null,G__11272,G__11273,G__11274));
})(),(function (){var G__11275 = x;
var G__11276 = y;
var G__11277 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__11275,G__11276,G__11277) : g.call(null,G__11275,G__11276,G__11277));
})(),(function (){var G__11278 = x;
var G__11279 = y;
var G__11280 = z;
return (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(G__11278,G__11279,G__11280) : h.call(null,G__11278,G__11279,G__11280));
})()],null));
});
var G__11299__4 = (function() { 
var G__11300__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args)],null));
};
var G__11300 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__11301__i = 0, G__11301__a = new Array(arguments.length -  3);
while (G__11301__i < G__11301__a.length) {G__11301__a[G__11301__i] = arguments[G__11301__i + 3]; ++G__11301__i;}
  args = new cljs.core.IndexedSeq(G__11301__a,0);
} 
return G__11300__delegate.call(this,x,y,z,args);};
G__11300.cljs$lang$maxFixedArity = 3;
G__11300.cljs$lang$applyTo = (function (arglist__11302){
var x = cljs.core.first(arglist__11302);
arglist__11302 = cljs.core.next(arglist__11302);
var y = cljs.core.first(arglist__11302);
arglist__11302 = cljs.core.next(arglist__11302);
var z = cljs.core.first(arglist__11302);
var args = cljs.core.rest(arglist__11302);
return G__11300__delegate(x,y,z,args);
});
G__11300.cljs$core$IFn$_invoke$arity$variadic = G__11300__delegate;
return G__11300;
})()
;
G__11299 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__11299__0.call(this);
case 1:
return G__11299__1.call(this,x);
case 2:
return G__11299__2.call(this,x,y);
case 3:
return G__11299__3.call(this,x,y,z);
default:
var G__11303 = null;
if (arguments.length > 3) {
var G__11304__i = 0, G__11304__a = new Array(arguments.length -  3);
while (G__11304__i < G__11304__a.length) {G__11304__a[G__11304__i] = arguments[G__11304__i + 3]; ++G__11304__i;}
G__11303 = new cljs.core.IndexedSeq(G__11304__a,0);
}
return G__11299__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__11303);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11299.cljs$lang$maxFixedArity = 3;
G__11299.cljs$lang$applyTo = G__11299__4.cljs$lang$applyTo;
G__11299.cljs$core$IFn$_invoke$arity$0 = G__11299__0;
G__11299.cljs$core$IFn$_invoke$arity$1 = G__11299__1;
G__11299.cljs$core$IFn$_invoke$arity$2 = G__11299__2;
G__11299.cljs$core$IFn$_invoke$arity$3 = G__11299__3;
G__11299.cljs$core$IFn$_invoke$arity$variadic = G__11299__4.cljs$core$IFn$_invoke$arity$variadic;
return G__11299;
})()
});
var juxt__4 = (function() { 
var G__11305__delegate = function (f,g,h,fs){
var fs__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f,g,h,fs);
return ((function (fs__$1){
return (function() {
var G__11306 = null;
var G__11306__0 = (function (){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__11193_SHARP_,p2__11194_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__11193_SHARP_,(function (){return (p2__11194_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p2__11194_SHARP_.cljs$core$IFn$_invoke$arity$0() : p2__11194_SHARP_.call(null));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__11306__1 = (function (x){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__11195_SHARP_,p2__11196_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__11195_SHARP_,(function (){var G__11281 = x;
return (p2__11196_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p2__11196_SHARP_.cljs$core$IFn$_invoke$arity$1(G__11281) : p2__11196_SHARP_.call(null,G__11281));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__11306__2 = (function (x,y){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__11197_SHARP_,p2__11198_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__11197_SHARP_,(function (){var G__11282 = x;
var G__11283 = y;
return (p2__11198_SHARP_.cljs$core$IFn$_invoke$arity$2 ? p2__11198_SHARP_.cljs$core$IFn$_invoke$arity$2(G__11282,G__11283) : p2__11198_SHARP_.call(null,G__11282,G__11283));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__11306__3 = (function (x,y,z){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__11199_SHARP_,p2__11200_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__11199_SHARP_,(function (){var G__11284 = x;
var G__11285 = y;
var G__11286 = z;
return (p2__11200_SHARP_.cljs$core$IFn$_invoke$arity$3 ? p2__11200_SHARP_.cljs$core$IFn$_invoke$arity$3(G__11284,G__11285,G__11286) : p2__11200_SHARP_.call(null,G__11284,G__11285,G__11286));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__11306__4 = (function() { 
var G__11307__delegate = function (x,y,z,args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__11201_SHARP_,p2__11202_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__11201_SHARP_,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(p2__11202_SHARP_,x,y,z,args));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
};
var G__11307 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__11308__i = 0, G__11308__a = new Array(arguments.length -  3);
while (G__11308__i < G__11308__a.length) {G__11308__a[G__11308__i] = arguments[G__11308__i + 3]; ++G__11308__i;}
  args = new cljs.core.IndexedSeq(G__11308__a,0);
} 
return G__11307__delegate.call(this,x,y,z,args);};
G__11307.cljs$lang$maxFixedArity = 3;
G__11307.cljs$lang$applyTo = (function (arglist__11309){
var x = cljs.core.first(arglist__11309);
arglist__11309 = cljs.core.next(arglist__11309);
var y = cljs.core.first(arglist__11309);
arglist__11309 = cljs.core.next(arglist__11309);
var z = cljs.core.first(arglist__11309);
var args = cljs.core.rest(arglist__11309);
return G__11307__delegate(x,y,z,args);
});
G__11307.cljs$core$IFn$_invoke$arity$variadic = G__11307__delegate;
return G__11307;
})()
;
G__11306 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__11306__0.call(this);
case 1:
return G__11306__1.call(this,x);
case 2:
return G__11306__2.call(this,x,y);
case 3:
return G__11306__3.call(this,x,y,z);
default:
var G__11310 = null;
if (arguments.length > 3) {
var G__11311__i = 0, G__11311__a = new Array(arguments.length -  3);
while (G__11311__i < G__11311__a.length) {G__11311__a[G__11311__i] = arguments[G__11311__i + 3]; ++G__11311__i;}
G__11310 = new cljs.core.IndexedSeq(G__11311__a,0);
}
return G__11306__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__11310);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11306.cljs$lang$maxFixedArity = 3;
G__11306.cljs$lang$applyTo = G__11306__4.cljs$lang$applyTo;
G__11306.cljs$core$IFn$_invoke$arity$0 = G__11306__0;
G__11306.cljs$core$IFn$_invoke$arity$1 = G__11306__1;
G__11306.cljs$core$IFn$_invoke$arity$2 = G__11306__2;
G__11306.cljs$core$IFn$_invoke$arity$3 = G__11306__3;
G__11306.cljs$core$IFn$_invoke$arity$variadic = G__11306__4.cljs$core$IFn$_invoke$arity$variadic;
return G__11306;
})()
;})(fs__$1))
};
var G__11305 = function (f,g,h,var_args){
var fs = null;
if (arguments.length > 3) {
var G__11312__i = 0, G__11312__a = new Array(arguments.length -  3);
while (G__11312__i < G__11312__a.length) {G__11312__a[G__11312__i] = arguments[G__11312__i + 3]; ++G__11312__i;}
  fs = new cljs.core.IndexedSeq(G__11312__a,0);
} 
return G__11305__delegate.call(this,f,g,h,fs);};
G__11305.cljs$lang$maxFixedArity = 3;
G__11305.cljs$lang$applyTo = (function (arglist__11313){
var f = cljs.core.first(arglist__11313);
arglist__11313 = cljs.core.next(arglist__11313);
var g = cljs.core.first(arglist__11313);
arglist__11313 = cljs.core.next(arglist__11313);
var h = cljs.core.first(arglist__11313);
var fs = cljs.core.rest(arglist__11313);
return G__11305__delegate(f,g,h,fs);
});
G__11305.cljs$core$IFn$_invoke$arity$variadic = G__11305__delegate;
return G__11305;
})()
;
juxt = function(f,g,h,var_args){
var fs = var_args;
switch(arguments.length){
case 1:
return juxt__1.call(this,f);
case 2:
return juxt__2.call(this,f,g);
case 3:
return juxt__3.call(this,f,g,h);
default:
var G__11314 = null;
if (arguments.length > 3) {
var G__11315__i = 0, G__11315__a = new Array(arguments.length -  3);
while (G__11315__i < G__11315__a.length) {G__11315__a[G__11315__i] = arguments[G__11315__i + 3]; ++G__11315__i;}
G__11314 = new cljs.core.IndexedSeq(G__11315__a,0);
}
return juxt__4.cljs$core$IFn$_invoke$arity$variadic(f,g,h, G__11314);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
juxt.cljs$lang$maxFixedArity = 3;
juxt.cljs$lang$applyTo = juxt__4.cljs$lang$applyTo;
juxt.cljs$core$IFn$_invoke$arity$1 = juxt__1;
juxt.cljs$core$IFn$_invoke$arity$2 = juxt__2;
juxt.cljs$core$IFn$_invoke$arity$3 = juxt__3;
juxt.cljs$core$IFn$_invoke$arity$variadic = juxt__4.cljs$core$IFn$_invoke$arity$variadic;
return juxt;
})()
;
/**
* When lazy sequences are produced via functions that have side
* effects, any effects other than those needed to produce the first
* element in the seq do not occur until the seq is consumed. dorun can
* be used to force any effects. Walks through the successive nexts of
* the seq, does not retain the head and returns nil.
*/
cljs.core.dorun = (function() {
var dorun = null;
var dorun__1 = (function (coll){
while(true){
if(cljs.core.seq(coll)){
var G__11316 = cljs.core.next(coll);
coll = G__11316;
continue;
} else {
return null;
}
break;
}
});
var dorun__2 = (function (n,coll){
while(true){
if((cljs.core.seq(coll)) && ((n > (0)))){
var G__11317 = (n - (1));
var G__11318 = cljs.core.next(coll);
n = G__11317;
coll = G__11318;
continue;
} else {
return null;
}
break;
}
});
dorun = function(n,coll){
switch(arguments.length){
case 1:
return dorun__1.call(this,n);
case 2:
return dorun__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
dorun.cljs$core$IFn$_invoke$arity$1 = dorun__1;
dorun.cljs$core$IFn$_invoke$arity$2 = dorun__2;
return dorun;
})()
;
/**
* When lazy sequences are produced via functions that have side
* effects, any effects other than those needed to produce the first
* element in the seq do not occur until the seq is consumed. doall can
* be used to force any effects. Walks through the successive nexts of
* the seq, retains the head and returns it, thus causing the entire
* seq to reside in memory at one time.
*/
cljs.core.doall = (function() {
var doall = null;
var doall__1 = (function (coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(coll);

return coll;
});
var doall__2 = (function (n,coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$2(n,coll);

return coll;
});
doall = function(n,coll){
switch(arguments.length){
case 1:
return doall__1.call(this,n);
case 2:
return doall__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
doall.cljs$core$IFn$_invoke$arity$1 = doall__1;
doall.cljs$core$IFn$_invoke$arity$2 = doall__2;
return doall;
})()
;
cljs.core.regexp_QMARK_ = (function regexp_QMARK_(o){
return (o instanceof RegExp);
});
/**
* Returns the result of (re-find re s) if re fully matches s.
*/
cljs.core.re_matches = (function re_matches(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(matches),s)){
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
} else {
return null;
}
} else {
throw (new TypeError("re-matches must match against a string."));
}
});
/**
* Returns the first regex match, if any, of s to re, using
* re.exec(s). Returns a vector, containing first the matching
* substring, then any capturing groups if the regular expression contains
* capturing groups.
*/
cljs.core.re_find = (function re_find(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if((matches == null)){
return null;
} else {
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
}
} else {
throw (new TypeError("re-find must match against a string."));
}
});
/**
* Returns a lazy sequence of successive matches of re in s.
*/
cljs.core.re_seq = (function re_seq(re,s){
var match_data = cljs.core.re_find(re,s);
var match_idx = s.search(re);
var match_str = ((cljs.core.coll_QMARK_(match_data))?cljs.core.first(match_data):match_data);
var post_match = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,(match_idx + cljs.core.count(match_str)));
if(cljs.core.truth_(match_data)){
return (new cljs.core.LazySeq(null,((function (match_data,match_idx,match_str,post_match){
return (function (){
return cljs.core.cons(match_data,((cljs.core.seq(post_match))?re_seq(re,post_match):null));
});})(match_data,match_idx,match_str,post_match))
,null,null));
} else {
return null;
}
});
/**
* Returns an instance of RegExp which has compiled the provided string.
*/
cljs.core.re_pattern = (function re_pattern(s){
if((s instanceof RegExp)){
return s;
} else {
var vec__11322 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,s);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11322,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11322,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11322,(2),null);
return (new RegExp(pattern,flags));
}
});
cljs.core.pr_sequential_writer = (function pr_sequential_writer(writer,print_one,begin,sep,end,opts,coll){
var _STAR_print_level_STAR_11330 = cljs.core._STAR_print_level_STAR_;
cljs.core._STAR_print_level_STAR_ = (((cljs.core._STAR_print_level_STAR_ == null))?null:(cljs.core._STAR_print_level_STAR_ - (1)));

try{if((!((cljs.core._STAR_print_level_STAR_ == null))) && ((cljs.core._STAR_print_level_STAR_ < (0)))){
return cljs.core._write(writer,"#");
} else {
cljs.core._write(writer,begin);

if((new cljs.core.Keyword(null,"print-length","print-length",1931866356).cljs$core$IFn$_invoke$arity$1(opts) === (0))){
if(cljs.core.seq(coll)){
cljs.core._write(writer,"...");
} else {
}
} else {
if(cljs.core.seq(coll)){
var G__11331_11337 = cljs.core.first(coll);
var G__11332_11338 = writer;
var G__11333_11339 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__11331_11337,G__11332_11338,G__11333_11339) : print_one.call(null,G__11331_11337,G__11332_11338,G__11333_11339));
} else {
}

var coll_11340__$1 = cljs.core.next(coll);
var n_11341 = (new cljs.core.Keyword(null,"print-length","print-length",1931866356).cljs$core$IFn$_invoke$arity$1(opts) - (1));
while(true){
if((coll_11340__$1) && (((n_11341 == null)) || (!((n_11341 === (0)))))){
cljs.core._write(writer,sep);

var G__11334_11342 = cljs.core.first(coll_11340__$1);
var G__11335_11343 = writer;
var G__11336_11344 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__11334_11342,G__11335_11343,G__11336_11344) : print_one.call(null,G__11334_11342,G__11335_11343,G__11336_11344));

var G__11345 = cljs.core.next(coll_11340__$1);
var G__11346 = (n_11341 - (1));
coll_11340__$1 = G__11345;
n_11341 = G__11346;
continue;
} else {
if((cljs.core.seq(coll_11340__$1)) && ((n_11341 === (0)))){
cljs.core._write(writer,sep);

cljs.core._write(writer,"...");
} else {
}
}
break;
}
}

return cljs.core._write(writer,end);
}
}finally {cljs.core._STAR_print_level_STAR_ = _STAR_print_level_STAR_11330;
}});
/**
* @param {...*} var_args
*/
cljs.core.write_all = (function() { 
var write_all__delegate = function (writer,ss){
var seq__11351 = cljs.core.seq(ss);
var chunk__11352 = null;
var count__11353 = (0);
var i__11354 = (0);
while(true){
if((i__11354 < count__11353)){
var s = chunk__11352.cljs$core$IIndexed$_nth$arity$2(null,i__11354);
cljs.core._write(writer,s);

var G__11355 = seq__11351;
var G__11356 = chunk__11352;
var G__11357 = count__11353;
var G__11358 = (i__11354 + (1));
seq__11351 = G__11355;
chunk__11352 = G__11356;
count__11353 = G__11357;
i__11354 = G__11358;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__11351);
if(temp__4126__auto__){
var seq__11351__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11351__$1)){
var c__5889__auto__ = cljs.core.chunk_first(seq__11351__$1);
var G__11359 = cljs.core.chunk_rest(seq__11351__$1);
var G__11360 = c__5889__auto__;
var G__11361 = cljs.core.count(c__5889__auto__);
var G__11362 = (0);
seq__11351 = G__11359;
chunk__11352 = G__11360;
count__11353 = G__11361;
i__11354 = G__11362;
continue;
} else {
var s = cljs.core.first(seq__11351__$1);
cljs.core._write(writer,s);

var G__11363 = cljs.core.next(seq__11351__$1);
var G__11364 = null;
var G__11365 = (0);
var G__11366 = (0);
seq__11351 = G__11363;
chunk__11352 = G__11364;
count__11353 = G__11365;
i__11354 = G__11366;
continue;
}
} else {
return null;
}
}
break;
}
};
var write_all = function (writer,var_args){
var ss = null;
if (arguments.length > 1) {
var G__11367__i = 0, G__11367__a = new Array(arguments.length -  1);
while (G__11367__i < G__11367__a.length) {G__11367__a[G__11367__i] = arguments[G__11367__i + 1]; ++G__11367__i;}
  ss = new cljs.core.IndexedSeq(G__11367__a,0);
} 
return write_all__delegate.call(this,writer,ss);};
write_all.cljs$lang$maxFixedArity = 1;
write_all.cljs$lang$applyTo = (function (arglist__11368){
var writer = cljs.core.first(arglist__11368);
var ss = cljs.core.rest(arglist__11368);
return write_all__delegate(writer,ss);
});
write_all.cljs$core$IFn$_invoke$arity$variadic = write_all__delegate;
return write_all;
})()
;
cljs.core.string_print = (function string_print(x){
(cljs.core._STAR_print_fn_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.core._STAR_print_fn_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.core._STAR_print_fn_STAR_.call(null,x));

return null;
});
cljs.core.flush = (function flush(){
return null;
});
cljs.core.char_escapes = (function (){var obj11370 = {"\"":"\\\"","\\":"\\\\","\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"};
return obj11370;
})();
cljs.core.quote_string = (function quote_string(s){
return [cljs.core.str("\""),cljs.core.str(s.replace((function (){var G__11373 = "[\\\\\"\b\f\n\r\t]";
var G__11374 = "g";
return RegExp(G__11373,G__11374);
})(),(function (match){
return (cljs.core.char_escapes[match]);
}))),cljs.core.str("\"")].join('');
});
/**
* Prefer this to pr-seq, because it makes the printing function
* configurable, allowing efficient implementations such as appending
* to a StringBuffer.
*/
cljs.core.pr_writer = (function pr_writer(obj,writer,opts){
if((obj == null)){
return cljs.core._write(writer,"nil");
} else {
if((void 0 === obj)){
return cljs.core._write(writer,"#<undefined>");
} else {
if(cljs.core.truth_((function (){var and__5090__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.core.truth_(and__5090__auto__)){
var and__5090__auto____$1 = (function (){var G__11388 = obj;
if(G__11388){
var bit__5783__auto__ = (G__11388.cljs$lang$protocol_mask$partition0$ & (131072));
if((bit__5783__auto__) || (G__11388.cljs$core$IMeta$)){
return true;
} else {
if((!G__11388.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__11388);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__11388);
}
})();
if(and__5090__auto____$1){
return cljs.core.meta(obj);
} else {
return and__5090__auto____$1;
}
} else {
return and__5090__auto__;
}
})())){
cljs.core._write(writer,"^");

pr_writer(cljs.core.meta(obj),writer,opts);

cljs.core._write(writer," ");
} else {
}

if((obj == null)){
return cljs.core._write(writer,"nil");
} else {
if(obj.cljs$lang$type){
return obj.cljs$lang$ctorPrWriter(obj,writer,opts);
} else {
if((function (){var G__11389 = obj;
if(G__11389){
var bit__5776__auto__ = (G__11389.cljs$lang$protocol_mask$partition0$ & (2147483648));
if((bit__5776__auto__) || (G__11389.cljs$core$IPrintWithWriter$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,opts);
} else {
if(((cljs.core.type(obj) === Boolean)) || (typeof obj === 'number')){
return cljs.core._write(writer,[cljs.core.str(obj)].join(''));
} else {
if(cljs.core.object_QMARK_(obj)){
cljs.core._write(writer,"#js ");

var G__11390 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (k){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k),(obj[k])], null);
}),cljs.core.js_keys(obj));
var G__11391 = pr_writer;
var G__11392 = writer;
var G__11393 = opts;
return (cljs.core.print_map.cljs$core$IFn$_invoke$arity$4 ? cljs.core.print_map.cljs$core$IFn$_invoke$arity$4(G__11390,G__11391,G__11392,G__11393) : cljs.core.print_map.call(null,G__11390,G__11391,G__11392,G__11393));
} else {
if(Array.isArray(obj)){
return cljs.core.pr_sequential_writer(writer,pr_writer,"#js ["," ","]",opts,obj);
} else {
if(cljs.core.truth_((function (){var G__11394 = obj;
return goog.isString(G__11394);
})())){
if(cljs.core.truth_(new cljs.core.Keyword(null,"readably","readably",1129599760).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core._write(writer,cljs.core.quote_string(obj));
} else {
return cljs.core._write(writer,obj);
}
} else {
if(cljs.core.fn_QMARK_(obj)){
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#<",[cljs.core.str(obj)].join(''),">"], 0));
} else {
if((obj instanceof Date)){
var normalize = (function (n,len){
var ns = [cljs.core.str(n)].join('');
while(true){
if((cljs.core.count(ns) < len)){
var G__11396 = [cljs.core.str("0"),cljs.core.str(ns)].join('');
ns = G__11396;
continue;
} else {
return ns;
}
break;
}
});
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#inst \"",[cljs.core.str(obj.getUTCFullYear())].join(''),"-",normalize((obj.getUTCMonth() + (1)),(2)),"-",normalize(obj.getUTCDate(),(2)),"T",normalize(obj.getUTCHours(),(2)),":",normalize(obj.getUTCMinutes(),(2)),":",normalize(obj.getUTCSeconds(),(2)),".",normalize(obj.getUTCMilliseconds(),(3)),"-","00:00\""], 0));
} else {
if(cljs.core.regexp_QMARK_(obj)){
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#\"",obj.source,"\""], 0));
} else {
if((function (){var G__11395 = obj;
if(G__11395){
var bit__5783__auto__ = (G__11395.cljs$lang$protocol_mask$partition0$ & (2147483648));
if((bit__5783__auto__) || (G__11395.cljs$core$IPrintWithWriter$)){
return true;
} else {
if((!G__11395.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IPrintWithWriter,G__11395);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IPrintWithWriter,G__11395);
}
})()){
return cljs.core._pr_writer(obj,writer,opts);
} else {
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#<",[cljs.core.str(obj)].join(''),">"], 0));

}
}
}
}
}
}
}
}
}
}
}

}
}
});
cljs.core.pr_seq_writer = (function pr_seq_writer(objs,writer,opts){
cljs.core.pr_writer(cljs.core.first(objs),writer,opts);

var seq__11401 = cljs.core.seq(cljs.core.next(objs));
var chunk__11402 = null;
var count__11403 = (0);
var i__11404 = (0);
while(true){
if((i__11404 < count__11403)){
var obj = chunk__11402.cljs$core$IIndexed$_nth$arity$2(null,i__11404);
cljs.core._write(writer," ");

cljs.core.pr_writer(obj,writer,opts);

var G__11405 = seq__11401;
var G__11406 = chunk__11402;
var G__11407 = count__11403;
var G__11408 = (i__11404 + (1));
seq__11401 = G__11405;
chunk__11402 = G__11406;
count__11403 = G__11407;
i__11404 = G__11408;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__11401);
if(temp__4126__auto__){
var seq__11401__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11401__$1)){
var c__5889__auto__ = cljs.core.chunk_first(seq__11401__$1);
var G__11409 = cljs.core.chunk_rest(seq__11401__$1);
var G__11410 = c__5889__auto__;
var G__11411 = cljs.core.count(c__5889__auto__);
var G__11412 = (0);
seq__11401 = G__11409;
chunk__11402 = G__11410;
count__11403 = G__11411;
i__11404 = G__11412;
continue;
} else {
var obj = cljs.core.first(seq__11401__$1);
cljs.core._write(writer," ");

cljs.core.pr_writer(obj,writer,opts);

var G__11413 = cljs.core.next(seq__11401__$1);
var G__11414 = null;
var G__11415 = (0);
var G__11416 = (0);
seq__11401 = G__11413;
chunk__11402 = G__11414;
count__11403 = G__11415;
i__11404 = G__11416;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.core.pr_sb_with_opts = (function pr_sb_with_opts(objs,opts){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
cljs.core.pr_seq_writer(objs,writer,opts);

writer.cljs$core$IWriter$_flush$arity$1(null);

return sb;
});
/**
* Prints a sequence of objects to a string, observing all the
* options given in opts
*/
cljs.core.pr_str_with_opts = (function pr_str_with_opts(objs,opts){
if(cljs.core.empty_QMARK_(objs)){
return "";
} else {
return [cljs.core.str(cljs.core.pr_sb_with_opts(objs,opts))].join('');
}
});
/**
* Same as pr-str-with-opts followed by (newline)
*/
cljs.core.prn_str_with_opts = (function prn_str_with_opts(objs,opts){
if(cljs.core.empty_QMARK_(objs)){
return "\n";
} else {
var sb = cljs.core.pr_sb_with_opts(objs,opts);
sb.append("\n");

return [cljs.core.str(sb)].join('');
}
});
/**
* Prints a sequence of objects using string-print, observing all
* the options given in opts
*/
cljs.core.pr_with_opts = (function pr_with_opts(objs,opts){
return cljs.core.string_print(cljs.core.pr_str_with_opts(objs,opts));
});
cljs.core.newline = (function newline(opts){
cljs.core.string_print("\n");

if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939)))){
return cljs.core.flush();
} else {
return null;
}
});
/**
* pr to a string, returning it. Fundamental entrypoint to IPrintWithWriter.
* @param {...*} var_args
*/
cljs.core.pr_str = (function() { 
var pr_str__delegate = function (objs){
return cljs.core.pr_str_with_opts(objs,cljs.core.pr_opts());
};
var pr_str = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__11417__i = 0, G__11417__a = new Array(arguments.length -  0);
while (G__11417__i < G__11417__a.length) {G__11417__a[G__11417__i] = arguments[G__11417__i + 0]; ++G__11417__i;}
  objs = new cljs.core.IndexedSeq(G__11417__a,0);
} 
return pr_str__delegate.call(this,objs);};
pr_str.cljs$lang$maxFixedArity = 0;
pr_str.cljs$lang$applyTo = (function (arglist__11418){
var objs = cljs.core.seq(arglist__11418);
return pr_str__delegate(objs);
});
pr_str.cljs$core$IFn$_invoke$arity$variadic = pr_str__delegate;
return pr_str;
})()
;
/**
* Same as pr-str followed by (newline)
* @param {...*} var_args
*/
cljs.core.prn_str = (function() { 
var prn_str__delegate = function (objs){
return cljs.core.prn_str_with_opts(objs,cljs.core.pr_opts());
};
var prn_str = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__11419__i = 0, G__11419__a = new Array(arguments.length -  0);
while (G__11419__i < G__11419__a.length) {G__11419__a[G__11419__i] = arguments[G__11419__i + 0]; ++G__11419__i;}
  objs = new cljs.core.IndexedSeq(G__11419__a,0);
} 
return prn_str__delegate.call(this,objs);};
prn_str.cljs$lang$maxFixedArity = 0;
prn_str.cljs$lang$applyTo = (function (arglist__11420){
var objs = cljs.core.seq(arglist__11420);
return prn_str__delegate(objs);
});
prn_str.cljs$core$IFn$_invoke$arity$variadic = prn_str__delegate;
return prn_str;
})()
;
/**
* Prints the object(s) using string-print.  Prints the
* object(s), separated by spaces if there is more than one.
* By default, pr and prn print in a way that objects can be
* read by the reader
* @param {...*} var_args
*/
cljs.core.pr = (function() { 
var pr__delegate = function (objs){
return cljs.core.pr_with_opts(objs,cljs.core.pr_opts());
};
var pr = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__11421__i = 0, G__11421__a = new Array(arguments.length -  0);
while (G__11421__i < G__11421__a.length) {G__11421__a[G__11421__i] = arguments[G__11421__i + 0]; ++G__11421__i;}
  objs = new cljs.core.IndexedSeq(G__11421__a,0);
} 
return pr__delegate.call(this,objs);};
pr.cljs$lang$maxFixedArity = 0;
pr.cljs$lang$applyTo = (function (arglist__11422){
var objs = cljs.core.seq(arglist__11422);
return pr__delegate(objs);
});
pr.cljs$core$IFn$_invoke$arity$variadic = pr__delegate;
return pr;
})()
;
/**
* Prints the object(s) using string-print.
* print and println produce output for human consumption.
* @param {...*} var_args
*/
cljs.core.print = (function() { 
var cljs_core_print__delegate = function (objs){
return cljs.core.pr_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
};
var cljs_core_print = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__11423__i = 0, G__11423__a = new Array(arguments.length -  0);
while (G__11423__i < G__11423__a.length) {G__11423__a[G__11423__i] = arguments[G__11423__i + 0]; ++G__11423__i;}
  objs = new cljs.core.IndexedSeq(G__11423__a,0);
} 
return cljs_core_print__delegate.call(this,objs);};
cljs_core_print.cljs$lang$maxFixedArity = 0;
cljs_core_print.cljs$lang$applyTo = (function (arglist__11424){
var objs = cljs.core.seq(arglist__11424);
return cljs_core_print__delegate(objs);
});
cljs_core_print.cljs$core$IFn$_invoke$arity$variadic = cljs_core_print__delegate;
return cljs_core_print;
})()
;
/**
* print to a string, returning it
* @param {...*} var_args
*/
cljs.core.print_str = (function() { 
var print_str__delegate = function (objs){
return cljs.core.pr_str_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
};
var print_str = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__11425__i = 0, G__11425__a = new Array(arguments.length -  0);
while (G__11425__i < G__11425__a.length) {G__11425__a[G__11425__i] = arguments[G__11425__i + 0]; ++G__11425__i;}
  objs = new cljs.core.IndexedSeq(G__11425__a,0);
} 
return print_str__delegate.call(this,objs);};
print_str.cljs$lang$maxFixedArity = 0;
print_str.cljs$lang$applyTo = (function (arglist__11426){
var objs = cljs.core.seq(arglist__11426);
return print_str__delegate(objs);
});
print_str.cljs$core$IFn$_invoke$arity$variadic = print_str__delegate;
return print_str;
})()
;
/**
* Same as print followed by (newline)
* @param {...*} var_args
*/
cljs.core.println = (function() { 
var println__delegate = function (objs){
cljs.core.pr_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));

if(cljs.core.truth_(cljs.core._STAR_print_newline_STAR_)){
return cljs.core.newline(cljs.core.pr_opts());
} else {
return null;
}
};
var println = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__11427__i = 0, G__11427__a = new Array(arguments.length -  0);
while (G__11427__i < G__11427__a.length) {G__11427__a[G__11427__i] = arguments[G__11427__i + 0]; ++G__11427__i;}
  objs = new cljs.core.IndexedSeq(G__11427__a,0);
} 
return println__delegate.call(this,objs);};
println.cljs$lang$maxFixedArity = 0;
println.cljs$lang$applyTo = (function (arglist__11428){
var objs = cljs.core.seq(arglist__11428);
return println__delegate(objs);
});
println.cljs$core$IFn$_invoke$arity$variadic = println__delegate;
return println;
})()
;
/**
* println to a string, returning it
* @param {...*} var_args
*/
cljs.core.println_str = (function() { 
var println_str__delegate = function (objs){
return cljs.core.prn_str_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
};
var println_str = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__11429__i = 0, G__11429__a = new Array(arguments.length -  0);
while (G__11429__i < G__11429__a.length) {G__11429__a[G__11429__i] = arguments[G__11429__i + 0]; ++G__11429__i;}
  objs = new cljs.core.IndexedSeq(G__11429__a,0);
} 
return println_str__delegate.call(this,objs);};
println_str.cljs$lang$maxFixedArity = 0;
println_str.cljs$lang$applyTo = (function (arglist__11430){
var objs = cljs.core.seq(arglist__11430);
return println_str__delegate(objs);
});
println_str.cljs$core$IFn$_invoke$arity$variadic = println_str__delegate;
return println_str;
})()
;
/**
* Same as pr followed by (newline).
* @param {...*} var_args
*/
cljs.core.prn = (function() { 
var prn__delegate = function (objs){
cljs.core.pr_with_opts(objs,cljs.core.pr_opts());

if(cljs.core.truth_(cljs.core._STAR_print_newline_STAR_)){
return cljs.core.newline(cljs.core.pr_opts());
} else {
return null;
}
};
var prn = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__11431__i = 0, G__11431__a = new Array(arguments.length -  0);
while (G__11431__i < G__11431__a.length) {G__11431__a[G__11431__i] = arguments[G__11431__i + 0]; ++G__11431__i;}
  objs = new cljs.core.IndexedSeq(G__11431__a,0);
} 
return prn__delegate.call(this,objs);};
prn.cljs$lang$maxFixedArity = 0;
prn.cljs$lang$applyTo = (function (arglist__11432){
var objs = cljs.core.seq(arglist__11432);
return prn__delegate(objs);
});
prn.cljs$core$IFn$_invoke$arity$variadic = prn__delegate;
return prn;
})()
;
cljs.core.print_map = (function print_map(m,print_one,writer,opts){
return cljs.core.pr_sequential_writer(writer,(function (e,w,opts__$1){
var G__11439_11445 = cljs.core.key(e);
var G__11440_11446 = w;
var G__11441_11447 = opts__$1;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__11439_11445,G__11440_11446,G__11441_11447) : print_one.call(null,G__11439_11445,G__11440_11446,G__11441_11447));

cljs.core._write(w," ");

var G__11442 = cljs.core.val(e);
var G__11443 = w;
var G__11444 = opts__$1;
return (print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__11442,G__11443,G__11444) : print_one.call(null,G__11442,G__11443,G__11444));
}),"{",", ","}",opts,cljs.core.seq(m));
});
cljs.core.Volatile.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Volatile.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#<Volatile: ");

cljs.core.pr_writer(a__$1.state,writer,opts);

return cljs.core._write(writer,">");
});

cljs.core.Var.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Var.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#'");

return cljs.core.pr_writer(a__$1.sym,writer,opts);
});

cljs.core.IndexedSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.IndexedSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.LazySeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.NodeSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.BlackNode.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.BlackNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ES6IteratorSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#{"," ","}",opts,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ChunkedSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.ObjMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ObjMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.Cons.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Cons.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.RSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentHashMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.Subvec.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Subvec.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentHashSet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#{"," ","}",opts,coll__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ChunkedCons.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.Atom.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Atom.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#<Atom: ");

cljs.core.pr_writer(a__$1.state,writer,opts);

return cljs.core._write(writer,">");
});

cljs.core.ValSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ValSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.RedNode.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.RedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentVector.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.EmptyList.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core._write(writer,"()");
});

cljs.core.LazyTransformer.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.LazyTransformer.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentQueue.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentQueue.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#queue ["," ","]",opts,cljs.core.seq(coll__$1));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.Range.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Range.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.KeySeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.List.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.List.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});
cljs.core.PersistentVector.prototype.cljs$core$IComparable$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(x__$1,y);
});

cljs.core.Subvec.prototype.cljs$core$IComparable$ = true;

cljs.core.Subvec.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(x__$1,y);
});

cljs.core.Keyword.prototype.cljs$core$IComparable$ = true;

cljs.core.Keyword.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_keywords(x__$1,y);
});

cljs.core.Symbol.prototype.cljs$core$IComparable$ = true;

cljs.core.Symbol.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_symbols(x__$1,y);
});
/**
* Atomically sets the metadata for a namespace/var/ref/agent/atom to be:
* 
* (apply f its-current-meta args)
* 
* f must be free of side-effects
* @param {...*} var_args
*/
cljs.core.alter_meta_BANG_ = (function() { 
var alter_meta_BANG___delegate = function (iref,f,args){
return iref.meta = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,iref.meta,args);
};
var alter_meta_BANG_ = function (iref,f,var_args){
var args = null;
if (arguments.length > 2) {
var G__11448__i = 0, G__11448__a = new Array(arguments.length -  2);
while (G__11448__i < G__11448__a.length) {G__11448__a[G__11448__i] = arguments[G__11448__i + 2]; ++G__11448__i;}
  args = new cljs.core.IndexedSeq(G__11448__a,0);
} 
return alter_meta_BANG___delegate.call(this,iref,f,args);};
alter_meta_BANG_.cljs$lang$maxFixedArity = 2;
alter_meta_BANG_.cljs$lang$applyTo = (function (arglist__11449){
var iref = cljs.core.first(arglist__11449);
arglist__11449 = cljs.core.next(arglist__11449);
var f = cljs.core.first(arglist__11449);
var args = cljs.core.rest(arglist__11449);
return alter_meta_BANG___delegate(iref,f,args);
});
alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic = alter_meta_BANG___delegate;
return alter_meta_BANG_;
})()
;
/**
* Atomically resets the metadata for an atom
*/
cljs.core.reset_meta_BANG_ = (function reset_meta_BANG_(iref,m){
return iref.meta = m;
});
/**
* Alpha - subject to change.
* 
* Adds a watch function to an atom reference. The watch fn must be a
* fn of 4 args: a key, the reference, its old-state, its
* new-state. Whenever the reference's state might have been changed,
* any registered watches will have their functions called. The watch
* fn will be called synchronously. Note that an atom's state
* may have changed again prior to the fn call, so use old/new-state
* rather than derefing the reference. Keys must be unique per
* reference, and can be used to remove the watch with remove-watch,
* but are otherwise considered opaque by the watch mechanism.  Bear in
* mind that regardless of the result or action of the watch fns the
* atom's value will change.  Example:
* 
* (def a (atom 0))
* (add-watch a :inc (fn [k r o n] (assert (== 0 n))))
* (swap! a inc)
* ;; Assertion Error
* (deref a)
* ;=> 1
*/
cljs.core.add_watch = (function add_watch(iref,key,f){
cljs.core._add_watch(iref,key,f);

return iref;
});
/**
* Alpha - subject to change.
* 
* Removes a watch (set by add-watch) from a reference
*/
cljs.core.remove_watch = (function remove_watch(iref,key){
cljs.core._remove_watch(iref,key);

return iref;
});
cljs.core.gensym_counter = null;
/**
* Returns a new symbol with a unique name. If a prefix string is
* supplied, the name is prefix# where # is some unique number. If
* prefix is not supplied, the prefix is 'G__'.
*/
cljs.core.gensym = (function() {
var gensym = null;
var gensym__0 = (function (){
return gensym.cljs$core$IFn$_invoke$arity$1("G__");
});
var gensym__1 = (function (prefix_string){
if((cljs.core.gensym_counter == null)){
cljs.core.gensym_counter = (function (){var G__11452 = (0);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__11452) : cljs.core.atom.call(null,G__11452));
})();
} else {
}

return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str(prefix_string),cljs.core.str(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.gensym_counter,cljs.core.inc))].join(''));
});
gensym = function(prefix_string){
switch(arguments.length){
case 0:
return gensym__0.call(this);
case 1:
return gensym__1.call(this,prefix_string);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
gensym.cljs$core$IFn$_invoke$arity$0 = gensym__0;
gensym.cljs$core$IFn$_invoke$arity$1 = gensym__1;
return gensym;
})()
;
cljs.core.fixture1 = (1);
cljs.core.fixture2 = (2);

/**
* @constructor
*/
cljs.core.Delay = (function (f,value){
this.f = f;
this.value = value;
this.cljs$lang$protocol_mask$partition1$ = 1;
this.cljs$lang$protocol_mask$partition0$ = 32768;
})
cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (d){
var self__ = this;
var d__$1 = this;
return cljs.core.not(self__.f);
});

cljs.core.Delay.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.f)){
self__.value = (function (){return (self__.f.cljs$core$IFn$_invoke$arity$0 ? self__.f.cljs$core$IFn$_invoke$arity$0() : self__.f.call(null));
})();

self__.f = null;
} else {
}

return self__.value;
});

cljs.core.Delay.cljs$lang$type = true;

cljs.core.Delay.cljs$lang$ctorStr = "cljs.core/Delay";

cljs.core.Delay.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/Delay");
});

cljs.core.__GT_Delay = (function __GT_Delay(f,value){
return (new cljs.core.Delay(f,value));
});

/**
* returns true if x is a Delay created with delay
*/
cljs.core.delay_QMARK_ = (function delay_QMARK_(x){
return (x instanceof cljs.core.Delay);
});
/**
* If x is a Delay, returns the (possibly cached) value of its expression, else returns x
*/
cljs.core.force = (function force(x){
if(cljs.core.delay_QMARK_(x)){
var G__11454 = x;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11454) : cljs.core.deref.call(null,G__11454));
} else {
return x;
}
});
/**
* Returns true if a value has been produced for a promise, delay, future or lazy sequence.
*/
cljs.core.realized_QMARK_ = (function realized_QMARK_(d){
return cljs.core._realized_QMARK_(d);
});
cljs.core.preserving_reduced = (function preserving_reduced(rf){
return (function (p1__11455_SHARP_,p2__11456_SHARP_){
var ret = (function (){var G__11459 = p1__11455_SHARP_;
var G__11460 = p2__11456_SHARP_;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11459,G__11460) : rf.call(null,G__11459,G__11460));
})();
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.reduced(ret);
} else {
return ret;
}
});
});
/**
* A transducer which concatenates the contents of each input, which must be a
* collection, into the reduction.
*/
cljs.core.cat = (function cat(rf){
var rf1 = cljs.core.preserving_reduced(rf);
return ((function (rf1){
return (function() {
var G__11463 = null;
var G__11463__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11463__1 = (function (result){
var G__11462 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11462) : rf.call(null,G__11462));
});
var G__11463__2 = (function (result,input){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(rf1,result,input);
});
G__11463 = function(result,input){
switch(arguments.length){
case 0:
return G__11463__0.call(this);
case 1:
return G__11463__1.call(this,result);
case 2:
return G__11463__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11463.cljs$core$IFn$_invoke$arity$0 = G__11463__0;
G__11463.cljs$core$IFn$_invoke$arity$1 = G__11463__1;
G__11463.cljs$core$IFn$_invoke$arity$2 = G__11463__2;
return G__11463;
})()
;})(rf1))
});
/**
* Returns a lazy sequence removing consecutive duplicates in coll.
* Returns a transducer when no collection is provided.
*/
cljs.core.dedupe = (function() {
var dedupe = null;
var dedupe__0 = (function (){
return (function (rf){
var pa = cljs.core.volatile_BANG_(new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439));
return ((function (pa){
return (function() {
var G__11472 = null;
var G__11472__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11472__1 = (function (result){
var G__11468 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11468) : rf.call(null,G__11468));
});
var G__11472__2 = (function (result,input){
var prior = (function (){var G__11469 = pa;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11469) : cljs.core.deref.call(null,G__11469));
})();
cljs.core.vreset_BANG_(pa,input);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(prior,input)){
return result;
} else {
var G__11470 = result;
var G__11471 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11470,G__11471) : rf.call(null,G__11470,G__11471));
}
});
G__11472 = function(result,input){
switch(arguments.length){
case 0:
return G__11472__0.call(this);
case 1:
return G__11472__1.call(this,result);
case 2:
return G__11472__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11472.cljs$core$IFn$_invoke$arity$0 = G__11472__0;
G__11472.cljs$core$IFn$_invoke$arity$1 = G__11472__1;
G__11472.cljs$core$IFn$_invoke$arity$2 = G__11472__2;
return G__11472;
})()
;})(pa))
});
});
var dedupe__1 = (function (coll){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(dedupe.cljs$core$IFn$_invoke$arity$0(),coll);
});
dedupe = function(coll){
switch(arguments.length){
case 0:
return dedupe__0.call(this);
case 1:
return dedupe__1.call(this,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
dedupe.cljs$core$IFn$_invoke$arity$0 = dedupe__0;
dedupe.cljs$core$IFn$_invoke$arity$1 = dedupe__1;
return dedupe;
})()
;
/**
* Returns items from coll with random probability of prob (0.0 -
* 1.0).  Returns a transducer when no collection is provided.
*/
cljs.core.random_sample = (function() {
var random_sample = null;
var random_sample__1 = (function (prob){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (_){
return ((function (){return (cljs.core.rand.cljs$core$IFn$_invoke$arity$0 ? cljs.core.rand.cljs$core$IFn$_invoke$arity$0() : cljs.core.rand.call(null));
})() < prob);
}));
});
var random_sample__2 = (function (prob,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (_){
return ((function (){return (cljs.core.rand.cljs$core$IFn$_invoke$arity$0 ? cljs.core.rand.cljs$core$IFn$_invoke$arity$0() : cljs.core.rand.call(null));
})() < prob);
}),coll);
});
random_sample = function(prob,coll){
switch(arguments.length){
case 1:
return random_sample__1.call(this,prob);
case 2:
return random_sample__2.call(this,prob,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
random_sample.cljs$core$IFn$_invoke$arity$1 = random_sample__1;
random_sample.cljs$core$IFn$_invoke$arity$2 = random_sample__2;
return random_sample;
})()
;

/**
* @constructor
*/
cljs.core.Eduction = (function (xform,coll){
this.xform = xform;
this.coll = coll;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2173173760;
})
cljs.core.Eduction.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll__$1,writer,opts){
var self__ = this;
var coll__$2 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$2);
});

cljs.core.Eduction.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (_,f,init){
var self__ = this;
var ___$1 = this;
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(self__.xform,f,init,self__.coll);
});

cljs.core.Eduction.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.seq(cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(self__.xform,self__.coll));
});

cljs.core.Eduction.cljs$lang$type = true;

cljs.core.Eduction.cljs$lang$ctorStr = "cljs.core/Eduction";

cljs.core.Eduction.cljs$lang$ctorPrWriter = (function (this__5689__auto__,writer__5690__auto__,opt__5691__auto__){
return cljs.core._write(writer__5690__auto__,"cljs.core/Eduction");
});

cljs.core.__GT_Eduction = (function __GT_Eduction(xform,coll){
return (new cljs.core.Eduction(xform,coll));
});

(cljs.core.Eduction.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__6080__auto__ = this;
return cljs.core.es6_iterator(this__6080__auto__);
}));
/**
* Returns a reducible/iterable/seqable application of
* the transducer to the items in coll. Note that these applications
* will be performed every time iterator/seq/reduce is called.
*/
cljs.core.eduction = (function eduction(xform,coll){
return (new cljs.core.Eduction(xform,coll));
});
/**
* Runs the supplied procedure (via reduce), for purposes of side
* effects, on successive items in the collection. Returns nil
*/
cljs.core.run_BANG_ = (function run_BANG_(proc,coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__11474_SHARP_,p2__11473_SHARP_){
var G__11476 = p2__11473_SHARP_;
return (proc.cljs$core$IFn$_invoke$arity$1 ? proc.cljs$core$IFn$_invoke$arity$1(G__11476) : proc.call(null,G__11476));
}),null,coll);
});

cljs.core.IEncodeJS = (function (){var obj11478 = {};
return obj11478;
})();

cljs.core._clj__GT_js = (function _clj__GT_js(x){
if((function (){var and__5090__auto__ = x;
if(and__5090__auto__){
return x.cljs$core$IEncodeJS$_clj__GT_js$arity$1;
} else {
return and__5090__auto__;
}
})()){
return x.cljs$core$IEncodeJS$_clj__GT_js$arity$1(x);
} else {
var x__5746__auto__ = (((x == null))?null:x);
return (function (){var or__5102__auto__ = (cljs.core._clj__GT_js[(function (){var G__11482 = x__5746__auto__;
return goog.typeOf(G__11482);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._clj__GT_js["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeJS.-clj->js",x);
}
}
})().call(null,x);
}
});

cljs.core._key__GT_js = (function _key__GT_js(x){
if((function (){var and__5090__auto__ = x;
if(and__5090__auto__){
return x.cljs$core$IEncodeJS$_key__GT_js$arity$1;
} else {
return and__5090__auto__;
}
})()){
return x.cljs$core$IEncodeJS$_key__GT_js$arity$1(x);
} else {
var x__5746__auto__ = (((x == null))?null:x);
return (function (){var or__5102__auto__ = (cljs.core._key__GT_js[(function (){var G__11486 = x__5746__auto__;
return goog.typeOf(G__11486);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._key__GT_js["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeJS.-key->js",x);
}
}
})().call(null,x);
}
});

cljs.core.key__GT_js = (function key__GT_js(k){
if((function (){var G__11489 = k;
if(G__11489){
var bit__5783__auto__ = null;
if(cljs.core.truth_((function (){var or__5102__auto__ = bit__5783__auto__;
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
return G__11489.cljs$core$IEncodeJS$;
}
})())){
return true;
} else {
if((!G__11489.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__11489);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__11489);
}
})()){
return cljs.core._clj__GT_js(k);
} else {
if((typeof k === 'string') || (typeof k === 'number') || ((k instanceof cljs.core.Keyword)) || ((k instanceof cljs.core.Symbol))){
var G__11490 = k;
return (cljs.core.clj__GT_js.cljs$core$IFn$_invoke$arity$1 ? cljs.core.clj__GT_js.cljs$core$IFn$_invoke$arity$1(G__11490) : cljs.core.clj__GT_js.call(null,G__11490));
} else {
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([k], 0));
}
}
});
/**
* Recursively transforms ClojureScript values to JavaScript.
* sets/vectors/lists become Arrays, Keywords and Symbol become Strings,
* Maps become Objects. Arbitrary keys are encoded to by key->js.
*/
cljs.core.clj__GT_js = (function clj__GT_js(x){
if((x == null)){
return null;
} else {
if((function (){var G__11506 = x;
if(G__11506){
var bit__5783__auto__ = null;
if(cljs.core.truth_((function (){var or__5102__auto__ = bit__5783__auto__;
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
return G__11506.cljs$core$IEncodeJS$;
}
})())){
return true;
} else {
if((!G__11506.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__11506);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__11506);
}
})()){
return cljs.core._clj__GT_js(x);
} else {
if((x instanceof cljs.core.Keyword)){
return cljs.core.name(x);
} else {
if((x instanceof cljs.core.Symbol)){
return [cljs.core.str(x)].join('');
} else {
if(cljs.core.map_QMARK_(x)){
var m = (function (){var obj11508 = {};
return obj11508;
})();
var seq__11509_11519 = cljs.core.seq(x);
var chunk__11510_11520 = null;
var count__11511_11521 = (0);
var i__11512_11522 = (0);
while(true){
if((i__11512_11522 < count__11511_11521)){
var vec__11513_11523 = chunk__11510_11520.cljs$core$IIndexed$_nth$arity$2(null,i__11512_11522);
var k_11524 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11513_11523,(0),null);
var v_11525 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11513_11523,(1),null);
(m[cljs.core.key__GT_js(k_11524)] = clj__GT_js(v_11525));

var G__11526 = seq__11509_11519;
var G__11527 = chunk__11510_11520;
var G__11528 = count__11511_11521;
var G__11529 = (i__11512_11522 + (1));
seq__11509_11519 = G__11526;
chunk__11510_11520 = G__11527;
count__11511_11521 = G__11528;
i__11512_11522 = G__11529;
continue;
} else {
var temp__4126__auto___11530 = cljs.core.seq(seq__11509_11519);
if(temp__4126__auto___11530){
var seq__11509_11531__$1 = temp__4126__auto___11530;
if(cljs.core.chunked_seq_QMARK_(seq__11509_11531__$1)){
var c__5889__auto___11532 = cljs.core.chunk_first(seq__11509_11531__$1);
var G__11533 = cljs.core.chunk_rest(seq__11509_11531__$1);
var G__11534 = c__5889__auto___11532;
var G__11535 = cljs.core.count(c__5889__auto___11532);
var G__11536 = (0);
seq__11509_11519 = G__11533;
chunk__11510_11520 = G__11534;
count__11511_11521 = G__11535;
i__11512_11522 = G__11536;
continue;
} else {
var vec__11514_11537 = cljs.core.first(seq__11509_11531__$1);
var k_11538 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11514_11537,(0),null);
var v_11539 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11514_11537,(1),null);
(m[cljs.core.key__GT_js(k_11538)] = clj__GT_js(v_11539));

var G__11540 = cljs.core.next(seq__11509_11531__$1);
var G__11541 = null;
var G__11542 = (0);
var G__11543 = (0);
seq__11509_11519 = G__11540;
chunk__11510_11520 = G__11541;
count__11511_11521 = G__11542;
i__11512_11522 = G__11543;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_(x)){
var arr = [];
var seq__11515_11544 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clj__GT_js,x));
var chunk__11516_11545 = null;
var count__11517_11546 = (0);
var i__11518_11547 = (0);
while(true){
if((i__11518_11547 < count__11517_11546)){
var x_11548__$1 = chunk__11516_11545.cljs$core$IIndexed$_nth$arity$2(null,i__11518_11547);
arr.push(x_11548__$1);

var G__11549 = seq__11515_11544;
var G__11550 = chunk__11516_11545;
var G__11551 = count__11517_11546;
var G__11552 = (i__11518_11547 + (1));
seq__11515_11544 = G__11549;
chunk__11516_11545 = G__11550;
count__11517_11546 = G__11551;
i__11518_11547 = G__11552;
continue;
} else {
var temp__4126__auto___11553 = cljs.core.seq(seq__11515_11544);
if(temp__4126__auto___11553){
var seq__11515_11554__$1 = temp__4126__auto___11553;
if(cljs.core.chunked_seq_QMARK_(seq__11515_11554__$1)){
var c__5889__auto___11555 = cljs.core.chunk_first(seq__11515_11554__$1);
var G__11556 = cljs.core.chunk_rest(seq__11515_11554__$1);
var G__11557 = c__5889__auto___11555;
var G__11558 = cljs.core.count(c__5889__auto___11555);
var G__11559 = (0);
seq__11515_11544 = G__11556;
chunk__11516_11545 = G__11557;
count__11517_11546 = G__11558;
i__11518_11547 = G__11559;
continue;
} else {
var x_11560__$1 = cljs.core.first(seq__11515_11554__$1);
arr.push(x_11560__$1);

var G__11561 = cljs.core.next(seq__11515_11554__$1);
var G__11562 = null;
var G__11563 = (0);
var G__11564 = (0);
seq__11515_11544 = G__11561;
chunk__11516_11545 = G__11562;
count__11517_11546 = G__11563;
i__11518_11547 = G__11564;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return x;

}
}
}
}
}
}
});

cljs.core.IEncodeClojure = (function (){var obj11566 = {};
return obj11566;
})();

cljs.core._js__GT_clj = (function _js__GT_clj(x,options){
if((function (){var and__5090__auto__ = x;
if(and__5090__auto__){
return x.cljs$core$IEncodeClojure$_js__GT_clj$arity$2;
} else {
return and__5090__auto__;
}
})()){
return x.cljs$core$IEncodeClojure$_js__GT_clj$arity$2(x,options);
} else {
var x__5746__auto__ = (((x == null))?null:x);
return (function (){var or__5102__auto__ = (cljs.core._js__GT_clj[(function (){var G__11570 = x__5746__auto__;
return goog.typeOf(G__11570);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._js__GT_clj["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeClojure.-js->clj",x);
}
}
})().call(null,x,options);
}
});

/**
* Recursively transforms JavaScript arrays into ClojureScript
* vectors, and JavaScript objects into ClojureScript maps.  With
* option ':keywordize-keys true' will convert object fields from
* strings to keywords.
* @param {...*} var_args
*/
cljs.core.js__GT_clj = (function() {
var js__GT_clj = null;
var js__GT_clj__1 = (function (x){
return js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),false], null)], 0));
});
var js__GT_clj__2 = (function() { 
var G__11627__delegate = function (x,opts){
var map__11600 = opts;
var map__11600__$1 = ((cljs.core.seq_QMARK_(map__11600))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11600):map__11600);
var keywordize_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11600__$1,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252));
var keyfn = (cljs.core.truth_(keywordize_keys)?cljs.core.keyword:cljs.core.str);
var f = ((function (map__11600,map__11600__$1,keywordize_keys,keyfn){
return (function thisfn(x__$1){
if((function (){var G__11616 = x__$1;
if(G__11616){
var bit__5783__auto__ = null;
if(cljs.core.truth_((function (){var or__5102__auto__ = bit__5783__auto__;
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
return G__11616.cljs$core$IEncodeClojure$;
}
})())){
return true;
} else {
if((!G__11616.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeClojure,G__11616);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeClojure,G__11616);
}
})()){
return cljs.core._js__GT_clj(x__$1,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.array_map,opts));
} else {
if(cljs.core.seq_QMARK_(x__$1)){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(thisfn,x__$1));
} else {
if(cljs.core.coll_QMARK_(x__$1)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.empty(x__$1),cljs.core.map.cljs$core$IFn$_invoke$arity$2(thisfn,x__$1));
} else {
if(Array.isArray(x__$1)){
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(thisfn,x__$1));
} else {
if((cljs.core.type(x__$1) === Object)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5858__auto__ = ((function (map__11600,map__11600__$1,keywordize_keys,keyfn){
return (function iter__11617(s__11618){
return (new cljs.core.LazySeq(null,((function (map__11600,map__11600__$1,keywordize_keys,keyfn){
return (function (){
var s__11618__$1 = s__11618;
while(true){
var temp__4126__auto__ = cljs.core.seq(s__11618__$1);
if(temp__4126__auto__){
var s__11618__$2 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s__11618__$2)){
var c__5856__auto__ = cljs.core.chunk_first(s__11618__$2);
var size__5857__auto__ = cljs.core.count(c__5856__auto__);
var b__11620 = cljs.core.chunk_buffer(size__5857__auto__);
if((function (){var i__11619 = (0);
while(true){
if((i__11619 < size__5857__auto__)){
var k = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5856__auto__,i__11619);
cljs.core.chunk_append(b__11620,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__11625 = k;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__11625) : keyfn.call(null,G__11625));
})(),thisfn((x__$1[k]))], null));

var G__11628 = (i__11619 + (1));
i__11619 = G__11628;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__11620),iter__11617(cljs.core.chunk_rest(s__11618__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__11620),null);
}
} else {
var k = cljs.core.first(s__11618__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__11626 = k;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__11626) : keyfn.call(null,G__11626));
})(),thisfn((x__$1[k]))], null),iter__11617(cljs.core.rest(s__11618__$2)));
}
} else {
return null;
}
break;
}
});})(map__11600,map__11600__$1,keywordize_keys,keyfn))
,null,null));
});})(map__11600,map__11600__$1,keywordize_keys,keyfn))
;
return iter__5858__auto__(cljs.core.js_keys(x__$1));
})());
} else {
return x__$1;

}
}
}
}
}
});})(map__11600,map__11600__$1,keywordize_keys,keyfn))
;
return f(x);
};
var G__11627 = function (x,var_args){
var opts = null;
if (arguments.length > 1) {
var G__11629__i = 0, G__11629__a = new Array(arguments.length -  1);
while (G__11629__i < G__11629__a.length) {G__11629__a[G__11629__i] = arguments[G__11629__i + 1]; ++G__11629__i;}
  opts = new cljs.core.IndexedSeq(G__11629__a,0);
} 
return G__11627__delegate.call(this,x,opts);};
G__11627.cljs$lang$maxFixedArity = 1;
G__11627.cljs$lang$applyTo = (function (arglist__11630){
var x = cljs.core.first(arglist__11630);
var opts = cljs.core.rest(arglist__11630);
return G__11627__delegate(x,opts);
});
G__11627.cljs$core$IFn$_invoke$arity$variadic = G__11627__delegate;
return G__11627;
})()
;
js__GT_clj = function(x,var_args){
var opts = var_args;
switch(arguments.length){
case 1:
return js__GT_clj__1.call(this,x);
default:
var G__11631 = null;
if (arguments.length > 1) {
var G__11632__i = 0, G__11632__a = new Array(arguments.length -  1);
while (G__11632__i < G__11632__a.length) {G__11632__a[G__11632__i] = arguments[G__11632__i + 1]; ++G__11632__i;}
G__11631 = new cljs.core.IndexedSeq(G__11632__a,0);
}
return js__GT_clj__2.cljs$core$IFn$_invoke$arity$variadic(x, G__11631);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
js__GT_clj.cljs$lang$maxFixedArity = 1;
js__GT_clj.cljs$lang$applyTo = js__GT_clj__2.cljs$lang$applyTo;
js__GT_clj.cljs$core$IFn$_invoke$arity$1 = js__GT_clj__1;
js__GT_clj.cljs$core$IFn$_invoke$arity$variadic = js__GT_clj__2.cljs$core$IFn$_invoke$arity$variadic;
return js__GT_clj;
})()
;
/**
* Returns a memoized version of a referentially transparent function. The
* memoized version of the function keeps a cache of the mapping from arguments
* to results and, when calls with the same arguments are repeated often, has
* higher performance at the expense of higher memory use.
*/
cljs.core.memoize = (function memoize(f){
var mem = (function (){var G__11635 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__11635) : cljs.core.atom.call(null,G__11635));
})();
return ((function (mem){
return (function() { 
var G__11637__delegate = function (args){
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$3((function (){var G__11636 = mem;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11636) : cljs.core.deref.call(null,G__11636));
})(),args,cljs.core.lookup_sentinel);
if((v === cljs.core.lookup_sentinel)){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(mem,cljs.core.assoc,args,ret);

return ret;
} else {
return v;
}
};
var G__11637 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__11638__i = 0, G__11638__a = new Array(arguments.length -  0);
while (G__11638__i < G__11638__a.length) {G__11638__a[G__11638__i] = arguments[G__11638__i + 0]; ++G__11638__i;}
  args = new cljs.core.IndexedSeq(G__11638__a,0);
} 
return G__11637__delegate.call(this,args);};
G__11637.cljs$lang$maxFixedArity = 0;
G__11637.cljs$lang$applyTo = (function (arglist__11639){
var args = cljs.core.seq(arglist__11639);
return G__11637__delegate(args);
});
G__11637.cljs$core$IFn$_invoke$arity$variadic = G__11637__delegate;
return G__11637;
})()
;
;})(mem))
});
/**
* trampoline can be used to convert algorithms requiring mutual
* recursion without stack consumption. Calls f with supplied args, if
* any. If f returns a fn, calls that fn with no arguments, and
* continues to repeat, until the return value is not a fn, then
* returns that non-fn value. Note that if you want to return a fn as a
* final value, you must wrap it in some data structure and unpack it
* after trampoline returns.
* @param {...*} var_args
*/
cljs.core.trampoline = (function() {
var trampoline = null;
var trampoline__1 = (function (f){
while(true){
var ret = (function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})();
if(cljs.core.fn_QMARK_(ret)){
var G__11641 = ret;
f = G__11641;
continue;
} else {
return ret;
}
break;
}
});
var trampoline__2 = (function() { 
var G__11642__delegate = function (f,args){
return trampoline.cljs$core$IFn$_invoke$arity$1((function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
}));
};
var G__11642 = function (f,var_args){
var args = null;
if (arguments.length > 1) {
var G__11643__i = 0, G__11643__a = new Array(arguments.length -  1);
while (G__11643__i < G__11643__a.length) {G__11643__a[G__11643__i] = arguments[G__11643__i + 1]; ++G__11643__i;}
  args = new cljs.core.IndexedSeq(G__11643__a,0);
} 
return G__11642__delegate.call(this,f,args);};
G__11642.cljs$lang$maxFixedArity = 1;
G__11642.cljs$lang$applyTo = (function (arglist__11644){
var f = cljs.core.first(arglist__11644);
var args = cljs.core.rest(arglist__11644);
return G__11642__delegate(f,args);
});
G__11642.cljs$core$IFn$_invoke$arity$variadic = G__11642__delegate;
return G__11642;
})()
;
trampoline = function(f,var_args){
var args = var_args;
switch(arguments.length){
case 1:
return trampoline__1.call(this,f);
default:
var G__11645 = null;
if (arguments.length > 1) {
var G__11646__i = 0, G__11646__a = new Array(arguments.length -  1);
while (G__11646__i < G__11646__a.length) {G__11646__a[G__11646__i] = arguments[G__11646__i + 1]; ++G__11646__i;}
G__11645 = new cljs.core.IndexedSeq(G__11646__a,0);
}
return trampoline__2.cljs$core$IFn$_invoke$arity$variadic(f, G__11645);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
trampoline.cljs$lang$maxFixedArity = 1;
trampoline.cljs$lang$applyTo = trampoline__2.cljs$lang$applyTo;
trampoline.cljs$core$IFn$_invoke$arity$1 = trampoline__1;
trampoline.cljs$core$IFn$_invoke$arity$variadic = trampoline__2.cljs$core$IFn$_invoke$arity$variadic;
return trampoline;
})()
;
/**
* Returns a random floating point number between 0 (inclusive) and
* n (default 1) (exclusive).
*/
cljs.core.rand = (function() {
var rand = null;
var rand__0 = (function (){
return rand.cljs$core$IFn$_invoke$arity$1((1));
});
var rand__1 = (function (n){
return ((function (){return (Math.random.cljs$core$IFn$_invoke$arity$0 ? Math.random.cljs$core$IFn$_invoke$arity$0() : Math.random.call(null));
})() * n);
});
rand = function(n){
switch(arguments.length){
case 0:
return rand__0.call(this);
case 1:
return rand__1.call(this,n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
rand.cljs$core$IFn$_invoke$arity$0 = rand__0;
rand.cljs$core$IFn$_invoke$arity$1 = rand__1;
return rand;
})()
;
/**
* Returns a random integer between 0 (inclusive) and n (exclusive).
*/
cljs.core.rand_int = (function rand_int(n){
var G__11649 = ((function (){return (Math.random.cljs$core$IFn$_invoke$arity$0 ? Math.random.cljs$core$IFn$_invoke$arity$0() : Math.random.call(null));
})() * n);
return (Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__11649) : Math.floor.call(null,G__11649));
});
/**
* Return a random element of the (sequential) collection. Will have
* the same performance characteristics as nth for the given
* collection.
*/
cljs.core.rand_nth = (function rand_nth(coll){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,cljs.core.rand_int(cljs.core.count(coll)));
});
/**
* Returns a map of the elements of coll keyed by the result of
* f on each element. The value at each key will be a vector of the
* corresponding elements, in the order they appeared in coll.
*/
cljs.core.group_by = (function group_by(f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret,x){
var k = (function (){var G__11651 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11651) : f.call(null,G__11651));
})();
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.PersistentVector.EMPTY),x));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
* Creates a hierarchy object for use with derive, isa? etc.
*/
cljs.core.make_hierarchy = (function make_hierarchy(){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"parents","parents",-2027538891),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"descendants","descendants",1824886031),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ancestors","ancestors",-776045424),cljs.core.PersistentArrayMap.EMPTY], null);
});
cljs.core._global_hierarchy = null;
cljs.core.get_global_hierarchy = (function get_global_hierarchy(){
if((cljs.core._global_hierarchy == null)){
cljs.core._global_hierarchy = (function (){var G__11653 = cljs.core.make_hierarchy();
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__11653) : cljs.core.atom.call(null,G__11653));
})();
} else {
}

return cljs.core._global_hierarchy;
});
/**
* @param {...*} var_args
*/
cljs.core.swap_global_hierarchy_BANG_ = (function() { 
var swap_global_hierarchy_BANG___delegate = function (f,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.swap_BANG_,cljs.core.get_global_hierarchy(),f,args);
};
var swap_global_hierarchy_BANG_ = function (f,var_args){
var args = null;
if (arguments.length > 1) {
var G__11654__i = 0, G__11654__a = new Array(arguments.length -  1);
while (G__11654__i < G__11654__a.length) {G__11654__a[G__11654__i] = arguments[G__11654__i + 1]; ++G__11654__i;}
  args = new cljs.core.IndexedSeq(G__11654__a,0);
} 
return swap_global_hierarchy_BANG___delegate.call(this,f,args);};
swap_global_hierarchy_BANG_.cljs$lang$maxFixedArity = 1;
swap_global_hierarchy_BANG_.cljs$lang$applyTo = (function (arglist__11655){
var f = cljs.core.first(arglist__11655);
var args = cljs.core.rest(arglist__11655);
return swap_global_hierarchy_BANG___delegate(f,args);
});
swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic = swap_global_hierarchy_BANG___delegate;
return swap_global_hierarchy_BANG_;
})()
;
/**
* Returns true if (= child parent), or child is directly or indirectly derived from
* parent, either via a JavaScript type inheritance relationship or a
* relationship established via derive. h must be a hierarchy obtained
* from make-hierarchy, if not supplied defaults to the global
* hierarchy
*/
cljs.core.isa_QMARK_ = (function() {
var isa_QMARK_ = null;
var isa_QMARK___2 = (function (child,parent){
return isa_QMARK_.cljs$core$IFn$_invoke$arity$3((function (){var G__11720 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11720) : cljs.core.deref.call(null,G__11720));
})(),child,parent);
});
var isa_QMARK___3 = (function (h,child,parent){
var or__5102__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(child,parent);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h).call(null,child),parent);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
var and__5090__auto__ = cljs.core.vector_QMARK_(parent);
if(and__5090__auto__){
var and__5090__auto____$1 = cljs.core.vector_QMARK_(child);
if(and__5090__auto____$1){
var and__5090__auto____$2 = (cljs.core.count(parent) === cljs.core.count(child));
if(and__5090__auto____$2){
var ret = true;
var i = (0);
while(true){
if((!(ret)) || ((i === cljs.core.count(parent)))){
return ret;
} else {
var G__11745 = isa_QMARK_.cljs$core$IFn$_invoke$arity$3(h,(function (){var G__11743 = i;
return (child.cljs$core$IFn$_invoke$arity$1 ? child.cljs$core$IFn$_invoke$arity$1(G__11743) : child.call(null,G__11743));
})(),(function (){var G__11744 = i;
return (parent.cljs$core$IFn$_invoke$arity$1 ? parent.cljs$core$IFn$_invoke$arity$1(G__11744) : parent.call(null,G__11744));
})());
var G__11746 = (i + (1));
ret = G__11745;
i = G__11746;
continue;
}
break;
}
} else {
return and__5090__auto____$2;
}
} else {
return and__5090__auto____$1;
}
} else {
return and__5090__auto__;
}
}
}
});
isa_QMARK_ = function(h,child,parent){
switch(arguments.length){
case 2:
return isa_QMARK___2.call(this,h,child);
case 3:
return isa_QMARK___3.call(this,h,child,parent);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
isa_QMARK_.cljs$core$IFn$_invoke$arity$2 = isa_QMARK___2;
isa_QMARK_.cljs$core$IFn$_invoke$arity$3 = isa_QMARK___3;
return isa_QMARK_;
})()
;
/**
* Returns the immediate parents of tag, either via a JavaScript type
* inheritance relationship or a relationship established via derive. h
* must be a hierarchy obtained from make-hierarchy, if not supplied
* defaults to the global hierarchy
*/
cljs.core.parents = (function() {
var parents = null;
var parents__1 = (function (tag){
return parents.cljs$core$IFn$_invoke$arity$2((function (){var G__11750 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11750) : cljs.core.deref.call(null,G__11750));
})(),tag);
});
var parents__2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h),tag));
});
parents = function(h,tag){
switch(arguments.length){
case 1:
return parents__1.call(this,h);
case 2:
return parents__2.call(this,h,tag);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
parents.cljs$core$IFn$_invoke$arity$1 = parents__1;
parents.cljs$core$IFn$_invoke$arity$2 = parents__2;
return parents;
})()
;
/**
* Returns the immediate and indirect parents of tag, either via a JavaScript type
* inheritance relationship or a relationship established via derive. h
* must be a hierarchy obtained from make-hierarchy, if not supplied
* defaults to the global hierarchy
*/
cljs.core.ancestors = (function() {
var ancestors = null;
var ancestors__1 = (function (tag){
return ancestors.cljs$core$IFn$_invoke$arity$2((function (){var G__11754 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11754) : cljs.core.deref.call(null,G__11754));
})(),tag);
});
var ancestors__2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h),tag));
});
ancestors = function(h,tag){
switch(arguments.length){
case 1:
return ancestors__1.call(this,h);
case 2:
return ancestors__2.call(this,h,tag);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
ancestors.cljs$core$IFn$_invoke$arity$1 = ancestors__1;
ancestors.cljs$core$IFn$_invoke$arity$2 = ancestors__2;
return ancestors;
})()
;
/**
* Returns the immediate and indirect children of tag, through a
* relationship established via derive. h must be a hierarchy obtained
* from make-hierarchy, if not supplied defaults to the global
* hierarchy. Note: does not work on JavaScript type inheritance
* relationships.
*/
cljs.core.descendants = (function() {
var descendants = null;
var descendants__1 = (function (tag){
return descendants.cljs$core$IFn$_invoke$arity$2((function (){var G__11758 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11758) : cljs.core.deref.call(null,G__11758));
})(),tag);
});
var descendants__2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"descendants","descendants",1824886031).cljs$core$IFn$_invoke$arity$1(h),tag));
});
descendants = function(h,tag){
switch(arguments.length){
case 1:
return descendants__1.call(this,h);
case 2:
return descendants__2.call(this,h,tag);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
descendants.cljs$core$IFn$_invoke$arity$1 = descendants__1;
descendants.cljs$core$IFn$_invoke$arity$2 = descendants__2;
return descendants;
})()
;
/**
* Establishes a parent/child relationship between parent and
* tag. Parent must be a namespace-qualified symbol or keyword and
* child can be either a namespace-qualified symbol or keyword or a
* class. h must be a hierarchy obtained from make-hierarchy, if not
* supplied defaults to, and modifies, the global hierarchy.
*/
cljs.core.derive = (function() {
var derive = null;
var derive__2 = (function (tag,parent){
if(cljs.core.truth_(cljs.core.namespace(parent))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"namespace","namespace",1263021155,null),new cljs.core.Symbol(null,"parent","parent",761652748,null))], 0)))].join('')));
}

cljs.core.swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic(derive,cljs.core.array_seq([tag,parent], 0));

return null;
});
var derive__3 = (function (h,tag,parent){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(tag,parent)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.Symbol(null,"tag","tag",350170304,null),new cljs.core.Symbol(null,"parent","parent",761652748,null))], 0)))].join('')));
}

var tp = new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h);
var td = new cljs.core.Keyword(null,"descendants","descendants",1824886031).cljs$core$IFn$_invoke$arity$1(h);
var ta = new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h);
var tf = ((function (tp,td,ta){
return (function (m,source,sources,target,targets){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (tp,td,ta){
return (function (ret,k){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.get.cljs$core$IFn$_invoke$arity$3(targets,k,cljs.core.PersistentHashSet.EMPTY),cljs.core.cons(target,(function (){var G__11767 = target;
return (targets.cljs$core$IFn$_invoke$arity$1 ? targets.cljs$core$IFn$_invoke$arity$1(G__11767) : targets.call(null,G__11767));
})())));
});})(tp,td,ta))
,m,cljs.core.cons(source,(function (){var G__11768 = source;
return (sources.cljs$core$IFn$_invoke$arity$1 ? sources.cljs$core$IFn$_invoke$arity$1(G__11768) : sources.call(null,G__11768));
})()));
});})(tp,td,ta))
;
var or__5102__auto__ = ((cljs.core.contains_QMARK_((function (){var G__11772 = tag;
return (tp.cljs$core$IFn$_invoke$arity$1 ? tp.cljs$core$IFn$_invoke$arity$1(G__11772) : tp.call(null,G__11772));
})(),parent))?null:(function (){
if(cljs.core.contains_QMARK_((function (){var G__11773 = tag;
return (ta.cljs$core$IFn$_invoke$arity$1 ? ta.cljs$core$IFn$_invoke$arity$1(G__11773) : ta.call(null,G__11773));
})(),parent)){
throw (new Error([cljs.core.str(tag),cljs.core.str("already has"),cljs.core.str(parent),cljs.core.str("as ancestor")].join('')));
} else {
}

if(cljs.core.contains_QMARK_((function (){var G__11774 = parent;
return (ta.cljs$core$IFn$_invoke$arity$1 ? ta.cljs$core$IFn$_invoke$arity$1(G__11774) : ta.call(null,G__11774));
})(),tag)){
throw (new Error([cljs.core.str("Cyclic derivation:"),cljs.core.str(parent),cljs.core.str("has"),cljs.core.str(tag),cljs.core.str("as ancestor")].join('')));
} else {
}

return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"parents","parents",-2027538891),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h),tag,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(tp,tag,cljs.core.PersistentHashSet.EMPTY),parent)),new cljs.core.Keyword(null,"ancestors","ancestors",-776045424),tf(new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h),tag,td,parent,ta),new cljs.core.Keyword(null,"descendants","descendants",1824886031),tf(new cljs.core.Keyword(null,"descendants","descendants",1824886031).cljs$core$IFn$_invoke$arity$1(h),parent,ta,tag,td)], null);
})()
);
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
return h;
}
});
derive = function(h,tag,parent){
switch(arguments.length){
case 2:
return derive__2.call(this,h,tag);
case 3:
return derive__3.call(this,h,tag,parent);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
derive.cljs$core$IFn$_invoke$arity$2 = derive__2;
derive.cljs$core$IFn$_invoke$arity$3 = derive__3;
return derive;
})()
;
/**
* Removes a parent/child relationship between parent and
* tag. h must be a hierarchy obtained from make-hierarchy, if not
* supplied defaults to, and modifies, the global hierarchy.
*/
cljs.core.underive = (function() {
var underive = null;
var underive__2 = (function (tag,parent){
cljs.core.swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic(underive,cljs.core.array_seq([tag,parent], 0));

return null;
});
var underive__3 = (function (h,tag,parent){
var parentMap = new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h);
var childsParents = (cljs.core.truth_((function (){var G__11781 = tag;
return (parentMap.cljs$core$IFn$_invoke$arity$1 ? parentMap.cljs$core$IFn$_invoke$arity$1(G__11781) : parentMap.call(null,G__11781));
})())?cljs.core.disj.cljs$core$IFn$_invoke$arity$2((function (){var G__11782 = tag;
return (parentMap.cljs$core$IFn$_invoke$arity$1 ? parentMap.cljs$core$IFn$_invoke$arity$1(G__11782) : parentMap.call(null,G__11782));
})(),parent):cljs.core.PersistentHashSet.EMPTY);
var newParents = (cljs.core.truth_(cljs.core.not_empty(childsParents))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(parentMap,tag,childsParents):cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(parentMap,tag));
var deriv_seq = cljs.core.flatten(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (parentMap,childsParents,newParents){
return (function (p1__11775_SHARP_){
return cljs.core.cons(cljs.core.first(p1__11775_SHARP_),cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(cljs.core.first(p1__11775_SHARP_),cljs.core.second(p1__11775_SHARP_)));
});})(parentMap,childsParents,newParents))
,cljs.core.seq(newParents)));
if(cljs.core.contains_QMARK_((function (){var G__11783 = tag;
return (parentMap.cljs$core$IFn$_invoke$arity$1 ? parentMap.cljs$core$IFn$_invoke$arity$1(G__11783) : parentMap.call(null,G__11783));
})(),parent)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (parentMap,childsParents,newParents,deriv_seq){
return (function (p1__11776_SHARP_,p2__11777_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.derive,p1__11776_SHARP_,p2__11777_SHARP_);
});})(parentMap,childsParents,newParents,deriv_seq))
,cljs.core.make_hierarchy(),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),deriv_seq));
} else {
return h;
}
});
underive = function(h,tag,parent){
switch(arguments.length){
case 2:
return underive__2.call(this,h,tag);
case 3:
return underive__3.call(this,h,tag,parent);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
underive.cljs$core$IFn$_invoke$arity$2 = underive__2;
underive.cljs$core$IFn$_invoke$arity$3 = underive__3;
return underive;
})()
;
cljs.core.reset_cache = (function reset_cache(method_cache,method_table,cached_hierarchy,hierarchy){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(method_cache,(function (_){
var G__11786 = method_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11786) : cljs.core.deref.call(null,G__11786));
}));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cached_hierarchy,(function (_){
var G__11787 = hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11787) : cljs.core.deref.call(null,G__11787));
}));
});
cljs.core.prefers_STAR_ = (function prefers_STAR_(x,y,prefer_table){
var xprefs = (function (){var G__11803 = prefer_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11803) : cljs.core.deref.call(null,G__11803));
})().call(null,x);
var or__5102__auto__ = (cljs.core.truth_((function (){var and__5090__auto__ = xprefs;
if(cljs.core.truth_(and__5090__auto__)){
var G__11805 = y;
return (xprefs.cljs$core$IFn$_invoke$arity$1 ? xprefs.cljs$core$IFn$_invoke$arity$1(G__11805) : xprefs.call(null,G__11805));
} else {
return and__5090__auto__;
}
})())?true:null);
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (function (){var ps = cljs.core.parents.cljs$core$IFn$_invoke$arity$1(y);
while(true){
if((cljs.core.count(ps) > (0))){
if(cljs.core.truth_(prefers_STAR_(x,cljs.core.first(ps),prefer_table))){
} else {
}

var G__11806 = cljs.core.rest(ps);
ps = G__11806;
continue;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(or__5102__auto____$1)){
return or__5102__auto____$1;
} else {
var or__5102__auto____$2 = (function (){var ps = cljs.core.parents.cljs$core$IFn$_invoke$arity$1(x);
while(true){
if((cljs.core.count(ps) > (0))){
if(cljs.core.truth_(prefers_STAR_(cljs.core.first(ps),y,prefer_table))){
} else {
}

var G__11807 = cljs.core.rest(ps);
ps = G__11807;
continue;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(or__5102__auto____$2)){
return or__5102__auto____$2;
} else {
return false;
}
}
}
});
cljs.core.dominates = (function dominates(x,y,prefer_table){
var or__5102__auto__ = cljs.core.prefers_STAR_(x,y,prefer_table);
if(cljs.core.truth_(or__5102__auto__)){
return or__5102__auto__;
} else {
return cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$2(x,y);
}
});
cljs.core.find_and_cache_best_method = (function find_and_cache_best_method(name,dispatch_val,hierarchy,method_table,prefer_table,method_cache,cached_hierarchy){
var best_entry = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (be,p__11821){
var vec__11822 = p__11821;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11822,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11822,(1),null);
var e = vec__11822;
if(cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$3((function (){var G__11823 = hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11823) : cljs.core.deref.call(null,G__11823));
})(),dispatch_val,k)){
var be2 = (cljs.core.truth_((function (){var or__5102__auto__ = (be == null);
if(or__5102__auto__){
return or__5102__auto__;
} else {
return cljs.core.dominates(k,cljs.core.first(be),prefer_table);
}
})())?e:be);
if(cljs.core.truth_(cljs.core.dominates(cljs.core.first(be2),k,prefer_table))){
} else {
throw (new Error([cljs.core.str("Multiple methods in multimethod '"),cljs.core.str(name),cljs.core.str("' match dispatch value: "),cljs.core.str(dispatch_val),cljs.core.str(" -> "),cljs.core.str(k),cljs.core.str(" and "),cljs.core.str(cljs.core.first(be2)),cljs.core.str(", and neither is preferred")].join('')));
}

return be2;
} else {
return be;
}
}),null,(function (){var G__11824 = method_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11824) : cljs.core.deref.call(null,G__11824));
})());
if(cljs.core.truth_(best_entry)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((function (){var G__11825 = cached_hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11825) : cljs.core.deref.call(null,G__11825));
})(),(function (){var G__11826 = hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11826) : cljs.core.deref.call(null,G__11826));
})())){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(method_cache,cljs.core.assoc,dispatch_val,cljs.core.second(best_entry));

return cljs.core.second(best_entry);
} else {
cljs.core.reset_cache(method_cache,method_table,cached_hierarchy,hierarchy);

return find_and_cache_best_method(name,dispatch_val,hierarchy,method_table,prefer_table,method_cache,cached_hierarchy);
}
} else {
return null;
}
});

cljs.core.IMultiFn = (function (){var obj11828 = {};
return obj11828;
})();

cljs.core._reset = (function _reset(mf){
if((function (){var and__5090__auto__ = mf;
if(and__5090__auto__){
return mf.cljs$core$IMultiFn$_reset$arity$1;
} else {
return and__5090__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_reset$arity$1(mf);
} else {
var x__5746__auto__ = (((mf == null))?null:mf);
return (function (){var or__5102__auto__ = (cljs.core._reset[(function (){var G__11832 = x__5746__auto__;
return goog.typeOf(G__11832);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._reset["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-reset",mf);
}
}
})().call(null,mf);
}
});

cljs.core._add_method = (function _add_method(mf,dispatch_val,method){
if((function (){var and__5090__auto__ = mf;
if(and__5090__auto__){
return mf.cljs$core$IMultiFn$_add_method$arity$3;
} else {
return and__5090__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_add_method$arity$3(mf,dispatch_val,method);
} else {
var x__5746__auto__ = (((mf == null))?null:mf);
return (function (){var or__5102__auto__ = (cljs.core._add_method[(function (){var G__11836 = x__5746__auto__;
return goog.typeOf(G__11836);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._add_method["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-add-method",mf);
}
}
})().call(null,mf,dispatch_val,method);
}
});

cljs.core._remove_method = (function _remove_method(mf,dispatch_val){
if((function (){var and__5090__auto__ = mf;
if(and__5090__auto__){
return mf.cljs$core$IMultiFn$_remove_method$arity$2;
} else {
return and__5090__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_remove_method$arity$2(mf,dispatch_val);
} else {
var x__5746__auto__ = (((mf == null))?null:mf);
return (function (){var or__5102__auto__ = (cljs.core._remove_method[(function (){var G__11840 = x__5746__auto__;
return goog.typeOf(G__11840);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._remove_method["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-remove-method",mf);
}
}
})().call(null,mf,dispatch_val);
}
});

cljs.core._prefer_method = (function _prefer_method(mf,dispatch_val,dispatch_val_y){
if((function (){var and__5090__auto__ = mf;
if(and__5090__auto__){
return mf.cljs$core$IMultiFn$_prefer_method$arity$3;
} else {
return and__5090__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_prefer_method$arity$3(mf,dispatch_val,dispatch_val_y);
} else {
var x__5746__auto__ = (((mf == null))?null:mf);
return (function (){var or__5102__auto__ = (cljs.core._prefer_method[(function (){var G__11844 = x__5746__auto__;
return goog.typeOf(G__11844);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._prefer_method["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-prefer-method",mf);
}
}
})().call(null,mf,dispatch_val,dispatch_val_y);
}
});

cljs.core._get_method = (function _get_method(mf,dispatch_val){
if((function (){var and__5090__auto__ = mf;
if(and__5090__auto__){
return mf.cljs$core$IMultiFn$_get_method$arity$2;
} else {
return and__5090__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_get_method$arity$2(mf,dispatch_val);
} else {
var x__5746__auto__ = (((mf == null))?null:mf);
return (function (){var or__5102__auto__ = (cljs.core._get_method[(function (){var G__11848 = x__5746__auto__;
return goog.typeOf(G__11848);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._get_method["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-get-method",mf);
}
}
})().call(null,mf,dispatch_val);
}
});

cljs.core._methods = (function _methods(mf){
if((function (){var and__5090__auto__ = mf;
if(and__5090__auto__){
return mf.cljs$core$IMultiFn$_methods$arity$1;
} else {
return and__5090__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_methods$arity$1(mf);
} else {
var x__5746__auto__ = (((mf == null))?null:mf);
return (function (){var or__5102__auto__ = (cljs.core._methods[(function (){var G__11852 = x__5746__auto__;
return goog.typeOf(G__11852);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._methods["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-methods",mf);
}
}
})().call(null,mf);
}
});

cljs.core._prefers = (function _prefers(mf){
if((function (){var and__5090__auto__ = mf;
if(and__5090__auto__){
return mf.cljs$core$IMultiFn$_prefers$arity$1;
} else {
return and__5090__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_prefers$arity$1(mf);
} else {
var x__5746__auto__ = (((mf == null))?null:mf);
return (function (){var or__5102__auto__ = (cljs.core._prefers[(function (){var G__11856 = x__5746__auto__;
return goog.typeOf(G__11856);
})()]);
if(or__5102__auto__){
return or__5102__auto__;
} else {
var or__5102__auto____$1 = (cljs.core._prefers["_"]);
if(or__5102__auto____$1){
return or__5102__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-prefers",mf);
}
}
})().call(null,mf);
}
});

cljs.core.throw_no_method_error = (function throw_no_method_error(name,dispatch_val){
throw (new Error([cljs.core.str("No method in multimethod '"),cljs.core.str(name),cljs.core.str("' for dispatch value: "),cljs.core.str(dispatch_val)].join('')));
});

/**
* @constructor
*/
cljs.core.MultiFn = (function (name,dispatch_fn,default_dispatch_val,hierarchy,method_table,prefer_table,method_cache,cached_hierarchy){
this.name = name;
this.dispatch_fn = dispatch_fn;
this.default_dispatch_val = default_dispatch_val;
this.hierarchy = hierarchy;
this.method_table = method_table;
this.prefer_table = prefer_table;
this.method_cache = method_cache;
this.cached_hierarchy = cached_hierarchy;
this.cljs$lang$protocol_mask$partition0$ = 4194305;
this.cljs$lang$protocol_mask$partition1$ = 4352;
})
cljs.core.MultiFn.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var G__11858 = this$__$1;
return goog.getUid(G__11858);
});

cljs.core.MultiFn.prototype.cljs$core$INamed$_name$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._name(self__.name);
});

cljs.core.MultiFn.prototype.cljs$core$INamed$_namespace$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._namespace(self__.name);
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_reset$arity$1 = (function (mf){
var self__ = this;
var mf__$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__.method_table,((function (mf__$1){
return (function (mf__$2){
return cljs.core.PersistentArrayMap.EMPTY;
});})(mf__$1))
);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__.method_cache,((function (mf__$1){
return (function (mf__$2){
return cljs.core.PersistentArrayMap.EMPTY;
});})(mf__$1))
);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__.prefer_table,((function (mf__$1){
return (function (mf__$2){
return cljs.core.PersistentArrayMap.EMPTY;
});})(mf__$1))
);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__.cached_hierarchy,((function (mf__$1){
return (function (mf__$2){
return null;
});})(mf__$1))
);

return mf__$1;
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_add_method$arity$3 = (function (mf,dispatch_val,method){
var self__ = this;
var mf__$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.method_table,cljs.core.assoc,dispatch_val,method);

cljs.core.reset_cache(self__.method_cache,self__.method_table,self__.cached_hierarchy,self__.hierarchy);

return mf__$1;
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_remove_method$arity$2 = (function (mf,dispatch_val){
var self__ = this;
var mf__$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.method_table,cljs.core.dissoc,dispatch_val);

cljs.core.reset_cache(self__.method_cache,self__.method_table,self__.cached_hierarchy,self__.hierarchy);

return mf__$1;
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_get_method$arity$2 = (function (mf,dispatch_val){
var self__ = this;
var mf__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((function (){var G__11859 = self__.cached_hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11859) : cljs.core.deref.call(null,G__11859));
})(),(function (){var G__11860 = self__.hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11860) : cljs.core.deref.call(null,G__11860));
})())){
} else {
cljs.core.reset_cache(self__.method_cache,self__.method_table,self__.cached_hierarchy,self__.hierarchy);
}

var temp__4124__auto__ = (function (){var G__11861 = self__.method_cache;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11861) : cljs.core.deref.call(null,G__11861));
})().call(null,dispatch_val);
if(cljs.core.truth_(temp__4124__auto__)){
var target_fn = temp__4124__auto__;
return target_fn;
} else {
var temp__4124__auto____$1 = cljs.core.find_and_cache_best_method(self__.name,dispatch_val,self__.hierarchy,self__.method_table,self__.prefer_table,self__.method_cache,self__.cached_hierarchy);
if(cljs.core.truth_(temp__4124__auto____$1)){
var target_fn = temp__4124__auto____$1;
return target_fn;
} else {
return (function (){var G__11862 = self__.method_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11862) : cljs.core.deref.call(null,G__11862));
})().call(null,self__.default_dispatch_val);
}
}
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefer_method$arity$3 = (function (mf,dispatch_val_x,dispatch_val_y){
var self__ = this;
var mf__$1 = this;
if(cljs.core.truth_(cljs.core.prefers_STAR_(dispatch_val_x,dispatch_val_y,self__.prefer_table))){
throw (new Error([cljs.core.str("Preference conflict in multimethod '"),cljs.core.str(self__.name),cljs.core.str("': "),cljs.core.str(dispatch_val_y),cljs.core.str(" is already preferred to "),cljs.core.str(dispatch_val_x)].join('')));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__.prefer_table,((function (mf__$1){
return (function (old){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(old,dispatch_val_x,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(old,dispatch_val_x,cljs.core.PersistentHashSet.EMPTY),dispatch_val_y));
});})(mf__$1))
);

return cljs.core.reset_cache(self__.method_cache,self__.method_table,self__.cached_hierarchy,self__.hierarchy);
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_methods$arity$1 = (function (mf){
var self__ = this;
var mf__$1 = this;
var G__11863 = self__.method_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11863) : cljs.core.deref.call(null,G__11863));
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefers$arity$1 = (function (mf){
var self__ = this;
var mf__$1 = this;
var G__11864 = self__.prefer_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11864) : cljs.core.deref.call(null,G__11864));
});

cljs.core.MultiFn.prototype.call = (function() {
var G__12705 = null;
var G__12705__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$0 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$0() : self__.dispatch_fn.call(null));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

return (target_fn.cljs$core$IFn$_invoke$arity$0 ? target_fn.cljs$core$IFn$_invoke$arity$0() : target_fn.call(null));
});
var G__12705__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__11865 = a;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$1 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$1(G__11865) : self__.dispatch_fn.call(null,G__11865));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__11866 = a;
return (target_fn.cljs$core$IFn$_invoke$arity$1 ? target_fn.cljs$core$IFn$_invoke$arity$1(G__11866) : target_fn.call(null,G__11866));
});
var G__12705__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__11867 = a;
var G__11868 = b;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$2 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$2(G__11867,G__11868) : self__.dispatch_fn.call(null,G__11867,G__11868));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__11869 = a;
var G__11870 = b;
return (target_fn.cljs$core$IFn$_invoke$arity$2 ? target_fn.cljs$core$IFn$_invoke$arity$2(G__11869,G__11870) : target_fn.call(null,G__11869,G__11870));
});
var G__12705__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__11871 = a;
var G__11872 = b;
var G__11873 = c;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$3 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$3(G__11871,G__11872,G__11873) : self__.dispatch_fn.call(null,G__11871,G__11872,G__11873));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__11874 = a;
var G__11875 = b;
var G__11876 = c;
return (target_fn.cljs$core$IFn$_invoke$arity$3 ? target_fn.cljs$core$IFn$_invoke$arity$3(G__11874,G__11875,G__11876) : target_fn.call(null,G__11874,G__11875,G__11876));
});
var G__12705__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__11877 = a;
var G__11878 = b;
var G__11879 = c;
var G__11880 = d;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$4 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$4(G__11877,G__11878,G__11879,G__11880) : self__.dispatch_fn.call(null,G__11877,G__11878,G__11879,G__11880));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__11881 = a;
var G__11882 = b;
var G__11883 = c;
var G__11884 = d;
return (target_fn.cljs$core$IFn$_invoke$arity$4 ? target_fn.cljs$core$IFn$_invoke$arity$4(G__11881,G__11882,G__11883,G__11884) : target_fn.call(null,G__11881,G__11882,G__11883,G__11884));
});
var G__12705__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__11885 = a;
var G__11886 = b;
var G__11887 = c;
var G__11888 = d;
var G__11889 = e;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$5 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$5(G__11885,G__11886,G__11887,G__11888,G__11889) : self__.dispatch_fn.call(null,G__11885,G__11886,G__11887,G__11888,G__11889));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__11890 = a;
var G__11891 = b;
var G__11892 = c;
var G__11893 = d;
var G__11894 = e;
return (target_fn.cljs$core$IFn$_invoke$arity$5 ? target_fn.cljs$core$IFn$_invoke$arity$5(G__11890,G__11891,G__11892,G__11893,G__11894) : target_fn.call(null,G__11890,G__11891,G__11892,G__11893,G__11894));
});
var G__12705__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__11895 = a;
var G__11896 = b;
var G__11897 = c;
var G__11898 = d;
var G__11899 = e;
var G__11900 = f;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$6 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$6(G__11895,G__11896,G__11897,G__11898,G__11899,G__11900) : self__.dispatch_fn.call(null,G__11895,G__11896,G__11897,G__11898,G__11899,G__11900));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__11901 = a;
var G__11902 = b;
var G__11903 = c;
var G__11904 = d;
var G__11905 = e;
var G__11906 = f;
return (target_fn.cljs$core$IFn$_invoke$arity$6 ? target_fn.cljs$core$IFn$_invoke$arity$6(G__11901,G__11902,G__11903,G__11904,G__11905,G__11906) : target_fn.call(null,G__11901,G__11902,G__11903,G__11904,G__11905,G__11906));
});
var G__12705__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__11907 = a;
var G__11908 = b;
var G__11909 = c;
var G__11910 = d;
var G__11911 = e;
var G__11912 = f;
var G__11913 = g;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$7 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$7(G__11907,G__11908,G__11909,G__11910,G__11911,G__11912,G__11913) : self__.dispatch_fn.call(null,G__11907,G__11908,G__11909,G__11910,G__11911,G__11912,G__11913));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__11914 = a;
var G__11915 = b;
var G__11916 = c;
var G__11917 = d;
var G__11918 = e;
var G__11919 = f;
var G__11920 = g;
return (target_fn.cljs$core$IFn$_invoke$arity$7 ? target_fn.cljs$core$IFn$_invoke$arity$7(G__11914,G__11915,G__11916,G__11917,G__11918,G__11919,G__11920) : target_fn.call(null,G__11914,G__11915,G__11916,G__11917,G__11918,G__11919,G__11920));
});
var G__12705__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__11921 = a;
var G__11922 = b;
var G__11923 = c;
var G__11924 = d;
var G__11925 = e;
var G__11926 = f;
var G__11927 = g;
var G__11928 = h;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$8 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$8(G__11921,G__11922,G__11923,G__11924,G__11925,G__11926,G__11927,G__11928) : self__.dispatch_fn.call(null,G__11921,G__11922,G__11923,G__11924,G__11925,G__11926,G__11927,G__11928));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__11929 = a;
var G__11930 = b;
var G__11931 = c;
var G__11932 = d;
var G__11933 = e;
var G__11934 = f;
var G__11935 = g;
var G__11936 = h;
return (target_fn.cljs$core$IFn$_invoke$arity$8 ? target_fn.cljs$core$IFn$_invoke$arity$8(G__11929,G__11930,G__11931,G__11932,G__11933,G__11934,G__11935,G__11936) : target_fn.call(null,G__11929,G__11930,G__11931,G__11932,G__11933,G__11934,G__11935,G__11936));
});
var G__12705__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__11937 = a;
var G__11938 = b;
var G__11939 = c;
var G__11940 = d;
var G__11941 = e;
var G__11942 = f;
var G__11943 = g;
var G__11944 = h;
var G__11945 = i;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$9 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$9(G__11937,G__11938,G__11939,G__11940,G__11941,G__11942,G__11943,G__11944,G__11945) : self__.dispatch_fn.call(null,G__11937,G__11938,G__11939,G__11940,G__11941,G__11942,G__11943,G__11944,G__11945));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__11946 = a;
var G__11947 = b;
var G__11948 = c;
var G__11949 = d;
var G__11950 = e;
var G__11951 = f;
var G__11952 = g;
var G__11953 = h;
var G__11954 = i;
return (target_fn.cljs$core$IFn$_invoke$arity$9 ? target_fn.cljs$core$IFn$_invoke$arity$9(G__11946,G__11947,G__11948,G__11949,G__11950,G__11951,G__11952,G__11953,G__11954) : target_fn.call(null,G__11946,G__11947,G__11948,G__11949,G__11950,G__11951,G__11952,G__11953,G__11954));
});
var G__12705__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__11955 = a;
var G__11956 = b;
var G__11957 = c;
var G__11958 = d;
var G__11959 = e;
var G__11960 = f;
var G__11961 = g;
var G__11962 = h;
var G__11963 = i;
var G__11964 = j;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$10 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$10(G__11955,G__11956,G__11957,G__11958,G__11959,G__11960,G__11961,G__11962,G__11963,G__11964) : self__.dispatch_fn.call(null,G__11955,G__11956,G__11957,G__11958,G__11959,G__11960,G__11961,G__11962,G__11963,G__11964));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__11965 = a;
var G__11966 = b;
var G__11967 = c;
var G__11968 = d;
var G__11969 = e;
var G__11970 = f;
var G__11971 = g;
var G__11972 = h;
var G__11973 = i;
var G__11974 = j;
return (target_fn.cljs$core$IFn$_invoke$arity$10 ? target_fn.cljs$core$IFn$_invoke$arity$10(G__11965,G__11966,G__11967,G__11968,G__11969,G__11970,G__11971,G__11972,G__11973,G__11974) : target_fn.call(null,G__11965,G__11966,G__11967,G__11968,G__11969,G__11970,G__11971,G__11972,G__11973,G__11974));
});
var G__12705__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__11975 = a;
var G__11976 = b;
var G__11977 = c;
var G__11978 = d;
var G__11979 = e;
var G__11980 = f;
var G__11981 = g;
var G__11982 = h;
var G__11983 = i;
var G__11984 = j;
var G__11985 = k;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$11 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$11(G__11975,G__11976,G__11977,G__11978,G__11979,G__11980,G__11981,G__11982,G__11983,G__11984,G__11985) : self__.dispatch_fn.call(null,G__11975,G__11976,G__11977,G__11978,G__11979,G__11980,G__11981,G__11982,G__11983,G__11984,G__11985));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__11986 = a;
var G__11987 = b;
var G__11988 = c;
var G__11989 = d;
var G__11990 = e;
var G__11991 = f;
var G__11992 = g;
var G__11993 = h;
var G__11994 = i;
var G__11995 = j;
var G__11996 = k;
return (target_fn.cljs$core$IFn$_invoke$arity$11 ? target_fn.cljs$core$IFn$_invoke$arity$11(G__11986,G__11987,G__11988,G__11989,G__11990,G__11991,G__11992,G__11993,G__11994,G__11995,G__11996) : target_fn.call(null,G__11986,G__11987,G__11988,G__11989,G__11990,G__11991,G__11992,G__11993,G__11994,G__11995,G__11996));
});
var G__12705__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__11997 = a;
var G__11998 = b;
var G__11999 = c;
var G__12000 = d;
var G__12001 = e;
var G__12002 = f;
var G__12003 = g;
var G__12004 = h;
var G__12005 = i;
var G__12006 = j;
var G__12007 = k;
var G__12008 = l;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$12 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$12(G__11997,G__11998,G__11999,G__12000,G__12001,G__12002,G__12003,G__12004,G__12005,G__12006,G__12007,G__12008) : self__.dispatch_fn.call(null,G__11997,G__11998,G__11999,G__12000,G__12001,G__12002,G__12003,G__12004,G__12005,G__12006,G__12007,G__12008));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12009 = a;
var G__12010 = b;
var G__12011 = c;
var G__12012 = d;
var G__12013 = e;
var G__12014 = f;
var G__12015 = g;
var G__12016 = h;
var G__12017 = i;
var G__12018 = j;
var G__12019 = k;
var G__12020 = l;
return (target_fn.cljs$core$IFn$_invoke$arity$12 ? target_fn.cljs$core$IFn$_invoke$arity$12(G__12009,G__12010,G__12011,G__12012,G__12013,G__12014,G__12015,G__12016,G__12017,G__12018,G__12019,G__12020) : target_fn.call(null,G__12009,G__12010,G__12011,G__12012,G__12013,G__12014,G__12015,G__12016,G__12017,G__12018,G__12019,G__12020));
});
var G__12705__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12021 = a;
var G__12022 = b;
var G__12023 = c;
var G__12024 = d;
var G__12025 = e;
var G__12026 = f;
var G__12027 = g;
var G__12028 = h;
var G__12029 = i;
var G__12030 = j;
var G__12031 = k;
var G__12032 = l;
var G__12033 = m;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$13 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$13(G__12021,G__12022,G__12023,G__12024,G__12025,G__12026,G__12027,G__12028,G__12029,G__12030,G__12031,G__12032,G__12033) : self__.dispatch_fn.call(null,G__12021,G__12022,G__12023,G__12024,G__12025,G__12026,G__12027,G__12028,G__12029,G__12030,G__12031,G__12032,G__12033));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12034 = a;
var G__12035 = b;
var G__12036 = c;
var G__12037 = d;
var G__12038 = e;
var G__12039 = f;
var G__12040 = g;
var G__12041 = h;
var G__12042 = i;
var G__12043 = j;
var G__12044 = k;
var G__12045 = l;
var G__12046 = m;
return (target_fn.cljs$core$IFn$_invoke$arity$13 ? target_fn.cljs$core$IFn$_invoke$arity$13(G__12034,G__12035,G__12036,G__12037,G__12038,G__12039,G__12040,G__12041,G__12042,G__12043,G__12044,G__12045,G__12046) : target_fn.call(null,G__12034,G__12035,G__12036,G__12037,G__12038,G__12039,G__12040,G__12041,G__12042,G__12043,G__12044,G__12045,G__12046));
});
var G__12705__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12047 = a;
var G__12048 = b;
var G__12049 = c;
var G__12050 = d;
var G__12051 = e;
var G__12052 = f;
var G__12053 = g;
var G__12054 = h;
var G__12055 = i;
var G__12056 = j;
var G__12057 = k;
var G__12058 = l;
var G__12059 = m;
var G__12060 = n;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$14 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$14(G__12047,G__12048,G__12049,G__12050,G__12051,G__12052,G__12053,G__12054,G__12055,G__12056,G__12057,G__12058,G__12059,G__12060) : self__.dispatch_fn.call(null,G__12047,G__12048,G__12049,G__12050,G__12051,G__12052,G__12053,G__12054,G__12055,G__12056,G__12057,G__12058,G__12059,G__12060));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12061 = a;
var G__12062 = b;
var G__12063 = c;
var G__12064 = d;
var G__12065 = e;
var G__12066 = f;
var G__12067 = g;
var G__12068 = h;
var G__12069 = i;
var G__12070 = j;
var G__12071 = k;
var G__12072 = l;
var G__12073 = m;
var G__12074 = n;
return (target_fn.cljs$core$IFn$_invoke$arity$14 ? target_fn.cljs$core$IFn$_invoke$arity$14(G__12061,G__12062,G__12063,G__12064,G__12065,G__12066,G__12067,G__12068,G__12069,G__12070,G__12071,G__12072,G__12073,G__12074) : target_fn.call(null,G__12061,G__12062,G__12063,G__12064,G__12065,G__12066,G__12067,G__12068,G__12069,G__12070,G__12071,G__12072,G__12073,G__12074));
});
var G__12705__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12075 = a;
var G__12076 = b;
var G__12077 = c;
var G__12078 = d;
var G__12079 = e;
var G__12080 = f;
var G__12081 = g;
var G__12082 = h;
var G__12083 = i;
var G__12084 = j;
var G__12085 = k;
var G__12086 = l;
var G__12087 = m;
var G__12088 = n;
var G__12089 = o;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$15 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$15(G__12075,G__12076,G__12077,G__12078,G__12079,G__12080,G__12081,G__12082,G__12083,G__12084,G__12085,G__12086,G__12087,G__12088,G__12089) : self__.dispatch_fn.call(null,G__12075,G__12076,G__12077,G__12078,G__12079,G__12080,G__12081,G__12082,G__12083,G__12084,G__12085,G__12086,G__12087,G__12088,G__12089));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12090 = a;
var G__12091 = b;
var G__12092 = c;
var G__12093 = d;
var G__12094 = e;
var G__12095 = f;
var G__12096 = g;
var G__12097 = h;
var G__12098 = i;
var G__12099 = j;
var G__12100 = k;
var G__12101 = l;
var G__12102 = m;
var G__12103 = n;
var G__12104 = o;
return (target_fn.cljs$core$IFn$_invoke$arity$15 ? target_fn.cljs$core$IFn$_invoke$arity$15(G__12090,G__12091,G__12092,G__12093,G__12094,G__12095,G__12096,G__12097,G__12098,G__12099,G__12100,G__12101,G__12102,G__12103,G__12104) : target_fn.call(null,G__12090,G__12091,G__12092,G__12093,G__12094,G__12095,G__12096,G__12097,G__12098,G__12099,G__12100,G__12101,G__12102,G__12103,G__12104));
});
var G__12705__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12105 = a;
var G__12106 = b;
var G__12107 = c;
var G__12108 = d;
var G__12109 = e;
var G__12110 = f;
var G__12111 = g;
var G__12112 = h;
var G__12113 = i;
var G__12114 = j;
var G__12115 = k;
var G__12116 = l;
var G__12117 = m;
var G__12118 = n;
var G__12119 = o;
var G__12120 = p;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$16 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$16(G__12105,G__12106,G__12107,G__12108,G__12109,G__12110,G__12111,G__12112,G__12113,G__12114,G__12115,G__12116,G__12117,G__12118,G__12119,G__12120) : self__.dispatch_fn.call(null,G__12105,G__12106,G__12107,G__12108,G__12109,G__12110,G__12111,G__12112,G__12113,G__12114,G__12115,G__12116,G__12117,G__12118,G__12119,G__12120));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12121 = a;
var G__12122 = b;
var G__12123 = c;
var G__12124 = d;
var G__12125 = e;
var G__12126 = f;
var G__12127 = g;
var G__12128 = h;
var G__12129 = i;
var G__12130 = j;
var G__12131 = k;
var G__12132 = l;
var G__12133 = m;
var G__12134 = n;
var G__12135 = o;
var G__12136 = p;
return (target_fn.cljs$core$IFn$_invoke$arity$16 ? target_fn.cljs$core$IFn$_invoke$arity$16(G__12121,G__12122,G__12123,G__12124,G__12125,G__12126,G__12127,G__12128,G__12129,G__12130,G__12131,G__12132,G__12133,G__12134,G__12135,G__12136) : target_fn.call(null,G__12121,G__12122,G__12123,G__12124,G__12125,G__12126,G__12127,G__12128,G__12129,G__12130,G__12131,G__12132,G__12133,G__12134,G__12135,G__12136));
});
var G__12705__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12137 = a;
var G__12138 = b;
var G__12139 = c;
var G__12140 = d;
var G__12141 = e;
var G__12142 = f;
var G__12143 = g;
var G__12144 = h;
var G__12145 = i;
var G__12146 = j;
var G__12147 = k;
var G__12148 = l;
var G__12149 = m;
var G__12150 = n;
var G__12151 = o;
var G__12152 = p;
var G__12153 = q;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$17 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$17(G__12137,G__12138,G__12139,G__12140,G__12141,G__12142,G__12143,G__12144,G__12145,G__12146,G__12147,G__12148,G__12149,G__12150,G__12151,G__12152,G__12153) : self__.dispatch_fn.call(null,G__12137,G__12138,G__12139,G__12140,G__12141,G__12142,G__12143,G__12144,G__12145,G__12146,G__12147,G__12148,G__12149,G__12150,G__12151,G__12152,G__12153));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12154 = a;
var G__12155 = b;
var G__12156 = c;
var G__12157 = d;
var G__12158 = e;
var G__12159 = f;
var G__12160 = g;
var G__12161 = h;
var G__12162 = i;
var G__12163 = j;
var G__12164 = k;
var G__12165 = l;
var G__12166 = m;
var G__12167 = n;
var G__12168 = o;
var G__12169 = p;
var G__12170 = q;
return (target_fn.cljs$core$IFn$_invoke$arity$17 ? target_fn.cljs$core$IFn$_invoke$arity$17(G__12154,G__12155,G__12156,G__12157,G__12158,G__12159,G__12160,G__12161,G__12162,G__12163,G__12164,G__12165,G__12166,G__12167,G__12168,G__12169,G__12170) : target_fn.call(null,G__12154,G__12155,G__12156,G__12157,G__12158,G__12159,G__12160,G__12161,G__12162,G__12163,G__12164,G__12165,G__12166,G__12167,G__12168,G__12169,G__12170));
});
var G__12705__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12171 = a;
var G__12172 = b;
var G__12173 = c;
var G__12174 = d;
var G__12175 = e;
var G__12176 = f;
var G__12177 = g;
var G__12178 = h;
var G__12179 = i;
var G__12180 = j;
var G__12181 = k;
var G__12182 = l;
var G__12183 = m;
var G__12184 = n;
var G__12185 = o;
var G__12186 = p;
var G__12187 = q;
var G__12188 = r;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$18 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$18(G__12171,G__12172,G__12173,G__12174,G__12175,G__12176,G__12177,G__12178,G__12179,G__12180,G__12181,G__12182,G__12183,G__12184,G__12185,G__12186,G__12187,G__12188) : self__.dispatch_fn.call(null,G__12171,G__12172,G__12173,G__12174,G__12175,G__12176,G__12177,G__12178,G__12179,G__12180,G__12181,G__12182,G__12183,G__12184,G__12185,G__12186,G__12187,G__12188));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12189 = a;
var G__12190 = b;
var G__12191 = c;
var G__12192 = d;
var G__12193 = e;
var G__12194 = f;
var G__12195 = g;
var G__12196 = h;
var G__12197 = i;
var G__12198 = j;
var G__12199 = k;
var G__12200 = l;
var G__12201 = m;
var G__12202 = n;
var G__12203 = o;
var G__12204 = p;
var G__12205 = q;
var G__12206 = r;
return (target_fn.cljs$core$IFn$_invoke$arity$18 ? target_fn.cljs$core$IFn$_invoke$arity$18(G__12189,G__12190,G__12191,G__12192,G__12193,G__12194,G__12195,G__12196,G__12197,G__12198,G__12199,G__12200,G__12201,G__12202,G__12203,G__12204,G__12205,G__12206) : target_fn.call(null,G__12189,G__12190,G__12191,G__12192,G__12193,G__12194,G__12195,G__12196,G__12197,G__12198,G__12199,G__12200,G__12201,G__12202,G__12203,G__12204,G__12205,G__12206));
});
var G__12705__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12207 = a;
var G__12208 = b;
var G__12209 = c;
var G__12210 = d;
var G__12211 = e;
var G__12212 = f;
var G__12213 = g;
var G__12214 = h;
var G__12215 = i;
var G__12216 = j;
var G__12217 = k;
var G__12218 = l;
var G__12219 = m;
var G__12220 = n;
var G__12221 = o;
var G__12222 = p;
var G__12223 = q;
var G__12224 = r;
var G__12225 = s;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$19 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$19(G__12207,G__12208,G__12209,G__12210,G__12211,G__12212,G__12213,G__12214,G__12215,G__12216,G__12217,G__12218,G__12219,G__12220,G__12221,G__12222,G__12223,G__12224,G__12225) : self__.dispatch_fn.call(null,G__12207,G__12208,G__12209,G__12210,G__12211,G__12212,G__12213,G__12214,G__12215,G__12216,G__12217,G__12218,G__12219,G__12220,G__12221,G__12222,G__12223,G__12224,G__12225));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12226 = a;
var G__12227 = b;
var G__12228 = c;
var G__12229 = d;
var G__12230 = e;
var G__12231 = f;
var G__12232 = g;
var G__12233 = h;
var G__12234 = i;
var G__12235 = j;
var G__12236 = k;
var G__12237 = l;
var G__12238 = m;
var G__12239 = n;
var G__12240 = o;
var G__12241 = p;
var G__12242 = q;
var G__12243 = r;
var G__12244 = s;
return (target_fn.cljs$core$IFn$_invoke$arity$19 ? target_fn.cljs$core$IFn$_invoke$arity$19(G__12226,G__12227,G__12228,G__12229,G__12230,G__12231,G__12232,G__12233,G__12234,G__12235,G__12236,G__12237,G__12238,G__12239,G__12240,G__12241,G__12242,G__12243,G__12244) : target_fn.call(null,G__12226,G__12227,G__12228,G__12229,G__12230,G__12231,G__12232,G__12233,G__12234,G__12235,G__12236,G__12237,G__12238,G__12239,G__12240,G__12241,G__12242,G__12243,G__12244));
});
var G__12705__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12245 = a;
var G__12246 = b;
var G__12247 = c;
var G__12248 = d;
var G__12249 = e;
var G__12250 = f;
var G__12251 = g;
var G__12252 = h;
var G__12253 = i;
var G__12254 = j;
var G__12255 = k;
var G__12256 = l;
var G__12257 = m;
var G__12258 = n;
var G__12259 = o;
var G__12260 = p;
var G__12261 = q;
var G__12262 = r;
var G__12263 = s;
var G__12264 = t;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$20 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$20(G__12245,G__12246,G__12247,G__12248,G__12249,G__12250,G__12251,G__12252,G__12253,G__12254,G__12255,G__12256,G__12257,G__12258,G__12259,G__12260,G__12261,G__12262,G__12263,G__12264) : self__.dispatch_fn.call(null,G__12245,G__12246,G__12247,G__12248,G__12249,G__12250,G__12251,G__12252,G__12253,G__12254,G__12255,G__12256,G__12257,G__12258,G__12259,G__12260,G__12261,G__12262,G__12263,G__12264));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12265 = a;
var G__12266 = b;
var G__12267 = c;
var G__12268 = d;
var G__12269 = e;
var G__12270 = f;
var G__12271 = g;
var G__12272 = h;
var G__12273 = i;
var G__12274 = j;
var G__12275 = k;
var G__12276 = l;
var G__12277 = m;
var G__12278 = n;
var G__12279 = o;
var G__12280 = p;
var G__12281 = q;
var G__12282 = r;
var G__12283 = s;
var G__12284 = t;
return (target_fn.cljs$core$IFn$_invoke$arity$20 ? target_fn.cljs$core$IFn$_invoke$arity$20(G__12265,G__12266,G__12267,G__12268,G__12269,G__12270,G__12271,G__12272,G__12273,G__12274,G__12275,G__12276,G__12277,G__12278,G__12279,G__12280,G__12281,G__12282,G__12283,G__12284) : target_fn.call(null,G__12265,G__12266,G__12267,G__12268,G__12269,G__12270,G__12271,G__12272,G__12273,G__12274,G__12275,G__12276,G__12277,G__12278,G__12279,G__12280,G__12281,G__12282,G__12283,G__12284));
});
var G__12705__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(self__.dispatch_fn,a,b,c,d,cljs.core.array_seq([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(target_fn,a,b,c,d,cljs.core.array_seq([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
});
G__12705 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r