(defproject com.greenyouse/ligable "0.1.0"
  :description "A declarative app writing library"
  :url "http://github.com/greenyouse/ligable"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[org.clojure/clojure "1.6.0"]
                 [org.clojure/clojurescript "0.0-3119"]]

  :profiles {:dev {:dependencies [[weasel "0.6.0"]
                                  [reagent "0.5.0"]]
                   :plugins [[lein-cljsbuild "1.0.3"]]}}

  :cljsbuild {
              :builds [{:id "dev"
                        :source-paths ["src" "dev"]
                        :compiler {:output-to "js/ligable.js"
                                   :output-dir "js/out"
                                   :source-map true
                                   :optimizations :none
                                   :cache-analysis true
                                   :asset-path "js/out"
                                   :main ligable.core}}
                       {:id "advanced"
                        :source-paths ["src"]
                        :compiler {:optimizations :advanced
                                   :output-to "js/ligable.js"
                                   :output-dir "js/advanced"
                                   :source-map "js/ligable.js.map"}}]})
