# Ligable


lig-* (ligare) - to bind
*-able (habilis) - to have or posses some property
ligable (this library) - able to ~~bind~~ make awesome cljs apps


Ligable is a tool for declarative app building. Everything works around
an external file called a `ligand` that lays out how your app will be
built. For now this library is built over
[Reagent](https://github.com/reagent-project/reagent) but that may
change in the future. This was heavily inspired by the by the
[data-driven systems](https://www.youtube.com/watch?v=BNkYYYyfF48) 
presentation given a while back. 

## Installation

Add the following to your Leiningen `:dependencies`:
```clj
[com.greenyouse/ligable "0.1.0-alpha']
```

## Ligands

A `ligand` should be written in an unused directory in your project such
as `resources`. Each `ligand` contains a Clojure map where the keywords
are names of plugins and the values are arguments to each
plugin. Something like this will work:

```clj
{:data {:homepage-list "lots o data"}
 :ui {:home [:section
             [:h1 {:icons ["compose" "search"]} "woot" ]
             [:ul {:data #bind [:data :homepage-list]}
              [:li [:a {:on-click #page :prefs} "Prefs"]]]]
      :prefs [:section
              [:h1 "Prefences"]
              [:p {:on-click #page :home} (+ 1 2)]]
      :homepage :home}}
```

This example uses the `data` and `ui` plugins which hold data in Reagent
atoms and create a Reagent-based UI, respectively. Each keyword of the
data plugin maps to a separate atom.  

The UI plugin builds the UI for the entire app and has a built-in page
router too. The keywords at the top level are pages for the app and
`:homepage` gives the page router a homepage to load. The values of each
page are (you guessed it) the Reagent code to each page. 

Currently the page router requires `:homepage` keyword to be given
though that will likely change in future versions.


These two plugins are the only ones provided by default but you can add
your own by extending the `ligable-plugin` multimethod.

## CLJS Code

In your app code you can build a ligand by using the `ligand` macro,
pointing to the ligand file, and specifying an id to mount on the DOM.

```clj
(ns your.project
    (:require [ligable.core :as l]))

(l/ligand "test/example-ligand.cljs" "app")
```

All the code is generated by a macro which pre-compiles the
ClojureScript code. This means the app is rendered a little faster than
normal.

This library was hacked together pretty quick so there are a few
issues to be aware of. The biggest is that the UI plugin declares
functions named after each page (like `home` and `prefs`) and a routing
function named `page-atom`. The data plugin also creates global defs
that match the name given (like `homepage-list`). Any PRs to help
resolve this or other problems are welcome.

## Tagged Literals

There are three tagged literals right now:

- `#bind` - 
  Takes a location within the ligand and expands into the data from that
  target location.
  
- `#reset` -
  Basically the opposite of `#bind`. It can push new data into the
  target location.
  
- `#page` -
  A helper for UI page navigation. This takes a UI page and will
  transition the app to that page whenever it's called.

Pretty soon there will be an option to add custom tagged literals too
but I need a little more time to work it out.

## License

Copyright © 2015 Ed Babcock

Distributed under the Eclipse Public License either version 1.0 
