/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.com.sun.mail.imap.protocol;

import com.google.code.com.sun.mail.iap.Protocol;
import com.google.code.com.sun.mail.iap.ProtocolException;
import com.google.code.com.sun.mail.iap.Response;
import com.google.code.com.sun.mail.imap.protocol.FetchResponse;
import com.google.code.com.sun.mail.util.ASCIIUtility;
import java.io.IOException;
import java.util.Vector;

public class IMAPResponse
extends Response {
    private String key;
    private int number;

    public IMAPResponse(Protocol c) throws IOException, ProtocolException {
        super(c);
        if (!(!this.isUnTagged() || this.isOK() || this.isNO() || this.isBAD() || this.isBYE())) {
            this.key = this.readAtom();
            try {
                this.number = Integer.parseInt(this.key);
                this.key = this.readAtom();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public IMAPResponse(IMAPResponse r) {
        super(r);
        this.key = r.key;
        this.number = r.number;
    }

    public String[] readSimpleList() {
        this.skipSpaces();
        if (this.buffer[this.index] != 40) {
            return null;
        }
        ++this.index;
        Vector<String> v = new Vector<String>();
        int start = this.index;
        while (this.buffer[this.index] != 41) {
            if (this.buffer[this.index] == 32) {
                v.addElement(ASCIIUtility.toString(this.buffer, start, this.index));
                start = this.index + 1;
            }
            ++this.index;
        }
        if (this.index > start) {
            v.addElement(ASCIIUtility.toString(this.buffer, start, this.index));
        }
        ++this.index;
        int size = v.size();
        if (size > 0) {
            Object[] s = new String[size];
            v.copyInto(s);
            return s;
        }
        return null;
    }

    public String[] readAtomStringList() {
        this.skipSpaces();
        if (this.buffer[this.index] != 40) {
            return null;
        }
        ++this.index;
        Vector<String> v = new Vector<String>();
        do {
            String as;
            if ((as = this.readAtomString()).length() <= 0) continue;
            v.addElement(as);
        } while (this.buffer[this.index++] != 41);
        int size = v.size();
        if (size > 0) {
            Object[] s = new String[size];
            v.copyInto(s);
            return s;
        }
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public boolean keyEquals(String k) {
        return this.key != null && this.key.equalsIgnoreCase(k);
    }

    public int getNumber() {
        return this.number;
    }

    public static IMAPResponse readResponse(Protocol p) throws IOException, ProtocolException {
        IMAPResponse r = new IMAPResponse(p);
        if (r.keyEquals("FETCH")) {
            r = new FetchResponse(r);
        }
        return r;
    }
}

