/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IndexesXml
implements Iterable<Index> {
    private List<Index> indexes = new ArrayList<Index>();

    @Override
    public Iterator<Index> iterator() {
        return this.indexes.iterator();
    }

    public int size() {
        return this.indexes.size();
    }

    public Index addNewIndex(String kind, boolean ancestors) {
        Index index = new Index(kind, ancestors);
        this.indexes.add(index);
        return index;
    }

    public void addNewIndex(Index index) {
        this.indexes.add(index);
    }

    public String toYaml() {
        return this.toYaml(false);
    }

    public String toYaml(boolean serverStyle) {
        int numIndexes;
        StringBuilder builder = new StringBuilder(1024);
        if (serverStyle) {
            builder.append("!!python/object:google.appengine.datastore.datastore_index.IndexDefinitions").append("\n");
        }
        builder.append("indexes:");
        int n = numIndexes = null == this.indexes ? 0 : this.indexes.size();
        if (0 == numIndexes && serverStyle) {
            builder.append(" []");
        }
        builder.append("\n");
        for (Index index : this.indexes) {
            String indexYaml = serverStyle ? index.toServerStyleYaml() : index.toLocalStyleYaml();
            builder.append(indexYaml);
        }
        return builder.toString();
    }

    public class Index {
        private String kind;
        private boolean ancestors;
        private List<PropertySort> properties;

        public Index(String kind, boolean ancestors) {
            this.kind = kind;
            this.ancestors = ancestors;
            this.properties = new ArrayList<PropertySort>();
        }

        public void addNewProperty(String name, boolean ascending) {
            this.properties.add(new PropertySort(name, ascending));
        }

        public String getKind() {
            return this.kind;
        }

        public boolean doIndexAncestors() {
            return this.ancestors;
        }

        public List<PropertySort> getProperties() {
            return this.properties;
        }

        private String toLocalStyleYaml() {
            StringBuilder builder = new StringBuilder(50 * (1 + this.properties.size()));
            builder.append("- kind: \"" + this.kind + "\"\n");
            if (this.ancestors) {
                builder.append("  ancestor: yes\n");
            }
            builder.append("  properties:\n");
            for (PropertySort prop : this.properties) {
                builder.append("  - name: \"" + prop.getPropertyName() + "\"\n");
                builder.append("    direction: " + (prop.isAscending() ? "asc" : "desc") + "\n");
            }
            return builder.toString();
        }

        private String toServerStyleYaml() {
            StringBuilder builder = new StringBuilder(50 * (1 + this.properties.size()));
            builder.append("- ").append("!!python/object:google.appengine.datastore.datastore_index.Index").append("\n");
            builder.append("  kind: " + this.kind + "\n");
            if (this.ancestors) {
                builder.append("  ancestor: yes\n");
            }
            builder.append("  properties:\n");
            for (PropertySort prop : this.properties) {
                builder.append("  - ").append("!!python/object:google.appengine.datastore.datastore_index.Property").append(" {direction: ").append(prop.isAscending() ? "asc" : "desc").append(",\n").append("    ").append("name: " + prop.getPropertyName()).append("}\n");
            }
            return builder.toString();
        }

        public String toXmlString() {
            StringBuilder builder = new StringBuilder(100 * (1 + this.properties.size()));
            builder.append("<datastore-index kind=\"" + this.kind + "\" ancestor=\"" + this.ancestors + "\">\n");
            for (PropertySort prop : this.properties) {
                String direction = prop.isAscending() ? "asc" : "desc";
                builder.append("    <property name=\"" + prop.getPropertyName() + "\" direction=\"" + direction + "\"/>\n");
            }
            builder.append("</datastore-index>\n");
            return builder.toString();
        }
    }

    public class PropertySort {
        private String propName;
        private boolean ascending;

        public PropertySort(String propName, boolean ascending) {
            this.propName = propName;
            this.ascending = ascending;
        }

        public String getPropertyName() {
            return this.propName;
        }

        public boolean isAscending() {
            return this.ascending;
        }
    }
}

