/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.wargen;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.tools.info.SdkInfo;
import com.google.appengine.tools.wargen.WarGenerator;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Set;

public final class WarGeneratorFactory {
    private static final int MAX_FILE_NAME_LENGTH = 255;

    private WarGeneratorFactory() {
    }

    public static WarGenerator newWarGenerator(File externalResourceDir, File destinationDir) throws IOException {
        File libDir = new File(SdkInfo.getSdkRoot(), "lib");
        File userDir = new File(libDir, "user");
        if (!userDir.isDirectory()) {
            throw new RuntimeException("Unable to generate war. " + userDir.getPath() + " is not an existing directory");
        }
        if (destinationDir == null) {
            destinationDir = WarGeneratorFactory.generateTempWarDirLocation(externalResourceDir);
        }
        WarGenerator warGenerator = new WarGenerator(externalResourceDir, destinationDir);
        warGenerator.addLibrariesToCopy(WarGeneratorFactory.topLevelFiles(userDir));
        return warGenerator;
    }

    private static Set<File> topLevelFiles(File dir) {
        HashSet<File> setOfJars = new HashSet<File>(10);
        WarGeneratorFactory.populateFileSet(setOfJars, dir, new FilesOnlyFilter());
        return setOfJars;
    }

    private static void populateFileSet(Set<File> fileSet, File dir, FileFilter filter) {
        for (File f : dir.listFiles()) {
            if (!filter.accept(f)) continue;
            if (f.isFile()) {
                fileSet.add(f);
                continue;
            }
            WarGeneratorFactory.populateFileSet(fileSet, f, filter);
        }
    }

    @VisibleForTesting
    static File generateTempWarDirLocation(File externalResourceDir) throws IOException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (!tempDir.isDirectory()) {
            throw new RuntimeException(tempDir.getPath() + " does not exist. Unable to generate a temporary war directory.");
        }
        File warGenBase = new File(new File(tempDir, "googleappengine"), "wargen");
        return new File(warGenBase, WarGeneratorFactory.encodeToFileNameString(externalResourceDir.getCanonicalPath()));
    }

    @VisibleForTesting
    static String encodeToFileNameString(String string) {
        try {
            String encoded = URLEncoder.encode(string, "UTF8").replaceAll("\\.", "%2E").replaceAll("\\+", "%20").replaceAll("\\*", "%2A").replaceAll("Q", "%51").replaceAll("q", "%71").replaceAll("%", "Q");
            int length = encoded.length();
            if (length > 255) {
                encoded = encoded.substring(length - 255);
            }
            return encoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static class FilesOnlyFilter
    implements FileFilter {
        private FilesOnlyFilter() {
        }

        @Override
        public boolean accept(File candidate) {
            return candidate.isFile();
        }
    }
}

