/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.plugins;

import com.google.appengine.tools.plugins.SDKPluginManager;
import com.google.appengine.tools.plugins.SDKRuntimePlugin;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppYaml;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public final class AppYamlProcessor {
    public static void convert(File baseDir, String aewebPath, String webXmlPath) {
        AppYaml appYaml;
        File appYamlFile = new File(baseDir, "app.yaml");
        if (!appYamlFile.exists()) {
            return;
        }
        File aeweb = new File(aewebPath);
        File webXml = new File(webXmlPath);
        if (aeweb.exists() && webXml.exists() && aeweb.lastModified() >= appYamlFile.lastModified() && webXml.lastModified() >= appYamlFile.lastModified()) {
            return;
        }
        try {
            appYaml = AppYaml.parse(new FileReader(appYamlFile));
        }
        catch (FileNotFoundException ex) {
            throw new AppEngineConfigException("Unable to parse " + appYamlFile, ex);
        }
        SDKRuntimePlugin plugin = SDKPluginManager.findRuntimePlugin(appYaml.getRuntime());
        if (plugin != null) {
            appYaml = plugin.process(appYaml);
        }
        try {
            FileWriter aewebWriter = new FileWriter(aeweb);
            appYaml.generateAppEngineWebXml(aewebWriter);
            aewebWriter.close();
            aeweb.setLastModified(appYamlFile.lastModified());
        }
        catch (IOException ex) {
            throw new AppEngineConfigException("Unable to generate " + aeweb, ex);
        }
        try {
            FileWriter webXmlWriter = new FileWriter(webXml);
            appYaml.generateWebXml(webXmlWriter);
            webXmlWriter.close();
            webXml.setLastModified(appYamlFile.lastModified());
        }
        catch (IOException ex) {
            throw new AppEngineConfigException("Unable to generate " + webXml, ex);
        }
    }
}

