/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools;

import com.google.appengine.tools.admin.OutputPump;
import com.google.appengine.tools.development.DevAppServerMain;
import com.google.appengine.tools.info.SdkInfo;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class KickStart {
    private static final Logger logger = Logger.getLogger(KickStart.class.getName());
    private static final String EXTERNAL_RESOURCE_DIR_FLAG = "--external_resource_dir";
    private static final String EXTERNAL_RESOURCE_DIR_ERROR_MESSAGE = "--external_resource_dir=<path> expected.";
    private static final String GENERATE_WAR_FLAG = "--generate_war";
    private static final String GENERATED_WAR_DIR_FLAG = "--generated_war_dir";
    private static final String JVM_FLAG = "--jvm_flag";
    private static final String JVM_FLAG_ERROR_MESSAGE = "--jvm_flag=<flag> expected.\n--jvm_flag may be repeated to supply multiple flags";
    private static final String START_ON_FIRST_THREAD_FLAG = "--startOnFirstThread";
    private static final String START_ON_FIRST_THREAD_ERROR_MESSAGE = "--startOnFirstThread=<boolean> expected";
    private static final String SDK_ROOT_FLAG = "--sdk_root";
    private static final String SDK_ROOT_ERROR_MESSAGE = "--sdk_root=<path> expected";
    private Process serverProcess = null;

    public static void main(String[] args) {
        new KickStart(args);
    }

    private KickStart(String[] args) {
        String entryClass = null;
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        String home = System.getProperty("java.home");
        String javaExe = home + File.separator + "bin" + File.separator + "java";
        ArrayList<String> jvmArgs = new ArrayList<String>();
        ArrayList<String> appServerArgs = new ArrayList<String>();
        List<String> command = builder.command();
        command.add(javaExe);
        boolean startOnFirstThread = System.getProperty("os.name").equalsIgnoreCase("Mac OS X");
        String externalResourceDirArg = null;
        boolean generateWar = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith(EXTERNAL_RESOURCE_DIR_FLAG)) {
                externalResourceDirArg = KickStart.extractValue(args[i], EXTERNAL_RESOURCE_DIR_ERROR_MESSAGE);
            } else if (args[i].startsWith(GENERATED_WAR_DIR_FLAG) || args[i].startsWith(GENERATE_WAR_FLAG)) {
                generateWar = true;
            }
            if (args[i].startsWith(JVM_FLAG)) {
                jvmArgs.add(KickStart.extractValue(args[i], JVM_FLAG_ERROR_MESSAGE));
                continue;
            }
            if (args[i].startsWith(START_ON_FIRST_THREAD_FLAG)) {
                startOnFirstThread = Boolean.valueOf(KickStart.extractValue(args[i], START_ON_FIRST_THREAD_ERROR_MESSAGE));
                continue;
            }
            if (entryClass == null) {
                if (args[i].charAt(0) == '-') {
                    throw new IllegalArgumentException("Only --jvm_flag may precede classname, not " + args[i]);
                }
                entryClass = args[i];
                if (entryClass.equals(DevAppServerMain.class.getName())) continue;
                throw new IllegalArgumentException("KickStart only works for DevAppServerMain");
            }
            appServerArgs.add(args[i]);
        }
        if (entryClass == null) {
            throw new IllegalArgumentException("missing entry classname");
        }
        if (externalResourceDirArg == null && generateWar) {
            System.err.println("Generating a war directory requires ----external_resource_dir");
            System.exit(1);
        }
        File newWorkingDir = KickStart.newWorkingDir(externalResourceDirArg, args);
        builder.directory(newWorkingDir);
        if (startOnFirstThread) {
            jvmArgs.add("-XstartOnFirstThread");
        }
        String classpath = System.getProperty("java.class.path");
        StringBuffer newClassPath = new StringBuffer();
        assert (classpath != null) : "classpath must not be null";
        String[] paths = classpath.split(File.pathSeparator);
        for (int i = 0; i < paths.length; ++i) {
            newClassPath.append(new File(paths[i]).getAbsolutePath());
            if (i == paths.length - 1) continue;
            newClassPath.append(File.pathSeparator);
        }
        String sdkRoot = null;
        ArrayList<String> absoluteAppServerArgs = new ArrayList<String>(appServerArgs.size());
        for (int i = 0; i < appServerArgs.size(); ++i) {
            File file;
            String arg = (String)appServerArgs.get(i);
            if (arg.startsWith(SDK_ROOT_FLAG)) {
                sdkRoot = new File(KickStart.extractValue(arg, SDK_ROOT_ERROR_MESSAGE)).getAbsolutePath();
                arg = "--sdk_root=" + sdkRoot;
            } else if (arg.startsWith(EXTERNAL_RESOURCE_DIR_FLAG)) {
                arg = "--external_resource_dir=" + new File(KickStart.extractValue(arg, EXTERNAL_RESOURCE_DIR_ERROR_MESSAGE)).getAbsolutePath();
            } else if (i == appServerArgs.size() - 1 && !arg.startsWith("-") && (file = new File(arg)).exists()) {
                arg = new File(arg).getAbsolutePath();
            }
            absoluteAppServerArgs.add(arg);
        }
        if (sdkRoot == null) {
            sdkRoot = SdkInfo.getSdkRoot().getAbsolutePath();
        }
        String agentJar = sdkRoot + "/lib/agent/appengine-agent.jar";
        agentJar = agentJar.replace('/', File.separatorChar);
        jvmArgs.add("-javaagent:" + agentJar);
        String jdkOverridesJar = sdkRoot + "/lib/override/appengine-dev-jdk-overrides.jar";
        jdkOverridesJar = jdkOverridesJar.replace('/', File.separatorChar);
        jvmArgs.add("-Xbootclasspath/p:" + jdkOverridesJar);
        command.addAll(jvmArgs);
        command.add("-classpath");
        command.add(newClassPath.toString());
        command.add(entryClass);
        command.addAll(absoluteAppServerArgs);
        logger.fine("Executing " + command);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (KickStart.this.serverProcess != null) {
                    KickStart.this.serverProcess.destroy();
                }
            }
        });
        try {
            this.serverProcess = builder.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to start the process", e);
        }
        new Thread(new OutputPump(this.serverProcess.getInputStream(), new PrintWriter(System.out, true))).start();
        new Thread(new OutputPump(this.serverProcess.getErrorStream(), new PrintWriter(System.err, true))).start();
        try {
            this.serverProcess.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.serverProcess.destroy();
        this.serverProcess = null;
    }

    private static String extractValue(String argument, String errorMessage) {
        int indexOfEqualSign = argument.indexOf(61);
        if (indexOfEqualSign == -1) {
            throw new IllegalArgumentException(errorMessage);
        }
        return argument.substring(argument.indexOf(61) + 1);
    }

    private static File newWorkingDir(String workingDirectoryArg, String[] args) {
        String workingDirPath;
        if (workingDirectoryArg != null) {
            workingDirPath = workingDirectoryArg;
        } else {
            if (args.length < 1) {
                DevAppServerMain.printHelp(System.out);
                System.exit(1);
            }
            workingDirPath = args[args.length - 1];
        }
        File newDir = new File(workingDirPath);
        if (!newDir.isDirectory()) {
            if (workingDirectoryArg != null) {
                System.err.println(workingDirectoryArg + " is not an existing directory.");
                System.exit(1);
            } else {
                DevAppServerMain.validateWarPath(newDir);
            }
        }
        return newDir;
    }
}

