goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_48363 = (function (this$){
var x__4550__auto__ = (((this$ == null))?null:this$);
var m__4551__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4551__auto__.call(null,this$));
} else {
var m__4549__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4549__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_48363(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_48364 = (function (this$){
var x__4550__auto__ = (((this$ == null))?null:this$);
var m__4551__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4551__auto__.call(null,this$));
} else {
var m__4549__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4549__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_48364(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__47224 = coll;
var G__47225 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__47224,G__47225) : shadow.dom.lazy_native_coll_seq.call(null,G__47224,G__47225));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4253__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__47255 = arguments.length;
switch (G__47255) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__47267 = arguments.length;
switch (G__47267) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__47277 = arguments.length;
switch (G__47277) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__47293 = arguments.length;
switch (G__47293) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__47305 = arguments.length;
switch (G__47305) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__47325 = arguments.length;
switch (G__47325) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4253__auto__ = (!((typeof document !== 'undefined')));
if(or__4253__auto__){
return or__4253__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e47331){if((e47331 instanceof Object)){
var e = e47331;
return console.log("didnt support attachEvent",el,e);
} else {
throw e47331;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4253__auto__ = (!((typeof document !== 'undefined')));
if(or__4253__auto__){
return or__4253__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__47348 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__47349 = null;
var count__47350 = (0);
var i__47351 = (0);
while(true){
if((i__47351 < count__47350)){
var el = chunk__47349.cljs$core$IIndexed$_nth$arity$2(null,i__47351);
var handler_48379__$1 = ((function (seq__47348,chunk__47349,count__47350,i__47351,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__47348,chunk__47349,count__47350,i__47351,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_48379__$1);


var G__48380 = seq__47348;
var G__48381 = chunk__47349;
var G__48382 = count__47350;
var G__48383 = (i__47351 + (1));
seq__47348 = G__48380;
chunk__47349 = G__48381;
count__47350 = G__48382;
i__47351 = G__48383;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__47348);
if(temp__5804__auto__){
var seq__47348__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__47348__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__47348__$1);
var G__48384 = cljs.core.chunk_rest(seq__47348__$1);
var G__48385 = c__4679__auto__;
var G__48386 = cljs.core.count(c__4679__auto__);
var G__48387 = (0);
seq__47348 = G__48384;
chunk__47349 = G__48385;
count__47350 = G__48386;
i__47351 = G__48387;
continue;
} else {
var el = cljs.core.first(seq__47348__$1);
var handler_48388__$1 = ((function (seq__47348,chunk__47349,count__47350,i__47351,el,seq__47348__$1,temp__5804__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__47348,chunk__47349,count__47350,i__47351,el,seq__47348__$1,temp__5804__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_48388__$1);


var G__48389 = cljs.core.next(seq__47348__$1);
var G__48390 = null;
var G__48391 = (0);
var G__48392 = (0);
seq__47348 = G__48389;
chunk__47349 = G__48390;
count__47350 = G__48391;
i__47351 = G__48392;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__47375 = arguments.length;
switch (G__47375) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__47401 = cljs.core.seq(events);
var chunk__47402 = null;
var count__47403 = (0);
var i__47404 = (0);
while(true){
if((i__47404 < count__47403)){
var vec__47414 = chunk__47402.cljs$core$IIndexed$_nth$arity$2(null,i__47404);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47414,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47414,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__48394 = seq__47401;
var G__48395 = chunk__47402;
var G__48396 = count__47403;
var G__48397 = (i__47404 + (1));
seq__47401 = G__48394;
chunk__47402 = G__48395;
count__47403 = G__48396;
i__47404 = G__48397;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__47401);
if(temp__5804__auto__){
var seq__47401__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__47401__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__47401__$1);
var G__48398 = cljs.core.chunk_rest(seq__47401__$1);
var G__48399 = c__4679__auto__;
var G__48400 = cljs.core.count(c__4679__auto__);
var G__48401 = (0);
seq__47401 = G__48398;
chunk__47402 = G__48399;
count__47403 = G__48400;
i__47404 = G__48401;
continue;
} else {
var vec__47422 = cljs.core.first(seq__47401__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47422,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47422,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__48402 = cljs.core.next(seq__47401__$1);
var G__48403 = null;
var G__48404 = (0);
var G__48405 = (0);
seq__47401 = G__48402;
chunk__47402 = G__48403;
count__47403 = G__48404;
i__47404 = G__48405;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__47431 = cljs.core.seq(styles);
var chunk__47432 = null;
var count__47433 = (0);
var i__47434 = (0);
while(true){
if((i__47434 < count__47433)){
var vec__47447 = chunk__47432.cljs$core$IIndexed$_nth$arity$2(null,i__47434);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47447,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47447,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__48406 = seq__47431;
var G__48407 = chunk__47432;
var G__48408 = count__47433;
var G__48409 = (i__47434 + (1));
seq__47431 = G__48406;
chunk__47432 = G__48407;
count__47433 = G__48408;
i__47434 = G__48409;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__47431);
if(temp__5804__auto__){
var seq__47431__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__47431__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__47431__$1);
var G__48410 = cljs.core.chunk_rest(seq__47431__$1);
var G__48411 = c__4679__auto__;
var G__48412 = cljs.core.count(c__4679__auto__);
var G__48413 = (0);
seq__47431 = G__48410;
chunk__47432 = G__48411;
count__47433 = G__48412;
i__47434 = G__48413;
continue;
} else {
var vec__47450 = cljs.core.first(seq__47431__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47450,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47450,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__48414 = cljs.core.next(seq__47431__$1);
var G__48415 = null;
var G__48416 = (0);
var G__48417 = (0);
seq__47431 = G__48414;
chunk__47432 = G__48415;
count__47433 = G__48416;
i__47434 = G__48417;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__47455_48418 = key;
var G__47455_48419__$1 = (((G__47455_48418 instanceof cljs.core.Keyword))?G__47455_48418.fqn:null);
switch (G__47455_48419__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_48421 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4253__auto__ = goog.string.startsWith(ks_48421,"data-");
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return goog.string.startsWith(ks_48421,"aria-");
}
})())){
el.setAttribute(ks_48421,value);
} else {
(el[ks_48421] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__47478){
var map__47480 = p__47478;
var map__47480__$1 = cljs.core.__destructure_map(map__47480);
var props = map__47480__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47480__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__47481 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47481,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47481,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47481,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__47488 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__47488,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__47488;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__47492 = arguments.length;
switch (G__47492) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__47497){
var vec__47498 = p__47497;
var seq__47499 = cljs.core.seq(vec__47498);
var first__47500 = cljs.core.first(seq__47499);
var seq__47499__$1 = cljs.core.next(seq__47499);
var nn = first__47500;
var first__47500__$1 = cljs.core.first(seq__47499__$1);
var seq__47499__$2 = cljs.core.next(seq__47499__$1);
var np = first__47500__$1;
var nc = seq__47499__$2;
var node = vec__47498;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__47501 = nn;
var G__47502 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__47501,G__47502) : create_fn.call(null,G__47501,G__47502));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__47503 = nn;
var G__47504 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__47503,G__47504) : create_fn.call(null,G__47503,G__47504));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__47506 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47506,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47506,(1),null);
var seq__47509_48425 = cljs.core.seq(node_children);
var chunk__47510_48426 = null;
var count__47511_48427 = (0);
var i__47512_48428 = (0);
while(true){
if((i__47512_48428 < count__47511_48427)){
var child_struct_48429 = chunk__47510_48426.cljs$core$IIndexed$_nth$arity$2(null,i__47512_48428);
var children_48430 = shadow.dom.dom_node(child_struct_48429);
if(cljs.core.seq_QMARK_(children_48430)){
var seq__47556_48431 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_48430));
var chunk__47558_48432 = null;
var count__47559_48433 = (0);
var i__47560_48434 = (0);
while(true){
if((i__47560_48434 < count__47559_48433)){
var child_48436 = chunk__47558_48432.cljs$core$IIndexed$_nth$arity$2(null,i__47560_48434);
if(cljs.core.truth_(child_48436)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_48436);


var G__48437 = seq__47556_48431;
var G__48438 = chunk__47558_48432;
var G__48439 = count__47559_48433;
var G__48440 = (i__47560_48434 + (1));
seq__47556_48431 = G__48437;
chunk__47558_48432 = G__48438;
count__47559_48433 = G__48439;
i__47560_48434 = G__48440;
continue;
} else {
var G__48441 = seq__47556_48431;
var G__48442 = chunk__47558_48432;
var G__48443 = count__47559_48433;
var G__48444 = (i__47560_48434 + (1));
seq__47556_48431 = G__48441;
chunk__47558_48432 = G__48442;
count__47559_48433 = G__48443;
i__47560_48434 = G__48444;
continue;
}
} else {
var temp__5804__auto___48446 = cljs.core.seq(seq__47556_48431);
if(temp__5804__auto___48446){
var seq__47556_48447__$1 = temp__5804__auto___48446;
if(cljs.core.chunked_seq_QMARK_(seq__47556_48447__$1)){
var c__4679__auto___48448 = cljs.core.chunk_first(seq__47556_48447__$1);
var G__48451 = cljs.core.chunk_rest(seq__47556_48447__$1);
var G__48453 = c__4679__auto___48448;
var G__48454 = cljs.core.count(c__4679__auto___48448);
var G__48455 = (0);
seq__47556_48431 = G__48451;
chunk__47558_48432 = G__48453;
count__47559_48433 = G__48454;
i__47560_48434 = G__48455;
continue;
} else {
var child_48456 = cljs.core.first(seq__47556_48447__$1);
if(cljs.core.truth_(child_48456)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_48456);


var G__48457 = cljs.core.next(seq__47556_48447__$1);
var G__48458 = null;
var G__48459 = (0);
var G__48460 = (0);
seq__47556_48431 = G__48457;
chunk__47558_48432 = G__48458;
count__47559_48433 = G__48459;
i__47560_48434 = G__48460;
continue;
} else {
var G__48461 = cljs.core.next(seq__47556_48447__$1);
var G__48462 = null;
var G__48463 = (0);
var G__48464 = (0);
seq__47556_48431 = G__48461;
chunk__47558_48432 = G__48462;
count__47559_48433 = G__48463;
i__47560_48434 = G__48464;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_48430);
}


var G__48465 = seq__47509_48425;
var G__48466 = chunk__47510_48426;
var G__48467 = count__47511_48427;
var G__48468 = (i__47512_48428 + (1));
seq__47509_48425 = G__48465;
chunk__47510_48426 = G__48466;
count__47511_48427 = G__48467;
i__47512_48428 = G__48468;
continue;
} else {
var temp__5804__auto___48469 = cljs.core.seq(seq__47509_48425);
if(temp__5804__auto___48469){
var seq__47509_48470__$1 = temp__5804__auto___48469;
if(cljs.core.chunked_seq_QMARK_(seq__47509_48470__$1)){
var c__4679__auto___48471 = cljs.core.chunk_first(seq__47509_48470__$1);
var G__48472 = cljs.core.chunk_rest(seq__47509_48470__$1);
var G__48473 = c__4679__auto___48471;
var G__48474 = cljs.core.count(c__4679__auto___48471);
var G__48475 = (0);
seq__47509_48425 = G__48472;
chunk__47510_48426 = G__48473;
count__47511_48427 = G__48474;
i__47512_48428 = G__48475;
continue;
} else {
var child_struct_48476 = cljs.core.first(seq__47509_48470__$1);
var children_48477 = shadow.dom.dom_node(child_struct_48476);
if(cljs.core.seq_QMARK_(children_48477)){
var seq__47564_48478 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_48477));
var chunk__47566_48479 = null;
var count__47567_48480 = (0);
var i__47568_48481 = (0);
while(true){
if((i__47568_48481 < count__47567_48480)){
var child_48482 = chunk__47566_48479.cljs$core$IIndexed$_nth$arity$2(null,i__47568_48481);
if(cljs.core.truth_(child_48482)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_48482);


var G__48483 = seq__47564_48478;
var G__48484 = chunk__47566_48479;
var G__48485 = count__47567_48480;
var G__48486 = (i__47568_48481 + (1));
seq__47564_48478 = G__48483;
chunk__47566_48479 = G__48484;
count__47567_48480 = G__48485;
i__47568_48481 = G__48486;
continue;
} else {
var G__48487 = seq__47564_48478;
var G__48488 = chunk__47566_48479;
var G__48489 = count__47567_48480;
var G__48490 = (i__47568_48481 + (1));
seq__47564_48478 = G__48487;
chunk__47566_48479 = G__48488;
count__47567_48480 = G__48489;
i__47568_48481 = G__48490;
continue;
}
} else {
var temp__5804__auto___48491__$1 = cljs.core.seq(seq__47564_48478);
if(temp__5804__auto___48491__$1){
var seq__47564_48492__$1 = temp__5804__auto___48491__$1;
if(cljs.core.chunked_seq_QMARK_(seq__47564_48492__$1)){
var c__4679__auto___48493 = cljs.core.chunk_first(seq__47564_48492__$1);
var G__48494 = cljs.core.chunk_rest(seq__47564_48492__$1);
var G__48495 = c__4679__auto___48493;
var G__48496 = cljs.core.count(c__4679__auto___48493);
var G__48497 = (0);
seq__47564_48478 = G__48494;
chunk__47566_48479 = G__48495;
count__47567_48480 = G__48496;
i__47568_48481 = G__48497;
continue;
} else {
var child_48498 = cljs.core.first(seq__47564_48492__$1);
if(cljs.core.truth_(child_48498)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_48498);


var G__48499 = cljs.core.next(seq__47564_48492__$1);
var G__48500 = null;
var G__48501 = (0);
var G__48502 = (0);
seq__47564_48478 = G__48499;
chunk__47566_48479 = G__48500;
count__47567_48480 = G__48501;
i__47568_48481 = G__48502;
continue;
} else {
var G__48503 = cljs.core.next(seq__47564_48492__$1);
var G__48504 = null;
var G__48505 = (0);
var G__48506 = (0);
seq__47564_48478 = G__48503;
chunk__47566_48479 = G__48504;
count__47567_48480 = G__48505;
i__47568_48481 = G__48506;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_48477);
}


var G__48507 = cljs.core.next(seq__47509_48470__$1);
var G__48508 = null;
var G__48509 = (0);
var G__48510 = (0);
seq__47509_48425 = G__48507;
chunk__47510_48426 = G__48508;
count__47511_48427 = G__48509;
i__47512_48428 = G__48510;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__47617 = cljs.core.seq(node);
var chunk__47618 = null;
var count__47619 = (0);
var i__47620 = (0);
while(true){
if((i__47620 < count__47619)){
var n = chunk__47618.cljs$core$IIndexed$_nth$arity$2(null,i__47620);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__48511 = seq__47617;
var G__48512 = chunk__47618;
var G__48513 = count__47619;
var G__48514 = (i__47620 + (1));
seq__47617 = G__48511;
chunk__47618 = G__48512;
count__47619 = G__48513;
i__47620 = G__48514;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__47617);
if(temp__5804__auto__){
var seq__47617__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__47617__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__47617__$1);
var G__48516 = cljs.core.chunk_rest(seq__47617__$1);
var G__48517 = c__4679__auto__;
var G__48518 = cljs.core.count(c__4679__auto__);
var G__48519 = (0);
seq__47617 = G__48516;
chunk__47618 = G__48517;
count__47619 = G__48518;
i__47620 = G__48519;
continue;
} else {
var n = cljs.core.first(seq__47617__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__48521 = cljs.core.next(seq__47617__$1);
var G__48522 = null;
var G__48523 = (0);
var G__48524 = (0);
seq__47617 = G__48521;
chunk__47618 = G__48522;
count__47619 = G__48523;
i__47620 = G__48524;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__47634 = arguments.length;
switch (G__47634) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__47644 = arguments.length;
switch (G__47644) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__47674 = arguments.length;
switch (G__47674) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4253__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4870__auto__ = [];
var len__4864__auto___48532 = arguments.length;
var i__4865__auto___48533 = (0);
while(true){
if((i__4865__auto___48533 < len__4864__auto___48532)){
args__4870__auto__.push((arguments[i__4865__auto___48533]));

var G__48534 = (i__4865__auto___48533 + (1));
i__4865__auto___48533 = G__48534;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__47719_48536 = cljs.core.seq(nodes);
var chunk__47720_48537 = null;
var count__47721_48538 = (0);
var i__47722_48539 = (0);
while(true){
if((i__47722_48539 < count__47721_48538)){
var node_48540 = chunk__47720_48537.cljs$core$IIndexed$_nth$arity$2(null,i__47722_48539);
fragment.appendChild(shadow.dom._to_dom(node_48540));


var G__48541 = seq__47719_48536;
var G__48542 = chunk__47720_48537;
var G__48543 = count__47721_48538;
var G__48544 = (i__47722_48539 + (1));
seq__47719_48536 = G__48541;
chunk__47720_48537 = G__48542;
count__47721_48538 = G__48543;
i__47722_48539 = G__48544;
continue;
} else {
var temp__5804__auto___48545 = cljs.core.seq(seq__47719_48536);
if(temp__5804__auto___48545){
var seq__47719_48546__$1 = temp__5804__auto___48545;
if(cljs.core.chunked_seq_QMARK_(seq__47719_48546__$1)){
var c__4679__auto___48548 = cljs.core.chunk_first(seq__47719_48546__$1);
var G__48549 = cljs.core.chunk_rest(seq__47719_48546__$1);
var G__48550 = c__4679__auto___48548;
var G__48551 = cljs.core.count(c__4679__auto___48548);
var G__48552 = (0);
seq__47719_48536 = G__48549;
chunk__47720_48537 = G__48550;
count__47721_48538 = G__48551;
i__47722_48539 = G__48552;
continue;
} else {
var node_48553 = cljs.core.first(seq__47719_48546__$1);
fragment.appendChild(shadow.dom._to_dom(node_48553));


var G__48555 = cljs.core.next(seq__47719_48546__$1);
var G__48556 = null;
var G__48557 = (0);
var G__48558 = (0);
seq__47719_48536 = G__48555;
chunk__47720_48537 = G__48556;
count__47721_48538 = G__48557;
i__47722_48539 = G__48558;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq47714){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq47714));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__47745_48559 = cljs.core.seq(scripts);
var chunk__47746_48560 = null;
var count__47747_48561 = (0);
var i__47748_48562 = (0);
while(true){
if((i__47748_48562 < count__47747_48561)){
var vec__47762_48563 = chunk__47746_48560.cljs$core$IIndexed$_nth$arity$2(null,i__47748_48562);
var script_tag_48564 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47762_48563,(0),null);
var script_body_48565 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47762_48563,(1),null);
eval(script_body_48565);


var G__48566 = seq__47745_48559;
var G__48567 = chunk__47746_48560;
var G__48568 = count__47747_48561;
var G__48569 = (i__47748_48562 + (1));
seq__47745_48559 = G__48566;
chunk__47746_48560 = G__48567;
count__47747_48561 = G__48568;
i__47748_48562 = G__48569;
continue;
} else {
var temp__5804__auto___48570 = cljs.core.seq(seq__47745_48559);
if(temp__5804__auto___48570){
var seq__47745_48571__$1 = temp__5804__auto___48570;
if(cljs.core.chunked_seq_QMARK_(seq__47745_48571__$1)){
var c__4679__auto___48572 = cljs.core.chunk_first(seq__47745_48571__$1);
var G__48573 = cljs.core.chunk_rest(seq__47745_48571__$1);
var G__48574 = c__4679__auto___48572;
var G__48575 = cljs.core.count(c__4679__auto___48572);
var G__48576 = (0);
seq__47745_48559 = G__48573;
chunk__47746_48560 = G__48574;
count__47747_48561 = G__48575;
i__47748_48562 = G__48576;
continue;
} else {
var vec__47766_48577 = cljs.core.first(seq__47745_48571__$1);
var script_tag_48578 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47766_48577,(0),null);
var script_body_48579 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47766_48577,(1),null);
eval(script_body_48579);


var G__48580 = cljs.core.next(seq__47745_48571__$1);
var G__48581 = null;
var G__48582 = (0);
var G__48583 = (0);
seq__47745_48559 = G__48580;
chunk__47746_48560 = G__48581;
count__47747_48561 = G__48582;
i__47748_48562 = G__48583;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__47772){
var vec__47773 = p__47772;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47773,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47773,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__47790 = arguments.length;
switch (G__47790) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__47811 = cljs.core.seq(style_keys);
var chunk__47812 = null;
var count__47813 = (0);
var i__47814 = (0);
while(true){
if((i__47814 < count__47813)){
var it = chunk__47812.cljs$core$IIndexed$_nth$arity$2(null,i__47814);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__48591 = seq__47811;
var G__48592 = chunk__47812;
var G__48593 = count__47813;
var G__48594 = (i__47814 + (1));
seq__47811 = G__48591;
chunk__47812 = G__48592;
count__47813 = G__48593;
i__47814 = G__48594;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__47811);
if(temp__5804__auto__){
var seq__47811__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__47811__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__47811__$1);
var G__48595 = cljs.core.chunk_rest(seq__47811__$1);
var G__48596 = c__4679__auto__;
var G__48597 = cljs.core.count(c__4679__auto__);
var G__48598 = (0);
seq__47811 = G__48595;
chunk__47812 = G__48596;
count__47813 = G__48597;
i__47814 = G__48598;
continue;
} else {
var it = cljs.core.first(seq__47811__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__48599 = cljs.core.next(seq__47811__$1);
var G__48600 = null;
var G__48601 = (0);
var G__48602 = (0);
seq__47811 = G__48599;
chunk__47812 = G__48600;
count__47813 = G__48601;
i__47814 = G__48602;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k47868,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__47885 = k47868;
var G__47885__$1 = (((G__47885 instanceof cljs.core.Keyword))?G__47885.fqn:null);
switch (G__47885__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k47868,else__4505__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__47897){
var vec__47899 = p__47897;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47899,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47899,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__47867){
var self__ = this;
var G__47867__$1 = this;
return (new cljs.core.RecordIter((0),G__47867__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
})(this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this47869,other47870){
var self__ = this;
var this47869__$1 = this;
return (((!((other47870 == null)))) && ((((this47869__$1.constructor === other47870.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47869__$1.x,other47870.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47869__$1.y,other47870.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47869__$1.__extmap,other47870.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k47868){
var self__ = this;
var this__4509__auto____$1 = this;
var G__47920 = k47868;
var G__47920__$1 = (((G__47920 instanceof cljs.core.Keyword))?G__47920.fqn:null);
switch (G__47920__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k47868);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__47867){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__47924 = cljs.core.keyword_identical_QMARK_;
var expr__47925 = k__4511__auto__;
if(cljs.core.truth_((pred__47924.cljs$core$IFn$_invoke$arity$2 ? pred__47924.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__47925) : pred__47924.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__47925)))){
return (new shadow.dom.Coordinate(G__47867,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__47924.cljs$core$IFn$_invoke$arity$2 ? pred__47924.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__47925) : pred__47924.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__47925)))){
return (new shadow.dom.Coordinate(self__.x,G__47867,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__47867),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__47867){
var self__ = this;
var this__4501__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__47867,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4508__auto__,(0)),cljs.core._nth(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__47873){
var extmap__4542__auto__ = (function (){var G__47945 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__47873,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__47873)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__47945);
} else {
return G__47945;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__47873),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__47873),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k47956,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__47963 = k47956;
var G__47963__$1 = (((G__47963 instanceof cljs.core.Keyword))?G__47963.fqn:null);
switch (G__47963__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k47956,else__4505__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__47967){
var vec__47968 = p__47967;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47968,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47968,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#shadow.dom.Size{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__47955){
var self__ = this;
var G__47955__$1 = this;
return (new cljs.core.RecordIter((0),G__47955__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
})(this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this47957,other47958){
var self__ = this;
var this47957__$1 = this;
return (((!((other47958 == null)))) && ((((this47957__$1.constructor === other47958.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47957__$1.w,other47958.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47957__$1.h,other47958.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47957__$1.__extmap,other47958.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k47956){
var self__ = this;
var this__4509__auto____$1 = this;
var G__48014 = k47956;
var G__48014__$1 = (((G__48014 instanceof cljs.core.Keyword))?G__48014.fqn:null);
switch (G__48014__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k47956);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__47955){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__48019 = cljs.core.keyword_identical_QMARK_;
var expr__48020 = k__4511__auto__;
if(cljs.core.truth_((pred__48019.cljs$core$IFn$_invoke$arity$2 ? pred__48019.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__48020) : pred__48019.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__48020)))){
return (new shadow.dom.Size(G__47955,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__48019.cljs$core$IFn$_invoke$arity$2 ? pred__48019.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__48020) : pred__48019.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__48020)))){
return (new shadow.dom.Size(self__.w,G__47955,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__47955),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__47955){
var self__ = this;
var this__4501__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__47955,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4508__auto__,(0)),cljs.core._nth(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__47960){
var extmap__4542__auto__ = (function (){var G__48050 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__47960,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__47960)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__48050);
} else {
return G__48050;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__47960),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__47960),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4738__auto__ = opts;
var l__4739__auto__ = a__4738__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4739__auto__)){
var G__48631 = (i + (1));
var G__48632 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__48631;
ret = G__48632;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__48111){
var vec__48112 = p__48111;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48112,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48112,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__48128 = arguments.length;
switch (G__48128) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5802__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5802__auto__)){
var child = temp__5802__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__48634 = ps;
var G__48635 = (i + (1));
el__$1 = G__48634;
i = G__48635;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__48162 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48162,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48162,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48162,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__48165_48636 = cljs.core.seq(props);
var chunk__48166_48637 = null;
var count__48167_48638 = (0);
var i__48168_48639 = (0);
while(true){
if((i__48168_48639 < count__48167_48638)){
var vec__48189_48640 = chunk__48166_48637.cljs$core$IIndexed$_nth$arity$2(null,i__48168_48639);
var k_48641 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48189_48640,(0),null);
var v_48642 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48189_48640,(1),null);
el.setAttributeNS((function (){var temp__5804__auto__ = cljs.core.namespace(k_48641);
if(cljs.core.truth_(temp__5804__auto__)){
var ns = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_48641),v_48642);


var G__48643 = seq__48165_48636;
var G__48644 = chunk__48166_48637;
var G__48645 = count__48167_48638;
var G__48646 = (i__48168_48639 + (1));
seq__48165_48636 = G__48643;
chunk__48166_48637 = G__48644;
count__48167_48638 = G__48645;
i__48168_48639 = G__48646;
continue;
} else {
var temp__5804__auto___48647 = cljs.core.seq(seq__48165_48636);
if(temp__5804__auto___48647){
var seq__48165_48648__$1 = temp__5804__auto___48647;
if(cljs.core.chunked_seq_QMARK_(seq__48165_48648__$1)){
var c__4679__auto___48649 = cljs.core.chunk_first(seq__48165_48648__$1);
var G__48650 = cljs.core.chunk_rest(seq__48165_48648__$1);
var G__48651 = c__4679__auto___48649;
var G__48652 = cljs.core.count(c__4679__auto___48649);
var G__48653 = (0);
seq__48165_48636 = G__48650;
chunk__48166_48637 = G__48651;
count__48167_48638 = G__48652;
i__48168_48639 = G__48653;
continue;
} else {
var vec__48201_48654 = cljs.core.first(seq__48165_48648__$1);
var k_48655 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48201_48654,(0),null);
var v_48656 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48201_48654,(1),null);
el.setAttributeNS((function (){var temp__5804__auto____$1 = cljs.core.namespace(k_48655);
if(cljs.core.truth_(temp__5804__auto____$1)){
var ns = temp__5804__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_48655),v_48656);


var G__48657 = cljs.core.next(seq__48165_48648__$1);
var G__48658 = null;
var G__48659 = (0);
var G__48660 = (0);
seq__48165_48636 = G__48657;
chunk__48166_48637 = G__48658;
count__48167_48638 = G__48659;
i__48168_48639 = G__48660;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__48209 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48209,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48209,(1),null);
var seq__48213_48661 = cljs.core.seq(node_children);
var chunk__48215_48662 = null;
var count__48216_48663 = (0);
var i__48217_48664 = (0);
while(true){
if((i__48217_48664 < count__48216_48663)){
var child_struct_48665 = chunk__48215_48662.cljs$core$IIndexed$_nth$arity$2(null,i__48217_48664);
if((!((child_struct_48665 == null)))){
if(typeof child_struct_48665 === 'string'){
var text_48666 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_48666),child_struct_48665].join(''));
} else {
var children_48667 = shadow.dom.svg_node(child_struct_48665);
if(cljs.core.seq_QMARK_(children_48667)){
var seq__48242_48669 = cljs.core.seq(children_48667);
var chunk__48244_48670 = null;
var count__48245_48671 = (0);
var i__48246_48672 = (0);
while(true){
if((i__48246_48672 < count__48245_48671)){
var child_48675 = chunk__48244_48670.cljs$core$IIndexed$_nth$arity$2(null,i__48246_48672);
if(cljs.core.truth_(child_48675)){
node.appendChild(child_48675);


var G__48676 = seq__48242_48669;
var G__48677 = chunk__48244_48670;
var G__48678 = count__48245_48671;
var G__48679 = (i__48246_48672 + (1));
seq__48242_48669 = G__48676;
chunk__48244_48670 = G__48677;
count__48245_48671 = G__48678;
i__48246_48672 = G__48679;
continue;
} else {
var G__48680 = seq__48242_48669;
var G__48681 = chunk__48244_48670;
var G__48682 = count__48245_48671;
var G__48683 = (i__48246_48672 + (1));
seq__48242_48669 = G__48680;
chunk__48244_48670 = G__48681;
count__48245_48671 = G__48682;
i__48246_48672 = G__48683;
continue;
}
} else {
var temp__5804__auto___48684 = cljs.core.seq(seq__48242_48669);
if(temp__5804__auto___48684){
var seq__48242_48685__$1 = temp__5804__auto___48684;
if(cljs.core.chunked_seq_QMARK_(seq__48242_48685__$1)){
var c__4679__auto___48686 = cljs.core.chunk_first(seq__48242_48685__$1);
var G__48687 = cljs.core.chunk_rest(seq__48242_48685__$1);
var G__48688 = c__4679__auto___48686;
var G__48689 = cljs.core.count(c__4679__auto___48686);
var G__48690 = (0);
seq__48242_48669 = G__48687;
chunk__48244_48670 = G__48688;
count__48245_48671 = G__48689;
i__48246_48672 = G__48690;
continue;
} else {
var child_48691 = cljs.core.first(seq__48242_48685__$1);
if(cljs.core.truth_(child_48691)){
node.appendChild(child_48691);


var G__48696 = cljs.core.next(seq__48242_48685__$1);
var G__48697 = null;
var G__48698 = (0);
var G__48699 = (0);
seq__48242_48669 = G__48696;
chunk__48244_48670 = G__48697;
count__48245_48671 = G__48698;
i__48246_48672 = G__48699;
continue;
} else {
var G__48700 = cljs.core.next(seq__48242_48685__$1);
var G__48701 = null;
var G__48702 = (0);
var G__48703 = (0);
seq__48242_48669 = G__48700;
chunk__48244_48670 = G__48701;
count__48245_48671 = G__48702;
i__48246_48672 = G__48703;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_48667);
}
}


var G__48704 = seq__48213_48661;
var G__48705 = chunk__48215_48662;
var G__48706 = count__48216_48663;
var G__48707 = (i__48217_48664 + (1));
seq__48213_48661 = G__48704;
chunk__48215_48662 = G__48705;
count__48216_48663 = G__48706;
i__48217_48664 = G__48707;
continue;
} else {
var G__48708 = seq__48213_48661;
var G__48709 = chunk__48215_48662;
var G__48710 = count__48216_48663;
var G__48711 = (i__48217_48664 + (1));
seq__48213_48661 = G__48708;
chunk__48215_48662 = G__48709;
count__48216_48663 = G__48710;
i__48217_48664 = G__48711;
continue;
}
} else {
var temp__5804__auto___48712 = cljs.core.seq(seq__48213_48661);
if(temp__5804__auto___48712){
var seq__48213_48713__$1 = temp__5804__auto___48712;
if(cljs.core.chunked_seq_QMARK_(seq__48213_48713__$1)){
var c__4679__auto___48714 = cljs.core.chunk_first(seq__48213_48713__$1);
var G__48715 = cljs.core.chunk_rest(seq__48213_48713__$1);
var G__48716 = c__4679__auto___48714;
var G__48717 = cljs.core.count(c__4679__auto___48714);
var G__48718 = (0);
seq__48213_48661 = G__48715;
chunk__48215_48662 = G__48716;
count__48216_48663 = G__48717;
i__48217_48664 = G__48718;
continue;
} else {
var child_struct_48719 = cljs.core.first(seq__48213_48713__$1);
if((!((child_struct_48719 == null)))){
if(typeof child_struct_48719 === 'string'){
var text_48720 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_48720),child_struct_48719].join(''));
} else {
var children_48721 = shadow.dom.svg_node(child_struct_48719);
if(cljs.core.seq_QMARK_(children_48721)){
var seq__48266_48722 = cljs.core.seq(children_48721);
var chunk__48268_48723 = null;
var count__48269_48724 = (0);
var i__48270_48725 = (0);
while(true){
if((i__48270_48725 < count__48269_48724)){
var child_48726 = chunk__48268_48723.cljs$core$IIndexed$_nth$arity$2(null,i__48270_48725);
if(cljs.core.truth_(child_48726)){
node.appendChild(child_48726);


var G__48731 = seq__48266_48722;
var G__48732 = chunk__48268_48723;
var G__48733 = count__48269_48724;
var G__48734 = (i__48270_48725 + (1));
seq__48266_48722 = G__48731;
chunk__48268_48723 = G__48732;
count__48269_48724 = G__48733;
i__48270_48725 = G__48734;
continue;
} else {
var G__48735 = seq__48266_48722;
var G__48736 = chunk__48268_48723;
var G__48737 = count__48269_48724;
var G__48738 = (i__48270_48725 + (1));
seq__48266_48722 = G__48735;
chunk__48268_48723 = G__48736;
count__48269_48724 = G__48737;
i__48270_48725 = G__48738;
continue;
}
} else {
var temp__5804__auto___48739__$1 = cljs.core.seq(seq__48266_48722);
if(temp__5804__auto___48739__$1){
var seq__48266_48740__$1 = temp__5804__auto___48739__$1;
if(cljs.core.chunked_seq_QMARK_(seq__48266_48740__$1)){
var c__4679__auto___48741 = cljs.core.chunk_first(seq__48266_48740__$1);
var G__48742 = cljs.core.chunk_rest(seq__48266_48740__$1);
var G__48743 = c__4679__auto___48741;
var G__48744 = cljs.core.count(c__4679__auto___48741);
var G__48745 = (0);
seq__48266_48722 = G__48742;
chunk__48268_48723 = G__48743;
count__48269_48724 = G__48744;
i__48270_48725 = G__48745;
continue;
} else {
var child_48746 = cljs.core.first(seq__48266_48740__$1);
if(cljs.core.truth_(child_48746)){
node.appendChild(child_48746);


var G__48747 = cljs.core.next(seq__48266_48740__$1);
var G__48748 = null;
var G__48749 = (0);
var G__48750 = (0);
seq__48266_48722 = G__48747;
chunk__48268_48723 = G__48748;
count__48269_48724 = G__48749;
i__48270_48725 = G__48750;
continue;
} else {
var G__48751 = cljs.core.next(seq__48266_48740__$1);
var G__48752 = null;
var G__48753 = (0);
var G__48754 = (0);
seq__48266_48722 = G__48751;
chunk__48268_48723 = G__48752;
count__48269_48724 = G__48753;
i__48270_48725 = G__48754;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_48721);
}
}


var G__48755 = cljs.core.next(seq__48213_48713__$1);
var G__48756 = null;
var G__48757 = (0);
var G__48758 = (0);
seq__48213_48661 = G__48755;
chunk__48215_48662 = G__48756;
count__48216_48663 = G__48757;
i__48217_48664 = G__48758;
continue;
} else {
var G__48759 = cljs.core.next(seq__48213_48713__$1);
var G__48760 = null;
var G__48761 = (0);
var G__48762 = (0);
seq__48213_48661 = G__48759;
chunk__48215_48662 = G__48760;
count__48216_48663 = G__48761;
i__48217_48664 = G__48762;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4870__auto__ = [];
var len__4864__auto___48767 = arguments.length;
var i__4865__auto___48768 = (0);
while(true){
if((i__4865__auto___48768 < len__4864__auto___48767)){
args__4870__auto__.push((arguments[i__4865__auto___48768]));

var G__48769 = (i__4865__auto___48768 + (1));
i__4865__auto___48768 = G__48769;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq48289){
var G__48290 = cljs.core.first(seq48289);
var seq48289__$1 = cljs.core.next(seq48289);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__48290,seq48289__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__48299 = arguments.length;
switch (G__48299) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4251__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4251__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4251__auto__;
}
})())){
var c__44127__auto___48784 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44128__auto__ = (function (){var switch__43957__auto__ = (function (state_48319){
var state_val_48320 = (state_48319[(1)]);
if((state_val_48320 === (1))){
var state_48319__$1 = state_48319;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48319__$1,(2),once_or_cleanup);
} else {
if((state_val_48320 === (2))){
var inst_48313 = (state_48319[(2)]);
var inst_48317 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_48319__$1 = (function (){var statearr_48340 = state_48319;
(statearr_48340[(7)] = inst_48313);

return statearr_48340;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_48319__$1,inst_48317);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__43958__auto__ = null;
var shadow$dom$state_machine__43958__auto____0 = (function (){
var statearr_48341 = [null,null,null,null,null,null,null,null];
(statearr_48341[(0)] = shadow$dom$state_machine__43958__auto__);

(statearr_48341[(1)] = (1));

return statearr_48341;
});
var shadow$dom$state_machine__43958__auto____1 = (function (state_48319){
while(true){
var ret_value__43959__auto__ = (function (){try{while(true){
var result__43960__auto__ = switch__43957__auto__(state_48319);
if(cljs.core.keyword_identical_QMARK_(result__43960__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43960__auto__;
}
break;
}
}catch (e48342){var ex__43961__auto__ = e48342;
var statearr_48343_48785 = state_48319;
(statearr_48343_48785[(2)] = ex__43961__auto__);


if(cljs.core.seq((state_48319[(4)]))){
var statearr_48344_48786 = state_48319;
(statearr_48344_48786[(1)] = cljs.core.first((state_48319[(4)])));

} else {
throw ex__43961__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43959__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48787 = state_48319;
state_48319 = G__48787;
continue;
} else {
return ret_value__43959__auto__;
}
break;
}
});
shadow$dom$state_machine__43958__auto__ = function(state_48319){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__43958__auto____0.call(this);
case 1:
return shadow$dom$state_machine__43958__auto____1.call(this,state_48319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__43958__auto____0;
shadow$dom$state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__43958__auto____1;
return shadow$dom$state_machine__43958__auto__;
})()
})();
var state__44129__auto__ = (function (){var statearr_48352 = f__44128__auto__();
(statearr_48352[(6)] = c__44127__auto___48784);

return statearr_48352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44129__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
