goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__44246 = arguments.length;
switch (G__44246) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44259 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44259 = (function (f,blockable,meta44260){
this.f = f;
this.blockable = blockable;
this.meta44260 = meta44260;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44259.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44261,meta44260__$1){
var self__ = this;
var _44261__$1 = this;
return (new cljs.core.async.t_cljs$core$async44259(self__.f,self__.blockable,meta44260__$1));
}));

(cljs.core.async.t_cljs$core$async44259.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44261){
var self__ = this;
var _44261__$1 = this;
return self__.meta44260;
}));

(cljs.core.async.t_cljs$core$async44259.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44259.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44259.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async44259.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async44259.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta44260","meta44260",78715620,null)], null);
}));

(cljs.core.async.t_cljs$core$async44259.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44259.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44259");

(cljs.core.async.t_cljs$core$async44259.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async44259");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44259.
 */
cljs.core.async.__GT_t_cljs$core$async44259 = (function cljs$core$async$__GT_t_cljs$core$async44259(f__$1,blockable__$1,meta44260){
return (new cljs.core.async.t_cljs$core$async44259(f__$1,blockable__$1,meta44260));
});

}

return (new cljs.core.async.t_cljs$core$async44259(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__44304 = arguments.length;
switch (G__44304) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__44317 = arguments.length;
switch (G__44317) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__44330 = arguments.length;
switch (G__44330) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_47144 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_47144) : fn1.call(null,val_47144));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_47144) : fn1.call(null,val_47144));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__44351 = arguments.length;
switch (G__44351) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4741__auto___47155 = n;
var x_47156 = (0);
while(true){
if((x_47156 < n__4741__auto___47155)){
(a[x_47156] = x_47156);

var G__47158 = (x_47156 + (1));
x_47156 = G__47158;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44362 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44362 = (function (flag,meta44363){
this.flag = flag;
this.meta44363 = meta44363;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44362.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44364,meta44363__$1){
var self__ = this;
var _44364__$1 = this;
return (new cljs.core.async.t_cljs$core$async44362(self__.flag,meta44363__$1));
}));

(cljs.core.async.t_cljs$core$async44362.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44364){
var self__ = this;
var _44364__$1 = this;
return self__.meta44363;
}));

(cljs.core.async.t_cljs$core$async44362.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44362.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async44362.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44362.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async44362.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta44363","meta44363",-912807115,null)], null);
}));

(cljs.core.async.t_cljs$core$async44362.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44362.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44362");

(cljs.core.async.t_cljs$core$async44362.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async44362");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44362.
 */
cljs.core.async.__GT_t_cljs$core$async44362 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async44362(flag__$1,meta44363){
return (new cljs.core.async.t_cljs$core$async44362(flag__$1,meta44363));
});

}

return (new cljs.core.async.t_cljs$core$async44362(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44383 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44383 = (function (flag,cb,meta44384){
this.flag = flag;
this.cb = cb;
this.meta44384 = meta44384;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44383.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44385,meta44384__$1){
var self__ = this;
var _44385__$1 = this;
return (new cljs.core.async.t_cljs$core$async44383(self__.flag,self__.cb,meta44384__$1));
}));

(cljs.core.async.t_cljs$core$async44383.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44385){
var self__ = this;
var _44385__$1 = this;
return self__.meta44384;
}));

(cljs.core.async.t_cljs$core$async44383.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44383.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async44383.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44383.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async44383.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta44384","meta44384",998829532,null)], null);
}));

(cljs.core.async.t_cljs$core$async44383.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44383.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44383");

(cljs.core.async.t_cljs$core$async44383.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async44383");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44383.
 */
cljs.core.async.__GT_t_cljs$core$async44383 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async44383(flag__$1,cb__$1,meta44384){
return (new cljs.core.async.t_cljs$core$async44383(flag__$1,cb__$1,meta44384));
});

}

return (new cljs.core.async.t_cljs$core$async44383(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__44419_SHARP_){
var G__44429 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__44419_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__44429) : fret.call(null,G__44429));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__44420_SHARP_){
var G__44436 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__44420_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__44436) : fret.call(null,G__44436));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4253__auto__ = wport;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return port;
}
})()], null));
} else {
var G__47205 = (i + (1));
i = G__47205;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4253__auto__ = ret;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__4251__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4251__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___47209 = arguments.length;
var i__4865__auto___47210 = (0);
while(true){
if((i__4865__auto___47210 < len__4864__auto___47209)){
args__4870__auto__.push((arguments[i__4865__auto___47210]));

var G__47211 = (i__4865__auto___47210 + (1));
i__4865__auto___47210 = G__47211;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__44440){
var map__44441 = p__44440;
var map__44441__$1 = cljs.core.__destructure_map(map__44441);
var opts = map__44441__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq44438){
var G__44439 = cljs.core.first(seq44438);
var seq44438__$1 = cljs.core.next(seq44438);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44439,seq44438__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__44445 = arguments.length;
switch (G__44445) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__44127__auto___47235 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44128__auto__ = (function (){var switch__43957__auto__ = (function (state_44480){
var state_val_44481 = (state_44480[(1)]);
if((state_val_44481 === (7))){
var inst_44474 = (state_44480[(2)]);
var state_44480__$1 = state_44480;
var statearr_44488_47236 = state_44480__$1;
(statearr_44488_47236[(2)] = inst_44474);

(statearr_44488_47236[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44481 === (1))){
var state_44480__$1 = state_44480;
var statearr_44489_47242 = state_44480__$1;
(statearr_44489_47242[(2)] = null);

(statearr_44489_47242[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44481 === (4))){
var inst_44454 = (state_44480[(7)]);
var inst_44454__$1 = (state_44480[(2)]);
var inst_44458 = (inst_44454__$1 == null);
var state_44480__$1 = (function (){var statearr_44490 = state_44480;
(statearr_44490[(7)] = inst_44454__$1);

return statearr_44490;
})();
if(cljs.core.truth_(inst_44458)){
var statearr_44491_47243 = state_44480__$1;
(statearr_44491_47243[(1)] = (5));

} else {
var statearr_44492_47244 = state_44480__$1;
(statearr_44492_47244[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44481 === (13))){
var state_44480__$1 = state_44480;
var statearr_44495_47245 = state_44480__$1;
(statearr_44495_47245[(2)] = null);

(statearr_44495_47245[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44481 === (6))){
var inst_44454 = (state_44480[(7)]);
var state_44480__$1 = state_44480;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44480__$1,(11),to,inst_44454);
} else {
if((state_val_44481 === (3))){
var inst_44476 = (state_44480[(2)]);
var state_44480__$1 = state_44480;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44480__$1,inst_44476);
} else {
if((state_val_44481 === (12))){
var state_44480__$1 = state_44480;
var statearr_44503_47247 = state_44480__$1;
(statearr_44503_47247[(2)] = null);

(statearr_44503_47247[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44481 === (2))){
var state_44480__$1 = state_44480;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44480__$1,(4),from);
} else {
if((state_val_44481 === (11))){
var inst_44467 = (state_44480[(2)]);
var state_44480__$1 = state_44480;
if(cljs.core.truth_(inst_44467)){
var statearr_44505_47249 = state_44480__$1;
(statearr_44505_47249[(1)] = (12));

} else {
var statearr_44506_47252 = state_44480__$1;
(statearr_44506_47252[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44481 === (9))){
var state_44480__$1 = state_44480;
var statearr_44507_47254 = state_44480__$1;
(statearr_44507_47254[(2)] = null);

(statearr_44507_47254[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44481 === (5))){
var state_44480__$1 = state_44480;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44508_47256 = state_44480__$1;
(statearr_44508_47256[(1)] = (8));

} else {
var statearr_44509_47257 = state_44480__$1;
(statearr_44509_47257[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44481 === (14))){
var inst_44472 = (state_44480[(2)]);
var state_44480__$1 = state_44480;
var statearr_44511_47258 = state_44480__$1;
(statearr_44511_47258[(2)] = inst_44472);

(statearr_44511_47258[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44481 === (10))){
var inst_44464 = (state_44480[(2)]);
var state_44480__$1 = state_44480;
var statearr_44512_47259 = state_44480__$1;
(statearr_44512_47259[(2)] = inst_44464);

(statearr_44512_47259[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44481 === (8))){
var inst_44461 = cljs.core.async.close_BANG_(to);
var state_44480__$1 = state_44480;
var statearr_44513_47260 = state_44480__$1;
(statearr_44513_47260[(2)] = inst_44461);

(statearr_44513_47260[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43958__auto__ = null;
var cljs$core$async$state_machine__43958__auto____0 = (function (){
var statearr_44514 = [null,null,null,null,null,null,null,null];
(statearr_44514[(0)] = cljs$core$async$state_machine__43958__auto__);

(statearr_44514[(1)] = (1));

return statearr_44514;
});
var cljs$core$async$state_machine__43958__auto____1 = (function (state_44480){
while(true){
var ret_value__43959__auto__ = (function (){try{while(true){
var result__43960__auto__ = switch__43957__auto__(state_44480);
if(cljs.core.keyword_identical_QMARK_(result__43960__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43960__auto__;
}
break;
}
}catch (e44515){var ex__43961__auto__ = e44515;
var statearr_44516_47266 = state_44480;
(statearr_44516_47266[(2)] = ex__43961__auto__);


if(cljs.core.seq((state_44480[(4)]))){
var statearr_44517_47268 = state_44480;
(statearr_44517_47268[(1)] = cljs.core.first((state_44480[(4)])));

} else {
throw ex__43961__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43959__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47270 = state_44480;
state_44480 = G__47270;
continue;
} else {
return ret_value__43959__auto__;
}
break;
}
});
cljs$core$async$state_machine__43958__auto__ = function(state_44480){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43958__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43958__auto____1.call(this,state_44480);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43958__auto____0;
cljs$core$async$state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43958__auto____1;
return cljs$core$async$state_machine__43958__auto__;
})()
})();
var state__44129__auto__ = (function (){var statearr_44519 = f__44128__auto__();
(statearr_44519[(6)] = c__44127__auto___47235);

return statearr_44519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44129__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__44531){
var vec__44532 = p__44531;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44532,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44532,(1),null);
var job = vec__44532;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__44127__auto___47285 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44128__auto__ = (function (){var switch__43957__auto__ = (function (state_44539){
var state_val_44540 = (state_44539[(1)]);
if((state_val_44540 === (1))){
var state_44539__$1 = state_44539;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44539__$1,(2),res,v);
} else {
if((state_val_44540 === (2))){
var inst_44536 = (state_44539[(2)]);
var inst_44537 = cljs.core.async.close_BANG_(res);
var state_44539__$1 = (function (){var statearr_44552 = state_44539;
(statearr_44552[(7)] = inst_44536);

return statearr_44552;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_44539__$1,inst_44537);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____0 = (function (){
var statearr_44557 = [null,null,null,null,null,null,null,null];
(statearr_44557[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__);

(statearr_44557[(1)] = (1));

return statearr_44557;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____1 = (function (state_44539){
while(true){
var ret_value__43959__auto__ = (function (){try{while(true){
var result__43960__auto__ = switch__43957__auto__(state_44539);
if(cljs.core.keyword_identical_QMARK_(result__43960__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43960__auto__;
}
break;
}
}catch (e44558){var ex__43961__auto__ = e44558;
var statearr_44559_47300 = state_44539;
(statearr_44559_47300[(2)] = ex__43961__auto__);


if(cljs.core.seq((state_44539[(4)]))){
var statearr_44560_47301 = state_44539;
(statearr_44560_47301[(1)] = cljs.core.first((state_44539[(4)])));

} else {
throw ex__43961__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43959__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47304 = state_44539;
state_44539 = G__47304;
continue;
} else {
return ret_value__43959__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__ = function(state_44539){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____1.call(this,state_44539);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__;
})()
})();
var state__44129__auto__ = (function (){var statearr_44561 = f__44128__auto__();
(statearr_44561[(6)] = c__44127__auto___47285);

return statearr_44561;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44129__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__44562){
var vec__44563 = p__44562;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44563,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44563,(1),null);
var job = vec__44563;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4741__auto___47308 = n;
var __47310 = (0);
while(true){
if((__47310 < n__4741__auto___47308)){
var G__44567_47311 = type;
var G__44567_47312__$1 = (((G__44567_47311 instanceof cljs.core.Keyword))?G__44567_47311.fqn:null);
switch (G__44567_47312__$1) {
case "compute":
var c__44127__auto___47316 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__47310,c__44127__auto___47316,G__44567_47311,G__44567_47312__$1,n__4741__auto___47308,jobs,results,process,async){
return (function (){
var f__44128__auto__ = (function (){var switch__43957__auto__ = ((function (__47310,c__44127__auto___47316,G__44567_47311,G__44567_47312__$1,n__4741__auto___47308,jobs,results,process,async){
return (function (state_44584){
var state_val_44585 = (state_44584[(1)]);
if((state_val_44585 === (1))){
var state_44584__$1 = state_44584;
var statearr_44587_47317 = state_44584__$1;
(statearr_44587_47317[(2)] = null);

(statearr_44587_47317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44585 === (2))){
var state_44584__$1 = state_44584;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44584__$1,(4),jobs);
} else {
if((state_val_44585 === (3))){
var inst_44582 = (state_44584[(2)]);
var state_44584__$1 = state_44584;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44584__$1,inst_44582);
} else {
if((state_val_44585 === (4))){
var inst_44570 = (state_44584[(2)]);
var inst_44571 = process(inst_44570);
var state_44584__$1 = state_44584;
if(cljs.core.truth_(inst_44571)){
var statearr_44588_47326 = state_44584__$1;
(statearr_44588_47326[(1)] = (5));

} else {
var statearr_44589_47327 = state_44584__$1;
(statearr_44589_47327[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44585 === (5))){
var state_44584__$1 = state_44584;
var statearr_44592_47329 = state_44584__$1;
(statearr_44592_47329[(2)] = null);

(statearr_44592_47329[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44585 === (6))){
var state_44584__$1 = state_44584;
var statearr_44594_47330 = state_44584__$1;
(statearr_44594_47330[(2)] = null);

(statearr_44594_47330[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44585 === (7))){
var inst_44580 = (state_44584[(2)]);
var state_44584__$1 = state_44584;
var statearr_44599_47333 = state_44584__$1;
(statearr_44599_47333[(2)] = inst_44580);

(statearr_44599_47333[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__47310,c__44127__auto___47316,G__44567_47311,G__44567_47312__$1,n__4741__auto___47308,jobs,results,process,async))
;
return ((function (__47310,switch__43957__auto__,c__44127__auto___47316,G__44567_47311,G__44567_47312__$1,n__4741__auto___47308,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____0 = (function (){
var statearr_44600 = [null,null,null,null,null,null,null];
(statearr_44600[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__);

(statearr_44600[(1)] = (1));

return statearr_44600;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____1 = (function (state_44584){
while(true){
var ret_value__43959__auto__ = (function (){try{while(true){
var result__43960__auto__ = switch__43957__auto__(state_44584);
if(cljs.core.keyword_identical_QMARK_(result__43960__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43960__auto__;
}
break;
}
}catch (e44601){var ex__43961__auto__ = e44601;
var statearr_44602_47345 = state_44584;
(statearr_44602_47345[(2)] = ex__43961__auto__);


if(cljs.core.seq((state_44584[(4)]))){
var statearr_44603_47346 = state_44584;
(statearr_44603_47346[(1)] = cljs.core.first((state_44584[(4)])));

} else {
throw ex__43961__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43959__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47347 = state_44584;
state_44584 = G__47347;
continue;
} else {
return ret_value__43959__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__ = function(state_44584){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____1.call(this,state_44584);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__;
})()
;})(__47310,switch__43957__auto__,c__44127__auto___47316,G__44567_47311,G__44567_47312__$1,n__4741__auto___47308,jobs,results,process,async))
})();
var state__44129__auto__ = (function (){var statearr_44607 = f__44128__auto__();
(statearr_44607[(6)] = c__44127__auto___47316);

return statearr_44607;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44129__auto__);
});})(__47310,c__44127__auto___47316,G__44567_47311,G__44567_47312__$1,n__4741__auto___47308,jobs,results,process,async))
);


break;
case "async":
var c__44127__auto___47352 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__47310,c__44127__auto___47352,G__44567_47311,G__44567_47312__$1,n__4741__auto___47308,jobs,results,process,async){
return (function (){
var f__44128__auto__ = (function (){var switch__43957__auto__ = ((function (__47310,c__44127__auto___47352,G__44567_47311,G__44567_47312__$1,n__4741__auto___47308,jobs,results,process,async){
return (function (state_44623){
var state_val_44624 = (state_44623[(1)]);
if((state_val_44624 === (1))){
var state_44623__$1 = state_44623;
var statearr_44626_47354 = state_44623__$1;
(statearr_44626_47354[(2)] = null);

(statearr_44626_47354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44624 === (2))){
var state_44623__$1 = state_44623;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44623__$1,(4),jobs);
} else {
if((state_val_44624 === (3))){
var inst_44621 = (state_44623[(2)]);
var state_44623__$1 = state_44623;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44623__$1,inst_44621);
} else {
if((state_val_44624 === (4))){
var inst_44611 = (state_44623[(2)]);
var inst_44612 = async(inst_44611);
var state_44623__$1 = state_44623;
if(cljs.core.truth_(inst_44612)){
var statearr_44628_47355 = state_44623__$1;
(statearr_44628_47355[(1)] = (5));

} else {
var statearr_44629_47356 = state_44623__$1;
(statearr_44629_47356[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44624 === (5))){
var state_44623__$1 = state_44623;
var statearr_44630_47358 = state_44623__$1;
(statearr_44630_47358[(2)] = null);

(statearr_44630_47358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44624 === (6))){
var state_44623__$1 = state_44623;
var statearr_44633_47359 = state_44623__$1;
(statearr_44633_47359[(2)] = null);

(statearr_44633_47359[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44624 === (7))){
var inst_44617 = (state_44623[(2)]);
var state_44623__$1 = state_44623;
var statearr_44638_47360 = state_44623__$1;
(statearr_44638_47360[(2)] = inst_44617);

(statearr_44638_47360[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__47310,c__44127__auto___47352,G__44567_47311,G__44567_47312__$1,n__4741__auto___47308,jobs,results,process,async))
;
return ((function (__47310,switch__43957__auto__,c__44127__auto___47352,G__44567_47311,G__44567_47312__$1,n__4741__auto___47308,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____0 = (function (){
var statearr_44639 = [null,null,null,null,null,null,null];
(statearr_44639[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__);

(statearr_44639[(1)] = (1));

return statearr_44639;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____1 = (function (state_44623){
while(true){
var ret_value__43959__auto__ = (function (){try{while(true){
var result__43960__auto__ = switch__43957__auto__(state_44623);
if(cljs.core.keyword_identical_QMARK_(result__43960__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43960__auto__;
}
break;
}
}catch (e44640){var ex__43961__auto__ = e44640;
var statearr_44641_47363 = state_44623;
(statearr_44641_47363[(2)] = ex__43961__auto__);


if(cljs.core.seq((state_44623[(4)]))){
var statearr_44643_47364 = state_44623;
(statearr_44643_47364[(1)] = cljs.core.first((state_44623[(4)])));

} else {
throw ex__43961__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43959__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47365 = state_44623;
state_44623 = G__47365;
continue;
} else {
return ret_value__43959__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__ = function(state_44623){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____1.call(this,state_44623);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__;
})()
;})(__47310,switch__43957__auto__,c__44127__auto___47352,G__44567_47311,G__44567_47312__$1,n__4741__auto___47308,jobs,results,process,async))
})();
var state__44129__auto__ = (function (){var statearr_44644 = f__44128__auto__();
(statearr_44644[(6)] = c__44127__auto___47352);

return statearr_44644;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44129__auto__);
});})(__47310,c__44127__auto___47352,G__44567_47311,G__44567_47312__$1,n__4741__auto___47308,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__44567_47312__$1)].join('')));

}

var G__47368 = (__47310 + (1));
__47310 = G__47368;
continue;
} else {
}
break;
}

var c__44127__auto___47369 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44128__auto__ = (function (){var switch__43957__auto__ = (function (state_44666){
var state_val_44667 = (state_44666[(1)]);
if((state_val_44667 === (7))){
var inst_44662 = (state_44666[(2)]);
var state_44666__$1 = state_44666;
var statearr_44679_47371 = state_44666__$1;
(statearr_44679_47371[(2)] = inst_44662);

(statearr_44679_47371[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44667 === (1))){
var state_44666__$1 = state_44666;
var statearr_44680_47372 = state_44666__$1;
(statearr_44680_47372[(2)] = null);

(statearr_44680_47372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44667 === (4))){
var inst_44647 = (state_44666[(7)]);
var inst_44647__$1 = (state_44666[(2)]);
var inst_44648 = (inst_44647__$1 == null);
var state_44666__$1 = (function (){var statearr_44681 = state_44666;
(statearr_44681[(7)] = inst_44647__$1);

return statearr_44681;
})();
if(cljs.core.truth_(inst_44648)){
var statearr_44682_47373 = state_44666__$1;
(statearr_44682_47373[(1)] = (5));

} else {
var statearr_44683_47374 = state_44666__$1;
(statearr_44683_47374[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44667 === (6))){
var inst_44647 = (state_44666[(7)]);
var inst_44652 = (state_44666[(8)]);
var inst_44652__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_44653 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44654 = [inst_44647,inst_44652__$1];
var inst_44655 = (new cljs.core.PersistentVector(null,2,(5),inst_44653,inst_44654,null));
var state_44666__$1 = (function (){var statearr_44684 = state_44666;
(statearr_44684[(8)] = inst_44652__$1);

return statearr_44684;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44666__$1,(8),jobs,inst_44655);
} else {
if((state_val_44667 === (3))){
var inst_44664 = (state_44666[(2)]);
var state_44666__$1 = state_44666;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44666__$1,inst_44664);
} else {
if((state_val_44667 === (2))){
var state_44666__$1 = state_44666;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44666__$1,(4),from);
} else {
if((state_val_44667 === (9))){
var inst_44659 = (state_44666[(2)]);
var state_44666__$1 = (function (){var statearr_44685 = state_44666;
(statearr_44685[(9)] = inst_44659);

return statearr_44685;
})();
var statearr_44692_47384 = state_44666__$1;
(statearr_44692_47384[(2)] = null);

(statearr_44692_47384[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44667 === (5))){
var inst_44650 = cljs.core.async.close_BANG_(jobs);
var state_44666__$1 = state_44666;
var statearr_44693_47389 = state_44666__$1;
(statearr_44693_47389[(2)] = inst_44650);

(statearr_44693_47389[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44667 === (8))){
var inst_44652 = (state_44666[(8)]);
var inst_44657 = (state_44666[(2)]);
var state_44666__$1 = (function (){var statearr_44698 = state_44666;
(statearr_44698[(10)] = inst_44657);

return statearr_44698;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44666__$1,(9),results,inst_44652);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____0 = (function (){
var statearr_44699 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44699[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__);

(statearr_44699[(1)] = (1));

return statearr_44699;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____1 = (function (state_44666){
while(true){
var ret_value__43959__auto__ = (function (){try{while(true){
var result__43960__auto__ = switch__43957__auto__(state_44666);
if(cljs.core.keyword_identical_QMARK_(result__43960__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43960__auto__;
}
break;
}
}catch (e44700){var ex__43961__auto__ = e44700;
var statearr_44701_47390 = state_44666;
(statearr_44701_47390[(2)] = ex__43961__auto__);


if(cljs.core.seq((state_44666[(4)]))){
var statearr_44702_47391 = state_44666;
(statearr_44702_47391[(1)] = cljs.core.first((state_44666[(4)])));

} else {
throw ex__43961__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43959__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47392 = state_44666;
state_44666 = G__47392;
continue;
} else {
return ret_value__43959__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__ = function(state_44666){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____1.call(this,state_44666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__;
})()
})();
var state__44129__auto__ = (function (){var statearr_44703 = f__44128__auto__();
(statearr_44703[(6)] = c__44127__auto___47369);

return statearr_44703;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44129__auto__);
}));


var c__44127__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44128__auto__ = (function (){var switch__43957__auto__ = (function (state_44755){
var state_val_44756 = (state_44755[(1)]);
if((state_val_44756 === (7))){
var inst_44748 = (state_44755[(2)]);
var state_44755__$1 = state_44755;
var statearr_44757_47393 = state_44755__$1;
(statearr_44757_47393[(2)] = inst_44748);

(statearr_44757_47393[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44756 === (20))){
var state_44755__$1 = state_44755;
var statearr_44758_47394 = state_44755__$1;
(statearr_44758_47394[(2)] = null);

(statearr_44758_47394[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44756 === (1))){
var state_44755__$1 = state_44755;
var statearr_44759_47395 = state_44755__$1;
(statearr_44759_47395[(2)] = null);

(statearr_44759_47395[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44756 === (4))){
var inst_44709 = (state_44755[(7)]);
var inst_44709__$1 = (state_44755[(2)]);
var inst_44710 = (inst_44709__$1 == null);
var state_44755__$1 = (function (){var statearr_44761 = state_44755;
(statearr_44761[(7)] = inst_44709__$1);

return statearr_44761;
})();
if(cljs.core.truth_(inst_44710)){
var statearr_44763_47396 = state_44755__$1;
(statearr_44763_47396[(1)] = (5));

} else {
var statearr_44764_47397 = state_44755__$1;
(statearr_44764_47397[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44756 === (15))){
var inst_44730 = (state_44755[(8)]);
var state_44755__$1 = state_44755;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44755__$1,(18),to,inst_44730);
} else {
if((state_val_44756 === (21))){
var inst_44743 = (state_44755[(2)]);
var state_44755__$1 = state_44755;
var statearr_44766_47398 = state_44755__$1;
(statearr_44766_47398[(2)] = inst_44743);

(statearr_44766_47398[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44756 === (13))){
var inst_44745 = (state_44755[(2)]);
var state_44755__$1 = (function (){var statearr_44767 = state_44755;
(statearr_44767[(9)] = inst_44745);

return statearr_44767;
})();
var statearr_44768_47399 = state_44755__$1;
(statearr_44768_47399[(2)] = null);

(statearr_44768_47399[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44756 === (6))){
var inst_44709 = (state_44755[(7)]);
var state_44755__$1 = state_44755;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44755__$1,(11),inst_44709);
} else {
if((state_val_44756 === (17))){
var inst_44738 = (state_44755[(2)]);
var state_44755__$1 = state_44755;
if(cljs.core.truth_(inst_44738)){
var statearr_44769_47405 = state_44755__$1;
(statearr_44769_47405[(1)] = (19));

} else {
var statearr_44770_47409 = state_44755__$1;
(statearr_44770_47409[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44756 === (3))){
var inst_44750 = (state_44755[(2)]);
var state_44755__$1 = state_44755;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44755__$1,inst_44750);
} else {
if((state_val_44756 === (12))){
var inst_44727 = (state_44755[(10)]);
var state_44755__$1 = state_44755;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44755__$1,(14),inst_44727);
} else {
if((state_val_44756 === (2))){
var state_44755__$1 = state_44755;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44755__$1,(4),results);
} else {
if((state_val_44756 === (19))){
var state_44755__$1 = state_44755;
var statearr_44771_47413 = state_44755__$1;
(statearr_44771_47413[(2)] = null);

(statearr_44771_47413[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44756 === (11))){
var inst_44727 = (state_44755[(2)]);
var state_44755__$1 = (function (){var statearr_44776 = state_44755;
(statearr_44776[(10)] = inst_44727);

return statearr_44776;
})();
var statearr_44786_47417 = state_44755__$1;
(statearr_44786_47417[(2)] = null);

(statearr_44786_47417[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44756 === (9))){
var state_44755__$1 = state_44755;
var statearr_44787_47419 = state_44755__$1;
(statearr_44787_47419[(2)] = null);

(statearr_44787_47419[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44756 === (5))){
var state_44755__$1 = state_44755;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44788_47420 = state_44755__$1;
(statearr_44788_47420[(1)] = (8));

} else {
var statearr_44789_47421 = state_44755__$1;
(statearr_44789_47421[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44756 === (14))){
var inst_44730 = (state_44755[(8)]);
var inst_44732 = (state_44755[(11)]);
var inst_44730__$1 = (state_44755[(2)]);
var inst_44731 = (inst_44730__$1 == null);
var inst_44732__$1 = cljs.core.not(inst_44731);
var state_44755__$1 = (function (){var statearr_44790 = state_44755;
(statearr_44790[(8)] = inst_44730__$1);

(statearr_44790[(11)] = inst_44732__$1);

return statearr_44790;
})();
if(inst_44732__$1){
var statearr_44791_47425 = state_44755__$1;
(statearr_44791_47425[(1)] = (15));

} else {
var statearr_44792_47426 = state_44755__$1;
(statearr_44792_47426[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44756 === (16))){
var inst_44732 = (state_44755[(11)]);
var state_44755__$1 = state_44755;
var statearr_44798_47427 = state_44755__$1;
(statearr_44798_47427[(2)] = inst_44732);

(statearr_44798_47427[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44756 === (10))){
var inst_44724 = (state_44755[(2)]);
var state_44755__$1 = state_44755;
var statearr_44799_47428 = state_44755__$1;
(statearr_44799_47428[(2)] = inst_44724);

(statearr_44799_47428[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44756 === (18))){
var inst_44735 = (state_44755[(2)]);
var state_44755__$1 = state_44755;
var statearr_44800_47429 = state_44755__$1;
(statearr_44800_47429[(2)] = inst_44735);

(statearr_44800_47429[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44756 === (8))){
var inst_44717 = cljs.core.async.close_BANG_(to);
var state_44755__$1 = state_44755;
var statearr_44801_47430 = state_44755__$1;
(statearr_44801_47430[(2)] = inst_44717);

(statearr_44801_47430[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____0 = (function (){
var statearr_44802 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44802[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__);

(statearr_44802[(1)] = (1));

return statearr_44802;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____1 = (function (state_44755){
while(true){
var ret_value__43959__auto__ = (function (){try{while(true){
var result__43960__auto__ = switch__43957__auto__(state_44755);
if(cljs.core.keyword_identical_QMARK_(result__43960__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43960__auto__;
}
break;
}
}catch (e44805){var ex__43961__auto__ = e44805;
var statearr_44806_47438 = state_44755;
(statearr_44806_47438[(2)] = ex__43961__auto__);


if(cljs.core.seq((state_44755[(4)]))){
var statearr_44807_47439 = state_44755;
(statearr_44807_47439[(1)] = cljs.core.first((state_44755[(4)])));

} else {
throw ex__43961__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43959__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47440 = state_44755;
state_44755 = G__47440;
continue;
} else {
return ret_value__43959__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__ = function(state_44755){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____1.call(this,state_44755);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43958__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43958__auto__;
})()
})();
var state__44129__auto__ = (function (){var statearr_44809 = f__44128__auto__();
(statearr_44809[(6)] = c__44127__auto__);

return statearr_44809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44129__auto__);
}));

return c__44127__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__44811 = arguments.length;
switch (G__44811) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__44813 = arguments.length;
switch (G__44813) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__44815 = arguments.length;
switch (G__44815) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__44127__auto___47456 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44128__auto__ = (function (){var switch__43957__auto__ = (function (state_44853){
var state_val_44854 = (state_44853[(1)]);
if((state_val_44854 === (7))){
var inst_44849 = (state_44853[(2)]);
var state_44853__$1 = state_44853;
var statearr_44859_47457 = state_44853__$1;
(statearr_44859_47457[(2)] = inst_44849);

(statearr_44859_47457[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44854 === (1))){
var state_44853__$1 = state_44853;
var statearr_44860_47458 = state_44853__$1;
(statearr_44860_47458[(2)] = null);

(statearr_44860_47458[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44854 === (4))){
var inst_44830 = (state_44853[(7)]);
var inst_44830__$1 = (state_44853[(2)]);
var inst_44831 = (inst_44830__$1 == null);
var state_44853__$1 = (function (){var statearr_44861 = state_44853;
(statearr_44861[(7)] = inst_44830__$1);

return statearr_44861;
})();
if(cljs.core.truth_(inst_44831)){
var statearr_44862_47459 = state_44853__$1;
(statearr_44862_47459[(1)] = (5));

} else {
var statearr_44863_47460 = state_44853__$1;
(statearr_44863_47460[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44854 === (13))){
var state_44853__$1 = state_44853;
var statearr_44864_47461 = state_44853__$1;
(statearr_44864_47461[(2)] = null);

(statearr_44864_47461[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44854 === (6))){
var inst_44830 = (state_44853[(7)]);
var inst_44836 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_44830) : p.call(null,inst_44830));
var state_44853__$1 = state_44853;
if(cljs.core.truth_(inst_44836)){
var statearr_44876_47462 = state_44853__$1;
(statearr_44876_47462[(1)] = (9));

} else {
var statearr_44884_47463 = state_44853__$1;
(statearr_44884_47463[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44854 === (3))){
var inst_44851 = (state_44853[(2)]);
var state_44853__$1 = state_44853;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44853__$1,inst_44851);
} else {
if((state_val_44854 === (12))){
var state_44853__$1 = state_44853;
var statearr_44885_47464 = state_44853__$1;
(statearr_44885_47464[(2)] = null);

(statearr_44885_47464[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44854 === (2))){
var state_44853__$1 = state_44853;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44853__$1,(4),ch);
} else {
if((state_val_44854 === (11))){
var inst_44830 = (state_44853[(7)]);
var inst_44840 = (state_44853[(2)]);
var state_44853__$1 = state_44853;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44853__$1,(8),inst_44840,inst_44830);
} else {
if((state_val_44854 === (9))){
var state_44853__$1 = state_44853;
var statearr_44896_47465 = state_44853__$1;
(statearr_44896_47465[(2)] = tc);

(statearr_44896_47465[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44854 === (5))){
var inst_44833 = cljs.core.async.close_BANG_(tc);
var inst_44834 = cljs.core.async.close_BANG_(fc);
var state_44853__$1 = (function (){var statearr_44897 = state_44853;
(statearr_44897[(8)] = inst_44833);

return statearr_44897;
})();
var statearr_44898_47466 = state_44853__$1;
(statearr_44898_47466[(2)] = inst_44834);

(statearr_44898_47466[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44854 === (14))){
var inst_44847 = (state_44853[(2)]);
var state_44853__$1 = state_44853;
var statearr_44899_47467 = state_44853__$1;
(statearr_44899_47467[(2)] = inst_44847);

(statearr_44899_47467[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44854 === (10))){
var state_44853__$1 = state_44853;
var statearr_44900_47468 = state_44853__$1;
(statearr_44900_47468[(2)] = fc);

(statearr_44900_47468[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44854 === (8))){
var inst_44842 = (state_44853[(2)]);
var state_44853__$1 = state_44853;
if(cljs.core.truth_(inst_44842)){
var statearr_44905_47469 = state_44853__$1;
(statearr_44905_47469[(1)] = (12));

} else {
var statearr_44910_47470 = state_44853__$1;
(statearr_44910_47470[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43958__auto__ = null;
var cljs$core$async$state_machine__43958__auto____0 = (function (){
var statearr_44915 = [null,null,null,null,null,null,null,null,null];
(statearr_44915[(0)] = cljs$core$async$state_machine__43958__auto__);

(statearr_44915[(1)] = (1));

return statearr_44915;
});
var cljs$core$async$state_machine__43958__auto____1 = (function (state_44853){
while(true){
var ret_value__43959__auto__ = (function (){try{while(true){
var result__43960__auto__ = switch__43957__auto__(state_44853);
if(cljs.core.keyword_identical_QMARK_(result__43960__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43960__auto__;
}
break;
}
}catch (e44919){var ex__43961__auto__ = e44919;
var statearr_44920_47471 = state_44853;
(statearr_44920_47471[(2)] = ex__43961__auto__);


if(cljs.core.seq((state_44853[(4)]))){
var statearr_44921_47472 = state_44853;
(statearr_44921_47472[(1)] = cljs.core.first((state_44853[(4)])));

} else {
throw ex__43961__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43959__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47473 = state_44853;
state_44853 = G__47473;
continue;
} else {
return ret_value__43959__auto__;
}
break;
}
});
cljs$core$async$state_machine__43958__auto__ = function(state_44853){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43958__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43958__auto____1.call(this,state_44853);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43958__auto____0;
cljs$core$async$state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43958__auto____1;
return cljs$core$async$state_machine__43958__auto__;
})()
})();
var state__44129__auto__ = (function (){var statearr_44926 = f__44128__auto__();
(statearr_44926[(6)] = c__44127__auto___47456);

return statearr_44926;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44129__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__44127__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44128__auto__ = (function (){var switch__43957__auto__ = (function (state_44957){
var state_val_44958 = (state_44957[(1)]);
if((state_val_44958 === (7))){
var inst_44953 = (state_44957[(2)]);
var state_44957__$1 = state_44957;
var statearr_44962_47474 = state_44957__$1;
(statearr_44962_47474[(2)] = inst_44953);

(statearr_44962_47474[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44958 === (1))){
var inst_44928 = init;
var inst_44932 = inst_44928;
var state_44957__$1 = (function (){var statearr_44963 = state_44957;
(statearr_44963[(7)] = inst_44932);

return statearr_44963;
})();
var statearr_44964_47475 = state_44957__$1;
(statearr_44964_47475[(2)] = null);

(statearr_44964_47475[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44958 === (4))){
var inst_44936 = (state_44957[(8)]);
var inst_44936__$1 = (state_44957[(2)]);
var inst_44937 = (inst_44936__$1 == null);
var state_44957__$1 = (function (){var statearr_44965 = state_44957;
(statearr_44965[(8)] = inst_44936__$1);

return statearr_44965;
})();
if(cljs.core.truth_(inst_44937)){
var statearr_44966_47477 = state_44957__$1;
(statearr_44966_47477[(1)] = (5));

} else {
var statearr_44967_47479 = state_44957__$1;
(statearr_44967_47479[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44958 === (6))){
var inst_44936 = (state_44957[(8)]);
var inst_44932 = (state_44957[(7)]);
var inst_44942 = (state_44957[(9)]);
var inst_44942__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_44932,inst_44936) : f.call(null,inst_44932,inst_44936));
var inst_44945 = cljs.core.reduced_QMARK_(inst_44942__$1);
var state_44957__$1 = (function (){var statearr_44968 = state_44957;
(statearr_44968[(9)] = inst_44942__$1);

return statearr_44968;
})();
if(inst_44945){
var statearr_44969_47484 = state_44957__$1;
(statearr_44969_47484[(1)] = (8));

} else {
var statearr_44970_47485 = state_44957__$1;
(statearr_44970_47485[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44958 === (3))){
var inst_44955 = (state_44957[(2)]);
var state_44957__$1 = state_44957;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44957__$1,inst_44955);
} else {
if((state_val_44958 === (2))){
var state_44957__$1 = state_44957;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44957__$1,(4),ch);
} else {
if((state_val_44958 === (9))){
var inst_44942 = (state_44957[(9)]);
var inst_44932 = inst_44942;
var state_44957__$1 = (function (){var statearr_44971 = state_44957;
(statearr_44971[(7)] = inst_44932);

return statearr_44971;
})();
var statearr_44972_47486 = state_44957__$1;
(statearr_44972_47486[(2)] = null);

(statearr_44972_47486[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44958 === (5))){
var inst_44932 = (state_44957[(7)]);
var state_44957__$1 = state_44957;
var statearr_44973_47487 = state_44957__$1;
(statearr_44973_47487[(2)] = inst_44932);

(statearr_44973_47487[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44958 === (10))){
var inst_44951 = (state_44957[(2)]);
var state_44957__$1 = state_44957;
var statearr_44977_47489 = state_44957__$1;
(statearr_44977_47489[(2)] = inst_44951);

(statearr_44977_47489[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44958 === (8))){
var inst_44942 = (state_44957[(9)]);
var inst_44947 = cljs.core.deref(inst_44942);
var state_44957__$1 = state_44957;
var statearr_44982_47490 = state_44957__$1;
(statearr_44982_47490[(2)] = inst_44947);

(statearr_44982_47490[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__43958__auto__ = null;
var cljs$core$async$reduce_$_state_machine__43958__auto____0 = (function (){
var statearr_44996 = [null,null,null,null,null,null,null,null,null,null];
(statearr_44996[(0)] = cljs$core$async$reduce_$_state_machine__43958__auto__);

(statearr_44996[(1)] = (1));

return statearr_44996;
});
var cljs$core$async$reduce_$_state_machine__43958__auto____1 = (function (state_44957){
while(true){
var ret_value__43959__auto__ = (function (){try{while(true){
var result__43960__auto__ = switch__43957__auto__(state_44957);
if(cljs.core.keyword_identical_QMARK_(result__43960__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43960__auto__;
}
break;
}
}catch (e45000){var ex__43961__auto__ = e45000;
var statearr_45005_47493 = state_44957;
(statearr_45005_47493[(2)] = ex__43961__auto__);


if(cljs.core.seq((state_44957[(4)]))){
var statearr_45006_47495 = state_44957;
(statearr_45006_47495[(1)] = cljs.core.first((state_44957[(4)])));

} else {
throw ex__43961__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43959__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47496 = state_44957;
state_44957 = G__47496;
continue;
} else {
return ret_value__43959__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__43958__auto__ = function(state_44957){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__43958__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__43958__auto____1.call(this,state_44957);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__43958__auto____0;
cljs$core$async$reduce_$_state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__43958__auto____1;
return cljs$core$async$reduce_$_state_machine__43958__auto__;
})()
})();
var state__44129__auto__ = (function (){var statearr_45010 = f__44128__auto__();
(statearr_45010[(6)] = c__44127__auto__);

return statearr_45010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44129__auto__);
}));

return c__44127__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__44127__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44128__auto__ = (function (){var switch__43957__auto__ = (function (state_45022){
var state_val_45023 = (state_45022[(1)]);
if((state_val_45023 === (1))){
var inst_45016 = cljs.core.async.reduce(f__$1,init,ch);
var state_45022__$1 = state_45022;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45022__$1,(2),inst_45016);
} else {
if((state_val_45023 === (2))){
var inst_45019 = (state_45022[(2)]);
var inst_45020 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_45019) : f__$1.call(null,inst_45019));
var state_45022__$1 = state_45022;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45022__$1,inst_45020);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__43958__auto__ = null;
var cljs$core$async$transduce_$_state_machine__43958__auto____0 = (function (){
var statearr_45029 = [null,null,null,null,null,null,null];
(statearr_45029[(0)] = cljs$core$async$transduce_$_state_machine__43958__auto__);

(statearr_45029[(1)] = (1));

return statearr_45029;
});
var cljs$core$async$transduce_$_state_machine__43958__auto____1 = (function (state_45022){
while(true){
var ret_value__43959__auto__ = (function (){try{while(true){
var result__43960__auto__ = switch__43957__auto__(state_45022);
if(cljs.core.keyword_identical_QMARK_(result__43960__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43960__auto__;
}
break;
}
}catch (e45033){var ex__43961__auto__ = e45033;
var statearr_45034_47513 = state_45022;
(statearr_45034_47513[(2)] = ex__43961__auto__);


if(cljs.core.seq((state_45022[(4)]))){
var statearr_45035_47520 = state_45022;
(statearr_45035_47520[(1)] = cljs.core.first((state_45022[(4)])));

} else {
throw ex__43961__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43959__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47521 = state_45022;
state_45022 = G__47521;
continue;
} else {
return ret_value__43959__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__43958__auto__ = function(state_45022){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__43958__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__43958__auto____1.call(this,state_45022);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__43958__auto____0;
cljs$core$async$transduce_$_state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__43958__auto____1;
return cljs$core$async$transduce_$_state_machine__43958__auto__;
})()
})();
var state__44129__auto__ = (function (){var statearr_45042 = f__44128__auto__();
(statearr_45042[(6)] = c__44127__auto__);

return statearr_45042;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44129__auto__);
}));

return c__44127__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__45047 = arguments.length;
switch (G__45047) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__44127__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44128__auto__ = (function (){var switch__43957__auto__ = (function (state_45077){
var state_val_45078 = (state_45077[(1)]);
if((state_val_45078 === (7))){
var inst_45059 = (state_45077[(2)]);
var state_45077__$1 = state_45077;
var statearr_45082_47524 = state_45077__$1;
(statearr_45082_47524[(2)] = inst_45059);

(statearr_45082_47524[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45078 === (1))){
var inst_45053 = cljs.core.seq(coll);
var inst_45054 = inst_45053;
var state_45077__$1 = (function (){var statearr_45083 = state_45077;
(statearr_45083[(7)] = inst_45054);

return statearr_45083;
})();
var statearr_45087_47525 = state_45077__$1;
(statearr_45087_47525[(2)] = null);

(statearr_45087_47525[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45078 === (4))){
var inst_45054 = (state_45077[(7)]);
var inst_45057 = cljs.core.first(inst_45054);
var state_45077__$1 = state_45077;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45077__$1,(7),ch,inst_45057);
} else {
if((state_val_45078 === (13))){
var inst_45071 = (state_45077[(2)]);
var state_45077__$1 = state_45077;
var statearr_45088_47526 = state_45077__$1;
(statearr_45088_47526[(2)] = inst_45071);

(statearr_45088_47526[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45078 === (6))){
var inst_45062 = (state_45077[(2)]);
var state_45077__$1 = state_45077;
if(cljs.core.truth_(inst_45062)){
var statearr_45093_47527 = state_45077__$1;
(statearr_45093_47527[(1)] = (8));

} else {
var statearr_45096_47528 = state_45077__$1;
(statearr_45096_47528[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45078 === (3))){
var inst_45075 = (state_45077[(2)]);
var state_45077__$1 = state_45077;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45077__$1,inst_45075);
} else {
if((state_val_45078 === (12))){
var state_45077__$1 = state_45077;
var statearr_45109_47531 = state_45077__$1;
(statearr_45109_47531[(2)] = null);

(statearr_45109_47531[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45078 === (2))){
var inst_45054 = (state_45077[(7)]);
var state_45077__$1 = state_45077;
if(cljs.core.truth_(inst_45054)){
var statearr_45115_47532 = state_45077__$1;
(statearr_45115_47532[(1)] = (4));

} else {
var statearr_45116_47533 = state_45077__$1;
(statearr_45116_47533[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45078 === (11))){
var inst_45068 = cljs.core.async.close_BANG_(ch);
var state_45077__$1 = state_45077;
var statearr_45118_47534 = state_45077__$1;
(statearr_45118_47534[(2)] = inst_45068);

(statearr_45118_47534[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45078 === (9))){
var state_45077__$1 = state_45077;
if(cljs.core.truth_(close_QMARK_)){
var statearr_45121_47535 = state_45077__$1;
(statearr_45121_47535[(1)] = (11));

} else {
var statearr_45122_47536 = state_45077__$1;
(statearr_45122_47536[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45078 === (5))){
var inst_45054 = (state_45077[(7)]);
var state_45077__$1 = state_45077;
var statearr_45123_47537 = state_45077__$1;
(statearr_45123_47537[(2)] = inst_45054);

(statearr_45123_47537[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45078 === (10))){
var inst_45073 = (state_45077[(2)]);
var state_45077__$1 = state_45077;
var statearr_45124_47538 = state_45077__$1;
(statearr_45124_47538[(2)] = inst_45073);

(statearr_45124_47538[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45078 === (8))){
var inst_45054 = (state_45077[(7)]);
var inst_45064 = cljs.core.next(inst_45054);
var inst_45054__$1 = inst_45064;
var state_45077__$1 = (function (){var statearr_45126 = state_45077;
(statearr_45126[(7)] = inst_45054__$1);

return statearr_45126;
})();
var statearr_45127_47539 = state_45077__$1;
(statearr_45127_47539[(2)] = null);

(statearr_45127_47539[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43958__auto__ = null;
var cljs$core$async$state_machine__43958__auto____0 = (function (){
var statearr_45129 = [null,null,null,null,null,null,null,null];
(statearr_45129[(0)] = cljs$core$async$state_machine__43958__auto__);

(statearr_45129[(1)] = (1));

return statearr_45129;
});
var cljs$core$async$state_machine__43958__auto____1 = (function (state_45077){
while(true){
var ret_value__43959__auto__ = (function (){try{while(true){
var result__43960__auto__ = switch__43957__auto__(state_45077);
if(cljs.core.keyword_identical_QMARK_(result__43960__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43960__auto__;
}
break;
}
}catch (e45133){var ex__43961__auto__ = e45133;
var statearr_45134_47540 = state_45077;
(statearr_45134_47540[(2)] = ex__43961__auto__);


if(cljs.core.seq((state_45077[(4)]))){
var statearr_45136_47541 = state_45077;
(statearr_45136_47541[(1)] = cljs.core.first((state_45077[(4)])));

} else {
throw ex__43961__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43959__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47542 = state_45077;
state_45077 = G__47542;
continue;
} else {
return ret_value__43959__auto__;
}
break;
}
});
cljs$core$async$state_machine__43958__auto__ = function(state_45077){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43958__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43958__auto____1.call(this,state_45077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43958__auto____0;
cljs$core$async$state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43958__auto____1;
return cljs$core$async$state_machine__43958__auto__;
})()
})();
var state__44129__auto__ = (function (){var statearr_45137 = f__44128__auto__();
(statearr_45137[(6)] = c__44127__auto__);

return statearr_45137;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44129__auto__);
}));

return c__44127__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__45140 = arguments.length;
switch (G__45140) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_47552 = (function (_){
var x__4550__auto__ = (((_ == null))?null:_);
var m__4551__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4551__auto__.call(null,_));
} else {
var m__4549__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4549__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_47552(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_47553 = (function (m,ch,close_QMARK_){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4551__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4549__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4549__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_47553(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_47554 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_47554(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_47555 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4551__auto__.call(null,m));
} else {
var m__4549__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4549__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_47555(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45273 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45273 = (function (ch,cs,meta45274){
this.ch = ch;
this.cs = cs;
this.meta45274 = meta45274;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45273.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45275,meta45274__$1){
var self__ = this;
var _45275__$1 = this;
return (new cljs.core.async.t_cljs$core$async45273(self__.ch,self__.cs,meta45274__$1));
}));

(cljs.core.async.t_cljs$core$async45273.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45275){
var self__ = this;
var _45275__$1 = this;
return self__.meta45274;
}));

(cljs.core.async.t_cljs$core$async45273.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45273.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async45273.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45273.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async45273.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async45273.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async45273.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta45274","meta45274",2102430959,null)], null);
}));

(cljs.core.async.t_cljs$core$async45273.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45273.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45273");

(cljs.core.async.t_cljs$core$async45273.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async45273");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45273.
 */
cljs.core.async.__GT_t_cljs$core$async45273 = (function cljs$core$async$mult_$___GT_t_cljs$core$async45273(ch__$1,cs__$1,meta45274){
return (new cljs.core.async.t_cljs$core$async45273(ch__$1,cs__$1,meta45274));
});

}

return (new cljs.core.async.t_cljs$core$async45273(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__44127__auto___47570 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44128__auto__ = (function (){var switch__43957__auto__ = (function (state_45435){
var state_val_45436 = (state_45435[(1)]);
if((state_val_45436 === (7))){
var inst_45430 = (state_45435[(2)]);
var state_45435__$1 = state_45435;
var statearr_45437_47571 = state_45435__$1;
(statearr_45437_47571[(2)] = inst_45430);

(statearr_45437_47571[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (20))){
var inst_45322 = (state_45435[(7)]);
var inst_45334 = cljs.core.first(inst_45322);
var inst_45335 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45334,(0),null);
var inst_45338 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45334,(1),null);
var state_45435__$1 = (function (){var statearr_45438 = state_45435;
(statearr_45438[(8)] = inst_45335);

return statearr_45438;
})();
if(cljs.core.truth_(inst_45338)){
var statearr_45440_47572 = state_45435__$1;
(statearr_45440_47572[(1)] = (22));

} else {
var statearr_45441_47573 = state_45435__$1;
(statearr_45441_47573[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (27))){
var inst_45375 = (state_45435[(9)]);
var inst_45291 = (state_45435[(10)]);
var inst_45382 = (state_45435[(11)]);
var inst_45377 = (state_45435[(12)]);
var inst_45382__$1 = cljs.core._nth(inst_45375,inst_45377);
var inst_45383 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_45382__$1,inst_45291,done);
var state_45435__$1 = (function (){var statearr_45442 = state_45435;
(statearr_45442[(11)] = inst_45382__$1);

return statearr_45442;
})();
if(cljs.core.truth_(inst_45383)){
var statearr_45443_47574 = state_45435__$1;
(statearr_45443_47574[(1)] = (30));

} else {
var statearr_45444_47575 = state_45435__$1;
(statearr_45444_47575[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (1))){
var state_45435__$1 = state_45435;
var statearr_45445_47576 = state_45435__$1;
(statearr_45445_47576[(2)] = null);

(statearr_45445_47576[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (24))){
var inst_45322 = (state_45435[(7)]);
var inst_45343 = (state_45435[(2)]);
var inst_45344 = cljs.core.next(inst_45322);
var inst_45300 = inst_45344;
var inst_45301 = null;
var inst_45302 = (0);
var inst_45303 = (0);
var state_45435__$1 = (function (){var statearr_45446 = state_45435;
(statearr_45446[(13)] = inst_45303);

(statearr_45446[(14)] = inst_45301);

(statearr_45446[(15)] = inst_45300);

(statearr_45446[(16)] = inst_45343);

(statearr_45446[(17)] = inst_45302);

return statearr_45446;
})();
var statearr_45447_47577 = state_45435__$1;
(statearr_45447_47577[(2)] = null);

(statearr_45447_47577[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (39))){
var state_45435__$1 = state_45435;
var statearr_45452_47578 = state_45435__$1;
(statearr_45452_47578[(2)] = null);

(statearr_45452_47578[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (4))){
var inst_45291 = (state_45435[(10)]);
var inst_45291__$1 = (state_45435[(2)]);
var inst_45292 = (inst_45291__$1 == null);
var state_45435__$1 = (function (){var statearr_45454 = state_45435;
(statearr_45454[(10)] = inst_45291__$1);

return statearr_45454;
})();
if(cljs.core.truth_(inst_45292)){
var statearr_45459_47581 = state_45435__$1;
(statearr_45459_47581[(1)] = (5));

} else {
var statearr_45463_47583 = state_45435__$1;
(statearr_45463_47583[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (15))){
var inst_45303 = (state_45435[(13)]);
var inst_45301 = (state_45435[(14)]);
var inst_45300 = (state_45435[(15)]);
var inst_45302 = (state_45435[(17)]);
var inst_45318 = (state_45435[(2)]);
var inst_45319 = (inst_45303 + (1));
var tmp45448 = inst_45301;
var tmp45449 = inst_45300;
var tmp45450 = inst_45302;
var inst_45300__$1 = tmp45449;
var inst_45301__$1 = tmp45448;
var inst_45302__$1 = tmp45450;
var inst_45303__$1 = inst_45319;
var state_45435__$1 = (function (){var statearr_45471 = state_45435;
(statearr_45471[(13)] = inst_45303__$1);

(statearr_45471[(14)] = inst_45301__$1);

(statearr_45471[(15)] = inst_45300__$1);

(statearr_45471[(18)] = inst_45318);

(statearr_45471[(17)] = inst_45302__$1);

return statearr_45471;
})();
var statearr_45472_47584 = state_45435__$1;
(statearr_45472_47584[(2)] = null);

(statearr_45472_47584[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (21))){
var inst_45349 = (state_45435[(2)]);
var state_45435__$1 = state_45435;
var statearr_45478_47591 = state_45435__$1;
(statearr_45478_47591[(2)] = inst_45349);

(statearr_45478_47591[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (31))){
var inst_45382 = (state_45435[(11)]);
var inst_45386 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_45382);
var state_45435__$1 = state_45435;
var statearr_45480_47592 = state_45435__$1;
(statearr_45480_47592[(2)] = inst_45386);

(statearr_45480_47592[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (32))){
var inst_45375 = (state_45435[(9)]);
var inst_45376 = (state_45435[(19)]);
var inst_45374 = (state_45435[(20)]);
var inst_45377 = (state_45435[(12)]);
var inst_45388 = (state_45435[(2)]);
var inst_45389 = (inst_45377 + (1));
var tmp45474 = inst_45375;
var tmp45475 = inst_45376;
var tmp45476 = inst_45374;
var inst_45374__$1 = tmp45476;
var inst_45375__$1 = tmp45474;
var inst_45376__$1 = tmp45475;
var inst_45377__$1 = inst_45389;
var state_45435__$1 = (function (){var statearr_45482 = state_45435;
(statearr_45482[(9)] = inst_45375__$1);

(statearr_45482[(19)] = inst_45376__$1);

(statearr_45482[(20)] = inst_45374__$1);

(statearr_45482[(12)] = inst_45377__$1);

(statearr_45482[(21)] = inst_45388);

return statearr_45482;
})();
var statearr_45484_47601 = state_45435__$1;
(statearr_45484_47601[(2)] = null);

(statearr_45484_47601[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (40))){
var inst_45401 = (state_45435[(22)]);
var inst_45405 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_45401);
var state_45435__$1 = state_45435;
var statearr_45486_47605 = state_45435__$1;
(statearr_45486_47605[(2)] = inst_45405);

(statearr_45486_47605[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (33))){
var inst_45392 = (state_45435[(23)]);
var inst_45394 = cljs.core.chunked_seq_QMARK_(inst_45392);
var state_45435__$1 = state_45435;
if(inst_45394){
var statearr_45488_47608 = state_45435__$1;
(statearr_45488_47608[(1)] = (36));

} else {
var statearr_45489_47611 = state_45435__$1;
(statearr_45489_47611[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (13))){
var inst_45312 = (state_45435[(24)]);
var inst_45315 = cljs.core.async.close_BANG_(inst_45312);
var state_45435__$1 = state_45435;
var statearr_45492_47613 = state_45435__$1;
(statearr_45492_47613[(2)] = inst_45315);

(statearr_45492_47613[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (22))){
var inst_45335 = (state_45435[(8)]);
var inst_45340 = cljs.core.async.close_BANG_(inst_45335);
var state_45435__$1 = state_45435;
var statearr_45494_47615 = state_45435__$1;
(statearr_45494_47615[(2)] = inst_45340);

(statearr_45494_47615[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (36))){
var inst_45392 = (state_45435[(23)]);
var inst_45396 = cljs.core.chunk_first(inst_45392);
var inst_45397 = cljs.core.chunk_rest(inst_45392);
var inst_45398 = cljs.core.count(inst_45396);
var inst_45374 = inst_45397;
var inst_45375 = inst_45396;
var inst_45376 = inst_45398;
var inst_45377 = (0);
var state_45435__$1 = (function (){var statearr_45498 = state_45435;
(statearr_45498[(9)] = inst_45375);

(statearr_45498[(19)] = inst_45376);

(statearr_45498[(20)] = inst_45374);

(statearr_45498[(12)] = inst_45377);

return statearr_45498;
})();
var statearr_45499_47621 = state_45435__$1;
(statearr_45499_47621[(2)] = null);

(statearr_45499_47621[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (41))){
var inst_45392 = (state_45435[(23)]);
var inst_45407 = (state_45435[(2)]);
var inst_45408 = cljs.core.next(inst_45392);
var inst_45374 = inst_45408;
var inst_45375 = null;
var inst_45376 = (0);
var inst_45377 = (0);
var state_45435__$1 = (function (){var statearr_45500 = state_45435;
(statearr_45500[(9)] = inst_45375);

(statearr_45500[(25)] = inst_45407);

(statearr_45500[(19)] = inst_45376);

(statearr_45500[(20)] = inst_45374);

(statearr_45500[(12)] = inst_45377);

return statearr_45500;
})();
var statearr_45504_47624 = state_45435__$1;
(statearr_45504_47624[(2)] = null);

(statearr_45504_47624[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (43))){
var state_45435__$1 = state_45435;
var statearr_45507_47625 = state_45435__$1;
(statearr_45507_47625[(2)] = null);

(statearr_45507_47625[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (29))){
var inst_45416 = (state_45435[(2)]);
var state_45435__$1 = state_45435;
var statearr_45511_47627 = state_45435__$1;
(statearr_45511_47627[(2)] = inst_45416);

(statearr_45511_47627[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (44))){
var inst_45427 = (state_45435[(2)]);
var state_45435__$1 = (function (){var statearr_45512 = state_45435;
(statearr_45512[(26)] = inst_45427);

return statearr_45512;
})();
var statearr_45513_47628 = state_45435__$1;
(statearr_45513_47628[(2)] = null);

(statearr_45513_47628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (6))){
var inst_45363 = (state_45435[(27)]);
var inst_45362 = cljs.core.deref(cs);
var inst_45363__$1 = cljs.core.keys(inst_45362);
var inst_45364 = cljs.core.count(inst_45363__$1);
var inst_45365 = cljs.core.reset_BANG_(dctr,inst_45364);
var inst_45373 = cljs.core.seq(inst_45363__$1);
var inst_45374 = inst_45373;
var inst_45375 = null;
var inst_45376 = (0);
var inst_45377 = (0);
var state_45435__$1 = (function (){var statearr_45515 = state_45435;
(statearr_45515[(27)] = inst_45363__$1);

(statearr_45515[(9)] = inst_45375);

(statearr_45515[(19)] = inst_45376);

(statearr_45515[(28)] = inst_45365);

(statearr_45515[(20)] = inst_45374);

(statearr_45515[(12)] = inst_45377);

return statearr_45515;
})();
var statearr_45516_47629 = state_45435__$1;
(statearr_45516_47629[(2)] = null);

(statearr_45516_47629[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (28))){
var inst_45392 = (state_45435[(23)]);
var inst_45374 = (state_45435[(20)]);
var inst_45392__$1 = cljs.core.seq(inst_45374);
var state_45435__$1 = (function (){var statearr_45517 = state_45435;
(statearr_45517[(23)] = inst_45392__$1);

return statearr_45517;
})();
if(inst_45392__$1){
var statearr_45519_47631 = state_45435__$1;
(statearr_45519_47631[(1)] = (33));

} else {
var statearr_45520_47633 = state_45435__$1;
(statearr_45520_47633[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (25))){
var inst_45376 = (state_45435[(19)]);
var inst_45377 = (state_45435[(12)]);
var inst_45379 = (inst_45377 < inst_45376);
var inst_45380 = inst_45379;
var state_45435__$1 = state_45435;
if(cljs.core.truth_(inst_45380)){
var statearr_45521_47635 = state_45435__$1;
(statearr_45521_47635[(1)] = (27));

} else {
var statearr_45522_47636 = state_45435__$1;
(statearr_45522_47636[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (34))){
var state_45435__$1 = state_45435;
var statearr_45523_47637 = state_45435__$1;
(statearr_45523_47637[(2)] = null);

(statearr_45523_47637[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (17))){
var state_45435__$1 = state_45435;
var statearr_45525_47638 = state_45435__$1;
(statearr_45525_47638[(2)] = null);

(statearr_45525_47638[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (3))){
var inst_45432 = (state_45435[(2)]);
var state_45435__$1 = state_45435;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45435__$1,inst_45432);
} else {
if((state_val_45436 === (12))){
var inst_45354 = (state_45435[(2)]);
var state_45435__$1 = state_45435;
var statearr_45527_47639 = state_45435__$1;
(statearr_45527_47639[(2)] = inst_45354);

(statearr_45527_47639[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (2))){
var state_45435__$1 = state_45435;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45435__$1,(4),ch);
} else {
if((state_val_45436 === (23))){
var state_45435__$1 = state_45435;
var statearr_45531_47642 = state_45435__$1;
(statearr_45531_47642[(2)] = null);

(statearr_45531_47642[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (35))){
var inst_45414 = (state_45435[(2)]);
var state_45435__$1 = state_45435;
var statearr_45532_47645 = state_45435__$1;
(statearr_45532_47645[(2)] = inst_45414);

(statearr_45532_47645[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (19))){
var inst_45322 = (state_45435[(7)]);
var inst_45326 = cljs.core.chunk_first(inst_45322);
var inst_45327 = cljs.core.chunk_rest(inst_45322);
var inst_45328 = cljs.core.count(inst_45326);
var inst_45300 = inst_45327;
var inst_45301 = inst_45326;
var inst_45302 = inst_45328;
var inst_45303 = (0);
var state_45435__$1 = (function (){var statearr_45534 = state_45435;
(statearr_45534[(13)] = inst_45303);

(statearr_45534[(14)] = inst_45301);

(statearr_45534[(15)] = inst_45300);

(statearr_45534[(17)] = inst_45302);

return statearr_45534;
})();
var statearr_45541_47647 = state_45435__$1;
(statearr_45541_47647[(2)] = null);

(statearr_45541_47647[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (11))){
var inst_45322 = (state_45435[(7)]);
var inst_45300 = (state_45435[(15)]);
var inst_45322__$1 = cljs.core.seq(inst_45300);
var state_45435__$1 = (function (){var statearr_45542 = state_45435;
(statearr_45542[(7)] = inst_45322__$1);

return statearr_45542;
})();
if(inst_45322__$1){
var statearr_45544_47648 = state_45435__$1;
(statearr_45544_47648[(1)] = (16));

} else {
var statearr_45545_47649 = state_45435__$1;
(statearr_45545_47649[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (9))){
var inst_45356 = (state_45435[(2)]);
var state_45435__$1 = state_45435;
var statearr_45546_47650 = state_45435__$1;
(statearr_45546_47650[(2)] = inst_45356);

(statearr_45546_47650[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (5))){
var inst_45298 = cljs.core.deref(cs);
var inst_45299 = cljs.core.seq(inst_45298);
var inst_45300 = inst_45299;
var inst_45301 = null;
var inst_45302 = (0);
var inst_45303 = (0);
var state_45435__$1 = (function (){var statearr_45548 = state_45435;
(statearr_45548[(13)] = inst_45303);

(statearr_45548[(14)] = inst_45301);

(statearr_45548[(15)] = inst_45300);

(statearr_45548[(17)] = inst_45302);

return statearr_45548;
})();
var statearr_45549_47652 = state_45435__$1;
(statearr_45549_47652[(2)] = null);

(statearr_45549_47652[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (14))){
var state_45435__$1 = state_45435;
var statearr_45551_47653 = state_45435__$1;
(statearr_45551_47653[(2)] = null);

(statearr_45551_47653[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (45))){
var inst_45424 = (state_45435[(2)]);
var state_45435__$1 = state_45435;
var statearr_45554_47654 = state_45435__$1;
(statearr_45554_47654[(2)] = inst_45424);

(statearr_45554_47654[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (26))){
var inst_45363 = (state_45435[(27)]);
var inst_45418 = (state_45435[(2)]);
var inst_45420 = cljs.core.seq(inst_45363);
var state_45435__$1 = (function (){var statearr_45556 = state_45435;
(statearr_45556[(29)] = inst_45418);

return statearr_45556;
})();
if(inst_45420){
var statearr_45558_47657 = state_45435__$1;
(statearr_45558_47657[(1)] = (42));

} else {
var statearr_45559_47658 = state_45435__$1;
(statearr_45559_47658[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (16))){
var inst_45322 = (state_45435[(7)]);
var inst_45324 = cljs.core.chunked_seq_QMARK_(inst_45322);
var state_45435__$1 = state_45435;
if(inst_45324){
var statearr_45560_47660 = state_45435__$1;
(statearr_45560_47660[(1)] = (19));

} else {
var statearr_45561_47661 = state_45435__$1;
(statearr_45561_47661[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (38))){
var inst_45411 = (state_45435[(2)]);
var state_45435__$1 = state_45435;
var statearr_45562_47662 = state_45435__$1;
(statearr_45562_47662[(2)] = inst_45411);

(statearr_45562_47662[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (30))){
var state_45435__$1 = state_45435;
var statearr_45563_47663 = state_45435__$1;
(statearr_45563_47663[(2)] = null);

(statearr_45563_47663[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (10))){
var inst_45303 = (state_45435[(13)]);
var inst_45301 = (state_45435[(14)]);
var inst_45311 = cljs.core._nth(inst_45301,inst_45303);
var inst_45312 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45311,(0),null);
var inst_45313 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45311,(1),null);
var state_45435__$1 = (function (){var statearr_45564 = state_45435;
(statearr_45564[(24)] = inst_45312);

return statearr_45564;
})();
if(cljs.core.truth_(inst_45313)){
var statearr_45565_47664 = state_45435__$1;
(statearr_45565_47664[(1)] = (13));

} else {
var statearr_45566_47665 = state_45435__$1;
(statearr_45566_47665[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (18))){
var inst_45352 = (state_45435[(2)]);
var state_45435__$1 = state_45435;
var statearr_45567_47667 = state_45435__$1;
(statearr_45567_47667[(2)] = inst_45352);

(statearr_45567_47667[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (42))){
var state_45435__$1 = state_45435;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45435__$1,(45),dchan);
} else {
if((state_val_45436 === (37))){
var inst_45401 = (state_45435[(22)]);
var inst_45392 = (state_45435[(23)]);
var inst_45291 = (state_45435[(10)]);
var inst_45401__$1 = cljs.core.first(inst_45392);
var inst_45402 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_45401__$1,inst_45291,done);
var state_45435__$1 = (function (){var statearr_45571 = state_45435;
(statearr_45571[(22)] = inst_45401__$1);

return statearr_45571;
})();
if(cljs.core.truth_(inst_45402)){
var statearr_45572_47668 = state_45435__$1;
(statearr_45572_47668[(1)] = (39));

} else {
var statearr_45573_47670 = state_45435__$1;
(statearr_45573_47670[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45436 === (8))){
var inst_45303 = (state_45435[(13)]);
var inst_45302 = (state_45435[(17)]);
var inst_45305 = (inst_45303 < inst_45302);
var inst_45306 = inst_45305;
var state_45435__$1 = state_45435;
if(cljs.core.truth_(inst_45306)){
var statearr_45575_47671 = state_45435__$1;
(statearr_45575_47671[(1)] = (10));

} else {
var statearr_45576_47672 = state_45435__$1;
(statearr_45576_47672[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__43958__auto__ = null;
var cljs$core$async$mult_$_state_machine__43958__auto____0 = (function (){
var statearr_45577 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45577[(0)] = cljs$core$async$mult_$_state_machine__43958__auto__);

(statearr_45577[(1)] = (1));

return statearr_45577;
});
var cljs$core$async$mult_$_state_machine__43958__auto____1 = (function (state_45435){
while(true){
var ret_value__43959__auto__ = (function (){try{while(true){
var result__43960__auto__ = switch__43957__auto__(state_45435);
if(cljs.core.keyword_identical_QMARK_(result__43960__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43960__auto__;
}
break;
}
}catch (e45578){var ex__43961__auto__ = e45578;
var statearr_45579_47677 = state_45435;
(statearr_45579_47677[(2)] = ex__43961__auto__);


if(cljs.core.seq((state_45435[(4)]))){
var statearr_45580_47678 = state_45435;
(statearr_45580_47678[(1)] = cljs.core.first((state_45435[(4)])));

} else {
throw ex__43961__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43959__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47679 = state_45435;
state_45435 = G__47679;
continue;
} else {
return ret_value__43959__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__43958__auto__ = function(state_45435){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__43958__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__43958__auto____1.call(this,state_45435);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__43958__auto____0;
cljs$core$async$mult_$_state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__43958__auto____1;
return cljs$core$async$mult_$_state_machine__43958__auto__;
})()
})();
var state__44129__auto__ = (function (){var statearr_45581 = f__44128__auto__();
(statearr_45581[(6)] = c__44127__auto___47570);

return statearr_45581;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44129__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__45588 = arguments.length;
switch (G__45588) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_47682 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_47682(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_47685 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_47685(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_47687 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4551__auto__.call(null,m));
} else {
var m__4549__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4549__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_47687(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_47690 = (function (m,state_map){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4551__auto__.call(null,m,state_map));
} else {
var m__4549__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4549__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_47690(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_47694 = (function (m,mode){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4551__auto__.call(null,m,mode));
} else {
var m__4549__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4549__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_47694(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___47698 = arguments.length;
var i__4865__auto___47699 = (0);
while(true){
if((i__4865__auto___47699 < len__4864__auto___47698)){
args__4870__auto__.push((arguments[i__4865__auto___47699]));

var G__47701 = (i__4865__auto___47699 + (1));
i__4865__auto___47699 = G__47701;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((3) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4871__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__45626){
var map__45627 = p__45626;
var map__45627__$1 = cljs.core.__destructure_map(map__45627);
var opts = map__45627__$1;
var statearr_45628_47703 = state;
(statearr_45628_47703[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts((function (val){
var statearr_45629_47704 = state;
(statearr_45629_47704[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_45631_47705 = state;
(statearr_45631_47705[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq45619){
var G__45620 = cljs.core.first(seq45619);
var seq45619__$1 = cljs.core.next(seq45619);
var G__45621 = cljs.core.first(seq45619__$1);
var seq45619__$2 = cljs.core.next(seq45619__$1);
var G__45622 = cljs.core.first(seq45619__$2);
var seq45619__$3 = cljs.core.next(seq45619__$2);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45620,G__45621,G__45622,seq45619__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45642 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45642 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta45643){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta45643 = meta45643;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45642.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45644,meta45643__$1){
var self__ = this;
var _45644__$1 = this;
return (new cljs.core.async.t_cljs$core$async45642(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta45643__$1));
}));

(cljs.core.async.t_cljs$core$async45642.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45644){
var self__ = this;
var _45644__$1 = this;
return self__.meta45643;
}));

(cljs.core.async.t_cljs$core$async45642.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45642.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async45642.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45642.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45642.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45642.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45642.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45642.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45642.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta45643","meta45643",1962125414,null)], null);
}));

(cljs.core.async.t_cljs$core$async45642.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45642.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45642");

(cljs.core.async.t_cljs$core$async45642.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async45642");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45642.
 */
cljs.core.async.__GT_t_cljs$core$async45642 = (function cljs$core$async$mix_$___GT_t_cljs$core$async45642(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta45643){
return (new cljs.core.async.t_cljs$core$async45642(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta45643));
});

}

return (new cljs.core.async.t_cljs$core$async45642(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__44127__auto___47800 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44128__auto__ = (function (){var switch__43957__auto__ = (function (state_45776){
var state_val_45777 = (state_45776[(1)]);
if((state_val_45777 === (7))){
var inst_45736 = (state_45776[(2)]);
var state_45776__$1 = state_45776;
if(cljs.core.truth_(inst_45736)){
var statearr_45787_47806 = state_45776__$1;
(statearr_45787_47806[(1)] = (8));

} else {
var statearr_45790_47810 = state_45776__$1;
(statearr_45790_47810[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45777 === (20))){
var inst_45729 = (state_45776[(7)]);
var state_45776__$1 = state_45776;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45776__$1,(23),out,inst_45729);
} else {
if((state_val_45777 === (1))){
var inst_45711 = calc_state();
var inst_45712 = cljs.core.__destructure_map(inst_45711);
var inst_45713 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45712,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_45715 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45712,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_45716 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45712,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_45717 = inst_45711;
var state_45776__$1 = (function (){var statearr_45794 = state_45776;
(statearr_45794[(8)] = inst_45716);

(statearr_45794[(9)] = inst_45713);

(statearr_45794[(10)] = inst_45715);

(statearr_45794[(11)] = inst_45717);

return statearr_45794;
})();
var statearr_45795_47815 = state_45776__$1;
(statearr_45795_47815[(2)] = null);

(statearr_45795_47815[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45777 === (24))){
var inst_45720 = (state_45776[(12)]);
var inst_45717 = inst_45720;
var state_45776__$1 = (function (){var statearr_45800 = state_45776;
(statearr_45800[(11)] = inst_45717);

return statearr_45800;
})();
var statearr_45801_47816 = state_45776__$1;
(statearr_45801_47816[(2)] = null);

(statearr_45801_47816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45777 === (4))){
var inst_45731 = (state_45776[(13)]);
var inst_45729 = (state_45776[(7)]);
var inst_45728 = (state_45776[(2)]);
var inst_45729__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45728,(0),null);
var inst_45730 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45728,(1),null);
var inst_45731__$1 = (inst_45729__$1 == null);
var state_45776__$1 = (function (){var statearr_45810 = state_45776;
(statearr_45810[(13)] = inst_45731__$1);

(statearr_45810[(14)] = inst_45730);

(statearr_45810[(7)] = inst_45729__$1);

return statearr_45810;
})();
if(cljs.core.truth_(inst_45731__$1)){
var statearr_45811_47818 = state_45776__$1;
(statearr_45811_47818[(1)] = (5));

} else {
var statearr_45812_47819 = state_45776__$1;
(statearr_45812_47819[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45777 === (15))){
var inst_45721 = (state_45776[(15)]);
var inst_45750 = (state_45776[(16)]);
var inst_45750__$1 = cljs.core.empty_QMARK_(inst_45721);
var state_45776__$1 = (function (){var statearr_45813 = state_45776;
(statearr_45813[(16)] = inst_45750__$1);

return statearr_45813;
})();
if(inst_45750__$1){
var statearr_45814_47821 = state_45776__$1;
(statearr_45814_47821[(1)] = (17));

} else {
var statearr_45815_47823 = state_45776__$1;
(statearr_45815_47823[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45777 === (21))){
var inst_45720 = (state_45776[(12)]);
var inst_45717 = inst_45720;
var state_45776__$1 = (function (){var statearr_45816 = state_45776;
(statearr_45816[(11)] = inst_45717);

return statearr_45816;
})();
var statearr_45817_47825 = state_45776__$1;
(statearr_45817_47825[(2)] = null);

(statearr_45817_47825[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45777 === (13))){
var inst_45743 = (state_45776[(2)]);
var inst_45744 = calc_state();
var inst_45717 = inst_45744;
var state_45776__$1 = (function (){var statearr_45821 = state_45776;
(statearr_45821[(17)] = inst_45743);

(statearr_45821[(11)] = inst_45717);

return statearr_45821;
})();
var statearr_45822_47827 = state_45776__$1;
(statearr_45822_47827[(2)] = null);

(statearr_45822_47827[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45777 === (22))){
var inst_45770 = (state_45776[(2)]);
var state_45776__$1 = state_45776;
var statearr_45823_47828 = state_45776__$1;
(statearr_45823_47828[(2)] = inst_45770);

(statearr_45823_47828[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45777 === (6))){
var inst_45730 = (state_45776[(14)]);
var inst_45734 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_45730,change);
var state_45776__$1 = state_45776;
var statearr_45824_47832 = state_45776__$1;
(statearr_45824_47832[(2)] = inst_45734);

(statearr_45824_47832[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45777 === (25))){
var state_45776__$1 = state_45776;
var statearr_45825_47833 = state_45776__$1;
(statearr_45825_47833[(2)] = null);

(statearr_45825_47833[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45777 === (17))){
var inst_45730 = (state_45776[(14)]);
var inst_45722 = (state_45776[(18)]);
var inst_45752 = (inst_45722.cljs$core$IFn$_invoke$arity$1 ? inst_45722.cljs$core$IFn$_invoke$arity$1(inst_45730) : inst_45722.call(null,inst_45730));
var inst_45753 = cljs.core.not(inst_45752);
var state_45776__$1 = state_45776;
var statearr_45827_47835 = state_45776__$1;
(statearr_45827_47835[(2)] = inst_45753);

(statearr_45827_47835[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45777 === (3))){
var inst_45774 = (state_45776[(2)]);
var state_45776__$1 = state_45776;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45776__$1,inst_45774);
} else {
if((state_val_45777 === (12))){
var state_45776__$1 = state_45776;
var statearr_45829_47839 = state_45776__$1;
(statearr_45829_47839[(2)] = null);

(statearr_45829_47839[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45777 === (2))){
var inst_45720 = (state_45776[(12)]);
var inst_45717 = (state_45776[(11)]);
var inst_45720__$1 = cljs.core.__destructure_map(inst_45717);
var inst_45721 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45720__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_45722 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45720__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_45723 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45720__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_45776__$1 = (function (){var statearr_45831 = state_45776;
(statearr_45831[(15)] = inst_45721);

(statearr_45831[(12)] = inst_45720__$1);

(statearr_45831[(18)] = inst_45722);

return statearr_45831;
})();
return cljs.core.async.ioc_alts_BANG_(state_45776__$1,(4),inst_45723);
} else {
if((state_val_45777 === (23))){
var inst_45761 = (state_45776[(2)]);
var state_45776__$1 = state_45776;
if(cljs.core.truth_(inst_45761)){
var statearr_45833_47844 = state_45776__$1;
(statearr_45833_47844[(1)] = (24));

} else {
var statearr_45835_47845 = state_45776__$1;
(statearr_45835_47845[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45777 === (19))){
var inst_45756 = (state_45776[(2)]);
var state_45776__$1 = state_45776;
var statearr_45836_47846 = state_45776__$1;
(statearr_45836_47846[(2)] = inst_45756);

(statearr_45836_47846[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45777 === (11))){
var inst_45730 = (state_45776[(14)]);
var inst_45740 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_45730);
var state_45776__$1 = state_45776;
var statearr_45837_47847 = state_45776__$1;
(statearr_45837_47847[(2)] = inst_45740);

(statearr_45837_47847[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45777 === (9))){
var inst_45747 = (state_45776[(19)]);
var inst_45721 = (state_45776[(15)]);
var inst_45730 = (state_45776[(14)]);
var inst_45747__$1 = (inst_45721.cljs$core$IFn$_invoke$arity$1 ? inst_45721.cljs$core$IFn$_invoke$arity$1(inst_45730) : inst_45721.call(null,inst_45730));
var state_45776__$1 = (function (){var statearr_45838 = state_45776;
(statearr_45838[(19)] = inst_45747__$1);

return statearr_45838;
})();
if(cljs.core.truth_(inst_45747__$1)){
var statearr_45839_47848 = state_45776__$1;
(statearr_45839_47848[(1)] = (14));

} else {
var statearr_45840_47849 = state_45776__$1;
(statearr_45840_47849[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45777 === (5))){
var inst_45731 = (state_45776[(13)]);
var state_45776__$1 = state_45776;
var statearr_45841_47850 = state_45776__$1;
(statearr_45841_47850[(2)] = inst_45731);

(statearr_45841_47850[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45777 === (14))){
var inst_45747 = (state_45776[(19)]);
var state_45776__$1 = state_45776;
var statearr_45842_47852 = state_45776__$1;
(statearr_45842_47852[(2)] = inst_45747);

(statearr_45842_47852[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45777 === (26))){
var inst_45766 = (state_45776[(2)]);
var state_45776__$1 = state_45776;
var statearr_45847_47855 = state_45776__$1;
(statearr_45847_47855[(2)] = inst_45766);

(statearr_45847_47855[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45777 === (16))){
var inst_45758 = (state_45776[(2)]);
var state_45776__$1 = state_45776;
if(cljs.core.truth_(inst_45758)){
var statearr_45853_47857 = state_45776__$1;
(statearr_45853_47857[(1)] = (20));

} else {
var statearr_45854_47858 = state_45776__$1;
(statearr_45854_47858[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45777 === (10))){
var inst_45772 = (state_45776[(2)]);
var state_45776__$1 = state_45776;
var statearr_45856_47859 = state_45776__$1;
(statearr_45856_47859[(2)] = inst_45772);

(statearr_45856_47859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45777 === (18))){
var inst_45750 = (state_45776[(16)]);
var state_45776__$1 = state_45776;
var statearr_45861_47861 = state_45776__$1;
(statearr_45861_47861[(2)] = inst_45750);

(statearr_45861_47861[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45777 === (8))){
var inst_45729 = (state_45776[(7)]);
var inst_45738 = (inst_45729 == null);
var state_45776__$1 = state_45776;
if(cljs.core.truth_(inst_45738)){
var statearr_45862_47864 = state_45776__$1;
(statearr_45862_47864[(1)] = (11));

} else {
var statearr_45863_47866 = state_45776__$1;
(statearr_45863_47866[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__43958__auto__ = null;
var cljs$core$async$mix_$_state_machine__43958__auto____0 = (function (){
var statearr_45864 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45864[(0)] = cljs$core$async$mix_$_state_machine__43958__auto__);

(statearr_45864[(1)] = (1));

return statearr_45864;
});
var cljs$core$async$mix_$_state_machine__43958__auto____1 = (function (state_45776){
while(true){
var ret_value__43959__auto__ = (function (){try{while(true){
var result__43960__auto__ = switch__43957__auto__(state_45776);
if(cljs.core.keyword_identical_QMARK_(result__43960__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43960__auto__;
}
break;
}
}catch (e45869){var ex__43961__auto__ = e45869;
var statearr_45870_47872 = state_45776;
(statearr_45870_47872[(2)] = ex__43961__auto__);


if(cljs.core.seq((state_45776[(4)]))){
var statearr_45872_47874 = state_45776;
(statearr_45872_47874[(1)] = cljs.core.first((state_45776[(4)])));

} else {
throw ex__43961__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43959__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47878 = state_45776;
state_45776 = G__47878;
continue;
} else {
return ret_value__43959__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__43958__auto__ = function(state_45776){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__43958__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__43958__auto____1.call(this,state_45776);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__43958__auto____0;
cljs$core$async$mix_$_state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__43958__auto____1;
return cljs$core$async$mix_$_state_machine__43958__auto__;
})()
})();
var state__44129__auto__ = (function (){var statearr_45878 = f__44128__auto__();
(statearr_45878[(6)] = c__44127__auto___47800);

return statearr_45878;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44129__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_47883 = (function (p,v,ch,close_QMARK_){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4551__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4549__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4549__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_47883(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_47888 = (function (p,v,ch){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4551__auto__.call(null,p,v,ch));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4549__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_47888(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_47893 = (function() {
var G__47894 = null;
var G__47894__1 = (function (p){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4551__auto__.call(null,p));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4549__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__47894__2 = (function (p,v){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4551__auto__.call(null,p,v));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4549__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__47894 = function(p,v){
switch(arguments.length){
case 1:
return G__47894__1.call(this,p);
case 2:
return G__47894__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47894.cljs$core$IFn$_invoke$arity$1 = G__47894__1;
G__47894.cljs$core$IFn$_invoke$arity$2 = G__47894__2;
return G__47894;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__45913 = arguments.length;
switch (G__45913) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_47893(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_47893(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__45936 = arguments.length;
switch (G__45936) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__45931_SHARP_){
if(cljs.core.truth_((p1__45931_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__45931_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__45931_SHARP_.call(null,topic)))){
return p1__45931_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__45931_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45940 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45940 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta45941){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta45941 = meta45941;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45940.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45942,meta45941__$1){
var self__ = this;
var _45942__$1 = this;
return (new cljs.core.async.t_cljs$core$async45940(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta45941__$1));
}));

(cljs.core.async.t_cljs$core$async45940.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45942){
var self__ = this;
var _45942__$1 = this;
return self__.meta45941;
}));

(cljs.core.async.t_cljs$core$async45940.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45940.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async45940.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45940.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async45940.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async45940.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async45940.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async45940.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta45941","meta45941",410930980,null)], null);
}));

(cljs.core.async.t_cljs$core$async45940.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45940.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45940");

(cljs.core.async.t_cljs$core$async45940.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async45940");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45940.
 */
cljs.core.async.__GT_t_cljs$core$async45940 = (function cljs$core$async$__GT_t_cljs$core$async45940(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta45941){
return (new cljs.core.async.t_cljs$core$async45940(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta45941));
});

}

return (new cljs.core.async.t_cljs$core$async45940(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__44127__auto___47919 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44128__auto__ = (function (){var switch__43957__auto__ = (function (state_46055){
var state_val_46056 = (state_46055[(1)]);
if((state_val_46056 === (7))){
var inst_46051 = (state_46055[(2)]);
var state_46055__$1 = state_46055;
var statearr_46060_47921 = state_46055__$1;
(statearr_46060_47921[(2)] = inst_46051);

(statearr_46060_47921[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46056 === (20))){
var state_46055__$1 = state_46055;
var statearr_46061_47922 = state_46055__$1;
(statearr_46061_47922[(2)] = null);

(statearr_46061_47922[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46056 === (1))){
var state_46055__$1 = state_46055;
var statearr_46063_47923 = state_46055__$1;
(statearr_46063_47923[(2)] = null);

(statearr_46063_47923[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46056 === (24))){
var inst_46034 = (state_46055[(7)]);
var inst_46043 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_46034);
var state_46055__$1 = state_46055;
var statearr_46064_47927 = state_46055__$1;
(statearr_46064_47927[(2)] = inst_46043);

(statearr_46064_47927[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46056 === (4))){
var inst_45963 = (state_46055[(8)]);
var inst_45963__$1 = (state_46055[(2)]);
var inst_45964 = (inst_45963__$1 == null);
var state_46055__$1 = (function (){var statearr_46065 = state_46055;
(statearr_46065[(8)] = inst_45963__$1);

return statearr_46065;
})();
if(cljs.core.truth_(inst_45964)){
var statearr_46066_47928 = state_46055__$1;
(statearr_46066_47928[(1)] = (5));

} else {
var statearr_46067_47929 = state_46055__$1;
(statearr_46067_47929[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46056 === (15))){
var inst_46028 = (state_46055[(2)]);
var state_46055__$1 = state_46055;
var statearr_46068_47930 = state_46055__$1;
(statearr_46068_47930[(2)] = inst_46028);

(statearr_46068_47930[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46056 === (21))){
var inst_46048 = (state_46055[(2)]);
var state_46055__$1 = (function (){var statearr_46069 = state_46055;
(statearr_46069[(9)] = inst_46048);

return statearr_46069;
})();
var statearr_46070_47931 = state_46055__$1;
(statearr_46070_47931[(2)] = null);

(statearr_46070_47931[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46056 === (13))){
var inst_45987 = (state_46055[(10)]);
var inst_45996 = cljs.core.chunked_seq_QMARK_(inst_45987);
var state_46055__$1 = state_46055;
if(inst_45996){
var statearr_46073_47932 = state_46055__$1;
(statearr_46073_47932[(1)] = (16));

} else {
var statearr_46074_47933 = state_46055__$1;
(statearr_46074_47933[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46056 === (22))){
var inst_46040 = (state_46055[(2)]);
var state_46055__$1 = state_46055;
if(cljs.core.truth_(inst_46040)){
var statearr_46075_47934 = state_46055__$1;
(statearr_46075_47934[(1)] = (23));

} else {
var statearr_46076_47935 = state_46055__$1;
(statearr_46076_47935[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46056 === (6))){
var inst_45963 = (state_46055[(8)]);
var inst_46036 = (state_46055[(11)]);
var inst_46034 = (state_46055[(7)]);
var inst_46034__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_45963) : topic_fn.call(null,inst_45963));
var inst_46035 = cljs.core.deref(mults);
var inst_46036__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46035,inst_46034__$1);
var state_46055__$1 = (function (){var statearr_46078 = state_46055;
(statearr_46078[(11)] = inst_46036__$1);

(statearr_46078[(7)] = inst_46034__$1);

return statearr_46078;
})();
if(cljs.core.truth_(inst_46036__$1)){
var statearr_46080_47936 = state_46055__$1;
(statearr_46080_47936[(1)] = (19));

} else {
var statearr_46081_47937 = state_46055__$1;
(statearr_46081_47937[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46056 === (25))){
var inst_46045 = (state_46055[(2)]);
var state_46055__$1 = state_46055;
var statearr_46083_47938 = state_46055__$1;
(statearr_46083_47938[(2)] = inst_46045);

(statearr_46083_47938[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46056 === (17))){
var inst_45987 = (state_46055[(10)]);
var inst_46019 = cljs.core.first(inst_45987);
var inst_46020 = cljs.core.async.muxch_STAR_(inst_46019);
var inst_46021 = cljs.core.async.close_BANG_(inst_46020);
var inst_46022 = cljs.core.next(inst_45987);
var inst_45973 = inst_46022;
var inst_45974 = null;
var inst_45975 = (0);
var inst_45976 = (0);
var state_46055__$1 = (function (){var statearr_46088 = state_46055;
(statearr_46088[(12)] = inst_45973);

(statearr_46088[(13)] = inst_45976);

(statearr_46088[(14)] = inst_45975);

(statearr_46088[(15)] = inst_46021);

(statearr_46088[(16)] = inst_45974);

return statearr_46088;
})();
var statearr_46089_47939 = state_46055__$1;
(statearr_46089_47939[(2)] = null);

(statearr_46089_47939[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46056 === (3))){
var inst_46053 = (state_46055[(2)]);
var state_46055__$1 = state_46055;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46055__$1,inst_46053);
} else {
if((state_val_46056 === (12))){
var inst_46030 = (state_46055[(2)]);
var state_46055__$1 = state_46055;
var statearr_46091_47940 = state_46055__$1;
(statearr_46091_47940[(2)] = inst_46030);

(statearr_46091_47940[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46056 === (2))){
var state_46055__$1 = state_46055;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46055__$1,(4),ch);
} else {
if((state_val_46056 === (23))){
var state_46055__$1 = state_46055;
var statearr_46094_47941 = state_46055__$1;
(statearr_46094_47941[(2)] = null);

(statearr_46094_47941[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46056 === (19))){
var inst_45963 = (state_46055[(8)]);
var inst_46036 = (state_46055[(11)]);
var inst_46038 = cljs.core.async.muxch_STAR_(inst_46036);
var state_46055__$1 = state_46055;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46055__$1,(22),inst_46038,inst_45963);
} else {
if((state_val_46056 === (11))){
var inst_45973 = (state_46055[(12)]);
var inst_45987 = (state_46055[(10)]);
var inst_45987__$1 = cljs.core.seq(inst_45973);
var state_46055__$1 = (function (){var statearr_46095 = state_46055;
(statearr_46095[(10)] = inst_45987__$1);

return statearr_46095;
})();
if(inst_45987__$1){
var statearr_46097_47942 = state_46055__$1;
(statearr_46097_47942[(1)] = (13));

} else {
var statearr_46098_47943 = state_46055__$1;
(statearr_46098_47943[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46056 === (9))){
var inst_46032 = (state_46055[(2)]);
var state_46055__$1 = state_46055;
var statearr_46100_47944 = state_46055__$1;
(statearr_46100_47944[(2)] = inst_46032);

(statearr_46100_47944[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46056 === (5))){
var inst_45970 = cljs.core.deref(mults);
var inst_45971 = cljs.core.vals(inst_45970);
var inst_45972 = cljs.core.seq(inst_45971);
var inst_45973 = inst_45972;
var inst_45974 = null;
var inst_45975 = (0);
var inst_45976 = (0);
var state_46055__$1 = (function (){var statearr_46101 = state_46055;
(statearr_46101[(12)] = inst_45973);

(statearr_46101[(13)] = inst_45976);

(statearr_46101[(14)] = inst_45975);

(statearr_46101[(16)] = inst_45974);

return statearr_46101;
})();
var statearr_46102_47946 = state_46055__$1;
(statearr_46102_47946[(2)] = null);

(statearr_46102_47946[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46056 === (14))){
var state_46055__$1 = state_46055;
var statearr_46107_47947 = state_46055__$1;
(statearr_46107_47947[(2)] = null);

(statearr_46107_47947[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46056 === (16))){
var inst_45987 = (state_46055[(10)]);
var inst_46009 = cljs.core.chunk_first(inst_45987);
var inst_46011 = cljs.core.chunk_rest(inst_45987);
var inst_46012 = cljs.core.count(inst_46009);
var inst_45973 = inst_46011;
var inst_45974 = inst_46009;
var inst_45975 = inst_46012;
var inst_45976 = (0);
var state_46055__$1 = (function (){var statearr_46108 = state_46055;
(statearr_46108[(12)] = inst_45973);

(statearr_46108[(13)] = inst_45976);

(statearr_46108[(14)] = inst_45975);

(statearr_46108[(16)] = inst_45974);

return statearr_46108;
})();
var statearr_46109_47948 = state_46055__$1;
(statearr_46109_47948[(2)] = null);

(statearr_46109_47948[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46056 === (10))){
var inst_45973 = (state_46055[(12)]);
var inst_45976 = (state_46055[(13)]);
var inst_45975 = (state_46055[(14)]);
var inst_45974 = (state_46055[(16)]);
var inst_45981 = cljs.core._nth(inst_45974,inst_45976);
var inst_45982 = cljs.core.async.muxch_STAR_(inst_45981);
var inst_45983 = cljs.core.async.close_BANG_(inst_45982);
var inst_45984 = (inst_45976 + (1));
var tmp46104 = inst_45973;
var tmp46105 = inst_45975;
var tmp46106 = inst_45974;
var inst_45973__$1 = tmp46104;
var inst_45974__$1 = tmp46106;
var inst_45975__$1 = tmp46105;
var inst_45976__$1 = inst_45984;
var state_46055__$1 = (function (){var statearr_46115 = state_46055;
(statearr_46115[(17)] = inst_45983);

(statearr_46115[(12)] = inst_45973__$1);

(statearr_46115[(13)] = inst_45976__$1);

(statearr_46115[(14)] = inst_45975__$1);

(statearr_46115[(16)] = inst_45974__$1);

return statearr_46115;
})();
var statearr_46117_47949 = state_46055__$1;
(statearr_46117_47949[(2)] = null);

(statearr_46117_47949[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46056 === (18))){
var inst_46025 = (state_46055[(2)]);
var state_46055__$1 = state_46055;
var statearr_46118_47950 = state_46055__$1;
(statearr_46118_47950[(2)] = inst_46025);

(statearr_46118_47950[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46056 === (8))){
var inst_45976 = (state_46055[(13)]);
var inst_45975 = (state_46055[(14)]);
var inst_45978 = (inst_45976 < inst_45975);
var inst_45979 = inst_45978;
var state_46055__$1 = state_46055;
if(cljs.core.truth_(inst_45979)){
var statearr_46120_47951 = state_46055__$1;
(statearr_46120_47951[(1)] = (10));

} else {
var statearr_46121_47952 = state_46055__$1;
(statearr_46121_47952[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43958__auto__ = null;
var cljs$core$async$state_machine__43958__auto____0 = (function (){
var statearr_46123 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46123[(0)] = cljs$core$async$state_machine__43958__auto__);

(statearr_46123[(1)] = (1));

return statearr_46123;
});
var cljs$core$async$state_machine__43958__auto____1 = (function (state_46055){
while(true){
var ret_value__43959__auto__ = (function (){try{while(true){
var result__43960__auto__ = switch__43957__auto__(state_46055);
if(cljs.core.keyword_identical_QMARK_(result__43960__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43960__auto__;
}
break;
}
}catch (e46126){var ex__43961__auto__ = e46126;
var statearr_46129_47953 = state_46055;
(statearr_46129_47953[(2)] = ex__43961__auto__);


if(cljs.core.seq((state_46055[(4)]))){
var statearr_46133_47954 = state_46055;
(statearr_46133_47954[(1)] = cljs.core.first((state_46055[(4)])));

} else {
throw ex__43961__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43959__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47959 = state_46055;
state_46055 = G__47959;
continue;
} else {
return ret_value__43959__auto__;
}
break;
}
});
cljs$core$async$state_machine__43958__auto__ = function(state_46055){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43958__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43958__auto____1.call(this,state_46055);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43958__auto____0;
cljs$core$async$state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43958__auto____1;
return cljs$core$async$state_machine__43958__auto__;
})()
})();
var state__44129__auto__ = (function (){var statearr_46134 = f__44128__auto__();
(statearr_46134[(6)] = c__44127__auto___47919);

return statearr_46134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44129__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__46141 = arguments.length;
switch (G__46141) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__46160 = arguments.length;
switch (G__46160) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__46179 = arguments.length;
switch (G__46179) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__44127__auto___47971 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44128__auto__ = (function (){var switch__43957__auto__ = (function (state_46249){
var state_val_46250 = (state_46249[(1)]);
if((state_val_46250 === (7))){
var state_46249__$1 = state_46249;
var statearr_46256_47972 = state_46249__$1;
(statearr_46256_47972[(2)] = null);

(statearr_46256_47972[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46250 === (1))){
var state_46249__$1 = state_46249;
var statearr_46257_47977 = state_46249__$1;
(statearr_46257_47977[(2)] = null);

(statearr_46257_47977[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46250 === (4))){
var inst_46204 = (state_46249[(7)]);
var inst_46206 = (state_46249[(8)]);
var inst_46208 = (inst_46206 < inst_46204);
var state_46249__$1 = state_46249;
if(cljs.core.truth_(inst_46208)){
var statearr_46259_47978 = state_46249__$1;
(statearr_46259_47978[(1)] = (6));

} else {
var statearr_46260_47983 = state_46249__$1;
(statearr_46260_47983[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46250 === (15))){
var inst_46232 = (state_46249[(9)]);
var inst_46238 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_46232);
var state_46249__$1 = state_46249;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46249__$1,(17),out,inst_46238);
} else {
if((state_val_46250 === (13))){
var inst_46232 = (state_46249[(9)]);
var inst_46232__$1 = (state_46249[(2)]);
var inst_46234 = cljs.core.some(cljs.core.nil_QMARK_,inst_46232__$1);
var state_46249__$1 = (function (){var statearr_46264 = state_46249;
(statearr_46264[(9)] = inst_46232__$1);

return statearr_46264;
})();
if(cljs.core.truth_(inst_46234)){
var statearr_46265_47985 = state_46249__$1;
(statearr_46265_47985[(1)] = (14));

} else {
var statearr_46266_47986 = state_46249__$1;
(statearr_46266_47986[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46250 === (6))){
var state_46249__$1 = state_46249;
var statearr_46267_47987 = state_46249__$1;
(statearr_46267_47987[(2)] = null);

(statearr_46267_47987[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46250 === (17))){
var inst_46240 = (state_46249[(2)]);
var state_46249__$1 = (function (){var statearr_46274 = state_46249;
(statearr_46274[(10)] = inst_46240);

return statearr_46274;
})();
var statearr_46276_47996 = state_46249__$1;
(statearr_46276_47996[(2)] = null);

(statearr_46276_47996[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46250 === (3))){
var inst_46245 = (state_46249[(2)]);
var state_46249__$1 = state_46249;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46249__$1,inst_46245);
} else {
if((state_val_46250 === (12))){
var _ = (function (){var statearr_46279 = state_46249;
(statearr_46279[(4)] = cljs.core.rest((state_46249[(4)])));

return statearr_46279;
})();
var state_46249__$1 = state_46249;
var ex46272 = (state_46249__$1[(2)]);
var statearr_46280_48001 = state_46249__$1;
(statearr_46280_48001[(5)] = ex46272);


if((ex46272 instanceof Object)){
var statearr_46281_48002 = state_46249__$1;
(statearr_46281_48002[(1)] = (11));

(statearr_46281_48002[(5)] = null);

} else {
throw ex46272;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46250 === (2))){
var inst_46200 = cljs.core.reset_BANG_(dctr,cnt);
var inst_46204 = cnt;
var inst_46206 = (0);
var state_46249__$1 = (function (){var statearr_46285 = state_46249;
(statearr_46285[(7)] = inst_46204);

(statearr_46285[(8)] = inst_46206);

(statearr_46285[(11)] = inst_46200);

return statearr_46285;
})();
var statearr_46287_48006 = state_46249__$1;
(statearr_46287_48006[(2)] = null);

(statearr_46287_48006[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46250 === (11))){
var inst_46211 = (state_46249[(2)]);
var inst_46212 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_46249__$1 = (function (){var statearr_46289 = state_46249;
(statearr_46289[(12)] = inst_46211);

return statearr_46289;
})();
var statearr_46291_48008 = state_46249__$1;
(statearr_46291_48008[(2)] = inst_46212);

(statearr_46291_48008[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46250 === (9))){
var inst_46206 = (state_46249[(8)]);
var _ = (function (){var statearr_46292 = state_46249;
(statearr_46292[(4)] = cljs.core.cons((12),(state_46249[(4)])));

return statearr_46292;
})();
var inst_46218 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_46206) : chs__$1.call(null,inst_46206));
var inst_46219 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_46206) : done.call(null,inst_46206));
var inst_46220 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_46218,inst_46219);
var ___$1 = (function (){var statearr_46293 = state_46249;
(statearr_46293[(4)] = cljs.core.rest((state_46249[(4)])));

return statearr_46293;
})();
var state_46249__$1 = state_46249;
var statearr_46294_48013 = state_46249__$1;
(statearr_46294_48013[(2)] = inst_46220);

(statearr_46294_48013[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46250 === (5))){
var inst_46230 = (state_46249[(2)]);
var state_46249__$1 = (function (){var statearr_46296 = state_46249;
(statearr_46296[(13)] = inst_46230);

return statearr_46296;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46249__$1,(13),dchan);
} else {
if((state_val_46250 === (14))){
var inst_46236 = cljs.core.async.close_BANG_(out);
var state_46249__$1 = state_46249;
var statearr_46297_48015 = state_46249__$1;
(statearr_46297_48015[(2)] = inst_46236);

(statearr_46297_48015[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46250 === (16))){
var inst_46243 = (state_46249[(2)]);
var state_46249__$1 = state_46249;
var statearr_46298_48016 = state_46249__$1;
(statearr_46298_48016[(2)] = inst_46243);

(statearr_46298_48016[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46250 === (10))){
var inst_46206 = (state_46249[(8)]);
var inst_46223 = (state_46249[(2)]);
var inst_46224 = (inst_46206 + (1));
var inst_46206__$1 = inst_46224;
var state_46249__$1 = (function (){var statearr_46299 = state_46249;
(statearr_46299[(8)] = inst_46206__$1);

(statearr_46299[(14)] = inst_46223);

return statearr_46299;
})();
var statearr_46300_48018 = state_46249__$1;
(statearr_46300_48018[(2)] = null);

(statearr_46300_48018[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46250 === (8))){
var inst_46228 = (state_46249[(2)]);
var state_46249__$1 = state_46249;
var statearr_46303_48022 = state_46249__$1;
(statearr_46303_48022[(2)] = inst_46228);

(statearr_46303_48022[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43958__auto__ = null;
var cljs$core$async$state_machine__43958__auto____0 = (function (){
var statearr_46307 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46307[(0)] = cljs$core$async$state_machine__43958__auto__);

(statearr_46307[(1)] = (1));

return statearr_46307;
});
var cljs$core$async$state_machine__43958__auto____1 = (function (state_46249){
while(true){
var ret_value__43959__auto__ = (function (){try{while(true){
var result__43960__auto__ = switch__43957__auto__(state_46249);
if(cljs.core.keyword_identical_QMARK_(result__43960__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43960__auto__;
}
break;
}
}catch (e46308){var ex__43961__auto__ = e46308;
var statearr_46309_48023 = state_46249;
(statearr_46309_48023[(2)] = ex__43961__auto__);


if(cljs.core.seq((state_46249[(4)]))){
var statearr_46310_48024 = state_46249;
(statearr_46310_48024[(1)] = cljs.core.first((state_46249[(4)])));

} else {
throw ex__43961__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43959__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48025 = state_46249;
state_46249 = G__48025;
continue;
} else {
return ret_value__43959__auto__;
}
break;
}
});
cljs$core$async$state_machine__43958__auto__ = function(state_46249){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43958__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43958__auto____1.call(this,state_46249);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43958__auto____0;
cljs$core$async$state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43958__auto____1;
return cljs$core$async$state_machine__43958__auto__;
})()
})();
var state__44129__auto__ = (function (){var statearr_46311 = f__44128__auto__();
(statearr_46311[(6)] = c__44127__auto___47971);

return statearr_46311;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44129__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__46314 = arguments.length;
switch (G__46314) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44127__auto___48031 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44128__auto__ = (function (){var switch__43957__auto__ = (function (state_46356){
var state_val_46357 = (state_46356[(1)]);
if((state_val_46357 === (7))){
var inst_46328 = (state_46356[(7)]);
var inst_46327 = (state_46356[(8)]);
var inst_46327__$1 = (state_46356[(2)]);
var inst_46328__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46327__$1,(0),null);
var inst_46329 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46327__$1,(1),null);
var inst_46333 = (inst_46328__$1 == null);
var state_46356__$1 = (function (){var statearr_46358 = state_46356;
(statearr_46358[(7)] = inst_46328__$1);

(statearr_46358[(8)] = inst_46327__$1);

(statearr_46358[(9)] = inst_46329);

return statearr_46358;
})();
if(cljs.core.truth_(inst_46333)){
var statearr_46359_48036 = state_46356__$1;
(statearr_46359_48036[(1)] = (8));

} else {
var statearr_46360_48037 = state_46356__$1;
(statearr_46360_48037[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46357 === (1))){
var inst_46317 = cljs.core.vec(chs);
var inst_46318 = inst_46317;
var state_46356__$1 = (function (){var statearr_46361 = state_46356;
(statearr_46361[(10)] = inst_46318);

return statearr_46361;
})();
var statearr_46362_48038 = state_46356__$1;
(statearr_46362_48038[(2)] = null);

(statearr_46362_48038[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46357 === (4))){
var inst_46318 = (state_46356[(10)]);
var state_46356__$1 = state_46356;
return cljs.core.async.ioc_alts_BANG_(state_46356__$1,(7),inst_46318);
} else {
if((state_val_46357 === (6))){
var inst_46352 = (state_46356[(2)]);
var state_46356__$1 = state_46356;
var statearr_46363_48039 = state_46356__$1;
(statearr_46363_48039[(2)] = inst_46352);

(statearr_46363_48039[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46357 === (3))){
var inst_46354 = (state_46356[(2)]);
var state_46356__$1 = state_46356;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46356__$1,inst_46354);
} else {
if((state_val_46357 === (2))){
var inst_46318 = (state_46356[(10)]);
var inst_46320 = cljs.core.count(inst_46318);
var inst_46321 = (inst_46320 > (0));
var state_46356__$1 = state_46356;
if(cljs.core.truth_(inst_46321)){
var statearr_46365_48044 = state_46356__$1;
(statearr_46365_48044[(1)] = (4));

} else {
var statearr_46366_48045 = state_46356__$1;
(statearr_46366_48045[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46357 === (11))){
var inst_46318 = (state_46356[(10)]);
var inst_46345 = (state_46356[(2)]);
var tmp46364 = inst_46318;
var inst_46318__$1 = tmp46364;
var state_46356__$1 = (function (){var statearr_46368 = state_46356;
(statearr_46368[(10)] = inst_46318__$1);

(statearr_46368[(11)] = inst_46345);

return statearr_46368;
})();
var statearr_46369_48051 = state_46356__$1;
(statearr_46369_48051[(2)] = null);

(statearr_46369_48051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46357 === (9))){
var inst_46328 = (state_46356[(7)]);
var state_46356__$1 = state_46356;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46356__$1,(11),out,inst_46328);
} else {
if((state_val_46357 === (5))){
var inst_46350 = cljs.core.async.close_BANG_(out);
var state_46356__$1 = state_46356;
var statearr_46370_48057 = state_46356__$1;
(statearr_46370_48057[(2)] = inst_46350);

(statearr_46370_48057[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46357 === (10))){
var inst_46348 = (state_46356[(2)]);
var state_46356__$1 = state_46356;
var statearr_46371_48058 = state_46356__$1;
(statearr_46371_48058[(2)] = inst_46348);

(statearr_46371_48058[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46357 === (8))){
var inst_46328 = (state_46356[(7)]);
var inst_46318 = (state_46356[(10)]);
var inst_46327 = (state_46356[(8)]);
var inst_46329 = (state_46356[(9)]);
var inst_46340 = (function (){var cs = inst_46318;
var vec__46323 = inst_46327;
var v = inst_46328;
var c = inst_46329;
return (function (p1__46312_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__46312_SHARP_);
});
})();
var inst_46341 = cljs.core.filterv(inst_46340,inst_46318);
var inst_46318__$1 = inst_46341;
var state_46356__$1 = (function (){var statearr_46374 = state_46356;
(statearr_46374[(10)] = inst_46318__$1);

return statearr_46374;
})();
var statearr_46375_48063 = state_46356__$1;
(statearr_46375_48063[(2)] = null);

(statearr_46375_48063[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43958__auto__ = null;
var cljs$core$async$state_machine__43958__auto____0 = (function (){
var statearr_46380 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46380[(0)] = cljs$core$async$state_machine__43958__auto__);

(statearr_46380[(1)] = (1));

return statearr_46380;
});
var cljs$core$async$state_machine__43958__auto____1 = (function (state_46356){
while(true){
var ret_value__43959__auto__ = (function (){try{while(true){
var result__43960__auto__ = switch__43957__auto__(state_46356);
if(cljs.core.keyword_identical_QMARK_(result__43960__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43960__auto__;
}
break;
}
}catch (e46383){var ex__43961__auto__ = e46383;
var statearr_46384_48068 = state_46356;
(statearr_46384_48068[(2)] = ex__43961__auto__);


if(cljs.core.seq((state_46356[(4)]))){
var statearr_46386_48069 = state_46356;
(statearr_46386_48069[(1)] = cljs.core.first((state_46356[(4)])));

} else {
throw ex__43961__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43959__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48070 = state_46356;
state_46356 = G__48070;
continue;
} else {
return ret_value__43959__auto__;
}
break;
}
});
cljs$core$async$state_machine__43958__auto__ = function(state_46356){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43958__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43958__auto____1.call(this,state_46356);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43958__auto____0;
cljs$core$async$state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43958__auto____1;
return cljs$core$async$state_machine__43958__auto__;
})()
})();
var state__44129__auto__ = (function (){var statearr_46388 = f__44128__auto__();
(statearr_46388[(6)] = c__44127__auto___48031);

return statearr_46388;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44129__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__46398 = arguments.length;
switch (G__46398) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44127__auto___48076 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44128__auto__ = (function (){var switch__43957__auto__ = (function (state_46432){
var state_val_46433 = (state_46432[(1)]);
if((state_val_46433 === (7))){
var inst_46413 = (state_46432[(7)]);
var inst_46413__$1 = (state_46432[(2)]);
var inst_46414 = (inst_46413__$1 == null);
var inst_46415 = cljs.core.not(inst_46414);
var state_46432__$1 = (function (){var statearr_46448 = state_46432;
(statearr_46448[(7)] = inst_46413__$1);

return statearr_46448;
})();
if(inst_46415){
var statearr_46449_48080 = state_46432__$1;
(statearr_46449_48080[(1)] = (8));

} else {
var statearr_46450_48081 = state_46432__$1;
(statearr_46450_48081[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46433 === (1))){
var inst_46403 = (0);
var state_46432__$1 = (function (){var statearr_46451 = state_46432;
(statearr_46451[(8)] = inst_46403);

return statearr_46451;
})();
var statearr_46453_48082 = state_46432__$1;
(statearr_46453_48082[(2)] = null);

(statearr_46453_48082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46433 === (4))){
var state_46432__$1 = state_46432;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46432__$1,(7),ch);
} else {
if((state_val_46433 === (6))){
var inst_46427 = (state_46432[(2)]);
var state_46432__$1 = state_46432;
var statearr_46454_48084 = state_46432__$1;
(statearr_46454_48084[(2)] = inst_46427);

(statearr_46454_48084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46433 === (3))){
var inst_46429 = (state_46432[(2)]);
var inst_46430 = cljs.core.async.close_BANG_(out);
var state_46432__$1 = (function (){var statearr_46461 = state_46432;
(statearr_46461[(9)] = inst_46429);

return statearr_46461;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_46432__$1,inst_46430);
} else {
if((state_val_46433 === (2))){
var inst_46403 = (state_46432[(8)]);
var inst_46406 = (inst_46403 < n);
var state_46432__$1 = state_46432;
if(cljs.core.truth_(inst_46406)){
var statearr_46462_48085 = state_46432__$1;
(statearr_46462_48085[(1)] = (4));

} else {
var statearr_46463_48086 = state_46432__$1;
(statearr_46463_48086[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46433 === (11))){
var inst_46403 = (state_46432[(8)]);
var inst_46418 = (state_46432[(2)]);
var inst_46419 = (inst_46403 + (1));
var inst_46403__$1 = inst_46419;
var state_46432__$1 = (function (){var statearr_46464 = state_46432;
(statearr_46464[(10)] = inst_46418);

(statearr_46464[(8)] = inst_46403__$1);

return statearr_46464;
})();
var statearr_46469_48087 = state_46432__$1;
(statearr_46469_48087[(2)] = null);

(statearr_46469_48087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46433 === (9))){
var state_46432__$1 = state_46432;
var statearr_46470_48088 = state_46432__$1;
(statearr_46470_48088[(2)] = null);

(statearr_46470_48088[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46433 === (5))){
var state_46432__$1 = state_46432;
var statearr_46471_48089 = state_46432__$1;
(statearr_46471_48089[(2)] = null);

(statearr_46471_48089[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46433 === (10))){
var inst_46424 = (state_46432[(2)]);
var state_46432__$1 = state_46432;
var statearr_46473_48090 = state_46432__$1;
(statearr_46473_48090[(2)] = inst_46424);

(statearr_46473_48090[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46433 === (8))){
var inst_46413 = (state_46432[(7)]);
var state_46432__$1 = state_46432;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46432__$1,(11),out,inst_46413);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43958__auto__ = null;
var cljs$core$async$state_machine__43958__auto____0 = (function (){
var statearr_46487 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_46487[(0)] = cljs$core$async$state_machine__43958__auto__);

(statearr_46487[(1)] = (1));

return statearr_46487;
});
var cljs$core$async$state_machine__43958__auto____1 = (function (state_46432){
while(true){
var ret_value__43959__auto__ = (function (){try{while(true){
var result__43960__auto__ = switch__43957__auto__(state_46432);
if(cljs.core.keyword_identical_QMARK_(result__43960__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43960__auto__;
}
break;
}
}catch (e46488){var ex__43961__auto__ = e46488;
var statearr_46489_48094 = state_46432;
(statearr_46489_48094[(2)] = ex__43961__auto__);


if(cljs.core.seq((state_46432[(4)]))){
var statearr_46490_48095 = state_46432;
(statearr_46490_48095[(1)] = cljs.core.first((state_46432[(4)])));

} else {
throw ex__43961__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43959__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48096 = state_46432;
state_46432 = G__48096;
continue;
} else {
return ret_value__43959__auto__;
}
break;
}
});
cljs$core$async$state_machine__43958__auto__ = function(state_46432){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43958__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43958__auto____1.call(this,state_46432);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43958__auto____0;
cljs$core$async$state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43958__auto____1;
return cljs$core$async$state_machine__43958__auto__;
})()
})();
var state__44129__auto__ = (function (){var statearr_46500 = f__44128__auto__();
(statearr_46500[(6)] = c__44127__auto___48076);

return statearr_46500;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44129__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46504 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46504 = (function (f,ch,meta46505){
this.f = f;
this.ch = ch;
this.meta46505 = meta46505;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46504.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46506,meta46505__$1){
var self__ = this;
var _46506__$1 = this;
return (new cljs.core.async.t_cljs$core$async46504(self__.f,self__.ch,meta46505__$1));
}));

(cljs.core.async.t_cljs$core$async46504.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46506){
var self__ = this;
var _46506__$1 = this;
return self__.meta46505;
}));

(cljs.core.async.t_cljs$core$async46504.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46504.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async46504.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async46504.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46504.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46508 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46508 = (function (f,ch,meta46505,_,fn1,meta46509){
this.f = f;
this.ch = ch;
this.meta46505 = meta46505;
this._ = _;
this.fn1 = fn1;
this.meta46509 = meta46509;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46508.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46510,meta46509__$1){
var self__ = this;
var _46510__$1 = this;
return (new cljs.core.async.t_cljs$core$async46508(self__.f,self__.ch,self__.meta46505,self__._,self__.fn1,meta46509__$1));
}));

(cljs.core.async.t_cljs$core$async46508.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46510){
var self__ = this;
var _46510__$1 = this;
return self__.meta46509;
}));

(cljs.core.async.t_cljs$core$async46508.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46508.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async46508.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async46508.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__46503_SHARP_){
var G__46511 = (((p1__46503_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__46503_SHARP_) : self__.f.call(null,p1__46503_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__46511) : f1.call(null,G__46511));
});
}));

(cljs.core.async.t_cljs$core$async46508.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta46505","meta46505",1212014014,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async46504","cljs.core.async/t_cljs$core$async46504",-1685880812,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta46509","meta46509",2052986647,null)], null);
}));

(cljs.core.async.t_cljs$core$async46508.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46508.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46508");

(cljs.core.async.t_cljs$core$async46508.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async46508");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46508.
 */
cljs.core.async.__GT_t_cljs$core$async46508 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async46508(f__$1,ch__$1,meta46505__$1,___$2,fn1__$1,meta46509){
return (new cljs.core.async.t_cljs$core$async46508(f__$1,ch__$1,meta46505__$1,___$2,fn1__$1,meta46509));
});

}

return (new cljs.core.async.t_cljs$core$async46508(self__.f,self__.ch,self__.meta46505,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4251__auto__ = ret;
if(cljs.core.truth_(and__4251__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4251__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__46521 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__46521) : self__.f.call(null,G__46521));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async46504.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46504.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async46504.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta46505","meta46505",1212014014,null)], null);
}));

(cljs.core.async.t_cljs$core$async46504.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46504.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46504");

(cljs.core.async.t_cljs$core$async46504.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async46504");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46504.
 */
cljs.core.async.__GT_t_cljs$core$async46504 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async46504(f__$1,ch__$1,meta46505){
return (new cljs.core.async.t_cljs$core$async46504(f__$1,ch__$1,meta46505));
});

}

return (new cljs.core.async.t_cljs$core$async46504(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46529 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46529 = (function (f,ch,meta46530){
this.f = f;
this.ch = ch;
this.meta46530 = meta46530;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46529.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46531,meta46530__$1){
var self__ = this;
var _46531__$1 = this;
return (new cljs.core.async.t_cljs$core$async46529(self__.f,self__.ch,meta46530__$1));
}));

(cljs.core.async.t_cljs$core$async46529.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46531){
var self__ = this;
var _46531__$1 = this;
return self__.meta46530;
}));

(cljs.core.async.t_cljs$core$async46529.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46529.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async46529.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46529.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async46529.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46529.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async46529.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta46530","meta46530",71369875,null)], null);
}));

(cljs.core.async.t_cljs$core$async46529.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46529.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46529");

(cljs.core.async.t_cljs$core$async46529.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async46529");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46529.
 */
cljs.core.async.__GT_t_cljs$core$async46529 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async46529(f__$1,ch__$1,meta46530){
return (new cljs.core.async.t_cljs$core$async46529(f__$1,ch__$1,meta46530));
});

}

return (new cljs.core.async.t_cljs$core$async46529(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46567 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46567 = (function (p,ch,meta46568){
this.p = p;
this.ch = ch;
this.meta46568 = meta46568;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46567.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46569,meta46568__$1){
var self__ = this;
var _46569__$1 = this;
return (new cljs.core.async.t_cljs$core$async46567(self__.p,self__.ch,meta46568__$1));
}));

(cljs.core.async.t_cljs$core$async46567.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46569){
var self__ = this;
var _46569__$1 = this;
return self__.meta46568;
}));

(cljs.core.async.t_cljs$core$async46567.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46567.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async46567.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async46567.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46567.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async46567.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46567.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async46567.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta46568","meta46568",-13629557,null)], null);
}));

(cljs.core.async.t_cljs$core$async46567.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46567.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46567");

(cljs.core.async.t_cljs$core$async46567.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async46567");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46567.
 */
cljs.core.async.__GT_t_cljs$core$async46567 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async46567(p__$1,ch__$1,meta46568){
return (new cljs.core.async.t_cljs$core$async46567(p__$1,ch__$1,meta46568));
});

}

return (new cljs.core.async.t_cljs$core$async46567(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__46579 = arguments.length;
switch (G__46579) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44127__auto___48135 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44128__auto__ = (function (){var switch__43957__auto__ = (function (state_46604){
var state_val_46605 = (state_46604[(1)]);
if((state_val_46605 === (7))){
var inst_46600 = (state_46604[(2)]);
var state_46604__$1 = state_46604;
var statearr_46627_48136 = state_46604__$1;
(statearr_46627_48136[(2)] = inst_46600);

(statearr_46627_48136[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46605 === (1))){
var state_46604__$1 = state_46604;
var statearr_46628_48137 = state_46604__$1;
(statearr_46628_48137[(2)] = null);

(statearr_46628_48137[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46605 === (4))){
var inst_46586 = (state_46604[(7)]);
var inst_46586__$1 = (state_46604[(2)]);
var inst_46587 = (inst_46586__$1 == null);
var state_46604__$1 = (function (){var statearr_46629 = state_46604;
(statearr_46629[(7)] = inst_46586__$1);

return statearr_46629;
})();
if(cljs.core.truth_(inst_46587)){
var statearr_46630_48138 = state_46604__$1;
(statearr_46630_48138[(1)] = (5));

} else {
var statearr_46631_48139 = state_46604__$1;
(statearr_46631_48139[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46605 === (6))){
var inst_46586 = (state_46604[(7)]);
var inst_46591 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_46586) : p.call(null,inst_46586));
var state_46604__$1 = state_46604;
if(cljs.core.truth_(inst_46591)){
var statearr_46632_48140 = state_46604__$1;
(statearr_46632_48140[(1)] = (8));

} else {
var statearr_46633_48141 = state_46604__$1;
(statearr_46633_48141[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46605 === (3))){
var inst_46602 = (state_46604[(2)]);
var state_46604__$1 = state_46604;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46604__$1,inst_46602);
} else {
if((state_val_46605 === (2))){
var state_46604__$1 = state_46604;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46604__$1,(4),ch);
} else {
if((state_val_46605 === (11))){
var inst_46594 = (state_46604[(2)]);
var state_46604__$1 = state_46604;
var statearr_46634_48144 = state_46604__$1;
(statearr_46634_48144[(2)] = inst_46594);

(statearr_46634_48144[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46605 === (9))){
var state_46604__$1 = state_46604;
var statearr_46635_48145 = state_46604__$1;
(statearr_46635_48145[(2)] = null);

(statearr_46635_48145[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46605 === (5))){
var inst_46589 = cljs.core.async.close_BANG_(out);
var state_46604__$1 = state_46604;
var statearr_46636_48146 = state_46604__$1;
(statearr_46636_48146[(2)] = inst_46589);

(statearr_46636_48146[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46605 === (10))){
var inst_46597 = (state_46604[(2)]);
var state_46604__$1 = (function (){var statearr_46637 = state_46604;
(statearr_46637[(8)] = inst_46597);

return statearr_46637;
})();
var statearr_46638_48147 = state_46604__$1;
(statearr_46638_48147[(2)] = null);

(statearr_46638_48147[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46605 === (8))){
var inst_46586 = (state_46604[(7)]);
var state_46604__$1 = state_46604;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46604__$1,(11),out,inst_46586);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43958__auto__ = null;
var cljs$core$async$state_machine__43958__auto____0 = (function (){
var statearr_46639 = [null,null,null,null,null,null,null,null,null];
(statearr_46639[(0)] = cljs$core$async$state_machine__43958__auto__);

(statearr_46639[(1)] = (1));

return statearr_46639;
});
var cljs$core$async$state_machine__43958__auto____1 = (function (state_46604){
while(true){
var ret_value__43959__auto__ = (function (){try{while(true){
var result__43960__auto__ = switch__43957__auto__(state_46604);
if(cljs.core.keyword_identical_QMARK_(result__43960__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43960__auto__;
}
break;
}
}catch (e46640){var ex__43961__auto__ = e46640;
var statearr_46641_48148 = state_46604;
(statearr_46641_48148[(2)] = ex__43961__auto__);


if(cljs.core.seq((state_46604[(4)]))){
var statearr_46642_48149 = state_46604;
(statearr_46642_48149[(1)] = cljs.core.first((state_46604[(4)])));

} else {
throw ex__43961__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43959__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48150 = state_46604;
state_46604 = G__48150;
continue;
} else {
return ret_value__43959__auto__;
}
break;
}
});
cljs$core$async$state_machine__43958__auto__ = function(state_46604){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43958__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43958__auto____1.call(this,state_46604);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43958__auto____0;
cljs$core$async$state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43958__auto____1;
return cljs$core$async$state_machine__43958__auto__;
})()
})();
var state__44129__auto__ = (function (){var statearr_46643 = f__44128__auto__();
(statearr_46643[(6)] = c__44127__auto___48135);

return statearr_46643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44129__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__46660 = arguments.length;
switch (G__46660) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__44127__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44128__auto__ = (function (){var switch__43957__auto__ = (function (state_46737){
var state_val_46738 = (state_46737[(1)]);
if((state_val_46738 === (7))){
var inst_46731 = (state_46737[(2)]);
var state_46737__$1 = state_46737;
var statearr_46742_48152 = state_46737__$1;
(statearr_46742_48152[(2)] = inst_46731);

(statearr_46742_48152[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46738 === (20))){
var inst_46701 = (state_46737[(7)]);
var inst_46712 = (state_46737[(2)]);
var inst_46713 = cljs.core.next(inst_46701);
var inst_46687 = inst_46713;
var inst_46688 = null;
var inst_46689 = (0);
var inst_46690 = (0);
var state_46737__$1 = (function (){var statearr_46743 = state_46737;
(statearr_46743[(8)] = inst_46688);

(statearr_46743[(9)] = inst_46687);

(statearr_46743[(10)] = inst_46690);

(statearr_46743[(11)] = inst_46712);

(statearr_46743[(12)] = inst_46689);

return statearr_46743;
})();
var statearr_46744_48153 = state_46737__$1;
(statearr_46744_48153[(2)] = null);

(statearr_46744_48153[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46738 === (1))){
var state_46737__$1 = state_46737;
var statearr_46745_48154 = state_46737__$1;
(statearr_46745_48154[(2)] = null);

(statearr_46745_48154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46738 === (4))){
var inst_46673 = (state_46737[(13)]);
var inst_46673__$1 = (state_46737[(2)]);
var inst_46674 = (inst_46673__$1 == null);
var state_46737__$1 = (function (){var statearr_46746 = state_46737;
(statearr_46746[(13)] = inst_46673__$1);

return statearr_46746;
})();
if(cljs.core.truth_(inst_46674)){
var statearr_46747_48155 = state_46737__$1;
(statearr_46747_48155[(1)] = (5));

} else {
var statearr_46752_48156 = state_46737__$1;
(statearr_46752_48156[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46738 === (15))){
var state_46737__$1 = state_46737;
var statearr_46760_48157 = state_46737__$1;
(statearr_46760_48157[(2)] = null);

(statearr_46760_48157[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46738 === (21))){
var state_46737__$1 = state_46737;
var statearr_46762_48158 = state_46737__$1;
(statearr_46762_48158[(2)] = null);

(statearr_46762_48158[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46738 === (13))){
var inst_46688 = (state_46737[(8)]);
var inst_46687 = (state_46737[(9)]);
var inst_46690 = (state_46737[(10)]);
var inst_46689 = (state_46737[(12)]);
var inst_46697 = (state_46737[(2)]);
var inst_46698 = (inst_46690 + (1));
var tmp46757 = inst_46688;
var tmp46758 = inst_46687;
var tmp46759 = inst_46689;
var inst_46687__$1 = tmp46758;
var inst_46688__$1 = tmp46757;
var inst_46689__$1 = tmp46759;
var inst_46690__$1 = inst_46698;
var state_46737__$1 = (function (){var statearr_46767 = state_46737;
(statearr_46767[(8)] = inst_46688__$1);

(statearr_46767[(9)] = inst_46687__$1);

(statearr_46767[(14)] = inst_46697);

(statearr_46767[(10)] = inst_46690__$1);

(statearr_46767[(12)] = inst_46689__$1);

return statearr_46767;
})();
var statearr_46768_48159 = state_46737__$1;
(statearr_46768_48159[(2)] = null);

(statearr_46768_48159[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46738 === (22))){
var state_46737__$1 = state_46737;
var statearr_46770_48160 = state_46737__$1;
(statearr_46770_48160[(2)] = null);

(statearr_46770_48160[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46738 === (6))){
var inst_46673 = (state_46737[(13)]);
var inst_46685 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_46673) : f.call(null,inst_46673));
var inst_46686 = cljs.core.seq(inst_46685);
var inst_46687 = inst_46686;
var inst_46688 = null;
var inst_46689 = (0);
var inst_46690 = (0);
var state_46737__$1 = (function (){var statearr_46771 = state_46737;
(statearr_46771[(8)] = inst_46688);

(statearr_46771[(9)] = inst_46687);

(statearr_46771[(10)] = inst_46690);

(statearr_46771[(12)] = inst_46689);

return statearr_46771;
})();
var statearr_46772_48161 = state_46737__$1;
(statearr_46772_48161[(2)] = null);

(statearr_46772_48161[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46738 === (17))){
var inst_46701 = (state_46737[(7)]);
var inst_46705 = cljs.core.chunk_first(inst_46701);
var inst_46706 = cljs.core.chunk_rest(inst_46701);
var inst_46707 = cljs.core.count(inst_46705);
var inst_46687 = inst_46706;
var inst_46688 = inst_46705;
var inst_46689 = inst_46707;
var inst_46690 = (0);
var state_46737__$1 = (function (){var statearr_46774 = state_46737;
(statearr_46774[(8)] = inst_46688);

(statearr_46774[(9)] = inst_46687);

(statearr_46774[(10)] = inst_46690);

(statearr_46774[(12)] = inst_46689);

return statearr_46774;
})();
var statearr_46775_48172 = state_46737__$1;
(statearr_46775_48172[(2)] = null);

(statearr_46775_48172[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46738 === (3))){
var inst_46733 = (state_46737[(2)]);
var state_46737__$1 = state_46737;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46737__$1,inst_46733);
} else {
if((state_val_46738 === (12))){
var inst_46721 = (state_46737[(2)]);
var state_46737__$1 = state_46737;
var statearr_46778_48173 = state_46737__$1;
(statearr_46778_48173[(2)] = inst_46721);

(statearr_46778_48173[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46738 === (2))){
var state_46737__$1 = state_46737;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46737__$1,(4),in$);
} else {
if((state_val_46738 === (23))){
var inst_46729 = (state_46737[(2)]);
var state_46737__$1 = state_46737;
var statearr_46783_48174 = state_46737__$1;
(statearr_46783_48174[(2)] = inst_46729);

(statearr_46783_48174[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46738 === (19))){
var inst_46716 = (state_46737[(2)]);
var state_46737__$1 = state_46737;
var statearr_46784_48175 = state_46737__$1;
(statearr_46784_48175[(2)] = inst_46716);

(statearr_46784_48175[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46738 === (11))){
var inst_46687 = (state_46737[(9)]);
var inst_46701 = (state_46737[(7)]);
var inst_46701__$1 = cljs.core.seq(inst_46687);
var state_46737__$1 = (function (){var statearr_46787 = state_46737;
(statearr_46787[(7)] = inst_46701__$1);

return statearr_46787;
})();
if(inst_46701__$1){
var statearr_46788_48176 = state_46737__$1;
(statearr_46788_48176[(1)] = (14));

} else {
var statearr_46789_48177 = state_46737__$1;
(statearr_46789_48177[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46738 === (9))){
var inst_46723 = (state_46737[(2)]);
var inst_46724 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_46737__$1 = (function (){var statearr_46791 = state_46737;
(statearr_46791[(15)] = inst_46723);

return statearr_46791;
})();
if(cljs.core.truth_(inst_46724)){
var statearr_46792_48179 = state_46737__$1;
(statearr_46792_48179[(1)] = (21));

} else {
var statearr_46793_48180 = state_46737__$1;
(statearr_46793_48180[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46738 === (5))){
var inst_46676 = cljs.core.async.close_BANG_(out);
var state_46737__$1 = state_46737;
var statearr_46794_48182 = state_46737__$1;
(statearr_46794_48182[(2)] = inst_46676);

(statearr_46794_48182[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46738 === (14))){
var inst_46701 = (state_46737[(7)]);
var inst_46703 = cljs.core.chunked_seq_QMARK_(inst_46701);
var state_46737__$1 = state_46737;
if(inst_46703){
var statearr_46800_48186 = state_46737__$1;
(statearr_46800_48186[(1)] = (17));

} else {
var statearr_46801_48187 = state_46737__$1;
(statearr_46801_48187[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46738 === (16))){
var inst_46719 = (state_46737[(2)]);
var state_46737__$1 = state_46737;
var statearr_46806_48188 = state_46737__$1;
(statearr_46806_48188[(2)] = inst_46719);

(statearr_46806_48188[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46738 === (10))){
var inst_46688 = (state_46737[(8)]);
var inst_46690 = (state_46737[(10)]);
var inst_46695 = cljs.core._nth(inst_46688,inst_46690);
var state_46737__$1 = state_46737;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46737__$1,(13),out,inst_46695);
} else {
if((state_val_46738 === (18))){
var inst_46701 = (state_46737[(7)]);
var inst_46710 = cljs.core.first(inst_46701);
var state_46737__$1 = state_46737;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46737__$1,(20),out,inst_46710);
} else {
if((state_val_46738 === (8))){
var inst_46690 = (state_46737[(10)]);
var inst_46689 = (state_46737[(12)]);
var inst_46692 = (inst_46690 < inst_46689);
var inst_46693 = inst_46692;
var state_46737__$1 = state_46737;
if(cljs.core.truth_(inst_46693)){
var statearr_46813_48192 = state_46737__$1;
(statearr_46813_48192[(1)] = (10));

} else {
var statearr_46814_48193 = state_46737__$1;
(statearr_46814_48193[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__43958__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__43958__auto____0 = (function (){
var statearr_46815 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46815[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__43958__auto__);

(statearr_46815[(1)] = (1));

return statearr_46815;
});
var cljs$core$async$mapcat_STAR__$_state_machine__43958__auto____1 = (function (state_46737){
while(true){
var ret_value__43959__auto__ = (function (){try{while(true){
var result__43960__auto__ = switch__43957__auto__(state_46737);
if(cljs.core.keyword_identical_QMARK_(result__43960__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43960__auto__;
}
break;
}
}catch (e46816){var ex__43961__auto__ = e46816;
var statearr_46817_48194 = state_46737;
(statearr_46817_48194[(2)] = ex__43961__auto__);


if(cljs.core.seq((state_46737[(4)]))){
var statearr_46818_48195 = state_46737;
(statearr_46818_48195[(1)] = cljs.core.first((state_46737[(4)])));

} else {
throw ex__43961__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43959__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48196 = state_46737;
state_46737 = G__48196;
continue;
} else {
return ret_value__43959__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__43958__auto__ = function(state_46737){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__43958__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__43958__auto____1.call(this,state_46737);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__43958__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__43958__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__43958__auto__;
})()
})();
var state__44129__auto__ = (function (){var statearr_46819 = f__44128__auto__();
(statearr_46819[(6)] = c__44127__auto__);

return statearr_46819;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44129__auto__);
}));

return c__44127__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__46821 = arguments.length;
switch (G__46821) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__46841 = arguments.length;
switch (G__46841) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__46843 = arguments.length;
switch (G__46843) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44127__auto___48207 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44128__auto__ = (function (){var switch__43957__auto__ = (function (state_46868){
var state_val_46869 = (state_46868[(1)]);
if((state_val_46869 === (7))){
var inst_46863 = (state_46868[(2)]);
var state_46868__$1 = state_46868;
var statearr_46870_48212 = state_46868__$1;
(statearr_46870_48212[(2)] = inst_46863);

(statearr_46870_48212[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46869 === (1))){
var inst_46845 = null;
var state_46868__$1 = (function (){var statearr_46871 = state_46868;
(statearr_46871[(7)] = inst_46845);

return statearr_46871;
})();
var statearr_46872_48219 = state_46868__$1;
(statearr_46872_48219[(2)] = null);

(statearr_46872_48219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46869 === (4))){
var inst_46848 = (state_46868[(8)]);
var inst_46848__$1 = (state_46868[(2)]);
var inst_46849 = (inst_46848__$1 == null);
var inst_46850 = cljs.core.not(inst_46849);
var state_46868__$1 = (function (){var statearr_46873 = state_46868;
(statearr_46873[(8)] = inst_46848__$1);

return statearr_46873;
})();
if(inst_46850){
var statearr_46875_48220 = state_46868__$1;
(statearr_46875_48220[(1)] = (5));

} else {
var statearr_46876_48227 = state_46868__$1;
(statearr_46876_48227[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46869 === (6))){
var state_46868__$1 = state_46868;
var statearr_46877_48228 = state_46868__$1;
(statearr_46877_48228[(2)] = null);

(statearr_46877_48228[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46869 === (3))){
var inst_46865 = (state_46868[(2)]);
var inst_46866 = cljs.core.async.close_BANG_(out);
var state_46868__$1 = (function (){var statearr_46878 = state_46868;
(statearr_46878[(9)] = inst_46865);

return statearr_46878;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_46868__$1,inst_46866);
} else {
if((state_val_46869 === (2))){
var state_46868__$1 = state_46868;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46868__$1,(4),ch);
} else {
if((state_val_46869 === (11))){
var inst_46848 = (state_46868[(8)]);
var inst_46857 = (state_46868[(2)]);
var inst_46845 = inst_46848;
var state_46868__$1 = (function (){var statearr_46879 = state_46868;
(statearr_46879[(10)] = inst_46857);

(statearr_46879[(7)] = inst_46845);

return statearr_46879;
})();
var statearr_46880_48229 = state_46868__$1;
(statearr_46880_48229[(2)] = null);

(statearr_46880_48229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46869 === (9))){
var inst_46848 = (state_46868[(8)]);
var state_46868__$1 = state_46868;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46868__$1,(11),out,inst_46848);
} else {
if((state_val_46869 === (5))){
var inst_46848 = (state_46868[(8)]);
var inst_46845 = (state_46868[(7)]);
var inst_46852 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_46848,inst_46845);
var state_46868__$1 = state_46868;
if(inst_46852){
var statearr_46885_48236 = state_46868__$1;
(statearr_46885_48236[(1)] = (8));

} else {
var statearr_46887_48237 = state_46868__$1;
(statearr_46887_48237[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46869 === (10))){
var inst_46860 = (state_46868[(2)]);
var state_46868__$1 = state_46868;
var statearr_46891_48238 = state_46868__$1;
(statearr_46891_48238[(2)] = inst_46860);

(statearr_46891_48238[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46869 === (8))){
var inst_46845 = (state_46868[(7)]);
var tmp46883 = inst_46845;
var inst_46845__$1 = tmp46883;
var state_46868__$1 = (function (){var statearr_46894 = state_46868;
(statearr_46894[(7)] = inst_46845__$1);

return statearr_46894;
})();
var statearr_46897_48239 = state_46868__$1;
(statearr_46897_48239[(2)] = null);

(statearr_46897_48239[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43958__auto__ = null;
var cljs$core$async$state_machine__43958__auto____0 = (function (){
var statearr_46898 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_46898[(0)] = cljs$core$async$state_machine__43958__auto__);

(statearr_46898[(1)] = (1));

return statearr_46898;
});
var cljs$core$async$state_machine__43958__auto____1 = (function (state_46868){
while(true){
var ret_value__43959__auto__ = (function (){try{while(true){
var result__43960__auto__ = switch__43957__auto__(state_46868);
if(cljs.core.keyword_identical_QMARK_(result__43960__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43960__auto__;
}
break;
}
}catch (e46899){var ex__43961__auto__ = e46899;
var statearr_46900_48240 = state_46868;
(statearr_46900_48240[(2)] = ex__43961__auto__);


if(cljs.core.seq((state_46868[(4)]))){
var statearr_46901_48248 = state_46868;
(statearr_46901_48248[(1)] = cljs.core.first((state_46868[(4)])));

} else {
throw ex__43961__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43959__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48250 = state_46868;
state_46868 = G__48250;
continue;
} else {
return ret_value__43959__auto__;
}
break;
}
});
cljs$core$async$state_machine__43958__auto__ = function(state_46868){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43958__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43958__auto____1.call(this,state_46868);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43958__auto____0;
cljs$core$async$state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43958__auto____1;
return cljs$core$async$state_machine__43958__auto__;
})()
})();
var state__44129__auto__ = (function (){var statearr_46902 = f__44128__auto__();
(statearr_46902[(6)] = c__44127__auto___48207);

return statearr_46902;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44129__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__46905 = arguments.length;
switch (G__46905) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44127__auto___48252 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44128__auto__ = (function (){var switch__43957__auto__ = (function (state_46945){
var state_val_46946 = (state_46945[(1)]);
if((state_val_46946 === (7))){
var inst_46940 = (state_46945[(2)]);
var state_46945__$1 = state_46945;
var statearr_46947_48254 = state_46945__$1;
(statearr_46947_48254[(2)] = inst_46940);

(statearr_46947_48254[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46946 === (1))){
var inst_46907 = (new Array(n));
var inst_46908 = inst_46907;
var inst_46909 = (0);
var state_46945__$1 = (function (){var statearr_46949 = state_46945;
(statearr_46949[(7)] = inst_46909);

(statearr_46949[(8)] = inst_46908);

return statearr_46949;
})();
var statearr_46950_48258 = state_46945__$1;
(statearr_46950_48258[(2)] = null);

(statearr_46950_48258[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46946 === (4))){
var inst_46912 = (state_46945[(9)]);
var inst_46912__$1 = (state_46945[(2)]);
var inst_46913 = (inst_46912__$1 == null);
var inst_46914 = cljs.core.not(inst_46913);
var state_46945__$1 = (function (){var statearr_46951 = state_46945;
(statearr_46951[(9)] = inst_46912__$1);

return statearr_46951;
})();
if(inst_46914){
var statearr_46952_48259 = state_46945__$1;
(statearr_46952_48259[(1)] = (5));

} else {
var statearr_46953_48260 = state_46945__$1;
(statearr_46953_48260[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46946 === (15))){
var inst_46934 = (state_46945[(2)]);
var state_46945__$1 = state_46945;
var statearr_46954_48261 = state_46945__$1;
(statearr_46954_48261[(2)] = inst_46934);

(statearr_46954_48261[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46946 === (13))){
var state_46945__$1 = state_46945;
var statearr_46955_48262 = state_46945__$1;
(statearr_46955_48262[(2)] = null);

(statearr_46955_48262[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46946 === (6))){
var inst_46909 = (state_46945[(7)]);
var inst_46930 = (inst_46909 > (0));
var state_46945__$1 = state_46945;
if(cljs.core.truth_(inst_46930)){
var statearr_46956_48263 = state_46945__$1;
(statearr_46956_48263[(1)] = (12));

} else {
var statearr_46957_48264 = state_46945__$1;
(statearr_46957_48264[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46946 === (3))){
var inst_46943 = (state_46945[(2)]);
var state_46945__$1 = state_46945;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46945__$1,inst_46943);
} else {
if((state_val_46946 === (12))){
var inst_46908 = (state_46945[(8)]);
var inst_46932 = cljs.core.vec(inst_46908);
var state_46945__$1 = state_46945;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46945__$1,(15),out,inst_46932);
} else {
if((state_val_46946 === (2))){
var state_46945__$1 = state_46945;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46945__$1,(4),ch);
} else {
if((state_val_46946 === (11))){
var inst_46924 = (state_46945[(2)]);
var inst_46925 = (new Array(n));
var inst_46908 = inst_46925;
var inst_46909 = (0);
var state_46945__$1 = (function (){var statearr_46959 = state_46945;
(statearr_46959[(7)] = inst_46909);

(statearr_46959[(10)] = inst_46924);

(statearr_46959[(8)] = inst_46908);

return statearr_46959;
})();
var statearr_46960_48273 = state_46945__$1;
(statearr_46960_48273[(2)] = null);

(statearr_46960_48273[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46946 === (9))){
var inst_46908 = (state_46945[(8)]);
var inst_46922 = cljs.core.vec(inst_46908);
var state_46945__$1 = state_46945;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46945__$1,(11),out,inst_46922);
} else {
if((state_val_46946 === (5))){
var inst_46909 = (state_46945[(7)]);
var inst_46912 = (state_46945[(9)]);
var inst_46917 = (state_46945[(11)]);
var inst_46908 = (state_46945[(8)]);
var inst_46916 = (inst_46908[inst_46909] = inst_46912);
var inst_46917__$1 = (inst_46909 + (1));
var inst_46918 = (inst_46917__$1 < n);
var state_46945__$1 = (function (){var statearr_46961 = state_46945;
(statearr_46961[(11)] = inst_46917__$1);

(statearr_46961[(12)] = inst_46916);

return statearr_46961;
})();
if(cljs.core.truth_(inst_46918)){
var statearr_46962_48275 = state_46945__$1;
(statearr_46962_48275[(1)] = (8));

} else {
var statearr_46963_48276 = state_46945__$1;
(statearr_46963_48276[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46946 === (14))){
var inst_46937 = (state_46945[(2)]);
var inst_46938 = cljs.core.async.close_BANG_(out);
var state_46945__$1 = (function (){var statearr_46966 = state_46945;
(statearr_46966[(13)] = inst_46937);

return statearr_46966;
})();
var statearr_46967_48279 = state_46945__$1;
(statearr_46967_48279[(2)] = inst_46938);

(statearr_46967_48279[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46946 === (10))){
var inst_46928 = (state_46945[(2)]);
var state_46945__$1 = state_46945;
var statearr_46968_48280 = state_46945__$1;
(statearr_46968_48280[(2)] = inst_46928);

(statearr_46968_48280[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46946 === (8))){
var inst_46917 = (state_46945[(11)]);
var inst_46908 = (state_46945[(8)]);
var tmp46965 = inst_46908;
var inst_46908__$1 = tmp46965;
var inst_46909 = inst_46917;
var state_46945__$1 = (function (){var statearr_46970 = state_46945;
(statearr_46970[(7)] = inst_46909);

(statearr_46970[(8)] = inst_46908__$1);

return statearr_46970;
})();
var statearr_46971_48281 = state_46945__$1;
(statearr_46971_48281[(2)] = null);

(statearr_46971_48281[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43958__auto__ = null;
var cljs$core$async$state_machine__43958__auto____0 = (function (){
var statearr_46972 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46972[(0)] = cljs$core$async$state_machine__43958__auto__);

(statearr_46972[(1)] = (1));

return statearr_46972;
});
var cljs$core$async$state_machine__43958__auto____1 = (function (state_46945){
while(true){
var ret_value__43959__auto__ = (function (){try{while(true){
var result__43960__auto__ = switch__43957__auto__(state_46945);
if(cljs.core.keyword_identical_QMARK_(result__43960__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43960__auto__;
}
break;
}
}catch (e46973){var ex__43961__auto__ = e46973;
var statearr_46974_48282 = state_46945;
(statearr_46974_48282[(2)] = ex__43961__auto__);


if(cljs.core.seq((state_46945[(4)]))){
var statearr_46975_48283 = state_46945;
(statearr_46975_48283[(1)] = cljs.core.first((state_46945[(4)])));

} else {
throw ex__43961__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43959__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48284 = state_46945;
state_46945 = G__48284;
continue;
} else {
return ret_value__43959__auto__;
}
break;
}
});
cljs$core$async$state_machine__43958__auto__ = function(state_46945){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43958__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43958__auto____1.call(this,state_46945);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43958__auto____0;
cljs$core$async$state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43958__auto____1;
return cljs$core$async$state_machine__43958__auto__;
})()
})();
var state__44129__auto__ = (function (){var statearr_46977 = f__44128__auto__();
(statearr_46977[(6)] = c__44127__auto___48252);

return statearr_46977;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44129__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__46979 = arguments.length;
switch (G__46979) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44127__auto___48286 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44128__auto__ = (function (){var switch__43957__auto__ = (function (state_47024){
var state_val_47025 = (state_47024[(1)]);
if((state_val_47025 === (7))){
var inst_47020 = (state_47024[(2)]);
var state_47024__$1 = state_47024;
var statearr_47026_48287 = state_47024__$1;
(statearr_47026_48287[(2)] = inst_47020);

(statearr_47026_48287[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47025 === (1))){
var inst_46980 = [];
var inst_46981 = inst_46980;
var inst_46982 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_47024__$1 = (function (){var statearr_47028 = state_47024;
(statearr_47028[(7)] = inst_46982);

(statearr_47028[(8)] = inst_46981);

return statearr_47028;
})();
var statearr_47029_48288 = state_47024__$1;
(statearr_47029_48288[(2)] = null);

(statearr_47029_48288[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47025 === (4))){
var inst_46985 = (state_47024[(9)]);
var inst_46985__$1 = (state_47024[(2)]);
var inst_46986 = (inst_46985__$1 == null);
var inst_46987 = cljs.core.not(inst_46986);
var state_47024__$1 = (function (){var statearr_47030 = state_47024;
(statearr_47030[(9)] = inst_46985__$1);

return statearr_47030;
})();
if(inst_46987){
var statearr_47031_48291 = state_47024__$1;
(statearr_47031_48291[(1)] = (5));

} else {
var statearr_47032_48292 = state_47024__$1;
(statearr_47032_48292[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47025 === (15))){
var inst_46981 = (state_47024[(8)]);
var inst_47012 = cljs.core.vec(inst_46981);
var state_47024__$1 = state_47024;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47024__$1,(18),out,inst_47012);
} else {
if((state_val_47025 === (13))){
var inst_47007 = (state_47024[(2)]);
var state_47024__$1 = state_47024;
var statearr_47033_48293 = state_47024__$1;
(statearr_47033_48293[(2)] = inst_47007);

(statearr_47033_48293[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47025 === (6))){
var inst_46981 = (state_47024[(8)]);
var inst_47009 = inst_46981.length;
var inst_47010 = (inst_47009 > (0));
var state_47024__$1 = state_47024;
if(cljs.core.truth_(inst_47010)){
var statearr_47034_48294 = state_47024__$1;
(statearr_47034_48294[(1)] = (15));

} else {
var statearr_47035_48295 = state_47024__$1;
(statearr_47035_48295[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47025 === (17))){
var inst_47017 = (state_47024[(2)]);
var inst_47018 = cljs.core.async.close_BANG_(out);
var state_47024__$1 = (function (){var statearr_47036 = state_47024;
(statearr_47036[(10)] = inst_47017);

return statearr_47036;
})();
var statearr_47037_48296 = state_47024__$1;
(statearr_47037_48296[(2)] = inst_47018);

(statearr_47037_48296[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47025 === (3))){
var inst_47022 = (state_47024[(2)]);
var state_47024__$1 = state_47024;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47024__$1,inst_47022);
} else {
if((state_val_47025 === (12))){
var inst_46981 = (state_47024[(8)]);
var inst_47000 = cljs.core.vec(inst_46981);
var state_47024__$1 = state_47024;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47024__$1,(14),out,inst_47000);
} else {
if((state_val_47025 === (2))){
var state_47024__$1 = state_47024;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47024__$1,(4),ch);
} else {
if((state_val_47025 === (11))){
var inst_46981 = (state_47024[(8)]);
var inst_46989 = (state_47024[(11)]);
var inst_46985 = (state_47024[(9)]);
var inst_46997 = inst_46981.push(inst_46985);
var tmp47039 = inst_46981;
var inst_46981__$1 = tmp47039;
var inst_46982 = inst_46989;
var state_47024__$1 = (function (){var statearr_47041 = state_47024;
(statearr_47041[(7)] = inst_46982);

(statearr_47041[(12)] = inst_46997);

(statearr_47041[(8)] = inst_46981__$1);

return statearr_47041;
})();
var statearr_47043_48297 = state_47024__$1;
(statearr_47043_48297[(2)] = null);

(statearr_47043_48297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47025 === (9))){
var inst_46982 = (state_47024[(7)]);
var inst_46993 = cljs.core.keyword_identical_QMARK_(inst_46982,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_47024__$1 = state_47024;
var statearr_47044_48300 = state_47024__$1;
(statearr_47044_48300[(2)] = inst_46993);

(statearr_47044_48300[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47025 === (5))){
var inst_46990 = (state_47024[(13)]);
var inst_46982 = (state_47024[(7)]);
var inst_46989 = (state_47024[(11)]);
var inst_46985 = (state_47024[(9)]);
var inst_46989__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_46985) : f.call(null,inst_46985));
var inst_46990__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_46989__$1,inst_46982);
var state_47024__$1 = (function (){var statearr_47045 = state_47024;
(statearr_47045[(13)] = inst_46990__$1);

(statearr_47045[(11)] = inst_46989__$1);

return statearr_47045;
})();
if(inst_46990__$1){
var statearr_47046_48301 = state_47024__$1;
(statearr_47046_48301[(1)] = (8));

} else {
var statearr_47047_48302 = state_47024__$1;
(statearr_47047_48302[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47025 === (14))){
var inst_46989 = (state_47024[(11)]);
var inst_46985 = (state_47024[(9)]);
var inst_47002 = (state_47024[(2)]);
var inst_47003 = [];
var inst_47004 = inst_47003.push(inst_46985);
var inst_46981 = inst_47003;
var inst_46982 = inst_46989;
var state_47024__$1 = (function (){var statearr_47049 = state_47024;
(statearr_47049[(14)] = inst_47004);

(statearr_47049[(7)] = inst_46982);

(statearr_47049[(15)] = inst_47002);

(statearr_47049[(8)] = inst_46981);

return statearr_47049;
})();
var statearr_47050_48303 = state_47024__$1;
(statearr_47050_48303[(2)] = null);

(statearr_47050_48303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47025 === (16))){
var state_47024__$1 = state_47024;
var statearr_47051_48304 = state_47024__$1;
(statearr_47051_48304[(2)] = null);

(statearr_47051_48304[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47025 === (10))){
var inst_46995 = (state_47024[(2)]);
var state_47024__$1 = state_47024;
if(cljs.core.truth_(inst_46995)){
var statearr_47052_48305 = state_47024__$1;
(statearr_47052_48305[(1)] = (11));

} else {
var statearr_47053_48306 = state_47024__$1;
(statearr_47053_48306[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47025 === (18))){
var inst_47014 = (state_47024[(2)]);
var state_47024__$1 = state_47024;
var statearr_47058_48307 = state_47024__$1;
(statearr_47058_48307[(2)] = inst_47014);

(statearr_47058_48307[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47025 === (8))){
var inst_46990 = (state_47024[(13)]);
var state_47024__$1 = state_47024;
var statearr_47059_48308 = state_47024__$1;
(statearr_47059_48308[(2)] = inst_46990);

(statearr_47059_48308[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43958__auto__ = null;
var cljs$core$async$state_machine__43958__auto____0 = (function (){
var statearr_47065 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47065[(0)] = cljs$core$async$state_machine__43958__auto__);

(statearr_47065[(1)] = (1));

return statearr_47065;
});
var cljs$core$async$state_machine__43958__auto____1 = (function (state_47024){
while(true){
var ret_value__43959__auto__ = (function (){try{while(true){
var result__43960__auto__ = switch__43957__auto__(state_47024);
if(cljs.core.keyword_identical_QMARK_(result__43960__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43960__auto__;
}
break;
}
}catch (e47066){var ex__43961__auto__ = e47066;
var statearr_47071_48309 = state_47024;
(statearr_47071_48309[(2)] = ex__43961__auto__);


if(cljs.core.seq((state_47024[(4)]))){
var statearr_47072_48310 = state_47024;
(statearr_47072_48310[(1)] = cljs.core.first((state_47024[(4)])));

} else {
throw ex__43961__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43959__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48311 = state_47024;
state_47024 = G__48311;
continue;
} else {
return ret_value__43959__auto__;
}
break;
}
});
cljs$core$async$state_machine__43958__auto__ = function(state_47024){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43958__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43958__auto____1.call(this,state_47024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43958__auto____0;
cljs$core$async$state_machine__43958__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43958__auto____1;
return cljs$core$async$state_machine__43958__auto__;
})()
})();
var state__44129__auto__ = (function (){var statearr_47077 = f__44128__auto__();
(statearr_47077[(6)] = c__44127__auto___48286);

return statearr_47077;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44129__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
