(defproject com.github.zikajk/webappx "1.0.0"
  :description "A simple Clojure + Clojurescript stack"
  :url "https://github.com/zikajk/webappx"
  :license {:name "EPL-2.0 OR GPL-2.0-or-later WITH Classpath-exception-2.0"
            :url "https://www.eclipse.org/legal/epl-2.0/"}
  :dependencies [[org.clojure/clojure "1.11.0-beta1"]
                 [integrant "0.8.0"]
                 [ring "1.9.5"]
                 [metosin/malli "0.8.1"]
                 [metosin/muuntaja "0.6.8"]
                 [metosin/reitit "0.5.15"]
                 [hiccup "1.0.5"]
                 [thheller/shadow-cljs "2.17.1"]
                 [reagent "1.1.0"]
                 [cljsjs/react "17.0.2-0"]
                 [cljsjs/react-dom "17.0.2-0"]]
  :plugins [[lein-shadow "0.3.1"]]
  :source-paths ["src"]
  :test-paths ["test"]
  :resource-paths ["resources"]
  :main ^:skip-aot webappx.core
  :target-path "target/%s"
  :profiles {:uberjar {:aot :all
                       :jvm-opts ["-Dclojure.compiler.direct-linking=true"]}
             :dev {:dependencies [[ring/ring-mock "0.4.0"]]}}
  :repl-options {:init-ns user}
  :shadow-cljs {:nrepl {:port 8777}
                :builds {:app {:target :browser
                               :output-dir "resources/public/js/compiled"
                               :asset-path "assets/js/compiled"
                               :modules {:app {:init-fn webappx.app/init}}}}}
  :aliases {"watch" ["shadow" "watch" "app" "browser-test" "karma-test"]}
  )

; https://github.com/technomancy/leiningen/blob/master/sample.project.clj
