(ns user
  (:require
   [{{name}}.server]
   [integrant.core :as ig]
   [ring.middleware.reload :refer [wrap-reload]]
   [shadow.cljs.devtools.api :as shadow.api]
   [shadow.cljs.devtools.server :as shadow.server]))

(def dev-config
  {:adapter/jetty {:port 3000 :join? false :handler (ig/ref :handler/run-app)}
   :handler/run-app {:middleware [wrap-reload]}})

(declare sys)

(defn start-dev!
  []
  (shadow.server/start!)
  (shadow.api/watch :app)
  (def sys
    (ig/init dev-config)))

(defn stop-dev!
  []
  (ig/halt! sys))
