(ns {{name}}.server
  (:require
   [{{name}}.view :as view]
   [integrant.core :as ig]
   [ring.adapter.jetty :refer [run-jetty]]
   [reitit.ring :as ring]
   [muuntaja.core :as m]))

(defmethod ig/init-key :adapter/jetty [_ {:keys [port join? handler]}]
  (run-jetty handler {:port port :join? join?}))

(defmethod ig/halt-key! :adapter/jetty [_ server]
  (.stop server))

(defmethod ig/init-key :handler/run-app [_ {:keys [middleware]}]
  (ring/ring-handler
   (ring/router
    [["/" {:get {:handler view/main}}]
     ["/assets/*" (ring/create-resource-handler)]]
    {:data {:muuntaja m/instance
            :middleware middleware}})
   (ring/create-default-handler)))
