(ns leiningen.new.webappx
  (:require [leiningen.new.templates :as tmpl]
            [leiningen.core.main :as main]))

(def render (tmpl/renderer "webappx"))

(defn webappx
  "FIXME: write documentation"
  [name]
  (let [data {:name name
              :sanitized (tmpl/name-to-path name)}]
    (main/info "Generating fresh 'lein new' com.github.zikajk/webappx project.")
    (tmpl/->files data
                  ["project.clj" (render "project.clj" data)]
                  ["README.md" "README.md"]
                  ["CHANGELOG.md" "CHANGELOG.md"]
                  ["LICENSE" "LICENSE"]
                  ["src/{{sanitized}}/server.clj" (render "server.clj" data)]
                  ["src/{{sanitized}}/view.clj" (render "view.clj" data)]
                  ["src/{{sanitized}}/core.clj" (render "core.clj" data)]
                  ["src/{{sanitized}}/app.cljs" (render "app.cljs" data)]
                  ["dev/user.clj" (render "user.clj" data)])))
