/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir.storage;

import com.github.ylgrgyq.reservoir.storage.BlockBuilder;
import com.github.ylgrgyq.reservoir.storage.BlockIndexHandle;
import com.github.ylgrgyq.reservoir.storage.Footer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import javax.annotation.Nullable;

final class TableBuilder {
    private final FileChannel fileChannel;
    private final BlockBuilder pendingDataBlock;
    private final BlockBuilder indexBlock;
    private long lastKey;
    private long nextBlockOffset;
    private boolean isFinished;
    @Nullable
    private BlockIndexHandle pendingBlockIndexHandle;

    TableBuilder(FileChannel fileChannel) {
        this.fileChannel = fileChannel;
        this.pendingDataBlock = new BlockBuilder();
        this.indexBlock = new BlockBuilder();
        this.lastKey = -1L;
    }

    void add(long k, byte[] v) throws IOException {
        assert (k > this.lastKey);
        assert (v.length > 0);
        assert (!this.isFinished);
        if (this.pendingBlockIndexHandle != null) {
            this.indexBlock.add(k, this.pendingBlockIndexHandle.encode());
            this.pendingBlockIndexHandle = null;
        }
        this.pendingDataBlock.add(k, v);
        if (this.pendingDataBlock.estimateBlockSize() >= 4096) {
            this.flushDataBlock();
        }
        this.lastKey = k;
    }

    long finishBuild() throws IOException {
        assert (!this.isFinished);
        assert (this.nextBlockOffset >= 0L);
        this.isFinished = true;
        if (!this.pendingDataBlock.isEmpty()) {
            this.flushDataBlock();
        }
        if (this.pendingBlockIndexHandle != null) {
            this.indexBlock.add(this.lastKey + 1L, this.pendingBlockIndexHandle.encode());
            this.pendingBlockIndexHandle = null;
        }
        BlockIndexHandle blockIndexHandle = this.writeBlock(this.indexBlock);
        Footer footer = new Footer(blockIndexHandle);
        byte[] footerBytes = footer.encode();
        this.fileChannel.write(ByteBuffer.wrap(footerBytes));
        return this.nextBlockOffset + (long)footerBytes.length;
    }

    private void flushDataBlock() throws IOException {
        assert (!this.pendingDataBlock.isEmpty());
        this.pendingBlockIndexHandle = this.writeBlock(this.pendingDataBlock);
        this.fileChannel.force(true);
    }

    private BlockIndexHandle writeBlock(BlockBuilder block) throws IOException {
        assert (this.fileChannel.position() == this.nextBlockOffset) : "position: " + this.fileChannel.position() + " nextBlockOffset: " + this.nextBlockOffset;
        long blockStartOffset = this.nextBlockOffset;
        BlockBuilder.WriteBlockResult result = block.writeBlock(this.fileChannel);
        long checksum = result.getChecksum();
        int blockSize = result.getWrittenBlockSize();
        ByteBuffer trailer = ByteBuffer.allocate(8);
        trailer.putLong(checksum);
        trailer.flip();
        this.fileChannel.write(trailer);
        this.pendingDataBlock.reset();
        this.nextBlockOffset += (long)(blockSize + 8);
        return new BlockIndexHandle(blockStartOffset, blockSize);
    }
}

