/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir.storage;

import com.github.ylgrgyq.reservoir.SerializedObjectWithId;
import com.github.ylgrgyq.reservoir.storage.SeekableIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.Nullable;

final class Memtable
implements Iterable<SerializedObjectWithId<byte[]>> {
    private final ConcurrentSkipListMap<Long, byte[]> table = new ConcurrentSkipListMap();
    private int memSize;

    Memtable() {
    }

    void add(SerializedObjectWithId<byte[]> val) {
        long k = val.getId();
        byte[] v = val.getSerializedObject();
        this.table.put(k, v);
        this.memSize += 8 + v.length;
    }

    long firstId() {
        if (this.table.isEmpty()) {
            return -1L;
        }
        return this.table.firstKey();
    }

    long lastId() {
        if (this.table.isEmpty()) {
            return -1L;
        }
        return this.table.lastKey();
    }

    boolean isEmpty() {
        return this.table.isEmpty();
    }

    List<SerializedObjectWithId<byte[]>> getEntries(long start, int limit) {
        SerializedObjectWithId v;
        if (start > this.lastId()) {
            return Collections.emptyList();
        }
        Iterator iter = this.iterator();
        iter.seek(start);
        ArrayList<SerializedObjectWithId<byte[]>> ret = new ArrayList<SerializedObjectWithId<byte[]>>();
        while (iter.hasNext() && (v = (SerializedObjectWithId)iter.next()).getId() > start && ret.size() < limit) {
            ret.add(v);
        }
        return ret;
    }

    int getMemoryUsedInBytes() {
        return this.memSize;
    }

    public SeekableIterator<Long, SerializedObjectWithId<byte[]>> iterator() {
        return new Itr((ConcurrentNavigableMap<Long, byte[]>)this.table.clone());
    }

    private static class Itr
    implements SeekableIterator<Long, SerializedObjectWithId<byte[]>> {
        private final ConcurrentNavigableMap<Long, byte[]> innerMap;
        @Nullable
        private Map.Entry<Long, byte[]> offset;

        Itr(ConcurrentNavigableMap<Long, byte[]> innerMap) {
            this.innerMap = innerMap;
            this.offset = innerMap.firstEntry();
        }

        @Override
        public SeekableIterator<Long, SerializedObjectWithId<byte[]>> seek(Long key) {
            this.offset = this.innerMap.higherEntry(key);
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.offset != null;
        }

        @Override
        public SerializedObjectWithId<byte[]> next() {
            assert (this.offset != null);
            long id = this.offset.getKey();
            byte[] v = this.offset.getValue();
            this.offset = this.innerMap.higherEntry(id);
            return new SerializedObjectWithId<byte[]>(id, v);
        }
    }
}

