/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir.storage;

import com.github.ylgrgyq.reservoir.storage.BufferedChannel;
import com.github.ylgrgyq.reservoir.storage.RecordType;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.zip.CRC32;

final class LogWriter
implements Closeable {
    private final BufferedChannel workingFileChannel;
    private final ByteBuffer headerBuffer;
    private final ByteBuffer zeros;
    private final CRC32 checksum;
    private int blockOffset;

    LogWriter(FileChannel workingFileChannel) throws IOException {
        this(workingFileChannel, 0L);
    }

    LogWriter(FileChannel workingFileChannel, long writePosition) throws IOException {
        workingFileChannel.position(writePosition);
        this.workingFileChannel = new BufferedChannel(workingFileChannel);
        this.headerBuffer = ByteBuffer.allocateDirect(11);
        this.blockOffset = 0;
        this.zeros = ByteBuffer.allocate(11);
        this.checksum = new CRC32();
    }

    void flush(boolean force) throws IOException {
        this.workingFileChannel.flush();
        if (force) {
            this.workingFileChannel.force();
        }
    }

    @Override
    public void close() throws IOException {
        this.flush(true);
        this.workingFileChannel.close();
    }

    void append(byte[] data) throws IOException {
        int fragmentSize;
        assert (data.length > 0);
        ByteBuffer writeBuffer = ByteBuffer.wrap(data);
        boolean begin = true;
        for (int dataSizeRemain = writeBuffer.remaining(); dataSizeRemain > 0; dataSizeRemain -= fragmentSize) {
            boolean end;
            int blockLeft = 32768 - this.blockOffset;
            assert (blockLeft >= 0);
            if (blockLeft <= 11) {
                this.paddingBlock(blockLeft);
                this.blockOffset = 0;
            }
            assert (32768 - this.blockOffset - 11 >= 0);
            int blockForDataAvailable = 32768 - this.blockOffset - 11;
            fragmentSize = Math.min(blockForDataAvailable, dataSizeRemain);
            boolean bl = end = fragmentSize == dataSizeRemain;
            RecordType type = begin && end ? RecordType.kFullType : (begin ? RecordType.kFirstType : (end ? RecordType.kLastType : RecordType.kMiddleType));
            byte[] out = new byte[fragmentSize];
            writeBuffer.get(out);
            this.writeRecord(type, out);
            begin = false;
        }
    }

    private void paddingBlock(int blockLeft) throws IOException {
        assert (blockLeft >= 0) : "blockLeft: " + blockLeft;
        if (blockLeft > 0) {
            ByteBuffer padding = this.zeros;
            padding.position(11 - blockLeft);
            this.workingFileChannel.write(padding);
        }
    }

    private void writeRecord(RecordType type, byte[] blockPayload) throws IOException {
        assert (this.blockOffset + 11 + blockPayload.length <= 32768);
        CRC32 crc32 = this.checksum;
        crc32.reset();
        crc32.update(type.getCode());
        crc32.update(blockPayload);
        ByteBuffer header = this.headerBuffer;
        header.clear();
        header.putLong(crc32.getValue());
        header.putShort((short)blockPayload.length);
        header.put(type.getCode());
        header.flip();
        BufferedChannel ch = this.workingFileChannel;
        ch.write(header);
        ch.write(ByteBuffer.wrap(blockPayload));
        this.blockOffset += blockPayload.length + 11;
    }
}

