/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir.storage;

import com.github.ylgrgyq.reservoir.NamedThreadFactory;
import com.github.ylgrgyq.reservoir.StorageException;
import com.github.ylgrgyq.reservoir.storage.FileStorage;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class FileStorageBuilder {
    private boolean forceSyncOnFlushConsumerCommitLogWriter = false;
    private boolean forceSyncOnFlushDataLogWriter = false;
    private long truncateIntervalMillis = TimeUnit.MINUTES.toMillis(1L);
    private final String storageBaseDir;
    @Nullable
    private ExecutorService flushMemtableExecutorService;

    public static FileStorageBuilder newBuilder(String storageBaseDir) {
        Objects.requireNonNull(storageBaseDir, "storageBaseDir");
        return new FileStorageBuilder(storageBaseDir);
    }

    private FileStorageBuilder(String storageBaseDir) {
        this.storageBaseDir = storageBaseDir;
    }

    public FileStorageBuilder setTruncateIntervalMillis(long truncateInterval, TimeUnit unit) {
        if (truncateInterval < 0L) {
            throw new IllegalArgumentException("truncateInterval: " + truncateInterval + " (expect: >= 0)");
        }
        Objects.requireNonNull(unit, "unit");
        this.truncateIntervalMillis = unit.toMillis(truncateInterval);
        return this;
    }

    public FileStorageBuilder setFlushMemtableExecutorService(ExecutorService flushMemtableExecutorService) {
        Objects.requireNonNull(flushMemtableExecutorService, "flushMemtableExecutorService");
        this.flushMemtableExecutorService = flushMemtableExecutorService;
        return this;
    }

    public void setSyncFlushConsumerCommitLogWriter(boolean syncFlushConsumerCommitLogWriter) {
        this.forceSyncOnFlushConsumerCommitLogWriter = syncFlushConsumerCommitLogWriter;
    }

    public void setSyncFlushDataLogWriter(boolean syncFlushDataLogWriter) {
        this.forceSyncOnFlushDataLogWriter = syncFlushDataLogWriter;
    }

    public FileStorage build() throws StorageException {
        if (this.flushMemtableExecutorService == null) {
            this.flushMemtableExecutorService = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("memtable-writer-"));
        }
        return new FileStorage(this);
    }

    String getStorageBaseDir() {
        return this.storageBaseDir;
    }

    long getTruncateIntervalMillis() {
        return this.truncateIntervalMillis;
    }

    ExecutorService getFlushMemtableExecutorService() {
        if (this.flushMemtableExecutorService == null) {
            this.flushMemtableExecutorService = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("memtable-writer-"));
        }
        return this.flushMemtableExecutorService;
    }

    boolean isForceSyncOnFlushConsumerCommitLogWriter() {
        return this.forceSyncOnFlushConsumerCommitLogWriter;
    }

    boolean isForceSyncOnFlushDataLogWriter() {
        return this.forceSyncOnFlushDataLogWriter;
    }
}

