/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir.storage;

import java.nio.ByteBuffer;
import java.util.Objects;

final class BlockIndexHandle {
    static int BLOCK_HANDLE_SIZE = 12;
    private final long blockStartOffset;
    private final int blockSize;

    BlockIndexHandle(long blockStartOffset, int blockSize) {
        this.blockStartOffset = blockStartOffset;
        this.blockSize = blockSize;
    }

    long getBlockStartOffset() {
        return this.blockStartOffset;
    }

    int getBlockSize() {
        return this.blockSize;
    }

    byte[] encode() {
        ByteBuffer buffer = ByteBuffer.allocate(BLOCK_HANDLE_SIZE);
        buffer.putLong(this.blockStartOffset);
        buffer.putInt(this.blockSize);
        return buffer.array();
    }

    static BlockIndexHandle decode(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long offset = buffer.getLong();
        int size = buffer.getInt();
        return new BlockIndexHandle(offset, size);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockIndexHandle handle = (BlockIndexHandle)o;
        return this.getBlockStartOffset() == handle.getBlockStartOffset() && this.getBlockSize() == handle.getBlockSize();
    }

    public int hashCode() {
        return Objects.hash(this.getBlockStartOffset(), this.getBlockSize());
    }

    public String toString() {
        return "BlockIndexHandle{blockStartOffset=" + this.blockStartOffset + ", blockSize=" + this.blockSize + '}';
    }
}

