/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir;

import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;

public final class SerializedObjectWithId<S> {
    private final long id;
    private final S serializedObject;

    public SerializedObjectWithId(long id, S serializedObject) {
        Objects.requireNonNull(serializedObject, "serializedObject");
        this.id = id;
        this.serializedObject = serializedObject;
    }

    public long getId() {
        return this.id;
    }

    public S getSerializedObject() {
        return this.serializedObject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializedObjectWithId that = (SerializedObjectWithId)o;
        return this.getId() == that.getId() && this.getSerializedObject().getClass() == that.getSerializedObject().getClass() && (this.getSerializedObject() instanceof byte[] ? Arrays.equals((byte[])this.getSerializedObject(), (byte[])that.getSerializedObject()) : this.getSerializedObject().equals(that.getSerializedObject()));
    }

    public int hashCode() {
        S obj = this.getSerializedObject();
        if (obj instanceof byte[]) {
            int result = Objects.hash(this.getId());
            result = 31 * result + Arrays.hashCode((byte[])obj);
            return result;
        }
        return Objects.hash(this.getId(), obj);
    }

    public String toString() {
        return "SerializedObjectWithId{id=" + this.id + ", serializedObject=" + (this.serializedObject instanceof byte[] ? Base64.getEncoder().encodeToString((byte[])this.serializedObject) : this.serializedObject) + '}';
    }
}

