/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir;

import com.github.ylgrgyq.reservoir.AutoCommitObjectQueueConsumer;
import com.github.ylgrgyq.reservoir.Codec;
import com.github.ylgrgyq.reservoir.DisruptorBackedObjectQueueProducer;
import com.github.ylgrgyq.reservoir.ManualCommitObjectQueueConsumer;
import com.github.ylgrgyq.reservoir.NamedThreadFactory;
import com.github.ylgrgyq.reservoir.ObjectQueue;
import com.github.ylgrgyq.reservoir.ObjectQueueConsumer;
import com.github.ylgrgyq.reservoir.ObjectQueueProducer;
import com.github.ylgrgyq.reservoir.ObjectQueueStorage;
import com.github.ylgrgyq.reservoir.StorageException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public final class ObjectQueueBuilder<E, S> {
    private static final ThreadFactory threadFactory = new NamedThreadFactory("reservoir-object-queue-executor-");
    private ExecutorService producerExecutorService = Executors.newSingleThreadExecutor(threadFactory);
    private boolean shutdownProducerExecutorService = true;
    private int producerRingBufferSize = 512;
    private int consumerFetchBatchSize = 128;
    private boolean autoCommit = true;
    private ObjectQueueStorage<S> storage;
    private Codec<E, S> codec;

    public static <E> ObjectQueueBuilder<E, E> newBuilder(ObjectQueueStorage<E> storage) {
        Objects.requireNonNull(storage, "storage");
        return new ObjectQueueBuilder<E, E>(storage, new IdentityCodec());
    }

    public static <E, S> ObjectQueueBuilder<E, S> newBuilder(ObjectQueueStorage<S> storage, Codec<E, S> codec) {
        Objects.requireNonNull(storage, "storage");
        Objects.requireNonNull(codec, "codec");
        return new ObjectQueueBuilder<E, S>(storage, codec);
    }

    private ObjectQueueBuilder(ObjectQueueStorage<S> storage, Codec<E, S> codec) {
        this.storage = storage;
        this.codec = codec;
    }

    public ObjectQueueBuilder<E, S> replaceStorage(ObjectQueueStorage<S> storage) {
        Objects.requireNonNull(storage, "storage");
        this.storage = storage;
        return this;
    }

    public ObjectQueueBuilder<E, S> replaceCodec(Codec<E, S> codec) {
        Objects.requireNonNull(codec, "codec");
        this.codec = codec;
        return this;
    }

    public ObjectQueueBuilder<E, S> autoCommitAfterFetch(boolean autoCommit) {
        this.autoCommit = autoCommit;
        return this;
    }

    public ObjectQueueBuilder<E, S> setConsumerFetchBatchSize(int consumerFetchBatchSize) {
        if (consumerFetchBatchSize <= 0) {
            throw new IllegalArgumentException("consumerFetchBatchSize: " + consumerFetchBatchSize + " (expected: > 0)");
        }
        this.consumerFetchBatchSize = consumerFetchBatchSize;
        return this;
    }

    public ObjectQueueBuilder<E, S> setProducerRingBufferSize(int producerRingBufferSize) {
        if (producerRingBufferSize <= 0) {
            throw new IllegalArgumentException("producerRingBufferSize: " + producerRingBufferSize + " (expected: > 0)");
        }
        this.producerRingBufferSize = producerRingBufferSize;
        return this;
    }

    public void setProducerExecutorService(ExecutorService executorService) {
        Objects.requireNonNull(executorService, "producerExecutorService");
        this.producerExecutorService = executorService;
        this.shutdownProducerExecutorService = false;
    }

    public ObjectQueueProducer<E> buildProducer() throws StorageException {
        return new DisruptorBackedObjectQueueProducer(this);
    }

    public ObjectQueueConsumer<E> buildConsumer() throws StorageException {
        if (this.isAutoCommit()) {
            return new AutoCommitObjectQueueConsumer(this);
        }
        return new ManualCommitObjectQueueConsumer(this);
    }

    public ObjectQueue<E> buildQueue() throws StorageException {
        ObjectQueueProducer<E> producer = this.buildProducer();
        ObjectQueueConsumer<E> consumer = this.buildConsumer();
        return new ObjectQueue<E>(producer, consumer);
    }

    int getProducerRingBufferSize() {
        return this.producerRingBufferSize;
    }

    ExecutorService getProducerExecutorService() {
        return this.producerExecutorService;
    }

    boolean isShutdownProducerExecutorService() {
        return this.shutdownProducerExecutorService;
    }

    ObjectQueueStorage<S> getStorage() {
        return this.storage;
    }

    Codec<E, S> getCodec() {
        return this.codec;
    }

    int getConsumerFetchBatchSize() {
        return this.consumerFetchBatchSize;
    }

    private boolean isAutoCommit() {
        return this.autoCommit;
    }

    private static class IdentityCodec<E>
    implements Codec<E, E> {
        private IdentityCodec() {
        }

        @Override
        public E serialize(E obj) {
            return obj;
        }

        @Override
        public E deserialize(E serializedObj) {
            return serializedObj;
        }
    }
}

