/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir;

import com.lmax.disruptor.ExceptionHandler;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LogExceptionHandler<T>
implements ExceptionHandler<T> {
    private static final Logger logger = LoggerFactory.getLogger(LogExceptionHandler.class);
    private final String name;
    @Nullable
    private final OnEventException<T> onEventException;

    LogExceptionHandler(String name) {
        this(name, null);
    }

    LogExceptionHandler(String name, @Nullable OnEventException<T> onEventException) {
        this.name = name;
        this.onEventException = onEventException;
    }

    @Override
    public void handleOnStartException(Throwable ex) {
        logger.error("Start disruptor: {} failed.", (Object)this.name, (Object)ex);
    }

    @Override
    public void handleOnShutdownException(Throwable ex) {
        logger.error("Shutdown disruptor: {} failed.", (Object)this.name, (Object)ex);
    }

    @Override
    public void handleEventException(Throwable ex, long sequence, T event) {
        logger.error("Handle event: {} on disruptor: {} failed.", event, this.name, ex);
        if (this.onEventException != null) {
            this.onEventException.onException(event, ex);
        }
    }

    public static interface OnEventException<T> {
        public void onException(T var1, Throwable var2);
    }
}

