/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir.storage;

import com.github.ylgrgyq.reservoir.storage.SSTableFileMetaInfo;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

final class ManifestRecord {
    private final List<SSTableFileMetaInfo> metas = new ArrayList<SSTableFileMetaInfo>();
    private final Type type;
    private int nextFileNumber;
    private int dataLogFileNumber;
    private int consumerCommitLogFileNumber;

    private ManifestRecord(Type type) {
        this.type = type;
    }

    static ManifestRecord newPlainRecord() {
        return new ManifestRecord(Type.PLAIN);
    }

    static ManifestRecord newReplaceAllExistedMetasRecord() {
        return new ManifestRecord(Type.REPLACE_METAS);
    }

    int getNextFileNumber() {
        if (this.type == Type.PLAIN) {
            return this.nextFileNumber;
        }
        return -1;
    }

    void setNextFileNumber(int nextFileNumber) {
        assert (this.type != Type.PLAIN || nextFileNumber > 1);
        this.nextFileNumber = nextFileNumber;
    }

    int getDataLogFileNumber() {
        if (this.type == Type.PLAIN) {
            return this.dataLogFileNumber;
        }
        return -1;
    }

    int getConsumerCommitLogFileNumber() {
        if (this.type == Type.PLAIN) {
            return this.consumerCommitLogFileNumber;
        }
        return -1;
    }

    void setDataLogFileNumber(int number) {
        assert (this.type != Type.PLAIN || number > 0);
        this.dataLogFileNumber = number;
    }

    void setConsumerCommitLogFileNumber(int number) {
        assert (this.type != Type.PLAIN || number > 0);
        this.consumerCommitLogFileNumber = number;
    }

    Type getType() {
        return this.type;
    }

    List<SSTableFileMetaInfo> getMetas() {
        return this.metas;
    }

    void addMeta(SSTableFileMetaInfo meta) {
        this.metas.add(meta);
    }

    void addMetas(List<SSTableFileMetaInfo> ms) {
        this.metas.addAll(ms);
    }

    byte[] encode() {
        int sstableMetaInfoEncodeSize = 28;
        ByteBuffer buffer = ByteBuffer.allocate(1 + this.metas.size() * 28 + 16);
        buffer.put(this.type.getCode());
        buffer.putInt(this.nextFileNumber);
        buffer.putInt(this.dataLogFileNumber);
        buffer.putInt(this.consumerCommitLogFileNumber);
        buffer.putInt(this.metas.size());
        for (SSTableFileMetaInfo meta : this.metas) {
            buffer.putLong(meta.getFileSize());
            buffer.putInt(meta.getFileNumber());
            buffer.putLong(meta.getFirstId());
            buffer.putLong(meta.getLastId());
        }
        return buffer.array();
    }

    private static byte[] compact(List<byte[]> output) {
        int size = output.stream().mapToInt(b -> ((byte[])b).length).sum();
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (byte[] bytes : output) {
            buffer.put(bytes);
        }
        return buffer.array();
    }

    static ManifestRecord decode(List<byte[]> bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(ManifestRecord.compact(bytes));
        ManifestRecord record = Type.newManifestRecord(buffer.get());
        record.setNextFileNumber(buffer.getInt());
        record.setDataLogFileNumber(buffer.getInt());
        record.setConsumerCommitLogFileNumber(buffer.getInt());
        int metasSize = buffer.getInt();
        for (int i = 0; i < metasSize; ++i) {
            SSTableFileMetaInfo meta = new SSTableFileMetaInfo();
            meta.setFileSize(buffer.getLong());
            meta.setFileNumber(buffer.getInt());
            meta.setFirstId(buffer.getLong());
            meta.setLastId(buffer.getLong());
            record.addMeta(meta);
        }
        return record;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManifestRecord that = (ManifestRecord)o;
        return this.getNextFileNumber() == that.getNextFileNumber() && this.getDataLogFileNumber() == that.getDataLogFileNumber() && this.getConsumerCommitLogFileNumber() == that.getConsumerCommitLogFileNumber() && this.getMetas().equals(that.getMetas()) && this.getType() == that.getType();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getMetas(), this.getType(), this.getNextFileNumber(), this.getDataLogFileNumber(), this.getConsumerCommitLogFileNumber()});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ManifestRecord{type=" + (Object)((Object)this.type) + ", nextFileNumber=" + this.nextFileNumber + ", consumerCommitLogFileNumber=" + this.consumerCommitLogFileNumber + ", dataLogFileNumber=" + this.dataLogFileNumber);
        if (!this.metas.isEmpty()) {
            long from = this.metas.get(0).getFirstId();
            long to = this.metas.get(this.metas.size() - 1).getLastId();
            builder.append(", metaKeysFrom=");
            builder.append(from);
            builder.append(", metaKeysTo=");
            builder.append(to);
        }
        builder.append("}");
        return builder.toString();
    }

    static enum Type {
        PLAIN(0),
        REPLACE_METAS(1);

        private byte code;

        private Type(byte code) {
            this.code = code;
        }

        public byte getCode() {
            return this.code;
        }

        public static ManifestRecord newManifestRecord(byte typeCode) {
            switch (typeCode) {
                case 0: {
                    return ManifestRecord.newPlainRecord();
                }
                case 1: {
                    return ManifestRecord.newReplaceAllExistedMetasRecord();
                }
            }
            throw new IllegalArgumentException("unknown manifest record type code: " + typeCode);
        }
    }
}

