/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir.storage;

import com.github.ylgrgyq.reservoir.storage.BlockIndexHandle;
import java.nio.ByteBuffer;
import java.util.Objects;

final class Footer {
    static int tableFooterSize = BlockIndexHandle.BLOCK_HANDLE_SIZE + 8;
    private final BlockIndexHandle blockIndexHandle;

    static Footer decode(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        byte[] indexBlockHandleBytes = new byte[BlockIndexHandle.BLOCK_HANDLE_SIZE];
        buffer.get(indexBlockHandleBytes);
        long magic = buffer.getLong();
        if (magic != 24068102L) {
            throw new IllegalStateException("found invalid sstable during checking magic number");
        }
        BlockIndexHandle blockIndexHandle = BlockIndexHandle.decode(indexBlockHandleBytes);
        return new Footer(blockIndexHandle);
    }

    Footer(BlockIndexHandle blockIndexHandle) {
        this.blockIndexHandle = blockIndexHandle;
    }

    BlockIndexHandle getBlockIndexHandle() {
        return this.blockIndexHandle;
    }

    byte[] encode() {
        byte[] indexBlock = this.blockIndexHandle.encode();
        assert (indexBlock.length == BlockIndexHandle.BLOCK_HANDLE_SIZE);
        ByteBuffer buffer = ByteBuffer.allocate(BlockIndexHandle.BLOCK_HANDLE_SIZE + 8);
        buffer.put(indexBlock);
        buffer.putLong(24068102L);
        return buffer.array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Footer footer = (Footer)o;
        return this.getBlockIndexHandle().equals(footer.getBlockIndexHandle());
    }

    public int hashCode() {
        return Objects.hash(this.getBlockIndexHandle());
    }

    public String toString() {
        return "Footer{blockIndexHandle=" + this.blockIndexHandle + '}';
    }
}

