/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir.storage;

import com.github.ylgrgyq.reservoir.NamedThreadFactory;
import com.github.ylgrgyq.reservoir.StorageException;
import com.github.ylgrgyq.reservoir.storage.FileStorage;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class FileStorageBuilder {
    private boolean forceSyncOnFlushConsumerCommitLogWriter = false;
    private boolean forceSyncOnFlushDataLogWriter = false;
    private long readRetryIntervalMillis = 500L;
    private long truncateIntervalMillis = TimeUnit.MINUTES.toMillis(1L);
    private final String storageBaseDir;
    @Nullable
    private ExecutorService flushMemtableExecutorService;

    public static FileStorageBuilder newBuilder(String storageBaseDir) {
        Objects.requireNonNull(storageBaseDir, "storageBaseDir");
        return new FileStorageBuilder(storageBaseDir);
    }

    private FileStorageBuilder(String storageBaseDir) {
        this.storageBaseDir = storageBaseDir;
    }

    String getStorageBaseDir() {
        return this.storageBaseDir;
    }

    long getReadRetryIntervalMillis() {
        return this.readRetryIntervalMillis;
    }

    public FileStorageBuilder setReadRetryIntervalMillis(long readRetryInterval, TimeUnit unit) {
        if (readRetryInterval <= 0L) {
            throw new IllegalArgumentException("readRetryInterval: " + readRetryInterval + " (expect: > 0)");
        }
        Objects.requireNonNull(unit, "unit");
        this.readRetryIntervalMillis = unit.toMillis(readRetryInterval);
        return this;
    }

    long getTruncateIntervalMillis() {
        return this.truncateIntervalMillis;
    }

    public FileStorageBuilder setTruncateIntervalMillis(long truncateInterval, TimeUnit unit) {
        if (truncateInterval < 0L) {
            throw new IllegalArgumentException("truncateInterval: " + truncateInterval + " (expect: >= 0)");
        }
        Objects.requireNonNull(unit, "unit");
        this.truncateIntervalMillis = unit.toMillis(truncateInterval);
        return this;
    }

    ExecutorService getFlushMemtableExecutorService() {
        if (this.flushMemtableExecutorService == null) {
            this.flushMemtableExecutorService = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("memtable-writer-"));
        }
        return this.flushMemtableExecutorService;
    }

    public FileStorageBuilder setFlushMemtableExecutorService(ExecutorService flushMemtableExecutorService) {
        Objects.requireNonNull(flushMemtableExecutorService, "flushMemtableExecutorService");
        this.flushMemtableExecutorService = flushMemtableExecutorService;
        return this;
    }

    boolean isForceSyncOnFlushConsumerCommitLogWriter() {
        return this.forceSyncOnFlushConsumerCommitLogWriter;
    }

    public void setForceSyncOnFlushConsumerCommitLogWriter(boolean forceSyncOnFlushConsumerCommitLogWriter) {
        this.forceSyncOnFlushConsumerCommitLogWriter = forceSyncOnFlushConsumerCommitLogWriter;
    }

    boolean isForceSyncOnFlushDataLogWriter() {
        return this.forceSyncOnFlushDataLogWriter;
    }

    public void setForceSyncOnFlushDataLogWriter(boolean forceSyncOnFlushDataLogWriter) {
        this.forceSyncOnFlushDataLogWriter = forceSyncOnFlushDataLogWriter;
    }

    public FileStorage build() throws StorageException {
        if (this.flushMemtableExecutorService == null) {
            this.flushMemtableExecutorService = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("memtable-writer-"));
        }
        return new FileStorage(this);
    }
}

