/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir.storage;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Objects;

class BufferedChannel
implements AutoCloseable {
    private final FileChannel fileChannel;
    private final ByteBuffer readBuffer;
    private final ByteBuffer writeBuffer;
    private long readBufferStartPosition;
    private long writeBufferStartPosition;

    BufferedChannel(FileChannel fileChannel) throws IOException {
        this(fileChannel, 4096, 4096);
    }

    BufferedChannel(FileChannel fileChannel, int readCapacity, int writeCapacity) throws IOException {
        Objects.requireNonNull(fileChannel, "fileChannel");
        this.fileChannel = fileChannel;
        this.readBuffer = ByteBuffer.allocate(readCapacity);
        this.readBuffer.flip();
        this.writeBuffer = ByteBuffer.allocateDirect(writeCapacity);
        this.readBufferStartPosition = fileChannel.position();
        this.writeBufferStartPosition = fileChannel.position();
    }

    synchronized void write(ByteBuffer src) throws IOException {
        while (src.hasRemaining()) {
            ByteBuffer buf = src.slice();
            buf.limit(Math.min(this.writeBuffer.remaining(), buf.remaining()));
            int pos = src.position() + buf.remaining();
            this.writeBuffer.put(buf);
            src.position(pos);
            if (this.writeBuffer.hasRemaining()) continue;
            this.flush();
        }
    }

    synchronized void flush() throws IOException {
        this.writeBuffer.flip();
        do {
            this.fileChannel.write(this.writeBuffer);
        } while (this.writeBuffer.hasRemaining());
        this.writeBuffer.clear();
    }

    void force() throws IOException {
        this.fileChannel.force(true);
    }

    int read(ByteBuffer dest) throws IOException {
        return this.read(dest, this.readBufferStartPosition + (long)this.readBuffer.position());
    }

    int read(ByteBuffer dest, long pos) throws IOException {
        return this.read(dest, pos, dest.limit());
    }

    synchronized int read(ByteBuffer dest, long pos, int length) throws IOException {
        long currentPos = pos;
        long eof = this.fileChannel.size();
        if (currentPos >= eof) {
            return -1;
        }
        while (length > 0) {
            if (this.readBufferStartPosition <= currentPos && currentPos < this.readBufferStartPosition + (long)this.readBuffer.limit()) {
                int startPosInBuffer = (int)(currentPos - this.readBufferStartPosition);
                this.readBuffer.position(startPosInBuffer);
                int bytesSize = Math.min(length, this.readBuffer.remaining());
                Buffer buf = this.readBuffer.slice().limit(bytesSize);
                dest.put((ByteBuffer)buf);
                this.readBuffer.position(startPosInBuffer + bytesSize);
                currentPos += (long)bytesSize;
                length -= bytesSize;
                continue;
            }
            if (currentPos >= eof) break;
            this.readBufferStartPosition = currentPos;
            this.readBuffer.clear();
            if (this.fileChannel.read(this.readBuffer, currentPos) <= 0) {
                throw new IOException("EOF before read enough bytes");
            }
            this.readBuffer.flip();
        }
        return (int)(currentPos - pos);
    }

    @Override
    public synchronized void close() throws IOException {
        this.fileChannel.close();
        this.writeBuffer.clear();
        this.writeBuffer.flip();
        this.readBuffer.clear();
        this.readBuffer.flip();
    }
}

