/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir;

import com.github.ylgrgyq.reservoir.ObjectQueueConsumer;
import com.github.ylgrgyq.reservoir.ObjectQueueProducer;
import com.github.ylgrgyq.reservoir.StorageException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class ObjectQueue<E>
implements ObjectQueueConsumer<E>,
ObjectQueueProducer<E> {
    private final ObjectQueueProducer<E> producerDelegate;
    private final ObjectQueueConsumer<E> consumerDelegate;

    ObjectQueue(ObjectQueueProducer<E> producerDelegate, ObjectQueueConsumer<E> consumerDelegate) {
        this.producerDelegate = producerDelegate;
        this.consumerDelegate = consumerDelegate;
    }

    @Override
    public CompletableFuture<Void> produce(E object) {
        Objects.requireNonNull(object, "object");
        return this.producerDelegate.produce(object);
    }

    @Override
    public CompletableFuture<Void> flush() {
        return this.producerDelegate.flush();
    }

    @Override
    public E fetch() throws InterruptedException, StorageException {
        return this.consumerDelegate.fetch();
    }

    @Override
    @Nullable
    public E fetch(long timeout, TimeUnit unit) throws InterruptedException, StorageException {
        Objects.requireNonNull(unit, "unit");
        return this.consumerDelegate.fetch(timeout, unit);
    }

    @Override
    public void commit() throws StorageException {
        this.consumerDelegate.commit();
    }

    @Override
    public void close() throws Exception {
        this.producerDelegate.close();
        this.consumerDelegate.close();
    }

    @Override
    public boolean closed() {
        return this.consumerDelegate.closed();
    }
}

