/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir.benchmark.storage;

import com.codahale.metrics.Timer;
import com.github.ylgrgyq.reservoir.FileUtils;
import com.github.ylgrgyq.reservoir.ObjectQueueStorage;
import com.github.ylgrgyq.reservoir.StorageException;
import com.github.ylgrgyq.reservoir.benchmark.storage.BenchmarkTest;
import com.github.ylgrgyq.reservoir.benchmark.storage.BenchmarkTestReport;
import com.github.ylgrgyq.reservoir.benchmark.storage.DefaultBenchmarkReport;
import com.github.ylgrgyq.reservoir.benchmark.storage.TestingDataGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

abstract class StorageStoreBenchmark
implements BenchmarkTest {
    private final int numBatches;
    private final int dataSize;
    private final int numDataPerBatch;
    private final List<List<byte[]>> testingData;
    private final String baseDir;
    @Nullable
    private ObjectQueueStorage storage;
    @Nullable
    private Timer timer;

    StorageStoreBenchmark(int dataSize, int numDataPerBatch, int numBatches) {
        this.dataSize = dataSize;
        this.numBatches = numBatches;
        this.numDataPerBatch = numDataPerBatch;
        this.testingData = new ArrayList<List<byte[]>>(TestingDataGenerator.generate(dataSize, numBatches, numDataPerBatch));
        String tempDir = System.getProperty("java.io.tmpdir", "/tmp") + File.separator + "reservoir_benchmark_" + System.nanoTime();
        File tempFile = new File(tempDir);
        this.baseDir = tempFile.getPath();
    }

    @Override
    public void setup() throws Exception {
        String tempDir = this.baseDir + File.separator + "test_only_store" + System.nanoTime();
        File tempFile = new File(tempDir);
        FileUtils.forceMkdir((File)tempFile);
        this.storage = this.createStorage(tempFile.getPath());
        this.timer = new Timer();
    }

    @Override
    public void teardown() throws Exception {
        assert (this.storage != null);
        this.storage.close();
    }

    @Override
    public String testingSpec() {
        return "description: " + this.getTestDescription() + "\nstorage path: " + this.baseDir + "\nsize in bytes for each data: " + this.dataSize + "\nnumber of data per batch: " + this.numDataPerBatch + "\nnumber of batches: " + this.numBatches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BenchmarkTestReport runTest() throws StorageException {
        assert (this.timer != null);
        assert (this.storage != null);
        long start = System.nanoTime();
        for (List<byte[]> data : this.testingData) {
            Timer.Context cxt = this.timer.time();
            try {
                this.storage.store(data);
            }
            finally {
                cxt.stop();
            }
        }
        return new DefaultBenchmarkReport(System.nanoTime() - start, this.timer);
    }

    abstract String getTestDescription();

    abstract ObjectQueueStorage createStorage(String var1) throws Exception;
}

