/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir.storage;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.ylgrgyq.reservoir.ObjectWithId;
import com.github.ylgrgyq.reservoir.storage.FileName;
import com.github.ylgrgyq.reservoir.storage.SeekableIterator;
import com.github.ylgrgyq.reservoir.storage.Table;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class TableCache {
    private String baseDir;
    private Cache<Integer, Table> cache;

    TableCache(String baseDir) {
        this.baseDir = baseDir;
        this.cache = Caffeine.newBuilder().maximumSize(1024L).build();
    }

    private Table findTable(int fileNumber, long fileSize) throws IOException {
        Table t = this.cache.getIfPresent(fileNumber);
        if (t == null) {
            t = this.loadTable(fileNumber, fileSize);
        }
        return t;
    }

    Table loadTable(int fileNumber, long fileSize) throws IOException {
        String tableFileName = FileName.getSSTableName(fileNumber);
        FileChannel ch = FileChannel.open(Paths.get(this.baseDir, tableFileName), StandardOpenOption.READ);
        Table t = Table.open(ch, fileSize);
        this.cache.put(fileNumber, t);
        return t;
    }

    SeekableIterator<Long, ObjectWithId> iterator(int fileNumber, long fileSize) throws IOException {
        Table t = this.findTable(fileNumber, fileSize);
        return t.iterator();
    }

    boolean hasTable(int fileNumber) {
        Table t = this.cache.getIfPresent(fileNumber);
        return t != null;
    }

    void evict(int fileNumber) throws IOException {
        Table t = this.cache.getIfPresent(fileNumber);
        if (t != null) {
            t.close();
        }
        this.cache.invalidate(fileNumber);
    }

    void evict(List<Integer> fileNumbers) throws IOException {
        for (int fileNumber : fileNumbers) {
            this.evict(fileNumber);
        }
    }

    void evictAll() throws IOException {
        for (Map.Entry e : this.cache.asMap().entrySet()) {
            ((Table)e.getValue()).close();
        }
        this.cache.invalidateAll();
    }

    Set<Integer> getAllFileNumbers() {
        return this.cache.asMap().keySet();
    }
}

