/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir.storage;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.ylgrgyq.reservoir.ObjectWithId;
import com.github.ylgrgyq.reservoir.storage.Block;
import com.github.ylgrgyq.reservoir.storage.BlockIndexHandle;
import com.github.ylgrgyq.reservoir.storage.Footer;
import com.github.ylgrgyq.reservoir.storage.SeekableIterator;
import com.github.ylgrgyq.reservoir.storage.StorageRuntimeException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.zip.CRC32;
import javax.annotation.Nullable;

final class Table
implements Iterable<ObjectWithId> {
    private final Cache<Long, Block> dataBlockCache = Caffeine.newBuilder().initialCapacity(1024).maximumSize(2048L).build();
    private final FileChannel fileChannel;
    private final Block indexBlock;

    static Table open(FileChannel fileChannel, long fileSize) throws IOException {
        long footerOffset = fileSize - (long)Footer.tableFooterSize;
        ByteBuffer footerBuffer = ByteBuffer.allocate(Footer.tableFooterSize);
        fileChannel.read(footerBuffer, footerOffset);
        footerBuffer.flip();
        Footer footer = Footer.decode(footerBuffer.array());
        BlockIndexHandle blockIndexHandle = footer.getBlockIndexHandle();
        Block indexBlock = Table.readBlockFromChannel(fileChannel, blockIndexHandle);
        return new Table(fileChannel, indexBlock);
    }

    private static Block readBlockFromChannel(FileChannel fileChannel, BlockIndexHandle handle) throws IOException {
        ByteBuffer content = ByteBuffer.allocate(handle.getBlockSize());
        fileChannel.position(handle.getBlockStartOffset());
        fileChannel.read(content);
        ByteBuffer trailer = ByteBuffer.allocate(8);
        fileChannel.read(trailer);
        trailer.flip();
        long expectChecksum = trailer.getLong();
        CRC32 actualChecksum = new CRC32();
        actualChecksum.update(content.array());
        if (expectChecksum != actualChecksum.getValue()) {
            throw new IllegalArgumentException("actualChecksum: " + actualChecksum.getValue() + " (expect: = " + expectChecksum + ")");
        }
        return new Block(content);
    }

    private Table(FileChannel fileChannel, Block indexBlock) {
        this.fileChannel = fileChannel;
        this.indexBlock = indexBlock;
    }

    void close() throws IOException {
        this.fileChannel.close();
        this.dataBlockCache.invalidateAll();
    }

    public SeekableIterator<Long, ObjectWithId> iterator() {
        return new Itr(this.indexBlock);
    }

    private class Itr
    implements SeekableIterator<Long, ObjectWithId> {
        private final SeekableIterator<Long, ObjectWithId> indexBlockIter;
        @Nullable
        private SeekableIterator<Long, ObjectWithId> innerBlockIter;

        Itr(Block indexBlock) {
            this.indexBlockIter = indexBlock.iterator();
        }

        public Itr seek(Long key) {
            this.indexBlockIter.seek(key);
            if (this.indexBlockIter.hasNext()) {
                this.innerBlockIter = this.createInnerBlockIter();
                this.innerBlockIter.seek(key);
            } else {
                this.innerBlockIter = null;
            }
            return this;
        }

        @Override
        public boolean hasNext() {
            if ((this.innerBlockIter == null || !this.innerBlockIter.hasNext()) && this.indexBlockIter.hasNext()) {
                this.innerBlockIter = this.createInnerBlockIter();
            }
            return this.innerBlockIter != null && this.innerBlockIter.hasNext();
        }

        @Override
        public ObjectWithId next() {
            assert (this.innerBlockIter != null);
            assert (this.innerBlockIter.hasNext());
            return (ObjectWithId)this.innerBlockIter.next();
        }

        private SeekableIterator<Long, ObjectWithId> createInnerBlockIter() {
            try {
                ObjectWithId kv = (ObjectWithId)this.indexBlockIter.next();
                BlockIndexHandle handle = BlockIndexHandle.decode(kv.getObjectInBytes());
                Block block = this.getBlock(handle);
                return block.iterator();
            }
            catch (IOException ex) {
                throw new StorageRuntimeException("create inner block iterator failed", ex);
            }
        }

        private Block getBlock(BlockIndexHandle handle) throws IOException {
            Cache cache = Table.this.dataBlockCache;
            Block block = (Block)cache.getIfPresent(handle.getBlockStartOffset());
            if (block == null) {
                block = Table.readBlockFromChannel(Table.this.fileChannel, handle);
                cache.put(handle.getBlockStartOffset(), block);
            }
            return block;
        }
    }
}

