/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir.storage;

import com.github.ylgrgyq.reservoir.ObjectWithId;
import com.github.ylgrgyq.reservoir.storage.SeekableIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.Nullable;

final class Memtable
implements Iterable<ObjectWithId> {
    private final ConcurrentSkipListMap<Long, byte[]> table = new ConcurrentSkipListMap();
    private int memSize;

    Memtable() {
    }

    void add(ObjectWithId val) {
        long k = val.getId();
        byte[] v = val.getObjectInBytes();
        this.table.put(k, v);
        this.memSize += 8 + v.length;
    }

    long firstId() {
        if (this.table.isEmpty()) {
            return -1L;
        }
        return this.table.firstKey();
    }

    long lastId() {
        if (this.table.isEmpty()) {
            return -1L;
        }
        return this.table.lastKey();
    }

    boolean isEmpty() {
        return this.table.isEmpty();
    }

    List<ObjectWithId> getEntries(long start, int limit) {
        ObjectWithId v;
        if (start > this.lastId()) {
            return Collections.emptyList();
        }
        Iterator iter = this.iterator();
        iter.seek(start);
        ArrayList<ObjectWithId> ret = new ArrayList<ObjectWithId>();
        while (iter.hasNext() && (v = (ObjectWithId)iter.next()).getId() > start && ret.size() < limit) {
            ret.add(v);
        }
        return ret;
    }

    int getMemoryUsedInBytes() {
        return this.memSize;
    }

    public SeekableIterator<Long, ObjectWithId> iterator() {
        return new Itr((ConcurrentNavigableMap<Long, byte[]>)this.table.clone());
    }

    private static class Itr
    implements SeekableIterator<Long, ObjectWithId> {
        private final ConcurrentNavigableMap<Long, byte[]> innerMap;
        @Nullable
        private Map.Entry<Long, byte[]> offset;

        Itr(ConcurrentNavigableMap<Long, byte[]> innerMap) {
            this.innerMap = innerMap;
            this.offset = innerMap.firstEntry();
        }

        @Override
        public SeekableIterator<Long, ObjectWithId> seek(Long key) {
            this.offset = this.innerMap.higherEntry(key);
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.offset != null;
        }

        @Override
        public ObjectWithId next() {
            assert (this.offset != null);
            long id = this.offset.getKey();
            byte[] v = this.offset.getValue();
            this.offset = this.innerMap.higherEntry(id);
            return new ObjectWithId(id, v);
        }
    }
}

