/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir.storage;

import com.github.ylgrgyq.reservoir.StorageException;
import com.github.ylgrgyq.reservoir.storage.BadRecordException;
import com.github.ylgrgyq.reservoir.storage.FileName;
import com.github.ylgrgyq.reservoir.storage.LogReader;
import com.github.ylgrgyq.reservoir.storage.LogWriter;
import com.github.ylgrgyq.reservoir.storage.ManifestRecord;
import com.github.ylgrgyq.reservoir.storage.SSTableFileMetaInfo;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Manifest {
    private static final Logger logger = LoggerFactory.getLogger(Manifest.class.getName());
    private final String baseDir;
    private final List<SSTableFileMetaInfo> metas;
    private final ReentrantReadWriteLock.ReadLock readMetasLock;
    private final ReentrantReadWriteLock.WriteLock writeMetasLock;
    @Nullable
    private LogWriter manifestRecordWriter;
    private int nextFileNumber = 1;
    private int dataLogFileNumber;
    private int consumerCommittedIdLogFileNumber;

    Manifest(String baseDir) {
        this.baseDir = baseDir;
        this.metas = new ArrayList<SSTableFileMetaInfo>();
        ReentrantReadWriteLock metasLock = new ReentrantReadWriteLock();
        this.readMetasLock = metasLock.readLock();
        this.writeMetasLock = metasLock.writeLock();
    }

    synchronized void logRecord(ManifestRecord record) throws IOException {
        assert (record.getType() != ManifestRecord.Type.PLAIN || record.getDataLogFileNumber() >= this.dataLogFileNumber);
        this.registerMetas(record);
        String manifestFileName = null;
        int manifestFileNumber = 0;
        if (this.manifestRecordWriter == null) {
            int fileNumber;
            manifestFileNumber = fileNumber = this.getNextFileNumber();
            manifestFileName = FileName.getManifestFileName(fileNumber);
            FileChannel manifestFile = FileChannel.open(Paths.get(this.baseDir, manifestFileName), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            this.manifestRecordWriter = new LogWriter(manifestFile);
        }
        if (record.getType() == ManifestRecord.Type.PLAIN) {
            record.setNextFileNumber(this.nextFileNumber);
        }
        this.manifestRecordWriter.append(record.encode());
        this.manifestRecordWriter.flush();
        logger.debug("written manifest record {} to manifest file number {}", (Object)record, (Object)manifestFileNumber);
        if (manifestFileName != null) {
            assert (manifestFileNumber != 0);
            FileName.setCurrentFile(this.baseDir, manifestFileNumber);
        }
        if (record.getType() == ManifestRecord.Type.PLAIN) {
            this.dataLogFileNumber = record.getDataLogFileNumber();
            this.consumerCommittedIdLogFileNumber = record.getConsumerCommitLogFileNumber();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void recover(String manifestFileName) throws IOException, StorageException {
        Path manifestFilePath = Paths.get(this.baseDir, manifestFileName);
        if (!Files.exists(manifestFilePath, new LinkOption[0])) {
            throw new StorageException("CURRENT file points to an non-exists manifest file: " + this.baseDir + File.separator + manifestFileName);
        }
        FileChannel manifestFile = FileChannel.open(manifestFilePath, StandardOpenOption.READ);
        ArrayList<SSTableFileMetaInfo> ms = new ArrayList<SSTableFileMetaInfo>();
        try (LogReader reader = new LogReader(manifestFile, true);){
            List<byte[]> logOpt;
            while (!(logOpt = reader.readLog()).isEmpty()) {
                ManifestRecord record = ManifestRecord.decode(logOpt);
                switch (record.getType()) {
                    case PLAIN: {
                        this.nextFileNumber = record.getNextFileNumber();
                        this.dataLogFileNumber = record.getDataLogFileNumber();
                        this.consumerCommittedIdLogFileNumber = record.getConsumerCommitLogFileNumber();
                        break;
                    }
                    case REPLACE_METAS: {
                        ms.clear();
                        break;
                    }
                    default: {
                        throw new StorageException("unknown manifest record type:" + (Object)((Object)record.getType()));
                    }
                }
                ms.addAll(record.getMetas());
            }
            this.writeMetasLock.lock();
            try {
                assert (this.metas.isEmpty());
                this.metas.addAll(ms);
            }
            finally {
                this.writeMetasLock.unlock();
            }
        }
        catch (BadRecordException ex) {
            String msg = String.format("recover manifest from file:\"%s\" failed due to \"%s\" log record", manifestFileName, manifestFilePath);
            throw new StorageException(msg);
        }
    }

    long getFirstId() {
        this.readMetasLock.lock();
        try {
            if (!this.metas.isEmpty()) {
                long l = this.metas.get(0).getFirstId();
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            this.readMetasLock.unlock();
        }
    }

    long getLastId() {
        this.readMetasLock.lock();
        try {
            if (!this.metas.isEmpty()) {
                long l = this.metas.get(this.metas.size() - 1).getLastId();
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            this.readMetasLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void truncateToId(long toId) throws IOException {
        this.writeMetasLock.lock();
        try {
            if (toId > 0L) {
                List<SSTableFileMetaInfo> remainMetas = this.searchMetas(toId);
                if (remainMetas.size() < this.metas.size()) {
                    ManifestRecord record = ManifestRecord.newReplaceAllExistedMetasRecord();
                    record.addMetas(remainMetas);
                    this.logRecord(record);
                    this.registerMetas(record);
                } else assert (remainMetas.size() == this.metas.size());
            }
        }
        finally {
            this.writeMetasLock.unlock();
        }
    }

    synchronized void close() throws IOException {
        if (this.manifestRecordWriter != null) {
            this.manifestRecordWriter.close();
        }
    }

    synchronized int getNextFileNumber() {
        return this.nextFileNumber++;
    }

    synchronized int getDataLogFileNumber() {
        return this.dataLogFileNumber;
    }

    synchronized int getConsumerCommittedIdLogFileNumber() {
        return this.consumerCommittedIdLogFileNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SSTableFileMetaInfo> searchMetas(long startId) {
        this.readMetasLock.lock();
        try {
            int startMetaIndex = this.metas.size() > 32 ? this.binarySearchStartMeta(startId) : this.traverseSearchStartMeta(startId);
            List<SSTableFileMetaInfo> list = this.metas.subList(startMetaIndex, this.metas.size());
            return list;
        }
        finally {
            this.readMetasLock.unlock();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Manifest manifest = (Manifest)o;
        return this.getNextFileNumber() == manifest.getNextFileNumber() && this.getDataLogFileNumber() == manifest.getDataLogFileNumber() && this.getConsumerCommittedIdLogFileNumber() == manifest.getConsumerCommittedIdLogFileNumber() && this.baseDir.equals(manifest.baseDir) && this.metas.equals(manifest.metas);
    }

    public int hashCode() {
        return Objects.hash(this.baseDir, this.metas, this.getNextFileNumber(), this.getDataLogFileNumber(), this.getConsumerCommittedIdLogFileNumber());
    }

    private int traverseSearchStartMeta(long index) {
        SSTableFileMetaInfo meta;
        int i;
        for (i = 0; i < this.metas.size() && index > (meta = this.metas.get(i)).getFirstId() && index > meta.getLastId(); ++i) {
        }
        return i;
    }

    private int binarySearchStartMeta(long index) {
        int start = 0;
        int end = this.metas.size();
        while (start < end) {
            int mid = (start + end) / 2;
            SSTableFileMetaInfo meta = this.metas.get(mid);
            if (index >= meta.getFirstId() && index <= meta.getLastId()) {
                return mid;
            }
            if (index < meta.getFirstId()) {
                end = mid;
                continue;
            }
            start = mid + 1;
        }
        return start;
    }

    private void registerMetas(ManifestRecord record) {
        this.writeMetasLock.lock();
        try {
            if (record.getType() == ManifestRecord.Type.REPLACE_METAS) {
                this.metas.clear();
            }
            this.metas.addAll(record.getMetas());
        }
        finally {
            this.writeMetasLock.unlock();
        }
    }
}

