/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir.storage;

import com.github.ylgrgyq.reservoir.StorageException;
import com.github.ylgrgyq.reservoir.storage.BadRecordException;
import com.github.ylgrgyq.reservoir.storage.RecordType;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.CRC32;

final class LogReader
implements Closeable {
    private final FileChannel workingFileChannel;
    private final boolean checkChecksum;
    private final ByteBuffer buffer;
    private boolean eof;

    LogReader(FileChannel workingFileChannel, boolean checkChecksum) {
        this.workingFileChannel = workingFileChannel;
        this.buffer = ByteBuffer.allocate(32768);
        this.buffer.flip();
        this.checkChecksum = checkChecksum;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<byte[]> readLog() throws IOException, StorageException {
        RecordType type;
        ArrayList<byte[]> outPut = new ArrayList<byte[]>();
        boolean isFragmented = false;
        block7: while (true) {
            type = this.readRecord(outPut);
            switch (type) {
                case kFullType: {
                    if (isFragmented) {
                        throw new StorageException("partial record without end(1)");
                    }
                    assert (!outPut.isEmpty());
                    return outPut;
                }
                case kFirstType: {
                    if (isFragmented) {
                        throw new StorageException("partial record without end(2)");
                    }
                    isFragmented = true;
                    continue block7;
                }
                case kMiddleType: {
                    if (!isFragmented) throw new StorageException("missing start of fragmented record");
                    continue block7;
                }
                case kLastType: {
                    if (!isFragmented) {
                        throw new StorageException("missing start for the last fragmented record");
                    }
                    assert (!outPut.isEmpty());
                    return outPut;
                }
                case kEOF: {
                    return Collections.emptyList();
                }
            }
            break;
        }
        throw new StorageException("unknown record type: " + (Object)((Object)type));
    }

    @Override
    public void close() throws IOException {
        this.workingFileChannel.close();
        this.buffer.clear();
    }

    private RecordType readRecord(List<byte[]> out) throws IOException, StorageException {
        while (this.buffer.remaining() <= 11) {
            if (this.eof) {
                return RecordType.kEOF;
            }
            this.buffer.clear();
            this.readBlockFromChannel(this.buffer);
        }
        long expectChecksum = this.buffer.getLong();
        short length = this.buffer.getShort();
        byte typeCode = this.buffer.get();
        if (length <= 0 || length > this.buffer.remaining()) {
            if (this.eof) {
                return RecordType.kEOF;
            }
            throw new BadRecordException("block buffer under flow. need: " + length + " remain: " + this.buffer.remaining());
        }
        RecordType type = RecordType.getRecordTypeByCode(typeCode);
        if (type == null) {
            throw new BadRecordException("unknown record type code: " + typeCode);
        }
        byte[] buf = new byte[length];
        this.buffer.get(buf);
        if (this.checkChecksum) {
            CRC32 actualChecksum = new CRC32();
            actualChecksum.update(typeCode);
            actualChecksum.update(buf);
            if (actualChecksum.getValue() != expectChecksum) {
                throw new BadRecordException("checksum: " + actualChecksum.getValue() + " expect: " + expectChecksum);
            }
        }
        out.add(buf);
        return type;
    }

    private void readBlockFromChannel(ByteBuffer buffer) throws IOException {
        while (buffer.hasRemaining()) {
            int readBs = this.workingFileChannel.read(buffer);
            if (readBs != -1) continue;
            this.eof = true;
            break;
        }
        buffer.flip();
    }
}

