/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir.storage;

import com.github.ylgrgyq.reservoir.NamedThreadFactory;
import com.github.ylgrgyq.reservoir.StorageException;
import com.github.ylgrgyq.reservoir.storage.FileBasedStorage;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class FileBasedStorageBuilder {
    private long readRetryIntervalMillis = 500L;
    private long truncateIntervalMillis = TimeUnit.MINUTES.toMillis(1L);
    private final String storageBaseDir;
    @Nullable
    private ExecutorService flushMemtableExecutorService;

    public static FileBasedStorageBuilder newBuilder(String storageBaseDir) {
        Objects.requireNonNull(storageBaseDir, "storageBaseDir");
        return new FileBasedStorageBuilder(storageBaseDir);
    }

    private FileBasedStorageBuilder(String storageBaseDir) {
        this.storageBaseDir = storageBaseDir;
    }

    String getStorageBaseDir() {
        return this.storageBaseDir;
    }

    long getReadRetryIntervalMillis() {
        return this.readRetryIntervalMillis;
    }

    public FileBasedStorageBuilder setReadRetryIntervalMillis(long readRetryInterval, TimeUnit unit) {
        if (readRetryInterval <= 0L) {
            throw new IllegalArgumentException("readRetryInterval: " + readRetryInterval + " (expect: > 0)");
        }
        Objects.requireNonNull(unit, "unit");
        this.readRetryIntervalMillis = unit.toMillis(readRetryInterval);
        return this;
    }

    long getTruncateIntervalMillis() {
        return this.truncateIntervalMillis;
    }

    public FileBasedStorageBuilder setTruncateIntervalMillis(long truncateInterval, TimeUnit unit) {
        if (truncateInterval < 0L) {
            throw new IllegalArgumentException("truncateInterval: " + truncateInterval + " (expect: >= 0)");
        }
        Objects.requireNonNull(unit, "unit");
        this.truncateIntervalMillis = unit.toMillis(truncateInterval);
        return this;
    }

    ExecutorService getFlushMemtableExecutorService() {
        if (this.flushMemtableExecutorService == null) {
            this.flushMemtableExecutorService = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("memtable-writer-"));
        }
        return this.flushMemtableExecutorService;
    }

    public FileBasedStorageBuilder setFlushMemtableExecutorService(ExecutorService flushMemtableExecutorService) {
        Objects.requireNonNull(flushMemtableExecutorService, "flushMemtableExecutorService");
        this.flushMemtableExecutorService = flushMemtableExecutorService;
        return this;
    }

    public FileBasedStorage build() throws StorageException {
        if (this.flushMemtableExecutorService == null) {
            this.flushMemtableExecutorService = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("memtable-writer-"));
        }
        return new FileBasedStorage(this);
    }
}

