/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;

final class BlockBuilder {
    private final List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
    private final List<Integer> checkPoints = new ArrayList<Integer>();
    private int blockSize;
    private int entryCounter;
    private boolean isBuilt;

    BlockBuilder() {
    }

    long add(long k, byte[] v) {
        assert (!this.isBuilt);
        assert (v.length > 0) : "length: " + v.length;
        if ((this.entryCounter++ & 0x3F) == 0) {
            this.checkPoints.add(this.blockSize);
        }
        ByteBuffer buffer = ByteBuffer.allocate(12 + v.length);
        buffer.putLong(k);
        buffer.putInt(v.length);
        buffer.put(v);
        buffer.flip();
        this.buffers.add(buffer);
        this.blockSize += buffer.limit();
        return this.blockSize;
    }

    int estimateBlockSize() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.blockSize + 4 * this.checkPoints.size() + 4;
    }

    WriteBlockResult writeBlock(FileChannel fileChannel) throws IOException {
        assert (!this.isBuilt);
        assert (!this.buffers.isEmpty());
        assert (!this.checkPoints.isEmpty());
        this.isBuilt = true;
        ByteBuffer checkpointsBuffer = ByteBuffer.allocate(4 * this.checkPoints.size() + 4);
        for (Integer n : this.checkPoints) {
            checkpointsBuffer.putInt(n);
        }
        checkpointsBuffer.putInt(this.checkPoints.size());
        checkpointsBuffer.flip();
        this.buffers.add(checkpointsBuffer);
        this.blockSize += checkpointsBuffer.limit();
        CRC32 checksum = new CRC32();
        for (ByteBuffer buffer : this.buffers) {
            checksum.update(buffer.array());
        }
        ByteBuffer[] byteBufferArray = new ByteBuffer[this.buffers.size()];
        this.buffers.toArray(byteBufferArray);
        int written = 0;
        while (written < this.blockSize) {
            written = (int)((long)written + fileChannel.write(byteBufferArray));
        }
        assert (written > 0 && written == this.blockSize);
        return new WriteBlockResult(checksum.getValue(), written);
    }

    int getBlockDataSize() {
        return this.blockSize;
    }

    boolean isEmpty() {
        return this.blockSize == 0;
    }

    void reset() {
        this.buffers.clear();
        this.checkPoints.clear();
        this.blockSize = 0;
        this.entryCounter = 0;
        this.isBuilt = false;
    }

    static class WriteBlockResult {
        private final long checksum;
        private final int writtenBlockSize;

        private WriteBlockResult(long checksum, int writtenBlockSize) {
            this.checksum = checksum;
            this.writtenBlockSize = writtenBlockSize;
        }

        long getChecksum() {
            return this.checksum;
        }

        int getWrittenBlockSize() {
            return this.writtenBlockSize;
        }
    }
}

