/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir.storage;

import com.github.ylgrgyq.reservoir.ObjectWithId;
import com.github.ylgrgyq.reservoir.storage.SeekableIterator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

final class Block
implements Iterable<ObjectWithId> {
    private final ByteBuffer content;
    private final List<Integer> checkpoints;

    Block(ByteBuffer content) {
        this.content = content;
        content.position(content.limit() - 4);
        int checkpointSize = content.getInt();
        assert (checkpointSize > 0);
        this.checkpoints = new ArrayList<Integer>(checkpointSize);
        int checkpointStart = content.limit() - 4 - checkpointSize * 4;
        content.position(checkpointStart);
        int lastCheckpoint = -1;
        for (int i = 0; i < checkpointSize; ++i) {
            int checkpoint = content.getInt();
            assert (lastCheckpoint < checkpoint) : "checkpoint: " + checkpoint + ", lastCheckpoint: " + lastCheckpoint;
            lastCheckpoint = checkpoint;
            assert (checkpoint < checkpointStart) : "checkpoint: " + checkpoint + ", checkpointStart: " + checkpointStart;
            this.checkpoints.add(checkpoint);
        }
        content.rewind();
        content.limit(checkpointStart);
    }

    public SeekableIterator<Long, ObjectWithId> iterator() {
        return new Itr(this.content);
    }

    private int findStartCheckpoint(long key) {
        int start = 0;
        int end = this.checkpoints.size();
        while (start < end - 1) {
            int mid = (start + end) / 2;
            this.content.position(this.checkpoints.get(mid));
            long k = this.content.getLong();
            if (key < k) {
                end = mid;
                continue;
            }
            if (key <= k) break;
            if (mid + 1 >= end) {
                start = mid;
                continue;
            }
            this.content.position(this.checkpoints.get(mid + 1));
            k = this.content.getLong();
            if (key > k) {
                start = mid + 1;
                continue;
            }
            start = mid;
            break;
        }
        return start;
    }

    private byte[] readVal(ByteBuffer src, int len) {
        byte[] buffer = new byte[len];
        src.get(buffer);
        return buffer;
    }

    private class Itr
    implements SeekableIterator<Long, ObjectWithId> {
        private final ByteBuffer content;
        private int offset;

        Itr(ByteBuffer content) {
            this.content = content;
        }

        @Override
        public SeekableIterator<Long, ObjectWithId> seek(Long key) {
            int checkpoint = Block.this.findStartCheckpoint(key);
            this.offset = (Integer)Block.this.checkpoints.get(checkpoint);
            assert (this.offset < this.content.limit());
            while (this.offset < this.content.limit()) {
                this.content.position(this.offset);
                long k = this.content.getLong();
                int len = this.content.getInt();
                assert (len > 0);
                if (k > key) break;
                this.offset += len + 8 + 4;
            }
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.offset < this.content.limit();
        }

        @Override
        public ObjectWithId next() {
            assert (this.offset < this.content.limit());
            this.content.position(this.offset);
            long k = this.content.getLong();
            int len = this.content.getInt();
            assert (len > 0);
            byte[] val = Block.this.readVal(this.content, len);
            this.offset += len + 8 + 4;
            return new ObjectWithId(k, val);
        }
    }
}

