/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir.benchmark.storage;

import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.github.ylgrgyq.reservoir.benchmark.storage.BenchmarkTestReport;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class DefaultBenchmarkReport
implements BenchmarkTestReport {
    private final long testTimeElapsed;
    private final Timer timer;

    DefaultBenchmarkReport(long testTimeElapsed, Timer operationTimer) {
        this.testTimeElapsed = testTimeElapsed;
        this.timer = operationTimer;
    }

    @Override
    public String report() {
        Snapshot snapshot = this.timer.getSnapshot();
        return String.format("      time elapsed = %2.2f %s\n", this.convertDuration(this.testTimeElapsed), this.getDurationUnit()) + String.format("         mean rate = %2.2f calls/%s\n", this.timer.getMeanRate(), this.getRateUnit()) + String.format("     1-minute rate = %2.2f calls/%s\n", this.timer.getOneMinuteRate(), this.getRateUnit()) + String.format("               min = %2.2f %s\n", this.convertDuration(snapshot.getMin()), this.getDurationUnit()) + String.format("               max = %2.2f %s\n", this.convertDuration(snapshot.getMax()), this.getDurationUnit()) + String.format("              mean = %2.2f %s\n", this.convertDuration(snapshot.getMean()), this.getDurationUnit()) + String.format("            stddev = %2.2f %s\n", this.convertDuration(snapshot.getStdDev()), this.getDurationUnit()) + String.format("            median = %2.2f %s\n", this.convertDuration(snapshot.getMedian()), this.getDurationUnit()) + String.format("              75%% <= %2.2f %s\n", this.convertDuration(snapshot.get75thPercentile()), this.getDurationUnit()) + String.format("              95%% <= %2.2f %s\n", this.convertDuration(snapshot.get95thPercentile()), this.getDurationUnit()) + String.format("              98%% <= %2.2f %s\n", this.convertDuration(snapshot.get98thPercentile()), this.getDurationUnit()) + String.format("              99%% <= %2.2f %s\n", this.convertDuration(snapshot.get99thPercentile()), this.getDurationUnit()) + String.format("            99.9%% <= %2.2f %s\n", this.convertDuration(snapshot.get999thPercentile()), this.getDurationUnit());
    }

    public String toString() {
        return this.report();
    }

    private String getDurationUnit() {
        return TimeUnit.MICROSECONDS.toString().toLowerCase(Locale.US);
    }

    private String getRateUnit() {
        String s2 = TimeUnit.SECONDS.toString().toLowerCase(Locale.US);
        return s2.substring(0, s2.length() - 1);
    }

    private double convertDuration(double duration) {
        return duration / (double)TimeUnit.MICROSECONDS.toNanos(1L);
    }
}

