/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir.benchmark.storage;

import com.github.ylgrgyq.reservoir.benchmark.storage.BenchmarkTest;
import com.github.ylgrgyq.reservoir.benchmark.storage.BenchmarkTestReport;
import com.github.ylgrgyq.reservoir.benchmark.storage.EnvironmentInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BenchmarkRunner {
    private static final Logger logger = LoggerFactory.getLogger(BenchmarkRunner.class.getSimpleName());
    private int warmUpTimes = 5;
    private int testTimes = 5;
    private long coolDownIntervalMillis = 5000L;

    public void runTest(BenchmarkTest test) throws Exception {
        logger.info("\nEnvironment spec:\n{}\n", (Object)EnvironmentInfo.generateEnvironmentSpec());
        logger.info("\nTesting spec:\n{}\n", (Object)test.testingSpec());
        logger.info("Warm up for {} times.", (Object)this.warmUpTimes);
        this.doTest(test, this.warmUpTimes);
        logger.info("Test for {} times.", (Object)this.testTimes);
        this.doTest(test, this.testTimes);
    }

    private void doTest(BenchmarkTest test, int repeatTimes) throws Exception {
        for (int i = 1; i <= repeatTimes; ++i) {
            test.setup();
            logger.info("The {} test start.", (Object)this.ordinalNumber(i));
            BenchmarkTestReport report = test.runTest();
            logger.info("The {} test done. Result: \n{}\n", (Object)this.ordinalNumber(i), (Object)report);
            test.teardown();
            if (i == repeatTimes) continue;
            Thread.sleep(this.coolDownIntervalMillis);
        }
    }

    private String ordinalNumber(int i) {
        String[] sufixes = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
        switch (i % 100) {
            case 11: 
            case 12: 
            case 13: {
                return i + "th";
            }
        }
        return i + sufixes[i % 10];
    }
}

