/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir.benchmark.storage;

import com.github.ylgrgyq.reservoir.benchmark.storage.BenchmarkRunner;
import com.github.ylgrgyq.reservoir.benchmark.storage.FileStorageStoreBench;
import com.github.ylgrgyq.reservoir.benchmark.storage.RocksDbStorageStoreBench;
import com.github.ylgrgyq.reservoir.benchmark.storage.StorageStoreBenchmark;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class BenchmarkBootstrap {
    public static void main(String[] args) throws Exception {
        BenchmarkOptions options = new BenchmarkOptions(args);
        StorageStoreBenchmark test = options.getStorageType().equals("RocksDB") ? new RocksDbStorageStoreBench(options.getDataSize(), options.getNumDataPerBatch(), options.getNumBatches()) : new FileStorageStoreBench(options.getDataSize(), options.getNumDataPerBatch(), options.getNumBatches());
        BenchmarkRunner runner = new BenchmarkRunner();
        runner.runTest(test);
    }

    private static Options createCliOptions() {
        Options options = new Options();
        options.addOption(new Option("s", "data-size", true, "size in bytes for each data to store"));
        options.addOption(new Option("p", "data-per-batch", true, "number of data per batch"));
        options.addOption(new Option("n", "batches", true, "number of batches"));
        options.addOption(new Option("t", "storage-type", true, "storage type"));
        return options;
    }

    private static class BenchmarkOptions {
        private final int dataSize;
        private final int numDataPerBatch;
        private final int numBatches;
        private final String storageType;

        public BenchmarkOptions(String[] args) throws Exception {
            Options options = BenchmarkBootstrap.createCliOptions();
            DefaultParser parser = new DefaultParser();
            CommandLine cmd = parser.parse(options, args);
            this.dataSize = Integer.parseInt(cmd.getOptionValue("data-size", "100"));
            this.numDataPerBatch = Integer.parseInt(cmd.getOptionValue("data-per-batch", "10"));
            this.numBatches = Integer.parseInt(cmd.getOptionValue("batches", "10000"));
            this.storageType = cmd.getOptionValue("storage-type", "file");
        }

        public int getDataSize() {
            return this.dataSize;
        }

        public int getNumDataPerBatch() {
            return this.numDataPerBatch;
        }

        public int getNumBatches() {
            return this.numBatches;
        }

        public String getStorageType() {
            return this.storageType;
        }
    }
}

