/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir;

import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;

public final class ObjectWithId {
    private final long id;
    private final byte[] objectInBytes;

    public ObjectWithId(long id, byte[] objectInBytes) {
        Objects.requireNonNull(objectInBytes, "objectInBytes");
        this.id = id;
        this.objectInBytes = Arrays.copyOf(objectInBytes, objectInBytes.length);
    }

    public long getId() {
        return this.id;
    }

    public byte[] getObjectInBytes() {
        return this.objectInBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectWithId that = (ObjectWithId)o;
        return this.getId() == that.getId() && Arrays.equals(this.getObjectInBytes(), that.getObjectInBytes());
    }

    public int hashCode() {
        int result = Objects.hash(this.getId());
        result = 31 * result + Arrays.hashCode(this.getObjectInBytes());
        return result;
    }

    public String toString() {
        return "ObjectWithId{id=" + this.id + ", objectInBytes=" + Base64.getEncoder().encodeToString(this.objectInBytes) + '}';
    }
}

