/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir;

import com.github.ylgrgyq.reservoir.AutoCommitObjectQueueConsumer;
import com.github.ylgrgyq.reservoir.Codec;
import com.github.ylgrgyq.reservoir.DisruptorBackedObjectQueueProducer;
import com.github.ylgrgyq.reservoir.ManualCommitObjectQueueConsumer;
import com.github.ylgrgyq.reservoir.NamedThreadFactory;
import com.github.ylgrgyq.reservoir.ObjectQueue;
import com.github.ylgrgyq.reservoir.ObjectQueueConsumer;
import com.github.ylgrgyq.reservoir.ObjectQueueProducer;
import com.github.ylgrgyq.reservoir.ObjectQueueStorage;
import com.github.ylgrgyq.reservoir.StorageException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;

public final class ObjectQueueBuilder<E> {
    private static final ThreadFactory threadFactory = new NamedThreadFactory("object-queue-executor-");
    private ExecutorService executorService = Executors.newSingleThreadExecutor(threadFactory);
    private int ringBufferSize = 512;
    private int batchSize = 128;
    private boolean autoCommit = true;
    @Nullable
    private ObjectQueueStorage storage;
    @Nullable
    private Codec<E> codec;

    public static <E> ObjectQueueBuilder<E> newBuilder() {
        return new ObjectQueueBuilder<E>();
    }

    private ObjectQueueBuilder() {
    }

    ObjectQueueStorage getStorage() {
        assert (this.storage != null);
        return this.storage;
    }

    public ObjectQueueBuilder<E> setStorage(ObjectQueueStorage storage) {
        Objects.requireNonNull(storage, "storage");
        this.storage = storage;
        return this;
    }

    Codec<E> getCodec() {
        assert (this.codec != null);
        return this.codec;
    }

    public ObjectQueueBuilder<E> setCodec(Codec<E> codec) {
        Objects.requireNonNull(codec, "codec");
        this.codec = codec;
        return this;
    }

    boolean isAutoCommit() {
        return this.autoCommit;
    }

    public ObjectQueueBuilder<E> setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
        return this;
    }

    int getBatchSize() {
        return this.batchSize;
    }

    public ObjectQueueBuilder<E> setBatchSize(int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize: " + batchSize + " (expected: > 0)");
        }
        this.batchSize = batchSize;
        return this;
    }

    int getRingBufferSize() {
        return this.ringBufferSize;
    }

    public ObjectQueueBuilder<E> setRingBufferSize(int ringBufferSize) {
        if (ringBufferSize <= 0) {
            throw new IllegalArgumentException("ringBufferSize: " + ringBufferSize + " (expected: > 0)");
        }
        this.ringBufferSize = ringBufferSize;
        return this;
    }

    ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        Objects.requireNonNull(executorService, "executorService");
        this.executorService = executorService;
    }

    public ObjectQueueProducer<E> buildProducer() throws StorageException {
        Objects.requireNonNull(this.storage, "storage");
        Objects.requireNonNull(this.codec, "serializer");
        Objects.requireNonNull(this.executorService, "executorService");
        return new DisruptorBackedObjectQueueProducer(this);
    }

    public ObjectQueueConsumer<E> buildConsumer() throws StorageException {
        Objects.requireNonNull(this.storage, "storage");
        Objects.requireNonNull(this.codec, "deserializer");
        if (this.autoCommit) {
            return new AutoCommitObjectQueueConsumer(this);
        }
        return new ManualCommitObjectQueueConsumer(this);
    }

    public ObjectQueue<E> buildQueue() throws StorageException {
        ObjectQueueProducer<E> producer = this.buildProducer();
        ObjectQueueConsumer<E> consumer = this.buildConsumer();
        return new ObjectQueue<E>(producer, consumer);
    }
}

