/*
 * Decompiled with CFR 0.152.
 */
package com.github.ylgrgyq.reservoir;

import com.github.ylgrgyq.reservoir.AutomaticObjectQueueConsumer;
import com.github.ylgrgyq.reservoir.Codec;
import com.github.ylgrgyq.reservoir.ConsumeObjectHandler;
import com.github.ylgrgyq.reservoir.ConsumeObjectListener;
import com.github.ylgrgyq.reservoir.ObjectQueueBuilder;
import com.github.ylgrgyq.reservoir.ObjectQueueConsumer;
import com.github.ylgrgyq.reservoir.ObjectQueueStorage;
import com.github.ylgrgyq.reservoir.StorageException;
import com.github.ylgrgyq.reservoir.Verifiable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public final class AutomaticObjectQueueConsumerBuilder<E extends Verifiable> {
    private final List<ConsumeObjectListener<E>> listeners;
    private final ObjectQueueBuilder<E> consumerBuilder = ObjectQueueBuilder.newBuilder();
    @Nullable
    private ConsumeObjectHandler<E> consumeObjectHandler;
    @Nullable
    private Executor listenerExecutor;
    @Nullable
    private ObjectQueueConsumer<E> consumer;

    public static <E extends Verifiable> AutomaticObjectQueueConsumerBuilder<E> newBuilder() {
        return new AutomaticObjectQueueConsumerBuilder<E>();
    }

    private AutomaticObjectQueueConsumerBuilder() {
        this.listeners = new ArrayList<ConsumeObjectListener<E>>();
    }

    ObjectQueueConsumer<E> getConsumer() {
        assert (this.consumer != null);
        return this.consumer;
    }

    ObjectQueueStorage getStorage() {
        return this.consumerBuilder.getStorage();
    }

    public AutomaticObjectQueueConsumerBuilder<E> addConsumeElementListener(ConsumeObjectListener<E> listener) {
        Objects.requireNonNull(listener, "listener");
        this.listeners.add(listener);
        return this;
    }

    List<ConsumeObjectListener<E>> getConsumeElementListeners() {
        return this.listeners;
    }

    public AutomaticObjectQueueConsumerBuilder<E> setStorage(ObjectQueueStorage storage) {
        Objects.requireNonNull(storage, "storage");
        this.consumerBuilder.setStorage(storage);
        return this;
    }

    Codec<E> getCodec() {
        return this.consumerBuilder.getCodec();
    }

    public AutomaticObjectQueueConsumerBuilder<E> setCodec(Codec<E> codec) {
        Objects.requireNonNull(codec, "codec");
        this.consumerBuilder.setCodec(codec);
        return this;
    }

    boolean isAutoCommit() {
        return this.consumerBuilder.isAutoCommit();
    }

    public AutomaticObjectQueueConsumerBuilder<E> setAutoCommit(boolean autoCommit) {
        this.consumerBuilder.setAutoCommit(autoCommit);
        return this;
    }

    int getBatchSize() {
        return this.consumerBuilder.getBatchSize();
    }

    public AutomaticObjectQueueConsumerBuilder<E> setBatchSize(int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize: " + batchSize + " (expected: > 0)");
        }
        this.consumerBuilder.setBatchSize(batchSize);
        return this;
    }

    ConsumeObjectHandler<E> getConsumeObjectHandler() {
        assert (this.consumeObjectHandler != null);
        return this.consumeObjectHandler;
    }

    public AutomaticObjectQueueConsumerBuilder<E> setConsumeObjectHandler(ConsumeObjectHandler<E> consumeObjectHandler) {
        Objects.requireNonNull(consumeObjectHandler, "consumeObjectHandler");
        this.consumeObjectHandler = consumeObjectHandler;
        return this;
    }

    Executor getListenerExecutor() {
        assert (this.listenerExecutor != null);
        return this.listenerExecutor;
    }

    public AutomaticObjectQueueConsumerBuilder<E> setListenerExecutor(Executor listenerExecutor) {
        Objects.requireNonNull(listenerExecutor, "listenerExecutor");
        this.listenerExecutor = listenerExecutor;
        return this;
    }

    public AutomaticObjectQueueConsumer<E> build() throws StorageException {
        Objects.requireNonNull(this.consumeObjectHandler, "consumeObjectHandler");
        Objects.requireNonNull(this.listenerExecutor, "listenerExecutor");
        this.consumer = this.consumerBuilder.buildConsumer();
        return new AutomaticObjectQueueConsumer(this);
    }
}

