/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PushbackReader;
import java.io.Reader;

public class LineNumberingPushbackReader
extends PushbackReader {
    private static final int newline = 10;
    private boolean _atLineStart = true;
    private boolean _prev;

    public LineNumberingPushbackReader(Reader r) {
        super(new LineNumberReader(r));
    }

    public LineNumberingPushbackReader(Reader r, int size) {
        super(new LineNumberReader(r, size));
    }

    public int getLineNumber() {
        return ((LineNumberReader)this.in).getLineNumber() + 1;
    }

    public int read() throws IOException {
        int c = super.read();
        this._prev = this._atLineStart;
        this._atLineStart = c == 10 || c == -1;
        return c;
    }

    public void unread(int c) throws IOException {
        super.unread(c);
        this._atLineStart = this._prev;
    }

    public String readLine() throws IOException {
        String line;
        int c = this.read();
        switch (c) {
            case -1: {
                line = null;
                break;
            }
            case 10: {
                line = "";
                break;
            }
            default: {
                String first2 = String.valueOf((char)c);
                String rest2 = ((LineNumberReader)this.in).readLine();
                line = rest2 == null ? first2 : first2 + rest2;
                this._prev = false;
                this._atLineStart = true;
            }
        }
        return line;
    }

    public boolean atLineStart() {
        return this._atLineStart;
    }
}

