/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.Compiler;
import clojure.lang.Util;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicClassLoader
extends URLClassLoader {
    HashMap<Integer, Object[]> constantVals = new HashMap();
    static ConcurrentHashMap<String, Reference<Class>> classCache = new ConcurrentHashMap();
    Map<String, byte[]> classDefnitionCache = new HashMap<String, byte[]>();
    static final URL[] EMPTY_URLS = new URL[0];
    static final ReferenceQueue rq = new ReferenceQueue();

    public DynamicClassLoader() {
        super(EMPTY_URLS, Thread.currentThread().getContextClassLoader() == null || Thread.currentThread().getContextClassLoader() == ClassLoader.getSystemClassLoader() ? Compiler.class.getClassLoader() : Thread.currentThread().getContextClassLoader());
    }

    public DynamicClassLoader(ClassLoader parent) {
        super(EMPTY_URLS, parent);
    }

    public Class defineClass(String name2, byte[] bytes2, Object srcForm) {
        Util.clearCache(rq, classCache);
        Class<?> c = this.defineClass(name2, bytes2, 0, bytes2.length);
        classCache.put(name2, new SoftReference(c, rq));
        String resName = name2.replace('.', '/') + ".class";
        this.classDefnitionCache.put(resName, bytes2);
        return c;
    }

    @Override
    protected Class<?> findClass(String name2) throws ClassNotFoundException {
        Reference<Class> cr = classCache.get(name2);
        if (cr != null) {
            Class c = cr.get();
            if (c != null) {
                return c;
            }
            classCache.remove(name2, cr);
        }
        return super.findClass(name2);
    }

    @Override
    public InputStream getResourceAsStream(String name2) {
        byte[] bytes2;
        InputStream is2 = super.getResourceAsStream(name2);
        if (is2 == null && (bytes2 = this.classDefnitionCache.get(name2)) != null) {
            is2 = new ByteArrayInputStream(bytes2);
        }
        return is2;
    }

    public void registerConstants(int id, Object[] val2) {
        this.constantVals.put(id, val2);
    }

    public Object[] getConstants(int id) {
        return this.constantVals.get(id);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }
}

