(ns slipway.auth.constraints
  (:import (org.eclipse.jetty.util.security Constraint)
           (org.eclipse.jetty.security ConstraintMapping)))

(defn ^Constraint basic-auth-constraint []
  (doto (Constraint. Constraint/__BASIC_AUTH Constraint/ANY_AUTH) ;; == allow any authenticated user
    (.setName "auth")
    (.setAuthenticate true)))

(defn ^Constraint form-auth-constraint []
  (doto (Constraint. Constraint/__FORM_AUTH Constraint/ANY_AUTH) ;; == allow any authenticated user
    (.setName "auth")
    (.setAuthenticate true)))

(defn ^Constraint no-auth []
  (doto (Constraint.) (.setName "no-auth")))

(defn constraint-mapping
  [^String path ^Constraint constraint]
  (doto (ConstraintMapping.)
    (.setConstraint constraint)
    (.setPathSpec path)))