(ns slipway.auth.constraints
  (:import (org.eclipse.jetty.util.security Constraint)))

(defn basic-auth-constraint []
  (doto (Constraint. Constraint/__BASIC_AUTH Constraint/ANY_AUTH) ;; == allow any authenticated user
    (.setName "auth")
    (.setAuthenticate true)))

(defn form-auth-constraint []
  (doto (Constraint. Constraint/__FORM_AUTH Constraint/ANY_AUTH) ;; == allow any authenticated user
    (.setName "auth")
    (.setAuthenticate true)))

(defn no-auth []
  (doto (Constraint.) (.setName "no-auth")))