(ns reveal.style
  (:require [reveal.css :as css]))

;; categories:
;; - util
;; - text (string, character, regex)
;; - error
;; - simple scalar (nil, boolean, number)
;; - meaningful scalar (keyword, symbol)
;; - object (var, ns, function, control stuff, class)

(def dark
  (css/make
    {:palette {:util "#888"
               :string "#22aeaa"
               :error "#f15856"
               :scalar "#649fe9"
               :keyword "#a55cfc"
               :symbol "#aec1d0"
               :object "#f7b940"
               :background "#232325"
               :selection "#005dd1"
               :popup "#3b3b44"}
     :layout {:scroll-bar-size 10}
     :list-view {:cell-height 25}
     ".list-view" {:-fx-background-color :transparent
                   :-fx-fixed-cell-size [:list-view :cell-height]
                   :-fx-background-radius 0
                   ":focused" {:-fx-background-insets 0}}
     ".virtual-flow > .corner" {:-fx-background-color :transparent}
     ".scroll-bar" {:-fx-background-color :transparent
                    " > .thumb" {:-fx-background-color "#eee3"
                                 :-fx-background-insets 0
                                 :-fx-background-radius [:layout :scroll-bar-size]
                                 ":pressed" {:-fx-background-color "#fff6"}}
                    ":horizontal" {" > .increment-button > .increment-arrow" {:-fx-pref-height [:layout :scroll-bar-size]}
                                   " > .decrement-button > .decrement-arrow" {:-fx-pref-height [:layout :scroll-bar-size]}}
                    ":vertical" {" > .increment-button > .increment-arrow" {:-fx-pref-width [:layout :scroll-bar-size]}
                                 " > .decrement-button > .decrement-arrow" {:-fx-pref-width [:layout :scroll-bar-size]}}
                    " > .decrement-button" {:-fx-padding 0
                                            " > .decrement-arrow" {:-fx-shape nil
                                                                   :-fx-padding 0}}
                    " > .increment-button" {:-fx-padding 0
                                            " > .increment-arrow" {:-fx-shape nil
                                                                   :-fx-padding 0}}}
     ".list-cell" {:-fx-background-color :transparent
                   :-fx-text-fill [:palette :symbol]
                   ":selected" {:-fx-background-color [:palette :selection]}}
     ".search-label" {:-fx-text-fill [:palette :popup]
                      :-fx-padding 2
                      :-fx-background-radius 2
                      :-fx-background-color [:palette :object]}}))

#_(println (dark))

(defn url []
  (css/url `dark dark))
